"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.inferAlias = void 0;
const association_service_1 = require("../shared/association-service");
/**
 * Pre conform includes, so that "as" value can be inferred from source
 */
function inferAlias(options, source) {
    options = Object.assign({}, options);
    if (!options.include) {
        return options;
    }
    // if include is not an array, wrap in an array
    if (!Array.isArray(options.include)) {
        options.include = [options.include];
    }
    else if (!options.include.length) {
        delete options.include;
        return options;
    }
    // convert all included elements to { model: Model } form
    options.include = options.include.map((include) => {
        include = inferAliasForInclude(include, source);
        return include;
    });
    return options;
}
exports.inferAlias = inferAlias;
/**
 * Pre conform include, so that alias ("as") value can be inferred from source class
 */
function inferAliasForInclude(include, source) {
    const hasModelOptionWithoutAsOption = !!(include.model && !include.as);
    const hasIncludeOptions = !!include.include;
    const isConstructorFn = include instanceof Function;
    if (isConstructorFn || hasModelOptionWithoutAsOption) {
        if (isConstructorFn) {
            include = { model: include };
        }
        const targetPrototype = source.prototype || source;
        const relatedClass = include.model;
        const associations = (0, association_service_1.getAssociationsByRelation)(targetPrototype, relatedClass);
        if (associations.length > 0) {
            if (associations.length > 1) {
                throw new Error(`Alias cannot be inferred: "${source.name}" has multiple ` +
                    `relations with "${include.model.name}"`);
            }
            include.as = associations[0].getAs();
        }
    }
    if (!isConstructorFn && hasIncludeOptions) {
        include = inferAlias(include, include.model);
    }
    return include;
}
//# sourceMappingURL=alias-inference-service.js.map