<?php
    function get_page_number(string $page_url)
    {
        $data = parse_url($page_url);
        parse_str($data['query'], $output);

        return $output['page'] ?? '1';
    }
?>

<?php if($paginator->hasPages()): ?>
    <form
        action="<?php echo e(route('dashboard.user.openai.documents.all', ['id' => $currfolder?->id, 'listOnly' => true])); ?>"
        method="GET"
        x-init
        x-target="lqd-docs-container"
    >
        <input
            type="hidden"
            name="filter"
            :value="$store.documentsFilter.filter"
        >
        <input
            type="hidden"
            name="sort"
            :value="$store.documentsFilter.sort"
        >
        <input
            type="hidden"
            name="sortAscDesc"
            :value="$store.documentsFilter.sortAscDesc"
        >
        <nav class="lqd-pagination flex items-center justify-between pb-6 pt-10">
            <p class="m-0 text-foreground/70">
                <?php echo e(__('Showing')); ?>

                <span><?php echo e($paginator->firstItem()); ?></span>
                <?php echo e(__('to')); ?>

                <span><?php echo e($paginator->lastItem()); ?></span>
                <?php echo e(__('of')); ?>

                <span><?php echo e($paginator->total()); ?></span>
                <?php echo e(__('results')); ?>

            </p>

            <ul class="lqd-pagination-list flex items-center gap-1">
                
                <li
                    class="<?php echo \Illuminate\Support\Arr::toCssClasses([
                        'lqd-pagination-item flex w-7 h-7 items-center justify-center rounded-full',
                        'opacity-50 pointer-events-none' => $paginator->onFirstPage(),
                    ]); ?>"
                    aria-label="<?php echo e(__('Prev')); ?>"
                    <?php if($paginator->onFirstPage()): echo 'disabled'; endif; ?>
                >
                    <?php if(!$paginator->onFirstPage()): ?>
                        <button
                            class="lqd-pagination-link flex h-full w-full items-center justify-center rounded-full transition-all hover:-translate-x-0.5 hover:bg-primary/10"
                            type="submit"
                            value="<?php echo e(get_page_number($paginator->previousPageUrl())); ?>"
                            name="page"
                            @click="$store.documentsFilter.changePage( '<' )"
                        >
                    <?php endif; ?>
                    <?php if (isset($component)) { $__componentOriginal643fe1b47aec0b76658e1a0200b34b2c = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal643fe1b47aec0b76658e1a0200b34b2c = $attributes; } ?>
<?php $component = BladeUI\Icons\Components\Svg::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('tabler-chevron-left'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(BladeUI\Icons\Components\Svg::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'size-5','aria-hidden' => 'true']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal643fe1b47aec0b76658e1a0200b34b2c)): ?>
<?php $attributes = $__attributesOriginal643fe1b47aec0b76658e1a0200b34b2c; ?>
<?php unset($__attributesOriginal643fe1b47aec0b76658e1a0200b34b2c); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal643fe1b47aec0b76658e1a0200b34b2c)): ?>
<?php $component = $__componentOriginal643fe1b47aec0b76658e1a0200b34b2c; ?>
<?php unset($__componentOriginal643fe1b47aec0b76658e1a0200b34b2c); ?>
<?php endif; ?>
                    <?php if(!$paginator->onFirstPage()): ?>
                        </button>
                    <?php endif; ?>
                </li>

                
                <?php $__currentLoopData = $elements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $element): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    
                    <?php if(is_string($element)): ?>
                        <li
                            class="lqd-pagination-item size-7 pointer-events-none flex items-center justify-center rounded-full opacity-50"
                            aria-disabled="true"
                            aria-hidden="true"
                        >
                            <span class="lqd-pagination-link flex h-full w-full items-center justify-center">
                                <?php echo e($element); ?>

                            </span>
                        </li>
                    <?php endif; ?>

                    
                    <?php if(is_array($element)): ?>
                        <?php $__currentLoopData = $element; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page => $url): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li
                                class="<?php echo \Illuminate\Support\Arr::toCssClasses([
                                    'lqd-pagination-item flex size-7 items-center justify-center rounded-full transition-colors [&.active]:bg-primary [&.active]:text-primary-foreground',
                                    'active' => $page == $paginator->currentPage(),
                                    'hover:bg-primary/10' => $page != $paginator->currentPage(),
                                ]); ?>"
                                :class="$store.documentsFilter.page == '<?php echo e(get_page_number($url)); ?>'"
                            >
                                <?php if($page != $paginator->currentPage()): ?>
                                    <button
                                        class="lqd-pagination-link flex h-full w-full items-center justify-center rounded-full"
                                        type="submit"
                                        value="<?php echo e(get_page_number($url)); ?>"
                                        name="page"
                                        @click="$store.documentsFilter.changePage( <?php echo e(get_page_number($url)); ?> )"
                                    >
                                <?php endif; ?>
                                <?php echo e($page); ?>

                                <?php if($page != $paginator->currentPage()): ?>
                                    </button>
                                <?php endif; ?>
                            </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                
                <li
                    class="<?php echo \Illuminate\Support\Arr::toCssClasses([
                        'lqd-pagination-item flex w-7 h-7 items-center justify-center rounded-full',
                        'opacity-50 pointer-events-none' => !$paginator->hasMorePages(),
                    ]); ?>"
                    aria-label="<?php echo e(__('Next')); ?>"
                    <?php if(!$paginator->hasMorePages()): echo 'disabled'; endif; ?>
                >
                    <?php if($paginator->hasMorePages()): ?>
                        <button
                            class="lqd-pagination-link flex h-full w-full items-center justify-center rounded-full transition-all hover:translate-x-0.5 hover:bg-primary/10"
                            type="submit"
                            value="<?php echo e(get_page_number($paginator->nextPageUrl())); ?>"
                            name="page"
                            @click="$store.documentsFilter.changePage( '>' )"
                        >
                    <?php endif; ?>
                    <?php if (isset($component)) { $__componentOriginal643fe1b47aec0b76658e1a0200b34b2c = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal643fe1b47aec0b76658e1a0200b34b2c = $attributes; } ?>
<?php $component = BladeUI\Icons\Components\Svg::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('tabler-chevron-right'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(BladeUI\Icons\Components\Svg::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'size-5','aria-hidden' => 'true']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal643fe1b47aec0b76658e1a0200b34b2c)): ?>
<?php $attributes = $__attributesOriginal643fe1b47aec0b76658e1a0200b34b2c; ?>
<?php unset($__attributesOriginal643fe1b47aec0b76658e1a0200b34b2c); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal643fe1b47aec0b76658e1a0200b34b2c)): ?>
<?php $component = $__componentOriginal643fe1b47aec0b76658e1a0200b34b2c; ?>
<?php unset($__componentOriginal643fe1b47aec0b76658e1a0200b34b2c); ?>
<?php endif; ?>
                    <?php if($paginator->hasMorePages()): ?>
                        </button>
                    <?php endif; ?>
                </li>
            </ul>
        </nav>
    </form>
<?php endif; ?>
<?php /**PATH /home/newproai/public_html/resources/views/vendor/pagination/ajax.blade.php ENDPATH**/ ?>