/// <reference types="node" preserve="true" />
/**
 * This library implements a system for processing human readable text that
 * will be output by console applications.
 *
 * @remarks
 * See the {@link TerminalWritable} documentation for an overview of the major concepts.
 *
 * @packageDocumentation
 */
export { type ICallbackWritableOptions, CallbackWritable } from './CallbackWritable';
export { type IDiscardStdoutTransformOptions, DiscardStdoutTransform } from './DiscardStdoutTransform';
export { TerminalChunkKind, type ITerminalChunk } from './ITerminalChunk';
export { MockWritable } from './MockWritable';
export { type INormalizeNewlinesTextRewriterOptions, NormalizeNewlinesTextRewriter } from './NormalizeNewlinesTextRewriter';
export { DEFAULT_CONSOLE_WIDTH, PrintUtilities } from './PrintUtilities';
export { RemoveColorsTextRewriter } from './RemoveColorsTextRewriter';
export { type ISplitterTransformOptions, SplitterTransform } from './SplitterTransform';
export { type IStdioLineTransformOptions, StderrLineTransform } from './StdioLineTransform';
export { type IStdioSummarizerOptions, StdioSummarizer } from './StdioSummarizer';
export { StdioWritable } from './StdioWritable';
export { type ITerminalTransformOptions, TerminalTransform } from './TerminalTransform';
export { type ITerminalWritableOptions, TerminalWritable } from './TerminalWritable';
export { type TextRewriterState, TextRewriter } from './TextRewriter';
export { type ITextRewriterTransformOptions, TextRewriterTransform } from './TextRewriterTransform';
export { AnsiEscape, type IAnsiEscapeConvertForTestsOptions } from './AnsiEscape';
export type { ITerminal, TerminalWriteParameters, ITerminalWriteOptions } from './ITerminal';
export { Terminal } from './Terminal';
export { Colorize } from './Colorize';
export { type ITerminalProvider, TerminalProviderSeverity } from './ITerminalProvider';
export { ConsoleTerminalProvider, type IConsoleTerminalProviderOptions } from './ConsoleTerminalProvider';
export { StringBufferTerminalProvider, type IStringBufferOutputOptions } from './StringBufferTerminalProvider';
export { PrefixProxyTerminalProvider, type IPrefixProxyTerminalProviderOptions, type IDynamicPrefixProxyTerminalProviderOptions, type IPrefixProxyTerminalProviderOptionsBase, type IStaticPrefixProxyTerminalProviderOptions } from './PrefixProxyTerminalProvider';
export { NoOpTerminalProvider } from './NoOpTerminalProvider';
export { TerminalStreamWritable, type ITerminalStreamWritableOptions } from './TerminalStreamWritable';
//# sourceMappingURL=index.d.ts.map