<?php
    //Replicating table styles from table component
    $base_class = 'rounded-xl transition-colors';

    $variations = [
        'variant' => [
            'solid' => 'rounded-xl bg-table-background pt-1 group-[&[data-view-mode=grid]]:bg-transparent',
            'outline' => 'rounded-xl border border-table-border pt-1 group-[&[data-view-mode=grid]]:border-0',
            'shadow' => ' rounded-xl shadow-table bg-table-background pt-1 group-[&[data-view-mode=grid]]:shadow-none group-[&[data-view-mode=grid]]:bg-transparent',
            'outline-shadow' => 'rounded-xl border border-table-border pt-1 shadow-table bg-table-background',
            'plain' => '',
        ],
    ];

    $variant =
        isset($variant) && isset($variations['variant'][$variant])
            ? $variations['variant'][$variant]
            : $variations['variant'][Theme::getSetting('defaultVariations.table.variant', 'outline')];

    $class = @twMerge($base_class, $variant);
?>

<div
    class="lqd-docs-container group transition-all [&[aria-busy=true]]:animate-pulse max-lg:[&[data-view-mode=list]]:max-w-full max-lg:[&[data-view-mode=list]]:overflow-x-auto"
    id="lqd-docs-container"
    data-view-mode="list"
    x-bind:data-view-mode="$store.docsViewMode.docsViewMode"
    x-init
    x-merge.transition
>
    
    <script>
        document.querySelector('.lqd-docs-container')?.setAttribute('data-view-mode', localStorage.getItem('docsViewMode')?.replace(/\"/g, '') || 'list');
    </script>

    <div class="<?php echo e($class); ?>">
        <div
            class="lqd-docs-head grid gap-x-4 border-b px-4 py-3 text-4xs font-medium uppercase leading-tight tracking-wider text-foreground/50 [grid-template-columns:3fr_repeat(2,minmax(0,1fr))_100px_1fr] group-[&[data-view-mode=grid]]:hidden">
            <span>
                <?php echo e(__('Name')); ?>

            </span>

            <span>
                <?php echo e(__('Type')); ?>

            </span>

            <span>
                <?php echo e(__('Date')); ?>

            </span>

            <span>
                <?php echo e(__('Cost')); ?>

            </span>

            <span class="text-end">
                <?php echo e(__('Actions')); ?>

            </span>
        </div>

        <?php echo $__env->make('panel.user.openai.documents_list', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </div>

    <?php echo e($items->links('pagination::ajax', ['currfolder' => $currfolder])); ?>

</div>
<?php /**PATH /home/newproai/public_html/resources/views/default/panel/user/openai/documents_container.blade.php ENDPATH**/ ?>