import { Sequelize as OriginSequelize } from 'sequelize';
import { ModelMatch, SequelizeOptions } from './sequelize-options';
import { Model, ModelCtor, ModelType } from '../../model/model/model';
import { Repository } from '../..';
export declare class Sequelize extends OriginSequelize {
    options: SequelizeOptions;
    repositoryMode: boolean;
    constructor(database: string, username: string, password?: string, options?: SequelizeOptions);
    constructor(database: string, username: string, options?: SequelizeOptions);
    constructor(options?: SequelizeOptions);
    constructor(uri: string, options?: SequelizeOptions);
    model<TCreationAttributes extends {}, TModelAttributes extends {}>(model: string | ModelType<TCreationAttributes, TModelAttributes>): ModelCtor;
    addModels(models: ModelCtor[]): void;
    addModels(modelPaths: string[]): void;
    addModels(modelPaths: string[], modelMatch?: ModelMatch): void;
    addModels(arg: (ModelCtor | string)[]): void;
    getRepository<M extends Model>(modelClass: new () => M): Repository<M>;
    private associateModels;
    private defineModels;
    private createRepositoryModel;
}
