"use strict";
var MockServiceWorker = (() => {
  var __defProp = Object.defineProperty;
  var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
  var __getOwnPropNames = Object.getOwnPropertyNames;
  var __hasOwnProp = Object.prototype.hasOwnProperty;
  var __require = /* @__PURE__ */ ((x) => typeof require !== "undefined" ? require : typeof Proxy !== "undefined" ? new Proxy(x, {
    get: (a, b) => (typeof require !== "undefined" ? require : a)[b]
  }) : x)(function(x) {
    if (typeof require !== "undefined") return require.apply(this, arguments);
    throw Error('Dynamic require of "' + x + '" is not supported');
  });
  var __esm = (fn, res) => function __init() {
    return fn && (res = (0, fn[__getOwnPropNames(fn)[0]])(fn = 0)), res;
  };
  var __export = (target, all) => {
    for (var name in all)
      __defProp(target, name, { get: all[name], enumerable: true });
  };
  var __copyProps = (to, from, except, desc) => {
    if (from && typeof from === "object" || typeof from === "function") {
      for (let key of __getOwnPropNames(from))
        if (!__hasOwnProp.call(to, key) && key !== except)
          __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
    }
    return to;
  };
  var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/version.mjs
  var version, versionInfo;
  var init_version = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/version.mjs"() {
      "use strict";
      version = "16.8.2";
      versionInfo = Object.freeze({
        major: 16,
        minor: 8,
        patch: 2,
        preReleaseTag: null
      });
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/jsutils/devAssert.mjs
  function devAssert(condition, message3) {
    const booleanCondition = Boolean(condition);
    if (!booleanCondition) {
      throw new Error(message3);
    }
  }
  var init_devAssert = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/jsutils/devAssert.mjs"() {
      "use strict";
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/jsutils/isPromise.mjs
  function isPromise(value) {
    return typeof (value === null || value === void 0 ? void 0 : value.then) === "function";
  }
  var init_isPromise = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/jsutils/isPromise.mjs"() {
      "use strict";
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/jsutils/isObjectLike.mjs
  function isObjectLike(value) {
    return typeof value == "object" && value !== null;
  }
  var init_isObjectLike = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/jsutils/isObjectLike.mjs"() {
      "use strict";
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/jsutils/invariant.mjs
  function invariant2(condition, message3) {
    const booleanCondition = Boolean(condition);
    if (!booleanCondition) {
      throw new Error(
        message3 != null ? message3 : "Unexpected invariant triggered."
      );
    }
  }
  var init_invariant = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/jsutils/invariant.mjs"() {
      "use strict";
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/language/location.mjs
  function getLocation(source, position) {
    let lastLineStart = 0;
    let line = 1;
    for (const match2 of source.body.matchAll(LineRegExp)) {
      typeof match2.index === "number" || invariant2(false);
      if (match2.index >= position) {
        break;
      }
      lastLineStart = match2.index + match2[0].length;
      line += 1;
    }
    return {
      line,
      column: position + 1 - lastLineStart
    };
  }
  var LineRegExp;
  var init_location = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/language/location.mjs"() {
      "use strict";
      init_invariant();
      LineRegExp = /\r\n|[\n\r]/g;
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/language/printLocation.mjs
  function printLocation(location2) {
    return printSourceLocation(
      location2.source,
      getLocation(location2.source, location2.start)
    );
  }
  function printSourceLocation(source, sourceLocation) {
    const firstLineColumnOffset = source.locationOffset.column - 1;
    const body = "".padStart(firstLineColumnOffset) + source.body;
    const lineIndex = sourceLocation.line - 1;
    const lineOffset = source.locationOffset.line - 1;
    const lineNum = sourceLocation.line + lineOffset;
    const columnOffset = sourceLocation.line === 1 ? firstLineColumnOffset : 0;
    const columnNum = sourceLocation.column + columnOffset;
    const locationStr = `${source.name}:${lineNum}:${columnNum}
`;
    const lines = body.split(/\r\n|[\n\r]/g);
    const locationLine = lines[lineIndex];
    if (locationLine.length > 120) {
      const subLineIndex = Math.floor(columnNum / 80);
      const subLineColumnNum = columnNum % 80;
      const subLines = [];
      for (let i = 0; i < locationLine.length; i += 80) {
        subLines.push(locationLine.slice(i, i + 80));
      }
      return locationStr + printPrefixedLines([
        [`${lineNum} |`, subLines[0]],
        ...subLines.slice(1, subLineIndex + 1).map((subLine) => ["|", subLine]),
        ["|", "^".padStart(subLineColumnNum)],
        ["|", subLines[subLineIndex + 1]]
      ]);
    }
    return locationStr + printPrefixedLines([
      // Lines specified like this: ["prefix", "string"],
      [`${lineNum - 1} |`, lines[lineIndex - 1]],
      [`${lineNum} |`, locationLine],
      ["|", "^".padStart(columnNum)],
      [`${lineNum + 1} |`, lines[lineIndex + 1]]
    ]);
  }
  function printPrefixedLines(lines) {
    const existingLines = lines.filter(([_, line]) => line !== void 0);
    const padLen = Math.max(...existingLines.map(([prefix]) => prefix.length));
    return existingLines.map(([prefix, line]) => prefix.padStart(padLen) + (line ? " " + line : "")).join("\n");
  }
  var init_printLocation = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/language/printLocation.mjs"() {
      "use strict";
      init_location();
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/error/GraphQLError.mjs
  function toNormalizedOptions(args) {
    const firstArg = args[0];
    if (firstArg == null || "kind" in firstArg || "length" in firstArg) {
      return {
        nodes: firstArg,
        source: args[1],
        positions: args[2],
        path: args[3],
        originalError: args[4],
        extensions: args[5]
      };
    }
    return firstArg;
  }
  function undefinedIfEmpty(array) {
    return array === void 0 || array.length === 0 ? void 0 : array;
  }
  function printError(error3) {
    return error3.toString();
  }
  function formatError(error3) {
    return error3.toJSON();
  }
  var GraphQLError;
  var init_GraphQLError = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/error/GraphQLError.mjs"() {
      "use strict";
      init_isObjectLike();
      init_location();
      init_printLocation();
      GraphQLError = class _GraphQLError extends Error {
        /**
         * An array of `{ line, column }` locations within the source GraphQL document
         * which correspond to this error.
         *
         * Errors during validation often contain multiple locations, for example to
         * point out two things with the same name. Errors during execution include a
         * single location, the field which produced the error.
         *
         * Enumerable, and appears in the result of JSON.stringify().
         */
        /**
         * An array describing the JSON-path into the execution response which
         * corresponds to this error. Only included for errors during execution.
         *
         * Enumerable, and appears in the result of JSON.stringify().
         */
        /**
         * An array of GraphQL AST Nodes corresponding to this error.
         */
        /**
         * The source GraphQL document for the first location of this error.
         *
         * Note that if this Error represents more than one node, the source may not
         * represent nodes after the first node.
         */
        /**
         * An array of character offsets within the source GraphQL document
         * which correspond to this error.
         */
        /**
         * The original error thrown from a field resolver during execution.
         */
        /**
         * Extension fields to add to the formatted error.
         */
        /**
         * @deprecated Please use the `GraphQLErrorOptions` constructor overload instead.
         */
        constructor(message3, ...rawArgs) {
          var _this$nodes, _nodeLocations$, _ref;
          const { nodes, source, positions, path, originalError, extensions } = toNormalizedOptions(rawArgs);
          super(message3);
          this.name = "GraphQLError";
          this.path = path !== null && path !== void 0 ? path : void 0;
          this.originalError = originalError !== null && originalError !== void 0 ? originalError : void 0;
          this.nodes = undefinedIfEmpty(
            Array.isArray(nodes) ? nodes : nodes ? [nodes] : void 0
          );
          const nodeLocations = undefinedIfEmpty(
            (_this$nodes = this.nodes) === null || _this$nodes === void 0 ? void 0 : _this$nodes.map((node) => node.loc).filter((loc) => loc != null)
          );
          this.source = source !== null && source !== void 0 ? source : nodeLocations === null || nodeLocations === void 0 ? void 0 : (_nodeLocations$ = nodeLocations[0]) === null || _nodeLocations$ === void 0 ? void 0 : _nodeLocations$.source;
          this.positions = positions !== null && positions !== void 0 ? positions : nodeLocations === null || nodeLocations === void 0 ? void 0 : nodeLocations.map((loc) => loc.start);
          this.locations = positions && source ? positions.map((pos) => getLocation(source, pos)) : nodeLocations === null || nodeLocations === void 0 ? void 0 : nodeLocations.map((loc) => getLocation(loc.source, loc.start));
          const originalExtensions = isObjectLike(
            originalError === null || originalError === void 0 ? void 0 : originalError.extensions
          ) ? originalError === null || originalError === void 0 ? void 0 : originalError.extensions : void 0;
          this.extensions = (_ref = extensions !== null && extensions !== void 0 ? extensions : originalExtensions) !== null && _ref !== void 0 ? _ref : /* @__PURE__ */ Object.create(null);
          Object.defineProperties(this, {
            message: {
              writable: true,
              enumerable: true
            },
            name: {
              enumerable: false
            },
            nodes: {
              enumerable: false
            },
            source: {
              enumerable: false
            },
            positions: {
              enumerable: false
            },
            originalError: {
              enumerable: false
            }
          });
          if (originalError !== null && originalError !== void 0 && originalError.stack) {
            Object.defineProperty(this, "stack", {
              value: originalError.stack,
              writable: true,
              configurable: true
            });
          } else if (Error.captureStackTrace) {
            Error.captureStackTrace(this, _GraphQLError);
          } else {
            Object.defineProperty(this, "stack", {
              value: Error().stack,
              writable: true,
              configurable: true
            });
          }
        }
        get [Symbol.toStringTag]() {
          return "GraphQLError";
        }
        toString() {
          let output = this.message;
          if (this.nodes) {
            for (const node of this.nodes) {
              if (node.loc) {
                output += "\n\n" + printLocation(node.loc);
              }
            }
          } else if (this.source && this.locations) {
            for (const location2 of this.locations) {
              output += "\n\n" + printSourceLocation(this.source, location2);
            }
          }
          return output;
        }
        toJSON() {
          const formattedError = {
            message: this.message
          };
          if (this.locations != null) {
            formattedError.locations = this.locations;
          }
          if (this.path != null) {
            formattedError.path = this.path;
          }
          if (this.extensions != null && Object.keys(this.extensions).length > 0) {
            formattedError.extensions = this.extensions;
          }
          return formattedError;
        }
      };
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/error/syntaxError.mjs
  function syntaxError(source, position, description) {
    return new GraphQLError(`Syntax Error: ${description}`, {
      source,
      positions: [position]
    });
  }
  var init_syntaxError = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/error/syntaxError.mjs"() {
      "use strict";
      init_GraphQLError();
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/language/ast.mjs
  function isNode(maybeNode) {
    const maybeKind = maybeNode === null || maybeNode === void 0 ? void 0 : maybeNode.kind;
    return typeof maybeKind === "string" && kindValues.has(maybeKind);
  }
  var Location, Token, QueryDocumentKeys, kindValues, OperationTypeNode;
  var init_ast = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/language/ast.mjs"() {
      "use strict";
      Location = class {
        /**
         * The character offset at which this Node begins.
         */
        /**
         * The character offset at which this Node ends.
         */
        /**
         * The Token at which this Node begins.
         */
        /**
         * The Token at which this Node ends.
         */
        /**
         * The Source document the AST represents.
         */
        constructor(startToken, endToken, source) {
          this.start = startToken.start;
          this.end = endToken.end;
          this.startToken = startToken;
          this.endToken = endToken;
          this.source = source;
        }
        get [Symbol.toStringTag]() {
          return "Location";
        }
        toJSON() {
          return {
            start: this.start,
            end: this.end
          };
        }
      };
      Token = class {
        /**
         * The kind of Token.
         */
        /**
         * The character offset at which this Node begins.
         */
        /**
         * The character offset at which this Node ends.
         */
        /**
         * The 1-indexed line number on which this Token appears.
         */
        /**
         * The 1-indexed column number at which this Token begins.
         */
        /**
         * For non-punctuation tokens, represents the interpreted value of the token.
         *
         * Note: is undefined for punctuation tokens, but typed as string for
         * convenience in the parser.
         */
        /**
         * Tokens exist as nodes in a double-linked-list amongst all tokens
         * including ignored tokens. <SOF> is always the first node and <EOF>
         * the last.
         */
        constructor(kind, start, end, line, column, value) {
          this.kind = kind;
          this.start = start;
          this.end = end;
          this.line = line;
          this.column = column;
          this.value = value;
          this.prev = null;
          this.next = null;
        }
        get [Symbol.toStringTag]() {
          return "Token";
        }
        toJSON() {
          return {
            kind: this.kind,
            value: this.value,
            line: this.line,
            column: this.column
          };
        }
      };
      QueryDocumentKeys = {
        Name: [],
        Document: ["definitions"],
        OperationDefinition: [
          "name",
          "variableDefinitions",
          "directives",
          "selectionSet"
        ],
        VariableDefinition: ["variable", "type", "defaultValue", "directives"],
        Variable: ["name"],
        SelectionSet: ["selections"],
        Field: ["alias", "name", "arguments", "directives", "selectionSet"],
        Argument: ["name", "value"],
        FragmentSpread: ["name", "directives"],
        InlineFragment: ["typeCondition", "directives", "selectionSet"],
        FragmentDefinition: [
          "name",
          // Note: fragment variable definitions are deprecated and will removed in v17.0.0
          "variableDefinitions",
          "typeCondition",
          "directives",
          "selectionSet"
        ],
        IntValue: [],
        FloatValue: [],
        StringValue: [],
        BooleanValue: [],
        NullValue: [],
        EnumValue: [],
        ListValue: ["values"],
        ObjectValue: ["fields"],
        ObjectField: ["name", "value"],
        Directive: ["name", "arguments"],
        NamedType: ["name"],
        ListType: ["type"],
        NonNullType: ["type"],
        SchemaDefinition: ["description", "directives", "operationTypes"],
        OperationTypeDefinition: ["type"],
        ScalarTypeDefinition: ["description", "name", "directives"],
        ObjectTypeDefinition: [
          "description",
          "name",
          "interfaces",
          "directives",
          "fields"
        ],
        FieldDefinition: ["description", "name", "arguments", "type", "directives"],
        InputValueDefinition: [
          "description",
          "name",
          "type",
          "defaultValue",
          "directives"
        ],
        InterfaceTypeDefinition: [
          "description",
          "name",
          "interfaces",
          "directives",
          "fields"
        ],
        UnionTypeDefinition: ["description", "name", "directives", "types"],
        EnumTypeDefinition: ["description", "name", "directives", "values"],
        EnumValueDefinition: ["description", "name", "directives"],
        InputObjectTypeDefinition: ["description", "name", "directives", "fields"],
        DirectiveDefinition: ["description", "name", "arguments", "locations"],
        SchemaExtension: ["directives", "operationTypes"],
        ScalarTypeExtension: ["name", "directives"],
        ObjectTypeExtension: ["name", "interfaces", "directives", "fields"],
        InterfaceTypeExtension: ["name", "interfaces", "directives", "fields"],
        UnionTypeExtension: ["name", "directives", "types"],
        EnumTypeExtension: ["name", "directives", "values"],
        InputObjectTypeExtension: ["name", "directives", "fields"]
      };
      kindValues = new Set(Object.keys(QueryDocumentKeys));
      (function(OperationTypeNode2) {
        OperationTypeNode2["QUERY"] = "query";
        OperationTypeNode2["MUTATION"] = "mutation";
        OperationTypeNode2["SUBSCRIPTION"] = "subscription";
      })(OperationTypeNode || (OperationTypeNode = {}));
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/language/directiveLocation.mjs
  var DirectiveLocation;
  var init_directiveLocation = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/language/directiveLocation.mjs"() {
      "use strict";
      (function(DirectiveLocation2) {
        DirectiveLocation2["QUERY"] = "QUERY";
        DirectiveLocation2["MUTATION"] = "MUTATION";
        DirectiveLocation2["SUBSCRIPTION"] = "SUBSCRIPTION";
        DirectiveLocation2["FIELD"] = "FIELD";
        DirectiveLocation2["FRAGMENT_DEFINITION"] = "FRAGMENT_DEFINITION";
        DirectiveLocation2["FRAGMENT_SPREAD"] = "FRAGMENT_SPREAD";
        DirectiveLocation2["INLINE_FRAGMENT"] = "INLINE_FRAGMENT";
        DirectiveLocation2["VARIABLE_DEFINITION"] = "VARIABLE_DEFINITION";
        DirectiveLocation2["SCHEMA"] = "SCHEMA";
        DirectiveLocation2["SCALAR"] = "SCALAR";
        DirectiveLocation2["OBJECT"] = "OBJECT";
        DirectiveLocation2["FIELD_DEFINITION"] = "FIELD_DEFINITION";
        DirectiveLocation2["ARGUMENT_DEFINITION"] = "ARGUMENT_DEFINITION";
        DirectiveLocation2["INTERFACE"] = "INTERFACE";
        DirectiveLocation2["UNION"] = "UNION";
        DirectiveLocation2["ENUM"] = "ENUM";
        DirectiveLocation2["ENUM_VALUE"] = "ENUM_VALUE";
        DirectiveLocation2["INPUT_OBJECT"] = "INPUT_OBJECT";
        DirectiveLocation2["INPUT_FIELD_DEFINITION"] = "INPUT_FIELD_DEFINITION";
      })(DirectiveLocation || (DirectiveLocation = {}));
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/language/kinds.mjs
  var Kind;
  var init_kinds = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/language/kinds.mjs"() {
      "use strict";
      (function(Kind2) {
        Kind2["NAME"] = "Name";
        Kind2["DOCUMENT"] = "Document";
        Kind2["OPERATION_DEFINITION"] = "OperationDefinition";
        Kind2["VARIABLE_DEFINITION"] = "VariableDefinition";
        Kind2["SELECTION_SET"] = "SelectionSet";
        Kind2["FIELD"] = "Field";
        Kind2["ARGUMENT"] = "Argument";
        Kind2["FRAGMENT_SPREAD"] = "FragmentSpread";
        Kind2["INLINE_FRAGMENT"] = "InlineFragment";
        Kind2["FRAGMENT_DEFINITION"] = "FragmentDefinition";
        Kind2["VARIABLE"] = "Variable";
        Kind2["INT"] = "IntValue";
        Kind2["FLOAT"] = "FloatValue";
        Kind2["STRING"] = "StringValue";
        Kind2["BOOLEAN"] = "BooleanValue";
        Kind2["NULL"] = "NullValue";
        Kind2["ENUM"] = "EnumValue";
        Kind2["LIST"] = "ListValue";
        Kind2["OBJECT"] = "ObjectValue";
        Kind2["OBJECT_FIELD"] = "ObjectField";
        Kind2["DIRECTIVE"] = "Directive";
        Kind2["NAMED_TYPE"] = "NamedType";
        Kind2["LIST_TYPE"] = "ListType";
        Kind2["NON_NULL_TYPE"] = "NonNullType";
        Kind2["SCHEMA_DEFINITION"] = "SchemaDefinition";
        Kind2["OPERATION_TYPE_DEFINITION"] = "OperationTypeDefinition";
        Kind2["SCALAR_TYPE_DEFINITION"] = "ScalarTypeDefinition";
        Kind2["OBJECT_TYPE_DEFINITION"] = "ObjectTypeDefinition";
        Kind2["FIELD_DEFINITION"] = "FieldDefinition";
        Kind2["INPUT_VALUE_DEFINITION"] = "InputValueDefinition";
        Kind2["INTERFACE_TYPE_DEFINITION"] = "InterfaceTypeDefinition";
        Kind2["UNION_TYPE_DEFINITION"] = "UnionTypeDefinition";
        Kind2["ENUM_TYPE_DEFINITION"] = "EnumTypeDefinition";
        Kind2["ENUM_VALUE_DEFINITION"] = "EnumValueDefinition";
        Kind2["INPUT_OBJECT_TYPE_DEFINITION"] = "InputObjectTypeDefinition";
        Kind2["DIRECTIVE_DEFINITION"] = "DirectiveDefinition";
        Kind2["SCHEMA_EXTENSION"] = "SchemaExtension";
        Kind2["SCALAR_TYPE_EXTENSION"] = "ScalarTypeExtension";
        Kind2["OBJECT_TYPE_EXTENSION"] = "ObjectTypeExtension";
        Kind2["INTERFACE_TYPE_EXTENSION"] = "InterfaceTypeExtension";
        Kind2["UNION_TYPE_EXTENSION"] = "UnionTypeExtension";
        Kind2["ENUM_TYPE_EXTENSION"] = "EnumTypeExtension";
        Kind2["INPUT_OBJECT_TYPE_EXTENSION"] = "InputObjectTypeExtension";
      })(Kind || (Kind = {}));
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/language/characterClasses.mjs
  function isWhiteSpace(code) {
    return code === 9 || code === 32;
  }
  function isDigit(code) {
    return code >= 48 && code <= 57;
  }
  function isLetter(code) {
    return code >= 97 && code <= 122 || // A-Z
    code >= 65 && code <= 90;
  }
  function isNameStart(code) {
    return isLetter(code) || code === 95;
  }
  function isNameContinue(code) {
    return isLetter(code) || isDigit(code) || code === 95;
  }
  var init_characterClasses = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/language/characterClasses.mjs"() {
      "use strict";
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/language/blockString.mjs
  function dedentBlockStringLines(lines) {
    var _firstNonEmptyLine2;
    let commonIndent = Number.MAX_SAFE_INTEGER;
    let firstNonEmptyLine = null;
    let lastNonEmptyLine = -1;
    for (let i = 0; i < lines.length; ++i) {
      var _firstNonEmptyLine;
      const line = lines[i];
      const indent2 = leadingWhitespace(line);
      if (indent2 === line.length) {
        continue;
      }
      firstNonEmptyLine = (_firstNonEmptyLine = firstNonEmptyLine) !== null && _firstNonEmptyLine !== void 0 ? _firstNonEmptyLine : i;
      lastNonEmptyLine = i;
      if (i !== 0 && indent2 < commonIndent) {
        commonIndent = indent2;
      }
    }
    return lines.map((line, i) => i === 0 ? line : line.slice(commonIndent)).slice(
      (_firstNonEmptyLine2 = firstNonEmptyLine) !== null && _firstNonEmptyLine2 !== void 0 ? _firstNonEmptyLine2 : 0,
      lastNonEmptyLine + 1
    );
  }
  function leadingWhitespace(str) {
    let i = 0;
    while (i < str.length && isWhiteSpace(str.charCodeAt(i))) {
      ++i;
    }
    return i;
  }
  function isPrintableAsBlockString(value) {
    if (value === "") {
      return true;
    }
    let isEmptyLine = true;
    let hasIndent = false;
    let hasCommonIndent = true;
    let seenNonEmptyLine = false;
    for (let i = 0; i < value.length; ++i) {
      switch (value.codePointAt(i)) {
        case 0:
        case 1:
        case 2:
        case 3:
        case 4:
        case 5:
        case 6:
        case 7:
        case 8:
        case 11:
        case 12:
        case 14:
        case 15:
          return false;
        // Has non-printable characters
        case 13:
          return false;
        // Has \r or \r\n which will be replaced as \n
        case 10:
          if (isEmptyLine && !seenNonEmptyLine) {
            return false;
          }
          seenNonEmptyLine = true;
          isEmptyLine = true;
          hasIndent = false;
          break;
        case 9:
        //   \t
        case 32:
          hasIndent || (hasIndent = isEmptyLine);
          break;
        default:
          hasCommonIndent && (hasCommonIndent = hasIndent);
          isEmptyLine = false;
      }
    }
    if (isEmptyLine) {
      return false;
    }
    if (hasCommonIndent && seenNonEmptyLine) {
      return false;
    }
    return true;
  }
  function printBlockString(value, options) {
    const escapedValue = value.replace(/"""/g, '\\"""');
    const lines = escapedValue.split(/\r\n|[\n\r]/g);
    const isSingleLine = lines.length === 1;
    const forceLeadingNewLine = lines.length > 1 && lines.slice(1).every((line) => line.length === 0 || isWhiteSpace(line.charCodeAt(0)));
    const hasTrailingTripleQuotes = escapedValue.endsWith('\\"""');
    const hasTrailingQuote = value.endsWith('"') && !hasTrailingTripleQuotes;
    const hasTrailingSlash = value.endsWith("\\");
    const forceTrailingNewline = hasTrailingQuote || hasTrailingSlash;
    const printAsMultipleLines = !(options !== null && options !== void 0 && options.minimize) && // add leading and trailing new lines only if it improves readability
    (!isSingleLine || value.length > 70 || forceTrailingNewline || forceLeadingNewLine || hasTrailingTripleQuotes);
    let result = "";
    const skipLeadingNewLine = isSingleLine && isWhiteSpace(value.charCodeAt(0));
    if (printAsMultipleLines && !skipLeadingNewLine || forceLeadingNewLine) {
      result += "\n";
    }
    result += escapedValue;
    if (printAsMultipleLines || forceTrailingNewline) {
      result += "\n";
    }
    return '"""' + result + '"""';
  }
  var init_blockString = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/language/blockString.mjs"() {
      "use strict";
      init_characterClasses();
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/language/tokenKind.mjs
  var TokenKind;
  var init_tokenKind = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/language/tokenKind.mjs"() {
      "use strict";
      (function(TokenKind2) {
        TokenKind2["SOF"] = "<SOF>";
        TokenKind2["EOF"] = "<EOF>";
        TokenKind2["BANG"] = "!";
        TokenKind2["DOLLAR"] = "$";
        TokenKind2["AMP"] = "&";
        TokenKind2["PAREN_L"] = "(";
        TokenKind2["PAREN_R"] = ")";
        TokenKind2["SPREAD"] = "...";
        TokenKind2["COLON"] = ":";
        TokenKind2["EQUALS"] = "=";
        TokenKind2["AT"] = "@";
        TokenKind2["BRACKET_L"] = "[";
        TokenKind2["BRACKET_R"] = "]";
        TokenKind2["BRACE_L"] = "{";
        TokenKind2["PIPE"] = "|";
        TokenKind2["BRACE_R"] = "}";
        TokenKind2["NAME"] = "Name";
        TokenKind2["INT"] = "Int";
        TokenKind2["FLOAT"] = "Float";
        TokenKind2["STRING"] = "String";
        TokenKind2["BLOCK_STRING"] = "BlockString";
        TokenKind2["COMMENT"] = "Comment";
      })(TokenKind || (TokenKind = {}));
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/language/lexer.mjs
  function isPunctuatorTokenKind(kind) {
    return kind === TokenKind.BANG || kind === TokenKind.DOLLAR || kind === TokenKind.AMP || kind === TokenKind.PAREN_L || kind === TokenKind.PAREN_R || kind === TokenKind.SPREAD || kind === TokenKind.COLON || kind === TokenKind.EQUALS || kind === TokenKind.AT || kind === TokenKind.BRACKET_L || kind === TokenKind.BRACKET_R || kind === TokenKind.BRACE_L || kind === TokenKind.PIPE || kind === TokenKind.BRACE_R;
  }
  function isUnicodeScalarValue(code) {
    return code >= 0 && code <= 55295 || code >= 57344 && code <= 1114111;
  }
  function isSupplementaryCodePoint(body, location2) {
    return isLeadingSurrogate(body.charCodeAt(location2)) && isTrailingSurrogate(body.charCodeAt(location2 + 1));
  }
  function isLeadingSurrogate(code) {
    return code >= 55296 && code <= 56319;
  }
  function isTrailingSurrogate(code) {
    return code >= 56320 && code <= 57343;
  }
  function printCodePointAt(lexer2, location2) {
    const code = lexer2.source.body.codePointAt(location2);
    if (code === void 0) {
      return TokenKind.EOF;
    } else if (code >= 32 && code <= 126) {
      const char = String.fromCodePoint(code);
      return char === '"' ? `'"'` : `"${char}"`;
    }
    return "U+" + code.toString(16).toUpperCase().padStart(4, "0");
  }
  function createToken(lexer2, kind, start, end, value) {
    const line = lexer2.line;
    const col = 1 + start - lexer2.lineStart;
    return new Token(kind, start, end, line, col, value);
  }
  function readNextToken(lexer2, start) {
    const body = lexer2.source.body;
    const bodyLength = body.length;
    let position = start;
    while (position < bodyLength) {
      const code = body.charCodeAt(position);
      switch (code) {
        // Ignored ::
        //   - UnicodeBOM
        //   - WhiteSpace
        //   - LineTerminator
        //   - Comment
        //   - Comma
        //
        // UnicodeBOM :: "Byte Order Mark (U+FEFF)"
        //
        // WhiteSpace ::
        //   - "Horizontal Tab (U+0009)"
        //   - "Space (U+0020)"
        //
        // Comma :: ,
        case 65279:
        // <BOM>
        case 9:
        // \t
        case 32:
        // <space>
        case 44:
          ++position;
          continue;
        // LineTerminator ::
        //   - "New Line (U+000A)"
        //   - "Carriage Return (U+000D)" [lookahead != "New Line (U+000A)"]
        //   - "Carriage Return (U+000D)" "New Line (U+000A)"
        case 10:
          ++position;
          ++lexer2.line;
          lexer2.lineStart = position;
          continue;
        case 13:
          if (body.charCodeAt(position + 1) === 10) {
            position += 2;
          } else {
            ++position;
          }
          ++lexer2.line;
          lexer2.lineStart = position;
          continue;
        // Comment
        case 35:
          return readComment(lexer2, position);
        // Token ::
        //   - Punctuator
        //   - Name
        //   - IntValue
        //   - FloatValue
        //   - StringValue
        //
        // Punctuator :: one of ! $ & ( ) ... : = @ [ ] { | }
        case 33:
          return createToken(lexer2, TokenKind.BANG, position, position + 1);
        case 36:
          return createToken(lexer2, TokenKind.DOLLAR, position, position + 1);
        case 38:
          return createToken(lexer2, TokenKind.AMP, position, position + 1);
        case 40:
          return createToken(lexer2, TokenKind.PAREN_L, position, position + 1);
        case 41:
          return createToken(lexer2, TokenKind.PAREN_R, position, position + 1);
        case 46:
          if (body.charCodeAt(position + 1) === 46 && body.charCodeAt(position + 2) === 46) {
            return createToken(lexer2, TokenKind.SPREAD, position, position + 3);
          }
          break;
        case 58:
          return createToken(lexer2, TokenKind.COLON, position, position + 1);
        case 61:
          return createToken(lexer2, TokenKind.EQUALS, position, position + 1);
        case 64:
          return createToken(lexer2, TokenKind.AT, position, position + 1);
        case 91:
          return createToken(lexer2, TokenKind.BRACKET_L, position, position + 1);
        case 93:
          return createToken(lexer2, TokenKind.BRACKET_R, position, position + 1);
        case 123:
          return createToken(lexer2, TokenKind.BRACE_L, position, position + 1);
        case 124:
          return createToken(lexer2, TokenKind.PIPE, position, position + 1);
        case 125:
          return createToken(lexer2, TokenKind.BRACE_R, position, position + 1);
        // StringValue
        case 34:
          if (body.charCodeAt(position + 1) === 34 && body.charCodeAt(position + 2) === 34) {
            return readBlockString(lexer2, position);
          }
          return readString(lexer2, position);
      }
      if (isDigit(code) || code === 45) {
        return readNumber(lexer2, position, code);
      }
      if (isNameStart(code)) {
        return readName(lexer2, position);
      }
      throw syntaxError(
        lexer2.source,
        position,
        code === 39 ? `Unexpected single quote character ('), did you mean to use a double quote (")?` : isUnicodeScalarValue(code) || isSupplementaryCodePoint(body, position) ? `Unexpected character: ${printCodePointAt(lexer2, position)}.` : `Invalid character: ${printCodePointAt(lexer2, position)}.`
      );
    }
    return createToken(lexer2, TokenKind.EOF, bodyLength, bodyLength);
  }
  function readComment(lexer2, start) {
    const body = lexer2.source.body;
    const bodyLength = body.length;
    let position = start + 1;
    while (position < bodyLength) {
      const code = body.charCodeAt(position);
      if (code === 10 || code === 13) {
        break;
      }
      if (isUnicodeScalarValue(code)) {
        ++position;
      } else if (isSupplementaryCodePoint(body, position)) {
        position += 2;
      } else {
        break;
      }
    }
    return createToken(
      lexer2,
      TokenKind.COMMENT,
      start,
      position,
      body.slice(start + 1, position)
    );
  }
  function readNumber(lexer2, start, firstCode) {
    const body = lexer2.source.body;
    let position = start;
    let code = firstCode;
    let isFloat = false;
    if (code === 45) {
      code = body.charCodeAt(++position);
    }
    if (code === 48) {
      code = body.charCodeAt(++position);
      if (isDigit(code)) {
        throw syntaxError(
          lexer2.source,
          position,
          `Invalid number, unexpected digit after 0: ${printCodePointAt(
            lexer2,
            position
          )}.`
        );
      }
    } else {
      position = readDigits(lexer2, position, code);
      code = body.charCodeAt(position);
    }
    if (code === 46) {
      isFloat = true;
      code = body.charCodeAt(++position);
      position = readDigits(lexer2, position, code);
      code = body.charCodeAt(position);
    }
    if (code === 69 || code === 101) {
      isFloat = true;
      code = body.charCodeAt(++position);
      if (code === 43 || code === 45) {
        code = body.charCodeAt(++position);
      }
      position = readDigits(lexer2, position, code);
      code = body.charCodeAt(position);
    }
    if (code === 46 || isNameStart(code)) {
      throw syntaxError(
        lexer2.source,
        position,
        `Invalid number, expected digit but got: ${printCodePointAt(
          lexer2,
          position
        )}.`
      );
    }
    return createToken(
      lexer2,
      isFloat ? TokenKind.FLOAT : TokenKind.INT,
      start,
      position,
      body.slice(start, position)
    );
  }
  function readDigits(lexer2, start, firstCode) {
    if (!isDigit(firstCode)) {
      throw syntaxError(
        lexer2.source,
        start,
        `Invalid number, expected digit but got: ${printCodePointAt(
          lexer2,
          start
        )}.`
      );
    }
    const body = lexer2.source.body;
    let position = start + 1;
    while (isDigit(body.charCodeAt(position))) {
      ++position;
    }
    return position;
  }
  function readString(lexer2, start) {
    const body = lexer2.source.body;
    const bodyLength = body.length;
    let position = start + 1;
    let chunkStart = position;
    let value = "";
    while (position < bodyLength) {
      const code = body.charCodeAt(position);
      if (code === 34) {
        value += body.slice(chunkStart, position);
        return createToken(lexer2, TokenKind.STRING, start, position + 1, value);
      }
      if (code === 92) {
        value += body.slice(chunkStart, position);
        const escape = body.charCodeAt(position + 1) === 117 ? body.charCodeAt(position + 2) === 123 ? readEscapedUnicodeVariableWidth(lexer2, position) : readEscapedUnicodeFixedWidth(lexer2, position) : readEscapedCharacter(lexer2, position);
        value += escape.value;
        position += escape.size;
        chunkStart = position;
        continue;
      }
      if (code === 10 || code === 13) {
        break;
      }
      if (isUnicodeScalarValue(code)) {
        ++position;
      } else if (isSupplementaryCodePoint(body, position)) {
        position += 2;
      } else {
        throw syntaxError(
          lexer2.source,
          position,
          `Invalid character within String: ${printCodePointAt(
            lexer2,
            position
          )}.`
        );
      }
    }
    throw syntaxError(lexer2.source, position, "Unterminated string.");
  }
  function readEscapedUnicodeVariableWidth(lexer2, position) {
    const body = lexer2.source.body;
    let point = 0;
    let size = 3;
    while (size < 12) {
      const code = body.charCodeAt(position + size++);
      if (code === 125) {
        if (size < 5 || !isUnicodeScalarValue(point)) {
          break;
        }
        return {
          value: String.fromCodePoint(point),
          size
        };
      }
      point = point << 4 | readHexDigit(code);
      if (point < 0) {
        break;
      }
    }
    throw syntaxError(
      lexer2.source,
      position,
      `Invalid Unicode escape sequence: "${body.slice(
        position,
        position + size
      )}".`
    );
  }
  function readEscapedUnicodeFixedWidth(lexer2, position) {
    const body = lexer2.source.body;
    const code = read16BitHexCode(body, position + 2);
    if (isUnicodeScalarValue(code)) {
      return {
        value: String.fromCodePoint(code),
        size: 6
      };
    }
    if (isLeadingSurrogate(code)) {
      if (body.charCodeAt(position + 6) === 92 && body.charCodeAt(position + 7) === 117) {
        const trailingCode = read16BitHexCode(body, position + 8);
        if (isTrailingSurrogate(trailingCode)) {
          return {
            value: String.fromCodePoint(code, trailingCode),
            size: 12
          };
        }
      }
    }
    throw syntaxError(
      lexer2.source,
      position,
      `Invalid Unicode escape sequence: "${body.slice(position, position + 6)}".`
    );
  }
  function read16BitHexCode(body, position) {
    return readHexDigit(body.charCodeAt(position)) << 12 | readHexDigit(body.charCodeAt(position + 1)) << 8 | readHexDigit(body.charCodeAt(position + 2)) << 4 | readHexDigit(body.charCodeAt(position + 3));
  }
  function readHexDigit(code) {
    return code >= 48 && code <= 57 ? code - 48 : code >= 65 && code <= 70 ? code - 55 : code >= 97 && code <= 102 ? code - 87 : -1;
  }
  function readEscapedCharacter(lexer2, position) {
    const body = lexer2.source.body;
    const code = body.charCodeAt(position + 1);
    switch (code) {
      case 34:
        return {
          value: '"',
          size: 2
        };
      case 92:
        return {
          value: "\\",
          size: 2
        };
      case 47:
        return {
          value: "/",
          size: 2
        };
      case 98:
        return {
          value: "\b",
          size: 2
        };
      case 102:
        return {
          value: "\f",
          size: 2
        };
      case 110:
        return {
          value: "\n",
          size: 2
        };
      case 114:
        return {
          value: "\r",
          size: 2
        };
      case 116:
        return {
          value: "	",
          size: 2
        };
    }
    throw syntaxError(
      lexer2.source,
      position,
      `Invalid character escape sequence: "${body.slice(
        position,
        position + 2
      )}".`
    );
  }
  function readBlockString(lexer2, start) {
    const body = lexer2.source.body;
    const bodyLength = body.length;
    let lineStart = lexer2.lineStart;
    let position = start + 3;
    let chunkStart = position;
    let currentLine = "";
    const blockLines = [];
    while (position < bodyLength) {
      const code = body.charCodeAt(position);
      if (code === 34 && body.charCodeAt(position + 1) === 34 && body.charCodeAt(position + 2) === 34) {
        currentLine += body.slice(chunkStart, position);
        blockLines.push(currentLine);
        const token = createToken(
          lexer2,
          TokenKind.BLOCK_STRING,
          start,
          position + 3,
          // Return a string of the lines joined with U+000A.
          dedentBlockStringLines(blockLines).join("\n")
        );
        lexer2.line += blockLines.length - 1;
        lexer2.lineStart = lineStart;
        return token;
      }
      if (code === 92 && body.charCodeAt(position + 1) === 34 && body.charCodeAt(position + 2) === 34 && body.charCodeAt(position + 3) === 34) {
        currentLine += body.slice(chunkStart, position);
        chunkStart = position + 1;
        position += 4;
        continue;
      }
      if (code === 10 || code === 13) {
        currentLine += body.slice(chunkStart, position);
        blockLines.push(currentLine);
        if (code === 13 && body.charCodeAt(position + 1) === 10) {
          position += 2;
        } else {
          ++position;
        }
        currentLine = "";
        chunkStart = position;
        lineStart = position;
        continue;
      }
      if (isUnicodeScalarValue(code)) {
        ++position;
      } else if (isSupplementaryCodePoint(body, position)) {
        position += 2;
      } else {
        throw syntaxError(
          lexer2.source,
          position,
          `Invalid character within String: ${printCodePointAt(
            lexer2,
            position
          )}.`
        );
      }
    }
    throw syntaxError(lexer2.source, position, "Unterminated string.");
  }
  function readName(lexer2, start) {
    const body = lexer2.source.body;
    const bodyLength = body.length;
    let position = start + 1;
    while (position < bodyLength) {
      const code = body.charCodeAt(position);
      if (isNameContinue(code)) {
        ++position;
      } else {
        break;
      }
    }
    return createToken(
      lexer2,
      TokenKind.NAME,
      start,
      position,
      body.slice(start, position)
    );
  }
  var Lexer;
  var init_lexer = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/language/lexer.mjs"() {
      "use strict";
      init_syntaxError();
      init_ast();
      init_blockString();
      init_characterClasses();
      init_tokenKind();
      Lexer = class {
        /**
         * The previously focused non-ignored token.
         */
        /**
         * The currently focused non-ignored token.
         */
        /**
         * The (1-indexed) line containing the current token.
         */
        /**
         * The character offset at which the current line begins.
         */
        constructor(source) {
          const startOfFileToken = new Token(TokenKind.SOF, 0, 0, 0, 0);
          this.source = source;
          this.lastToken = startOfFileToken;
          this.token = startOfFileToken;
          this.line = 1;
          this.lineStart = 0;
        }
        get [Symbol.toStringTag]() {
          return "Lexer";
        }
        /**
         * Advances the token stream to the next non-ignored token.
         */
        advance() {
          this.lastToken = this.token;
          const token = this.token = this.lookahead();
          return token;
        }
        /**
         * Looks ahead and returns the next non-ignored token, but does not change
         * the state of Lexer.
         */
        lookahead() {
          let token = this.token;
          if (token.kind !== TokenKind.EOF) {
            do {
              if (token.next) {
                token = token.next;
              } else {
                const nextToken = readNextToken(this, token.end);
                token.next = nextToken;
                nextToken.prev = token;
                token = nextToken;
              }
            } while (token.kind === TokenKind.COMMENT);
          }
          return token;
        }
      };
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/jsutils/inspect.mjs
  function inspect(value) {
    return formatValue(value, []);
  }
  function formatValue(value, seenValues) {
    switch (typeof value) {
      case "string":
        return JSON.stringify(value);
      case "function":
        return value.name ? `[function ${value.name}]` : "[function]";
      case "object":
        return formatObjectValue(value, seenValues);
      default:
        return String(value);
    }
  }
  function formatObjectValue(value, previouslySeenValues) {
    if (value === null) {
      return "null";
    }
    if (previouslySeenValues.includes(value)) {
      return "[Circular]";
    }
    const seenValues = [...previouslySeenValues, value];
    if (isJSONable(value)) {
      const jsonValue = value.toJSON();
      if (jsonValue !== value) {
        return typeof jsonValue === "string" ? jsonValue : formatValue(jsonValue, seenValues);
      }
    } else if (Array.isArray(value)) {
      return formatArray(value, seenValues);
    }
    return formatObject(value, seenValues);
  }
  function isJSONable(value) {
    return typeof value.toJSON === "function";
  }
  function formatObject(object, seenValues) {
    const entries = Object.entries(object);
    if (entries.length === 0) {
      return "{}";
    }
    if (seenValues.length > MAX_RECURSIVE_DEPTH) {
      return "[" + getObjectTag(object) + "]";
    }
    const properties = entries.map(
      ([key, value]) => key + ": " + formatValue(value, seenValues)
    );
    return "{ " + properties.join(", ") + " }";
  }
  function formatArray(array, seenValues) {
    if (array.length === 0) {
      return "[]";
    }
    if (seenValues.length > MAX_RECURSIVE_DEPTH) {
      return "[Array]";
    }
    const len = Math.min(MAX_ARRAY_LENGTH, array.length);
    const remaining = array.length - len;
    const items = [];
    for (let i = 0; i < len; ++i) {
      items.push(formatValue(array[i], seenValues));
    }
    if (remaining === 1) {
      items.push("... 1 more item");
    } else if (remaining > 1) {
      items.push(`... ${remaining} more items`);
    }
    return "[" + items.join(", ") + "]";
  }
  function getObjectTag(object) {
    const tag = Object.prototype.toString.call(object).replace(/^\[object /, "").replace(/]$/, "");
    if (tag === "Object" && typeof object.constructor === "function") {
      const name = object.constructor.name;
      if (typeof name === "string" && name !== "") {
        return name;
      }
    }
    return tag;
  }
  var MAX_ARRAY_LENGTH, MAX_RECURSIVE_DEPTH;
  var init_inspect = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/jsutils/inspect.mjs"() {
      "use strict";
      MAX_ARRAY_LENGTH = 10;
      MAX_RECURSIVE_DEPTH = 2;
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/jsutils/instanceOf.mjs
  var isProduction, instanceOf;
  var init_instanceOf = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/jsutils/instanceOf.mjs"() {
      "use strict";
      init_inspect();
      isProduction = globalThis.process && // eslint-disable-next-line no-undef
      false;
      instanceOf = /* c8 ignore next 6 */
      // FIXME: https://github.com/graphql/graphql-js/issues/2317
      isProduction ? function instanceOf2(value, constructor) {
        return value instanceof constructor;
      } : function instanceOf3(value, constructor) {
        if (value instanceof constructor) {
          return true;
        }
        if (typeof value === "object" && value !== null) {
          var _value$constructor;
          const className = constructor.prototype[Symbol.toStringTag];
          const valueClassName = (
            // We still need to support constructor's name to detect conflicts with older versions of this library.
            Symbol.toStringTag in value ? value[Symbol.toStringTag] : (_value$constructor = value.constructor) === null || _value$constructor === void 0 ? void 0 : _value$constructor.name
          );
          if (className === valueClassName) {
            const stringifiedValue = inspect(value);
            throw new Error(`Cannot use ${className} "${stringifiedValue}" from another module or realm.

Ensure that there is only one instance of "graphql" in the node_modules
directory. If different versions of "graphql" are the dependencies of other
relied on modules, use "resolutions" to ensure only one version is installed.

https://yarnpkg.com/en/docs/selective-version-resolutions

Duplicate "graphql" modules cannot be used at the same time since different
versions may have different capabilities and behavior. The data from one
version used in the function from another could produce confusing and
spurious results.`);
          }
        }
        return false;
      };
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/language/source.mjs
  function isSource(source) {
    return instanceOf(source, Source);
  }
  var Source;
  var init_source = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/language/source.mjs"() {
      "use strict";
      init_devAssert();
      init_inspect();
      init_instanceOf();
      Source = class {
        constructor(body, name = "GraphQL request", locationOffset = {
          line: 1,
          column: 1
        }) {
          typeof body === "string" || devAssert(false, `Body must be a string. Received: ${inspect(body)}.`);
          this.body = body;
          this.name = name;
          this.locationOffset = locationOffset;
          this.locationOffset.line > 0 || devAssert(
            false,
            "line in locationOffset is 1-indexed and must be positive."
          );
          this.locationOffset.column > 0 || devAssert(
            false,
            "column in locationOffset is 1-indexed and must be positive."
          );
        }
        get [Symbol.toStringTag]() {
          return "Source";
        }
      };
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/language/parser.mjs
  function parse2(source, options) {
    const parser = new Parser(source, options);
    return parser.parseDocument();
  }
  function parseValue(source, options) {
    const parser = new Parser(source, options);
    parser.expectToken(TokenKind.SOF);
    const value = parser.parseValueLiteral(false);
    parser.expectToken(TokenKind.EOF);
    return value;
  }
  function parseConstValue(source, options) {
    const parser = new Parser(source, options);
    parser.expectToken(TokenKind.SOF);
    const value = parser.parseConstValueLiteral();
    parser.expectToken(TokenKind.EOF);
    return value;
  }
  function parseType(source, options) {
    const parser = new Parser(source, options);
    parser.expectToken(TokenKind.SOF);
    const type = parser.parseTypeReference();
    parser.expectToken(TokenKind.EOF);
    return type;
  }
  function getTokenDesc(token) {
    const value = token.value;
    return getTokenKindDesc(token.kind) + (value != null ? ` "${value}"` : "");
  }
  function getTokenKindDesc(kind) {
    return isPunctuatorTokenKind(kind) ? `"${kind}"` : kind;
  }
  var Parser;
  var init_parser = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/language/parser.mjs"() {
      "use strict";
      init_syntaxError();
      init_ast();
      init_directiveLocation();
      init_kinds();
      init_lexer();
      init_source();
      init_tokenKind();
      Parser = class {
        constructor(source, options = {}) {
          const sourceObj = isSource(source) ? source : new Source(source);
          this._lexer = new Lexer(sourceObj);
          this._options = options;
          this._tokenCounter = 0;
        }
        /**
         * Converts a name lex token into a name parse node.
         */
        parseName() {
          const token = this.expectToken(TokenKind.NAME);
          return this.node(token, {
            kind: Kind.NAME,
            value: token.value
          });
        }
        // Implements the parsing rules in the Document section.
        /**
         * Document : Definition+
         */
        parseDocument() {
          return this.node(this._lexer.token, {
            kind: Kind.DOCUMENT,
            definitions: this.many(
              TokenKind.SOF,
              this.parseDefinition,
              TokenKind.EOF
            )
          });
        }
        /**
         * Definition :
         *   - ExecutableDefinition
         *   - TypeSystemDefinition
         *   - TypeSystemExtension
         *
         * ExecutableDefinition :
         *   - OperationDefinition
         *   - FragmentDefinition
         *
         * TypeSystemDefinition :
         *   - SchemaDefinition
         *   - TypeDefinition
         *   - DirectiveDefinition
         *
         * TypeDefinition :
         *   - ScalarTypeDefinition
         *   - ObjectTypeDefinition
         *   - InterfaceTypeDefinition
         *   - UnionTypeDefinition
         *   - EnumTypeDefinition
         *   - InputObjectTypeDefinition
         */
        parseDefinition() {
          if (this.peek(TokenKind.BRACE_L)) {
            return this.parseOperationDefinition();
          }
          const hasDescription = this.peekDescription();
          const keywordToken = hasDescription ? this._lexer.lookahead() : this._lexer.token;
          if (keywordToken.kind === TokenKind.NAME) {
            switch (keywordToken.value) {
              case "schema":
                return this.parseSchemaDefinition();
              case "scalar":
                return this.parseScalarTypeDefinition();
              case "type":
                return this.parseObjectTypeDefinition();
              case "interface":
                return this.parseInterfaceTypeDefinition();
              case "union":
                return this.parseUnionTypeDefinition();
              case "enum":
                return this.parseEnumTypeDefinition();
              case "input":
                return this.parseInputObjectTypeDefinition();
              case "directive":
                return this.parseDirectiveDefinition();
            }
            if (hasDescription) {
              throw syntaxError(
                this._lexer.source,
                this._lexer.token.start,
                "Unexpected description, descriptions are supported only on type definitions."
              );
            }
            switch (keywordToken.value) {
              case "query":
              case "mutation":
              case "subscription":
                return this.parseOperationDefinition();
              case "fragment":
                return this.parseFragmentDefinition();
              case "extend":
                return this.parseTypeSystemExtension();
            }
          }
          throw this.unexpected(keywordToken);
        }
        // Implements the parsing rules in the Operations section.
        /**
         * OperationDefinition :
         *  - SelectionSet
         *  - OperationType Name? VariableDefinitions? Directives? SelectionSet
         */
        parseOperationDefinition() {
          const start = this._lexer.token;
          if (this.peek(TokenKind.BRACE_L)) {
            return this.node(start, {
              kind: Kind.OPERATION_DEFINITION,
              operation: OperationTypeNode.QUERY,
              name: void 0,
              variableDefinitions: [],
              directives: [],
              selectionSet: this.parseSelectionSet()
            });
          }
          const operation = this.parseOperationType();
          let name;
          if (this.peek(TokenKind.NAME)) {
            name = this.parseName();
          }
          return this.node(start, {
            kind: Kind.OPERATION_DEFINITION,
            operation,
            name,
            variableDefinitions: this.parseVariableDefinitions(),
            directives: this.parseDirectives(false),
            selectionSet: this.parseSelectionSet()
          });
        }
        /**
         * OperationType : one of query mutation subscription
         */
        parseOperationType() {
          const operationToken = this.expectToken(TokenKind.NAME);
          switch (operationToken.value) {
            case "query":
              return OperationTypeNode.QUERY;
            case "mutation":
              return OperationTypeNode.MUTATION;
            case "subscription":
              return OperationTypeNode.SUBSCRIPTION;
          }
          throw this.unexpected(operationToken);
        }
        /**
         * VariableDefinitions : ( VariableDefinition+ )
         */
        parseVariableDefinitions() {
          return this.optionalMany(
            TokenKind.PAREN_L,
            this.parseVariableDefinition,
            TokenKind.PAREN_R
          );
        }
        /**
         * VariableDefinition : Variable : Type DefaultValue? Directives[Const]?
         */
        parseVariableDefinition() {
          return this.node(this._lexer.token, {
            kind: Kind.VARIABLE_DEFINITION,
            variable: this.parseVariable(),
            type: (this.expectToken(TokenKind.COLON), this.parseTypeReference()),
            defaultValue: this.expectOptionalToken(TokenKind.EQUALS) ? this.parseConstValueLiteral() : void 0,
            directives: this.parseConstDirectives()
          });
        }
        /**
         * Variable : $ Name
         */
        parseVariable() {
          const start = this._lexer.token;
          this.expectToken(TokenKind.DOLLAR);
          return this.node(start, {
            kind: Kind.VARIABLE,
            name: this.parseName()
          });
        }
        /**
         * ```
         * SelectionSet : { Selection+ }
         * ```
         */
        parseSelectionSet() {
          return this.node(this._lexer.token, {
            kind: Kind.SELECTION_SET,
            selections: this.many(
              TokenKind.BRACE_L,
              this.parseSelection,
              TokenKind.BRACE_R
            )
          });
        }
        /**
         * Selection :
         *   - Field
         *   - FragmentSpread
         *   - InlineFragment
         */
        parseSelection() {
          return this.peek(TokenKind.SPREAD) ? this.parseFragment() : this.parseField();
        }
        /**
         * Field : Alias? Name Arguments? Directives? SelectionSet?
         *
         * Alias : Name :
         */
        parseField() {
          const start = this._lexer.token;
          const nameOrAlias = this.parseName();
          let alias;
          let name;
          if (this.expectOptionalToken(TokenKind.COLON)) {
            alias = nameOrAlias;
            name = this.parseName();
          } else {
            name = nameOrAlias;
          }
          return this.node(start, {
            kind: Kind.FIELD,
            alias,
            name,
            arguments: this.parseArguments(false),
            directives: this.parseDirectives(false),
            selectionSet: this.peek(TokenKind.BRACE_L) ? this.parseSelectionSet() : void 0
          });
        }
        /**
         * Arguments[Const] : ( Argument[?Const]+ )
         */
        parseArguments(isConst) {
          const item = isConst ? this.parseConstArgument : this.parseArgument;
          return this.optionalMany(TokenKind.PAREN_L, item, TokenKind.PAREN_R);
        }
        /**
         * Argument[Const] : Name : Value[?Const]
         */
        parseArgument(isConst = false) {
          const start = this._lexer.token;
          const name = this.parseName();
          this.expectToken(TokenKind.COLON);
          return this.node(start, {
            kind: Kind.ARGUMENT,
            name,
            value: this.parseValueLiteral(isConst)
          });
        }
        parseConstArgument() {
          return this.parseArgument(true);
        }
        // Implements the parsing rules in the Fragments section.
        /**
         * Corresponds to both FragmentSpread and InlineFragment in the spec.
         *
         * FragmentSpread : ... FragmentName Directives?
         *
         * InlineFragment : ... TypeCondition? Directives? SelectionSet
         */
        parseFragment() {
          const start = this._lexer.token;
          this.expectToken(TokenKind.SPREAD);
          const hasTypeCondition = this.expectOptionalKeyword("on");
          if (!hasTypeCondition && this.peek(TokenKind.NAME)) {
            return this.node(start, {
              kind: Kind.FRAGMENT_SPREAD,
              name: this.parseFragmentName(),
              directives: this.parseDirectives(false)
            });
          }
          return this.node(start, {
            kind: Kind.INLINE_FRAGMENT,
            typeCondition: hasTypeCondition ? this.parseNamedType() : void 0,
            directives: this.parseDirectives(false),
            selectionSet: this.parseSelectionSet()
          });
        }
        /**
         * FragmentDefinition :
         *   - fragment FragmentName on TypeCondition Directives? SelectionSet
         *
         * TypeCondition : NamedType
         */
        parseFragmentDefinition() {
          const start = this._lexer.token;
          this.expectKeyword("fragment");
          if (this._options.allowLegacyFragmentVariables === true) {
            return this.node(start, {
              kind: Kind.FRAGMENT_DEFINITION,
              name: this.parseFragmentName(),
              variableDefinitions: this.parseVariableDefinitions(),
              typeCondition: (this.expectKeyword("on"), this.parseNamedType()),
              directives: this.parseDirectives(false),
              selectionSet: this.parseSelectionSet()
            });
          }
          return this.node(start, {
            kind: Kind.FRAGMENT_DEFINITION,
            name: this.parseFragmentName(),
            typeCondition: (this.expectKeyword("on"), this.parseNamedType()),
            directives: this.parseDirectives(false),
            selectionSet: this.parseSelectionSet()
          });
        }
        /**
         * FragmentName : Name but not `on`
         */
        parseFragmentName() {
          if (this._lexer.token.value === "on") {
            throw this.unexpected();
          }
          return this.parseName();
        }
        // Implements the parsing rules in the Values section.
        /**
         * Value[Const] :
         *   - [~Const] Variable
         *   - IntValue
         *   - FloatValue
         *   - StringValue
         *   - BooleanValue
         *   - NullValue
         *   - EnumValue
         *   - ListValue[?Const]
         *   - ObjectValue[?Const]
         *
         * BooleanValue : one of `true` `false`
         *
         * NullValue : `null`
         *
         * EnumValue : Name but not `true`, `false` or `null`
         */
        parseValueLiteral(isConst) {
          const token = this._lexer.token;
          switch (token.kind) {
            case TokenKind.BRACKET_L:
              return this.parseList(isConst);
            case TokenKind.BRACE_L:
              return this.parseObject(isConst);
            case TokenKind.INT:
              this.advanceLexer();
              return this.node(token, {
                kind: Kind.INT,
                value: token.value
              });
            case TokenKind.FLOAT:
              this.advanceLexer();
              return this.node(token, {
                kind: Kind.FLOAT,
                value: token.value
              });
            case TokenKind.STRING:
            case TokenKind.BLOCK_STRING:
              return this.parseStringLiteral();
            case TokenKind.NAME:
              this.advanceLexer();
              switch (token.value) {
                case "true":
                  return this.node(token, {
                    kind: Kind.BOOLEAN,
                    value: true
                  });
                case "false":
                  return this.node(token, {
                    kind: Kind.BOOLEAN,
                    value: false
                  });
                case "null":
                  return this.node(token, {
                    kind: Kind.NULL
                  });
                default:
                  return this.node(token, {
                    kind: Kind.ENUM,
                    value: token.value
                  });
              }
            case TokenKind.DOLLAR:
              if (isConst) {
                this.expectToken(TokenKind.DOLLAR);
                if (this._lexer.token.kind === TokenKind.NAME) {
                  const varName = this._lexer.token.value;
                  throw syntaxError(
                    this._lexer.source,
                    token.start,
                    `Unexpected variable "$${varName}" in constant value.`
                  );
                } else {
                  throw this.unexpected(token);
                }
              }
              return this.parseVariable();
            default:
              throw this.unexpected();
          }
        }
        parseConstValueLiteral() {
          return this.parseValueLiteral(true);
        }
        parseStringLiteral() {
          const token = this._lexer.token;
          this.advanceLexer();
          return this.node(token, {
            kind: Kind.STRING,
            value: token.value,
            block: token.kind === TokenKind.BLOCK_STRING
          });
        }
        /**
         * ListValue[Const] :
         *   - [ ]
         *   - [ Value[?Const]+ ]
         */
        parseList(isConst) {
          const item = () => this.parseValueLiteral(isConst);
          return this.node(this._lexer.token, {
            kind: Kind.LIST,
            values: this.any(TokenKind.BRACKET_L, item, TokenKind.BRACKET_R)
          });
        }
        /**
         * ```
         * ObjectValue[Const] :
         *   - { }
         *   - { ObjectField[?Const]+ }
         * ```
         */
        parseObject(isConst) {
          const item = () => this.parseObjectField(isConst);
          return this.node(this._lexer.token, {
            kind: Kind.OBJECT,
            fields: this.any(TokenKind.BRACE_L, item, TokenKind.BRACE_R)
          });
        }
        /**
         * ObjectField[Const] : Name : Value[?Const]
         */
        parseObjectField(isConst) {
          const start = this._lexer.token;
          const name = this.parseName();
          this.expectToken(TokenKind.COLON);
          return this.node(start, {
            kind: Kind.OBJECT_FIELD,
            name,
            value: this.parseValueLiteral(isConst)
          });
        }
        // Implements the parsing rules in the Directives section.
        /**
         * Directives[Const] : Directive[?Const]+
         */
        parseDirectives(isConst) {
          const directives = [];
          while (this.peek(TokenKind.AT)) {
            directives.push(this.parseDirective(isConst));
          }
          return directives;
        }
        parseConstDirectives() {
          return this.parseDirectives(true);
        }
        /**
         * ```
         * Directive[Const] : @ Name Arguments[?Const]?
         * ```
         */
        parseDirective(isConst) {
          const start = this._lexer.token;
          this.expectToken(TokenKind.AT);
          return this.node(start, {
            kind: Kind.DIRECTIVE,
            name: this.parseName(),
            arguments: this.parseArguments(isConst)
          });
        }
        // Implements the parsing rules in the Types section.
        /**
         * Type :
         *   - NamedType
         *   - ListType
         *   - NonNullType
         */
        parseTypeReference() {
          const start = this._lexer.token;
          let type;
          if (this.expectOptionalToken(TokenKind.BRACKET_L)) {
            const innerType = this.parseTypeReference();
            this.expectToken(TokenKind.BRACKET_R);
            type = this.node(start, {
              kind: Kind.LIST_TYPE,
              type: innerType
            });
          } else {
            type = this.parseNamedType();
          }
          if (this.expectOptionalToken(TokenKind.BANG)) {
            return this.node(start, {
              kind: Kind.NON_NULL_TYPE,
              type
            });
          }
          return type;
        }
        /**
         * NamedType : Name
         */
        parseNamedType() {
          return this.node(this._lexer.token, {
            kind: Kind.NAMED_TYPE,
            name: this.parseName()
          });
        }
        // Implements the parsing rules in the Type Definition section.
        peekDescription() {
          return this.peek(TokenKind.STRING) || this.peek(TokenKind.BLOCK_STRING);
        }
        /**
         * Description : StringValue
         */
        parseDescription() {
          if (this.peekDescription()) {
            return this.parseStringLiteral();
          }
        }
        /**
         * ```
         * SchemaDefinition : Description? schema Directives[Const]? { OperationTypeDefinition+ }
         * ```
         */
        parseSchemaDefinition() {
          const start = this._lexer.token;
          const description = this.parseDescription();
          this.expectKeyword("schema");
          const directives = this.parseConstDirectives();
          const operationTypes = this.many(
            TokenKind.BRACE_L,
            this.parseOperationTypeDefinition,
            TokenKind.BRACE_R
          );
          return this.node(start, {
            kind: Kind.SCHEMA_DEFINITION,
            description,
            directives,
            operationTypes
          });
        }
        /**
         * OperationTypeDefinition : OperationType : NamedType
         */
        parseOperationTypeDefinition() {
          const start = this._lexer.token;
          const operation = this.parseOperationType();
          this.expectToken(TokenKind.COLON);
          const type = this.parseNamedType();
          return this.node(start, {
            kind: Kind.OPERATION_TYPE_DEFINITION,
            operation,
            type
          });
        }
        /**
         * ScalarTypeDefinition : Description? scalar Name Directives[Const]?
         */
        parseScalarTypeDefinition() {
          const start = this._lexer.token;
          const description = this.parseDescription();
          this.expectKeyword("scalar");
          const name = this.parseName();
          const directives = this.parseConstDirectives();
          return this.node(start, {
            kind: Kind.SCALAR_TYPE_DEFINITION,
            description,
            name,
            directives
          });
        }
        /**
         * ObjectTypeDefinition :
         *   Description?
         *   type Name ImplementsInterfaces? Directives[Const]? FieldsDefinition?
         */
        parseObjectTypeDefinition() {
          const start = this._lexer.token;
          const description = this.parseDescription();
          this.expectKeyword("type");
          const name = this.parseName();
          const interfaces = this.parseImplementsInterfaces();
          const directives = this.parseConstDirectives();
          const fields = this.parseFieldsDefinition();
          return this.node(start, {
            kind: Kind.OBJECT_TYPE_DEFINITION,
            description,
            name,
            interfaces,
            directives,
            fields
          });
        }
        /**
         * ImplementsInterfaces :
         *   - implements `&`? NamedType
         *   - ImplementsInterfaces & NamedType
         */
        parseImplementsInterfaces() {
          return this.expectOptionalKeyword("implements") ? this.delimitedMany(TokenKind.AMP, this.parseNamedType) : [];
        }
        /**
         * ```
         * FieldsDefinition : { FieldDefinition+ }
         * ```
         */
        parseFieldsDefinition() {
          return this.optionalMany(
            TokenKind.BRACE_L,
            this.parseFieldDefinition,
            TokenKind.BRACE_R
          );
        }
        /**
         * FieldDefinition :
         *   - Description? Name ArgumentsDefinition? : Type Directives[Const]?
         */
        parseFieldDefinition() {
          const start = this._lexer.token;
          const description = this.parseDescription();
          const name = this.parseName();
          const args = this.parseArgumentDefs();
          this.expectToken(TokenKind.COLON);
          const type = this.parseTypeReference();
          const directives = this.parseConstDirectives();
          return this.node(start, {
            kind: Kind.FIELD_DEFINITION,
            description,
            name,
            arguments: args,
            type,
            directives
          });
        }
        /**
         * ArgumentsDefinition : ( InputValueDefinition+ )
         */
        parseArgumentDefs() {
          return this.optionalMany(
            TokenKind.PAREN_L,
            this.parseInputValueDef,
            TokenKind.PAREN_R
          );
        }
        /**
         * InputValueDefinition :
         *   - Description? Name : Type DefaultValue? Directives[Const]?
         */
        parseInputValueDef() {
          const start = this._lexer.token;
          const description = this.parseDescription();
          const name = this.parseName();
          this.expectToken(TokenKind.COLON);
          const type = this.parseTypeReference();
          let defaultValue;
          if (this.expectOptionalToken(TokenKind.EQUALS)) {
            defaultValue = this.parseConstValueLiteral();
          }
          const directives = this.parseConstDirectives();
          return this.node(start, {
            kind: Kind.INPUT_VALUE_DEFINITION,
            description,
            name,
            type,
            defaultValue,
            directives
          });
        }
        /**
         * InterfaceTypeDefinition :
         *   - Description? interface Name Directives[Const]? FieldsDefinition?
         */
        parseInterfaceTypeDefinition() {
          const start = this._lexer.token;
          const description = this.parseDescription();
          this.expectKeyword("interface");
          const name = this.parseName();
          const interfaces = this.parseImplementsInterfaces();
          const directives = this.parseConstDirectives();
          const fields = this.parseFieldsDefinition();
          return this.node(start, {
            kind: Kind.INTERFACE_TYPE_DEFINITION,
            description,
            name,
            interfaces,
            directives,
            fields
          });
        }
        /**
         * UnionTypeDefinition :
         *   - Description? union Name Directives[Const]? UnionMemberTypes?
         */
        parseUnionTypeDefinition() {
          const start = this._lexer.token;
          const description = this.parseDescription();
          this.expectKeyword("union");
          const name = this.parseName();
          const directives = this.parseConstDirectives();
          const types = this.parseUnionMemberTypes();
          return this.node(start, {
            kind: Kind.UNION_TYPE_DEFINITION,
            description,
            name,
            directives,
            types
          });
        }
        /**
         * UnionMemberTypes :
         *   - = `|`? NamedType
         *   - UnionMemberTypes | NamedType
         */
        parseUnionMemberTypes() {
          return this.expectOptionalToken(TokenKind.EQUALS) ? this.delimitedMany(TokenKind.PIPE, this.parseNamedType) : [];
        }
        /**
         * EnumTypeDefinition :
         *   - Description? enum Name Directives[Const]? EnumValuesDefinition?
         */
        parseEnumTypeDefinition() {
          const start = this._lexer.token;
          const description = this.parseDescription();
          this.expectKeyword("enum");
          const name = this.parseName();
          const directives = this.parseConstDirectives();
          const values = this.parseEnumValuesDefinition();
          return this.node(start, {
            kind: Kind.ENUM_TYPE_DEFINITION,
            description,
            name,
            directives,
            values
          });
        }
        /**
         * ```
         * EnumValuesDefinition : { EnumValueDefinition+ }
         * ```
         */
        parseEnumValuesDefinition() {
          return this.optionalMany(
            TokenKind.BRACE_L,
            this.parseEnumValueDefinition,
            TokenKind.BRACE_R
          );
        }
        /**
         * EnumValueDefinition : Description? EnumValue Directives[Const]?
         */
        parseEnumValueDefinition() {
          const start = this._lexer.token;
          const description = this.parseDescription();
          const name = this.parseEnumValueName();
          const directives = this.parseConstDirectives();
          return this.node(start, {
            kind: Kind.ENUM_VALUE_DEFINITION,
            description,
            name,
            directives
          });
        }
        /**
         * EnumValue : Name but not `true`, `false` or `null`
         */
        parseEnumValueName() {
          if (this._lexer.token.value === "true" || this._lexer.token.value === "false" || this._lexer.token.value === "null") {
            throw syntaxError(
              this._lexer.source,
              this._lexer.token.start,
              `${getTokenDesc(
                this._lexer.token
              )} is reserved and cannot be used for an enum value.`
            );
          }
          return this.parseName();
        }
        /**
         * InputObjectTypeDefinition :
         *   - Description? input Name Directives[Const]? InputFieldsDefinition?
         */
        parseInputObjectTypeDefinition() {
          const start = this._lexer.token;
          const description = this.parseDescription();
          this.expectKeyword("input");
          const name = this.parseName();
          const directives = this.parseConstDirectives();
          const fields = this.parseInputFieldsDefinition();
          return this.node(start, {
            kind: Kind.INPUT_OBJECT_TYPE_DEFINITION,
            description,
            name,
            directives,
            fields
          });
        }
        /**
         * ```
         * InputFieldsDefinition : { InputValueDefinition+ }
         * ```
         */
        parseInputFieldsDefinition() {
          return this.optionalMany(
            TokenKind.BRACE_L,
            this.parseInputValueDef,
            TokenKind.BRACE_R
          );
        }
        /**
         * TypeSystemExtension :
         *   - SchemaExtension
         *   - TypeExtension
         *
         * TypeExtension :
         *   - ScalarTypeExtension
         *   - ObjectTypeExtension
         *   - InterfaceTypeExtension
         *   - UnionTypeExtension
         *   - EnumTypeExtension
         *   - InputObjectTypeDefinition
         */
        parseTypeSystemExtension() {
          const keywordToken = this._lexer.lookahead();
          if (keywordToken.kind === TokenKind.NAME) {
            switch (keywordToken.value) {
              case "schema":
                return this.parseSchemaExtension();
              case "scalar":
                return this.parseScalarTypeExtension();
              case "type":
                return this.parseObjectTypeExtension();
              case "interface":
                return this.parseInterfaceTypeExtension();
              case "union":
                return this.parseUnionTypeExtension();
              case "enum":
                return this.parseEnumTypeExtension();
              case "input":
                return this.parseInputObjectTypeExtension();
            }
          }
          throw this.unexpected(keywordToken);
        }
        /**
         * ```
         * SchemaExtension :
         *  - extend schema Directives[Const]? { OperationTypeDefinition+ }
         *  - extend schema Directives[Const]
         * ```
         */
        parseSchemaExtension() {
          const start = this._lexer.token;
          this.expectKeyword("extend");
          this.expectKeyword("schema");
          const directives = this.parseConstDirectives();
          const operationTypes = this.optionalMany(
            TokenKind.BRACE_L,
            this.parseOperationTypeDefinition,
            TokenKind.BRACE_R
          );
          if (directives.length === 0 && operationTypes.length === 0) {
            throw this.unexpected();
          }
          return this.node(start, {
            kind: Kind.SCHEMA_EXTENSION,
            directives,
            operationTypes
          });
        }
        /**
         * ScalarTypeExtension :
         *   - extend scalar Name Directives[Const]
         */
        parseScalarTypeExtension() {
          const start = this._lexer.token;
          this.expectKeyword("extend");
          this.expectKeyword("scalar");
          const name = this.parseName();
          const directives = this.parseConstDirectives();
          if (directives.length === 0) {
            throw this.unexpected();
          }
          return this.node(start, {
            kind: Kind.SCALAR_TYPE_EXTENSION,
            name,
            directives
          });
        }
        /**
         * ObjectTypeExtension :
         *  - extend type Name ImplementsInterfaces? Directives[Const]? FieldsDefinition
         *  - extend type Name ImplementsInterfaces? Directives[Const]
         *  - extend type Name ImplementsInterfaces
         */
        parseObjectTypeExtension() {
          const start = this._lexer.token;
          this.expectKeyword("extend");
          this.expectKeyword("type");
          const name = this.parseName();
          const interfaces = this.parseImplementsInterfaces();
          const directives = this.parseConstDirectives();
          const fields = this.parseFieldsDefinition();
          if (interfaces.length === 0 && directives.length === 0 && fields.length === 0) {
            throw this.unexpected();
          }
          return this.node(start, {
            kind: Kind.OBJECT_TYPE_EXTENSION,
            name,
            interfaces,
            directives,
            fields
          });
        }
        /**
         * InterfaceTypeExtension :
         *  - extend interface Name ImplementsInterfaces? Directives[Const]? FieldsDefinition
         *  - extend interface Name ImplementsInterfaces? Directives[Const]
         *  - extend interface Name ImplementsInterfaces
         */
        parseInterfaceTypeExtension() {
          const start = this._lexer.token;
          this.expectKeyword("extend");
          this.expectKeyword("interface");
          const name = this.parseName();
          const interfaces = this.parseImplementsInterfaces();
          const directives = this.parseConstDirectives();
          const fields = this.parseFieldsDefinition();
          if (interfaces.length === 0 && directives.length === 0 && fields.length === 0) {
            throw this.unexpected();
          }
          return this.node(start, {
            kind: Kind.INTERFACE_TYPE_EXTENSION,
            name,
            interfaces,
            directives,
            fields
          });
        }
        /**
         * UnionTypeExtension :
         *   - extend union Name Directives[Const]? UnionMemberTypes
         *   - extend union Name Directives[Const]
         */
        parseUnionTypeExtension() {
          const start = this._lexer.token;
          this.expectKeyword("extend");
          this.expectKeyword("union");
          const name = this.parseName();
          const directives = this.parseConstDirectives();
          const types = this.parseUnionMemberTypes();
          if (directives.length === 0 && types.length === 0) {
            throw this.unexpected();
          }
          return this.node(start, {
            kind: Kind.UNION_TYPE_EXTENSION,
            name,
            directives,
            types
          });
        }
        /**
         * EnumTypeExtension :
         *   - extend enum Name Directives[Const]? EnumValuesDefinition
         *   - extend enum Name Directives[Const]
         */
        parseEnumTypeExtension() {
          const start = this._lexer.token;
          this.expectKeyword("extend");
          this.expectKeyword("enum");
          const name = this.parseName();
          const directives = this.parseConstDirectives();
          const values = this.parseEnumValuesDefinition();
          if (directives.length === 0 && values.length === 0) {
            throw this.unexpected();
          }
          return this.node(start, {
            kind: Kind.ENUM_TYPE_EXTENSION,
            name,
            directives,
            values
          });
        }
        /**
         * InputObjectTypeExtension :
         *   - extend input Name Directives[Const]? InputFieldsDefinition
         *   - extend input Name Directives[Const]
         */
        parseInputObjectTypeExtension() {
          const start = this._lexer.token;
          this.expectKeyword("extend");
          this.expectKeyword("input");
          const name = this.parseName();
          const directives = this.parseConstDirectives();
          const fields = this.parseInputFieldsDefinition();
          if (directives.length === 0 && fields.length === 0) {
            throw this.unexpected();
          }
          return this.node(start, {
            kind: Kind.INPUT_OBJECT_TYPE_EXTENSION,
            name,
            directives,
            fields
          });
        }
        /**
         * ```
         * DirectiveDefinition :
         *   - Description? directive @ Name ArgumentsDefinition? `repeatable`? on DirectiveLocations
         * ```
         */
        parseDirectiveDefinition() {
          const start = this._lexer.token;
          const description = this.parseDescription();
          this.expectKeyword("directive");
          this.expectToken(TokenKind.AT);
          const name = this.parseName();
          const args = this.parseArgumentDefs();
          const repeatable = this.expectOptionalKeyword("repeatable");
          this.expectKeyword("on");
          const locations = this.parseDirectiveLocations();
          return this.node(start, {
            kind: Kind.DIRECTIVE_DEFINITION,
            description,
            name,
            arguments: args,
            repeatable,
            locations
          });
        }
        /**
         * DirectiveLocations :
         *   - `|`? DirectiveLocation
         *   - DirectiveLocations | DirectiveLocation
         */
        parseDirectiveLocations() {
          return this.delimitedMany(TokenKind.PIPE, this.parseDirectiveLocation);
        }
        /*
         * DirectiveLocation :
         *   - ExecutableDirectiveLocation
         *   - TypeSystemDirectiveLocation
         *
         * ExecutableDirectiveLocation : one of
         *   `QUERY`
         *   `MUTATION`
         *   `SUBSCRIPTION`
         *   `FIELD`
         *   `FRAGMENT_DEFINITION`
         *   `FRAGMENT_SPREAD`
         *   `INLINE_FRAGMENT`
         *
         * TypeSystemDirectiveLocation : one of
         *   `SCHEMA`
         *   `SCALAR`
         *   `OBJECT`
         *   `FIELD_DEFINITION`
         *   `ARGUMENT_DEFINITION`
         *   `INTERFACE`
         *   `UNION`
         *   `ENUM`
         *   `ENUM_VALUE`
         *   `INPUT_OBJECT`
         *   `INPUT_FIELD_DEFINITION`
         */
        parseDirectiveLocation() {
          const start = this._lexer.token;
          const name = this.parseName();
          if (Object.prototype.hasOwnProperty.call(DirectiveLocation, name.value)) {
            return name;
          }
          throw this.unexpected(start);
        }
        // Core parsing utility functions
        /**
         * Returns a node that, if configured to do so, sets a "loc" field as a
         * location object, used to identify the place in the source that created a
         * given parsed object.
         */
        node(startToken, node) {
          if (this._options.noLocation !== true) {
            node.loc = new Location(
              startToken,
              this._lexer.lastToken,
              this._lexer.source
            );
          }
          return node;
        }
        /**
         * Determines if the next token is of a given kind
         */
        peek(kind) {
          return this._lexer.token.kind === kind;
        }
        /**
         * If the next token is of the given kind, return that token after advancing the lexer.
         * Otherwise, do not change the parser state and throw an error.
         */
        expectToken(kind) {
          const token = this._lexer.token;
          if (token.kind === kind) {
            this.advanceLexer();
            return token;
          }
          throw syntaxError(
            this._lexer.source,
            token.start,
            `Expected ${getTokenKindDesc(kind)}, found ${getTokenDesc(token)}.`
          );
        }
        /**
         * If the next token is of the given kind, return "true" after advancing the lexer.
         * Otherwise, do not change the parser state and return "false".
         */
        expectOptionalToken(kind) {
          const token = this._lexer.token;
          if (token.kind === kind) {
            this.advanceLexer();
            return true;
          }
          return false;
        }
        /**
         * If the next token is a given keyword, advance the lexer.
         * Otherwise, do not change the parser state and throw an error.
         */
        expectKeyword(value) {
          const token = this._lexer.token;
          if (token.kind === TokenKind.NAME && token.value === value) {
            this.advanceLexer();
          } else {
            throw syntaxError(
              this._lexer.source,
              token.start,
              `Expected "${value}", found ${getTokenDesc(token)}.`
            );
          }
        }
        /**
         * If the next token is a given keyword, return "true" after advancing the lexer.
         * Otherwise, do not change the parser state and return "false".
         */
        expectOptionalKeyword(value) {
          const token = this._lexer.token;
          if (token.kind === TokenKind.NAME && token.value === value) {
            this.advanceLexer();
            return true;
          }
          return false;
        }
        /**
         * Helper function for creating an error when an unexpected lexed token is encountered.
         */
        unexpected(atToken) {
          const token = atToken !== null && atToken !== void 0 ? atToken : this._lexer.token;
          return syntaxError(
            this._lexer.source,
            token.start,
            `Unexpected ${getTokenDesc(token)}.`
          );
        }
        /**
         * Returns a possibly empty list of parse nodes, determined by the parseFn.
         * This list begins with a lex token of openKind and ends with a lex token of closeKind.
         * Advances the parser to the next lex token after the closing token.
         */
        any(openKind, parseFn, closeKind) {
          this.expectToken(openKind);
          const nodes = [];
          while (!this.expectOptionalToken(closeKind)) {
            nodes.push(parseFn.call(this));
          }
          return nodes;
        }
        /**
         * Returns a list of parse nodes, determined by the parseFn.
         * It can be empty only if open token is missing otherwise it will always return non-empty list
         * that begins with a lex token of openKind and ends with a lex token of closeKind.
         * Advances the parser to the next lex token after the closing token.
         */
        optionalMany(openKind, parseFn, closeKind) {
          if (this.expectOptionalToken(openKind)) {
            const nodes = [];
            do {
              nodes.push(parseFn.call(this));
            } while (!this.expectOptionalToken(closeKind));
            return nodes;
          }
          return [];
        }
        /**
         * Returns a non-empty list of parse nodes, determined by the parseFn.
         * This list begins with a lex token of openKind and ends with a lex token of closeKind.
         * Advances the parser to the next lex token after the closing token.
         */
        many(openKind, parseFn, closeKind) {
          this.expectToken(openKind);
          const nodes = [];
          do {
            nodes.push(parseFn.call(this));
          } while (!this.expectOptionalToken(closeKind));
          return nodes;
        }
        /**
         * Returns a non-empty list of parse nodes, determined by the parseFn.
         * This list may begin with a lex token of delimiterKind followed by items separated by lex tokens of tokenKind.
         * Advances the parser to the next lex token after last item in the list.
         */
        delimitedMany(delimiterKind, parseFn) {
          this.expectOptionalToken(delimiterKind);
          const nodes = [];
          do {
            nodes.push(parseFn.call(this));
          } while (this.expectOptionalToken(delimiterKind));
          return nodes;
        }
        advanceLexer() {
          const { maxTokens } = this._options;
          const token = this._lexer.advance();
          if (maxTokens !== void 0 && token.kind !== TokenKind.EOF) {
            ++this._tokenCounter;
            if (this._tokenCounter > maxTokens) {
              throw syntaxError(
                this._lexer.source,
                token.start,
                `Document contains more that ${maxTokens} tokens. Parsing aborted.`
              );
            }
          }
        }
      };
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/jsutils/didYouMean.mjs
  function didYouMean(firstArg, secondArg) {
    const [subMessage, suggestionsArg] = secondArg ? [firstArg, secondArg] : [void 0, firstArg];
    let message3 = " Did you mean ";
    if (subMessage) {
      message3 += subMessage + " ";
    }
    const suggestions = suggestionsArg.map((x) => `"${x}"`);
    switch (suggestions.length) {
      case 0:
        return "";
      case 1:
        return message3 + suggestions[0] + "?";
      case 2:
        return message3 + suggestions[0] + " or " + suggestions[1] + "?";
    }
    const selected = suggestions.slice(0, MAX_SUGGESTIONS);
    const lastItem = selected.pop();
    return message3 + selected.join(", ") + ", or " + lastItem + "?";
  }
  var MAX_SUGGESTIONS;
  var init_didYouMean = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/jsutils/didYouMean.mjs"() {
      "use strict";
      MAX_SUGGESTIONS = 5;
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/jsutils/identityFunc.mjs
  function identityFunc(x) {
    return x;
  }
  var init_identityFunc = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/jsutils/identityFunc.mjs"() {
      "use strict";
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/jsutils/keyMap.mjs
  function keyMap(list, keyFn) {
    const result = /* @__PURE__ */ Object.create(null);
    for (const item of list) {
      result[keyFn(item)] = item;
    }
    return result;
  }
  var init_keyMap = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/jsutils/keyMap.mjs"() {
      "use strict";
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/jsutils/keyValMap.mjs
  function keyValMap(list, keyFn, valFn) {
    const result = /* @__PURE__ */ Object.create(null);
    for (const item of list) {
      result[keyFn(item)] = valFn(item);
    }
    return result;
  }
  var init_keyValMap = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/jsutils/keyValMap.mjs"() {
      "use strict";
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/jsutils/mapValue.mjs
  function mapValue(map, fn) {
    const result = /* @__PURE__ */ Object.create(null);
    for (const key of Object.keys(map)) {
      result[key] = fn(map[key], key);
    }
    return result;
  }
  var init_mapValue = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/jsutils/mapValue.mjs"() {
      "use strict";
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/jsutils/naturalCompare.mjs
  function naturalCompare(aStr, bStr) {
    let aIndex = 0;
    let bIndex = 0;
    while (aIndex < aStr.length && bIndex < bStr.length) {
      let aChar = aStr.charCodeAt(aIndex);
      let bChar = bStr.charCodeAt(bIndex);
      if (isDigit2(aChar) && isDigit2(bChar)) {
        let aNum = 0;
        do {
          ++aIndex;
          aNum = aNum * 10 + aChar - DIGIT_0;
          aChar = aStr.charCodeAt(aIndex);
        } while (isDigit2(aChar) && aNum > 0);
        let bNum = 0;
        do {
          ++bIndex;
          bNum = bNum * 10 + bChar - DIGIT_0;
          bChar = bStr.charCodeAt(bIndex);
        } while (isDigit2(bChar) && bNum > 0);
        if (aNum < bNum) {
          return -1;
        }
        if (aNum > bNum) {
          return 1;
        }
      } else {
        if (aChar < bChar) {
          return -1;
        }
        if (aChar > bChar) {
          return 1;
        }
        ++aIndex;
        ++bIndex;
      }
    }
    return aStr.length - bStr.length;
  }
  function isDigit2(code) {
    return !isNaN(code) && DIGIT_0 <= code && code <= DIGIT_9;
  }
  var DIGIT_0, DIGIT_9;
  var init_naturalCompare = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/jsutils/naturalCompare.mjs"() {
      "use strict";
      DIGIT_0 = 48;
      DIGIT_9 = 57;
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/jsutils/suggestionList.mjs
  function suggestionList(input, options) {
    const optionsByDistance = /* @__PURE__ */ Object.create(null);
    const lexicalDistance = new LexicalDistance(input);
    const threshold = Math.floor(input.length * 0.4) + 1;
    for (const option of options) {
      const distance = lexicalDistance.measure(option, threshold);
      if (distance !== void 0) {
        optionsByDistance[option] = distance;
      }
    }
    return Object.keys(optionsByDistance).sort((a, b) => {
      const distanceDiff = optionsByDistance[a] - optionsByDistance[b];
      return distanceDiff !== 0 ? distanceDiff : naturalCompare(a, b);
    });
  }
  function stringToArray(str) {
    const strLength = str.length;
    const array = new Array(strLength);
    for (let i = 0; i < strLength; ++i) {
      array[i] = str.charCodeAt(i);
    }
    return array;
  }
  var LexicalDistance;
  var init_suggestionList = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/jsutils/suggestionList.mjs"() {
      "use strict";
      init_naturalCompare();
      LexicalDistance = class {
        constructor(input) {
          this._input = input;
          this._inputLowerCase = input.toLowerCase();
          this._inputArray = stringToArray(this._inputLowerCase);
          this._rows = [
            new Array(input.length + 1).fill(0),
            new Array(input.length + 1).fill(0),
            new Array(input.length + 1).fill(0)
          ];
        }
        measure(option, threshold) {
          if (this._input === option) {
            return 0;
          }
          const optionLowerCase = option.toLowerCase();
          if (this._inputLowerCase === optionLowerCase) {
            return 1;
          }
          let a = stringToArray(optionLowerCase);
          let b = this._inputArray;
          if (a.length < b.length) {
            const tmp = a;
            a = b;
            b = tmp;
          }
          const aLength = a.length;
          const bLength = b.length;
          if (aLength - bLength > threshold) {
            return void 0;
          }
          const rows = this._rows;
          for (let j = 0; j <= bLength; j++) {
            rows[0][j] = j;
          }
          for (let i = 1; i <= aLength; i++) {
            const upRow = rows[(i - 1) % 3];
            const currentRow = rows[i % 3];
            let smallestCell = currentRow[0] = i;
            for (let j = 1; j <= bLength; j++) {
              const cost = a[i - 1] === b[j - 1] ? 0 : 1;
              let currentCell = Math.min(
                upRow[j] + 1,
                // delete
                currentRow[j - 1] + 1,
                // insert
                upRow[j - 1] + cost
                // substitute
              );
              if (i > 1 && j > 1 && a[i - 1] === b[j - 2] && a[i - 2] === b[j - 1]) {
                const doubleDiagonalCell = rows[(i - 2) % 3][j - 2];
                currentCell = Math.min(currentCell, doubleDiagonalCell + 1);
              }
              if (currentCell < smallestCell) {
                smallestCell = currentCell;
              }
              currentRow[j] = currentCell;
            }
            if (smallestCell > threshold) {
              return void 0;
            }
          }
          const distance = rows[aLength % 3][bLength];
          return distance <= threshold ? distance : void 0;
        }
      };
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/jsutils/toObjMap.mjs
  function toObjMap(obj) {
    if (obj == null) {
      return /* @__PURE__ */ Object.create(null);
    }
    if (Object.getPrototypeOf(obj) === null) {
      return obj;
    }
    const map = /* @__PURE__ */ Object.create(null);
    for (const [key, value] of Object.entries(obj)) {
      map[key] = value;
    }
    return map;
  }
  var init_toObjMap = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/jsutils/toObjMap.mjs"() {
      "use strict";
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/language/printString.mjs
  function printString(str) {
    return `"${str.replace(escapedRegExp, escapedReplacer)}"`;
  }
  function escapedReplacer(str) {
    return escapeSequences[str.charCodeAt(0)];
  }
  var escapedRegExp, escapeSequences;
  var init_printString = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/language/printString.mjs"() {
      "use strict";
      escapedRegExp = /[\x00-\x1f\x22\x5c\x7f-\x9f]/g;
      escapeSequences = [
        "\\u0000",
        "\\u0001",
        "\\u0002",
        "\\u0003",
        "\\u0004",
        "\\u0005",
        "\\u0006",
        "\\u0007",
        "\\b",
        "\\t",
        "\\n",
        "\\u000B",
        "\\f",
        "\\r",
        "\\u000E",
        "\\u000F",
        "\\u0010",
        "\\u0011",
        "\\u0012",
        "\\u0013",
        "\\u0014",
        "\\u0015",
        "\\u0016",
        "\\u0017",
        "\\u0018",
        "\\u0019",
        "\\u001A",
        "\\u001B",
        "\\u001C",
        "\\u001D",
        "\\u001E",
        "\\u001F",
        "",
        "",
        '\\"',
        "",
        "",
        "",
        "",
        "",
        "",
        "",
        "",
        "",
        "",
        "",
        "",
        "",
        // 2F
        "",
        "",
        "",
        "",
        "",
        "",
        "",
        "",
        "",
        "",
        "",
        "",
        "",
        "",
        "",
        "",
        // 3F
        "",
        "",
        "",
        "",
        "",
        "",
        "",
        "",
        "",
        "",
        "",
        "",
        "",
        "",
        "",
        "",
        // 4F
        "",
        "",
        "",
        "",
        "",
        "",
        "",
        "",
        "",
        "",
        "",
        "",
        "\\\\",
        "",
        "",
        "",
        // 5F
        "",
        "",
        "",
        "",
        "",
        "",
        "",
        "",
        "",
        "",
        "",
        "",
        "",
        "",
        "",
        "",
        // 6F
        "",
        "",
        "",
        "",
        "",
        "",
        "",
        "",
        "",
        "",
        "",
        "",
        "",
        "",
        "",
        "\\u007F",
        "\\u0080",
        "\\u0081",
        "\\u0082",
        "\\u0083",
        "\\u0084",
        "\\u0085",
        "\\u0086",
        "\\u0087",
        "\\u0088",
        "\\u0089",
        "\\u008A",
        "\\u008B",
        "\\u008C",
        "\\u008D",
        "\\u008E",
        "\\u008F",
        "\\u0090",
        "\\u0091",
        "\\u0092",
        "\\u0093",
        "\\u0094",
        "\\u0095",
        "\\u0096",
        "\\u0097",
        "\\u0098",
        "\\u0099",
        "\\u009A",
        "\\u009B",
        "\\u009C",
        "\\u009D",
        "\\u009E",
        "\\u009F"
      ];
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/language/visitor.mjs
  function visit(root, visitor, visitorKeys = QueryDocumentKeys) {
    const enterLeaveMap = /* @__PURE__ */ new Map();
    for (const kind of Object.values(Kind)) {
      enterLeaveMap.set(kind, getEnterLeaveForKind(visitor, kind));
    }
    let stack = void 0;
    let inArray = Array.isArray(root);
    let keys = [root];
    let index = -1;
    let edits = [];
    let node = root;
    let key = void 0;
    let parent = void 0;
    const path = [];
    const ancestors = [];
    do {
      index++;
      const isLeaving = index === keys.length;
      const isEdited = isLeaving && edits.length !== 0;
      if (isLeaving) {
        key = ancestors.length === 0 ? void 0 : path[path.length - 1];
        node = parent;
        parent = ancestors.pop();
        if (isEdited) {
          if (inArray) {
            node = node.slice();
            let editOffset = 0;
            for (const [editKey, editValue] of edits) {
              const arrayKey = editKey - editOffset;
              if (editValue === null) {
                node.splice(arrayKey, 1);
                editOffset++;
              } else {
                node[arrayKey] = editValue;
              }
            }
          } else {
            node = Object.defineProperties(
              {},
              Object.getOwnPropertyDescriptors(node)
            );
            for (const [editKey, editValue] of edits) {
              node[editKey] = editValue;
            }
          }
        }
        index = stack.index;
        keys = stack.keys;
        edits = stack.edits;
        inArray = stack.inArray;
        stack = stack.prev;
      } else if (parent) {
        key = inArray ? index : keys[index];
        node = parent[key];
        if (node === null || node === void 0) {
          continue;
        }
        path.push(key);
      }
      let result;
      if (!Array.isArray(node)) {
        var _enterLeaveMap$get, _enterLeaveMap$get2;
        isNode(node) || devAssert(false, `Invalid AST Node: ${inspect(node)}.`);
        const visitFn = isLeaving ? (_enterLeaveMap$get = enterLeaveMap.get(node.kind)) === null || _enterLeaveMap$get === void 0 ? void 0 : _enterLeaveMap$get.leave : (_enterLeaveMap$get2 = enterLeaveMap.get(node.kind)) === null || _enterLeaveMap$get2 === void 0 ? void 0 : _enterLeaveMap$get2.enter;
        result = visitFn === null || visitFn === void 0 ? void 0 : visitFn.call(visitor, node, key, parent, path, ancestors);
        if (result === BREAK) {
          break;
        }
        if (result === false) {
          if (!isLeaving) {
            path.pop();
            continue;
          }
        } else if (result !== void 0) {
          edits.push([key, result]);
          if (!isLeaving) {
            if (isNode(result)) {
              node = result;
            } else {
              path.pop();
              continue;
            }
          }
        }
      }
      if (result === void 0 && isEdited) {
        edits.push([key, node]);
      }
      if (isLeaving) {
        path.pop();
      } else {
        var _node$kind;
        stack = {
          inArray,
          index,
          keys,
          edits,
          prev: stack
        };
        inArray = Array.isArray(node);
        keys = inArray ? node : (_node$kind = visitorKeys[node.kind]) !== null && _node$kind !== void 0 ? _node$kind : [];
        index = -1;
        edits = [];
        if (parent) {
          ancestors.push(parent);
        }
        parent = node;
      }
    } while (stack !== void 0);
    if (edits.length !== 0) {
      return edits[edits.length - 1][1];
    }
    return root;
  }
  function visitInParallel(visitors) {
    const skipping = new Array(visitors.length).fill(null);
    const mergedVisitor = /* @__PURE__ */ Object.create(null);
    for (const kind of Object.values(Kind)) {
      let hasVisitor = false;
      const enterList = new Array(visitors.length).fill(void 0);
      const leaveList = new Array(visitors.length).fill(void 0);
      for (let i = 0; i < visitors.length; ++i) {
        const { enter, leave } = getEnterLeaveForKind(visitors[i], kind);
        hasVisitor || (hasVisitor = enter != null || leave != null);
        enterList[i] = enter;
        leaveList[i] = leave;
      }
      if (!hasVisitor) {
        continue;
      }
      const mergedEnterLeave = {
        enter(...args) {
          const node = args[0];
          for (let i = 0; i < visitors.length; i++) {
            if (skipping[i] === null) {
              var _enterList$i;
              const result = (_enterList$i = enterList[i]) === null || _enterList$i === void 0 ? void 0 : _enterList$i.apply(visitors[i], args);
              if (result === false) {
                skipping[i] = node;
              } else if (result === BREAK) {
                skipping[i] = BREAK;
              } else if (result !== void 0) {
                return result;
              }
            }
          }
        },
        leave(...args) {
          const node = args[0];
          for (let i = 0; i < visitors.length; i++) {
            if (skipping[i] === null) {
              var _leaveList$i;
              const result = (_leaveList$i = leaveList[i]) === null || _leaveList$i === void 0 ? void 0 : _leaveList$i.apply(visitors[i], args);
              if (result === BREAK) {
                skipping[i] = BREAK;
              } else if (result !== void 0 && result !== false) {
                return result;
              }
            } else if (skipping[i] === node) {
              skipping[i] = null;
            }
          }
        }
      };
      mergedVisitor[kind] = mergedEnterLeave;
    }
    return mergedVisitor;
  }
  function getEnterLeaveForKind(visitor, kind) {
    const kindVisitor = visitor[kind];
    if (typeof kindVisitor === "object") {
      return kindVisitor;
    } else if (typeof kindVisitor === "function") {
      return {
        enter: kindVisitor,
        leave: void 0
      };
    }
    return {
      enter: visitor.enter,
      leave: visitor.leave
    };
  }
  function getVisitFn(visitor, kind, isLeaving) {
    const { enter, leave } = getEnterLeaveForKind(visitor, kind);
    return isLeaving ? leave : enter;
  }
  var BREAK;
  var init_visitor = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/language/visitor.mjs"() {
      "use strict";
      init_devAssert();
      init_inspect();
      init_ast();
      init_kinds();
      BREAK = Object.freeze({});
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/language/printer.mjs
  function print(ast) {
    return visit(ast, printDocASTReducer);
  }
  function join(maybeArray, separator = "") {
    var _maybeArray$filter$jo;
    return (_maybeArray$filter$jo = maybeArray === null || maybeArray === void 0 ? void 0 : maybeArray.filter((x) => x).join(separator)) !== null && _maybeArray$filter$jo !== void 0 ? _maybeArray$filter$jo : "";
  }
  function block(array) {
    return wrap("{\n", indent(join(array, "\n")), "\n}");
  }
  function wrap(start, maybeString, end = "") {
    return maybeString != null && maybeString !== "" ? start + maybeString + end : "";
  }
  function indent(str) {
    return wrap("  ", str.replace(/\n/g, "\n  "));
  }
  function hasMultilineItems(maybeArray) {
    var _maybeArray$some;
    return (_maybeArray$some = maybeArray === null || maybeArray === void 0 ? void 0 : maybeArray.some((str) => str.includes("\n"))) !== null && _maybeArray$some !== void 0 ? _maybeArray$some : false;
  }
  var MAX_LINE_LENGTH, printDocASTReducer;
  var init_printer = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/language/printer.mjs"() {
      "use strict";
      init_blockString();
      init_printString();
      init_visitor();
      MAX_LINE_LENGTH = 80;
      printDocASTReducer = {
        Name: {
          leave: (node) => node.value
        },
        Variable: {
          leave: (node) => "$" + node.name
        },
        // Document
        Document: {
          leave: (node) => join(node.definitions, "\n\n")
        },
        OperationDefinition: {
          leave(node) {
            const varDefs = wrap("(", join(node.variableDefinitions, ", "), ")");
            const prefix = join(
              [
                node.operation,
                join([node.name, varDefs]),
                join(node.directives, " ")
              ],
              " "
            );
            return (prefix === "query" ? "" : prefix + " ") + node.selectionSet;
          }
        },
        VariableDefinition: {
          leave: ({ variable, type, defaultValue, directives }) => variable + ": " + type + wrap(" = ", defaultValue) + wrap(" ", join(directives, " "))
        },
        SelectionSet: {
          leave: ({ selections }) => block(selections)
        },
        Field: {
          leave({ alias, name, arguments: args, directives, selectionSet }) {
            const prefix = wrap("", alias, ": ") + name;
            let argsLine = prefix + wrap("(", join(args, ", "), ")");
            if (argsLine.length > MAX_LINE_LENGTH) {
              argsLine = prefix + wrap("(\n", indent(join(args, "\n")), "\n)");
            }
            return join([argsLine, join(directives, " "), selectionSet], " ");
          }
        },
        Argument: {
          leave: ({ name, value }) => name + ": " + value
        },
        // Fragments
        FragmentSpread: {
          leave: ({ name, directives }) => "..." + name + wrap(" ", join(directives, " "))
        },
        InlineFragment: {
          leave: ({ typeCondition, directives, selectionSet }) => join(
            [
              "...",
              wrap("on ", typeCondition),
              join(directives, " "),
              selectionSet
            ],
            " "
          )
        },
        FragmentDefinition: {
          leave: ({ name, typeCondition, variableDefinitions, directives, selectionSet }) => (
            // or removed in the future.
            `fragment ${name}${wrap("(", join(variableDefinitions, ", "), ")")} on ${typeCondition} ${wrap("", join(directives, " "), " ")}` + selectionSet
          )
        },
        // Value
        IntValue: {
          leave: ({ value }) => value
        },
        FloatValue: {
          leave: ({ value }) => value
        },
        StringValue: {
          leave: ({ value, block: isBlockString }) => isBlockString ? printBlockString(value) : printString(value)
        },
        BooleanValue: {
          leave: ({ value }) => value ? "true" : "false"
        },
        NullValue: {
          leave: () => "null"
        },
        EnumValue: {
          leave: ({ value }) => value
        },
        ListValue: {
          leave: ({ values }) => "[" + join(values, ", ") + "]"
        },
        ObjectValue: {
          leave: ({ fields }) => "{" + join(fields, ", ") + "}"
        },
        ObjectField: {
          leave: ({ name, value }) => name + ": " + value
        },
        // Directive
        Directive: {
          leave: ({ name, arguments: args }) => "@" + name + wrap("(", join(args, ", "), ")")
        },
        // Type
        NamedType: {
          leave: ({ name }) => name
        },
        ListType: {
          leave: ({ type }) => "[" + type + "]"
        },
        NonNullType: {
          leave: ({ type }) => type + "!"
        },
        // Type System Definitions
        SchemaDefinition: {
          leave: ({ description, directives, operationTypes }) => wrap("", description, "\n") + join(["schema", join(directives, " "), block(operationTypes)], " ")
        },
        OperationTypeDefinition: {
          leave: ({ operation, type }) => operation + ": " + type
        },
        ScalarTypeDefinition: {
          leave: ({ description, name, directives }) => wrap("", description, "\n") + join(["scalar", name, join(directives, " ")], " ")
        },
        ObjectTypeDefinition: {
          leave: ({ description, name, interfaces, directives, fields }) => wrap("", description, "\n") + join(
            [
              "type",
              name,
              wrap("implements ", join(interfaces, " & ")),
              join(directives, " "),
              block(fields)
            ],
            " "
          )
        },
        FieldDefinition: {
          leave: ({ description, name, arguments: args, type, directives }) => wrap("", description, "\n") + name + (hasMultilineItems(args) ? wrap("(\n", indent(join(args, "\n")), "\n)") : wrap("(", join(args, ", "), ")")) + ": " + type + wrap(" ", join(directives, " "))
        },
        InputValueDefinition: {
          leave: ({ description, name, type, defaultValue, directives }) => wrap("", description, "\n") + join(
            [name + ": " + type, wrap("= ", defaultValue), join(directives, " ")],
            " "
          )
        },
        InterfaceTypeDefinition: {
          leave: ({ description, name, interfaces, directives, fields }) => wrap("", description, "\n") + join(
            [
              "interface",
              name,
              wrap("implements ", join(interfaces, " & ")),
              join(directives, " "),
              block(fields)
            ],
            " "
          )
        },
        UnionTypeDefinition: {
          leave: ({ description, name, directives, types }) => wrap("", description, "\n") + join(
            ["union", name, join(directives, " "), wrap("= ", join(types, " | "))],
            " "
          )
        },
        EnumTypeDefinition: {
          leave: ({ description, name, directives, values }) => wrap("", description, "\n") + join(["enum", name, join(directives, " "), block(values)], " ")
        },
        EnumValueDefinition: {
          leave: ({ description, name, directives }) => wrap("", description, "\n") + join([name, join(directives, " ")], " ")
        },
        InputObjectTypeDefinition: {
          leave: ({ description, name, directives, fields }) => wrap("", description, "\n") + join(["input", name, join(directives, " "), block(fields)], " ")
        },
        DirectiveDefinition: {
          leave: ({ description, name, arguments: args, repeatable, locations }) => wrap("", description, "\n") + "directive @" + name + (hasMultilineItems(args) ? wrap("(\n", indent(join(args, "\n")), "\n)") : wrap("(", join(args, ", "), ")")) + (repeatable ? " repeatable" : "") + " on " + join(locations, " | ")
        },
        SchemaExtension: {
          leave: ({ directives, operationTypes }) => join(
            ["extend schema", join(directives, " "), block(operationTypes)],
            " "
          )
        },
        ScalarTypeExtension: {
          leave: ({ name, directives }) => join(["extend scalar", name, join(directives, " ")], " ")
        },
        ObjectTypeExtension: {
          leave: ({ name, interfaces, directives, fields }) => join(
            [
              "extend type",
              name,
              wrap("implements ", join(interfaces, " & ")),
              join(directives, " "),
              block(fields)
            ],
            " "
          )
        },
        InterfaceTypeExtension: {
          leave: ({ name, interfaces, directives, fields }) => join(
            [
              "extend interface",
              name,
              wrap("implements ", join(interfaces, " & ")),
              join(directives, " "),
              block(fields)
            ],
            " "
          )
        },
        UnionTypeExtension: {
          leave: ({ name, directives, types }) => join(
            [
              "extend union",
              name,
              join(directives, " "),
              wrap("= ", join(types, " | "))
            ],
            " "
          )
        },
        EnumTypeExtension: {
          leave: ({ name, directives, values }) => join(["extend enum", name, join(directives, " "), block(values)], " ")
        },
        InputObjectTypeExtension: {
          leave: ({ name, directives, fields }) => join(["extend input", name, join(directives, " "), block(fields)], " ")
        }
      };
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/utilities/valueFromASTUntyped.mjs
  function valueFromASTUntyped(valueNode, variables) {
    switch (valueNode.kind) {
      case Kind.NULL:
        return null;
      case Kind.INT:
        return parseInt(valueNode.value, 10);
      case Kind.FLOAT:
        return parseFloat(valueNode.value);
      case Kind.STRING:
      case Kind.ENUM:
      case Kind.BOOLEAN:
        return valueNode.value;
      case Kind.LIST:
        return valueNode.values.map(
          (node) => valueFromASTUntyped(node, variables)
        );
      case Kind.OBJECT:
        return keyValMap(
          valueNode.fields,
          (field) => field.name.value,
          (field) => valueFromASTUntyped(field.value, variables)
        );
      case Kind.VARIABLE:
        return variables === null || variables === void 0 ? void 0 : variables[valueNode.name.value];
    }
  }
  var init_valueFromASTUntyped = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/utilities/valueFromASTUntyped.mjs"() {
      "use strict";
      init_keyValMap();
      init_kinds();
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/type/assertName.mjs
  function assertName(name) {
    name != null || devAssert(false, "Must provide name.");
    typeof name === "string" || devAssert(false, "Expected name to be a string.");
    if (name.length === 0) {
      throw new GraphQLError("Expected name to be a non-empty string.");
    }
    for (let i = 1; i < name.length; ++i) {
      if (!isNameContinue(name.charCodeAt(i))) {
        throw new GraphQLError(
          `Names must only contain [_a-zA-Z0-9] but "${name}" does not.`
        );
      }
    }
    if (!isNameStart(name.charCodeAt(0))) {
      throw new GraphQLError(
        `Names must start with [_a-zA-Z] but "${name}" does not.`
      );
    }
    return name;
  }
  function assertEnumValueName(name) {
    if (name === "true" || name === "false" || name === "null") {
      throw new GraphQLError(`Enum values cannot be named: ${name}`);
    }
    return assertName(name);
  }
  var init_assertName = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/type/assertName.mjs"() {
      "use strict";
      init_devAssert();
      init_GraphQLError();
      init_characterClasses();
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/type/definition.mjs
  function isType(type) {
    return isScalarType(type) || isObjectType(type) || isInterfaceType(type) || isUnionType(type) || isEnumType(type) || isInputObjectType(type) || isListType(type) || isNonNullType(type);
  }
  function assertType(type) {
    if (!isType(type)) {
      throw new Error(`Expected ${inspect(type)} to be a GraphQL type.`);
    }
    return type;
  }
  function isScalarType(type) {
    return instanceOf(type, GraphQLScalarType);
  }
  function assertScalarType(type) {
    if (!isScalarType(type)) {
      throw new Error(`Expected ${inspect(type)} to be a GraphQL Scalar type.`);
    }
    return type;
  }
  function isObjectType(type) {
    return instanceOf(type, GraphQLObjectType);
  }
  function assertObjectType(type) {
    if (!isObjectType(type)) {
      throw new Error(`Expected ${inspect(type)} to be a GraphQL Object type.`);
    }
    return type;
  }
  function isInterfaceType(type) {
    return instanceOf(type, GraphQLInterfaceType);
  }
  function assertInterfaceType(type) {
    if (!isInterfaceType(type)) {
      throw new Error(
        `Expected ${inspect(type)} to be a GraphQL Interface type.`
      );
    }
    return type;
  }
  function isUnionType(type) {
    return instanceOf(type, GraphQLUnionType);
  }
  function assertUnionType(type) {
    if (!isUnionType(type)) {
      throw new Error(`Expected ${inspect(type)} to be a GraphQL Union type.`);
    }
    return type;
  }
  function isEnumType(type) {
    return instanceOf(type, GraphQLEnumType);
  }
  function assertEnumType(type) {
    if (!isEnumType(type)) {
      throw new Error(`Expected ${inspect(type)} to be a GraphQL Enum type.`);
    }
    return type;
  }
  function isInputObjectType(type) {
    return instanceOf(type, GraphQLInputObjectType);
  }
  function assertInputObjectType(type) {
    if (!isInputObjectType(type)) {
      throw new Error(
        `Expected ${inspect(type)} to be a GraphQL Input Object type.`
      );
    }
    return type;
  }
  function isListType(type) {
    return instanceOf(type, GraphQLList);
  }
  function assertListType(type) {
    if (!isListType(type)) {
      throw new Error(`Expected ${inspect(type)} to be a GraphQL List type.`);
    }
    return type;
  }
  function isNonNullType(type) {
    return instanceOf(type, GraphQLNonNull);
  }
  function assertNonNullType(type) {
    if (!isNonNullType(type)) {
      throw new Error(`Expected ${inspect(type)} to be a GraphQL Non-Null type.`);
    }
    return type;
  }
  function isInputType(type) {
    return isScalarType(type) || isEnumType(type) || isInputObjectType(type) || isWrappingType(type) && isInputType(type.ofType);
  }
  function assertInputType(type) {
    if (!isInputType(type)) {
      throw new Error(`Expected ${inspect(type)} to be a GraphQL input type.`);
    }
    return type;
  }
  function isOutputType(type) {
    return isScalarType(type) || isObjectType(type) || isInterfaceType(type) || isUnionType(type) || isEnumType(type) || isWrappingType(type) && isOutputType(type.ofType);
  }
  function assertOutputType(type) {
    if (!isOutputType(type)) {
      throw new Error(`Expected ${inspect(type)} to be a GraphQL output type.`);
    }
    return type;
  }
  function isLeafType(type) {
    return isScalarType(type) || isEnumType(type);
  }
  function assertLeafType(type) {
    if (!isLeafType(type)) {
      throw new Error(`Expected ${inspect(type)} to be a GraphQL leaf type.`);
    }
    return type;
  }
  function isCompositeType(type) {
    return isObjectType(type) || isInterfaceType(type) || isUnionType(type);
  }
  function assertCompositeType(type) {
    if (!isCompositeType(type)) {
      throw new Error(
        `Expected ${inspect(type)} to be a GraphQL composite type.`
      );
    }
    return type;
  }
  function isAbstractType(type) {
    return isInterfaceType(type) || isUnionType(type);
  }
  function assertAbstractType(type) {
    if (!isAbstractType(type)) {
      throw new Error(`Expected ${inspect(type)} to be a GraphQL abstract type.`);
    }
    return type;
  }
  function isWrappingType(type) {
    return isListType(type) || isNonNullType(type);
  }
  function assertWrappingType(type) {
    if (!isWrappingType(type)) {
      throw new Error(`Expected ${inspect(type)} to be a GraphQL wrapping type.`);
    }
    return type;
  }
  function isNullableType(type) {
    return isType(type) && !isNonNullType(type);
  }
  function assertNullableType(type) {
    if (!isNullableType(type)) {
      throw new Error(`Expected ${inspect(type)} to be a GraphQL nullable type.`);
    }
    return type;
  }
  function getNullableType(type) {
    if (type) {
      return isNonNullType(type) ? type.ofType : type;
    }
  }
  function isNamedType(type) {
    return isScalarType(type) || isObjectType(type) || isInterfaceType(type) || isUnionType(type) || isEnumType(type) || isInputObjectType(type);
  }
  function assertNamedType(type) {
    if (!isNamedType(type)) {
      throw new Error(`Expected ${inspect(type)} to be a GraphQL named type.`);
    }
    return type;
  }
  function getNamedType(type) {
    if (type) {
      let unwrappedType = type;
      while (isWrappingType(unwrappedType)) {
        unwrappedType = unwrappedType.ofType;
      }
      return unwrappedType;
    }
  }
  function resolveReadonlyArrayThunk(thunk) {
    return typeof thunk === "function" ? thunk() : thunk;
  }
  function resolveObjMapThunk(thunk) {
    return typeof thunk === "function" ? thunk() : thunk;
  }
  function defineInterfaces(config) {
    var _config$interfaces;
    const interfaces = resolveReadonlyArrayThunk(
      (_config$interfaces = config.interfaces) !== null && _config$interfaces !== void 0 ? _config$interfaces : []
    );
    Array.isArray(interfaces) || devAssert(
      false,
      `${config.name} interfaces must be an Array or a function which returns an Array.`
    );
    return interfaces;
  }
  function defineFieldMap(config) {
    const fieldMap = resolveObjMapThunk(config.fields);
    isPlainObj(fieldMap) || devAssert(
      false,
      `${config.name} fields must be an object with field names as keys or a function which returns such an object.`
    );
    return mapValue(fieldMap, (fieldConfig, fieldName) => {
      var _fieldConfig$args;
      isPlainObj(fieldConfig) || devAssert(
        false,
        `${config.name}.${fieldName} field config must be an object.`
      );
      fieldConfig.resolve == null || typeof fieldConfig.resolve === "function" || devAssert(
        false,
        `${config.name}.${fieldName} field resolver must be a function if provided, but got: ${inspect(fieldConfig.resolve)}.`
      );
      const argsConfig = (_fieldConfig$args = fieldConfig.args) !== null && _fieldConfig$args !== void 0 ? _fieldConfig$args : {};
      isPlainObj(argsConfig) || devAssert(
        false,
        `${config.name}.${fieldName} args must be an object with argument names as keys.`
      );
      return {
        name: assertName(fieldName),
        description: fieldConfig.description,
        type: fieldConfig.type,
        args: defineArguments(argsConfig),
        resolve: fieldConfig.resolve,
        subscribe: fieldConfig.subscribe,
        deprecationReason: fieldConfig.deprecationReason,
        extensions: toObjMap(fieldConfig.extensions),
        astNode: fieldConfig.astNode
      };
    });
  }
  function defineArguments(config) {
    return Object.entries(config).map(([argName, argConfig]) => ({
      name: assertName(argName),
      description: argConfig.description,
      type: argConfig.type,
      defaultValue: argConfig.defaultValue,
      deprecationReason: argConfig.deprecationReason,
      extensions: toObjMap(argConfig.extensions),
      astNode: argConfig.astNode
    }));
  }
  function isPlainObj(obj) {
    return isObjectLike(obj) && !Array.isArray(obj);
  }
  function fieldsToFieldsConfig(fields) {
    return mapValue(fields, (field) => ({
      description: field.description,
      type: field.type,
      args: argsToArgsConfig(field.args),
      resolve: field.resolve,
      subscribe: field.subscribe,
      deprecationReason: field.deprecationReason,
      extensions: field.extensions,
      astNode: field.astNode
    }));
  }
  function argsToArgsConfig(args) {
    return keyValMap(
      args,
      (arg) => arg.name,
      (arg) => ({
        description: arg.description,
        type: arg.type,
        defaultValue: arg.defaultValue,
        deprecationReason: arg.deprecationReason,
        extensions: arg.extensions,
        astNode: arg.astNode
      })
    );
  }
  function isRequiredArgument(arg) {
    return isNonNullType(arg.type) && arg.defaultValue === void 0;
  }
  function defineTypes(config) {
    const types = resolveReadonlyArrayThunk(config.types);
    Array.isArray(types) || devAssert(
      false,
      `Must provide Array of types or a function which returns such an array for Union ${config.name}.`
    );
    return types;
  }
  function didYouMeanEnumValue(enumType, unknownValueStr) {
    const allNames = enumType.getValues().map((value) => value.name);
    const suggestedValues = suggestionList(unknownValueStr, allNames);
    return didYouMean("the enum value", suggestedValues);
  }
  function defineEnumValues(typeName, valueMap) {
    isPlainObj(valueMap) || devAssert(
      false,
      `${typeName} values must be an object with value names as keys.`
    );
    return Object.entries(valueMap).map(([valueName, valueConfig]) => {
      isPlainObj(valueConfig) || devAssert(
        false,
        `${typeName}.${valueName} must refer to an object with a "value" key representing an internal value but got: ${inspect(valueConfig)}.`
      );
      return {
        name: assertEnumValueName(valueName),
        description: valueConfig.description,
        value: valueConfig.value !== void 0 ? valueConfig.value : valueName,
        deprecationReason: valueConfig.deprecationReason,
        extensions: toObjMap(valueConfig.extensions),
        astNode: valueConfig.astNode
      };
    });
  }
  function defineInputFieldMap(config) {
    const fieldMap = resolveObjMapThunk(config.fields);
    isPlainObj(fieldMap) || devAssert(
      false,
      `${config.name} fields must be an object with field names as keys or a function which returns such an object.`
    );
    return mapValue(fieldMap, (fieldConfig, fieldName) => {
      !("resolve" in fieldConfig) || devAssert(
        false,
        `${config.name}.${fieldName} field has a resolve property, but Input Types cannot define resolvers.`
      );
      return {
        name: assertName(fieldName),
        description: fieldConfig.description,
        type: fieldConfig.type,
        defaultValue: fieldConfig.defaultValue,
        deprecationReason: fieldConfig.deprecationReason,
        extensions: toObjMap(fieldConfig.extensions),
        astNode: fieldConfig.astNode
      };
    });
  }
  function isRequiredInputField(field) {
    return isNonNullType(field.type) && field.defaultValue === void 0;
  }
  var GraphQLList, GraphQLNonNull, GraphQLScalarType, GraphQLObjectType, GraphQLInterfaceType, GraphQLUnionType, GraphQLEnumType, GraphQLInputObjectType;
  var init_definition = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/type/definition.mjs"() {
      "use strict";
      init_devAssert();
      init_didYouMean();
      init_identityFunc();
      init_inspect();
      init_instanceOf();
      init_isObjectLike();
      init_keyMap();
      init_keyValMap();
      init_mapValue();
      init_suggestionList();
      init_toObjMap();
      init_GraphQLError();
      init_kinds();
      init_printer();
      init_valueFromASTUntyped();
      init_assertName();
      GraphQLList = class {
        constructor(ofType) {
          isType(ofType) || devAssert(false, `Expected ${inspect(ofType)} to be a GraphQL type.`);
          this.ofType = ofType;
        }
        get [Symbol.toStringTag]() {
          return "GraphQLList";
        }
        toString() {
          return "[" + String(this.ofType) + "]";
        }
        toJSON() {
          return this.toString();
        }
      };
      GraphQLNonNull = class {
        constructor(ofType) {
          isNullableType(ofType) || devAssert(
            false,
            `Expected ${inspect(ofType)} to be a GraphQL nullable type.`
          );
          this.ofType = ofType;
        }
        get [Symbol.toStringTag]() {
          return "GraphQLNonNull";
        }
        toString() {
          return String(this.ofType) + "!";
        }
        toJSON() {
          return this.toString();
        }
      };
      GraphQLScalarType = class {
        constructor(config) {
          var _config$parseValue, _config$serialize, _config$parseLiteral, _config$extensionASTN;
          const parseValue2 = (_config$parseValue = config.parseValue) !== null && _config$parseValue !== void 0 ? _config$parseValue : identityFunc;
          this.name = assertName(config.name);
          this.description = config.description;
          this.specifiedByURL = config.specifiedByURL;
          this.serialize = (_config$serialize = config.serialize) !== null && _config$serialize !== void 0 ? _config$serialize : identityFunc;
          this.parseValue = parseValue2;
          this.parseLiteral = (_config$parseLiteral = config.parseLiteral) !== null && _config$parseLiteral !== void 0 ? _config$parseLiteral : (node, variables) => parseValue2(valueFromASTUntyped(node, variables));
          this.extensions = toObjMap(config.extensions);
          this.astNode = config.astNode;
          this.extensionASTNodes = (_config$extensionASTN = config.extensionASTNodes) !== null && _config$extensionASTN !== void 0 ? _config$extensionASTN : [];
          config.specifiedByURL == null || typeof config.specifiedByURL === "string" || devAssert(
            false,
            `${this.name} must provide "specifiedByURL" as a string, but got: ${inspect(config.specifiedByURL)}.`
          );
          config.serialize == null || typeof config.serialize === "function" || devAssert(
            false,
            `${this.name} must provide "serialize" function. If this custom Scalar is also used as an input type, ensure "parseValue" and "parseLiteral" functions are also provided.`
          );
          if (config.parseLiteral) {
            typeof config.parseValue === "function" && typeof config.parseLiteral === "function" || devAssert(
              false,
              `${this.name} must provide both "parseValue" and "parseLiteral" functions.`
            );
          }
        }
        get [Symbol.toStringTag]() {
          return "GraphQLScalarType";
        }
        toConfig() {
          return {
            name: this.name,
            description: this.description,
            specifiedByURL: this.specifiedByURL,
            serialize: this.serialize,
            parseValue: this.parseValue,
            parseLiteral: this.parseLiteral,
            extensions: this.extensions,
            astNode: this.astNode,
            extensionASTNodes: this.extensionASTNodes
          };
        }
        toString() {
          return this.name;
        }
        toJSON() {
          return this.toString();
        }
      };
      GraphQLObjectType = class {
        constructor(config) {
          var _config$extensionASTN2;
          this.name = assertName(config.name);
          this.description = config.description;
          this.isTypeOf = config.isTypeOf;
          this.extensions = toObjMap(config.extensions);
          this.astNode = config.astNode;
          this.extensionASTNodes = (_config$extensionASTN2 = config.extensionASTNodes) !== null && _config$extensionASTN2 !== void 0 ? _config$extensionASTN2 : [];
          this._fields = () => defineFieldMap(config);
          this._interfaces = () => defineInterfaces(config);
          config.isTypeOf == null || typeof config.isTypeOf === "function" || devAssert(
            false,
            `${this.name} must provide "isTypeOf" as a function, but got: ${inspect(config.isTypeOf)}.`
          );
        }
        get [Symbol.toStringTag]() {
          return "GraphQLObjectType";
        }
        getFields() {
          if (typeof this._fields === "function") {
            this._fields = this._fields();
          }
          return this._fields;
        }
        getInterfaces() {
          if (typeof this._interfaces === "function") {
            this._interfaces = this._interfaces();
          }
          return this._interfaces;
        }
        toConfig() {
          return {
            name: this.name,
            description: this.description,
            interfaces: this.getInterfaces(),
            fields: fieldsToFieldsConfig(this.getFields()),
            isTypeOf: this.isTypeOf,
            extensions: this.extensions,
            astNode: this.astNode,
            extensionASTNodes: this.extensionASTNodes
          };
        }
        toString() {
          return this.name;
        }
        toJSON() {
          return this.toString();
        }
      };
      GraphQLInterfaceType = class {
        constructor(config) {
          var _config$extensionASTN3;
          this.name = assertName(config.name);
          this.description = config.description;
          this.resolveType = config.resolveType;
          this.extensions = toObjMap(config.extensions);
          this.astNode = config.astNode;
          this.extensionASTNodes = (_config$extensionASTN3 = config.extensionASTNodes) !== null && _config$extensionASTN3 !== void 0 ? _config$extensionASTN3 : [];
          this._fields = defineFieldMap.bind(void 0, config);
          this._interfaces = defineInterfaces.bind(void 0, config);
          config.resolveType == null || typeof config.resolveType === "function" || devAssert(
            false,
            `${this.name} must provide "resolveType" as a function, but got: ${inspect(config.resolveType)}.`
          );
        }
        get [Symbol.toStringTag]() {
          return "GraphQLInterfaceType";
        }
        getFields() {
          if (typeof this._fields === "function") {
            this._fields = this._fields();
          }
          return this._fields;
        }
        getInterfaces() {
          if (typeof this._interfaces === "function") {
            this._interfaces = this._interfaces();
          }
          return this._interfaces;
        }
        toConfig() {
          return {
            name: this.name,
            description: this.description,
            interfaces: this.getInterfaces(),
            fields: fieldsToFieldsConfig(this.getFields()),
            resolveType: this.resolveType,
            extensions: this.extensions,
            astNode: this.astNode,
            extensionASTNodes: this.extensionASTNodes
          };
        }
        toString() {
          return this.name;
        }
        toJSON() {
          return this.toString();
        }
      };
      GraphQLUnionType = class {
        constructor(config) {
          var _config$extensionASTN4;
          this.name = assertName(config.name);
          this.description = config.description;
          this.resolveType = config.resolveType;
          this.extensions = toObjMap(config.extensions);
          this.astNode = config.astNode;
          this.extensionASTNodes = (_config$extensionASTN4 = config.extensionASTNodes) !== null && _config$extensionASTN4 !== void 0 ? _config$extensionASTN4 : [];
          this._types = defineTypes.bind(void 0, config);
          config.resolveType == null || typeof config.resolveType === "function" || devAssert(
            false,
            `${this.name} must provide "resolveType" as a function, but got: ${inspect(config.resolveType)}.`
          );
        }
        get [Symbol.toStringTag]() {
          return "GraphQLUnionType";
        }
        getTypes() {
          if (typeof this._types === "function") {
            this._types = this._types();
          }
          return this._types;
        }
        toConfig() {
          return {
            name: this.name,
            description: this.description,
            types: this.getTypes(),
            resolveType: this.resolveType,
            extensions: this.extensions,
            astNode: this.astNode,
            extensionASTNodes: this.extensionASTNodes
          };
        }
        toString() {
          return this.name;
        }
        toJSON() {
          return this.toString();
        }
      };
      GraphQLEnumType = class {
        /* <T> */
        constructor(config) {
          var _config$extensionASTN5;
          this.name = assertName(config.name);
          this.description = config.description;
          this.extensions = toObjMap(config.extensions);
          this.astNode = config.astNode;
          this.extensionASTNodes = (_config$extensionASTN5 = config.extensionASTNodes) !== null && _config$extensionASTN5 !== void 0 ? _config$extensionASTN5 : [];
          this._values = defineEnumValues(this.name, config.values);
          this._valueLookup = new Map(
            this._values.map((enumValue) => [enumValue.value, enumValue])
          );
          this._nameLookup = keyMap(this._values, (value) => value.name);
        }
        get [Symbol.toStringTag]() {
          return "GraphQLEnumType";
        }
        getValues() {
          return this._values;
        }
        getValue(name) {
          return this._nameLookup[name];
        }
        serialize(outputValue) {
          const enumValue = this._valueLookup.get(outputValue);
          if (enumValue === void 0) {
            throw new GraphQLError(
              `Enum "${this.name}" cannot represent value: ${inspect(outputValue)}`
            );
          }
          return enumValue.name;
        }
        parseValue(inputValue) {
          if (typeof inputValue !== "string") {
            const valueStr = inspect(inputValue);
            throw new GraphQLError(
              `Enum "${this.name}" cannot represent non-string value: ${valueStr}.` + didYouMeanEnumValue(this, valueStr)
            );
          }
          const enumValue = this.getValue(inputValue);
          if (enumValue == null) {
            throw new GraphQLError(
              `Value "${inputValue}" does not exist in "${this.name}" enum.` + didYouMeanEnumValue(this, inputValue)
            );
          }
          return enumValue.value;
        }
        parseLiteral(valueNode, _variables) {
          if (valueNode.kind !== Kind.ENUM) {
            const valueStr = print(valueNode);
            throw new GraphQLError(
              `Enum "${this.name}" cannot represent non-enum value: ${valueStr}.` + didYouMeanEnumValue(this, valueStr),
              {
                nodes: valueNode
              }
            );
          }
          const enumValue = this.getValue(valueNode.value);
          if (enumValue == null) {
            const valueStr = print(valueNode);
            throw new GraphQLError(
              `Value "${valueStr}" does not exist in "${this.name}" enum.` + didYouMeanEnumValue(this, valueStr),
              {
                nodes: valueNode
              }
            );
          }
          return enumValue.value;
        }
        toConfig() {
          const values = keyValMap(
            this.getValues(),
            (value) => value.name,
            (value) => ({
              description: value.description,
              value: value.value,
              deprecationReason: value.deprecationReason,
              extensions: value.extensions,
              astNode: value.astNode
            })
          );
          return {
            name: this.name,
            description: this.description,
            values,
            extensions: this.extensions,
            astNode: this.astNode,
            extensionASTNodes: this.extensionASTNodes
          };
        }
        toString() {
          return this.name;
        }
        toJSON() {
          return this.toString();
        }
      };
      GraphQLInputObjectType = class {
        constructor(config) {
          var _config$extensionASTN6;
          this.name = assertName(config.name);
          this.description = config.description;
          this.extensions = toObjMap(config.extensions);
          this.astNode = config.astNode;
          this.extensionASTNodes = (_config$extensionASTN6 = config.extensionASTNodes) !== null && _config$extensionASTN6 !== void 0 ? _config$extensionASTN6 : [];
          this._fields = defineInputFieldMap.bind(void 0, config);
        }
        get [Symbol.toStringTag]() {
          return "GraphQLInputObjectType";
        }
        getFields() {
          if (typeof this._fields === "function") {
            this._fields = this._fields();
          }
          return this._fields;
        }
        toConfig() {
          const fields = mapValue(this.getFields(), (field) => ({
            description: field.description,
            type: field.type,
            defaultValue: field.defaultValue,
            deprecationReason: field.deprecationReason,
            extensions: field.extensions,
            astNode: field.astNode
          }));
          return {
            name: this.name,
            description: this.description,
            fields,
            extensions: this.extensions,
            astNode: this.astNode,
            extensionASTNodes: this.extensionASTNodes
          };
        }
        toString() {
          return this.name;
        }
        toJSON() {
          return this.toString();
        }
      };
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/utilities/typeComparators.mjs
  function isEqualType(typeA, typeB) {
    if (typeA === typeB) {
      return true;
    }
    if (isNonNullType(typeA) && isNonNullType(typeB)) {
      return isEqualType(typeA.ofType, typeB.ofType);
    }
    if (isListType(typeA) && isListType(typeB)) {
      return isEqualType(typeA.ofType, typeB.ofType);
    }
    return false;
  }
  function isTypeSubTypeOf(schema, maybeSubType, superType) {
    if (maybeSubType === superType) {
      return true;
    }
    if (isNonNullType(superType)) {
      if (isNonNullType(maybeSubType)) {
        return isTypeSubTypeOf(schema, maybeSubType.ofType, superType.ofType);
      }
      return false;
    }
    if (isNonNullType(maybeSubType)) {
      return isTypeSubTypeOf(schema, maybeSubType.ofType, superType);
    }
    if (isListType(superType)) {
      if (isListType(maybeSubType)) {
        return isTypeSubTypeOf(schema, maybeSubType.ofType, superType.ofType);
      }
      return false;
    }
    if (isListType(maybeSubType)) {
      return false;
    }
    return isAbstractType(superType) && (isInterfaceType(maybeSubType) || isObjectType(maybeSubType)) && schema.isSubType(superType, maybeSubType);
  }
  function doTypesOverlap(schema, typeA, typeB) {
    if (typeA === typeB) {
      return true;
    }
    if (isAbstractType(typeA)) {
      if (isAbstractType(typeB)) {
        return schema.getPossibleTypes(typeA).some((type) => schema.isSubType(typeB, type));
      }
      return schema.isSubType(typeA, typeB);
    }
    if (isAbstractType(typeB)) {
      return schema.isSubType(typeB, typeA);
    }
    return false;
  }
  var init_typeComparators = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/utilities/typeComparators.mjs"() {
      "use strict";
      init_definition();
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/type/scalars.mjs
  function isSpecifiedScalarType(type) {
    return specifiedScalarTypes.some(({ name }) => type.name === name);
  }
  function serializeObject(outputValue) {
    if (isObjectLike(outputValue)) {
      if (typeof outputValue.valueOf === "function") {
        const valueOfResult = outputValue.valueOf();
        if (!isObjectLike(valueOfResult)) {
          return valueOfResult;
        }
      }
      if (typeof outputValue.toJSON === "function") {
        return outputValue.toJSON();
      }
    }
    return outputValue;
  }
  var GRAPHQL_MAX_INT, GRAPHQL_MIN_INT, GraphQLInt, GraphQLFloat, GraphQLString, GraphQLBoolean, GraphQLID, specifiedScalarTypes;
  var init_scalars = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/type/scalars.mjs"() {
      "use strict";
      init_inspect();
      init_isObjectLike();
      init_GraphQLError();
      init_kinds();
      init_printer();
      init_definition();
      GRAPHQL_MAX_INT = 2147483647;
      GRAPHQL_MIN_INT = -2147483648;
      GraphQLInt = new GraphQLScalarType({
        name: "Int",
        description: "The `Int` scalar type represents non-fractional signed whole numeric values. Int can represent values between -(2^31) and 2^31 - 1.",
        serialize(outputValue) {
          const coercedValue = serializeObject(outputValue);
          if (typeof coercedValue === "boolean") {
            return coercedValue ? 1 : 0;
          }
          let num = coercedValue;
          if (typeof coercedValue === "string" && coercedValue !== "") {
            num = Number(coercedValue);
          }
          if (typeof num !== "number" || !Number.isInteger(num)) {
            throw new GraphQLError(
              `Int cannot represent non-integer value: ${inspect(coercedValue)}`
            );
          }
          if (num > GRAPHQL_MAX_INT || num < GRAPHQL_MIN_INT) {
            throw new GraphQLError(
              "Int cannot represent non 32-bit signed integer value: " + inspect(coercedValue)
            );
          }
          return num;
        },
        parseValue(inputValue) {
          if (typeof inputValue !== "number" || !Number.isInteger(inputValue)) {
            throw new GraphQLError(
              `Int cannot represent non-integer value: ${inspect(inputValue)}`
            );
          }
          if (inputValue > GRAPHQL_MAX_INT || inputValue < GRAPHQL_MIN_INT) {
            throw new GraphQLError(
              `Int cannot represent non 32-bit signed integer value: ${inputValue}`
            );
          }
          return inputValue;
        },
        parseLiteral(valueNode) {
          if (valueNode.kind !== Kind.INT) {
            throw new GraphQLError(
              `Int cannot represent non-integer value: ${print(valueNode)}`,
              {
                nodes: valueNode
              }
            );
          }
          const num = parseInt(valueNode.value, 10);
          if (num > GRAPHQL_MAX_INT || num < GRAPHQL_MIN_INT) {
            throw new GraphQLError(
              `Int cannot represent non 32-bit signed integer value: ${valueNode.value}`,
              {
                nodes: valueNode
              }
            );
          }
          return num;
        }
      });
      GraphQLFloat = new GraphQLScalarType({
        name: "Float",
        description: "The `Float` scalar type represents signed double-precision fractional values as specified by [IEEE 754](https://en.wikipedia.org/wiki/IEEE_floating_point).",
        serialize(outputValue) {
          const coercedValue = serializeObject(outputValue);
          if (typeof coercedValue === "boolean") {
            return coercedValue ? 1 : 0;
          }
          let num = coercedValue;
          if (typeof coercedValue === "string" && coercedValue !== "") {
            num = Number(coercedValue);
          }
          if (typeof num !== "number" || !Number.isFinite(num)) {
            throw new GraphQLError(
              `Float cannot represent non numeric value: ${inspect(coercedValue)}`
            );
          }
          return num;
        },
        parseValue(inputValue) {
          if (typeof inputValue !== "number" || !Number.isFinite(inputValue)) {
            throw new GraphQLError(
              `Float cannot represent non numeric value: ${inspect(inputValue)}`
            );
          }
          return inputValue;
        },
        parseLiteral(valueNode) {
          if (valueNode.kind !== Kind.FLOAT && valueNode.kind !== Kind.INT) {
            throw new GraphQLError(
              `Float cannot represent non numeric value: ${print(valueNode)}`,
              valueNode
            );
          }
          return parseFloat(valueNode.value);
        }
      });
      GraphQLString = new GraphQLScalarType({
        name: "String",
        description: "The `String` scalar type represents textual data, represented as UTF-8 character sequences. The String type is most often used by GraphQL to represent free-form human-readable text.",
        serialize(outputValue) {
          const coercedValue = serializeObject(outputValue);
          if (typeof coercedValue === "string") {
            return coercedValue;
          }
          if (typeof coercedValue === "boolean") {
            return coercedValue ? "true" : "false";
          }
          if (typeof coercedValue === "number" && Number.isFinite(coercedValue)) {
            return coercedValue.toString();
          }
          throw new GraphQLError(
            `String cannot represent value: ${inspect(outputValue)}`
          );
        },
        parseValue(inputValue) {
          if (typeof inputValue !== "string") {
            throw new GraphQLError(
              `String cannot represent a non string value: ${inspect(inputValue)}`
            );
          }
          return inputValue;
        },
        parseLiteral(valueNode) {
          if (valueNode.kind !== Kind.STRING) {
            throw new GraphQLError(
              `String cannot represent a non string value: ${print(valueNode)}`,
              {
                nodes: valueNode
              }
            );
          }
          return valueNode.value;
        }
      });
      GraphQLBoolean = new GraphQLScalarType({
        name: "Boolean",
        description: "The `Boolean` scalar type represents `true` or `false`.",
        serialize(outputValue) {
          const coercedValue = serializeObject(outputValue);
          if (typeof coercedValue === "boolean") {
            return coercedValue;
          }
          if (Number.isFinite(coercedValue)) {
            return coercedValue !== 0;
          }
          throw new GraphQLError(
            `Boolean cannot represent a non boolean value: ${inspect(coercedValue)}`
          );
        },
        parseValue(inputValue) {
          if (typeof inputValue !== "boolean") {
            throw new GraphQLError(
              `Boolean cannot represent a non boolean value: ${inspect(inputValue)}`
            );
          }
          return inputValue;
        },
        parseLiteral(valueNode) {
          if (valueNode.kind !== Kind.BOOLEAN) {
            throw new GraphQLError(
              `Boolean cannot represent a non boolean value: ${print(valueNode)}`,
              {
                nodes: valueNode
              }
            );
          }
          return valueNode.value;
        }
      });
      GraphQLID = new GraphQLScalarType({
        name: "ID",
        description: 'The `ID` scalar type represents a unique identifier, often used to refetch an object or as key for a cache. The ID type appears in a JSON response as a String; however, it is not intended to be human-readable. When expected as an input type, any string (such as `"4"`) or integer (such as `4`) input value will be accepted as an ID.',
        serialize(outputValue) {
          const coercedValue = serializeObject(outputValue);
          if (typeof coercedValue === "string") {
            return coercedValue;
          }
          if (Number.isInteger(coercedValue)) {
            return String(coercedValue);
          }
          throw new GraphQLError(
            `ID cannot represent value: ${inspect(outputValue)}`
          );
        },
        parseValue(inputValue) {
          if (typeof inputValue === "string") {
            return inputValue;
          }
          if (typeof inputValue === "number" && Number.isInteger(inputValue)) {
            return inputValue.toString();
          }
          throw new GraphQLError(`ID cannot represent value: ${inspect(inputValue)}`);
        },
        parseLiteral(valueNode) {
          if (valueNode.kind !== Kind.STRING && valueNode.kind !== Kind.INT) {
            throw new GraphQLError(
              "ID cannot represent a non-string and non-integer value: " + print(valueNode),
              {
                nodes: valueNode
              }
            );
          }
          return valueNode.value;
        }
      });
      specifiedScalarTypes = Object.freeze([
        GraphQLString,
        GraphQLInt,
        GraphQLFloat,
        GraphQLBoolean,
        GraphQLID
      ]);
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/type/directives.mjs
  function isDirective(directive) {
    return instanceOf(directive, GraphQLDirective);
  }
  function assertDirective(directive) {
    if (!isDirective(directive)) {
      throw new Error(
        `Expected ${inspect(directive)} to be a GraphQL directive.`
      );
    }
    return directive;
  }
  function isSpecifiedDirective(directive) {
    return specifiedDirectives.some(({ name }) => name === directive.name);
  }
  var GraphQLDirective, GraphQLIncludeDirective, GraphQLSkipDirective, DEFAULT_DEPRECATION_REASON, GraphQLDeprecatedDirective, GraphQLSpecifiedByDirective, specifiedDirectives;
  var init_directives = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/type/directives.mjs"() {
      "use strict";
      init_devAssert();
      init_inspect();
      init_instanceOf();
      init_isObjectLike();
      init_toObjMap();
      init_directiveLocation();
      init_assertName();
      init_definition();
      init_scalars();
      GraphQLDirective = class {
        constructor(config) {
          var _config$isRepeatable, _config$args;
          this.name = assertName(config.name);
          this.description = config.description;
          this.locations = config.locations;
          this.isRepeatable = (_config$isRepeatable = config.isRepeatable) !== null && _config$isRepeatable !== void 0 ? _config$isRepeatable : false;
          this.extensions = toObjMap(config.extensions);
          this.astNode = config.astNode;
          Array.isArray(config.locations) || devAssert(false, `@${config.name} locations must be an Array.`);
          const args = (_config$args = config.args) !== null && _config$args !== void 0 ? _config$args : {};
          isObjectLike(args) && !Array.isArray(args) || devAssert(
            false,
            `@${config.name} args must be an object with argument names as keys.`
          );
          this.args = defineArguments(args);
        }
        get [Symbol.toStringTag]() {
          return "GraphQLDirective";
        }
        toConfig() {
          return {
            name: this.name,
            description: this.description,
            locations: this.locations,
            args: argsToArgsConfig(this.args),
            isRepeatable: this.isRepeatable,
            extensions: this.extensions,
            astNode: this.astNode
          };
        }
        toString() {
          return "@" + this.name;
        }
        toJSON() {
          return this.toString();
        }
      };
      GraphQLIncludeDirective = new GraphQLDirective({
        name: "include",
        description: "Directs the executor to include this field or fragment only when the `if` argument is true.",
        locations: [
          DirectiveLocation.FIELD,
          DirectiveLocation.FRAGMENT_SPREAD,
          DirectiveLocation.INLINE_FRAGMENT
        ],
        args: {
          if: {
            type: new GraphQLNonNull(GraphQLBoolean),
            description: "Included when true."
          }
        }
      });
      GraphQLSkipDirective = new GraphQLDirective({
        name: "skip",
        description: "Directs the executor to skip this field or fragment when the `if` argument is true.",
        locations: [
          DirectiveLocation.FIELD,
          DirectiveLocation.FRAGMENT_SPREAD,
          DirectiveLocation.INLINE_FRAGMENT
        ],
        args: {
          if: {
            type: new GraphQLNonNull(GraphQLBoolean),
            description: "Skipped when true."
          }
        }
      });
      DEFAULT_DEPRECATION_REASON = "No longer supported";
      GraphQLDeprecatedDirective = new GraphQLDirective({
        name: "deprecated",
        description: "Marks an element of a GraphQL schema as no longer supported.",
        locations: [
          DirectiveLocation.FIELD_DEFINITION,
          DirectiveLocation.ARGUMENT_DEFINITION,
          DirectiveLocation.INPUT_FIELD_DEFINITION,
          DirectiveLocation.ENUM_VALUE
        ],
        args: {
          reason: {
            type: GraphQLString,
            description: "Explains why this element was deprecated, usually also including a suggestion for how to access supported similar data. Formatted using the Markdown syntax, as specified by [CommonMark](https://commonmark.org/).",
            defaultValue: DEFAULT_DEPRECATION_REASON
          }
        }
      });
      GraphQLSpecifiedByDirective = new GraphQLDirective({
        name: "specifiedBy",
        description: "Exposes a URL that specifies the behavior of this scalar.",
        locations: [DirectiveLocation.SCALAR],
        args: {
          url: {
            type: new GraphQLNonNull(GraphQLString),
            description: "The URL that specifies the behavior of this scalar."
          }
        }
      });
      specifiedDirectives = Object.freeze([
        GraphQLIncludeDirective,
        GraphQLSkipDirective,
        GraphQLDeprecatedDirective,
        GraphQLSpecifiedByDirective
      ]);
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/jsutils/isIterableObject.mjs
  function isIterableObject(maybeIterable) {
    return typeof maybeIterable === "object" && typeof (maybeIterable === null || maybeIterable === void 0 ? void 0 : maybeIterable[Symbol.iterator]) === "function";
  }
  var init_isIterableObject = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/jsutils/isIterableObject.mjs"() {
      "use strict";
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/utilities/astFromValue.mjs
  function astFromValue(value, type) {
    if (isNonNullType(type)) {
      const astValue = astFromValue(value, type.ofType);
      if ((astValue === null || astValue === void 0 ? void 0 : astValue.kind) === Kind.NULL) {
        return null;
      }
      return astValue;
    }
    if (value === null) {
      return {
        kind: Kind.NULL
      };
    }
    if (value === void 0) {
      return null;
    }
    if (isListType(type)) {
      const itemType = type.ofType;
      if (isIterableObject(value)) {
        const valuesNodes = [];
        for (const item of value) {
          const itemNode = astFromValue(item, itemType);
          if (itemNode != null) {
            valuesNodes.push(itemNode);
          }
        }
        return {
          kind: Kind.LIST,
          values: valuesNodes
        };
      }
      return astFromValue(value, itemType);
    }
    if (isInputObjectType(type)) {
      if (!isObjectLike(value)) {
        return null;
      }
      const fieldNodes = [];
      for (const field of Object.values(type.getFields())) {
        const fieldValue = astFromValue(value[field.name], field.type);
        if (fieldValue) {
          fieldNodes.push({
            kind: Kind.OBJECT_FIELD,
            name: {
              kind: Kind.NAME,
              value: field.name
            },
            value: fieldValue
          });
        }
      }
      return {
        kind: Kind.OBJECT,
        fields: fieldNodes
      };
    }
    if (isLeafType(type)) {
      const serialized = type.serialize(value);
      if (serialized == null) {
        return null;
      }
      if (typeof serialized === "boolean") {
        return {
          kind: Kind.BOOLEAN,
          value: serialized
        };
      }
      if (typeof serialized === "number" && Number.isFinite(serialized)) {
        const stringNum = String(serialized);
        return integerStringRegExp.test(stringNum) ? {
          kind: Kind.INT,
          value: stringNum
        } : {
          kind: Kind.FLOAT,
          value: stringNum
        };
      }
      if (typeof serialized === "string") {
        if (isEnumType(type)) {
          return {
            kind: Kind.ENUM,
            value: serialized
          };
        }
        if (type === GraphQLID && integerStringRegExp.test(serialized)) {
          return {
            kind: Kind.INT,
            value: serialized
          };
        }
        return {
          kind: Kind.STRING,
          value: serialized
        };
      }
      throw new TypeError(`Cannot convert value to AST: ${inspect(serialized)}.`);
    }
    invariant2(false, "Unexpected input type: " + inspect(type));
  }
  var integerStringRegExp;
  var init_astFromValue = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/utilities/astFromValue.mjs"() {
      "use strict";
      init_inspect();
      init_invariant();
      init_isIterableObject();
      init_isObjectLike();
      init_kinds();
      init_definition();
      init_scalars();
      integerStringRegExp = /^-?(?:0|[1-9][0-9]*)$/;
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/type/introspection.mjs
  function isIntrospectionType(type) {
    return introspectionTypes.some(({ name }) => type.name === name);
  }
  var __Schema, __Directive, __DirectiveLocation, __Type, __Field, __InputValue, __EnumValue, TypeKind, __TypeKind, SchemaMetaFieldDef, TypeMetaFieldDef, TypeNameMetaFieldDef, introspectionTypes;
  var init_introspection = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/type/introspection.mjs"() {
      "use strict";
      init_inspect();
      init_invariant();
      init_directiveLocation();
      init_printer();
      init_astFromValue();
      init_definition();
      init_scalars();
      __Schema = new GraphQLObjectType({
        name: "__Schema",
        description: "A GraphQL Schema defines the capabilities of a GraphQL server. It exposes all available types and directives on the server, as well as the entry points for query, mutation, and subscription operations.",
        fields: () => ({
          description: {
            type: GraphQLString,
            resolve: (schema) => schema.description
          },
          types: {
            description: "A list of all types supported by this server.",
            type: new GraphQLNonNull(new GraphQLList(new GraphQLNonNull(__Type))),
            resolve(schema) {
              return Object.values(schema.getTypeMap());
            }
          },
          queryType: {
            description: "The type that query operations will be rooted at.",
            type: new GraphQLNonNull(__Type),
            resolve: (schema) => schema.getQueryType()
          },
          mutationType: {
            description: "If this server supports mutation, the type that mutation operations will be rooted at.",
            type: __Type,
            resolve: (schema) => schema.getMutationType()
          },
          subscriptionType: {
            description: "If this server support subscription, the type that subscription operations will be rooted at.",
            type: __Type,
            resolve: (schema) => schema.getSubscriptionType()
          },
          directives: {
            description: "A list of all directives supported by this server.",
            type: new GraphQLNonNull(
              new GraphQLList(new GraphQLNonNull(__Directive))
            ),
            resolve: (schema) => schema.getDirectives()
          }
        })
      });
      __Directive = new GraphQLObjectType({
        name: "__Directive",
        description: "A Directive provides a way to describe alternate runtime execution and type validation behavior in a GraphQL document.\n\nIn some cases, you need to provide options to alter GraphQL's execution behavior in ways field arguments will not suffice, such as conditionally including or skipping a field. Directives provide this by describing additional information to the executor.",
        fields: () => ({
          name: {
            type: new GraphQLNonNull(GraphQLString),
            resolve: (directive) => directive.name
          },
          description: {
            type: GraphQLString,
            resolve: (directive) => directive.description
          },
          isRepeatable: {
            type: new GraphQLNonNull(GraphQLBoolean),
            resolve: (directive) => directive.isRepeatable
          },
          locations: {
            type: new GraphQLNonNull(
              new GraphQLList(new GraphQLNonNull(__DirectiveLocation))
            ),
            resolve: (directive) => directive.locations
          },
          args: {
            type: new GraphQLNonNull(
              new GraphQLList(new GraphQLNonNull(__InputValue))
            ),
            args: {
              includeDeprecated: {
                type: GraphQLBoolean,
                defaultValue: false
              }
            },
            resolve(field, { includeDeprecated }) {
              return includeDeprecated ? field.args : field.args.filter((arg) => arg.deprecationReason == null);
            }
          }
        })
      });
      __DirectiveLocation = new GraphQLEnumType({
        name: "__DirectiveLocation",
        description: "A Directive can be adjacent to many parts of the GraphQL language, a __DirectiveLocation describes one such possible adjacencies.",
        values: {
          QUERY: {
            value: DirectiveLocation.QUERY,
            description: "Location adjacent to a query operation."
          },
          MUTATION: {
            value: DirectiveLocation.MUTATION,
            description: "Location adjacent to a mutation operation."
          },
          SUBSCRIPTION: {
            value: DirectiveLocation.SUBSCRIPTION,
            description: "Location adjacent to a subscription operation."
          },
          FIELD: {
            value: DirectiveLocation.FIELD,
            description: "Location adjacent to a field."
          },
          FRAGMENT_DEFINITION: {
            value: DirectiveLocation.FRAGMENT_DEFINITION,
            description: "Location adjacent to a fragment definition."
          },
          FRAGMENT_SPREAD: {
            value: DirectiveLocation.FRAGMENT_SPREAD,
            description: "Location adjacent to a fragment spread."
          },
          INLINE_FRAGMENT: {
            value: DirectiveLocation.INLINE_FRAGMENT,
            description: "Location adjacent to an inline fragment."
          },
          VARIABLE_DEFINITION: {
            value: DirectiveLocation.VARIABLE_DEFINITION,
            description: "Location adjacent to a variable definition."
          },
          SCHEMA: {
            value: DirectiveLocation.SCHEMA,
            description: "Location adjacent to a schema definition."
          },
          SCALAR: {
            value: DirectiveLocation.SCALAR,
            description: "Location adjacent to a scalar definition."
          },
          OBJECT: {
            value: DirectiveLocation.OBJECT,
            description: "Location adjacent to an object type definition."
          },
          FIELD_DEFINITION: {
            value: DirectiveLocation.FIELD_DEFINITION,
            description: "Location adjacent to a field definition."
          },
          ARGUMENT_DEFINITION: {
            value: DirectiveLocation.ARGUMENT_DEFINITION,
            description: "Location adjacent to an argument definition."
          },
          INTERFACE: {
            value: DirectiveLocation.INTERFACE,
            description: "Location adjacent to an interface definition."
          },
          UNION: {
            value: DirectiveLocation.UNION,
            description: "Location adjacent to a union definition."
          },
          ENUM: {
            value: DirectiveLocation.ENUM,
            description: "Location adjacent to an enum definition."
          },
          ENUM_VALUE: {
            value: DirectiveLocation.ENUM_VALUE,
            description: "Location adjacent to an enum value definition."
          },
          INPUT_OBJECT: {
            value: DirectiveLocation.INPUT_OBJECT,
            description: "Location adjacent to an input object type definition."
          },
          INPUT_FIELD_DEFINITION: {
            value: DirectiveLocation.INPUT_FIELD_DEFINITION,
            description: "Location adjacent to an input object field definition."
          }
        }
      });
      __Type = new GraphQLObjectType({
        name: "__Type",
        description: "The fundamental unit of any GraphQL Schema is the type. There are many kinds of types in GraphQL as represented by the `__TypeKind` enum.\n\nDepending on the kind of a type, certain fields describe information about that type. Scalar types provide no information beyond a name, description and optional `specifiedByURL`, while Enum types provide their values. Object and Interface types provide the fields they describe. Abstract types, Union and Interface, provide the Object types possible at runtime. List and NonNull types compose other types.",
        fields: () => ({
          kind: {
            type: new GraphQLNonNull(__TypeKind),
            resolve(type) {
              if (isScalarType(type)) {
                return TypeKind.SCALAR;
              }
              if (isObjectType(type)) {
                return TypeKind.OBJECT;
              }
              if (isInterfaceType(type)) {
                return TypeKind.INTERFACE;
              }
              if (isUnionType(type)) {
                return TypeKind.UNION;
              }
              if (isEnumType(type)) {
                return TypeKind.ENUM;
              }
              if (isInputObjectType(type)) {
                return TypeKind.INPUT_OBJECT;
              }
              if (isListType(type)) {
                return TypeKind.LIST;
              }
              if (isNonNullType(type)) {
                return TypeKind.NON_NULL;
              }
              invariant2(false, `Unexpected type: "${inspect(type)}".`);
            }
          },
          name: {
            type: GraphQLString,
            resolve: (type) => "name" in type ? type.name : void 0
          },
          description: {
            type: GraphQLString,
            resolve: (type) => (
              /* c8 ignore next */
              "description" in type ? type.description : void 0
            )
          },
          specifiedByURL: {
            type: GraphQLString,
            resolve: (obj) => "specifiedByURL" in obj ? obj.specifiedByURL : void 0
          },
          fields: {
            type: new GraphQLList(new GraphQLNonNull(__Field)),
            args: {
              includeDeprecated: {
                type: GraphQLBoolean,
                defaultValue: false
              }
            },
            resolve(type, { includeDeprecated }) {
              if (isObjectType(type) || isInterfaceType(type)) {
                const fields = Object.values(type.getFields());
                return includeDeprecated ? fields : fields.filter((field) => field.deprecationReason == null);
              }
            }
          },
          interfaces: {
            type: new GraphQLList(new GraphQLNonNull(__Type)),
            resolve(type) {
              if (isObjectType(type) || isInterfaceType(type)) {
                return type.getInterfaces();
              }
            }
          },
          possibleTypes: {
            type: new GraphQLList(new GraphQLNonNull(__Type)),
            resolve(type, _args, _context, { schema }) {
              if (isAbstractType(type)) {
                return schema.getPossibleTypes(type);
              }
            }
          },
          enumValues: {
            type: new GraphQLList(new GraphQLNonNull(__EnumValue)),
            args: {
              includeDeprecated: {
                type: GraphQLBoolean,
                defaultValue: false
              }
            },
            resolve(type, { includeDeprecated }) {
              if (isEnumType(type)) {
                const values = type.getValues();
                return includeDeprecated ? values : values.filter((field) => field.deprecationReason == null);
              }
            }
          },
          inputFields: {
            type: new GraphQLList(new GraphQLNonNull(__InputValue)),
            args: {
              includeDeprecated: {
                type: GraphQLBoolean,
                defaultValue: false
              }
            },
            resolve(type, { includeDeprecated }) {
              if (isInputObjectType(type)) {
                const values = Object.values(type.getFields());
                return includeDeprecated ? values : values.filter((field) => field.deprecationReason == null);
              }
            }
          },
          ofType: {
            type: __Type,
            resolve: (type) => "ofType" in type ? type.ofType : void 0
          }
        })
      });
      __Field = new GraphQLObjectType({
        name: "__Field",
        description: "Object and Interface types are described by a list of Fields, each of which has a name, potentially a list of arguments, and a return type.",
        fields: () => ({
          name: {
            type: new GraphQLNonNull(GraphQLString),
            resolve: (field) => field.name
          },
          description: {
            type: GraphQLString,
            resolve: (field) => field.description
          },
          args: {
            type: new GraphQLNonNull(
              new GraphQLList(new GraphQLNonNull(__InputValue))
            ),
            args: {
              includeDeprecated: {
                type: GraphQLBoolean,
                defaultValue: false
              }
            },
            resolve(field, { includeDeprecated }) {
              return includeDeprecated ? field.args : field.args.filter((arg) => arg.deprecationReason == null);
            }
          },
          type: {
            type: new GraphQLNonNull(__Type),
            resolve: (field) => field.type
          },
          isDeprecated: {
            type: new GraphQLNonNull(GraphQLBoolean),
            resolve: (field) => field.deprecationReason != null
          },
          deprecationReason: {
            type: GraphQLString,
            resolve: (field) => field.deprecationReason
          }
        })
      });
      __InputValue = new GraphQLObjectType({
        name: "__InputValue",
        description: "Arguments provided to Fields or Directives and the input fields of an InputObject are represented as Input Values which describe their type and optionally a default value.",
        fields: () => ({
          name: {
            type: new GraphQLNonNull(GraphQLString),
            resolve: (inputValue) => inputValue.name
          },
          description: {
            type: GraphQLString,
            resolve: (inputValue) => inputValue.description
          },
          type: {
            type: new GraphQLNonNull(__Type),
            resolve: (inputValue) => inputValue.type
          },
          defaultValue: {
            type: GraphQLString,
            description: "A GraphQL-formatted string representing the default value for this input value.",
            resolve(inputValue) {
              const { type, defaultValue } = inputValue;
              const valueAST = astFromValue(defaultValue, type);
              return valueAST ? print(valueAST) : null;
            }
          },
          isDeprecated: {
            type: new GraphQLNonNull(GraphQLBoolean),
            resolve: (field) => field.deprecationReason != null
          },
          deprecationReason: {
            type: GraphQLString,
            resolve: (obj) => obj.deprecationReason
          }
        })
      });
      __EnumValue = new GraphQLObjectType({
        name: "__EnumValue",
        description: "One possible value for a given Enum. Enum values are unique values, not a placeholder for a string or numeric value. However an Enum value is returned in a JSON response as a string.",
        fields: () => ({
          name: {
            type: new GraphQLNonNull(GraphQLString),
            resolve: (enumValue) => enumValue.name
          },
          description: {
            type: GraphQLString,
            resolve: (enumValue) => enumValue.description
          },
          isDeprecated: {
            type: new GraphQLNonNull(GraphQLBoolean),
            resolve: (enumValue) => enumValue.deprecationReason != null
          },
          deprecationReason: {
            type: GraphQLString,
            resolve: (enumValue) => enumValue.deprecationReason
          }
        })
      });
      (function(TypeKind2) {
        TypeKind2["SCALAR"] = "SCALAR";
        TypeKind2["OBJECT"] = "OBJECT";
        TypeKind2["INTERFACE"] = "INTERFACE";
        TypeKind2["UNION"] = "UNION";
        TypeKind2["ENUM"] = "ENUM";
        TypeKind2["INPUT_OBJECT"] = "INPUT_OBJECT";
        TypeKind2["LIST"] = "LIST";
        TypeKind2["NON_NULL"] = "NON_NULL";
      })(TypeKind || (TypeKind = {}));
      __TypeKind = new GraphQLEnumType({
        name: "__TypeKind",
        description: "An enum describing what kind of type a given `__Type` is.",
        values: {
          SCALAR: {
            value: TypeKind.SCALAR,
            description: "Indicates this type is a scalar."
          },
          OBJECT: {
            value: TypeKind.OBJECT,
            description: "Indicates this type is an object. `fields` and `interfaces` are valid fields."
          },
          INTERFACE: {
            value: TypeKind.INTERFACE,
            description: "Indicates this type is an interface. `fields`, `interfaces`, and `possibleTypes` are valid fields."
          },
          UNION: {
            value: TypeKind.UNION,
            description: "Indicates this type is a union. `possibleTypes` is a valid field."
          },
          ENUM: {
            value: TypeKind.ENUM,
            description: "Indicates this type is an enum. `enumValues` is a valid field."
          },
          INPUT_OBJECT: {
            value: TypeKind.INPUT_OBJECT,
            description: "Indicates this type is an input object. `inputFields` is a valid field."
          },
          LIST: {
            value: TypeKind.LIST,
            description: "Indicates this type is a list. `ofType` is a valid field."
          },
          NON_NULL: {
            value: TypeKind.NON_NULL,
            description: "Indicates this type is a non-null. `ofType` is a valid field."
          }
        }
      });
      SchemaMetaFieldDef = {
        name: "__schema",
        type: new GraphQLNonNull(__Schema),
        description: "Access the current type schema of this server.",
        args: [],
        resolve: (_source, _args, _context, { schema }) => schema,
        deprecationReason: void 0,
        extensions: /* @__PURE__ */ Object.create(null),
        astNode: void 0
      };
      TypeMetaFieldDef = {
        name: "__type",
        type: __Type,
        description: "Request the type information of a single type.",
        args: [
          {
            name: "name",
            description: void 0,
            type: new GraphQLNonNull(GraphQLString),
            defaultValue: void 0,
            deprecationReason: void 0,
            extensions: /* @__PURE__ */ Object.create(null),
            astNode: void 0
          }
        ],
        resolve: (_source, { name }, _context, { schema }) => schema.getType(name),
        deprecationReason: void 0,
        extensions: /* @__PURE__ */ Object.create(null),
        astNode: void 0
      };
      TypeNameMetaFieldDef = {
        name: "__typename",
        type: new GraphQLNonNull(GraphQLString),
        description: "The name of the current Object type at runtime.",
        args: [],
        resolve: (_source, _args, _context, { parentType }) => parentType.name,
        deprecationReason: void 0,
        extensions: /* @__PURE__ */ Object.create(null),
        astNode: void 0
      };
      introspectionTypes = Object.freeze([
        __Schema,
        __Directive,
        __DirectiveLocation,
        __Type,
        __Field,
        __InputValue,
        __EnumValue,
        __TypeKind
      ]);
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/type/schema.mjs
  function isSchema(schema) {
    return instanceOf(schema, GraphQLSchema);
  }
  function assertSchema(schema) {
    if (!isSchema(schema)) {
      throw new Error(`Expected ${inspect(schema)} to be a GraphQL schema.`);
    }
    return schema;
  }
  function collectReferencedTypes(type, typeSet) {
    const namedType = getNamedType(type);
    if (!typeSet.has(namedType)) {
      typeSet.add(namedType);
      if (isUnionType(namedType)) {
        for (const memberType of namedType.getTypes()) {
          collectReferencedTypes(memberType, typeSet);
        }
      } else if (isObjectType(namedType) || isInterfaceType(namedType)) {
        for (const interfaceType of namedType.getInterfaces()) {
          collectReferencedTypes(interfaceType, typeSet);
        }
        for (const field of Object.values(namedType.getFields())) {
          collectReferencedTypes(field.type, typeSet);
          for (const arg of field.args) {
            collectReferencedTypes(arg.type, typeSet);
          }
        }
      } else if (isInputObjectType(namedType)) {
        for (const field of Object.values(namedType.getFields())) {
          collectReferencedTypes(field.type, typeSet);
        }
      }
    }
    return typeSet;
  }
  var GraphQLSchema;
  var init_schema = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/type/schema.mjs"() {
      "use strict";
      init_devAssert();
      init_inspect();
      init_instanceOf();
      init_isObjectLike();
      init_toObjMap();
      init_ast();
      init_definition();
      init_directives();
      init_introspection();
      GraphQLSchema = class {
        // Used as a cache for validateSchema().
        constructor(config) {
          var _config$extensionASTN, _config$directives;
          this.__validationErrors = config.assumeValid === true ? [] : void 0;
          isObjectLike(config) || devAssert(false, "Must provide configuration object.");
          !config.types || Array.isArray(config.types) || devAssert(
            false,
            `"types" must be Array if provided but got: ${inspect(config.types)}.`
          );
          !config.directives || Array.isArray(config.directives) || devAssert(
            false,
            `"directives" must be Array if provided but got: ${inspect(config.directives)}.`
          );
          this.description = config.description;
          this.extensions = toObjMap(config.extensions);
          this.astNode = config.astNode;
          this.extensionASTNodes = (_config$extensionASTN = config.extensionASTNodes) !== null && _config$extensionASTN !== void 0 ? _config$extensionASTN : [];
          this._queryType = config.query;
          this._mutationType = config.mutation;
          this._subscriptionType = config.subscription;
          this._directives = (_config$directives = config.directives) !== null && _config$directives !== void 0 ? _config$directives : specifiedDirectives;
          const allReferencedTypes = new Set(config.types);
          if (config.types != null) {
            for (const type of config.types) {
              allReferencedTypes.delete(type);
              collectReferencedTypes(type, allReferencedTypes);
            }
          }
          if (this._queryType != null) {
            collectReferencedTypes(this._queryType, allReferencedTypes);
          }
          if (this._mutationType != null) {
            collectReferencedTypes(this._mutationType, allReferencedTypes);
          }
          if (this._subscriptionType != null) {
            collectReferencedTypes(this._subscriptionType, allReferencedTypes);
          }
          for (const directive of this._directives) {
            if (isDirective(directive)) {
              for (const arg of directive.args) {
                collectReferencedTypes(arg.type, allReferencedTypes);
              }
            }
          }
          collectReferencedTypes(__Schema, allReferencedTypes);
          this._typeMap = /* @__PURE__ */ Object.create(null);
          this._subTypeMap = /* @__PURE__ */ Object.create(null);
          this._implementationsMap = /* @__PURE__ */ Object.create(null);
          for (const namedType of allReferencedTypes) {
            if (namedType == null) {
              continue;
            }
            const typeName = namedType.name;
            typeName || devAssert(
              false,
              "One of the provided types for building the Schema is missing a name."
            );
            if (this._typeMap[typeName] !== void 0) {
              throw new Error(
                `Schema must contain uniquely named types but contains multiple types named "${typeName}".`
              );
            }
            this._typeMap[typeName] = namedType;
            if (isInterfaceType(namedType)) {
              for (const iface of namedType.getInterfaces()) {
                if (isInterfaceType(iface)) {
                  let implementations = this._implementationsMap[iface.name];
                  if (implementations === void 0) {
                    implementations = this._implementationsMap[iface.name] = {
                      objects: [],
                      interfaces: []
                    };
                  }
                  implementations.interfaces.push(namedType);
                }
              }
            } else if (isObjectType(namedType)) {
              for (const iface of namedType.getInterfaces()) {
                if (isInterfaceType(iface)) {
                  let implementations = this._implementationsMap[iface.name];
                  if (implementations === void 0) {
                    implementations = this._implementationsMap[iface.name] = {
                      objects: [],
                      interfaces: []
                    };
                  }
                  implementations.objects.push(namedType);
                }
              }
            }
          }
        }
        get [Symbol.toStringTag]() {
          return "GraphQLSchema";
        }
        getQueryType() {
          return this._queryType;
        }
        getMutationType() {
          return this._mutationType;
        }
        getSubscriptionType() {
          return this._subscriptionType;
        }
        getRootType(operation) {
          switch (operation) {
            case OperationTypeNode.QUERY:
              return this.getQueryType();
            case OperationTypeNode.MUTATION:
              return this.getMutationType();
            case OperationTypeNode.SUBSCRIPTION:
              return this.getSubscriptionType();
          }
        }
        getTypeMap() {
          return this._typeMap;
        }
        getType(name) {
          return this.getTypeMap()[name];
        }
        getPossibleTypes(abstractType) {
          return isUnionType(abstractType) ? abstractType.getTypes() : this.getImplementations(abstractType).objects;
        }
        getImplementations(interfaceType) {
          const implementations = this._implementationsMap[interfaceType.name];
          return implementations !== null && implementations !== void 0 ? implementations : {
            objects: [],
            interfaces: []
          };
        }
        isSubType(abstractType, maybeSubType) {
          let map = this._subTypeMap[abstractType.name];
          if (map === void 0) {
            map = /* @__PURE__ */ Object.create(null);
            if (isUnionType(abstractType)) {
              for (const type of abstractType.getTypes()) {
                map[type.name] = true;
              }
            } else {
              const implementations = this.getImplementations(abstractType);
              for (const type of implementations.objects) {
                map[type.name] = true;
              }
              for (const type of implementations.interfaces) {
                map[type.name] = true;
              }
            }
            this._subTypeMap[abstractType.name] = map;
          }
          return map[maybeSubType.name] !== void 0;
        }
        getDirectives() {
          return this._directives;
        }
        getDirective(name) {
          return this.getDirectives().find((directive) => directive.name === name);
        }
        toConfig() {
          return {
            description: this.description,
            query: this.getQueryType(),
            mutation: this.getMutationType(),
            subscription: this.getSubscriptionType(),
            types: Object.values(this.getTypeMap()),
            directives: this.getDirectives(),
            extensions: this.extensions,
            astNode: this.astNode,
            extensionASTNodes: this.extensionASTNodes,
            assumeValid: this.__validationErrors !== void 0
          };
        }
      };
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/type/validate.mjs
  function validateSchema(schema) {
    assertSchema(schema);
    if (schema.__validationErrors) {
      return schema.__validationErrors;
    }
    const context = new SchemaValidationContext(schema);
    validateRootTypes(context);
    validateDirectives(context);
    validateTypes(context);
    const errors = context.getErrors();
    schema.__validationErrors = errors;
    return errors;
  }
  function assertValidSchema(schema) {
    const errors = validateSchema(schema);
    if (errors.length !== 0) {
      throw new Error(errors.map((error3) => error3.message).join("\n\n"));
    }
  }
  function validateRootTypes(context) {
    const schema = context.schema;
    const queryType = schema.getQueryType();
    if (!queryType) {
      context.reportError("Query root type must be provided.", schema.astNode);
    } else if (!isObjectType(queryType)) {
      var _getOperationTypeNode;
      context.reportError(
        `Query root type must be Object type, it cannot be ${inspect(
          queryType
        )}.`,
        (_getOperationTypeNode = getOperationTypeNode(
          schema,
          OperationTypeNode.QUERY
        )) !== null && _getOperationTypeNode !== void 0 ? _getOperationTypeNode : queryType.astNode
      );
    }
    const mutationType = schema.getMutationType();
    if (mutationType && !isObjectType(mutationType)) {
      var _getOperationTypeNode2;
      context.reportError(
        `Mutation root type must be Object type if provided, it cannot be ${inspect(mutationType)}.`,
        (_getOperationTypeNode2 = getOperationTypeNode(
          schema,
          OperationTypeNode.MUTATION
        )) !== null && _getOperationTypeNode2 !== void 0 ? _getOperationTypeNode2 : mutationType.astNode
      );
    }
    const subscriptionType = schema.getSubscriptionType();
    if (subscriptionType && !isObjectType(subscriptionType)) {
      var _getOperationTypeNode3;
      context.reportError(
        `Subscription root type must be Object type if provided, it cannot be ${inspect(subscriptionType)}.`,
        (_getOperationTypeNode3 = getOperationTypeNode(
          schema,
          OperationTypeNode.SUBSCRIPTION
        )) !== null && _getOperationTypeNode3 !== void 0 ? _getOperationTypeNode3 : subscriptionType.astNode
      );
    }
  }
  function getOperationTypeNode(schema, operation) {
    var _flatMap$find;
    return (_flatMap$find = [schema.astNode, ...schema.extensionASTNodes].flatMap(
      // FIXME: https://github.com/graphql/graphql-js/issues/2203
      (schemaNode) => {
        var _schemaNode$operation;
        return (
          /* c8 ignore next */
          (_schemaNode$operation = schemaNode === null || schemaNode === void 0 ? void 0 : schemaNode.operationTypes) !== null && _schemaNode$operation !== void 0 ? _schemaNode$operation : []
        );
      }
    ).find((operationNode) => operationNode.operation === operation)) === null || _flatMap$find === void 0 ? void 0 : _flatMap$find.type;
  }
  function validateDirectives(context) {
    for (const directive of context.schema.getDirectives()) {
      if (!isDirective(directive)) {
        context.reportError(
          `Expected directive but got: ${inspect(directive)}.`,
          directive === null || directive === void 0 ? void 0 : directive.astNode
        );
        continue;
      }
      validateName(context, directive);
      for (const arg of directive.args) {
        validateName(context, arg);
        if (!isInputType(arg.type)) {
          context.reportError(
            `The type of @${directive.name}(${arg.name}:) must be Input Type but got: ${inspect(arg.type)}.`,
            arg.astNode
          );
        }
        if (isRequiredArgument(arg) && arg.deprecationReason != null) {
          var _arg$astNode;
          context.reportError(
            `Required argument @${directive.name}(${arg.name}:) cannot be deprecated.`,
            [
              getDeprecatedDirectiveNode(arg.astNode),
              (_arg$astNode = arg.astNode) === null || _arg$astNode === void 0 ? void 0 : _arg$astNode.type
            ]
          );
        }
      }
    }
  }
  function validateName(context, node) {
    if (node.name.startsWith("__")) {
      context.reportError(
        `Name "${node.name}" must not begin with "__", which is reserved by GraphQL introspection.`,
        node.astNode
      );
    }
  }
  function validateTypes(context) {
    const validateInputObjectCircularRefs = createInputObjectCircularRefsValidator(context);
    const typeMap = context.schema.getTypeMap();
    for (const type of Object.values(typeMap)) {
      if (!isNamedType(type)) {
        context.reportError(
          `Expected GraphQL named type but got: ${inspect(type)}.`,
          type.astNode
        );
        continue;
      }
      if (!isIntrospectionType(type)) {
        validateName(context, type);
      }
      if (isObjectType(type)) {
        validateFields(context, type);
        validateInterfaces(context, type);
      } else if (isInterfaceType(type)) {
        validateFields(context, type);
        validateInterfaces(context, type);
      } else if (isUnionType(type)) {
        validateUnionMembers(context, type);
      } else if (isEnumType(type)) {
        validateEnumValues(context, type);
      } else if (isInputObjectType(type)) {
        validateInputFields(context, type);
        validateInputObjectCircularRefs(type);
      }
    }
  }
  function validateFields(context, type) {
    const fields = Object.values(type.getFields());
    if (fields.length === 0) {
      context.reportError(`Type ${type.name} must define one or more fields.`, [
        type.astNode,
        ...type.extensionASTNodes
      ]);
    }
    for (const field of fields) {
      validateName(context, field);
      if (!isOutputType(field.type)) {
        var _field$astNode;
        context.reportError(
          `The type of ${type.name}.${field.name} must be Output Type but got: ${inspect(field.type)}.`,
          (_field$astNode = field.astNode) === null || _field$astNode === void 0 ? void 0 : _field$astNode.type
        );
      }
      for (const arg of field.args) {
        const argName = arg.name;
        validateName(context, arg);
        if (!isInputType(arg.type)) {
          var _arg$astNode2;
          context.reportError(
            `The type of ${type.name}.${field.name}(${argName}:) must be Input Type but got: ${inspect(arg.type)}.`,
            (_arg$astNode2 = arg.astNode) === null || _arg$astNode2 === void 0 ? void 0 : _arg$astNode2.type
          );
        }
        if (isRequiredArgument(arg) && arg.deprecationReason != null) {
          var _arg$astNode3;
          context.reportError(
            `Required argument ${type.name}.${field.name}(${argName}:) cannot be deprecated.`,
            [
              getDeprecatedDirectiveNode(arg.astNode),
              (_arg$astNode3 = arg.astNode) === null || _arg$astNode3 === void 0 ? void 0 : _arg$astNode3.type
            ]
          );
        }
      }
    }
  }
  function validateInterfaces(context, type) {
    const ifaceTypeNames = /* @__PURE__ */ Object.create(null);
    for (const iface of type.getInterfaces()) {
      if (!isInterfaceType(iface)) {
        context.reportError(
          `Type ${inspect(type)} must only implement Interface types, it cannot implement ${inspect(iface)}.`,
          getAllImplementsInterfaceNodes(type, iface)
        );
        continue;
      }
      if (type === iface) {
        context.reportError(
          `Type ${type.name} cannot implement itself because it would create a circular reference.`,
          getAllImplementsInterfaceNodes(type, iface)
        );
        continue;
      }
      if (ifaceTypeNames[iface.name]) {
        context.reportError(
          `Type ${type.name} can only implement ${iface.name} once.`,
          getAllImplementsInterfaceNodes(type, iface)
        );
        continue;
      }
      ifaceTypeNames[iface.name] = true;
      validateTypeImplementsAncestors(context, type, iface);
      validateTypeImplementsInterface(context, type, iface);
    }
  }
  function validateTypeImplementsInterface(context, type, iface) {
    const typeFieldMap = type.getFields();
    for (const ifaceField of Object.values(iface.getFields())) {
      const fieldName = ifaceField.name;
      const typeField = typeFieldMap[fieldName];
      if (!typeField) {
        context.reportError(
          `Interface field ${iface.name}.${fieldName} expected but ${type.name} does not provide it.`,
          [ifaceField.astNode, type.astNode, ...type.extensionASTNodes]
        );
        continue;
      }
      if (!isTypeSubTypeOf(context.schema, typeField.type, ifaceField.type)) {
        var _ifaceField$astNode, _typeField$astNode;
        context.reportError(
          `Interface field ${iface.name}.${fieldName} expects type ${inspect(ifaceField.type)} but ${type.name}.${fieldName} is type ${inspect(typeField.type)}.`,
          [
            (_ifaceField$astNode = ifaceField.astNode) === null || _ifaceField$astNode === void 0 ? void 0 : _ifaceField$astNode.type,
            (_typeField$astNode = typeField.astNode) === null || _typeField$astNode === void 0 ? void 0 : _typeField$astNode.type
          ]
        );
      }
      for (const ifaceArg of ifaceField.args) {
        const argName = ifaceArg.name;
        const typeArg = typeField.args.find((arg) => arg.name === argName);
        if (!typeArg) {
          context.reportError(
            `Interface field argument ${iface.name}.${fieldName}(${argName}:) expected but ${type.name}.${fieldName} does not provide it.`,
            [ifaceArg.astNode, typeField.astNode]
          );
          continue;
        }
        if (!isEqualType(ifaceArg.type, typeArg.type)) {
          var _ifaceArg$astNode, _typeArg$astNode;
          context.reportError(
            `Interface field argument ${iface.name}.${fieldName}(${argName}:) expects type ${inspect(ifaceArg.type)} but ${type.name}.${fieldName}(${argName}:) is type ${inspect(typeArg.type)}.`,
            [
              (_ifaceArg$astNode = ifaceArg.astNode) === null || _ifaceArg$astNode === void 0 ? void 0 : _ifaceArg$astNode.type,
              (_typeArg$astNode = typeArg.astNode) === null || _typeArg$astNode === void 0 ? void 0 : _typeArg$astNode.type
            ]
          );
        }
      }
      for (const typeArg of typeField.args) {
        const argName = typeArg.name;
        const ifaceArg = ifaceField.args.find((arg) => arg.name === argName);
        if (!ifaceArg && isRequiredArgument(typeArg)) {
          context.reportError(
            `Object field ${type.name}.${fieldName} includes required argument ${argName} that is missing from the Interface field ${iface.name}.${fieldName}.`,
            [typeArg.astNode, ifaceField.astNode]
          );
        }
      }
    }
  }
  function validateTypeImplementsAncestors(context, type, iface) {
    const ifaceInterfaces = type.getInterfaces();
    for (const transitive of iface.getInterfaces()) {
      if (!ifaceInterfaces.includes(transitive)) {
        context.reportError(
          transitive === type ? `Type ${type.name} cannot implement ${iface.name} because it would create a circular reference.` : `Type ${type.name} must implement ${transitive.name} because it is implemented by ${iface.name}.`,
          [
            ...getAllImplementsInterfaceNodes(iface, transitive),
            ...getAllImplementsInterfaceNodes(type, iface)
          ]
        );
      }
    }
  }
  function validateUnionMembers(context, union) {
    const memberTypes = union.getTypes();
    if (memberTypes.length === 0) {
      context.reportError(
        `Union type ${union.name} must define one or more member types.`,
        [union.astNode, ...union.extensionASTNodes]
      );
    }
    const includedTypeNames = /* @__PURE__ */ Object.create(null);
    for (const memberType of memberTypes) {
      if (includedTypeNames[memberType.name]) {
        context.reportError(
          `Union type ${union.name} can only include type ${memberType.name} once.`,
          getUnionMemberTypeNodes(union, memberType.name)
        );
        continue;
      }
      includedTypeNames[memberType.name] = true;
      if (!isObjectType(memberType)) {
        context.reportError(
          `Union type ${union.name} can only include Object types, it cannot include ${inspect(memberType)}.`,
          getUnionMemberTypeNodes(union, String(memberType))
        );
      }
    }
  }
  function validateEnumValues(context, enumType) {
    const enumValues = enumType.getValues();
    if (enumValues.length === 0) {
      context.reportError(
        `Enum type ${enumType.name} must define one or more values.`,
        [enumType.astNode, ...enumType.extensionASTNodes]
      );
    }
    for (const enumValue of enumValues) {
      validateName(context, enumValue);
    }
  }
  function validateInputFields(context, inputObj) {
    const fields = Object.values(inputObj.getFields());
    if (fields.length === 0) {
      context.reportError(
        `Input Object type ${inputObj.name} must define one or more fields.`,
        [inputObj.astNode, ...inputObj.extensionASTNodes]
      );
    }
    for (const field of fields) {
      validateName(context, field);
      if (!isInputType(field.type)) {
        var _field$astNode2;
        context.reportError(
          `The type of ${inputObj.name}.${field.name} must be Input Type but got: ${inspect(field.type)}.`,
          (_field$astNode2 = field.astNode) === null || _field$astNode2 === void 0 ? void 0 : _field$astNode2.type
        );
      }
      if (isRequiredInputField(field) && field.deprecationReason != null) {
        var _field$astNode3;
        context.reportError(
          `Required input field ${inputObj.name}.${field.name} cannot be deprecated.`,
          [
            getDeprecatedDirectiveNode(field.astNode),
            (_field$astNode3 = field.astNode) === null || _field$astNode3 === void 0 ? void 0 : _field$astNode3.type
          ]
        );
      }
    }
  }
  function createInputObjectCircularRefsValidator(context) {
    const visitedTypes = /* @__PURE__ */ Object.create(null);
    const fieldPath = [];
    const fieldPathIndexByTypeName = /* @__PURE__ */ Object.create(null);
    return detectCycleRecursive;
    function detectCycleRecursive(inputObj) {
      if (visitedTypes[inputObj.name]) {
        return;
      }
      visitedTypes[inputObj.name] = true;
      fieldPathIndexByTypeName[inputObj.name] = fieldPath.length;
      const fields = Object.values(inputObj.getFields());
      for (const field of fields) {
        if (isNonNullType(field.type) && isInputObjectType(field.type.ofType)) {
          const fieldType = field.type.ofType;
          const cycleIndex = fieldPathIndexByTypeName[fieldType.name];
          fieldPath.push(field);
          if (cycleIndex === void 0) {
            detectCycleRecursive(fieldType);
          } else {
            const cyclePath = fieldPath.slice(cycleIndex);
            const pathStr = cyclePath.map((fieldObj) => fieldObj.name).join(".");
            context.reportError(
              `Cannot reference Input Object "${fieldType.name}" within itself through a series of non-null fields: "${pathStr}".`,
              cyclePath.map((fieldObj) => fieldObj.astNode)
            );
          }
          fieldPath.pop();
        }
      }
      fieldPathIndexByTypeName[inputObj.name] = void 0;
    }
  }
  function getAllImplementsInterfaceNodes(type, iface) {
    const { astNode, extensionASTNodes } = type;
    const nodes = astNode != null ? [astNode, ...extensionASTNodes] : extensionASTNodes;
    return nodes.flatMap((typeNode) => {
      var _typeNode$interfaces;
      return (
        /* c8 ignore next */
        (_typeNode$interfaces = typeNode.interfaces) !== null && _typeNode$interfaces !== void 0 ? _typeNode$interfaces : []
      );
    }).filter((ifaceNode) => ifaceNode.name.value === iface.name);
  }
  function getUnionMemberTypeNodes(union, typeName) {
    const { astNode, extensionASTNodes } = union;
    const nodes = astNode != null ? [astNode, ...extensionASTNodes] : extensionASTNodes;
    return nodes.flatMap((unionNode) => {
      var _unionNode$types;
      return (
        /* c8 ignore next */
        (_unionNode$types = unionNode.types) !== null && _unionNode$types !== void 0 ? _unionNode$types : []
      );
    }).filter((typeNode) => typeNode.name.value === typeName);
  }
  function getDeprecatedDirectiveNode(definitionNode) {
    var _definitionNode$direc;
    return definitionNode === null || definitionNode === void 0 ? void 0 : (_definitionNode$direc = definitionNode.directives) === null || _definitionNode$direc === void 0 ? void 0 : _definitionNode$direc.find(
      (node) => node.name.value === GraphQLDeprecatedDirective.name
    );
  }
  var SchemaValidationContext;
  var init_validate = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/type/validate.mjs"() {
      "use strict";
      init_inspect();
      init_GraphQLError();
      init_ast();
      init_typeComparators();
      init_definition();
      init_directives();
      init_introspection();
      init_schema();
      SchemaValidationContext = class {
        constructor(schema) {
          this._errors = [];
          this.schema = schema;
        }
        reportError(message3, nodes) {
          const _nodes = Array.isArray(nodes) ? nodes.filter(Boolean) : nodes;
          this._errors.push(
            new GraphQLError(message3, {
              nodes: _nodes
            })
          );
        }
        getErrors() {
          return this._errors;
        }
      };
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/utilities/typeFromAST.mjs
  function typeFromAST(schema, typeNode) {
    switch (typeNode.kind) {
      case Kind.LIST_TYPE: {
        const innerType = typeFromAST(schema, typeNode.type);
        return innerType && new GraphQLList(innerType);
      }
      case Kind.NON_NULL_TYPE: {
        const innerType = typeFromAST(schema, typeNode.type);
        return innerType && new GraphQLNonNull(innerType);
      }
      case Kind.NAMED_TYPE:
        return schema.getType(typeNode.name.value);
    }
  }
  var init_typeFromAST = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/utilities/typeFromAST.mjs"() {
      "use strict";
      init_kinds();
      init_definition();
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/utilities/TypeInfo.mjs
  function getFieldDef(schema, parentType, fieldNode) {
    const name = fieldNode.name.value;
    if (name === SchemaMetaFieldDef.name && schema.getQueryType() === parentType) {
      return SchemaMetaFieldDef;
    }
    if (name === TypeMetaFieldDef.name && schema.getQueryType() === parentType) {
      return TypeMetaFieldDef;
    }
    if (name === TypeNameMetaFieldDef.name && isCompositeType(parentType)) {
      return TypeNameMetaFieldDef;
    }
    if (isObjectType(parentType) || isInterfaceType(parentType)) {
      return parentType.getFields()[name];
    }
  }
  function visitWithTypeInfo(typeInfo, visitor) {
    return {
      enter(...args) {
        const node = args[0];
        typeInfo.enter(node);
        const fn = getEnterLeaveForKind(visitor, node.kind).enter;
        if (fn) {
          const result = fn.apply(visitor, args);
          if (result !== void 0) {
            typeInfo.leave(node);
            if (isNode(result)) {
              typeInfo.enter(result);
            }
          }
          return result;
        }
      },
      leave(...args) {
        const node = args[0];
        const fn = getEnterLeaveForKind(visitor, node.kind).leave;
        let result;
        if (fn) {
          result = fn.apply(visitor, args);
        }
        typeInfo.leave(node);
        return result;
      }
    };
  }
  var TypeInfo;
  var init_TypeInfo = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/utilities/TypeInfo.mjs"() {
      "use strict";
      init_ast();
      init_kinds();
      init_visitor();
      init_definition();
      init_introspection();
      init_typeFromAST();
      TypeInfo = class {
        constructor(schema, initialType, getFieldDefFn) {
          this._schema = schema;
          this._typeStack = [];
          this._parentTypeStack = [];
          this._inputTypeStack = [];
          this._fieldDefStack = [];
          this._defaultValueStack = [];
          this._directive = null;
          this._argument = null;
          this._enumValue = null;
          this._getFieldDef = getFieldDefFn !== null && getFieldDefFn !== void 0 ? getFieldDefFn : getFieldDef;
          if (initialType) {
            if (isInputType(initialType)) {
              this._inputTypeStack.push(initialType);
            }
            if (isCompositeType(initialType)) {
              this._parentTypeStack.push(initialType);
            }
            if (isOutputType(initialType)) {
              this._typeStack.push(initialType);
            }
          }
        }
        get [Symbol.toStringTag]() {
          return "TypeInfo";
        }
        getType() {
          if (this._typeStack.length > 0) {
            return this._typeStack[this._typeStack.length - 1];
          }
        }
        getParentType() {
          if (this._parentTypeStack.length > 0) {
            return this._parentTypeStack[this._parentTypeStack.length - 1];
          }
        }
        getInputType() {
          if (this._inputTypeStack.length > 0) {
            return this._inputTypeStack[this._inputTypeStack.length - 1];
          }
        }
        getParentInputType() {
          if (this._inputTypeStack.length > 1) {
            return this._inputTypeStack[this._inputTypeStack.length - 2];
          }
        }
        getFieldDef() {
          if (this._fieldDefStack.length > 0) {
            return this._fieldDefStack[this._fieldDefStack.length - 1];
          }
        }
        getDefaultValue() {
          if (this._defaultValueStack.length > 0) {
            return this._defaultValueStack[this._defaultValueStack.length - 1];
          }
        }
        getDirective() {
          return this._directive;
        }
        getArgument() {
          return this._argument;
        }
        getEnumValue() {
          return this._enumValue;
        }
        enter(node) {
          const schema = this._schema;
          switch (node.kind) {
            case Kind.SELECTION_SET: {
              const namedType = getNamedType(this.getType());
              this._parentTypeStack.push(
                isCompositeType(namedType) ? namedType : void 0
              );
              break;
            }
            case Kind.FIELD: {
              const parentType = this.getParentType();
              let fieldDef;
              let fieldType;
              if (parentType) {
                fieldDef = this._getFieldDef(schema, parentType, node);
                if (fieldDef) {
                  fieldType = fieldDef.type;
                }
              }
              this._fieldDefStack.push(fieldDef);
              this._typeStack.push(isOutputType(fieldType) ? fieldType : void 0);
              break;
            }
            case Kind.DIRECTIVE:
              this._directive = schema.getDirective(node.name.value);
              break;
            case Kind.OPERATION_DEFINITION: {
              const rootType = schema.getRootType(node.operation);
              this._typeStack.push(isObjectType(rootType) ? rootType : void 0);
              break;
            }
            case Kind.INLINE_FRAGMENT:
            case Kind.FRAGMENT_DEFINITION: {
              const typeConditionAST = node.typeCondition;
              const outputType = typeConditionAST ? typeFromAST(schema, typeConditionAST) : getNamedType(this.getType());
              this._typeStack.push(isOutputType(outputType) ? outputType : void 0);
              break;
            }
            case Kind.VARIABLE_DEFINITION: {
              const inputType = typeFromAST(schema, node.type);
              this._inputTypeStack.push(
                isInputType(inputType) ? inputType : void 0
              );
              break;
            }
            case Kind.ARGUMENT: {
              var _this$getDirective;
              let argDef;
              let argType;
              const fieldOrDirective = (_this$getDirective = this.getDirective()) !== null && _this$getDirective !== void 0 ? _this$getDirective : this.getFieldDef();
              if (fieldOrDirective) {
                argDef = fieldOrDirective.args.find(
                  (arg) => arg.name === node.name.value
                );
                if (argDef) {
                  argType = argDef.type;
                }
              }
              this._argument = argDef;
              this._defaultValueStack.push(argDef ? argDef.defaultValue : void 0);
              this._inputTypeStack.push(isInputType(argType) ? argType : void 0);
              break;
            }
            case Kind.LIST: {
              const listType = getNullableType(this.getInputType());
              const itemType = isListType(listType) ? listType.ofType : listType;
              this._defaultValueStack.push(void 0);
              this._inputTypeStack.push(isInputType(itemType) ? itemType : void 0);
              break;
            }
            case Kind.OBJECT_FIELD: {
              const objectType = getNamedType(this.getInputType());
              let inputFieldType;
              let inputField;
              if (isInputObjectType(objectType)) {
                inputField = objectType.getFields()[node.name.value];
                if (inputField) {
                  inputFieldType = inputField.type;
                }
              }
              this._defaultValueStack.push(
                inputField ? inputField.defaultValue : void 0
              );
              this._inputTypeStack.push(
                isInputType(inputFieldType) ? inputFieldType : void 0
              );
              break;
            }
            case Kind.ENUM: {
              const enumType = getNamedType(this.getInputType());
              let enumValue;
              if (isEnumType(enumType)) {
                enumValue = enumType.getValue(node.value);
              }
              this._enumValue = enumValue;
              break;
            }
            default:
          }
        }
        leave(node) {
          switch (node.kind) {
            case Kind.SELECTION_SET:
              this._parentTypeStack.pop();
              break;
            case Kind.FIELD:
              this._fieldDefStack.pop();
              this._typeStack.pop();
              break;
            case Kind.DIRECTIVE:
              this._directive = null;
              break;
            case Kind.OPERATION_DEFINITION:
            case Kind.INLINE_FRAGMENT:
            case Kind.FRAGMENT_DEFINITION:
              this._typeStack.pop();
              break;
            case Kind.VARIABLE_DEFINITION:
              this._inputTypeStack.pop();
              break;
            case Kind.ARGUMENT:
              this._argument = null;
              this._defaultValueStack.pop();
              this._inputTypeStack.pop();
              break;
            case Kind.LIST:
            case Kind.OBJECT_FIELD:
              this._defaultValueStack.pop();
              this._inputTypeStack.pop();
              break;
            case Kind.ENUM:
              this._enumValue = null;
              break;
            default:
          }
        }
      };
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/language/predicates.mjs
  function isDefinitionNode(node) {
    return isExecutableDefinitionNode(node) || isTypeSystemDefinitionNode(node) || isTypeSystemExtensionNode(node);
  }
  function isExecutableDefinitionNode(node) {
    return node.kind === Kind.OPERATION_DEFINITION || node.kind === Kind.FRAGMENT_DEFINITION;
  }
  function isSelectionNode(node) {
    return node.kind === Kind.FIELD || node.kind === Kind.FRAGMENT_SPREAD || node.kind === Kind.INLINE_FRAGMENT;
  }
  function isValueNode(node) {
    return node.kind === Kind.VARIABLE || node.kind === Kind.INT || node.kind === Kind.FLOAT || node.kind === Kind.STRING || node.kind === Kind.BOOLEAN || node.kind === Kind.NULL || node.kind === Kind.ENUM || node.kind === Kind.LIST || node.kind === Kind.OBJECT;
  }
  function isConstValueNode(node) {
    return isValueNode(node) && (node.kind === Kind.LIST ? node.values.some(isConstValueNode) : node.kind === Kind.OBJECT ? node.fields.some((field) => isConstValueNode(field.value)) : node.kind !== Kind.VARIABLE);
  }
  function isTypeNode(node) {
    return node.kind === Kind.NAMED_TYPE || node.kind === Kind.LIST_TYPE || node.kind === Kind.NON_NULL_TYPE;
  }
  function isTypeSystemDefinitionNode(node) {
    return node.kind === Kind.SCHEMA_DEFINITION || isTypeDefinitionNode(node) || node.kind === Kind.DIRECTIVE_DEFINITION;
  }
  function isTypeDefinitionNode(node) {
    return node.kind === Kind.SCALAR_TYPE_DEFINITION || node.kind === Kind.OBJECT_TYPE_DEFINITION || node.kind === Kind.INTERFACE_TYPE_DEFINITION || node.kind === Kind.UNION_TYPE_DEFINITION || node.kind === Kind.ENUM_TYPE_DEFINITION || node.kind === Kind.INPUT_OBJECT_TYPE_DEFINITION;
  }
  function isTypeSystemExtensionNode(node) {
    return node.kind === Kind.SCHEMA_EXTENSION || isTypeExtensionNode(node);
  }
  function isTypeExtensionNode(node) {
    return node.kind === Kind.SCALAR_TYPE_EXTENSION || node.kind === Kind.OBJECT_TYPE_EXTENSION || node.kind === Kind.INTERFACE_TYPE_EXTENSION || node.kind === Kind.UNION_TYPE_EXTENSION || node.kind === Kind.ENUM_TYPE_EXTENSION || node.kind === Kind.INPUT_OBJECT_TYPE_EXTENSION;
  }
  var init_predicates = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/language/predicates.mjs"() {
      "use strict";
      init_kinds();
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/validation/rules/ExecutableDefinitionsRule.mjs
  function ExecutableDefinitionsRule(context) {
    return {
      Document(node) {
        for (const definition of node.definitions) {
          if (!isExecutableDefinitionNode(definition)) {
            const defName = definition.kind === Kind.SCHEMA_DEFINITION || definition.kind === Kind.SCHEMA_EXTENSION ? "schema" : '"' + definition.name.value + '"';
            context.reportError(
              new GraphQLError(`The ${defName} definition is not executable.`, {
                nodes: definition
              })
            );
          }
        }
        return false;
      }
    };
  }
  var init_ExecutableDefinitionsRule = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/validation/rules/ExecutableDefinitionsRule.mjs"() {
      "use strict";
      init_GraphQLError();
      init_kinds();
      init_predicates();
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/validation/rules/FieldsOnCorrectTypeRule.mjs
  function FieldsOnCorrectTypeRule(context) {
    return {
      Field(node) {
        const type = context.getParentType();
        if (type) {
          const fieldDef = context.getFieldDef();
          if (!fieldDef) {
            const schema = context.getSchema();
            const fieldName = node.name.value;
            let suggestion = didYouMean(
              "to use an inline fragment on",
              getSuggestedTypeNames(schema, type, fieldName)
            );
            if (suggestion === "") {
              suggestion = didYouMean(getSuggestedFieldNames(type, fieldName));
            }
            context.reportError(
              new GraphQLError(
                `Cannot query field "${fieldName}" on type "${type.name}".` + suggestion,
                {
                  nodes: node
                }
              )
            );
          }
        }
      }
    };
  }
  function getSuggestedTypeNames(schema, type, fieldName) {
    if (!isAbstractType(type)) {
      return [];
    }
    const suggestedTypes = /* @__PURE__ */ new Set();
    const usageCount = /* @__PURE__ */ Object.create(null);
    for (const possibleType of schema.getPossibleTypes(type)) {
      if (!possibleType.getFields()[fieldName]) {
        continue;
      }
      suggestedTypes.add(possibleType);
      usageCount[possibleType.name] = 1;
      for (const possibleInterface of possibleType.getInterfaces()) {
        var _usageCount$possibleI;
        if (!possibleInterface.getFields()[fieldName]) {
          continue;
        }
        suggestedTypes.add(possibleInterface);
        usageCount[possibleInterface.name] = ((_usageCount$possibleI = usageCount[possibleInterface.name]) !== null && _usageCount$possibleI !== void 0 ? _usageCount$possibleI : 0) + 1;
      }
    }
    return [...suggestedTypes].sort((typeA, typeB) => {
      const usageCountDiff = usageCount[typeB.name] - usageCount[typeA.name];
      if (usageCountDiff !== 0) {
        return usageCountDiff;
      }
      if (isInterfaceType(typeA) && schema.isSubType(typeA, typeB)) {
        return -1;
      }
      if (isInterfaceType(typeB) && schema.isSubType(typeB, typeA)) {
        return 1;
      }
      return naturalCompare(typeA.name, typeB.name);
    }).map((x) => x.name);
  }
  function getSuggestedFieldNames(type, fieldName) {
    if (isObjectType(type) || isInterfaceType(type)) {
      const possibleFieldNames = Object.keys(type.getFields());
      return suggestionList(fieldName, possibleFieldNames);
    }
    return [];
  }
  var init_FieldsOnCorrectTypeRule = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/validation/rules/FieldsOnCorrectTypeRule.mjs"() {
      "use strict";
      init_didYouMean();
      init_naturalCompare();
      init_suggestionList();
      init_GraphQLError();
      init_definition();
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/validation/rules/FragmentsOnCompositeTypesRule.mjs
  function FragmentsOnCompositeTypesRule(context) {
    return {
      InlineFragment(node) {
        const typeCondition = node.typeCondition;
        if (typeCondition) {
          const type = typeFromAST(context.getSchema(), typeCondition);
          if (type && !isCompositeType(type)) {
            const typeStr = print(typeCondition);
            context.reportError(
              new GraphQLError(
                `Fragment cannot condition on non composite type "${typeStr}".`,
                {
                  nodes: typeCondition
                }
              )
            );
          }
        }
      },
      FragmentDefinition(node) {
        const type = typeFromAST(context.getSchema(), node.typeCondition);
        if (type && !isCompositeType(type)) {
          const typeStr = print(node.typeCondition);
          context.reportError(
            new GraphQLError(
              `Fragment "${node.name.value}" cannot condition on non composite type "${typeStr}".`,
              {
                nodes: node.typeCondition
              }
            )
          );
        }
      }
    };
  }
  var init_FragmentsOnCompositeTypesRule = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/validation/rules/FragmentsOnCompositeTypesRule.mjs"() {
      "use strict";
      init_GraphQLError();
      init_printer();
      init_definition();
      init_typeFromAST();
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/validation/rules/KnownArgumentNamesRule.mjs
  function KnownArgumentNamesRule(context) {
    return {
      // eslint-disable-next-line new-cap
      ...KnownArgumentNamesOnDirectivesRule(context),
      Argument(argNode) {
        const argDef = context.getArgument();
        const fieldDef = context.getFieldDef();
        const parentType = context.getParentType();
        if (!argDef && fieldDef && parentType) {
          const argName = argNode.name.value;
          const knownArgsNames = fieldDef.args.map((arg) => arg.name);
          const suggestions = suggestionList(argName, knownArgsNames);
          context.reportError(
            new GraphQLError(
              `Unknown argument "${argName}" on field "${parentType.name}.${fieldDef.name}".` + didYouMean(suggestions),
              {
                nodes: argNode
              }
            )
          );
        }
      }
    };
  }
  function KnownArgumentNamesOnDirectivesRule(context) {
    const directiveArgs = /* @__PURE__ */ Object.create(null);
    const schema = context.getSchema();
    const definedDirectives = schema ? schema.getDirectives() : specifiedDirectives;
    for (const directive of definedDirectives) {
      directiveArgs[directive.name] = directive.args.map((arg) => arg.name);
    }
    const astDefinitions = context.getDocument().definitions;
    for (const def of astDefinitions) {
      if (def.kind === Kind.DIRECTIVE_DEFINITION) {
        var _def$arguments;
        const argsNodes = (_def$arguments = def.arguments) !== null && _def$arguments !== void 0 ? _def$arguments : [];
        directiveArgs[def.name.value] = argsNodes.map((arg) => arg.name.value);
      }
    }
    return {
      Directive(directiveNode) {
        const directiveName = directiveNode.name.value;
        const knownArgs = directiveArgs[directiveName];
        if (directiveNode.arguments && knownArgs) {
          for (const argNode of directiveNode.arguments) {
            const argName = argNode.name.value;
            if (!knownArgs.includes(argName)) {
              const suggestions = suggestionList(argName, knownArgs);
              context.reportError(
                new GraphQLError(
                  `Unknown argument "${argName}" on directive "@${directiveName}".` + didYouMean(suggestions),
                  {
                    nodes: argNode
                  }
                )
              );
            }
          }
        }
        return false;
      }
    };
  }
  var init_KnownArgumentNamesRule = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/validation/rules/KnownArgumentNamesRule.mjs"() {
      "use strict";
      init_didYouMean();
      init_suggestionList();
      init_GraphQLError();
      init_kinds();
      init_directives();
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/validation/rules/KnownDirectivesRule.mjs
  function KnownDirectivesRule(context) {
    const locationsMap = /* @__PURE__ */ Object.create(null);
    const schema = context.getSchema();
    const definedDirectives = schema ? schema.getDirectives() : specifiedDirectives;
    for (const directive of definedDirectives) {
      locationsMap[directive.name] = directive.locations;
    }
    const astDefinitions = context.getDocument().definitions;
    for (const def of astDefinitions) {
      if (def.kind === Kind.DIRECTIVE_DEFINITION) {
        locationsMap[def.name.value] = def.locations.map((name) => name.value);
      }
    }
    return {
      Directive(node, _key, _parent, _path, ancestors) {
        const name = node.name.value;
        const locations = locationsMap[name];
        if (!locations) {
          context.reportError(
            new GraphQLError(`Unknown directive "@${name}".`, {
              nodes: node
            })
          );
          return;
        }
        const candidateLocation = getDirectiveLocationForASTPath(ancestors);
        if (candidateLocation && !locations.includes(candidateLocation)) {
          context.reportError(
            new GraphQLError(
              `Directive "@${name}" may not be used on ${candidateLocation}.`,
              {
                nodes: node
              }
            )
          );
        }
      }
    };
  }
  function getDirectiveLocationForASTPath(ancestors) {
    const appliedTo = ancestors[ancestors.length - 1];
    "kind" in appliedTo || invariant2(false);
    switch (appliedTo.kind) {
      case Kind.OPERATION_DEFINITION:
        return getDirectiveLocationForOperation(appliedTo.operation);
      case Kind.FIELD:
        return DirectiveLocation.FIELD;
      case Kind.FRAGMENT_SPREAD:
        return DirectiveLocation.FRAGMENT_SPREAD;
      case Kind.INLINE_FRAGMENT:
        return DirectiveLocation.INLINE_FRAGMENT;
      case Kind.FRAGMENT_DEFINITION:
        return DirectiveLocation.FRAGMENT_DEFINITION;
      case Kind.VARIABLE_DEFINITION:
        return DirectiveLocation.VARIABLE_DEFINITION;
      case Kind.SCHEMA_DEFINITION:
      case Kind.SCHEMA_EXTENSION:
        return DirectiveLocation.SCHEMA;
      case Kind.SCALAR_TYPE_DEFINITION:
      case Kind.SCALAR_TYPE_EXTENSION:
        return DirectiveLocation.SCALAR;
      case Kind.OBJECT_TYPE_DEFINITION:
      case Kind.OBJECT_TYPE_EXTENSION:
        return DirectiveLocation.OBJECT;
      case Kind.FIELD_DEFINITION:
        return DirectiveLocation.FIELD_DEFINITION;
      case Kind.INTERFACE_TYPE_DEFINITION:
      case Kind.INTERFACE_TYPE_EXTENSION:
        return DirectiveLocation.INTERFACE;
      case Kind.UNION_TYPE_DEFINITION:
      case Kind.UNION_TYPE_EXTENSION:
        return DirectiveLocation.UNION;
      case Kind.ENUM_TYPE_DEFINITION:
      case Kind.ENUM_TYPE_EXTENSION:
        return DirectiveLocation.ENUM;
      case Kind.ENUM_VALUE_DEFINITION:
        return DirectiveLocation.ENUM_VALUE;
      case Kind.INPUT_OBJECT_TYPE_DEFINITION:
      case Kind.INPUT_OBJECT_TYPE_EXTENSION:
        return DirectiveLocation.INPUT_OBJECT;
      case Kind.INPUT_VALUE_DEFINITION: {
        const parentNode = ancestors[ancestors.length - 3];
        "kind" in parentNode || invariant2(false);
        return parentNode.kind === Kind.INPUT_OBJECT_TYPE_DEFINITION ? DirectiveLocation.INPUT_FIELD_DEFINITION : DirectiveLocation.ARGUMENT_DEFINITION;
      }
      // Not reachable, all possible types have been considered.
      /* c8 ignore next */
      default:
        invariant2(false, "Unexpected kind: " + inspect(appliedTo.kind));
    }
  }
  function getDirectiveLocationForOperation(operation) {
    switch (operation) {
      case OperationTypeNode.QUERY:
        return DirectiveLocation.QUERY;
      case OperationTypeNode.MUTATION:
        return DirectiveLocation.MUTATION;
      case OperationTypeNode.SUBSCRIPTION:
        return DirectiveLocation.SUBSCRIPTION;
    }
  }
  var init_KnownDirectivesRule = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/validation/rules/KnownDirectivesRule.mjs"() {
      "use strict";
      init_inspect();
      init_invariant();
      init_GraphQLError();
      init_ast();
      init_directiveLocation();
      init_kinds();
      init_directives();
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/validation/rules/KnownFragmentNamesRule.mjs
  function KnownFragmentNamesRule(context) {
    return {
      FragmentSpread(node) {
        const fragmentName = node.name.value;
        const fragment = context.getFragment(fragmentName);
        if (!fragment) {
          context.reportError(
            new GraphQLError(`Unknown fragment "${fragmentName}".`, {
              nodes: node.name
            })
          );
        }
      }
    };
  }
  var init_KnownFragmentNamesRule = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/validation/rules/KnownFragmentNamesRule.mjs"() {
      "use strict";
      init_GraphQLError();
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/validation/rules/KnownTypeNamesRule.mjs
  function KnownTypeNamesRule(context) {
    const schema = context.getSchema();
    const existingTypesMap = schema ? schema.getTypeMap() : /* @__PURE__ */ Object.create(null);
    const definedTypes = /* @__PURE__ */ Object.create(null);
    for (const def of context.getDocument().definitions) {
      if (isTypeDefinitionNode(def)) {
        definedTypes[def.name.value] = true;
      }
    }
    const typeNames = [
      ...Object.keys(existingTypesMap),
      ...Object.keys(definedTypes)
    ];
    return {
      NamedType(node, _1, parent, _2, ancestors) {
        const typeName = node.name.value;
        if (!existingTypesMap[typeName] && !definedTypes[typeName]) {
          var _ancestors$;
          const definitionNode = (_ancestors$ = ancestors[2]) !== null && _ancestors$ !== void 0 ? _ancestors$ : parent;
          const isSDL = definitionNode != null && isSDLNode(definitionNode);
          if (isSDL && standardTypeNames.includes(typeName)) {
            return;
          }
          const suggestedTypes = suggestionList(
            typeName,
            isSDL ? standardTypeNames.concat(typeNames) : typeNames
          );
          context.reportError(
            new GraphQLError(
              `Unknown type "${typeName}".` + didYouMean(suggestedTypes),
              {
                nodes: node
              }
            )
          );
        }
      }
    };
  }
  function isSDLNode(value) {
    return "kind" in value && (isTypeSystemDefinitionNode(value) || isTypeSystemExtensionNode(value));
  }
  var standardTypeNames;
  var init_KnownTypeNamesRule = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/validation/rules/KnownTypeNamesRule.mjs"() {
      "use strict";
      init_didYouMean();
      init_suggestionList();
      init_GraphQLError();
      init_predicates();
      init_introspection();
      init_scalars();
      standardTypeNames = [...specifiedScalarTypes, ...introspectionTypes].map(
        (type) => type.name
      );
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/validation/rules/LoneAnonymousOperationRule.mjs
  function LoneAnonymousOperationRule(context) {
    let operationCount = 0;
    return {
      Document(node) {
        operationCount = node.definitions.filter(
          (definition) => definition.kind === Kind.OPERATION_DEFINITION
        ).length;
      },
      OperationDefinition(node) {
        if (!node.name && operationCount > 1) {
          context.reportError(
            new GraphQLError(
              "This anonymous operation must be the only defined operation.",
              {
                nodes: node
              }
            )
          );
        }
      }
    };
  }
  var init_LoneAnonymousOperationRule = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/validation/rules/LoneAnonymousOperationRule.mjs"() {
      "use strict";
      init_GraphQLError();
      init_kinds();
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/validation/rules/LoneSchemaDefinitionRule.mjs
  function LoneSchemaDefinitionRule(context) {
    var _ref, _ref2, _oldSchema$astNode;
    const oldSchema = context.getSchema();
    const alreadyDefined = (_ref = (_ref2 = (_oldSchema$astNode = oldSchema === null || oldSchema === void 0 ? void 0 : oldSchema.astNode) !== null && _oldSchema$astNode !== void 0 ? _oldSchema$astNode : oldSchema === null || oldSchema === void 0 ? void 0 : oldSchema.getQueryType()) !== null && _ref2 !== void 0 ? _ref2 : oldSchema === null || oldSchema === void 0 ? void 0 : oldSchema.getMutationType()) !== null && _ref !== void 0 ? _ref : oldSchema === null || oldSchema === void 0 ? void 0 : oldSchema.getSubscriptionType();
    let schemaDefinitionsCount = 0;
    return {
      SchemaDefinition(node) {
        if (alreadyDefined) {
          context.reportError(
            new GraphQLError(
              "Cannot define a new schema within a schema extension.",
              {
                nodes: node
              }
            )
          );
          return;
        }
        if (schemaDefinitionsCount > 0) {
          context.reportError(
            new GraphQLError("Must provide only one schema definition.", {
              nodes: node
            })
          );
        }
        ++schemaDefinitionsCount;
      }
    };
  }
  var init_LoneSchemaDefinitionRule = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/validation/rules/LoneSchemaDefinitionRule.mjs"() {
      "use strict";
      init_GraphQLError();
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/validation/rules/NoFragmentCyclesRule.mjs
  function NoFragmentCyclesRule(context) {
    const visitedFrags = /* @__PURE__ */ Object.create(null);
    const spreadPath = [];
    const spreadPathIndexByName = /* @__PURE__ */ Object.create(null);
    return {
      OperationDefinition: () => false,
      FragmentDefinition(node) {
        detectCycleRecursive(node);
        return false;
      }
    };
    function detectCycleRecursive(fragment) {
      if (visitedFrags[fragment.name.value]) {
        return;
      }
      const fragmentName = fragment.name.value;
      visitedFrags[fragmentName] = true;
      const spreadNodes = context.getFragmentSpreads(fragment.selectionSet);
      if (spreadNodes.length === 0) {
        return;
      }
      spreadPathIndexByName[fragmentName] = spreadPath.length;
      for (const spreadNode of spreadNodes) {
        const spreadName = spreadNode.name.value;
        const cycleIndex = spreadPathIndexByName[spreadName];
        spreadPath.push(spreadNode);
        if (cycleIndex === void 0) {
          const spreadFragment = context.getFragment(spreadName);
          if (spreadFragment) {
            detectCycleRecursive(spreadFragment);
          }
        } else {
          const cyclePath = spreadPath.slice(cycleIndex);
          const viaPath = cyclePath.slice(0, -1).map((s) => '"' + s.name.value + '"').join(", ");
          context.reportError(
            new GraphQLError(
              `Cannot spread fragment "${spreadName}" within itself` + (viaPath !== "" ? ` via ${viaPath}.` : "."),
              {
                nodes: cyclePath
              }
            )
          );
        }
        spreadPath.pop();
      }
      spreadPathIndexByName[fragmentName] = void 0;
    }
  }
  var init_NoFragmentCyclesRule = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/validation/rules/NoFragmentCyclesRule.mjs"() {
      "use strict";
      init_GraphQLError();
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/validation/rules/NoUndefinedVariablesRule.mjs
  function NoUndefinedVariablesRule(context) {
    let variableNameDefined = /* @__PURE__ */ Object.create(null);
    return {
      OperationDefinition: {
        enter() {
          variableNameDefined = /* @__PURE__ */ Object.create(null);
        },
        leave(operation) {
          const usages = context.getRecursiveVariableUsages(operation);
          for (const { node } of usages) {
            const varName = node.name.value;
            if (variableNameDefined[varName] !== true) {
              context.reportError(
                new GraphQLError(
                  operation.name ? `Variable "$${varName}" is not defined by operation "${operation.name.value}".` : `Variable "$${varName}" is not defined.`,
                  {
                    nodes: [node, operation]
                  }
                )
              );
            }
          }
        }
      },
      VariableDefinition(node) {
        variableNameDefined[node.variable.name.value] = true;
      }
    };
  }
  var init_NoUndefinedVariablesRule = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/validation/rules/NoUndefinedVariablesRule.mjs"() {
      "use strict";
      init_GraphQLError();
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/validation/rules/NoUnusedFragmentsRule.mjs
  function NoUnusedFragmentsRule(context) {
    const operationDefs = [];
    const fragmentDefs = [];
    return {
      OperationDefinition(node) {
        operationDefs.push(node);
        return false;
      },
      FragmentDefinition(node) {
        fragmentDefs.push(node);
        return false;
      },
      Document: {
        leave() {
          const fragmentNameUsed = /* @__PURE__ */ Object.create(null);
          for (const operation of operationDefs) {
            for (const fragment of context.getRecursivelyReferencedFragments(
              operation
            )) {
              fragmentNameUsed[fragment.name.value] = true;
            }
          }
          for (const fragmentDef of fragmentDefs) {
            const fragName = fragmentDef.name.value;
            if (fragmentNameUsed[fragName] !== true) {
              context.reportError(
                new GraphQLError(`Fragment "${fragName}" is never used.`, {
                  nodes: fragmentDef
                })
              );
            }
          }
        }
      }
    };
  }
  var init_NoUnusedFragmentsRule = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/validation/rules/NoUnusedFragmentsRule.mjs"() {
      "use strict";
      init_GraphQLError();
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/validation/rules/NoUnusedVariablesRule.mjs
  function NoUnusedVariablesRule(context) {
    let variableDefs = [];
    return {
      OperationDefinition: {
        enter() {
          variableDefs = [];
        },
        leave(operation) {
          const variableNameUsed = /* @__PURE__ */ Object.create(null);
          const usages = context.getRecursiveVariableUsages(operation);
          for (const { node } of usages) {
            variableNameUsed[node.name.value] = true;
          }
          for (const variableDef of variableDefs) {
            const variableName = variableDef.variable.name.value;
            if (variableNameUsed[variableName] !== true) {
              context.reportError(
                new GraphQLError(
                  operation.name ? `Variable "$${variableName}" is never used in operation "${operation.name.value}".` : `Variable "$${variableName}" is never used.`,
                  {
                    nodes: variableDef
                  }
                )
              );
            }
          }
        }
      },
      VariableDefinition(def) {
        variableDefs.push(def);
      }
    };
  }
  var init_NoUnusedVariablesRule = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/validation/rules/NoUnusedVariablesRule.mjs"() {
      "use strict";
      init_GraphQLError();
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/utilities/sortValueNode.mjs
  function sortValueNode(valueNode) {
    switch (valueNode.kind) {
      case Kind.OBJECT:
        return { ...valueNode, fields: sortFields(valueNode.fields) };
      case Kind.LIST:
        return { ...valueNode, values: valueNode.values.map(sortValueNode) };
      case Kind.INT:
      case Kind.FLOAT:
      case Kind.STRING:
      case Kind.BOOLEAN:
      case Kind.NULL:
      case Kind.ENUM:
      case Kind.VARIABLE:
        return valueNode;
    }
  }
  function sortFields(fields) {
    return fields.map((fieldNode) => ({
      ...fieldNode,
      value: sortValueNode(fieldNode.value)
    })).sort(
      (fieldA, fieldB) => naturalCompare(fieldA.name.value, fieldB.name.value)
    );
  }
  var init_sortValueNode = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/utilities/sortValueNode.mjs"() {
      "use strict";
      init_naturalCompare();
      init_kinds();
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/validation/rules/OverlappingFieldsCanBeMergedRule.mjs
  function reasonMessage(reason) {
    if (Array.isArray(reason)) {
      return reason.map(
        ([responseName, subReason]) => `subfields "${responseName}" conflict because ` + reasonMessage(subReason)
      ).join(" and ");
    }
    return reason;
  }
  function OverlappingFieldsCanBeMergedRule(context) {
    const comparedFragmentPairs = new PairSet();
    const cachedFieldsAndFragmentNames = /* @__PURE__ */ new Map();
    return {
      SelectionSet(selectionSet) {
        const conflicts = findConflictsWithinSelectionSet(
          context,
          cachedFieldsAndFragmentNames,
          comparedFragmentPairs,
          context.getParentType(),
          selectionSet
        );
        for (const [[responseName, reason], fields1, fields2] of conflicts) {
          const reasonMsg = reasonMessage(reason);
          context.reportError(
            new GraphQLError(
              `Fields "${responseName}" conflict because ${reasonMsg}. Use different aliases on the fields to fetch both if this was intentional.`,
              {
                nodes: fields1.concat(fields2)
              }
            )
          );
        }
      }
    };
  }
  function findConflictsWithinSelectionSet(context, cachedFieldsAndFragmentNames, comparedFragmentPairs, parentType, selectionSet) {
    const conflicts = [];
    const [fieldMap, fragmentNames] = getFieldsAndFragmentNames(
      context,
      cachedFieldsAndFragmentNames,
      parentType,
      selectionSet
    );
    collectConflictsWithin(
      context,
      conflicts,
      cachedFieldsAndFragmentNames,
      comparedFragmentPairs,
      fieldMap
    );
    if (fragmentNames.length !== 0) {
      for (let i = 0; i < fragmentNames.length; i++) {
        collectConflictsBetweenFieldsAndFragment(
          context,
          conflicts,
          cachedFieldsAndFragmentNames,
          comparedFragmentPairs,
          false,
          fieldMap,
          fragmentNames[i]
        );
        for (let j = i + 1; j < fragmentNames.length; j++) {
          collectConflictsBetweenFragments(
            context,
            conflicts,
            cachedFieldsAndFragmentNames,
            comparedFragmentPairs,
            false,
            fragmentNames[i],
            fragmentNames[j]
          );
        }
      }
    }
    return conflicts;
  }
  function collectConflictsBetweenFieldsAndFragment(context, conflicts, cachedFieldsAndFragmentNames, comparedFragmentPairs, areMutuallyExclusive, fieldMap, fragmentName) {
    const fragment = context.getFragment(fragmentName);
    if (!fragment) {
      return;
    }
    const [fieldMap2, referencedFragmentNames] = getReferencedFieldsAndFragmentNames(
      context,
      cachedFieldsAndFragmentNames,
      fragment
    );
    if (fieldMap === fieldMap2) {
      return;
    }
    collectConflictsBetween(
      context,
      conflicts,
      cachedFieldsAndFragmentNames,
      comparedFragmentPairs,
      areMutuallyExclusive,
      fieldMap,
      fieldMap2
    );
    for (const referencedFragmentName of referencedFragmentNames) {
      if (comparedFragmentPairs.has(
        referencedFragmentName,
        fragmentName,
        areMutuallyExclusive
      )) {
        continue;
      }
      comparedFragmentPairs.add(
        referencedFragmentName,
        fragmentName,
        areMutuallyExclusive
      );
      collectConflictsBetweenFieldsAndFragment(
        context,
        conflicts,
        cachedFieldsAndFragmentNames,
        comparedFragmentPairs,
        areMutuallyExclusive,
        fieldMap,
        referencedFragmentName
      );
    }
  }
  function collectConflictsBetweenFragments(context, conflicts, cachedFieldsAndFragmentNames, comparedFragmentPairs, areMutuallyExclusive, fragmentName1, fragmentName2) {
    if (fragmentName1 === fragmentName2) {
      return;
    }
    if (comparedFragmentPairs.has(
      fragmentName1,
      fragmentName2,
      areMutuallyExclusive
    )) {
      return;
    }
    comparedFragmentPairs.add(fragmentName1, fragmentName2, areMutuallyExclusive);
    const fragment1 = context.getFragment(fragmentName1);
    const fragment2 = context.getFragment(fragmentName2);
    if (!fragment1 || !fragment2) {
      return;
    }
    const [fieldMap1, referencedFragmentNames1] = getReferencedFieldsAndFragmentNames(
      context,
      cachedFieldsAndFragmentNames,
      fragment1
    );
    const [fieldMap2, referencedFragmentNames2] = getReferencedFieldsAndFragmentNames(
      context,
      cachedFieldsAndFragmentNames,
      fragment2
    );
    collectConflictsBetween(
      context,
      conflicts,
      cachedFieldsAndFragmentNames,
      comparedFragmentPairs,
      areMutuallyExclusive,
      fieldMap1,
      fieldMap2
    );
    for (const referencedFragmentName2 of referencedFragmentNames2) {
      collectConflictsBetweenFragments(
        context,
        conflicts,
        cachedFieldsAndFragmentNames,
        comparedFragmentPairs,
        areMutuallyExclusive,
        fragmentName1,
        referencedFragmentName2
      );
    }
    for (const referencedFragmentName1 of referencedFragmentNames1) {
      collectConflictsBetweenFragments(
        context,
        conflicts,
        cachedFieldsAndFragmentNames,
        comparedFragmentPairs,
        areMutuallyExclusive,
        referencedFragmentName1,
        fragmentName2
      );
    }
  }
  function findConflictsBetweenSubSelectionSets(context, cachedFieldsAndFragmentNames, comparedFragmentPairs, areMutuallyExclusive, parentType1, selectionSet1, parentType2, selectionSet2) {
    const conflicts = [];
    const [fieldMap1, fragmentNames1] = getFieldsAndFragmentNames(
      context,
      cachedFieldsAndFragmentNames,
      parentType1,
      selectionSet1
    );
    const [fieldMap2, fragmentNames2] = getFieldsAndFragmentNames(
      context,
      cachedFieldsAndFragmentNames,
      parentType2,
      selectionSet2
    );
    collectConflictsBetween(
      context,
      conflicts,
      cachedFieldsAndFragmentNames,
      comparedFragmentPairs,
      areMutuallyExclusive,
      fieldMap1,
      fieldMap2
    );
    for (const fragmentName2 of fragmentNames2) {
      collectConflictsBetweenFieldsAndFragment(
        context,
        conflicts,
        cachedFieldsAndFragmentNames,
        comparedFragmentPairs,
        areMutuallyExclusive,
        fieldMap1,
        fragmentName2
      );
    }
    for (const fragmentName1 of fragmentNames1) {
      collectConflictsBetweenFieldsAndFragment(
        context,
        conflicts,
        cachedFieldsAndFragmentNames,
        comparedFragmentPairs,
        areMutuallyExclusive,
        fieldMap2,
        fragmentName1
      );
    }
    for (const fragmentName1 of fragmentNames1) {
      for (const fragmentName2 of fragmentNames2) {
        collectConflictsBetweenFragments(
          context,
          conflicts,
          cachedFieldsAndFragmentNames,
          comparedFragmentPairs,
          areMutuallyExclusive,
          fragmentName1,
          fragmentName2
        );
      }
    }
    return conflicts;
  }
  function collectConflictsWithin(context, conflicts, cachedFieldsAndFragmentNames, comparedFragmentPairs, fieldMap) {
    for (const [responseName, fields] of Object.entries(fieldMap)) {
      if (fields.length > 1) {
        for (let i = 0; i < fields.length; i++) {
          for (let j = i + 1; j < fields.length; j++) {
            const conflict = findConflict(
              context,
              cachedFieldsAndFragmentNames,
              comparedFragmentPairs,
              false,
              // within one collection is never mutually exclusive
              responseName,
              fields[i],
              fields[j]
            );
            if (conflict) {
              conflicts.push(conflict);
            }
          }
        }
      }
    }
  }
  function collectConflictsBetween(context, conflicts, cachedFieldsAndFragmentNames, comparedFragmentPairs, parentFieldsAreMutuallyExclusive, fieldMap1, fieldMap2) {
    for (const [responseName, fields1] of Object.entries(fieldMap1)) {
      const fields2 = fieldMap2[responseName];
      if (fields2) {
        for (const field1 of fields1) {
          for (const field2 of fields2) {
            const conflict = findConflict(
              context,
              cachedFieldsAndFragmentNames,
              comparedFragmentPairs,
              parentFieldsAreMutuallyExclusive,
              responseName,
              field1,
              field2
            );
            if (conflict) {
              conflicts.push(conflict);
            }
          }
        }
      }
    }
  }
  function findConflict(context, cachedFieldsAndFragmentNames, comparedFragmentPairs, parentFieldsAreMutuallyExclusive, responseName, field1, field2) {
    const [parentType1, node1, def1] = field1;
    const [parentType2, node2, def2] = field2;
    const areMutuallyExclusive = parentFieldsAreMutuallyExclusive || parentType1 !== parentType2 && isObjectType(parentType1) && isObjectType(parentType2);
    if (!areMutuallyExclusive) {
      const name1 = node1.name.value;
      const name2 = node2.name.value;
      if (name1 !== name2) {
        return [
          [responseName, `"${name1}" and "${name2}" are different fields`],
          [node1],
          [node2]
        ];
      }
      if (!sameArguments(node1, node2)) {
        return [
          [responseName, "they have differing arguments"],
          [node1],
          [node2]
        ];
      }
    }
    const type1 = def1 === null || def1 === void 0 ? void 0 : def1.type;
    const type2 = def2 === null || def2 === void 0 ? void 0 : def2.type;
    if (type1 && type2 && doTypesConflict(type1, type2)) {
      return [
        [
          responseName,
          `they return conflicting types "${inspect(type1)}" and "${inspect(
            type2
          )}"`
        ],
        [node1],
        [node2]
      ];
    }
    const selectionSet1 = node1.selectionSet;
    const selectionSet2 = node2.selectionSet;
    if (selectionSet1 && selectionSet2) {
      const conflicts = findConflictsBetweenSubSelectionSets(
        context,
        cachedFieldsAndFragmentNames,
        comparedFragmentPairs,
        areMutuallyExclusive,
        getNamedType(type1),
        selectionSet1,
        getNamedType(type2),
        selectionSet2
      );
      return subfieldConflicts(conflicts, responseName, node1, node2);
    }
  }
  function sameArguments(node1, node2) {
    const args1 = node1.arguments;
    const args2 = node2.arguments;
    if (args1 === void 0 || args1.length === 0) {
      return args2 === void 0 || args2.length === 0;
    }
    if (args2 === void 0 || args2.length === 0) {
      return false;
    }
    if (args1.length !== args2.length) {
      return false;
    }
    const values2 = new Map(args2.map(({ name, value }) => [name.value, value]));
    return args1.every((arg1) => {
      const value1 = arg1.value;
      const value2 = values2.get(arg1.name.value);
      if (value2 === void 0) {
        return false;
      }
      return stringifyValue(value1) === stringifyValue(value2);
    });
  }
  function stringifyValue(value) {
    return print(sortValueNode(value));
  }
  function doTypesConflict(type1, type2) {
    if (isListType(type1)) {
      return isListType(type2) ? doTypesConflict(type1.ofType, type2.ofType) : true;
    }
    if (isListType(type2)) {
      return true;
    }
    if (isNonNullType(type1)) {
      return isNonNullType(type2) ? doTypesConflict(type1.ofType, type2.ofType) : true;
    }
    if (isNonNullType(type2)) {
      return true;
    }
    if (isLeafType(type1) || isLeafType(type2)) {
      return type1 !== type2;
    }
    return false;
  }
  function getFieldsAndFragmentNames(context, cachedFieldsAndFragmentNames, parentType, selectionSet) {
    const cached = cachedFieldsAndFragmentNames.get(selectionSet);
    if (cached) {
      return cached;
    }
    const nodeAndDefs = /* @__PURE__ */ Object.create(null);
    const fragmentNames = /* @__PURE__ */ Object.create(null);
    _collectFieldsAndFragmentNames(
      context,
      parentType,
      selectionSet,
      nodeAndDefs,
      fragmentNames
    );
    const result = [nodeAndDefs, Object.keys(fragmentNames)];
    cachedFieldsAndFragmentNames.set(selectionSet, result);
    return result;
  }
  function getReferencedFieldsAndFragmentNames(context, cachedFieldsAndFragmentNames, fragment) {
    const cached = cachedFieldsAndFragmentNames.get(fragment.selectionSet);
    if (cached) {
      return cached;
    }
    const fragmentType = typeFromAST(context.getSchema(), fragment.typeCondition);
    return getFieldsAndFragmentNames(
      context,
      cachedFieldsAndFragmentNames,
      fragmentType,
      fragment.selectionSet
    );
  }
  function _collectFieldsAndFragmentNames(context, parentType, selectionSet, nodeAndDefs, fragmentNames) {
    for (const selection of selectionSet.selections) {
      switch (selection.kind) {
        case Kind.FIELD: {
          const fieldName = selection.name.value;
          let fieldDef;
          if (isObjectType(parentType) || isInterfaceType(parentType)) {
            fieldDef = parentType.getFields()[fieldName];
          }
          const responseName = selection.alias ? selection.alias.value : fieldName;
          if (!nodeAndDefs[responseName]) {
            nodeAndDefs[responseName] = [];
          }
          nodeAndDefs[responseName].push([parentType, selection, fieldDef]);
          break;
        }
        case Kind.FRAGMENT_SPREAD:
          fragmentNames[selection.name.value] = true;
          break;
        case Kind.INLINE_FRAGMENT: {
          const typeCondition = selection.typeCondition;
          const inlineFragmentType = typeCondition ? typeFromAST(context.getSchema(), typeCondition) : parentType;
          _collectFieldsAndFragmentNames(
            context,
            inlineFragmentType,
            selection.selectionSet,
            nodeAndDefs,
            fragmentNames
          );
          break;
        }
      }
    }
  }
  function subfieldConflicts(conflicts, responseName, node1, node2) {
    if (conflicts.length > 0) {
      return [
        [responseName, conflicts.map(([reason]) => reason)],
        [node1, ...conflicts.map(([, fields1]) => fields1).flat()],
        [node2, ...conflicts.map(([, , fields2]) => fields2).flat()]
      ];
    }
  }
  var PairSet;
  var init_OverlappingFieldsCanBeMergedRule = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/validation/rules/OverlappingFieldsCanBeMergedRule.mjs"() {
      "use strict";
      init_inspect();
      init_GraphQLError();
      init_kinds();
      init_printer();
      init_definition();
      init_sortValueNode();
      init_typeFromAST();
      PairSet = class {
        constructor() {
          this._data = /* @__PURE__ */ new Map();
        }
        has(a, b, areMutuallyExclusive) {
          var _this$_data$get;
          const [key1, key2] = a < b ? [a, b] : [b, a];
          const result = (_this$_data$get = this._data.get(key1)) === null || _this$_data$get === void 0 ? void 0 : _this$_data$get.get(key2);
          if (result === void 0) {
            return false;
          }
          return areMutuallyExclusive ? true : areMutuallyExclusive === result;
        }
        add(a, b, areMutuallyExclusive) {
          const [key1, key2] = a < b ? [a, b] : [b, a];
          const map = this._data.get(key1);
          if (map === void 0) {
            this._data.set(key1, /* @__PURE__ */ new Map([[key2, areMutuallyExclusive]]));
          } else {
            map.set(key2, areMutuallyExclusive);
          }
        }
      };
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/validation/rules/PossibleFragmentSpreadsRule.mjs
  function PossibleFragmentSpreadsRule(context) {
    return {
      InlineFragment(node) {
        const fragType = context.getType();
        const parentType = context.getParentType();
        if (isCompositeType(fragType) && isCompositeType(parentType) && !doTypesOverlap(context.getSchema(), fragType, parentType)) {
          const parentTypeStr = inspect(parentType);
          const fragTypeStr = inspect(fragType);
          context.reportError(
            new GraphQLError(
              `Fragment cannot be spread here as objects of type "${parentTypeStr}" can never be of type "${fragTypeStr}".`,
              {
                nodes: node
              }
            )
          );
        }
      },
      FragmentSpread(node) {
        const fragName = node.name.value;
        const fragType = getFragmentType(context, fragName);
        const parentType = context.getParentType();
        if (fragType && parentType && !doTypesOverlap(context.getSchema(), fragType, parentType)) {
          const parentTypeStr = inspect(parentType);
          const fragTypeStr = inspect(fragType);
          context.reportError(
            new GraphQLError(
              `Fragment "${fragName}" cannot be spread here as objects of type "${parentTypeStr}" can never be of type "${fragTypeStr}".`,
              {
                nodes: node
              }
            )
          );
        }
      }
    };
  }
  function getFragmentType(context, name) {
    const frag = context.getFragment(name);
    if (frag) {
      const type = typeFromAST(context.getSchema(), frag.typeCondition);
      if (isCompositeType(type)) {
        return type;
      }
    }
  }
  var init_PossibleFragmentSpreadsRule = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/validation/rules/PossibleFragmentSpreadsRule.mjs"() {
      "use strict";
      init_inspect();
      init_GraphQLError();
      init_definition();
      init_typeComparators();
      init_typeFromAST();
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/validation/rules/PossibleTypeExtensionsRule.mjs
  function PossibleTypeExtensionsRule(context) {
    const schema = context.getSchema();
    const definedTypes = /* @__PURE__ */ Object.create(null);
    for (const def of context.getDocument().definitions) {
      if (isTypeDefinitionNode(def)) {
        definedTypes[def.name.value] = def;
      }
    }
    return {
      ScalarTypeExtension: checkExtension,
      ObjectTypeExtension: checkExtension,
      InterfaceTypeExtension: checkExtension,
      UnionTypeExtension: checkExtension,
      EnumTypeExtension: checkExtension,
      InputObjectTypeExtension: checkExtension
    };
    function checkExtension(node) {
      const typeName = node.name.value;
      const defNode = definedTypes[typeName];
      const existingType = schema === null || schema === void 0 ? void 0 : schema.getType(typeName);
      let expectedKind;
      if (defNode) {
        expectedKind = defKindToExtKind[defNode.kind];
      } else if (existingType) {
        expectedKind = typeToExtKind(existingType);
      }
      if (expectedKind) {
        if (expectedKind !== node.kind) {
          const kindStr = extensionKindToTypeName(node.kind);
          context.reportError(
            new GraphQLError(`Cannot extend non-${kindStr} type "${typeName}".`, {
              nodes: defNode ? [defNode, node] : node
            })
          );
        }
      } else {
        const allTypeNames = Object.keys({
          ...definedTypes,
          ...schema === null || schema === void 0 ? void 0 : schema.getTypeMap()
        });
        const suggestedTypes = suggestionList(typeName, allTypeNames);
        context.reportError(
          new GraphQLError(
            `Cannot extend type "${typeName}" because it is not defined.` + didYouMean(suggestedTypes),
            {
              nodes: node.name
            }
          )
        );
      }
    }
  }
  function typeToExtKind(type) {
    if (isScalarType(type)) {
      return Kind.SCALAR_TYPE_EXTENSION;
    }
    if (isObjectType(type)) {
      return Kind.OBJECT_TYPE_EXTENSION;
    }
    if (isInterfaceType(type)) {
      return Kind.INTERFACE_TYPE_EXTENSION;
    }
    if (isUnionType(type)) {
      return Kind.UNION_TYPE_EXTENSION;
    }
    if (isEnumType(type)) {
      return Kind.ENUM_TYPE_EXTENSION;
    }
    if (isInputObjectType(type)) {
      return Kind.INPUT_OBJECT_TYPE_EXTENSION;
    }
    invariant2(false, "Unexpected type: " + inspect(type));
  }
  function extensionKindToTypeName(kind) {
    switch (kind) {
      case Kind.SCALAR_TYPE_EXTENSION:
        return "scalar";
      case Kind.OBJECT_TYPE_EXTENSION:
        return "object";
      case Kind.INTERFACE_TYPE_EXTENSION:
        return "interface";
      case Kind.UNION_TYPE_EXTENSION:
        return "union";
      case Kind.ENUM_TYPE_EXTENSION:
        return "enum";
      case Kind.INPUT_OBJECT_TYPE_EXTENSION:
        return "input object";
      // Not reachable. All possible types have been considered
      /* c8 ignore next */
      default:
        invariant2(false, "Unexpected kind: " + inspect(kind));
    }
  }
  var defKindToExtKind;
  var init_PossibleTypeExtensionsRule = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/validation/rules/PossibleTypeExtensionsRule.mjs"() {
      "use strict";
      init_didYouMean();
      init_inspect();
      init_invariant();
      init_suggestionList();
      init_GraphQLError();
      init_kinds();
      init_predicates();
      init_definition();
      defKindToExtKind = {
        [Kind.SCALAR_TYPE_DEFINITION]: Kind.SCALAR_TYPE_EXTENSION,
        [Kind.OBJECT_TYPE_DEFINITION]: Kind.OBJECT_TYPE_EXTENSION,
        [Kind.INTERFACE_TYPE_DEFINITION]: Kind.INTERFACE_TYPE_EXTENSION,
        [Kind.UNION_TYPE_DEFINITION]: Kind.UNION_TYPE_EXTENSION,
        [Kind.ENUM_TYPE_DEFINITION]: Kind.ENUM_TYPE_EXTENSION,
        [Kind.INPUT_OBJECT_TYPE_DEFINITION]: Kind.INPUT_OBJECT_TYPE_EXTENSION
      };
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/validation/rules/ProvidedRequiredArgumentsRule.mjs
  function ProvidedRequiredArgumentsRule(context) {
    return {
      // eslint-disable-next-line new-cap
      ...ProvidedRequiredArgumentsOnDirectivesRule(context),
      Field: {
        // Validate on leave to allow for deeper errors to appear first.
        leave(fieldNode) {
          var _fieldNode$arguments;
          const fieldDef = context.getFieldDef();
          if (!fieldDef) {
            return false;
          }
          const providedArgs = new Set(
            // FIXME: https://github.com/graphql/graphql-js/issues/2203
            /* c8 ignore next */
            (_fieldNode$arguments = fieldNode.arguments) === null || _fieldNode$arguments === void 0 ? void 0 : _fieldNode$arguments.map((arg) => arg.name.value)
          );
          for (const argDef of fieldDef.args) {
            if (!providedArgs.has(argDef.name) && isRequiredArgument(argDef)) {
              const argTypeStr = inspect(argDef.type);
              context.reportError(
                new GraphQLError(
                  `Field "${fieldDef.name}" argument "${argDef.name}" of type "${argTypeStr}" is required, but it was not provided.`,
                  {
                    nodes: fieldNode
                  }
                )
              );
            }
          }
        }
      }
    };
  }
  function ProvidedRequiredArgumentsOnDirectivesRule(context) {
    var _schema$getDirectives;
    const requiredArgsMap = /* @__PURE__ */ Object.create(null);
    const schema = context.getSchema();
    const definedDirectives = (_schema$getDirectives = schema === null || schema === void 0 ? void 0 : schema.getDirectives()) !== null && _schema$getDirectives !== void 0 ? _schema$getDirectives : specifiedDirectives;
    for (const directive of definedDirectives) {
      requiredArgsMap[directive.name] = keyMap(
        directive.args.filter(isRequiredArgument),
        (arg) => arg.name
      );
    }
    const astDefinitions = context.getDocument().definitions;
    for (const def of astDefinitions) {
      if (def.kind === Kind.DIRECTIVE_DEFINITION) {
        var _def$arguments;
        const argNodes = (_def$arguments = def.arguments) !== null && _def$arguments !== void 0 ? _def$arguments : [];
        requiredArgsMap[def.name.value] = keyMap(
          argNodes.filter(isRequiredArgumentNode),
          (arg) => arg.name.value
        );
      }
    }
    return {
      Directive: {
        // Validate on leave to allow for deeper errors to appear first.
        leave(directiveNode) {
          const directiveName = directiveNode.name.value;
          const requiredArgs = requiredArgsMap[directiveName];
          if (requiredArgs) {
            var _directiveNode$argume;
            const argNodes = (_directiveNode$argume = directiveNode.arguments) !== null && _directiveNode$argume !== void 0 ? _directiveNode$argume : [];
            const argNodeMap = new Set(argNodes.map((arg) => arg.name.value));
            for (const [argName, argDef] of Object.entries(requiredArgs)) {
              if (!argNodeMap.has(argName)) {
                const argType = isType(argDef.type) ? inspect(argDef.type) : print(argDef.type);
                context.reportError(
                  new GraphQLError(
                    `Directive "@${directiveName}" argument "${argName}" of type "${argType}" is required, but it was not provided.`,
                    {
                      nodes: directiveNode
                    }
                  )
                );
              }
            }
          }
        }
      }
    };
  }
  function isRequiredArgumentNode(arg) {
    return arg.type.kind === Kind.NON_NULL_TYPE && arg.defaultValue == null;
  }
  var init_ProvidedRequiredArgumentsRule = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/validation/rules/ProvidedRequiredArgumentsRule.mjs"() {
      "use strict";
      init_inspect();
      init_keyMap();
      init_GraphQLError();
      init_kinds();
      init_printer();
      init_definition();
      init_directives();
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/validation/rules/ScalarLeafsRule.mjs
  function ScalarLeafsRule(context) {
    return {
      Field(node) {
        const type = context.getType();
        const selectionSet = node.selectionSet;
        if (type) {
          if (isLeafType(getNamedType(type))) {
            if (selectionSet) {
              const fieldName = node.name.value;
              const typeStr = inspect(type);
              context.reportError(
                new GraphQLError(
                  `Field "${fieldName}" must not have a selection since type "${typeStr}" has no subfields.`,
                  {
                    nodes: selectionSet
                  }
                )
              );
            }
          } else if (!selectionSet) {
            const fieldName = node.name.value;
            const typeStr = inspect(type);
            context.reportError(
              new GraphQLError(
                `Field "${fieldName}" of type "${typeStr}" must have a selection of subfields. Did you mean "${fieldName} { ... }"?`,
                {
                  nodes: node
                }
              )
            );
          }
        }
      }
    };
  }
  var init_ScalarLeafsRule = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/validation/rules/ScalarLeafsRule.mjs"() {
      "use strict";
      init_inspect();
      init_GraphQLError();
      init_definition();
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/jsutils/printPathArray.mjs
  function printPathArray(path) {
    return path.map(
      (key) => typeof key === "number" ? "[" + key.toString() + "]" : "." + key
    ).join("");
  }
  var init_printPathArray = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/jsutils/printPathArray.mjs"() {
      "use strict";
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/jsutils/Path.mjs
  function addPath(prev, key, typename) {
    return {
      prev,
      key,
      typename
    };
  }
  function pathToArray(path) {
    const flattened = [];
    let curr = path;
    while (curr) {
      flattened.push(curr.key);
      curr = curr.prev;
    }
    return flattened.reverse();
  }
  var init_Path = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/jsutils/Path.mjs"() {
      "use strict";
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/utilities/coerceInputValue.mjs
  function coerceInputValue(inputValue, type, onError = defaultOnError) {
    return coerceInputValueImpl(inputValue, type, onError, void 0);
  }
  function defaultOnError(path, invalidValue, error3) {
    let errorPrefix = "Invalid value " + inspect(invalidValue);
    if (path.length > 0) {
      errorPrefix += ` at "value${printPathArray(path)}"`;
    }
    error3.message = errorPrefix + ": " + error3.message;
    throw error3;
  }
  function coerceInputValueImpl(inputValue, type, onError, path) {
    if (isNonNullType(type)) {
      if (inputValue != null) {
        return coerceInputValueImpl(inputValue, type.ofType, onError, path);
      }
      onError(
        pathToArray(path),
        inputValue,
        new GraphQLError(
          `Expected non-nullable type "${inspect(type)}" not to be null.`
        )
      );
      return;
    }
    if (inputValue == null) {
      return null;
    }
    if (isListType(type)) {
      const itemType = type.ofType;
      if (isIterableObject(inputValue)) {
        return Array.from(inputValue, (itemValue, index) => {
          const itemPath = addPath(path, index, void 0);
          return coerceInputValueImpl(itemValue, itemType, onError, itemPath);
        });
      }
      return [coerceInputValueImpl(inputValue, itemType, onError, path)];
    }
    if (isInputObjectType(type)) {
      if (!isObjectLike(inputValue)) {
        onError(
          pathToArray(path),
          inputValue,
          new GraphQLError(`Expected type "${type.name}" to be an object.`)
        );
        return;
      }
      const coercedValue = {};
      const fieldDefs = type.getFields();
      for (const field of Object.values(fieldDefs)) {
        const fieldValue = inputValue[field.name];
        if (fieldValue === void 0) {
          if (field.defaultValue !== void 0) {
            coercedValue[field.name] = field.defaultValue;
          } else if (isNonNullType(field.type)) {
            const typeStr = inspect(field.type);
            onError(
              pathToArray(path),
              inputValue,
              new GraphQLError(
                `Field "${field.name}" of required type "${typeStr}" was not provided.`
              )
            );
          }
          continue;
        }
        coercedValue[field.name] = coerceInputValueImpl(
          fieldValue,
          field.type,
          onError,
          addPath(path, field.name, type.name)
        );
      }
      for (const fieldName of Object.keys(inputValue)) {
        if (!fieldDefs[fieldName]) {
          const suggestions = suggestionList(
            fieldName,
            Object.keys(type.getFields())
          );
          onError(
            pathToArray(path),
            inputValue,
            new GraphQLError(
              `Field "${fieldName}" is not defined by type "${type.name}".` + didYouMean(suggestions)
            )
          );
        }
      }
      return coercedValue;
    }
    if (isLeafType(type)) {
      let parseResult;
      try {
        parseResult = type.parseValue(inputValue);
      } catch (error3) {
        if (error3 instanceof GraphQLError) {
          onError(pathToArray(path), inputValue, error3);
        } else {
          onError(
            pathToArray(path),
            inputValue,
            new GraphQLError(`Expected type "${type.name}". ` + error3.message, {
              originalError: error3
            })
          );
        }
        return;
      }
      if (parseResult === void 0) {
        onError(
          pathToArray(path),
          inputValue,
          new GraphQLError(`Expected type "${type.name}".`)
        );
      }
      return parseResult;
    }
    invariant2(false, "Unexpected input type: " + inspect(type));
  }
  var init_coerceInputValue = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/utilities/coerceInputValue.mjs"() {
      "use strict";
      init_didYouMean();
      init_inspect();
      init_invariant();
      init_isIterableObject();
      init_isObjectLike();
      init_Path();
      init_printPathArray();
      init_suggestionList();
      init_GraphQLError();
      init_definition();
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/utilities/valueFromAST.mjs
  function valueFromAST(valueNode, type, variables) {
    if (!valueNode) {
      return;
    }
    if (valueNode.kind === Kind.VARIABLE) {
      const variableName = valueNode.name.value;
      if (variables == null || variables[variableName] === void 0) {
        return;
      }
      const variableValue = variables[variableName];
      if (variableValue === null && isNonNullType(type)) {
        return;
      }
      return variableValue;
    }
    if (isNonNullType(type)) {
      if (valueNode.kind === Kind.NULL) {
        return;
      }
      return valueFromAST(valueNode, type.ofType, variables);
    }
    if (valueNode.kind === Kind.NULL) {
      return null;
    }
    if (isListType(type)) {
      const itemType = type.ofType;
      if (valueNode.kind === Kind.LIST) {
        const coercedValues = [];
        for (const itemNode of valueNode.values) {
          if (isMissingVariable(itemNode, variables)) {
            if (isNonNullType(itemType)) {
              return;
            }
            coercedValues.push(null);
          } else {
            const itemValue = valueFromAST(itemNode, itemType, variables);
            if (itemValue === void 0) {
              return;
            }
            coercedValues.push(itemValue);
          }
        }
        return coercedValues;
      }
      const coercedValue = valueFromAST(valueNode, itemType, variables);
      if (coercedValue === void 0) {
        return;
      }
      return [coercedValue];
    }
    if (isInputObjectType(type)) {
      if (valueNode.kind !== Kind.OBJECT) {
        return;
      }
      const coercedObj = /* @__PURE__ */ Object.create(null);
      const fieldNodes = keyMap(valueNode.fields, (field) => field.name.value);
      for (const field of Object.values(type.getFields())) {
        const fieldNode = fieldNodes[field.name];
        if (!fieldNode || isMissingVariable(fieldNode.value, variables)) {
          if (field.defaultValue !== void 0) {
            coercedObj[field.name] = field.defaultValue;
          } else if (isNonNullType(field.type)) {
            return;
          }
          continue;
        }
        const fieldValue = valueFromAST(fieldNode.value, field.type, variables);
        if (fieldValue === void 0) {
          return;
        }
        coercedObj[field.name] = fieldValue;
      }
      return coercedObj;
    }
    if (isLeafType(type)) {
      let result;
      try {
        result = type.parseLiteral(valueNode, variables);
      } catch (_error) {
        return;
      }
      if (result === void 0) {
        return;
      }
      return result;
    }
    invariant2(false, "Unexpected input type: " + inspect(type));
  }
  function isMissingVariable(valueNode, variables) {
    return valueNode.kind === Kind.VARIABLE && (variables == null || variables[valueNode.name.value] === void 0);
  }
  var init_valueFromAST = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/utilities/valueFromAST.mjs"() {
      "use strict";
      init_inspect();
      init_invariant();
      init_keyMap();
      init_kinds();
      init_definition();
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/execution/values.mjs
  function getVariableValues(schema, varDefNodes, inputs, options) {
    const errors = [];
    const maxErrors = options === null || options === void 0 ? void 0 : options.maxErrors;
    try {
      const coerced = coerceVariableValues(
        schema,
        varDefNodes,
        inputs,
        (error3) => {
          if (maxErrors != null && errors.length >= maxErrors) {
            throw new GraphQLError(
              "Too many errors processing variables, error limit reached. Execution aborted."
            );
          }
          errors.push(error3);
        }
      );
      if (errors.length === 0) {
        return {
          coerced
        };
      }
    } catch (error3) {
      errors.push(error3);
    }
    return {
      errors
    };
  }
  function coerceVariableValues(schema, varDefNodes, inputs, onError) {
    const coercedValues = {};
    for (const varDefNode of varDefNodes) {
      const varName = varDefNode.variable.name.value;
      const varType = typeFromAST(schema, varDefNode.type);
      if (!isInputType(varType)) {
        const varTypeStr = print(varDefNode.type);
        onError(
          new GraphQLError(
            `Variable "$${varName}" expected value of type "${varTypeStr}" which cannot be used as an input type.`,
            {
              nodes: varDefNode.type
            }
          )
        );
        continue;
      }
      if (!hasOwnProperty(inputs, varName)) {
        if (varDefNode.defaultValue) {
          coercedValues[varName] = valueFromAST(varDefNode.defaultValue, varType);
        } else if (isNonNullType(varType)) {
          const varTypeStr = inspect(varType);
          onError(
            new GraphQLError(
              `Variable "$${varName}" of required type "${varTypeStr}" was not provided.`,
              {
                nodes: varDefNode
              }
            )
          );
        }
        continue;
      }
      const value = inputs[varName];
      if (value === null && isNonNullType(varType)) {
        const varTypeStr = inspect(varType);
        onError(
          new GraphQLError(
            `Variable "$${varName}" of non-null type "${varTypeStr}" must not be null.`,
            {
              nodes: varDefNode
            }
          )
        );
        continue;
      }
      coercedValues[varName] = coerceInputValue(
        value,
        varType,
        (path, invalidValue, error3) => {
          let prefix = `Variable "$${varName}" got invalid value ` + inspect(invalidValue);
          if (path.length > 0) {
            prefix += ` at "${varName}${printPathArray(path)}"`;
          }
          onError(
            new GraphQLError(prefix + "; " + error3.message, {
              nodes: varDefNode,
              originalError: error3
            })
          );
        }
      );
    }
    return coercedValues;
  }
  function getArgumentValues(def, node, variableValues) {
    var _node$arguments;
    const coercedValues = {};
    const argumentNodes = (_node$arguments = node.arguments) !== null && _node$arguments !== void 0 ? _node$arguments : [];
    const argNodeMap = keyMap(argumentNodes, (arg) => arg.name.value);
    for (const argDef of def.args) {
      const name = argDef.name;
      const argType = argDef.type;
      const argumentNode = argNodeMap[name];
      if (!argumentNode) {
        if (argDef.defaultValue !== void 0) {
          coercedValues[name] = argDef.defaultValue;
        } else if (isNonNullType(argType)) {
          throw new GraphQLError(
            `Argument "${name}" of required type "${inspect(argType)}" was not provided.`,
            {
              nodes: node
            }
          );
        }
        continue;
      }
      const valueNode = argumentNode.value;
      let isNull = valueNode.kind === Kind.NULL;
      if (valueNode.kind === Kind.VARIABLE) {
        const variableName = valueNode.name.value;
        if (variableValues == null || !hasOwnProperty(variableValues, variableName)) {
          if (argDef.defaultValue !== void 0) {
            coercedValues[name] = argDef.defaultValue;
          } else if (isNonNullType(argType)) {
            throw new GraphQLError(
              `Argument "${name}" of required type "${inspect(argType)}" was provided the variable "$${variableName}" which was not provided a runtime value.`,
              {
                nodes: valueNode
              }
            );
          }
          continue;
        }
        isNull = variableValues[variableName] == null;
      }
      if (isNull && isNonNullType(argType)) {
        throw new GraphQLError(
          `Argument "${name}" of non-null type "${inspect(argType)}" must not be null.`,
          {
            nodes: valueNode
          }
        );
      }
      const coercedValue = valueFromAST(valueNode, argType, variableValues);
      if (coercedValue === void 0) {
        throw new GraphQLError(
          `Argument "${name}" has invalid value ${print(valueNode)}.`,
          {
            nodes: valueNode
          }
        );
      }
      coercedValues[name] = coercedValue;
    }
    return coercedValues;
  }
  function getDirectiveValues(directiveDef, node, variableValues) {
    var _node$directives;
    const directiveNode = (_node$directives = node.directives) === null || _node$directives === void 0 ? void 0 : _node$directives.find(
      (directive) => directive.name.value === directiveDef.name
    );
    if (directiveNode) {
      return getArgumentValues(directiveDef, directiveNode, variableValues);
    }
  }
  function hasOwnProperty(obj, prop) {
    return Object.prototype.hasOwnProperty.call(obj, prop);
  }
  var init_values = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/execution/values.mjs"() {
      "use strict";
      init_inspect();
      init_keyMap();
      init_printPathArray();
      init_GraphQLError();
      init_kinds();
      init_printer();
      init_definition();
      init_coerceInputValue();
      init_typeFromAST();
      init_valueFromAST();
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/execution/collectFields.mjs
  function collectFields(schema, fragments, variableValues, runtimeType, selectionSet) {
    const fields = /* @__PURE__ */ new Map();
    collectFieldsImpl(
      schema,
      fragments,
      variableValues,
      runtimeType,
      selectionSet,
      fields,
      /* @__PURE__ */ new Set()
    );
    return fields;
  }
  function collectSubfields(schema, fragments, variableValues, returnType, fieldNodes) {
    const subFieldNodes = /* @__PURE__ */ new Map();
    const visitedFragmentNames = /* @__PURE__ */ new Set();
    for (const node of fieldNodes) {
      if (node.selectionSet) {
        collectFieldsImpl(
          schema,
          fragments,
          variableValues,
          returnType,
          node.selectionSet,
          subFieldNodes,
          visitedFragmentNames
        );
      }
    }
    return subFieldNodes;
  }
  function collectFieldsImpl(schema, fragments, variableValues, runtimeType, selectionSet, fields, visitedFragmentNames) {
    for (const selection of selectionSet.selections) {
      switch (selection.kind) {
        case Kind.FIELD: {
          if (!shouldIncludeNode(variableValues, selection)) {
            continue;
          }
          const name = getFieldEntryKey(selection);
          const fieldList = fields.get(name);
          if (fieldList !== void 0) {
            fieldList.push(selection);
          } else {
            fields.set(name, [selection]);
          }
          break;
        }
        case Kind.INLINE_FRAGMENT: {
          if (!shouldIncludeNode(variableValues, selection) || !doesFragmentConditionMatch(schema, selection, runtimeType)) {
            continue;
          }
          collectFieldsImpl(
            schema,
            fragments,
            variableValues,
            runtimeType,
            selection.selectionSet,
            fields,
            visitedFragmentNames
          );
          break;
        }
        case Kind.FRAGMENT_SPREAD: {
          const fragName = selection.name.value;
          if (visitedFragmentNames.has(fragName) || !shouldIncludeNode(variableValues, selection)) {
            continue;
          }
          visitedFragmentNames.add(fragName);
          const fragment = fragments[fragName];
          if (!fragment || !doesFragmentConditionMatch(schema, fragment, runtimeType)) {
            continue;
          }
          collectFieldsImpl(
            schema,
            fragments,
            variableValues,
            runtimeType,
            fragment.selectionSet,
            fields,
            visitedFragmentNames
          );
          break;
        }
      }
    }
  }
  function shouldIncludeNode(variableValues, node) {
    const skip = getDirectiveValues(GraphQLSkipDirective, node, variableValues);
    if ((skip === null || skip === void 0 ? void 0 : skip.if) === true) {
      return false;
    }
    const include = getDirectiveValues(
      GraphQLIncludeDirective,
      node,
      variableValues
    );
    if ((include === null || include === void 0 ? void 0 : include.if) === false) {
      return false;
    }
    return true;
  }
  function doesFragmentConditionMatch(schema, fragment, type) {
    const typeConditionNode = fragment.typeCondition;
    if (!typeConditionNode) {
      return true;
    }
    const conditionalType = typeFromAST(schema, typeConditionNode);
    if (conditionalType === type) {
      return true;
    }
    if (isAbstractType(conditionalType)) {
      return schema.isSubType(conditionalType, type);
    }
    return false;
  }
  function getFieldEntryKey(node) {
    return node.alias ? node.alias.value : node.name.value;
  }
  var init_collectFields = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/execution/collectFields.mjs"() {
      "use strict";
      init_kinds();
      init_definition();
      init_directives();
      init_typeFromAST();
      init_values();
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/validation/rules/SingleFieldSubscriptionsRule.mjs
  function SingleFieldSubscriptionsRule(context) {
    return {
      OperationDefinition(node) {
        if (node.operation === "subscription") {
          const schema = context.getSchema();
          const subscriptionType = schema.getSubscriptionType();
          if (subscriptionType) {
            const operationName = node.name ? node.name.value : null;
            const variableValues = /* @__PURE__ */ Object.create(null);
            const document2 = context.getDocument();
            const fragments = /* @__PURE__ */ Object.create(null);
            for (const definition of document2.definitions) {
              if (definition.kind === Kind.FRAGMENT_DEFINITION) {
                fragments[definition.name.value] = definition;
              }
            }
            const fields = collectFields(
              schema,
              fragments,
              variableValues,
              subscriptionType,
              node.selectionSet
            );
            if (fields.size > 1) {
              const fieldSelectionLists = [...fields.values()];
              const extraFieldSelectionLists = fieldSelectionLists.slice(1);
              const extraFieldSelections = extraFieldSelectionLists.flat();
              context.reportError(
                new GraphQLError(
                  operationName != null ? `Subscription "${operationName}" must select only one top level field.` : "Anonymous Subscription must select only one top level field.",
                  {
                    nodes: extraFieldSelections
                  }
                )
              );
            }
            for (const fieldNodes of fields.values()) {
              const field = fieldNodes[0];
              const fieldName = field.name.value;
              if (fieldName.startsWith("__")) {
                context.reportError(
                  new GraphQLError(
                    operationName != null ? `Subscription "${operationName}" must not select an introspection top level field.` : "Anonymous Subscription must not select an introspection top level field.",
                    {
                      nodes: fieldNodes
                    }
                  )
                );
              }
            }
          }
        }
      }
    };
  }
  var init_SingleFieldSubscriptionsRule = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/validation/rules/SingleFieldSubscriptionsRule.mjs"() {
      "use strict";
      init_GraphQLError();
      init_kinds();
      init_collectFields();
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/jsutils/groupBy.mjs
  function groupBy(list, keyFn) {
    const result = /* @__PURE__ */ new Map();
    for (const item of list) {
      const key = keyFn(item);
      const group = result.get(key);
      if (group === void 0) {
        result.set(key, [item]);
      } else {
        group.push(item);
      }
    }
    return result;
  }
  var init_groupBy = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/jsutils/groupBy.mjs"() {
      "use strict";
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/validation/rules/UniqueArgumentDefinitionNamesRule.mjs
  function UniqueArgumentDefinitionNamesRule(context) {
    return {
      DirectiveDefinition(directiveNode) {
        var _directiveNode$argume;
        const argumentNodes = (_directiveNode$argume = directiveNode.arguments) !== null && _directiveNode$argume !== void 0 ? _directiveNode$argume : [];
        return checkArgUniqueness(`@${directiveNode.name.value}`, argumentNodes);
      },
      InterfaceTypeDefinition: checkArgUniquenessPerField,
      InterfaceTypeExtension: checkArgUniquenessPerField,
      ObjectTypeDefinition: checkArgUniquenessPerField,
      ObjectTypeExtension: checkArgUniquenessPerField
    };
    function checkArgUniquenessPerField(typeNode) {
      var _typeNode$fields;
      const typeName = typeNode.name.value;
      const fieldNodes = (_typeNode$fields = typeNode.fields) !== null && _typeNode$fields !== void 0 ? _typeNode$fields : [];
      for (const fieldDef of fieldNodes) {
        var _fieldDef$arguments;
        const fieldName = fieldDef.name.value;
        const argumentNodes = (_fieldDef$arguments = fieldDef.arguments) !== null && _fieldDef$arguments !== void 0 ? _fieldDef$arguments : [];
        checkArgUniqueness(`${typeName}.${fieldName}`, argumentNodes);
      }
      return false;
    }
    function checkArgUniqueness(parentName, argumentNodes) {
      const seenArgs = groupBy(argumentNodes, (arg) => arg.name.value);
      for (const [argName, argNodes] of seenArgs) {
        if (argNodes.length > 1) {
          context.reportError(
            new GraphQLError(
              `Argument "${parentName}(${argName}:)" can only be defined once.`,
              {
                nodes: argNodes.map((node) => node.name)
              }
            )
          );
        }
      }
      return false;
    }
  }
  var init_UniqueArgumentDefinitionNamesRule = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/validation/rules/UniqueArgumentDefinitionNamesRule.mjs"() {
      "use strict";
      init_groupBy();
      init_GraphQLError();
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/validation/rules/UniqueArgumentNamesRule.mjs
  function UniqueArgumentNamesRule(context) {
    return {
      Field: checkArgUniqueness,
      Directive: checkArgUniqueness
    };
    function checkArgUniqueness(parentNode) {
      var _parentNode$arguments;
      const argumentNodes = (_parentNode$arguments = parentNode.arguments) !== null && _parentNode$arguments !== void 0 ? _parentNode$arguments : [];
      const seenArgs = groupBy(argumentNodes, (arg) => arg.name.value);
      for (const [argName, argNodes] of seenArgs) {
        if (argNodes.length > 1) {
          context.reportError(
            new GraphQLError(
              `There can be only one argument named "${argName}".`,
              {
                nodes: argNodes.map((node) => node.name)
              }
            )
          );
        }
      }
    }
  }
  var init_UniqueArgumentNamesRule = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/validation/rules/UniqueArgumentNamesRule.mjs"() {
      "use strict";
      init_groupBy();
      init_GraphQLError();
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/validation/rules/UniqueDirectiveNamesRule.mjs
  function UniqueDirectiveNamesRule(context) {
    const knownDirectiveNames = /* @__PURE__ */ Object.create(null);
    const schema = context.getSchema();
    return {
      DirectiveDefinition(node) {
        const directiveName = node.name.value;
        if (schema !== null && schema !== void 0 && schema.getDirective(directiveName)) {
          context.reportError(
            new GraphQLError(
              `Directive "@${directiveName}" already exists in the schema. It cannot be redefined.`,
              {
                nodes: node.name
              }
            )
          );
          return;
        }
        if (knownDirectiveNames[directiveName]) {
          context.reportError(
            new GraphQLError(
              `There can be only one directive named "@${directiveName}".`,
              {
                nodes: [knownDirectiveNames[directiveName], node.name]
              }
            )
          );
        } else {
          knownDirectiveNames[directiveName] = node.name;
        }
        return false;
      }
    };
  }
  var init_UniqueDirectiveNamesRule = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/validation/rules/UniqueDirectiveNamesRule.mjs"() {
      "use strict";
      init_GraphQLError();
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/validation/rules/UniqueDirectivesPerLocationRule.mjs
  function UniqueDirectivesPerLocationRule(context) {
    const uniqueDirectiveMap = /* @__PURE__ */ Object.create(null);
    const schema = context.getSchema();
    const definedDirectives = schema ? schema.getDirectives() : specifiedDirectives;
    for (const directive of definedDirectives) {
      uniqueDirectiveMap[directive.name] = !directive.isRepeatable;
    }
    const astDefinitions = context.getDocument().definitions;
    for (const def of astDefinitions) {
      if (def.kind === Kind.DIRECTIVE_DEFINITION) {
        uniqueDirectiveMap[def.name.value] = !def.repeatable;
      }
    }
    const schemaDirectives = /* @__PURE__ */ Object.create(null);
    const typeDirectivesMap = /* @__PURE__ */ Object.create(null);
    return {
      // Many different AST nodes may contain directives. Rather than listing
      // them all, just listen for entering any node, and check to see if it
      // defines any directives.
      enter(node) {
        if (!("directives" in node) || !node.directives) {
          return;
        }
        let seenDirectives;
        if (node.kind === Kind.SCHEMA_DEFINITION || node.kind === Kind.SCHEMA_EXTENSION) {
          seenDirectives = schemaDirectives;
        } else if (isTypeDefinitionNode(node) || isTypeExtensionNode(node)) {
          const typeName = node.name.value;
          seenDirectives = typeDirectivesMap[typeName];
          if (seenDirectives === void 0) {
            typeDirectivesMap[typeName] = seenDirectives = /* @__PURE__ */ Object.create(null);
          }
        } else {
          seenDirectives = /* @__PURE__ */ Object.create(null);
        }
        for (const directive of node.directives) {
          const directiveName = directive.name.value;
          if (uniqueDirectiveMap[directiveName]) {
            if (seenDirectives[directiveName]) {
              context.reportError(
                new GraphQLError(
                  `The directive "@${directiveName}" can only be used once at this location.`,
                  {
                    nodes: [seenDirectives[directiveName], directive]
                  }
                )
              );
            } else {
              seenDirectives[directiveName] = directive;
            }
          }
        }
      }
    };
  }
  var init_UniqueDirectivesPerLocationRule = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/validation/rules/UniqueDirectivesPerLocationRule.mjs"() {
      "use strict";
      init_GraphQLError();
      init_kinds();
      init_predicates();
      init_directives();
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/validation/rules/UniqueEnumValueNamesRule.mjs
  function UniqueEnumValueNamesRule(context) {
    const schema = context.getSchema();
    const existingTypeMap = schema ? schema.getTypeMap() : /* @__PURE__ */ Object.create(null);
    const knownValueNames = /* @__PURE__ */ Object.create(null);
    return {
      EnumTypeDefinition: checkValueUniqueness,
      EnumTypeExtension: checkValueUniqueness
    };
    function checkValueUniqueness(node) {
      var _node$values;
      const typeName = node.name.value;
      if (!knownValueNames[typeName]) {
        knownValueNames[typeName] = /* @__PURE__ */ Object.create(null);
      }
      const valueNodes = (_node$values = node.values) !== null && _node$values !== void 0 ? _node$values : [];
      const valueNames = knownValueNames[typeName];
      for (const valueDef of valueNodes) {
        const valueName = valueDef.name.value;
        const existingType = existingTypeMap[typeName];
        if (isEnumType(existingType) && existingType.getValue(valueName)) {
          context.reportError(
            new GraphQLError(
              `Enum value "${typeName}.${valueName}" already exists in the schema. It cannot also be defined in this type extension.`,
              {
                nodes: valueDef.name
              }
            )
          );
        } else if (valueNames[valueName]) {
          context.reportError(
            new GraphQLError(
              `Enum value "${typeName}.${valueName}" can only be defined once.`,
              {
                nodes: [valueNames[valueName], valueDef.name]
              }
            )
          );
        } else {
          valueNames[valueName] = valueDef.name;
        }
      }
      return false;
    }
  }
  var init_UniqueEnumValueNamesRule = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/validation/rules/UniqueEnumValueNamesRule.mjs"() {
      "use strict";
      init_GraphQLError();
      init_definition();
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/validation/rules/UniqueFieldDefinitionNamesRule.mjs
  function UniqueFieldDefinitionNamesRule(context) {
    const schema = context.getSchema();
    const existingTypeMap = schema ? schema.getTypeMap() : /* @__PURE__ */ Object.create(null);
    const knownFieldNames = /* @__PURE__ */ Object.create(null);
    return {
      InputObjectTypeDefinition: checkFieldUniqueness,
      InputObjectTypeExtension: checkFieldUniqueness,
      InterfaceTypeDefinition: checkFieldUniqueness,
      InterfaceTypeExtension: checkFieldUniqueness,
      ObjectTypeDefinition: checkFieldUniqueness,
      ObjectTypeExtension: checkFieldUniqueness
    };
    function checkFieldUniqueness(node) {
      var _node$fields;
      const typeName = node.name.value;
      if (!knownFieldNames[typeName]) {
        knownFieldNames[typeName] = /* @__PURE__ */ Object.create(null);
      }
      const fieldNodes = (_node$fields = node.fields) !== null && _node$fields !== void 0 ? _node$fields : [];
      const fieldNames = knownFieldNames[typeName];
      for (const fieldDef of fieldNodes) {
        const fieldName = fieldDef.name.value;
        if (hasField(existingTypeMap[typeName], fieldName)) {
          context.reportError(
            new GraphQLError(
              `Field "${typeName}.${fieldName}" already exists in the schema. It cannot also be defined in this type extension.`,
              {
                nodes: fieldDef.name
              }
            )
          );
        } else if (fieldNames[fieldName]) {
          context.reportError(
            new GraphQLError(
              `Field "${typeName}.${fieldName}" can only be defined once.`,
              {
                nodes: [fieldNames[fieldName], fieldDef.name]
              }
            )
          );
        } else {
          fieldNames[fieldName] = fieldDef.name;
        }
      }
      return false;
    }
  }
  function hasField(type, fieldName) {
    if (isObjectType(type) || isInterfaceType(type) || isInputObjectType(type)) {
      return type.getFields()[fieldName] != null;
    }
    return false;
  }
  var init_UniqueFieldDefinitionNamesRule = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/validation/rules/UniqueFieldDefinitionNamesRule.mjs"() {
      "use strict";
      init_GraphQLError();
      init_definition();
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/validation/rules/UniqueFragmentNamesRule.mjs
  function UniqueFragmentNamesRule(context) {
    const knownFragmentNames = /* @__PURE__ */ Object.create(null);
    return {
      OperationDefinition: () => false,
      FragmentDefinition(node) {
        const fragmentName = node.name.value;
        if (knownFragmentNames[fragmentName]) {
          context.reportError(
            new GraphQLError(
              `There can be only one fragment named "${fragmentName}".`,
              {
                nodes: [knownFragmentNames[fragmentName], node.name]
              }
            )
          );
        } else {
          knownFragmentNames[fragmentName] = node.name;
        }
        return false;
      }
    };
  }
  var init_UniqueFragmentNamesRule = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/validation/rules/UniqueFragmentNamesRule.mjs"() {
      "use strict";
      init_GraphQLError();
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/validation/rules/UniqueInputFieldNamesRule.mjs
  function UniqueInputFieldNamesRule(context) {
    const knownNameStack = [];
    let knownNames = /* @__PURE__ */ Object.create(null);
    return {
      ObjectValue: {
        enter() {
          knownNameStack.push(knownNames);
          knownNames = /* @__PURE__ */ Object.create(null);
        },
        leave() {
          const prevKnownNames = knownNameStack.pop();
          prevKnownNames || invariant2(false);
          knownNames = prevKnownNames;
        }
      },
      ObjectField(node) {
        const fieldName = node.name.value;
        if (knownNames[fieldName]) {
          context.reportError(
            new GraphQLError(
              `There can be only one input field named "${fieldName}".`,
              {
                nodes: [knownNames[fieldName], node.name]
              }
            )
          );
        } else {
          knownNames[fieldName] = node.name;
        }
      }
    };
  }
  var init_UniqueInputFieldNamesRule = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/validation/rules/UniqueInputFieldNamesRule.mjs"() {
      "use strict";
      init_invariant();
      init_GraphQLError();
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/validation/rules/UniqueOperationNamesRule.mjs
  function UniqueOperationNamesRule(context) {
    const knownOperationNames = /* @__PURE__ */ Object.create(null);
    return {
      OperationDefinition(node) {
        const operationName = node.name;
        if (operationName) {
          if (knownOperationNames[operationName.value]) {
            context.reportError(
              new GraphQLError(
                `There can be only one operation named "${operationName.value}".`,
                {
                  nodes: [
                    knownOperationNames[operationName.value],
                    operationName
                  ]
                }
              )
            );
          } else {
            knownOperationNames[operationName.value] = operationName;
          }
        }
        return false;
      },
      FragmentDefinition: () => false
    };
  }
  var init_UniqueOperationNamesRule = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/validation/rules/UniqueOperationNamesRule.mjs"() {
      "use strict";
      init_GraphQLError();
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/validation/rules/UniqueOperationTypesRule.mjs
  function UniqueOperationTypesRule(context) {
    const schema = context.getSchema();
    const definedOperationTypes = /* @__PURE__ */ Object.create(null);
    const existingOperationTypes = schema ? {
      query: schema.getQueryType(),
      mutation: schema.getMutationType(),
      subscription: schema.getSubscriptionType()
    } : {};
    return {
      SchemaDefinition: checkOperationTypes,
      SchemaExtension: checkOperationTypes
    };
    function checkOperationTypes(node) {
      var _node$operationTypes;
      const operationTypesNodes = (_node$operationTypes = node.operationTypes) !== null && _node$operationTypes !== void 0 ? _node$operationTypes : [];
      for (const operationType of operationTypesNodes) {
        const operation = operationType.operation;
        const alreadyDefinedOperationType = definedOperationTypes[operation];
        if (existingOperationTypes[operation]) {
          context.reportError(
            new GraphQLError(
              `Type for ${operation} already defined in the schema. It cannot be redefined.`,
              {
                nodes: operationType
              }
            )
          );
        } else if (alreadyDefinedOperationType) {
          context.reportError(
            new GraphQLError(
              `There can be only one ${operation} type in schema.`,
              {
                nodes: [alreadyDefinedOperationType, operationType]
              }
            )
          );
        } else {
          definedOperationTypes[operation] = operationType;
        }
      }
      return false;
    }
  }
  var init_UniqueOperationTypesRule = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/validation/rules/UniqueOperationTypesRule.mjs"() {
      "use strict";
      init_GraphQLError();
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/validation/rules/UniqueTypeNamesRule.mjs
  function UniqueTypeNamesRule(context) {
    const knownTypeNames = /* @__PURE__ */ Object.create(null);
    const schema = context.getSchema();
    return {
      ScalarTypeDefinition: checkTypeName,
      ObjectTypeDefinition: checkTypeName,
      InterfaceTypeDefinition: checkTypeName,
      UnionTypeDefinition: checkTypeName,
      EnumTypeDefinition: checkTypeName,
      InputObjectTypeDefinition: checkTypeName
    };
    function checkTypeName(node) {
      const typeName = node.name.value;
      if (schema !== null && schema !== void 0 && schema.getType(typeName)) {
        context.reportError(
          new GraphQLError(
            `Type "${typeName}" already exists in the schema. It cannot also be defined in this type definition.`,
            {
              nodes: node.name
            }
          )
        );
        return;
      }
      if (knownTypeNames[typeName]) {
        context.reportError(
          new GraphQLError(`There can be only one type named "${typeName}".`, {
            nodes: [knownTypeNames[typeName], node.name]
          })
        );
      } else {
        knownTypeNames[typeName] = node.name;
      }
      return false;
    }
  }
  var init_UniqueTypeNamesRule = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/validation/rules/UniqueTypeNamesRule.mjs"() {
      "use strict";
      init_GraphQLError();
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/validation/rules/UniqueVariableNamesRule.mjs
  function UniqueVariableNamesRule(context) {
    return {
      OperationDefinition(operationNode) {
        var _operationNode$variab;
        const variableDefinitions = (_operationNode$variab = operationNode.variableDefinitions) !== null && _operationNode$variab !== void 0 ? _operationNode$variab : [];
        const seenVariableDefinitions = groupBy(
          variableDefinitions,
          (node) => node.variable.name.value
        );
        for (const [variableName, variableNodes] of seenVariableDefinitions) {
          if (variableNodes.length > 1) {
            context.reportError(
              new GraphQLError(
                `There can be only one variable named "$${variableName}".`,
                {
                  nodes: variableNodes.map((node) => node.variable.name)
                }
              )
            );
          }
        }
      }
    };
  }
  var init_UniqueVariableNamesRule = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/validation/rules/UniqueVariableNamesRule.mjs"() {
      "use strict";
      init_groupBy();
      init_GraphQLError();
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/validation/rules/ValuesOfCorrectTypeRule.mjs
  function ValuesOfCorrectTypeRule(context) {
    return {
      ListValue(node) {
        const type = getNullableType(context.getParentInputType());
        if (!isListType(type)) {
          isValidValueNode(context, node);
          return false;
        }
      },
      ObjectValue(node) {
        const type = getNamedType(context.getInputType());
        if (!isInputObjectType(type)) {
          isValidValueNode(context, node);
          return false;
        }
        const fieldNodeMap = keyMap(node.fields, (field) => field.name.value);
        for (const fieldDef of Object.values(type.getFields())) {
          const fieldNode = fieldNodeMap[fieldDef.name];
          if (!fieldNode && isRequiredInputField(fieldDef)) {
            const typeStr = inspect(fieldDef.type);
            context.reportError(
              new GraphQLError(
                `Field "${type.name}.${fieldDef.name}" of required type "${typeStr}" was not provided.`,
                {
                  nodes: node
                }
              )
            );
          }
        }
      },
      ObjectField(node) {
        const parentType = getNamedType(context.getParentInputType());
        const fieldType = context.getInputType();
        if (!fieldType && isInputObjectType(parentType)) {
          const suggestions = suggestionList(
            node.name.value,
            Object.keys(parentType.getFields())
          );
          context.reportError(
            new GraphQLError(
              `Field "${node.name.value}" is not defined by type "${parentType.name}".` + didYouMean(suggestions),
              {
                nodes: node
              }
            )
          );
        }
      },
      NullValue(node) {
        const type = context.getInputType();
        if (isNonNullType(type)) {
          context.reportError(
            new GraphQLError(
              `Expected value of type "${inspect(type)}", found ${print(node)}.`,
              {
                nodes: node
              }
            )
          );
        }
      },
      EnumValue: (node) => isValidValueNode(context, node),
      IntValue: (node) => isValidValueNode(context, node),
      FloatValue: (node) => isValidValueNode(context, node),
      StringValue: (node) => isValidValueNode(context, node),
      BooleanValue: (node) => isValidValueNode(context, node)
    };
  }
  function isValidValueNode(context, node) {
    const locationType = context.getInputType();
    if (!locationType) {
      return;
    }
    const type = getNamedType(locationType);
    if (!isLeafType(type)) {
      const typeStr = inspect(locationType);
      context.reportError(
        new GraphQLError(
          `Expected value of type "${typeStr}", found ${print(node)}.`,
          {
            nodes: node
          }
        )
      );
      return;
    }
    try {
      const parseResult = type.parseLiteral(
        node,
        void 0
        /* variables */
      );
      if (parseResult === void 0) {
        const typeStr = inspect(locationType);
        context.reportError(
          new GraphQLError(
            `Expected value of type "${typeStr}", found ${print(node)}.`,
            {
              nodes: node
            }
          )
        );
      }
    } catch (error3) {
      const typeStr = inspect(locationType);
      if (error3 instanceof GraphQLError) {
        context.reportError(error3);
      } else {
        context.reportError(
          new GraphQLError(
            `Expected value of type "${typeStr}", found ${print(node)}; ` + error3.message,
            {
              nodes: node,
              originalError: error3
            }
          )
        );
      }
    }
  }
  var init_ValuesOfCorrectTypeRule = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/validation/rules/ValuesOfCorrectTypeRule.mjs"() {
      "use strict";
      init_didYouMean();
      init_inspect();
      init_keyMap();
      init_suggestionList();
      init_GraphQLError();
      init_printer();
      init_definition();
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/validation/rules/VariablesAreInputTypesRule.mjs
  function VariablesAreInputTypesRule(context) {
    return {
      VariableDefinition(node) {
        const type = typeFromAST(context.getSchema(), node.type);
        if (type !== void 0 && !isInputType(type)) {
          const variableName = node.variable.name.value;
          const typeName = print(node.type);
          context.reportError(
            new GraphQLError(
              `Variable "$${variableName}" cannot be non-input type "${typeName}".`,
              {
                nodes: node.type
              }
            )
          );
        }
      }
    };
  }
  var init_VariablesAreInputTypesRule = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/validation/rules/VariablesAreInputTypesRule.mjs"() {
      "use strict";
      init_GraphQLError();
      init_printer();
      init_definition();
      init_typeFromAST();
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/validation/rules/VariablesInAllowedPositionRule.mjs
  function VariablesInAllowedPositionRule(context) {
    let varDefMap = /* @__PURE__ */ Object.create(null);
    return {
      OperationDefinition: {
        enter() {
          varDefMap = /* @__PURE__ */ Object.create(null);
        },
        leave(operation) {
          const usages = context.getRecursiveVariableUsages(operation);
          for (const { node, type, defaultValue } of usages) {
            const varName = node.name.value;
            const varDef = varDefMap[varName];
            if (varDef && type) {
              const schema = context.getSchema();
              const varType = typeFromAST(schema, varDef.type);
              if (varType && !allowedVariableUsage(
                schema,
                varType,
                varDef.defaultValue,
                type,
                defaultValue
              )) {
                const varTypeStr = inspect(varType);
                const typeStr = inspect(type);
                context.reportError(
                  new GraphQLError(
                    `Variable "$${varName}" of type "${varTypeStr}" used in position expecting type "${typeStr}".`,
                    {
                      nodes: [varDef, node]
                    }
                  )
                );
              }
            }
          }
        }
      },
      VariableDefinition(node) {
        varDefMap[node.variable.name.value] = node;
      }
    };
  }
  function allowedVariableUsage(schema, varType, varDefaultValue, locationType, locationDefaultValue) {
    if (isNonNullType(locationType) && !isNonNullType(varType)) {
      const hasNonNullVariableDefaultValue = varDefaultValue != null && varDefaultValue.kind !== Kind.NULL;
      const hasLocationDefaultValue = locationDefaultValue !== void 0;
      if (!hasNonNullVariableDefaultValue && !hasLocationDefaultValue) {
        return false;
      }
      const nullableLocationType = locationType.ofType;
      return isTypeSubTypeOf(schema, varType, nullableLocationType);
    }
    return isTypeSubTypeOf(schema, varType, locationType);
  }
  var init_VariablesInAllowedPositionRule = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/validation/rules/VariablesInAllowedPositionRule.mjs"() {
      "use strict";
      init_inspect();
      init_GraphQLError();
      init_kinds();
      init_definition();
      init_typeComparators();
      init_typeFromAST();
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/validation/specifiedRules.mjs
  var specifiedRules, specifiedSDLRules;
  var init_specifiedRules = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/validation/specifiedRules.mjs"() {
      "use strict";
      init_ExecutableDefinitionsRule();
      init_FieldsOnCorrectTypeRule();
      init_FragmentsOnCompositeTypesRule();
      init_KnownArgumentNamesRule();
      init_KnownDirectivesRule();
      init_KnownFragmentNamesRule();
      init_KnownTypeNamesRule();
      init_LoneAnonymousOperationRule();
      init_LoneSchemaDefinitionRule();
      init_NoFragmentCyclesRule();
      init_NoUndefinedVariablesRule();
      init_NoUnusedFragmentsRule();
      init_NoUnusedVariablesRule();
      init_OverlappingFieldsCanBeMergedRule();
      init_PossibleFragmentSpreadsRule();
      init_PossibleTypeExtensionsRule();
      init_ProvidedRequiredArgumentsRule();
      init_ScalarLeafsRule();
      init_SingleFieldSubscriptionsRule();
      init_UniqueArgumentDefinitionNamesRule();
      init_UniqueArgumentNamesRule();
      init_UniqueDirectiveNamesRule();
      init_UniqueDirectivesPerLocationRule();
      init_UniqueEnumValueNamesRule();
      init_UniqueFieldDefinitionNamesRule();
      init_UniqueFragmentNamesRule();
      init_UniqueInputFieldNamesRule();
      init_UniqueOperationNamesRule();
      init_UniqueOperationTypesRule();
      init_UniqueTypeNamesRule();
      init_UniqueVariableNamesRule();
      init_ValuesOfCorrectTypeRule();
      init_VariablesAreInputTypesRule();
      init_VariablesInAllowedPositionRule();
      specifiedRules = Object.freeze([
        ExecutableDefinitionsRule,
        UniqueOperationNamesRule,
        LoneAnonymousOperationRule,
        SingleFieldSubscriptionsRule,
        KnownTypeNamesRule,
        FragmentsOnCompositeTypesRule,
        VariablesAreInputTypesRule,
        ScalarLeafsRule,
        FieldsOnCorrectTypeRule,
        UniqueFragmentNamesRule,
        KnownFragmentNamesRule,
        NoUnusedFragmentsRule,
        PossibleFragmentSpreadsRule,
        NoFragmentCyclesRule,
        UniqueVariableNamesRule,
        NoUndefinedVariablesRule,
        NoUnusedVariablesRule,
        KnownDirectivesRule,
        UniqueDirectivesPerLocationRule,
        KnownArgumentNamesRule,
        UniqueArgumentNamesRule,
        ValuesOfCorrectTypeRule,
        ProvidedRequiredArgumentsRule,
        VariablesInAllowedPositionRule,
        OverlappingFieldsCanBeMergedRule,
        UniqueInputFieldNamesRule
      ]);
      specifiedSDLRules = Object.freeze([
        LoneSchemaDefinitionRule,
        UniqueOperationTypesRule,
        UniqueTypeNamesRule,
        UniqueEnumValueNamesRule,
        UniqueFieldDefinitionNamesRule,
        UniqueArgumentDefinitionNamesRule,
        UniqueDirectiveNamesRule,
        KnownTypeNamesRule,
        KnownDirectivesRule,
        UniqueDirectivesPerLocationRule,
        PossibleTypeExtensionsRule,
        KnownArgumentNamesOnDirectivesRule,
        UniqueArgumentNamesRule,
        UniqueInputFieldNamesRule,
        ProvidedRequiredArgumentsOnDirectivesRule
      ]);
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/validation/ValidationContext.mjs
  var ASTValidationContext, SDLValidationContext, ValidationContext;
  var init_ValidationContext = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/validation/ValidationContext.mjs"() {
      "use strict";
      init_kinds();
      init_visitor();
      init_TypeInfo();
      ASTValidationContext = class {
        constructor(ast, onError) {
          this._ast = ast;
          this._fragments = void 0;
          this._fragmentSpreads = /* @__PURE__ */ new Map();
          this._recursivelyReferencedFragments = /* @__PURE__ */ new Map();
          this._onError = onError;
        }
        get [Symbol.toStringTag]() {
          return "ASTValidationContext";
        }
        reportError(error3) {
          this._onError(error3);
        }
        getDocument() {
          return this._ast;
        }
        getFragment(name) {
          let fragments;
          if (this._fragments) {
            fragments = this._fragments;
          } else {
            fragments = /* @__PURE__ */ Object.create(null);
            for (const defNode of this.getDocument().definitions) {
              if (defNode.kind === Kind.FRAGMENT_DEFINITION) {
                fragments[defNode.name.value] = defNode;
              }
            }
            this._fragments = fragments;
          }
          return fragments[name];
        }
        getFragmentSpreads(node) {
          let spreads = this._fragmentSpreads.get(node);
          if (!spreads) {
            spreads = [];
            const setsToVisit = [node];
            let set;
            while (set = setsToVisit.pop()) {
              for (const selection of set.selections) {
                if (selection.kind === Kind.FRAGMENT_SPREAD) {
                  spreads.push(selection);
                } else if (selection.selectionSet) {
                  setsToVisit.push(selection.selectionSet);
                }
              }
            }
            this._fragmentSpreads.set(node, spreads);
          }
          return spreads;
        }
        getRecursivelyReferencedFragments(operation) {
          let fragments = this._recursivelyReferencedFragments.get(operation);
          if (!fragments) {
            fragments = [];
            const collectedNames = /* @__PURE__ */ Object.create(null);
            const nodesToVisit = [operation.selectionSet];
            let node;
            while (node = nodesToVisit.pop()) {
              for (const spread of this.getFragmentSpreads(node)) {
                const fragName = spread.name.value;
                if (collectedNames[fragName] !== true) {
                  collectedNames[fragName] = true;
                  const fragment = this.getFragment(fragName);
                  if (fragment) {
                    fragments.push(fragment);
                    nodesToVisit.push(fragment.selectionSet);
                  }
                }
              }
            }
            this._recursivelyReferencedFragments.set(operation, fragments);
          }
          return fragments;
        }
      };
      SDLValidationContext = class extends ASTValidationContext {
        constructor(ast, schema, onError) {
          super(ast, onError);
          this._schema = schema;
        }
        get [Symbol.toStringTag]() {
          return "SDLValidationContext";
        }
        getSchema() {
          return this._schema;
        }
      };
      ValidationContext = class extends ASTValidationContext {
        constructor(schema, ast, typeInfo, onError) {
          super(ast, onError);
          this._schema = schema;
          this._typeInfo = typeInfo;
          this._variableUsages = /* @__PURE__ */ new Map();
          this._recursiveVariableUsages = /* @__PURE__ */ new Map();
        }
        get [Symbol.toStringTag]() {
          return "ValidationContext";
        }
        getSchema() {
          return this._schema;
        }
        getVariableUsages(node) {
          let usages = this._variableUsages.get(node);
          if (!usages) {
            const newUsages = [];
            const typeInfo = new TypeInfo(this._schema);
            visit(
              node,
              visitWithTypeInfo(typeInfo, {
                VariableDefinition: () => false,
                Variable(variable) {
                  newUsages.push({
                    node: variable,
                    type: typeInfo.getInputType(),
                    defaultValue: typeInfo.getDefaultValue()
                  });
                }
              })
            );
            usages = newUsages;
            this._variableUsages.set(node, usages);
          }
          return usages;
        }
        getRecursiveVariableUsages(operation) {
          let usages = this._recursiveVariableUsages.get(operation);
          if (!usages) {
            usages = this.getVariableUsages(operation);
            for (const frag of this.getRecursivelyReferencedFragments(operation)) {
              usages = usages.concat(this.getVariableUsages(frag));
            }
            this._recursiveVariableUsages.set(operation, usages);
          }
          return usages;
        }
        getType() {
          return this._typeInfo.getType();
        }
        getParentType() {
          return this._typeInfo.getParentType();
        }
        getInputType() {
          return this._typeInfo.getInputType();
        }
        getParentInputType() {
          return this._typeInfo.getParentInputType();
        }
        getFieldDef() {
          return this._typeInfo.getFieldDef();
        }
        getDirective() {
          return this._typeInfo.getDirective();
        }
        getArgument() {
          return this._typeInfo.getArgument();
        }
        getEnumValue() {
          return this._typeInfo.getEnumValue();
        }
      };
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/validation/validate.mjs
  function validate(schema, documentAST, rules = specifiedRules, options, typeInfo = new TypeInfo(schema)) {
    var _options$maxErrors;
    const maxErrors = (_options$maxErrors = options === null || options === void 0 ? void 0 : options.maxErrors) !== null && _options$maxErrors !== void 0 ? _options$maxErrors : 100;
    documentAST || devAssert(false, "Must provide document.");
    assertValidSchema(schema);
    const abortObj = Object.freeze({});
    const errors = [];
    const context = new ValidationContext(
      schema,
      documentAST,
      typeInfo,
      (error3) => {
        if (errors.length >= maxErrors) {
          errors.push(
            new GraphQLError(
              "Too many validation errors, error limit reached. Validation aborted."
            )
          );
          throw abortObj;
        }
        errors.push(error3);
      }
    );
    const visitor = visitInParallel(rules.map((rule) => rule(context)));
    try {
      visit(documentAST, visitWithTypeInfo(typeInfo, visitor));
    } catch (e) {
      if (e !== abortObj) {
        throw e;
      }
    }
    return errors;
  }
  function validateSDL(documentAST, schemaToExtend, rules = specifiedSDLRules) {
    const errors = [];
    const context = new SDLValidationContext(
      documentAST,
      schemaToExtend,
      (error3) => {
        errors.push(error3);
      }
    );
    const visitors = rules.map((rule) => rule(context));
    visit(documentAST, visitInParallel(visitors));
    return errors;
  }
  function assertValidSDL(documentAST) {
    const errors = validateSDL(documentAST);
    if (errors.length !== 0) {
      throw new Error(errors.map((error3) => error3.message).join("\n\n"));
    }
  }
  function assertValidSDLExtension(documentAST, schema) {
    const errors = validateSDL(documentAST, schema);
    if (errors.length !== 0) {
      throw new Error(errors.map((error3) => error3.message).join("\n\n"));
    }
  }
  var init_validate2 = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/validation/validate.mjs"() {
      "use strict";
      init_devAssert();
      init_GraphQLError();
      init_visitor();
      init_validate();
      init_TypeInfo();
      init_specifiedRules();
      init_ValidationContext();
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/jsutils/memoize3.mjs
  function memoize3(fn) {
    let cache0;
    return function memoized(a1, a2, a3) {
      if (cache0 === void 0) {
        cache0 = /* @__PURE__ */ new WeakMap();
      }
      let cache1 = cache0.get(a1);
      if (cache1 === void 0) {
        cache1 = /* @__PURE__ */ new WeakMap();
        cache0.set(a1, cache1);
      }
      let cache2 = cache1.get(a2);
      if (cache2 === void 0) {
        cache2 = /* @__PURE__ */ new WeakMap();
        cache1.set(a2, cache2);
      }
      let fnResult = cache2.get(a3);
      if (fnResult === void 0) {
        fnResult = fn(a1, a2, a3);
        cache2.set(a3, fnResult);
      }
      return fnResult;
    };
  }
  var init_memoize3 = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/jsutils/memoize3.mjs"() {
      "use strict";
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/jsutils/promiseForObject.mjs
  function promiseForObject(object) {
    return Promise.all(Object.values(object)).then((resolvedValues) => {
      const resolvedObject = /* @__PURE__ */ Object.create(null);
      for (const [i, key] of Object.keys(object).entries()) {
        resolvedObject[key] = resolvedValues[i];
      }
      return resolvedObject;
    });
  }
  var init_promiseForObject = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/jsutils/promiseForObject.mjs"() {
      "use strict";
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/jsutils/promiseReduce.mjs
  function promiseReduce(values, callbackFn, initialValue) {
    let accumulator = initialValue;
    for (const value of values) {
      accumulator = isPromise(accumulator) ? accumulator.then((resolved) => callbackFn(resolved, value)) : callbackFn(accumulator, value);
    }
    return accumulator;
  }
  var init_promiseReduce = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/jsutils/promiseReduce.mjs"() {
      "use strict";
      init_isPromise();
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/jsutils/toError.mjs
  function toError(thrownValue) {
    return thrownValue instanceof Error ? thrownValue : new NonErrorThrown(thrownValue);
  }
  var NonErrorThrown;
  var init_toError = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/jsutils/toError.mjs"() {
      "use strict";
      init_inspect();
      NonErrorThrown = class extends Error {
        constructor(thrownValue) {
          super("Unexpected error value: " + inspect(thrownValue));
          this.name = "NonErrorThrown";
          this.thrownValue = thrownValue;
        }
      };
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/error/locatedError.mjs
  function locatedError(rawOriginalError, nodes, path) {
    var _nodes;
    const originalError = toError(rawOriginalError);
    if (isLocatedGraphQLError(originalError)) {
      return originalError;
    }
    return new GraphQLError(originalError.message, {
      nodes: (_nodes = originalError.nodes) !== null && _nodes !== void 0 ? _nodes : nodes,
      source: originalError.source,
      positions: originalError.positions,
      path,
      originalError
    });
  }
  function isLocatedGraphQLError(error3) {
    return Array.isArray(error3.path);
  }
  var init_locatedError = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/error/locatedError.mjs"() {
      "use strict";
      init_toError();
      init_GraphQLError();
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/execution/execute.mjs
  function execute(args) {
    arguments.length < 2 || devAssert(
      false,
      "graphql@16 dropped long-deprecated support for positional arguments, please pass an object instead."
    );
    const { schema, document: document2, variableValues, rootValue } = args;
    assertValidExecutionArguments(schema, document2, variableValues);
    const exeContext = buildExecutionContext(args);
    if (!("schema" in exeContext)) {
      return {
        errors: exeContext
      };
    }
    try {
      const { operation } = exeContext;
      const result = executeOperation(exeContext, operation, rootValue);
      if (isPromise(result)) {
        return result.then(
          (data) => buildResponse(data, exeContext.errors),
          (error3) => {
            exeContext.errors.push(error3);
            return buildResponse(null, exeContext.errors);
          }
        );
      }
      return buildResponse(result, exeContext.errors);
    } catch (error3) {
      exeContext.errors.push(error3);
      return buildResponse(null, exeContext.errors);
    }
  }
  function executeSync(args) {
    const result = execute(args);
    if (isPromise(result)) {
      throw new Error("GraphQL execution failed to complete synchronously.");
    }
    return result;
  }
  function buildResponse(data, errors) {
    return errors.length === 0 ? {
      data
    } : {
      errors,
      data
    };
  }
  function assertValidExecutionArguments(schema, document2, rawVariableValues) {
    document2 || devAssert(false, "Must provide document.");
    assertValidSchema(schema);
    rawVariableValues == null || isObjectLike(rawVariableValues) || devAssert(
      false,
      "Variables must be provided as an Object where each property is a variable value. Perhaps look to see if an unparsed JSON string was provided."
    );
  }
  function buildExecutionContext(args) {
    var _definition$name, _operation$variableDe;
    const {
      schema,
      document: document2,
      rootValue,
      contextValue,
      variableValues: rawVariableValues,
      operationName,
      fieldResolver,
      typeResolver,
      subscribeFieldResolver
    } = args;
    let operation;
    const fragments = /* @__PURE__ */ Object.create(null);
    for (const definition of document2.definitions) {
      switch (definition.kind) {
        case Kind.OPERATION_DEFINITION:
          if (operationName == null) {
            if (operation !== void 0) {
              return [
                new GraphQLError(
                  "Must provide operation name if query contains multiple operations."
                )
              ];
            }
            operation = definition;
          } else if (((_definition$name = definition.name) === null || _definition$name === void 0 ? void 0 : _definition$name.value) === operationName) {
            operation = definition;
          }
          break;
        case Kind.FRAGMENT_DEFINITION:
          fragments[definition.name.value] = definition;
          break;
        default:
      }
    }
    if (!operation) {
      if (operationName != null) {
        return [new GraphQLError(`Unknown operation named "${operationName}".`)];
      }
      return [new GraphQLError("Must provide an operation.")];
    }
    const variableDefinitions = (_operation$variableDe = operation.variableDefinitions) !== null && _operation$variableDe !== void 0 ? _operation$variableDe : [];
    const coercedVariableValues = getVariableValues(
      schema,
      variableDefinitions,
      rawVariableValues !== null && rawVariableValues !== void 0 ? rawVariableValues : {},
      {
        maxErrors: 50
      }
    );
    if (coercedVariableValues.errors) {
      return coercedVariableValues.errors;
    }
    return {
      schema,
      fragments,
      rootValue,
      contextValue,
      operation,
      variableValues: coercedVariableValues.coerced,
      fieldResolver: fieldResolver !== null && fieldResolver !== void 0 ? fieldResolver : defaultFieldResolver,
      typeResolver: typeResolver !== null && typeResolver !== void 0 ? typeResolver : defaultTypeResolver,
      subscribeFieldResolver: subscribeFieldResolver !== null && subscribeFieldResolver !== void 0 ? subscribeFieldResolver : defaultFieldResolver,
      errors: []
    };
  }
  function executeOperation(exeContext, operation, rootValue) {
    const rootType = exeContext.schema.getRootType(operation.operation);
    if (rootType == null) {
      throw new GraphQLError(
        `Schema is not configured to execute ${operation.operation} operation.`,
        {
          nodes: operation
        }
      );
    }
    const rootFields = collectFields(
      exeContext.schema,
      exeContext.fragments,
      exeContext.variableValues,
      rootType,
      operation.selectionSet
    );
    const path = void 0;
    switch (operation.operation) {
      case OperationTypeNode.QUERY:
        return executeFields(exeContext, rootType, rootValue, path, rootFields);
      case OperationTypeNode.MUTATION:
        return executeFieldsSerially(
          exeContext,
          rootType,
          rootValue,
          path,
          rootFields
        );
      case OperationTypeNode.SUBSCRIPTION:
        return executeFields(exeContext, rootType, rootValue, path, rootFields);
    }
  }
  function executeFieldsSerially(exeContext, parentType, sourceValue, path, fields) {
    return promiseReduce(
      fields.entries(),
      (results, [responseName, fieldNodes]) => {
        const fieldPath = addPath(path, responseName, parentType.name);
        const result = executeField(
          exeContext,
          parentType,
          sourceValue,
          fieldNodes,
          fieldPath
        );
        if (result === void 0) {
          return results;
        }
        if (isPromise(result)) {
          return result.then((resolvedResult) => {
            results[responseName] = resolvedResult;
            return results;
          });
        }
        results[responseName] = result;
        return results;
      },
      /* @__PURE__ */ Object.create(null)
    );
  }
  function executeFields(exeContext, parentType, sourceValue, path, fields) {
    const results = /* @__PURE__ */ Object.create(null);
    let containsPromise = false;
    try {
      for (const [responseName, fieldNodes] of fields.entries()) {
        const fieldPath = addPath(path, responseName, parentType.name);
        const result = executeField(
          exeContext,
          parentType,
          sourceValue,
          fieldNodes,
          fieldPath
        );
        if (result !== void 0) {
          results[responseName] = result;
          if (isPromise(result)) {
            containsPromise = true;
          }
        }
      }
    } catch (error3) {
      if (containsPromise) {
        return promiseForObject(results).finally(() => {
          throw error3;
        });
      }
      throw error3;
    }
    if (!containsPromise) {
      return results;
    }
    return promiseForObject(results);
  }
  function executeField(exeContext, parentType, source, fieldNodes, path) {
    var _fieldDef$resolve;
    const fieldDef = getFieldDef2(exeContext.schema, parentType, fieldNodes[0]);
    if (!fieldDef) {
      return;
    }
    const returnType = fieldDef.type;
    const resolveFn = (_fieldDef$resolve = fieldDef.resolve) !== null && _fieldDef$resolve !== void 0 ? _fieldDef$resolve : exeContext.fieldResolver;
    const info = buildResolveInfo(
      exeContext,
      fieldDef,
      fieldNodes,
      parentType,
      path
    );
    try {
      const args = getArgumentValues(
        fieldDef,
        fieldNodes[0],
        exeContext.variableValues
      );
      const contextValue = exeContext.contextValue;
      const result = resolveFn(source, args, contextValue, info);
      let completed;
      if (isPromise(result)) {
        completed = result.then(
          (resolved) => completeValue(exeContext, returnType, fieldNodes, info, path, resolved)
        );
      } else {
        completed = completeValue(
          exeContext,
          returnType,
          fieldNodes,
          info,
          path,
          result
        );
      }
      if (isPromise(completed)) {
        return completed.then(void 0, (rawError) => {
          const error3 = locatedError(rawError, fieldNodes, pathToArray(path));
          return handleFieldError(error3, returnType, exeContext);
        });
      }
      return completed;
    } catch (rawError) {
      const error3 = locatedError(rawError, fieldNodes, pathToArray(path));
      return handleFieldError(error3, returnType, exeContext);
    }
  }
  function buildResolveInfo(exeContext, fieldDef, fieldNodes, parentType, path) {
    return {
      fieldName: fieldDef.name,
      fieldNodes,
      returnType: fieldDef.type,
      parentType,
      path,
      schema: exeContext.schema,
      fragments: exeContext.fragments,
      rootValue: exeContext.rootValue,
      operation: exeContext.operation,
      variableValues: exeContext.variableValues
    };
  }
  function handleFieldError(error3, returnType, exeContext) {
    if (isNonNullType(returnType)) {
      throw error3;
    }
    exeContext.errors.push(error3);
    return null;
  }
  function completeValue(exeContext, returnType, fieldNodes, info, path, result) {
    if (result instanceof Error) {
      throw result;
    }
    if (isNonNullType(returnType)) {
      const completed = completeValue(
        exeContext,
        returnType.ofType,
        fieldNodes,
        info,
        path,
        result
      );
      if (completed === null) {
        throw new Error(
          `Cannot return null for non-nullable field ${info.parentType.name}.${info.fieldName}.`
        );
      }
      return completed;
    }
    if (result == null) {
      return null;
    }
    if (isListType(returnType)) {
      return completeListValue(
        exeContext,
        returnType,
        fieldNodes,
        info,
        path,
        result
      );
    }
    if (isLeafType(returnType)) {
      return completeLeafValue(returnType, result);
    }
    if (isAbstractType(returnType)) {
      return completeAbstractValue(
        exeContext,
        returnType,
        fieldNodes,
        info,
        path,
        result
      );
    }
    if (isObjectType(returnType)) {
      return completeObjectValue(
        exeContext,
        returnType,
        fieldNodes,
        info,
        path,
        result
      );
    }
    invariant2(
      false,
      "Cannot complete value of unexpected output type: " + inspect(returnType)
    );
  }
  function completeListValue(exeContext, returnType, fieldNodes, info, path, result) {
    if (!isIterableObject(result)) {
      throw new GraphQLError(
        `Expected Iterable, but did not find one for field "${info.parentType.name}.${info.fieldName}".`
      );
    }
    const itemType = returnType.ofType;
    let containsPromise = false;
    const completedResults = Array.from(result, (item, index) => {
      const itemPath = addPath(path, index, void 0);
      try {
        let completedItem;
        if (isPromise(item)) {
          completedItem = item.then(
            (resolved) => completeValue(
              exeContext,
              itemType,
              fieldNodes,
              info,
              itemPath,
              resolved
            )
          );
        } else {
          completedItem = completeValue(
            exeContext,
            itemType,
            fieldNodes,
            info,
            itemPath,
            item
          );
        }
        if (isPromise(completedItem)) {
          containsPromise = true;
          return completedItem.then(void 0, (rawError) => {
            const error3 = locatedError(
              rawError,
              fieldNodes,
              pathToArray(itemPath)
            );
            return handleFieldError(error3, itemType, exeContext);
          });
        }
        return completedItem;
      } catch (rawError) {
        const error3 = locatedError(rawError, fieldNodes, pathToArray(itemPath));
        return handleFieldError(error3, itemType, exeContext);
      }
    });
    return containsPromise ? Promise.all(completedResults) : completedResults;
  }
  function completeLeafValue(returnType, result) {
    const serializedResult = returnType.serialize(result);
    if (serializedResult == null) {
      throw new Error(
        `Expected \`${inspect(returnType)}.serialize(${inspect(result)})\` to return non-nullable value, returned: ${inspect(serializedResult)}`
      );
    }
    return serializedResult;
  }
  function completeAbstractValue(exeContext, returnType, fieldNodes, info, path, result) {
    var _returnType$resolveTy;
    const resolveTypeFn = (_returnType$resolveTy = returnType.resolveType) !== null && _returnType$resolveTy !== void 0 ? _returnType$resolveTy : exeContext.typeResolver;
    const contextValue = exeContext.contextValue;
    const runtimeType = resolveTypeFn(result, contextValue, info, returnType);
    if (isPromise(runtimeType)) {
      return runtimeType.then(
        (resolvedRuntimeType) => completeObjectValue(
          exeContext,
          ensureValidRuntimeType(
            resolvedRuntimeType,
            exeContext,
            returnType,
            fieldNodes,
            info,
            result
          ),
          fieldNodes,
          info,
          path,
          result
        )
      );
    }
    return completeObjectValue(
      exeContext,
      ensureValidRuntimeType(
        runtimeType,
        exeContext,
        returnType,
        fieldNodes,
        info,
        result
      ),
      fieldNodes,
      info,
      path,
      result
    );
  }
  function ensureValidRuntimeType(runtimeTypeName, exeContext, returnType, fieldNodes, info, result) {
    if (runtimeTypeName == null) {
      throw new GraphQLError(
        `Abstract type "${returnType.name}" must resolve to an Object type at runtime for field "${info.parentType.name}.${info.fieldName}". Either the "${returnType.name}" type should provide a "resolveType" function or each possible type should provide an "isTypeOf" function.`,
        fieldNodes
      );
    }
    if (isObjectType(runtimeTypeName)) {
      throw new GraphQLError(
        "Support for returning GraphQLObjectType from resolveType was removed in graphql-js@16.0.0 please return type name instead."
      );
    }
    if (typeof runtimeTypeName !== "string") {
      throw new GraphQLError(
        `Abstract type "${returnType.name}" must resolve to an Object type at runtime for field "${info.parentType.name}.${info.fieldName}" with value ${inspect(result)}, received "${inspect(runtimeTypeName)}".`
      );
    }
    const runtimeType = exeContext.schema.getType(runtimeTypeName);
    if (runtimeType == null) {
      throw new GraphQLError(
        `Abstract type "${returnType.name}" was resolved to a type "${runtimeTypeName}" that does not exist inside the schema.`,
        {
          nodes: fieldNodes
        }
      );
    }
    if (!isObjectType(runtimeType)) {
      throw new GraphQLError(
        `Abstract type "${returnType.name}" was resolved to a non-object type "${runtimeTypeName}".`,
        {
          nodes: fieldNodes
        }
      );
    }
    if (!exeContext.schema.isSubType(returnType, runtimeType)) {
      throw new GraphQLError(
        `Runtime Object type "${runtimeType.name}" is not a possible type for "${returnType.name}".`,
        {
          nodes: fieldNodes
        }
      );
    }
    return runtimeType;
  }
  function completeObjectValue(exeContext, returnType, fieldNodes, info, path, result) {
    const subFieldNodes = collectSubfields2(exeContext, returnType, fieldNodes);
    if (returnType.isTypeOf) {
      const isTypeOf = returnType.isTypeOf(result, exeContext.contextValue, info);
      if (isPromise(isTypeOf)) {
        return isTypeOf.then((resolvedIsTypeOf) => {
          if (!resolvedIsTypeOf) {
            throw invalidReturnTypeError(returnType, result, fieldNodes);
          }
          return executeFields(
            exeContext,
            returnType,
            result,
            path,
            subFieldNodes
          );
        });
      }
      if (!isTypeOf) {
        throw invalidReturnTypeError(returnType, result, fieldNodes);
      }
    }
    return executeFields(exeContext, returnType, result, path, subFieldNodes);
  }
  function invalidReturnTypeError(returnType, result, fieldNodes) {
    return new GraphQLError(
      `Expected value of type "${returnType.name}" but got: ${inspect(result)}.`,
      {
        nodes: fieldNodes
      }
    );
  }
  function getFieldDef2(schema, parentType, fieldNode) {
    const fieldName = fieldNode.name.value;
    if (fieldName === SchemaMetaFieldDef.name && schema.getQueryType() === parentType) {
      return SchemaMetaFieldDef;
    } else if (fieldName === TypeMetaFieldDef.name && schema.getQueryType() === parentType) {
      return TypeMetaFieldDef;
    } else if (fieldName === TypeNameMetaFieldDef.name) {
      return TypeNameMetaFieldDef;
    }
    return parentType.getFields()[fieldName];
  }
  var collectSubfields2, defaultTypeResolver, defaultFieldResolver;
  var init_execute = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/execution/execute.mjs"() {
      "use strict";
      init_devAssert();
      init_inspect();
      init_invariant();
      init_isIterableObject();
      init_isObjectLike();
      init_isPromise();
      init_memoize3();
      init_Path();
      init_promiseForObject();
      init_promiseReduce();
      init_GraphQLError();
      init_locatedError();
      init_ast();
      init_kinds();
      init_definition();
      init_introspection();
      init_validate();
      init_collectFields();
      init_values();
      collectSubfields2 = memoize3(
        (exeContext, returnType, fieldNodes) => collectSubfields(
          exeContext.schema,
          exeContext.fragments,
          exeContext.variableValues,
          returnType,
          fieldNodes
        )
      );
      defaultTypeResolver = function(value, contextValue, info, abstractType) {
        if (isObjectLike(value) && typeof value.__typename === "string") {
          return value.__typename;
        }
        const possibleTypes = info.schema.getPossibleTypes(abstractType);
        const promisedIsTypeOfResults = [];
        for (let i = 0; i < possibleTypes.length; i++) {
          const type = possibleTypes[i];
          if (type.isTypeOf) {
            const isTypeOfResult = type.isTypeOf(value, contextValue, info);
            if (isPromise(isTypeOfResult)) {
              promisedIsTypeOfResults[i] = isTypeOfResult;
            } else if (isTypeOfResult) {
              return type.name;
            }
          }
        }
        if (promisedIsTypeOfResults.length) {
          return Promise.all(promisedIsTypeOfResults).then((isTypeOfResults) => {
            for (let i = 0; i < isTypeOfResults.length; i++) {
              if (isTypeOfResults[i]) {
                return possibleTypes[i].name;
              }
            }
          });
        }
      };
      defaultFieldResolver = function(source, args, contextValue, info) {
        if (isObjectLike(source) || typeof source === "function") {
          const property = source[info.fieldName];
          if (typeof property === "function") {
            return source[info.fieldName](args, contextValue, info);
          }
          return property;
        }
      };
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/graphql.mjs
  function graphql(args) {
    return new Promise((resolve) => resolve(graphqlImpl(args)));
  }
  function graphqlSync(args) {
    const result = graphqlImpl(args);
    if (isPromise(result)) {
      throw new Error("GraphQL execution failed to complete synchronously.");
    }
    return result;
  }
  function graphqlImpl(args) {
    arguments.length < 2 || devAssert(
      false,
      "graphql@16 dropped long-deprecated support for positional arguments, please pass an object instead."
    );
    const {
      schema,
      source,
      rootValue,
      contextValue,
      variableValues,
      operationName,
      fieldResolver,
      typeResolver
    } = args;
    const schemaValidationErrors = validateSchema(schema);
    if (schemaValidationErrors.length > 0) {
      return {
        errors: schemaValidationErrors
      };
    }
    let document2;
    try {
      document2 = parse2(source);
    } catch (syntaxError2) {
      return {
        errors: [syntaxError2]
      };
    }
    const validationErrors = validate(schema, document2);
    if (validationErrors.length > 0) {
      return {
        errors: validationErrors
      };
    }
    return execute({
      schema,
      document: document2,
      rootValue,
      contextValue,
      variableValues,
      operationName,
      fieldResolver,
      typeResolver
    });
  }
  var init_graphql = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/graphql.mjs"() {
      "use strict";
      init_devAssert();
      init_isPromise();
      init_parser();
      init_validate();
      init_validate2();
      init_execute();
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/type/index.mjs
  var init_type = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/type/index.mjs"() {
      "use strict";
      init_schema();
      init_definition();
      init_directives();
      init_scalars();
      init_introspection();
      init_validate();
      init_assertName();
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/language/index.mjs
  var init_language = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/language/index.mjs"() {
      "use strict";
      init_source();
      init_location();
      init_printLocation();
      init_kinds();
      init_tokenKind();
      init_lexer();
      init_parser();
      init_printer();
      init_visitor();
      init_ast();
      init_predicates();
      init_directiveLocation();
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/jsutils/isAsyncIterable.mjs
  function isAsyncIterable(maybeAsyncIterable) {
    return typeof (maybeAsyncIterable === null || maybeAsyncIterable === void 0 ? void 0 : maybeAsyncIterable[Symbol.asyncIterator]) === "function";
  }
  var init_isAsyncIterable = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/jsutils/isAsyncIterable.mjs"() {
      "use strict";
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/execution/mapAsyncIterator.mjs
  function mapAsyncIterator(iterable, callback) {
    const iterator = iterable[Symbol.asyncIterator]();
    async function mapResult(result) {
      if (result.done) {
        return result;
      }
      try {
        return {
          value: await callback(result.value),
          done: false
        };
      } catch (error3) {
        if (typeof iterator.return === "function") {
          try {
            await iterator.return();
          } catch (_e) {
          }
        }
        throw error3;
      }
    }
    return {
      async next() {
        return mapResult(await iterator.next());
      },
      async return() {
        return typeof iterator.return === "function" ? mapResult(await iterator.return()) : {
          value: void 0,
          done: true
        };
      },
      async throw(error3) {
        if (typeof iterator.throw === "function") {
          return mapResult(await iterator.throw(error3));
        }
        throw error3;
      },
      [Symbol.asyncIterator]() {
        return this;
      }
    };
  }
  var init_mapAsyncIterator = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/execution/mapAsyncIterator.mjs"() {
      "use strict";
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/execution/subscribe.mjs
  async function subscribe(args) {
    arguments.length < 2 || devAssert(
      false,
      "graphql@16 dropped long-deprecated support for positional arguments, please pass an object instead."
    );
    const resultOrStream = await createSourceEventStream(args);
    if (!isAsyncIterable(resultOrStream)) {
      return resultOrStream;
    }
    const mapSourceToResponse = (payload) => execute({ ...args, rootValue: payload });
    return mapAsyncIterator(resultOrStream, mapSourceToResponse);
  }
  function toNormalizedArgs(args) {
    const firstArg = args[0];
    if (firstArg && "document" in firstArg) {
      return firstArg;
    }
    return {
      schema: firstArg,
      // FIXME: when underlying TS bug fixed, see https://github.com/microsoft/TypeScript/issues/31613
      document: args[1],
      rootValue: args[2],
      contextValue: args[3],
      variableValues: args[4],
      operationName: args[5],
      subscribeFieldResolver: args[6]
    };
  }
  async function createSourceEventStream(...rawArgs) {
    const args = toNormalizedArgs(rawArgs);
    const { schema, document: document2, variableValues } = args;
    assertValidExecutionArguments(schema, document2, variableValues);
    const exeContext = buildExecutionContext(args);
    if (!("schema" in exeContext)) {
      return {
        errors: exeContext
      };
    }
    try {
      const eventStream = await executeSubscription(exeContext);
      if (!isAsyncIterable(eventStream)) {
        throw new Error(
          `Subscription field must return Async Iterable. Received: ${inspect(eventStream)}.`
        );
      }
      return eventStream;
    } catch (error3) {
      if (error3 instanceof GraphQLError) {
        return {
          errors: [error3]
        };
      }
      throw error3;
    }
  }
  async function executeSubscription(exeContext) {
    const { schema, fragments, operation, variableValues, rootValue } = exeContext;
    const rootType = schema.getSubscriptionType();
    if (rootType == null) {
      throw new GraphQLError(
        "Schema is not configured to execute subscription operation.",
        {
          nodes: operation
        }
      );
    }
    const rootFields = collectFields(
      schema,
      fragments,
      variableValues,
      rootType,
      operation.selectionSet
    );
    const [responseName, fieldNodes] = [...rootFields.entries()][0];
    const fieldDef = getFieldDef2(schema, rootType, fieldNodes[0]);
    if (!fieldDef) {
      const fieldName = fieldNodes[0].name.value;
      throw new GraphQLError(
        `The subscription field "${fieldName}" is not defined.`,
        {
          nodes: fieldNodes
        }
      );
    }
    const path = addPath(void 0, responseName, rootType.name);
    const info = buildResolveInfo(
      exeContext,
      fieldDef,
      fieldNodes,
      rootType,
      path
    );
    try {
      var _fieldDef$subscribe;
      const args = getArgumentValues(fieldDef, fieldNodes[0], variableValues);
      const contextValue = exeContext.contextValue;
      const resolveFn = (_fieldDef$subscribe = fieldDef.subscribe) !== null && _fieldDef$subscribe !== void 0 ? _fieldDef$subscribe : exeContext.subscribeFieldResolver;
      const eventStream = await resolveFn(rootValue, args, contextValue, info);
      if (eventStream instanceof Error) {
        throw eventStream;
      }
      return eventStream;
    } catch (error3) {
      throw locatedError(error3, fieldNodes, pathToArray(path));
    }
  }
  var init_subscribe = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/execution/subscribe.mjs"() {
      "use strict";
      init_devAssert();
      init_inspect();
      init_isAsyncIterable();
      init_Path();
      init_GraphQLError();
      init_locatedError();
      init_collectFields();
      init_execute();
      init_mapAsyncIterator();
      init_values();
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/execution/index.mjs
  var init_execution = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/execution/index.mjs"() {
      "use strict";
      init_Path();
      init_execute();
      init_subscribe();
      init_values();
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/validation/rules/custom/NoDeprecatedCustomRule.mjs
  function NoDeprecatedCustomRule(context) {
    return {
      Field(node) {
        const fieldDef = context.getFieldDef();
        const deprecationReason = fieldDef === null || fieldDef === void 0 ? void 0 : fieldDef.deprecationReason;
        if (fieldDef && deprecationReason != null) {
          const parentType = context.getParentType();
          parentType != null || invariant2(false);
          context.reportError(
            new GraphQLError(
              `The field ${parentType.name}.${fieldDef.name} is deprecated. ${deprecationReason}`,
              {
                nodes: node
              }
            )
          );
        }
      },
      Argument(node) {
        const argDef = context.getArgument();
        const deprecationReason = argDef === null || argDef === void 0 ? void 0 : argDef.deprecationReason;
        if (argDef && deprecationReason != null) {
          const directiveDef = context.getDirective();
          if (directiveDef != null) {
            context.reportError(
              new GraphQLError(
                `Directive "@${directiveDef.name}" argument "${argDef.name}" is deprecated. ${deprecationReason}`,
                {
                  nodes: node
                }
              )
            );
          } else {
            const parentType = context.getParentType();
            const fieldDef = context.getFieldDef();
            parentType != null && fieldDef != null || invariant2(false);
            context.reportError(
              new GraphQLError(
                `Field "${parentType.name}.${fieldDef.name}" argument "${argDef.name}" is deprecated. ${deprecationReason}`,
                {
                  nodes: node
                }
              )
            );
          }
        }
      },
      ObjectField(node) {
        const inputObjectDef = getNamedType(context.getParentInputType());
        if (isInputObjectType(inputObjectDef)) {
          const inputFieldDef = inputObjectDef.getFields()[node.name.value];
          const deprecationReason = inputFieldDef === null || inputFieldDef === void 0 ? void 0 : inputFieldDef.deprecationReason;
          if (deprecationReason != null) {
            context.reportError(
              new GraphQLError(
                `The input field ${inputObjectDef.name}.${inputFieldDef.name} is deprecated. ${deprecationReason}`,
                {
                  nodes: node
                }
              )
            );
          }
        }
      },
      EnumValue(node) {
        const enumValueDef = context.getEnumValue();
        const deprecationReason = enumValueDef === null || enumValueDef === void 0 ? void 0 : enumValueDef.deprecationReason;
        if (enumValueDef && deprecationReason != null) {
          const enumTypeDef = getNamedType(context.getInputType());
          enumTypeDef != null || invariant2(false);
          context.reportError(
            new GraphQLError(
              `The enum value "${enumTypeDef.name}.${enumValueDef.name}" is deprecated. ${deprecationReason}`,
              {
                nodes: node
              }
            )
          );
        }
      }
    };
  }
  var init_NoDeprecatedCustomRule = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/validation/rules/custom/NoDeprecatedCustomRule.mjs"() {
      "use strict";
      init_invariant();
      init_GraphQLError();
      init_definition();
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/validation/rules/custom/NoSchemaIntrospectionCustomRule.mjs
  function NoSchemaIntrospectionCustomRule(context) {
    return {
      Field(node) {
        const type = getNamedType(context.getType());
        if (type && isIntrospectionType(type)) {
          context.reportError(
            new GraphQLError(
              `GraphQL introspection has been disabled, but the requested query contained the field "${node.name.value}".`,
              {
                nodes: node
              }
            )
          );
        }
      }
    };
  }
  var init_NoSchemaIntrospectionCustomRule = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/validation/rules/custom/NoSchemaIntrospectionCustomRule.mjs"() {
      "use strict";
      init_GraphQLError();
      init_definition();
      init_introspection();
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/validation/index.mjs
  var init_validation = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/validation/index.mjs"() {
      "use strict";
      init_validate2();
      init_ValidationContext();
      init_specifiedRules();
      init_ExecutableDefinitionsRule();
      init_FieldsOnCorrectTypeRule();
      init_FragmentsOnCompositeTypesRule();
      init_KnownArgumentNamesRule();
      init_KnownDirectivesRule();
      init_KnownFragmentNamesRule();
      init_KnownTypeNamesRule();
      init_LoneAnonymousOperationRule();
      init_NoFragmentCyclesRule();
      init_NoUndefinedVariablesRule();
      init_NoUnusedFragmentsRule();
      init_NoUnusedVariablesRule();
      init_OverlappingFieldsCanBeMergedRule();
      init_PossibleFragmentSpreadsRule();
      init_ProvidedRequiredArgumentsRule();
      init_ScalarLeafsRule();
      init_SingleFieldSubscriptionsRule();
      init_UniqueArgumentNamesRule();
      init_UniqueDirectivesPerLocationRule();
      init_UniqueFragmentNamesRule();
      init_UniqueInputFieldNamesRule();
      init_UniqueOperationNamesRule();
      init_UniqueVariableNamesRule();
      init_ValuesOfCorrectTypeRule();
      init_VariablesAreInputTypesRule();
      init_VariablesInAllowedPositionRule();
      init_LoneSchemaDefinitionRule();
      init_UniqueOperationTypesRule();
      init_UniqueTypeNamesRule();
      init_UniqueEnumValueNamesRule();
      init_UniqueFieldDefinitionNamesRule();
      init_UniqueArgumentDefinitionNamesRule();
      init_UniqueDirectiveNamesRule();
      init_PossibleTypeExtensionsRule();
      init_NoDeprecatedCustomRule();
      init_NoSchemaIntrospectionCustomRule();
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/error/index.mjs
  var init_error = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/error/index.mjs"() {
      "use strict";
      init_GraphQLError();
      init_syntaxError();
      init_locatedError();
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/utilities/getIntrospectionQuery.mjs
  function getIntrospectionQuery(options) {
    const optionsWithDefault = {
      descriptions: true,
      specifiedByUrl: false,
      directiveIsRepeatable: false,
      schemaDescription: false,
      inputValueDeprecation: false,
      ...options
    };
    const descriptions = optionsWithDefault.descriptions ? "description" : "";
    const specifiedByUrl = optionsWithDefault.specifiedByUrl ? "specifiedByURL" : "";
    const directiveIsRepeatable = optionsWithDefault.directiveIsRepeatable ? "isRepeatable" : "";
    const schemaDescription = optionsWithDefault.schemaDescription ? descriptions : "";
    function inputDeprecation(str) {
      return optionsWithDefault.inputValueDeprecation ? str : "";
    }
    return `
    query IntrospectionQuery {
      __schema {
        ${schemaDescription}
        queryType { name }
        mutationType { name }
        subscriptionType { name }
        types {
          ...FullType
        }
        directives {
          name
          ${descriptions}
          ${directiveIsRepeatable}
          locations
          args${inputDeprecation("(includeDeprecated: true)")} {
            ...InputValue
          }
        }
      }
    }

    fragment FullType on __Type {
      kind
      name
      ${descriptions}
      ${specifiedByUrl}
      fields(includeDeprecated: true) {
        name
        ${descriptions}
        args${inputDeprecation("(includeDeprecated: true)")} {
          ...InputValue
        }
        type {
          ...TypeRef
        }
        isDeprecated
        deprecationReason
      }
      inputFields${inputDeprecation("(includeDeprecated: true)")} {
        ...InputValue
      }
      interfaces {
        ...TypeRef
      }
      enumValues(includeDeprecated: true) {
        name
        ${descriptions}
        isDeprecated
        deprecationReason
      }
      possibleTypes {
        ...TypeRef
      }
    }

    fragment InputValue on __InputValue {
      name
      ${descriptions}
      type { ...TypeRef }
      defaultValue
      ${inputDeprecation("isDeprecated")}
      ${inputDeprecation("deprecationReason")}
    }

    fragment TypeRef on __Type {
      kind
      name
      ofType {
        kind
        name
        ofType {
          kind
          name
          ofType {
            kind
            name
            ofType {
              kind
              name
              ofType {
                kind
                name
                ofType {
                  kind
                  name
                  ofType {
                    kind
                    name
                    ofType {
                      kind
                      name
                      ofType {
                        kind
                        name
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  `;
  }
  var init_getIntrospectionQuery = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/utilities/getIntrospectionQuery.mjs"() {
      "use strict";
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/utilities/getOperationAST.mjs
  function getOperationAST(documentAST, operationName) {
    let operation = null;
    for (const definition of documentAST.definitions) {
      if (definition.kind === Kind.OPERATION_DEFINITION) {
        var _definition$name;
        if (operationName == null) {
          if (operation) {
            return null;
          }
          operation = definition;
        } else if (((_definition$name = definition.name) === null || _definition$name === void 0 ? void 0 : _definition$name.value) === operationName) {
          return definition;
        }
      }
    }
    return operation;
  }
  var init_getOperationAST = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/utilities/getOperationAST.mjs"() {
      "use strict";
      init_kinds();
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/utilities/getOperationRootType.mjs
  function getOperationRootType(schema, operation) {
    if (operation.operation === "query") {
      const queryType = schema.getQueryType();
      if (!queryType) {
        throw new GraphQLError(
          "Schema does not define the required query root type.",
          {
            nodes: operation
          }
        );
      }
      return queryType;
    }
    if (operation.operation === "mutation") {
      const mutationType = schema.getMutationType();
      if (!mutationType) {
        throw new GraphQLError("Schema is not configured for mutations.", {
          nodes: operation
        });
      }
      return mutationType;
    }
    if (operation.operation === "subscription") {
      const subscriptionType = schema.getSubscriptionType();
      if (!subscriptionType) {
        throw new GraphQLError("Schema is not configured for subscriptions.", {
          nodes: operation
        });
      }
      return subscriptionType;
    }
    throw new GraphQLError(
      "Can only have query, mutation and subscription operations.",
      {
        nodes: operation
      }
    );
  }
  var init_getOperationRootType = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/utilities/getOperationRootType.mjs"() {
      "use strict";
      init_GraphQLError();
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/utilities/introspectionFromSchema.mjs
  function introspectionFromSchema(schema, options) {
    const optionsWithDefaults = {
      specifiedByUrl: true,
      directiveIsRepeatable: true,
      schemaDescription: true,
      inputValueDeprecation: true,
      ...options
    };
    const document2 = parse2(getIntrospectionQuery(optionsWithDefaults));
    const result = executeSync({
      schema,
      document: document2
    });
    !result.errors && result.data || invariant2(false);
    return result.data;
  }
  var init_introspectionFromSchema = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/utilities/introspectionFromSchema.mjs"() {
      "use strict";
      init_invariant();
      init_parser();
      init_execute();
      init_getIntrospectionQuery();
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/utilities/buildClientSchema.mjs
  function buildClientSchema(introspection, options) {
    isObjectLike(introspection) && isObjectLike(introspection.__schema) || devAssert(
      false,
      `Invalid or incomplete introspection result. Ensure that you are passing "data" property of introspection response and no "errors" was returned alongside: ${inspect(
        introspection
      )}.`
    );
    const schemaIntrospection = introspection.__schema;
    const typeMap = keyValMap(
      schemaIntrospection.types,
      (typeIntrospection) => typeIntrospection.name,
      (typeIntrospection) => buildType(typeIntrospection)
    );
    for (const stdType of [...specifiedScalarTypes, ...introspectionTypes]) {
      if (typeMap[stdType.name]) {
        typeMap[stdType.name] = stdType;
      }
    }
    const queryType = schemaIntrospection.queryType ? getObjectType(schemaIntrospection.queryType) : null;
    const mutationType = schemaIntrospection.mutationType ? getObjectType(schemaIntrospection.mutationType) : null;
    const subscriptionType = schemaIntrospection.subscriptionType ? getObjectType(schemaIntrospection.subscriptionType) : null;
    const directives = schemaIntrospection.directives ? schemaIntrospection.directives.map(buildDirective) : [];
    return new GraphQLSchema({
      description: schemaIntrospection.description,
      query: queryType,
      mutation: mutationType,
      subscription: subscriptionType,
      types: Object.values(typeMap),
      directives,
      assumeValid: options === null || options === void 0 ? void 0 : options.assumeValid
    });
    function getType(typeRef) {
      if (typeRef.kind === TypeKind.LIST) {
        const itemRef = typeRef.ofType;
        if (!itemRef) {
          throw new Error("Decorated type deeper than introspection query.");
        }
        return new GraphQLList(getType(itemRef));
      }
      if (typeRef.kind === TypeKind.NON_NULL) {
        const nullableRef = typeRef.ofType;
        if (!nullableRef) {
          throw new Error("Decorated type deeper than introspection query.");
        }
        const nullableType = getType(nullableRef);
        return new GraphQLNonNull(assertNullableType(nullableType));
      }
      return getNamedType2(typeRef);
    }
    function getNamedType2(typeRef) {
      const typeName = typeRef.name;
      if (!typeName) {
        throw new Error(`Unknown type reference: ${inspect(typeRef)}.`);
      }
      const type = typeMap[typeName];
      if (!type) {
        throw new Error(
          `Invalid or incomplete schema, unknown type: ${typeName}. Ensure that a full introspection query is used in order to build a client schema.`
        );
      }
      return type;
    }
    function getObjectType(typeRef) {
      return assertObjectType(getNamedType2(typeRef));
    }
    function getInterfaceType(typeRef) {
      return assertInterfaceType(getNamedType2(typeRef));
    }
    function buildType(type) {
      if (type != null && type.name != null && type.kind != null) {
        switch (type.kind) {
          case TypeKind.SCALAR:
            return buildScalarDef(type);
          case TypeKind.OBJECT:
            return buildObjectDef(type);
          case TypeKind.INTERFACE:
            return buildInterfaceDef(type);
          case TypeKind.UNION:
            return buildUnionDef(type);
          case TypeKind.ENUM:
            return buildEnumDef(type);
          case TypeKind.INPUT_OBJECT:
            return buildInputObjectDef(type);
        }
      }
      const typeStr = inspect(type);
      throw new Error(
        `Invalid or incomplete introspection result. Ensure that a full introspection query is used in order to build a client schema: ${typeStr}.`
      );
    }
    function buildScalarDef(scalarIntrospection) {
      return new GraphQLScalarType({
        name: scalarIntrospection.name,
        description: scalarIntrospection.description,
        specifiedByURL: scalarIntrospection.specifiedByURL
      });
    }
    function buildImplementationsList(implementingIntrospection) {
      if (implementingIntrospection.interfaces === null && implementingIntrospection.kind === TypeKind.INTERFACE) {
        return [];
      }
      if (!implementingIntrospection.interfaces) {
        const implementingIntrospectionStr = inspect(implementingIntrospection);
        throw new Error(
          `Introspection result missing interfaces: ${implementingIntrospectionStr}.`
        );
      }
      return implementingIntrospection.interfaces.map(getInterfaceType);
    }
    function buildObjectDef(objectIntrospection) {
      return new GraphQLObjectType({
        name: objectIntrospection.name,
        description: objectIntrospection.description,
        interfaces: () => buildImplementationsList(objectIntrospection),
        fields: () => buildFieldDefMap(objectIntrospection)
      });
    }
    function buildInterfaceDef(interfaceIntrospection) {
      return new GraphQLInterfaceType({
        name: interfaceIntrospection.name,
        description: interfaceIntrospection.description,
        interfaces: () => buildImplementationsList(interfaceIntrospection),
        fields: () => buildFieldDefMap(interfaceIntrospection)
      });
    }
    function buildUnionDef(unionIntrospection) {
      if (!unionIntrospection.possibleTypes) {
        const unionIntrospectionStr = inspect(unionIntrospection);
        throw new Error(
          `Introspection result missing possibleTypes: ${unionIntrospectionStr}.`
        );
      }
      return new GraphQLUnionType({
        name: unionIntrospection.name,
        description: unionIntrospection.description,
        types: () => unionIntrospection.possibleTypes.map(getObjectType)
      });
    }
    function buildEnumDef(enumIntrospection) {
      if (!enumIntrospection.enumValues) {
        const enumIntrospectionStr = inspect(enumIntrospection);
        throw new Error(
          `Introspection result missing enumValues: ${enumIntrospectionStr}.`
        );
      }
      return new GraphQLEnumType({
        name: enumIntrospection.name,
        description: enumIntrospection.description,
        values: keyValMap(
          enumIntrospection.enumValues,
          (valueIntrospection) => valueIntrospection.name,
          (valueIntrospection) => ({
            description: valueIntrospection.description,
            deprecationReason: valueIntrospection.deprecationReason
          })
        )
      });
    }
    function buildInputObjectDef(inputObjectIntrospection) {
      if (!inputObjectIntrospection.inputFields) {
        const inputObjectIntrospectionStr = inspect(inputObjectIntrospection);
        throw new Error(
          `Introspection result missing inputFields: ${inputObjectIntrospectionStr}.`
        );
      }
      return new GraphQLInputObjectType({
        name: inputObjectIntrospection.name,
        description: inputObjectIntrospection.description,
        fields: () => buildInputValueDefMap(inputObjectIntrospection.inputFields)
      });
    }
    function buildFieldDefMap(typeIntrospection) {
      if (!typeIntrospection.fields) {
        throw new Error(
          `Introspection result missing fields: ${inspect(typeIntrospection)}.`
        );
      }
      return keyValMap(
        typeIntrospection.fields,
        (fieldIntrospection) => fieldIntrospection.name,
        buildField
      );
    }
    function buildField(fieldIntrospection) {
      const type = getType(fieldIntrospection.type);
      if (!isOutputType(type)) {
        const typeStr = inspect(type);
        throw new Error(
          `Introspection must provide output type for fields, but received: ${typeStr}.`
        );
      }
      if (!fieldIntrospection.args) {
        const fieldIntrospectionStr = inspect(fieldIntrospection);
        throw new Error(
          `Introspection result missing field args: ${fieldIntrospectionStr}.`
        );
      }
      return {
        description: fieldIntrospection.description,
        deprecationReason: fieldIntrospection.deprecationReason,
        type,
        args: buildInputValueDefMap(fieldIntrospection.args)
      };
    }
    function buildInputValueDefMap(inputValueIntrospections) {
      return keyValMap(
        inputValueIntrospections,
        (inputValue) => inputValue.name,
        buildInputValue
      );
    }
    function buildInputValue(inputValueIntrospection) {
      const type = getType(inputValueIntrospection.type);
      if (!isInputType(type)) {
        const typeStr = inspect(type);
        throw new Error(
          `Introspection must provide input type for arguments, but received: ${typeStr}.`
        );
      }
      const defaultValue = inputValueIntrospection.defaultValue != null ? valueFromAST(parseValue(inputValueIntrospection.defaultValue), type) : void 0;
      return {
        description: inputValueIntrospection.description,
        type,
        defaultValue,
        deprecationReason: inputValueIntrospection.deprecationReason
      };
    }
    function buildDirective(directiveIntrospection) {
      if (!directiveIntrospection.args) {
        const directiveIntrospectionStr = inspect(directiveIntrospection);
        throw new Error(
          `Introspection result missing directive args: ${directiveIntrospectionStr}.`
        );
      }
      if (!directiveIntrospection.locations) {
        const directiveIntrospectionStr = inspect(directiveIntrospection);
        throw new Error(
          `Introspection result missing directive locations: ${directiveIntrospectionStr}.`
        );
      }
      return new GraphQLDirective({
        name: directiveIntrospection.name,
        description: directiveIntrospection.description,
        isRepeatable: directiveIntrospection.isRepeatable,
        locations: directiveIntrospection.locations.slice(),
        args: buildInputValueDefMap(directiveIntrospection.args)
      });
    }
  }
  var init_buildClientSchema = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/utilities/buildClientSchema.mjs"() {
      "use strict";
      init_devAssert();
      init_inspect();
      init_isObjectLike();
      init_keyValMap();
      init_parser();
      init_definition();
      init_directives();
      init_introspection();
      init_scalars();
      init_schema();
      init_valueFromAST();
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/utilities/extendSchema.mjs
  function extendSchema(schema, documentAST, options) {
    assertSchema(schema);
    documentAST != null && documentAST.kind === Kind.DOCUMENT || devAssert(false, "Must provide valid Document AST.");
    if ((options === null || options === void 0 ? void 0 : options.assumeValid) !== true && (options === null || options === void 0 ? void 0 : options.assumeValidSDL) !== true) {
      assertValidSDLExtension(documentAST, schema);
    }
    const schemaConfig = schema.toConfig();
    const extendedConfig = extendSchemaImpl(schemaConfig, documentAST, options);
    return schemaConfig === extendedConfig ? schema : new GraphQLSchema(extendedConfig);
  }
  function extendSchemaImpl(schemaConfig, documentAST, options) {
    var _schemaDef, _schemaDef$descriptio, _schemaDef2, _options$assumeValid;
    const typeDefs = [];
    const typeExtensionsMap = /* @__PURE__ */ Object.create(null);
    const directiveDefs = [];
    let schemaDef;
    const schemaExtensions = [];
    for (const def of documentAST.definitions) {
      if (def.kind === Kind.SCHEMA_DEFINITION) {
        schemaDef = def;
      } else if (def.kind === Kind.SCHEMA_EXTENSION) {
        schemaExtensions.push(def);
      } else if (isTypeDefinitionNode(def)) {
        typeDefs.push(def);
      } else if (isTypeExtensionNode(def)) {
        const extendedTypeName = def.name.value;
        const existingTypeExtensions = typeExtensionsMap[extendedTypeName];
        typeExtensionsMap[extendedTypeName] = existingTypeExtensions ? existingTypeExtensions.concat([def]) : [def];
      } else if (def.kind === Kind.DIRECTIVE_DEFINITION) {
        directiveDefs.push(def);
      }
    }
    if (Object.keys(typeExtensionsMap).length === 0 && typeDefs.length === 0 && directiveDefs.length === 0 && schemaExtensions.length === 0 && schemaDef == null) {
      return schemaConfig;
    }
    const typeMap = /* @__PURE__ */ Object.create(null);
    for (const existingType of schemaConfig.types) {
      typeMap[existingType.name] = extendNamedType(existingType);
    }
    for (const typeNode of typeDefs) {
      var _stdTypeMap$name;
      const name = typeNode.name.value;
      typeMap[name] = (_stdTypeMap$name = stdTypeMap[name]) !== null && _stdTypeMap$name !== void 0 ? _stdTypeMap$name : buildType(typeNode);
    }
    const operationTypes = {
      // Get the extended root operation types.
      query: schemaConfig.query && replaceNamedType(schemaConfig.query),
      mutation: schemaConfig.mutation && replaceNamedType(schemaConfig.mutation),
      subscription: schemaConfig.subscription && replaceNamedType(schemaConfig.subscription),
      // Then, incorporate schema definition and all schema extensions.
      ...schemaDef && getOperationTypes([schemaDef]),
      ...getOperationTypes(schemaExtensions)
    };
    return {
      description: (_schemaDef = schemaDef) === null || _schemaDef === void 0 ? void 0 : (_schemaDef$descriptio = _schemaDef.description) === null || _schemaDef$descriptio === void 0 ? void 0 : _schemaDef$descriptio.value,
      ...operationTypes,
      types: Object.values(typeMap),
      directives: [
        ...schemaConfig.directives.map(replaceDirective),
        ...directiveDefs.map(buildDirective)
      ],
      extensions: /* @__PURE__ */ Object.create(null),
      astNode: (_schemaDef2 = schemaDef) !== null && _schemaDef2 !== void 0 ? _schemaDef2 : schemaConfig.astNode,
      extensionASTNodes: schemaConfig.extensionASTNodes.concat(schemaExtensions),
      assumeValid: (_options$assumeValid = options === null || options === void 0 ? void 0 : options.assumeValid) !== null && _options$assumeValid !== void 0 ? _options$assumeValid : false
    };
    function replaceType(type) {
      if (isListType(type)) {
        return new GraphQLList(replaceType(type.ofType));
      }
      if (isNonNullType(type)) {
        return new GraphQLNonNull(replaceType(type.ofType));
      }
      return replaceNamedType(type);
    }
    function replaceNamedType(type) {
      return typeMap[type.name];
    }
    function replaceDirective(directive) {
      const config = directive.toConfig();
      return new GraphQLDirective({
        ...config,
        args: mapValue(config.args, extendArg)
      });
    }
    function extendNamedType(type) {
      if (isIntrospectionType(type) || isSpecifiedScalarType(type)) {
        return type;
      }
      if (isScalarType(type)) {
        return extendScalarType(type);
      }
      if (isObjectType(type)) {
        return extendObjectType(type);
      }
      if (isInterfaceType(type)) {
        return extendInterfaceType(type);
      }
      if (isUnionType(type)) {
        return extendUnionType(type);
      }
      if (isEnumType(type)) {
        return extendEnumType(type);
      }
      if (isInputObjectType(type)) {
        return extendInputObjectType(type);
      }
      invariant2(false, "Unexpected type: " + inspect(type));
    }
    function extendInputObjectType(type) {
      var _typeExtensionsMap$co;
      const config = type.toConfig();
      const extensions = (_typeExtensionsMap$co = typeExtensionsMap[config.name]) !== null && _typeExtensionsMap$co !== void 0 ? _typeExtensionsMap$co : [];
      return new GraphQLInputObjectType({
        ...config,
        fields: () => ({
          ...mapValue(config.fields, (field) => ({
            ...field,
            type: replaceType(field.type)
          })),
          ...buildInputFieldMap(extensions)
        }),
        extensionASTNodes: config.extensionASTNodes.concat(extensions)
      });
    }
    function extendEnumType(type) {
      var _typeExtensionsMap$ty;
      const config = type.toConfig();
      const extensions = (_typeExtensionsMap$ty = typeExtensionsMap[type.name]) !== null && _typeExtensionsMap$ty !== void 0 ? _typeExtensionsMap$ty : [];
      return new GraphQLEnumType({
        ...config,
        values: { ...config.values, ...buildEnumValueMap(extensions) },
        extensionASTNodes: config.extensionASTNodes.concat(extensions)
      });
    }
    function extendScalarType(type) {
      var _typeExtensionsMap$co2;
      const config = type.toConfig();
      const extensions = (_typeExtensionsMap$co2 = typeExtensionsMap[config.name]) !== null && _typeExtensionsMap$co2 !== void 0 ? _typeExtensionsMap$co2 : [];
      let specifiedByURL = config.specifiedByURL;
      for (const extensionNode of extensions) {
        var _getSpecifiedByURL;
        specifiedByURL = (_getSpecifiedByURL = getSpecifiedByURL(extensionNode)) !== null && _getSpecifiedByURL !== void 0 ? _getSpecifiedByURL : specifiedByURL;
      }
      return new GraphQLScalarType({
        ...config,
        specifiedByURL,
        extensionASTNodes: config.extensionASTNodes.concat(extensions)
      });
    }
    function extendObjectType(type) {
      var _typeExtensionsMap$co3;
      const config = type.toConfig();
      const extensions = (_typeExtensionsMap$co3 = typeExtensionsMap[config.name]) !== null && _typeExtensionsMap$co3 !== void 0 ? _typeExtensionsMap$co3 : [];
      return new GraphQLObjectType({
        ...config,
        interfaces: () => [
          ...type.getInterfaces().map(replaceNamedType),
          ...buildInterfaces(extensions)
        ],
        fields: () => ({
          ...mapValue(config.fields, extendField),
          ...buildFieldMap(extensions)
        }),
        extensionASTNodes: config.extensionASTNodes.concat(extensions)
      });
    }
    function extendInterfaceType(type) {
      var _typeExtensionsMap$co4;
      const config = type.toConfig();
      const extensions = (_typeExtensionsMap$co4 = typeExtensionsMap[config.name]) !== null && _typeExtensionsMap$co4 !== void 0 ? _typeExtensionsMap$co4 : [];
      return new GraphQLInterfaceType({
        ...config,
        interfaces: () => [
          ...type.getInterfaces().map(replaceNamedType),
          ...buildInterfaces(extensions)
        ],
        fields: () => ({
          ...mapValue(config.fields, extendField),
          ...buildFieldMap(extensions)
        }),
        extensionASTNodes: config.extensionASTNodes.concat(extensions)
      });
    }
    function extendUnionType(type) {
      var _typeExtensionsMap$co5;
      const config = type.toConfig();
      const extensions = (_typeExtensionsMap$co5 = typeExtensionsMap[config.name]) !== null && _typeExtensionsMap$co5 !== void 0 ? _typeExtensionsMap$co5 : [];
      return new GraphQLUnionType({
        ...config,
        types: () => [
          ...type.getTypes().map(replaceNamedType),
          ...buildUnionTypes(extensions)
        ],
        extensionASTNodes: config.extensionASTNodes.concat(extensions)
      });
    }
    function extendField(field) {
      return {
        ...field,
        type: replaceType(field.type),
        args: field.args && mapValue(field.args, extendArg)
      };
    }
    function extendArg(arg) {
      return { ...arg, type: replaceType(arg.type) };
    }
    function getOperationTypes(nodes) {
      const opTypes = {};
      for (const node of nodes) {
        var _node$operationTypes;
        const operationTypesNodes = (
          /* c8 ignore next */
          (_node$operationTypes = node.operationTypes) !== null && _node$operationTypes !== void 0 ? _node$operationTypes : []
        );
        for (const operationType of operationTypesNodes) {
          opTypes[operationType.operation] = getNamedType2(operationType.type);
        }
      }
      return opTypes;
    }
    function getNamedType2(node) {
      var _stdTypeMap$name2;
      const name = node.name.value;
      const type = (_stdTypeMap$name2 = stdTypeMap[name]) !== null && _stdTypeMap$name2 !== void 0 ? _stdTypeMap$name2 : typeMap[name];
      if (type === void 0) {
        throw new Error(`Unknown type: "${name}".`);
      }
      return type;
    }
    function getWrappedType(node) {
      if (node.kind === Kind.LIST_TYPE) {
        return new GraphQLList(getWrappedType(node.type));
      }
      if (node.kind === Kind.NON_NULL_TYPE) {
        return new GraphQLNonNull(getWrappedType(node.type));
      }
      return getNamedType2(node);
    }
    function buildDirective(node) {
      var _node$description;
      return new GraphQLDirective({
        name: node.name.value,
        description: (_node$description = node.description) === null || _node$description === void 0 ? void 0 : _node$description.value,
        // @ts-expect-error
        locations: node.locations.map(({ value }) => value),
        isRepeatable: node.repeatable,
        args: buildArgumentMap(node.arguments),
        astNode: node
      });
    }
    function buildFieldMap(nodes) {
      const fieldConfigMap = /* @__PURE__ */ Object.create(null);
      for (const node of nodes) {
        var _node$fields;
        const nodeFields = (
          /* c8 ignore next */
          (_node$fields = node.fields) !== null && _node$fields !== void 0 ? _node$fields : []
        );
        for (const field of nodeFields) {
          var _field$description;
          fieldConfigMap[field.name.value] = {
            // Note: While this could make assertions to get the correctly typed
            // value, that would throw immediately while type system validation
            // with validateSchema() will produce more actionable results.
            type: getWrappedType(field.type),
            description: (_field$description = field.description) === null || _field$description === void 0 ? void 0 : _field$description.value,
            args: buildArgumentMap(field.arguments),
            deprecationReason: getDeprecationReason(field),
            astNode: field
          };
        }
      }
      return fieldConfigMap;
    }
    function buildArgumentMap(args) {
      const argsNodes = (
        /* c8 ignore next */
        args !== null && args !== void 0 ? args : []
      );
      const argConfigMap = /* @__PURE__ */ Object.create(null);
      for (const arg of argsNodes) {
        var _arg$description;
        const type = getWrappedType(arg.type);
        argConfigMap[arg.name.value] = {
          type,
          description: (_arg$description = arg.description) === null || _arg$description === void 0 ? void 0 : _arg$description.value,
          defaultValue: valueFromAST(arg.defaultValue, type),
          deprecationReason: getDeprecationReason(arg),
          astNode: arg
        };
      }
      return argConfigMap;
    }
    function buildInputFieldMap(nodes) {
      const inputFieldMap = /* @__PURE__ */ Object.create(null);
      for (const node of nodes) {
        var _node$fields2;
        const fieldsNodes = (
          /* c8 ignore next */
          (_node$fields2 = node.fields) !== null && _node$fields2 !== void 0 ? _node$fields2 : []
        );
        for (const field of fieldsNodes) {
          var _field$description2;
          const type = getWrappedType(field.type);
          inputFieldMap[field.name.value] = {
            type,
            description: (_field$description2 = field.description) === null || _field$description2 === void 0 ? void 0 : _field$description2.value,
            defaultValue: valueFromAST(field.defaultValue, type),
            deprecationReason: getDeprecationReason(field),
            astNode: field
          };
        }
      }
      return inputFieldMap;
    }
    function buildEnumValueMap(nodes) {
      const enumValueMap = /* @__PURE__ */ Object.create(null);
      for (const node of nodes) {
        var _node$values;
        const valuesNodes = (
          /* c8 ignore next */
          (_node$values = node.values) !== null && _node$values !== void 0 ? _node$values : []
        );
        for (const value of valuesNodes) {
          var _value$description;
          enumValueMap[value.name.value] = {
            description: (_value$description = value.description) === null || _value$description === void 0 ? void 0 : _value$description.value,
            deprecationReason: getDeprecationReason(value),
            astNode: value
          };
        }
      }
      return enumValueMap;
    }
    function buildInterfaces(nodes) {
      return nodes.flatMap(
        // FIXME: https://github.com/graphql/graphql-js/issues/2203
        (node) => {
          var _node$interfaces$map, _node$interfaces;
          return (
            /* c8 ignore next */
            (_node$interfaces$map = (_node$interfaces = node.interfaces) === null || _node$interfaces === void 0 ? void 0 : _node$interfaces.map(getNamedType2)) !== null && _node$interfaces$map !== void 0 ? _node$interfaces$map : []
          );
        }
      );
    }
    function buildUnionTypes(nodes) {
      return nodes.flatMap(
        // FIXME: https://github.com/graphql/graphql-js/issues/2203
        (node) => {
          var _node$types$map, _node$types;
          return (
            /* c8 ignore next */
            (_node$types$map = (_node$types = node.types) === null || _node$types === void 0 ? void 0 : _node$types.map(getNamedType2)) !== null && _node$types$map !== void 0 ? _node$types$map : []
          );
        }
      );
    }
    function buildType(astNode) {
      var _typeExtensionsMap$na;
      const name = astNode.name.value;
      const extensionASTNodes = (_typeExtensionsMap$na = typeExtensionsMap[name]) !== null && _typeExtensionsMap$na !== void 0 ? _typeExtensionsMap$na : [];
      switch (astNode.kind) {
        case Kind.OBJECT_TYPE_DEFINITION: {
          var _astNode$description;
          const allNodes = [astNode, ...extensionASTNodes];
          return new GraphQLObjectType({
            name,
            description: (_astNode$description = astNode.description) === null || _astNode$description === void 0 ? void 0 : _astNode$description.value,
            interfaces: () => buildInterfaces(allNodes),
            fields: () => buildFieldMap(allNodes),
            astNode,
            extensionASTNodes
          });
        }
        case Kind.INTERFACE_TYPE_DEFINITION: {
          var _astNode$description2;
          const allNodes = [astNode, ...extensionASTNodes];
          return new GraphQLInterfaceType({
            name,
            description: (_astNode$description2 = astNode.description) === null || _astNode$description2 === void 0 ? void 0 : _astNode$description2.value,
            interfaces: () => buildInterfaces(allNodes),
            fields: () => buildFieldMap(allNodes),
            astNode,
            extensionASTNodes
          });
        }
        case Kind.ENUM_TYPE_DEFINITION: {
          var _astNode$description3;
          const allNodes = [astNode, ...extensionASTNodes];
          return new GraphQLEnumType({
            name,
            description: (_astNode$description3 = astNode.description) === null || _astNode$description3 === void 0 ? void 0 : _astNode$description3.value,
            values: buildEnumValueMap(allNodes),
            astNode,
            extensionASTNodes
          });
        }
        case Kind.UNION_TYPE_DEFINITION: {
          var _astNode$description4;
          const allNodes = [astNode, ...extensionASTNodes];
          return new GraphQLUnionType({
            name,
            description: (_astNode$description4 = astNode.description) === null || _astNode$description4 === void 0 ? void 0 : _astNode$description4.value,
            types: () => buildUnionTypes(allNodes),
            astNode,
            extensionASTNodes
          });
        }
        case Kind.SCALAR_TYPE_DEFINITION: {
          var _astNode$description5;
          return new GraphQLScalarType({
            name,
            description: (_astNode$description5 = astNode.description) === null || _astNode$description5 === void 0 ? void 0 : _astNode$description5.value,
            specifiedByURL: getSpecifiedByURL(astNode),
            astNode,
            extensionASTNodes
          });
        }
        case Kind.INPUT_OBJECT_TYPE_DEFINITION: {
          var _astNode$description6;
          const allNodes = [astNode, ...extensionASTNodes];
          return new GraphQLInputObjectType({
            name,
            description: (_astNode$description6 = astNode.description) === null || _astNode$description6 === void 0 ? void 0 : _astNode$description6.value,
            fields: () => buildInputFieldMap(allNodes),
            astNode,
            extensionASTNodes
          });
        }
      }
    }
  }
  function getDeprecationReason(node) {
    const deprecated = getDirectiveValues(GraphQLDeprecatedDirective, node);
    return deprecated === null || deprecated === void 0 ? void 0 : deprecated.reason;
  }
  function getSpecifiedByURL(node) {
    const specifiedBy = getDirectiveValues(GraphQLSpecifiedByDirective, node);
    return specifiedBy === null || specifiedBy === void 0 ? void 0 : specifiedBy.url;
  }
  var stdTypeMap;
  var init_extendSchema = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/utilities/extendSchema.mjs"() {
      "use strict";
      init_devAssert();
      init_inspect();
      init_invariant();
      init_keyMap();
      init_mapValue();
      init_kinds();
      init_predicates();
      init_definition();
      init_directives();
      init_introspection();
      init_scalars();
      init_schema();
      init_validate2();
      init_values();
      init_valueFromAST();
      stdTypeMap = keyMap(
        [...specifiedScalarTypes, ...introspectionTypes],
        (type) => type.name
      );
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/utilities/buildASTSchema.mjs
  function buildASTSchema(documentAST, options) {
    documentAST != null && documentAST.kind === Kind.DOCUMENT || devAssert(false, "Must provide valid Document AST.");
    if ((options === null || options === void 0 ? void 0 : options.assumeValid) !== true && (options === null || options === void 0 ? void 0 : options.assumeValidSDL) !== true) {
      assertValidSDL(documentAST);
    }
    const emptySchemaConfig = {
      description: void 0,
      types: [],
      directives: [],
      extensions: /* @__PURE__ */ Object.create(null),
      extensionASTNodes: [],
      assumeValid: false
    };
    const config = extendSchemaImpl(emptySchemaConfig, documentAST, options);
    if (config.astNode == null) {
      for (const type of config.types) {
        switch (type.name) {
          // Note: While this could make early assertions to get the correctly
          // typed values below, that would throw immediately while type system
          // validation with validateSchema() will produce more actionable results.
          case "Query":
            config.query = type;
            break;
          case "Mutation":
            config.mutation = type;
            break;
          case "Subscription":
            config.subscription = type;
            break;
        }
      }
    }
    const directives = [
      ...config.directives,
      // If specified directives were not explicitly declared, add them.
      ...specifiedDirectives.filter(
        (stdDirective) => config.directives.every(
          (directive) => directive.name !== stdDirective.name
        )
      )
    ];
    return new GraphQLSchema({ ...config, directives });
  }
  function buildSchema(source, options) {
    const document2 = parse2(source, {
      noLocation: options === null || options === void 0 ? void 0 : options.noLocation,
      allowLegacyFragmentVariables: options === null || options === void 0 ? void 0 : options.allowLegacyFragmentVariables
    });
    return buildASTSchema(document2, {
      assumeValidSDL: options === null || options === void 0 ? void 0 : options.assumeValidSDL,
      assumeValid: options === null || options === void 0 ? void 0 : options.assumeValid
    });
  }
  var init_buildASTSchema = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/utilities/buildASTSchema.mjs"() {
      "use strict";
      init_devAssert();
      init_kinds();
      init_parser();
      init_directives();
      init_schema();
      init_validate2();
      init_extendSchema();
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/utilities/lexicographicSortSchema.mjs
  function lexicographicSortSchema(schema) {
    const schemaConfig = schema.toConfig();
    const typeMap = keyValMap(
      sortByName(schemaConfig.types),
      (type) => type.name,
      sortNamedType
    );
    return new GraphQLSchema({
      ...schemaConfig,
      types: Object.values(typeMap),
      directives: sortByName(schemaConfig.directives).map(sortDirective),
      query: replaceMaybeType(schemaConfig.query),
      mutation: replaceMaybeType(schemaConfig.mutation),
      subscription: replaceMaybeType(schemaConfig.subscription)
    });
    function replaceType(type) {
      if (isListType(type)) {
        return new GraphQLList(replaceType(type.ofType));
      } else if (isNonNullType(type)) {
        return new GraphQLNonNull(replaceType(type.ofType));
      }
      return replaceNamedType(type);
    }
    function replaceNamedType(type) {
      return typeMap[type.name];
    }
    function replaceMaybeType(maybeType) {
      return maybeType && replaceNamedType(maybeType);
    }
    function sortDirective(directive) {
      const config = directive.toConfig();
      return new GraphQLDirective({
        ...config,
        locations: sortBy(config.locations, (x) => x),
        args: sortArgs(config.args)
      });
    }
    function sortArgs(args) {
      return sortObjMap(args, (arg) => ({ ...arg, type: replaceType(arg.type) }));
    }
    function sortFields2(fieldsMap) {
      return sortObjMap(fieldsMap, (field) => ({
        ...field,
        type: replaceType(field.type),
        args: field.args && sortArgs(field.args)
      }));
    }
    function sortInputFields(fieldsMap) {
      return sortObjMap(fieldsMap, (field) => ({
        ...field,
        type: replaceType(field.type)
      }));
    }
    function sortTypes(array) {
      return sortByName(array).map(replaceNamedType);
    }
    function sortNamedType(type) {
      if (isScalarType(type) || isIntrospectionType(type)) {
        return type;
      }
      if (isObjectType(type)) {
        const config = type.toConfig();
        return new GraphQLObjectType({
          ...config,
          interfaces: () => sortTypes(config.interfaces),
          fields: () => sortFields2(config.fields)
        });
      }
      if (isInterfaceType(type)) {
        const config = type.toConfig();
        return new GraphQLInterfaceType({
          ...config,
          interfaces: () => sortTypes(config.interfaces),
          fields: () => sortFields2(config.fields)
        });
      }
      if (isUnionType(type)) {
        const config = type.toConfig();
        return new GraphQLUnionType({
          ...config,
          types: () => sortTypes(config.types)
        });
      }
      if (isEnumType(type)) {
        const config = type.toConfig();
        return new GraphQLEnumType({
          ...config,
          values: sortObjMap(config.values, (value) => value)
        });
      }
      if (isInputObjectType(type)) {
        const config = type.toConfig();
        return new GraphQLInputObjectType({
          ...config,
          fields: () => sortInputFields(config.fields)
        });
      }
      invariant2(false, "Unexpected type: " + inspect(type));
    }
  }
  function sortObjMap(map, sortValueFn) {
    const sortedMap = /* @__PURE__ */ Object.create(null);
    for (const key of Object.keys(map).sort(naturalCompare)) {
      sortedMap[key] = sortValueFn(map[key]);
    }
    return sortedMap;
  }
  function sortByName(array) {
    return sortBy(array, (obj) => obj.name);
  }
  function sortBy(array, mapToKey) {
    return array.slice().sort((obj1, obj2) => {
      const key1 = mapToKey(obj1);
      const key2 = mapToKey(obj2);
      return naturalCompare(key1, key2);
    });
  }
  var init_lexicographicSortSchema = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/utilities/lexicographicSortSchema.mjs"() {
      "use strict";
      init_inspect();
      init_invariant();
      init_keyValMap();
      init_naturalCompare();
      init_definition();
      init_directives();
      init_introspection();
      init_schema();
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/utilities/printSchema.mjs
  function printSchema(schema) {
    return printFilteredSchema(
      schema,
      (n) => !isSpecifiedDirective(n),
      isDefinedType
    );
  }
  function printIntrospectionSchema(schema) {
    return printFilteredSchema(schema, isSpecifiedDirective, isIntrospectionType);
  }
  function isDefinedType(type) {
    return !isSpecifiedScalarType(type) && !isIntrospectionType(type);
  }
  function printFilteredSchema(schema, directiveFilter, typeFilter) {
    const directives = schema.getDirectives().filter(directiveFilter);
    const types = Object.values(schema.getTypeMap()).filter(typeFilter);
    return [
      printSchemaDefinition(schema),
      ...directives.map((directive) => printDirective(directive)),
      ...types.map((type) => printType(type))
    ].filter(Boolean).join("\n\n");
  }
  function printSchemaDefinition(schema) {
    if (schema.description == null && isSchemaOfCommonNames(schema)) {
      return;
    }
    const operationTypes = [];
    const queryType = schema.getQueryType();
    if (queryType) {
      operationTypes.push(`  query: ${queryType.name}`);
    }
    const mutationType = schema.getMutationType();
    if (mutationType) {
      operationTypes.push(`  mutation: ${mutationType.name}`);
    }
    const subscriptionType = schema.getSubscriptionType();
    if (subscriptionType) {
      operationTypes.push(`  subscription: ${subscriptionType.name}`);
    }
    return printDescription(schema) + `schema {
${operationTypes.join("\n")}
}`;
  }
  function isSchemaOfCommonNames(schema) {
    const queryType = schema.getQueryType();
    if (queryType && queryType.name !== "Query") {
      return false;
    }
    const mutationType = schema.getMutationType();
    if (mutationType && mutationType.name !== "Mutation") {
      return false;
    }
    const subscriptionType = schema.getSubscriptionType();
    if (subscriptionType && subscriptionType.name !== "Subscription") {
      return false;
    }
    return true;
  }
  function printType(type) {
    if (isScalarType(type)) {
      return printScalar(type);
    }
    if (isObjectType(type)) {
      return printObject(type);
    }
    if (isInterfaceType(type)) {
      return printInterface(type);
    }
    if (isUnionType(type)) {
      return printUnion(type);
    }
    if (isEnumType(type)) {
      return printEnum(type);
    }
    if (isInputObjectType(type)) {
      return printInputObject(type);
    }
    invariant2(false, "Unexpected type: " + inspect(type));
  }
  function printScalar(type) {
    return printDescription(type) + `scalar ${type.name}` + printSpecifiedByURL(type);
  }
  function printImplementedInterfaces(type) {
    const interfaces = type.getInterfaces();
    return interfaces.length ? " implements " + interfaces.map((i) => i.name).join(" & ") : "";
  }
  function printObject(type) {
    return printDescription(type) + `type ${type.name}` + printImplementedInterfaces(type) + printFields(type);
  }
  function printInterface(type) {
    return printDescription(type) + `interface ${type.name}` + printImplementedInterfaces(type) + printFields(type);
  }
  function printUnion(type) {
    const types = type.getTypes();
    const possibleTypes = types.length ? " = " + types.join(" | ") : "";
    return printDescription(type) + "union " + type.name + possibleTypes;
  }
  function printEnum(type) {
    const values = type.getValues().map(
      (value, i) => printDescription(value, "  ", !i) + "  " + value.name + printDeprecated(value.deprecationReason)
    );
    return printDescription(type) + `enum ${type.name}` + printBlock(values);
  }
  function printInputObject(type) {
    const fields = Object.values(type.getFields()).map(
      (f, i) => printDescription(f, "  ", !i) + "  " + printInputValue(f)
    );
    return printDescription(type) + `input ${type.name}` + printBlock(fields);
  }
  function printFields(type) {
    const fields = Object.values(type.getFields()).map(
      (f, i) => printDescription(f, "  ", !i) + "  " + f.name + printArgs(f.args, "  ") + ": " + String(f.type) + printDeprecated(f.deprecationReason)
    );
    return printBlock(fields);
  }
  function printBlock(items) {
    return items.length !== 0 ? " {\n" + items.join("\n") + "\n}" : "";
  }
  function printArgs(args, indentation = "") {
    if (args.length === 0) {
      return "";
    }
    if (args.every((arg) => !arg.description)) {
      return "(" + args.map(printInputValue).join(", ") + ")";
    }
    return "(\n" + args.map(
      (arg, i) => printDescription(arg, "  " + indentation, !i) + "  " + indentation + printInputValue(arg)
    ).join("\n") + "\n" + indentation + ")";
  }
  function printInputValue(arg) {
    const defaultAST = astFromValue(arg.defaultValue, arg.type);
    let argDecl = arg.name + ": " + String(arg.type);
    if (defaultAST) {
      argDecl += ` = ${print(defaultAST)}`;
    }
    return argDecl + printDeprecated(arg.deprecationReason);
  }
  function printDirective(directive) {
    return printDescription(directive) + "directive @" + directive.name + printArgs(directive.args) + (directive.isRepeatable ? " repeatable" : "") + " on " + directive.locations.join(" | ");
  }
  function printDeprecated(reason) {
    if (reason == null) {
      return "";
    }
    if (reason !== DEFAULT_DEPRECATION_REASON) {
      const astValue = print({
        kind: Kind.STRING,
        value: reason
      });
      return ` @deprecated(reason: ${astValue})`;
    }
    return " @deprecated";
  }
  function printSpecifiedByURL(scalar) {
    if (scalar.specifiedByURL == null) {
      return "";
    }
    const astValue = print({
      kind: Kind.STRING,
      value: scalar.specifiedByURL
    });
    return ` @specifiedBy(url: ${astValue})`;
  }
  function printDescription(def, indentation = "", firstInBlock = true) {
    const { description } = def;
    if (description == null) {
      return "";
    }
    const blockString = print({
      kind: Kind.STRING,
      value: description,
      block: isPrintableAsBlockString(description)
    });
    const prefix = indentation && !firstInBlock ? "\n" + indentation : indentation;
    return prefix + blockString.replace(/\n/g, "\n" + indentation) + "\n";
  }
  var init_printSchema = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/utilities/printSchema.mjs"() {
      "use strict";
      init_inspect();
      init_invariant();
      init_blockString();
      init_kinds();
      init_printer();
      init_definition();
      init_directives();
      init_introspection();
      init_scalars();
      init_astFromValue();
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/utilities/concatAST.mjs
  function concatAST(documents) {
    const definitions = [];
    for (const doc of documents) {
      definitions.push(...doc.definitions);
    }
    return {
      kind: Kind.DOCUMENT,
      definitions
    };
  }
  var init_concatAST = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/utilities/concatAST.mjs"() {
      "use strict";
      init_kinds();
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/utilities/separateOperations.mjs
  function separateOperations(documentAST) {
    const operations = [];
    const depGraph = /* @__PURE__ */ Object.create(null);
    for (const definitionNode of documentAST.definitions) {
      switch (definitionNode.kind) {
        case Kind.OPERATION_DEFINITION:
          operations.push(definitionNode);
          break;
        case Kind.FRAGMENT_DEFINITION:
          depGraph[definitionNode.name.value] = collectDependencies(
            definitionNode.selectionSet
          );
          break;
        default:
      }
    }
    const separatedDocumentASTs = /* @__PURE__ */ Object.create(null);
    for (const operation of operations) {
      const dependencies = /* @__PURE__ */ new Set();
      for (const fragmentName of collectDependencies(operation.selectionSet)) {
        collectTransitiveDependencies(dependencies, depGraph, fragmentName);
      }
      const operationName = operation.name ? operation.name.value : "";
      separatedDocumentASTs[operationName] = {
        kind: Kind.DOCUMENT,
        definitions: documentAST.definitions.filter(
          (node) => node === operation || node.kind === Kind.FRAGMENT_DEFINITION && dependencies.has(node.name.value)
        )
      };
    }
    return separatedDocumentASTs;
  }
  function collectTransitiveDependencies(collected, depGraph, fromName) {
    if (!collected.has(fromName)) {
      collected.add(fromName);
      const immediateDeps = depGraph[fromName];
      if (immediateDeps !== void 0) {
        for (const toName of immediateDeps) {
          collectTransitiveDependencies(collected, depGraph, toName);
        }
      }
    }
  }
  function collectDependencies(selectionSet) {
    const dependencies = [];
    visit(selectionSet, {
      FragmentSpread(node) {
        dependencies.push(node.name.value);
      }
    });
    return dependencies;
  }
  var init_separateOperations = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/utilities/separateOperations.mjs"() {
      "use strict";
      init_kinds();
      init_visitor();
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/utilities/stripIgnoredCharacters.mjs
  function stripIgnoredCharacters(source) {
    const sourceObj = isSource(source) ? source : new Source(source);
    const body = sourceObj.body;
    const lexer2 = new Lexer(sourceObj);
    let strippedBody = "";
    let wasLastAddedTokenNonPunctuator = false;
    while (lexer2.advance().kind !== TokenKind.EOF) {
      const currentToken = lexer2.token;
      const tokenKind = currentToken.kind;
      const isNonPunctuator = !isPunctuatorTokenKind(currentToken.kind);
      if (wasLastAddedTokenNonPunctuator) {
        if (isNonPunctuator || currentToken.kind === TokenKind.SPREAD) {
          strippedBody += " ";
        }
      }
      const tokenBody = body.slice(currentToken.start, currentToken.end);
      if (tokenKind === TokenKind.BLOCK_STRING) {
        strippedBody += printBlockString(currentToken.value, {
          minimize: true
        });
      } else {
        strippedBody += tokenBody;
      }
      wasLastAddedTokenNonPunctuator = isNonPunctuator;
    }
    return strippedBody;
  }
  var init_stripIgnoredCharacters = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/utilities/stripIgnoredCharacters.mjs"() {
      "use strict";
      init_blockString();
      init_lexer();
      init_source();
      init_tokenKind();
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/utilities/assertValidName.mjs
  function assertValidName(name) {
    const error3 = isValidNameError(name);
    if (error3) {
      throw error3;
    }
    return name;
  }
  function isValidNameError(name) {
    typeof name === "string" || devAssert(false, "Expected name to be a string.");
    if (name.startsWith("__")) {
      return new GraphQLError(
        `Name "${name}" must not begin with "__", which is reserved by GraphQL introspection.`
      );
    }
    try {
      assertName(name);
    } catch (error3) {
      return error3;
    }
  }
  var init_assertValidName = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/utilities/assertValidName.mjs"() {
      "use strict";
      init_devAssert();
      init_GraphQLError();
      init_assertName();
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/utilities/findBreakingChanges.mjs
  function findBreakingChanges(oldSchema, newSchema) {
    return findSchemaChanges(oldSchema, newSchema).filter(
      (change) => change.type in BreakingChangeType
    );
  }
  function findDangerousChanges(oldSchema, newSchema) {
    return findSchemaChanges(oldSchema, newSchema).filter(
      (change) => change.type in DangerousChangeType
    );
  }
  function findSchemaChanges(oldSchema, newSchema) {
    return [
      ...findTypeChanges(oldSchema, newSchema),
      ...findDirectiveChanges(oldSchema, newSchema)
    ];
  }
  function findDirectiveChanges(oldSchema, newSchema) {
    const schemaChanges = [];
    const directivesDiff = diff(
      oldSchema.getDirectives(),
      newSchema.getDirectives()
    );
    for (const oldDirective of directivesDiff.removed) {
      schemaChanges.push({
        type: BreakingChangeType.DIRECTIVE_REMOVED,
        description: `${oldDirective.name} was removed.`
      });
    }
    for (const [oldDirective, newDirective] of directivesDiff.persisted) {
      const argsDiff = diff(oldDirective.args, newDirective.args);
      for (const newArg of argsDiff.added) {
        if (isRequiredArgument(newArg)) {
          schemaChanges.push({
            type: BreakingChangeType.REQUIRED_DIRECTIVE_ARG_ADDED,
            description: `A required arg ${newArg.name} on directive ${oldDirective.name} was added.`
          });
        }
      }
      for (const oldArg of argsDiff.removed) {
        schemaChanges.push({
          type: BreakingChangeType.DIRECTIVE_ARG_REMOVED,
          description: `${oldArg.name} was removed from ${oldDirective.name}.`
        });
      }
      if (oldDirective.isRepeatable && !newDirective.isRepeatable) {
        schemaChanges.push({
          type: BreakingChangeType.DIRECTIVE_REPEATABLE_REMOVED,
          description: `Repeatable flag was removed from ${oldDirective.name}.`
        });
      }
      for (const location2 of oldDirective.locations) {
        if (!newDirective.locations.includes(location2)) {
          schemaChanges.push({
            type: BreakingChangeType.DIRECTIVE_LOCATION_REMOVED,
            description: `${location2} was removed from ${oldDirective.name}.`
          });
        }
      }
    }
    return schemaChanges;
  }
  function findTypeChanges(oldSchema, newSchema) {
    const schemaChanges = [];
    const typesDiff = diff(
      Object.values(oldSchema.getTypeMap()),
      Object.values(newSchema.getTypeMap())
    );
    for (const oldType of typesDiff.removed) {
      schemaChanges.push({
        type: BreakingChangeType.TYPE_REMOVED,
        description: isSpecifiedScalarType(oldType) ? `Standard scalar ${oldType.name} was removed because it is not referenced anymore.` : `${oldType.name} was removed.`
      });
    }
    for (const [oldType, newType] of typesDiff.persisted) {
      if (isEnumType(oldType) && isEnumType(newType)) {
        schemaChanges.push(...findEnumTypeChanges(oldType, newType));
      } else if (isUnionType(oldType) && isUnionType(newType)) {
        schemaChanges.push(...findUnionTypeChanges(oldType, newType));
      } else if (isInputObjectType(oldType) && isInputObjectType(newType)) {
        schemaChanges.push(...findInputObjectTypeChanges(oldType, newType));
      } else if (isObjectType(oldType) && isObjectType(newType)) {
        schemaChanges.push(
          ...findFieldChanges(oldType, newType),
          ...findImplementedInterfacesChanges(oldType, newType)
        );
      } else if (isInterfaceType(oldType) && isInterfaceType(newType)) {
        schemaChanges.push(
          ...findFieldChanges(oldType, newType),
          ...findImplementedInterfacesChanges(oldType, newType)
        );
      } else if (oldType.constructor !== newType.constructor) {
        schemaChanges.push({
          type: BreakingChangeType.TYPE_CHANGED_KIND,
          description: `${oldType.name} changed from ${typeKindName(oldType)} to ${typeKindName(newType)}.`
        });
      }
    }
    return schemaChanges;
  }
  function findInputObjectTypeChanges(oldType, newType) {
    const schemaChanges = [];
    const fieldsDiff = diff(
      Object.values(oldType.getFields()),
      Object.values(newType.getFields())
    );
    for (const newField of fieldsDiff.added) {
      if (isRequiredInputField(newField)) {
        schemaChanges.push({
          type: BreakingChangeType.REQUIRED_INPUT_FIELD_ADDED,
          description: `A required field ${newField.name} on input type ${oldType.name} was added.`
        });
      } else {
        schemaChanges.push({
          type: DangerousChangeType.OPTIONAL_INPUT_FIELD_ADDED,
          description: `An optional field ${newField.name} on input type ${oldType.name} was added.`
        });
      }
    }
    for (const oldField of fieldsDiff.removed) {
      schemaChanges.push({
        type: BreakingChangeType.FIELD_REMOVED,
        description: `${oldType.name}.${oldField.name} was removed.`
      });
    }
    for (const [oldField, newField] of fieldsDiff.persisted) {
      const isSafe = isChangeSafeForInputObjectFieldOrFieldArg(
        oldField.type,
        newField.type
      );
      if (!isSafe) {
        schemaChanges.push({
          type: BreakingChangeType.FIELD_CHANGED_KIND,
          description: `${oldType.name}.${oldField.name} changed type from ${String(oldField.type)} to ${String(newField.type)}.`
        });
      }
    }
    return schemaChanges;
  }
  function findUnionTypeChanges(oldType, newType) {
    const schemaChanges = [];
    const possibleTypesDiff = diff(oldType.getTypes(), newType.getTypes());
    for (const newPossibleType of possibleTypesDiff.added) {
      schemaChanges.push({
        type: DangerousChangeType.TYPE_ADDED_TO_UNION,
        description: `${newPossibleType.name} was added to union type ${oldType.name}.`
      });
    }
    for (const oldPossibleType of possibleTypesDiff.removed) {
      schemaChanges.push({
        type: BreakingChangeType.TYPE_REMOVED_FROM_UNION,
        description: `${oldPossibleType.name} was removed from union type ${oldType.name}.`
      });
    }
    return schemaChanges;
  }
  function findEnumTypeChanges(oldType, newType) {
    const schemaChanges = [];
    const valuesDiff = diff(oldType.getValues(), newType.getValues());
    for (const newValue of valuesDiff.added) {
      schemaChanges.push({
        type: DangerousChangeType.VALUE_ADDED_TO_ENUM,
        description: `${newValue.name} was added to enum type ${oldType.name}.`
      });
    }
    for (const oldValue of valuesDiff.removed) {
      schemaChanges.push({
        type: BreakingChangeType.VALUE_REMOVED_FROM_ENUM,
        description: `${oldValue.name} was removed from enum type ${oldType.name}.`
      });
    }
    return schemaChanges;
  }
  function findImplementedInterfacesChanges(oldType, newType) {
    const schemaChanges = [];
    const interfacesDiff = diff(oldType.getInterfaces(), newType.getInterfaces());
    for (const newInterface of interfacesDiff.added) {
      schemaChanges.push({
        type: DangerousChangeType.IMPLEMENTED_INTERFACE_ADDED,
        description: `${newInterface.name} added to interfaces implemented by ${oldType.name}.`
      });
    }
    for (const oldInterface of interfacesDiff.removed) {
      schemaChanges.push({
        type: BreakingChangeType.IMPLEMENTED_INTERFACE_REMOVED,
        description: `${oldType.name} no longer implements interface ${oldInterface.name}.`
      });
    }
    return schemaChanges;
  }
  function findFieldChanges(oldType, newType) {
    const schemaChanges = [];
    const fieldsDiff = diff(
      Object.values(oldType.getFields()),
      Object.values(newType.getFields())
    );
    for (const oldField of fieldsDiff.removed) {
      schemaChanges.push({
        type: BreakingChangeType.FIELD_REMOVED,
        description: `${oldType.name}.${oldField.name} was removed.`
      });
    }
    for (const [oldField, newField] of fieldsDiff.persisted) {
      schemaChanges.push(...findArgChanges(oldType, oldField, newField));
      const isSafe = isChangeSafeForObjectOrInterfaceField(
        oldField.type,
        newField.type
      );
      if (!isSafe) {
        schemaChanges.push({
          type: BreakingChangeType.FIELD_CHANGED_KIND,
          description: `${oldType.name}.${oldField.name} changed type from ${String(oldField.type)} to ${String(newField.type)}.`
        });
      }
    }
    return schemaChanges;
  }
  function findArgChanges(oldType, oldField, newField) {
    const schemaChanges = [];
    const argsDiff = diff(oldField.args, newField.args);
    for (const oldArg of argsDiff.removed) {
      schemaChanges.push({
        type: BreakingChangeType.ARG_REMOVED,
        description: `${oldType.name}.${oldField.name} arg ${oldArg.name} was removed.`
      });
    }
    for (const [oldArg, newArg] of argsDiff.persisted) {
      const isSafe = isChangeSafeForInputObjectFieldOrFieldArg(
        oldArg.type,
        newArg.type
      );
      if (!isSafe) {
        schemaChanges.push({
          type: BreakingChangeType.ARG_CHANGED_KIND,
          description: `${oldType.name}.${oldField.name} arg ${oldArg.name} has changed type from ${String(oldArg.type)} to ${String(newArg.type)}.`
        });
      } else if (oldArg.defaultValue !== void 0) {
        if (newArg.defaultValue === void 0) {
          schemaChanges.push({
            type: DangerousChangeType.ARG_DEFAULT_VALUE_CHANGE,
            description: `${oldType.name}.${oldField.name} arg ${oldArg.name} defaultValue was removed.`
          });
        } else {
          const oldValueStr = stringifyValue2(oldArg.defaultValue, oldArg.type);
          const newValueStr = stringifyValue2(newArg.defaultValue, newArg.type);
          if (oldValueStr !== newValueStr) {
            schemaChanges.push({
              type: DangerousChangeType.ARG_DEFAULT_VALUE_CHANGE,
              description: `${oldType.name}.${oldField.name} arg ${oldArg.name} has changed defaultValue from ${oldValueStr} to ${newValueStr}.`
            });
          }
        }
      }
    }
    for (const newArg of argsDiff.added) {
      if (isRequiredArgument(newArg)) {
        schemaChanges.push({
          type: BreakingChangeType.REQUIRED_ARG_ADDED,
          description: `A required arg ${newArg.name} on ${oldType.name}.${oldField.name} was added.`
        });
      } else {
        schemaChanges.push({
          type: DangerousChangeType.OPTIONAL_ARG_ADDED,
          description: `An optional arg ${newArg.name} on ${oldType.name}.${oldField.name} was added.`
        });
      }
    }
    return schemaChanges;
  }
  function isChangeSafeForObjectOrInterfaceField(oldType, newType) {
    if (isListType(oldType)) {
      return (
        // if they're both lists, make sure the underlying types are compatible
        isListType(newType) && isChangeSafeForObjectOrInterfaceField(
          oldType.ofType,
          newType.ofType
        ) || // moving from nullable to non-null of the same underlying type is safe
        isNonNullType(newType) && isChangeSafeForObjectOrInterfaceField(oldType, newType.ofType)
      );
    }
    if (isNonNullType(oldType)) {
      return isNonNullType(newType) && isChangeSafeForObjectOrInterfaceField(oldType.ofType, newType.ofType);
    }
    return (
      // if they're both named types, see if their names are equivalent
      isNamedType(newType) && oldType.name === newType.name || // moving from nullable to non-null of the same underlying type is safe
      isNonNullType(newType) && isChangeSafeForObjectOrInterfaceField(oldType, newType.ofType)
    );
  }
  function isChangeSafeForInputObjectFieldOrFieldArg(oldType, newType) {
    if (isListType(oldType)) {
      return isListType(newType) && isChangeSafeForInputObjectFieldOrFieldArg(oldType.ofType, newType.ofType);
    }
    if (isNonNullType(oldType)) {
      return (
        // if they're both non-null, make sure the underlying types are
        // compatible
        isNonNullType(newType) && isChangeSafeForInputObjectFieldOrFieldArg(
          oldType.ofType,
          newType.ofType
        ) || // moving from non-null to nullable of the same underlying type is safe
        !isNonNullType(newType) && isChangeSafeForInputObjectFieldOrFieldArg(oldType.ofType, newType)
      );
    }
    return isNamedType(newType) && oldType.name === newType.name;
  }
  function typeKindName(type) {
    if (isScalarType(type)) {
      return "a Scalar type";
    }
    if (isObjectType(type)) {
      return "an Object type";
    }
    if (isInterfaceType(type)) {
      return "an Interface type";
    }
    if (isUnionType(type)) {
      return "a Union type";
    }
    if (isEnumType(type)) {
      return "an Enum type";
    }
    if (isInputObjectType(type)) {
      return "an Input type";
    }
    invariant2(false, "Unexpected type: " + inspect(type));
  }
  function stringifyValue2(value, type) {
    const ast = astFromValue(value, type);
    ast != null || invariant2(false);
    return print(sortValueNode(ast));
  }
  function diff(oldArray, newArray) {
    const added = [];
    const removed = [];
    const persisted = [];
    const oldMap = keyMap(oldArray, ({ name }) => name);
    const newMap = keyMap(newArray, ({ name }) => name);
    for (const oldItem of oldArray) {
      const newItem = newMap[oldItem.name];
      if (newItem === void 0) {
        removed.push(oldItem);
      } else {
        persisted.push([oldItem, newItem]);
      }
    }
    for (const newItem of newArray) {
      if (oldMap[newItem.name] === void 0) {
        added.push(newItem);
      }
    }
    return {
      added,
      persisted,
      removed
    };
  }
  var BreakingChangeType, DangerousChangeType;
  var init_findBreakingChanges = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/utilities/findBreakingChanges.mjs"() {
      "use strict";
      init_inspect();
      init_invariant();
      init_keyMap();
      init_printer();
      init_definition();
      init_scalars();
      init_astFromValue();
      init_sortValueNode();
      (function(BreakingChangeType2) {
        BreakingChangeType2["TYPE_REMOVED"] = "TYPE_REMOVED";
        BreakingChangeType2["TYPE_CHANGED_KIND"] = "TYPE_CHANGED_KIND";
        BreakingChangeType2["TYPE_REMOVED_FROM_UNION"] = "TYPE_REMOVED_FROM_UNION";
        BreakingChangeType2["VALUE_REMOVED_FROM_ENUM"] = "VALUE_REMOVED_FROM_ENUM";
        BreakingChangeType2["REQUIRED_INPUT_FIELD_ADDED"] = "REQUIRED_INPUT_FIELD_ADDED";
        BreakingChangeType2["IMPLEMENTED_INTERFACE_REMOVED"] = "IMPLEMENTED_INTERFACE_REMOVED";
        BreakingChangeType2["FIELD_REMOVED"] = "FIELD_REMOVED";
        BreakingChangeType2["FIELD_CHANGED_KIND"] = "FIELD_CHANGED_KIND";
        BreakingChangeType2["REQUIRED_ARG_ADDED"] = "REQUIRED_ARG_ADDED";
        BreakingChangeType2["ARG_REMOVED"] = "ARG_REMOVED";
        BreakingChangeType2["ARG_CHANGED_KIND"] = "ARG_CHANGED_KIND";
        BreakingChangeType2["DIRECTIVE_REMOVED"] = "DIRECTIVE_REMOVED";
        BreakingChangeType2["DIRECTIVE_ARG_REMOVED"] = "DIRECTIVE_ARG_REMOVED";
        BreakingChangeType2["REQUIRED_DIRECTIVE_ARG_ADDED"] = "REQUIRED_DIRECTIVE_ARG_ADDED";
        BreakingChangeType2["DIRECTIVE_REPEATABLE_REMOVED"] = "DIRECTIVE_REPEATABLE_REMOVED";
        BreakingChangeType2["DIRECTIVE_LOCATION_REMOVED"] = "DIRECTIVE_LOCATION_REMOVED";
      })(BreakingChangeType || (BreakingChangeType = {}));
      (function(DangerousChangeType2) {
        DangerousChangeType2["VALUE_ADDED_TO_ENUM"] = "VALUE_ADDED_TO_ENUM";
        DangerousChangeType2["TYPE_ADDED_TO_UNION"] = "TYPE_ADDED_TO_UNION";
        DangerousChangeType2["OPTIONAL_INPUT_FIELD_ADDED"] = "OPTIONAL_INPUT_FIELD_ADDED";
        DangerousChangeType2["OPTIONAL_ARG_ADDED"] = "OPTIONAL_ARG_ADDED";
        DangerousChangeType2["IMPLEMENTED_INTERFACE_ADDED"] = "IMPLEMENTED_INTERFACE_ADDED";
        DangerousChangeType2["ARG_DEFAULT_VALUE_CHANGE"] = "ARG_DEFAULT_VALUE_CHANGE";
      })(DangerousChangeType || (DangerousChangeType = {}));
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/utilities/index.mjs
  var init_utilities = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/utilities/index.mjs"() {
      "use strict";
      init_getIntrospectionQuery();
      init_getOperationAST();
      init_getOperationRootType();
      init_introspectionFromSchema();
      init_buildClientSchema();
      init_buildASTSchema();
      init_extendSchema();
      init_lexicographicSortSchema();
      init_printSchema();
      init_typeFromAST();
      init_valueFromAST();
      init_valueFromASTUntyped();
      init_astFromValue();
      init_TypeInfo();
      init_coerceInputValue();
      init_concatAST();
      init_separateOperations();
      init_stripIgnoredCharacters();
      init_typeComparators();
      init_assertValidName();
      init_findBreakingChanges();
    }
  });

  // node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/index.mjs
  var graphql_exports = {};
  __export(graphql_exports, {
    BREAK: () => BREAK,
    BreakingChangeType: () => BreakingChangeType,
    DEFAULT_DEPRECATION_REASON: () => DEFAULT_DEPRECATION_REASON,
    DangerousChangeType: () => DangerousChangeType,
    DirectiveLocation: () => DirectiveLocation,
    ExecutableDefinitionsRule: () => ExecutableDefinitionsRule,
    FieldsOnCorrectTypeRule: () => FieldsOnCorrectTypeRule,
    FragmentsOnCompositeTypesRule: () => FragmentsOnCompositeTypesRule,
    GRAPHQL_MAX_INT: () => GRAPHQL_MAX_INT,
    GRAPHQL_MIN_INT: () => GRAPHQL_MIN_INT,
    GraphQLBoolean: () => GraphQLBoolean,
    GraphQLDeprecatedDirective: () => GraphQLDeprecatedDirective,
    GraphQLDirective: () => GraphQLDirective,
    GraphQLEnumType: () => GraphQLEnumType,
    GraphQLError: () => GraphQLError,
    GraphQLFloat: () => GraphQLFloat,
    GraphQLID: () => GraphQLID,
    GraphQLIncludeDirective: () => GraphQLIncludeDirective,
    GraphQLInputObjectType: () => GraphQLInputObjectType,
    GraphQLInt: () => GraphQLInt,
    GraphQLInterfaceType: () => GraphQLInterfaceType,
    GraphQLList: () => GraphQLList,
    GraphQLNonNull: () => GraphQLNonNull,
    GraphQLObjectType: () => GraphQLObjectType,
    GraphQLScalarType: () => GraphQLScalarType,
    GraphQLSchema: () => GraphQLSchema,
    GraphQLSkipDirective: () => GraphQLSkipDirective,
    GraphQLSpecifiedByDirective: () => GraphQLSpecifiedByDirective,
    GraphQLString: () => GraphQLString,
    GraphQLUnionType: () => GraphQLUnionType,
    Kind: () => Kind,
    KnownArgumentNamesRule: () => KnownArgumentNamesRule,
    KnownDirectivesRule: () => KnownDirectivesRule,
    KnownFragmentNamesRule: () => KnownFragmentNamesRule,
    KnownTypeNamesRule: () => KnownTypeNamesRule,
    Lexer: () => Lexer,
    Location: () => Location,
    LoneAnonymousOperationRule: () => LoneAnonymousOperationRule,
    LoneSchemaDefinitionRule: () => LoneSchemaDefinitionRule,
    NoDeprecatedCustomRule: () => NoDeprecatedCustomRule,
    NoFragmentCyclesRule: () => NoFragmentCyclesRule,
    NoSchemaIntrospectionCustomRule: () => NoSchemaIntrospectionCustomRule,
    NoUndefinedVariablesRule: () => NoUndefinedVariablesRule,
    NoUnusedFragmentsRule: () => NoUnusedFragmentsRule,
    NoUnusedVariablesRule: () => NoUnusedVariablesRule,
    OperationTypeNode: () => OperationTypeNode,
    OverlappingFieldsCanBeMergedRule: () => OverlappingFieldsCanBeMergedRule,
    PossibleFragmentSpreadsRule: () => PossibleFragmentSpreadsRule,
    PossibleTypeExtensionsRule: () => PossibleTypeExtensionsRule,
    ProvidedRequiredArgumentsRule: () => ProvidedRequiredArgumentsRule,
    ScalarLeafsRule: () => ScalarLeafsRule,
    SchemaMetaFieldDef: () => SchemaMetaFieldDef,
    SingleFieldSubscriptionsRule: () => SingleFieldSubscriptionsRule,
    Source: () => Source,
    Token: () => Token,
    TokenKind: () => TokenKind,
    TypeInfo: () => TypeInfo,
    TypeKind: () => TypeKind,
    TypeMetaFieldDef: () => TypeMetaFieldDef,
    TypeNameMetaFieldDef: () => TypeNameMetaFieldDef,
    UniqueArgumentDefinitionNamesRule: () => UniqueArgumentDefinitionNamesRule,
    UniqueArgumentNamesRule: () => UniqueArgumentNamesRule,
    UniqueDirectiveNamesRule: () => UniqueDirectiveNamesRule,
    UniqueDirectivesPerLocationRule: () => UniqueDirectivesPerLocationRule,
    UniqueEnumValueNamesRule: () => UniqueEnumValueNamesRule,
    UniqueFieldDefinitionNamesRule: () => UniqueFieldDefinitionNamesRule,
    UniqueFragmentNamesRule: () => UniqueFragmentNamesRule,
    UniqueInputFieldNamesRule: () => UniqueInputFieldNamesRule,
    UniqueOperationNamesRule: () => UniqueOperationNamesRule,
    UniqueOperationTypesRule: () => UniqueOperationTypesRule,
    UniqueTypeNamesRule: () => UniqueTypeNamesRule,
    UniqueVariableNamesRule: () => UniqueVariableNamesRule,
    ValidationContext: () => ValidationContext,
    ValuesOfCorrectTypeRule: () => ValuesOfCorrectTypeRule,
    VariablesAreInputTypesRule: () => VariablesAreInputTypesRule,
    VariablesInAllowedPositionRule: () => VariablesInAllowedPositionRule,
    __Directive: () => __Directive,
    __DirectiveLocation: () => __DirectiveLocation,
    __EnumValue: () => __EnumValue,
    __Field: () => __Field,
    __InputValue: () => __InputValue,
    __Schema: () => __Schema,
    __Type: () => __Type,
    __TypeKind: () => __TypeKind,
    assertAbstractType: () => assertAbstractType,
    assertCompositeType: () => assertCompositeType,
    assertDirective: () => assertDirective,
    assertEnumType: () => assertEnumType,
    assertEnumValueName: () => assertEnumValueName,
    assertInputObjectType: () => assertInputObjectType,
    assertInputType: () => assertInputType,
    assertInterfaceType: () => assertInterfaceType,
    assertLeafType: () => assertLeafType,
    assertListType: () => assertListType,
    assertName: () => assertName,
    assertNamedType: () => assertNamedType,
    assertNonNullType: () => assertNonNullType,
    assertNullableType: () => assertNullableType,
    assertObjectType: () => assertObjectType,
    assertOutputType: () => assertOutputType,
    assertScalarType: () => assertScalarType,
    assertSchema: () => assertSchema,
    assertType: () => assertType,
    assertUnionType: () => assertUnionType,
    assertValidName: () => assertValidName,
    assertValidSchema: () => assertValidSchema,
    assertWrappingType: () => assertWrappingType,
    astFromValue: () => astFromValue,
    buildASTSchema: () => buildASTSchema,
    buildClientSchema: () => buildClientSchema,
    buildSchema: () => buildSchema,
    coerceInputValue: () => coerceInputValue,
    concatAST: () => concatAST,
    createSourceEventStream: () => createSourceEventStream,
    defaultFieldResolver: () => defaultFieldResolver,
    defaultTypeResolver: () => defaultTypeResolver,
    doTypesOverlap: () => doTypesOverlap,
    execute: () => execute,
    executeSync: () => executeSync,
    extendSchema: () => extendSchema,
    findBreakingChanges: () => findBreakingChanges,
    findDangerousChanges: () => findDangerousChanges,
    formatError: () => formatError,
    getArgumentValues: () => getArgumentValues,
    getDirectiveValues: () => getDirectiveValues,
    getEnterLeaveForKind: () => getEnterLeaveForKind,
    getIntrospectionQuery: () => getIntrospectionQuery,
    getLocation: () => getLocation,
    getNamedType: () => getNamedType,
    getNullableType: () => getNullableType,
    getOperationAST: () => getOperationAST,
    getOperationRootType: () => getOperationRootType,
    getVariableValues: () => getVariableValues,
    getVisitFn: () => getVisitFn,
    graphql: () => graphql,
    graphqlSync: () => graphqlSync,
    introspectionFromSchema: () => introspectionFromSchema,
    introspectionTypes: () => introspectionTypes,
    isAbstractType: () => isAbstractType,
    isCompositeType: () => isCompositeType,
    isConstValueNode: () => isConstValueNode,
    isDefinitionNode: () => isDefinitionNode,
    isDirective: () => isDirective,
    isEnumType: () => isEnumType,
    isEqualType: () => isEqualType,
    isExecutableDefinitionNode: () => isExecutableDefinitionNode,
    isInputObjectType: () => isInputObjectType,
    isInputType: () => isInputType,
    isInterfaceType: () => isInterfaceType,
    isIntrospectionType: () => isIntrospectionType,
    isLeafType: () => isLeafType,
    isListType: () => isListType,
    isNamedType: () => isNamedType,
    isNonNullType: () => isNonNullType,
    isNullableType: () => isNullableType,
    isObjectType: () => isObjectType,
    isOutputType: () => isOutputType,
    isRequiredArgument: () => isRequiredArgument,
    isRequiredInputField: () => isRequiredInputField,
    isScalarType: () => isScalarType,
    isSchema: () => isSchema,
    isSelectionNode: () => isSelectionNode,
    isSpecifiedDirective: () => isSpecifiedDirective,
    isSpecifiedScalarType: () => isSpecifiedScalarType,
    isType: () => isType,
    isTypeDefinitionNode: () => isTypeDefinitionNode,
    isTypeExtensionNode: () => isTypeExtensionNode,
    isTypeNode: () => isTypeNode,
    isTypeSubTypeOf: () => isTypeSubTypeOf,
    isTypeSystemDefinitionNode: () => isTypeSystemDefinitionNode,
    isTypeSystemExtensionNode: () => isTypeSystemExtensionNode,
    isUnionType: () => isUnionType,
    isValidNameError: () => isValidNameError,
    isValueNode: () => isValueNode,
    isWrappingType: () => isWrappingType,
    lexicographicSortSchema: () => lexicographicSortSchema,
    locatedError: () => locatedError,
    parse: () => parse2,
    parseConstValue: () => parseConstValue,
    parseType: () => parseType,
    parseValue: () => parseValue,
    print: () => print,
    printError: () => printError,
    printIntrospectionSchema: () => printIntrospectionSchema,
    printLocation: () => printLocation,
    printSchema: () => printSchema,
    printSourceLocation: () => printSourceLocation,
    printType: () => printType,
    resolveObjMapThunk: () => resolveObjMapThunk,
    resolveReadonlyArrayThunk: () => resolveReadonlyArrayThunk,
    responsePathAsArray: () => pathToArray,
    separateOperations: () => separateOperations,
    specifiedDirectives: () => specifiedDirectives,
    specifiedRules: () => specifiedRules,
    specifiedScalarTypes: () => specifiedScalarTypes,
    stripIgnoredCharacters: () => stripIgnoredCharacters,
    subscribe: () => subscribe,
    syntaxError: () => syntaxError,
    typeFromAST: () => typeFromAST,
    validate: () => validate,
    validateSchema: () => validateSchema,
    valueFromAST: () => valueFromAST,
    valueFromASTUntyped: () => valueFromASTUntyped,
    version: () => version,
    versionInfo: () => versionInfo,
    visit: () => visit,
    visitInParallel: () => visitInParallel,
    visitWithTypeInfo: () => visitWithTypeInfo
  });
  var init_graphql2 = __esm({
    "node_modules/.pnpm/graphql@16.8.2/node_modules/graphql/index.mjs"() {
      "use strict";
      init_version();
      init_graphql();
      init_type();
      init_language();
      init_execution();
      init_validation();
      init_error();
      init_utilities();
    }
  });

  // src/iife/index.ts
  var iife_exports = {};
  __export(iife_exports, {
    GraphQLHandler: () => GraphQLHandler,
    HttpHandler: () => HttpHandler,
    HttpMethods: () => HttpMethods,
    HttpResponse: () => HttpResponse,
    MAX_SERVER_RESPONSE_TIME: () => MAX_SERVER_RESPONSE_TIME,
    MIN_SERVER_RESPONSE_TIME: () => MIN_SERVER_RESPONSE_TIME,
    NODE_SERVER_RESPONSE_TIME: () => NODE_SERVER_RESPONSE_TIME,
    RequestHandler: () => RequestHandler,
    SET_TIMEOUT_MAX_ALLOWED_INT: () => SET_TIMEOUT_MAX_ALLOWED_INT,
    SetupApi: () => SetupApi,
    SetupWorkerApi: () => SetupWorkerApi,
    WebSocketHandler: () => WebSocketHandler,
    bypass: () => bypass,
    cleanUrl: () => cleanUrl,
    delay: () => delay,
    getResponse: () => getResponse,
    graphql: () => graphql2,
    handleRequest: () => handleRequest,
    http: () => http,
    isCommonAssetRequest: () => isCommonAssetRequest,
    matchRequestUrl: () => matchRequestUrl,
    passthrough: () => passthrough,
    setupWorker: () => setupWorker,
    ws: () => ws
  });

  // node_modules/.pnpm/outvariant@1.4.3/node_modules/outvariant/lib/index.mjs
  var POSITIONALS_EXP = /(%?)(%([sdijo]))/g;
  function serializePositional(positional, flag) {
    switch (flag) {
      case "s":
        return positional;
      case "d":
      case "i":
        return Number(positional);
      case "j":
        return JSON.stringify(positional);
      case "o": {
        if (typeof positional === "string") {
          return positional;
        }
        const json = JSON.stringify(positional);
        if (json === "{}" || json === "[]" || /^\[object .+?\]$/.test(json)) {
          return positional;
        }
        return json;
      }
    }
  }
  function format(message3, ...positionals) {
    if (positionals.length === 0) {
      return message3;
    }
    let positionalIndex = 0;
    let formattedMessage = message3.replace(
      POSITIONALS_EXP,
      (match2, isEscaped, _, flag) => {
        const positional = positionals[positionalIndex];
        const value = serializePositional(positional, flag);
        if (!isEscaped) {
          positionalIndex++;
          return value;
        }
        return match2;
      }
    );
    if (positionalIndex < positionals.length) {
      formattedMessage += ` ${positionals.slice(positionalIndex).join(" ")}`;
    }
    formattedMessage = formattedMessage.replace(/%{2,2}/g, "%");
    return formattedMessage;
  }
  var STACK_FRAMES_TO_IGNORE = 2;
  function cleanErrorStack(error3) {
    if (!error3.stack) {
      return;
    }
    const nextStack = error3.stack.split("\n");
    nextStack.splice(1, STACK_FRAMES_TO_IGNORE);
    error3.stack = nextStack.join("\n");
  }
  var InvariantError = class extends Error {
    constructor(message3, ...positionals) {
      super(message3);
      this.message = message3;
      this.name = "Invariant Violation";
      this.message = format(message3, ...positionals);
      cleanErrorStack(this);
    }
  };
  var invariant = (predicate, message3, ...positionals) => {
    if (!predicate) {
      throw new InvariantError(message3, ...positionals);
    }
  };
  invariant.as = (ErrorConstructor, predicate, message3, ...positionals) => {
    if (!predicate) {
      const formatMessage2 = positionals.length === 0 ? message3 : format(message3, ...positionals);
      let error3;
      try {
        error3 = Reflect.construct(ErrorConstructor, [
          formatMessage2
        ]);
      } catch (err) {
        error3 = ErrorConstructor(formatMessage2);
      }
      throw error3;
    }
  };

  // src/core/utils/internal/devUtils.ts
  var LIBRARY_PREFIX = "[MSW]";
  function formatMessage(message3, ...positionals) {
    const interpolatedMessage = format(message3, ...positionals);
    return `${LIBRARY_PREFIX} ${interpolatedMessage}`;
  }
  function warn(message3, ...positionals) {
    console.warn(formatMessage(message3, ...positionals));
  }
  function error(message3, ...positionals) {
    console.error(formatMessage(message3, ...positionals));
  }
  var devUtils = {
    formatMessage,
    warn,
    error
  };
  var InternalError = class extends Error {
    constructor(message3) {
      super(message3);
      this.name = "InternalError";
    }
  };

  // src/core/utils/internal/checkGlobals.ts
  function checkGlobals() {
    invariant(
      typeof URL !== "undefined",
      devUtils.formatMessage(
        `Global "URL" class is not defined. This likely means that you're running MSW in an environment that doesn't support all Node.js standard API (e.g. React Native). If that's the case, please use an appropriate polyfill for the "URL" class, like "react-native-url-polyfill".`
      )
    );
  }

  // node_modules/.pnpm/strict-event-emitter@0.5.1/node_modules/strict-event-emitter/lib/index.mjs
  var MemoryLeakError = class extends Error {
    constructor(emitter, type, count) {
      super(
        `Possible EventEmitter memory leak detected. ${count} ${type.toString()} listeners added. Use emitter.setMaxListeners() to increase limit`
      );
      this.emitter = emitter;
      this.type = type;
      this.count = count;
      this.name = "MaxListenersExceededWarning";
    }
  };
  var _Emitter = class {
    static listenerCount(emitter, eventName) {
      return emitter.listenerCount(eventName);
    }
    constructor() {
      this.events = /* @__PURE__ */ new Map();
      this.maxListeners = _Emitter.defaultMaxListeners;
      this.hasWarnedAboutPotentialMemoryLeak = false;
    }
    _emitInternalEvent(internalEventName, eventName, listener) {
      this.emit(
        internalEventName,
        ...[eventName, listener]
      );
    }
    _getListeners(eventName) {
      return Array.prototype.concat.apply([], this.events.get(eventName)) || [];
    }
    _removeListener(listeners, listener) {
      const index = listeners.indexOf(listener);
      if (index > -1) {
        listeners.splice(index, 1);
      }
      return [];
    }
    _wrapOnceListener(eventName, listener) {
      const onceListener = (...data) => {
        this.removeListener(eventName, onceListener);
        return listener.apply(this, data);
      };
      Object.defineProperty(onceListener, "name", { value: listener.name });
      return onceListener;
    }
    setMaxListeners(maxListeners) {
      this.maxListeners = maxListeners;
      return this;
    }
    /**
     * Returns the current max listener value for the `Emitter` which is
     * either set by `emitter.setMaxListeners(n)` or defaults to
     * `Emitter.defaultMaxListeners`.
     */
    getMaxListeners() {
      return this.maxListeners;
    }
    /**
     * Returns an array listing the events for which the emitter has registered listeners.
     * The values in the array will be strings or Symbols.
     */
    eventNames() {
      return Array.from(this.events.keys());
    }
    /**
     * Synchronously calls each of the listeners registered for the event named `eventName`,
     * in the order they were registered, passing the supplied arguments to each.
     * Returns `true` if the event has listeners, `false` otherwise.
     *
     * @example
     * const emitter = new Emitter<{ hello: [string] }>()
     * emitter.emit('hello', 'John')
     */
    emit(eventName, ...data) {
      const listeners = this._getListeners(eventName);
      listeners.forEach((listener) => {
        listener.apply(this, data);
      });
      return listeners.length > 0;
    }
    addListener(eventName, listener) {
      this._emitInternalEvent("newListener", eventName, listener);
      const nextListeners = this._getListeners(eventName).concat(listener);
      this.events.set(eventName, nextListeners);
      if (this.maxListeners > 0 && this.listenerCount(eventName) > this.maxListeners && !this.hasWarnedAboutPotentialMemoryLeak) {
        this.hasWarnedAboutPotentialMemoryLeak = true;
        const memoryLeakWarning = new MemoryLeakError(
          this,
          eventName,
          this.listenerCount(eventName)
        );
        console.warn(memoryLeakWarning);
      }
      return this;
    }
    on(eventName, listener) {
      return this.addListener(eventName, listener);
    }
    once(eventName, listener) {
      return this.addListener(
        eventName,
        this._wrapOnceListener(eventName, listener)
      );
    }
    prependListener(eventName, listener) {
      const listeners = this._getListeners(eventName);
      if (listeners.length > 0) {
        const nextListeners = [listener].concat(listeners);
        this.events.set(eventName, nextListeners);
      } else {
        this.events.set(eventName, listeners.concat(listener));
      }
      return this;
    }
    prependOnceListener(eventName, listener) {
      return this.prependListener(
        eventName,
        this._wrapOnceListener(eventName, listener)
      );
    }
    removeListener(eventName, listener) {
      const listeners = this._getListeners(eventName);
      if (listeners.length > 0) {
        this._removeListener(listeners, listener);
        this.events.set(eventName, listeners);
        this._emitInternalEvent("removeListener", eventName, listener);
      }
      return this;
    }
    /**
     * Alias for `emitter.removeListener()`.
     *
     * @example
     * emitter.off('hello', listener)
     */
    off(eventName, listener) {
      return this.removeListener(eventName, listener);
    }
    removeAllListeners(eventName) {
      if (eventName) {
        this.events.delete(eventName);
      } else {
        this.events.clear();
      }
      return this;
    }
    /**
     * Returns a copy of the array of listeners for the event named `eventName`.
     */
    listeners(eventName) {
      return Array.from(this._getListeners(eventName));
    }
    /**
     * Returns the number of listeners listening to the event named `eventName`.
     */
    listenerCount(eventName) {
      return this._getListeners(eventName).length;
    }
    rawListeners(eventName) {
      return this.listeners(eventName);
    }
  };
  var Emitter = _Emitter;
  Emitter.defaultMaxListeners = 10;

  // src/core/utils/internal/pipeEvents.ts
  function pipeEvents(source, destination) {
    const rawEmit = source.emit;
    if (rawEmit._isPiped) {
      return;
    }
    const sourceEmit = function sourceEmit2(event, ...data) {
      destination.emit(event, ...data);
      return rawEmit.call(this, event, ...data);
    };
    sourceEmit._isPiped = true;
    source.emit = sourceEmit;
  }

  // src/core/utils/internal/toReadonlyArray.ts
  function toReadonlyArray(source) {
    const clone = [...source];
    Object.freeze(clone);
    return clone;
  }

  // src/core/utils/internal/Disposable.ts
  var Disposable = class {
    subscriptions = [];
    dispose() {
      let subscription;
      while (subscription = this.subscriptions.shift()) {
        subscription();
      }
    }
  };

  // src/core/SetupApi.ts
  var InMemoryHandlersController = class {
    constructor(initialHandlers) {
      this.initialHandlers = initialHandlers;
      this.handlers = [...initialHandlers];
    }
    handlers;
    prepend(runtimeHandles) {
      this.handlers.unshift(...runtimeHandles);
    }
    reset(nextHandlers) {
      this.handlers = nextHandlers.length > 0 ? [...nextHandlers] : [...this.initialHandlers];
    }
    currentHandlers() {
      return this.handlers;
    }
  };
  var SetupApi = class extends Disposable {
    handlersController;
    emitter;
    publicEmitter;
    events;
    constructor(...initialHandlers) {
      super();
      invariant(
        this.validateHandlers(initialHandlers),
        devUtils.formatMessage(
          `Failed to apply given request handlers: invalid input. Did you forget to spread the request handlers Array?`
        )
      );
      this.handlersController = new InMemoryHandlersController(initialHandlers);
      this.emitter = new Emitter();
      this.publicEmitter = new Emitter();
      pipeEvents(this.emitter, this.publicEmitter);
      this.events = this.createLifeCycleEvents();
      this.subscriptions.push(() => {
        this.emitter.removeAllListeners();
        this.publicEmitter.removeAllListeners();
      });
    }
    validateHandlers(handlers) {
      return handlers.every((handler) => !Array.isArray(handler));
    }
    use(...runtimeHandlers) {
      invariant(
        this.validateHandlers(runtimeHandlers),
        devUtils.formatMessage(
          `Failed to call "use()" with the given request handlers: invalid input. Did you forget to spread the array of request handlers?`
        )
      );
      this.handlersController.prepend(runtimeHandlers);
    }
    restoreHandlers() {
      this.handlersController.currentHandlers().forEach((handler) => {
        if ("isUsed" in handler) {
          handler.isUsed = false;
        }
      });
    }
    resetHandlers(...nextHandlers) {
      this.handlersController.reset(nextHandlers);
    }
    listHandlers() {
      return toReadonlyArray(this.handlersController.currentHandlers());
    }
    createLifeCycleEvents() {
      return {
        on: (...args) => {
          return this.publicEmitter.on(...args);
        },
        removeListener: (...args) => {
          return this.publicEmitter.removeListener(...args);
        },
        removeAllListeners: (...args) => {
          return this.publicEmitter.removeAllListeners(...args);
        }
      };
    }
  };

  // src/core/utils/internal/getCallFrame.ts
  var SOURCE_FRAME = /[\/\\]msw[\/\\]src[\/\\](.+)/;
  var BUILD_FRAME = /(node_modules)?[\/\\]lib[\/\\](core|browser|node|native|iife)[\/\\]|^[^\/\\]*$/;
  function getCallFrame(error3) {
    const stack = error3.stack;
    if (!stack) {
      return;
    }
    const frames = stack.split("\n").slice(1);
    const declarationFrame = frames.find((frame) => {
      return !(SOURCE_FRAME.test(frame) || BUILD_FRAME.test(frame));
    });
    if (!declarationFrame) {
      return;
    }
    const declarationPath = declarationFrame.replace(/\s*at [^()]*\(([^)]+)\)/, "$1").replace(/^@/, "");
    return declarationPath;
  }

  // src/core/utils/internal/isIterable.ts
  function isIterable(fn) {
    if (!fn) {
      return false;
    }
    return Reflect.has(fn, Symbol.iterator) || Reflect.has(fn, Symbol.asyncIterator);
  }

  // src/core/handlers/RequestHandler.ts
  var RequestHandler = class _RequestHandler {
    static cache = /* @__PURE__ */ new WeakMap();
    __kind;
    info;
    /**
     * Indicates whether this request handler has been used
     * (its resolver has successfully executed).
     */
    isUsed;
    resolver;
    resolverIterator;
    resolverIteratorResult;
    options;
    constructor(args) {
      this.resolver = args.resolver;
      this.options = args.options;
      const callFrame = getCallFrame(new Error());
      this.info = {
        ...args.info,
        callFrame
      };
      this.isUsed = false;
      this.__kind = "RequestHandler";
    }
    /**
     * Parse the intercepted request to extract additional information from it.
     * Parsed result is then exposed to other methods of this request handler.
     */
    async parse(_args) {
      return {};
    }
    /**
     * Test if this handler matches the given request.
     *
     * This method is not used internally but is exposed
     * as a convenience method for consumers writing custom
     * handlers.
     */
    async test(args) {
      const parsedResult = await this.parse({
        request: args.request,
        resolutionContext: args.resolutionContext
      });
      return this.predicate({
        request: args.request,
        parsedResult,
        resolutionContext: args.resolutionContext
      });
    }
    extendResolverArgs(_args) {
      return {};
    }
    // Clone the request instance before it's passed to the handler phases
    // and the response resolver so we can always read it for logging.
    // We only clone it once per request to avoid unnecessary overhead.
    cloneRequestOrGetFromCache(request) {
      const existingClone = _RequestHandler.cache.get(request);
      if (typeof existingClone !== "undefined") {
        return existingClone;
      }
      const clonedRequest = request.clone();
      _RequestHandler.cache.set(request, clonedRequest);
      return clonedRequest;
    }
    /**
     * Execute this request handler and produce a mocked response
     * using the given resolver function.
     */
    async run(args) {
      if (this.isUsed && this.options?.once) {
        return null;
      }
      const requestClone = this.cloneRequestOrGetFromCache(args.request);
      const parsedResult = await this.parse({
        request: args.request,
        resolutionContext: args.resolutionContext
      });
      const shouldInterceptRequest = this.predicate({
        request: args.request,
        parsedResult,
        resolutionContext: args.resolutionContext
      });
      if (!shouldInterceptRequest) {
        return null;
      }
      if (this.isUsed && this.options?.once) {
        return null;
      }
      this.isUsed = true;
      const executeResolver = this.wrapResolver(this.resolver);
      const resolverExtras = this.extendResolverArgs({
        request: args.request,
        parsedResult
      });
      const mockedResponsePromise = executeResolver({
        ...resolverExtras,
        requestId: args.requestId,
        request: args.request
      }).catch((errorOrResponse) => {
        if (errorOrResponse instanceof Response) {
          return errorOrResponse;
        }
        throw errorOrResponse;
      });
      const mockedResponse = await mockedResponsePromise;
      const executionResult = this.createExecutionResult({
        // Pass the cloned request to the result so that logging
        // and other consumers could read its body once more.
        request: requestClone,
        requestId: args.requestId,
        response: mockedResponse,
        parsedResult
      });
      return executionResult;
    }
    wrapResolver(resolver) {
      return async (info) => {
        if (!this.resolverIterator) {
          const result = await resolver(info);
          if (!isIterable(result)) {
            return result;
          }
          this.resolverIterator = Symbol.iterator in result ? result[Symbol.iterator]() : result[Symbol.asyncIterator]();
        }
        this.isUsed = false;
        const { done, value } = await this.resolverIterator.next();
        const nextResponse = await value;
        if (nextResponse) {
          this.resolverIteratorResult = nextResponse.clone();
        }
        if (done) {
          this.isUsed = true;
          return this.resolverIteratorResult?.clone();
        }
        return nextResponse;
      };
    }
    createExecutionResult(args) {
      return {
        handler: this,
        request: args.request,
        requestId: args.requestId,
        response: args.response,
        parsedResult: args.parsedResult
      };
    }
  };

  // src/core/utils/internal/isStringEqual.ts
  function isStringEqual(actual, expected) {
    return actual.toLowerCase() === expected.toLowerCase();
  }

  // src/core/utils/logging/getStatusCodeColor.ts
  function getStatusCodeColor(status) {
    if (status < 300) {
      return "#69AB32" /* Success */;
    }
    if (status < 400) {
      return "#F0BB4B" /* Warning */;
    }
    return "#E95F5D" /* Danger */;
  }

  // src/core/utils/logging/getTimestamp.ts
  function getTimestamp(options) {
    const now = /* @__PURE__ */ new Date();
    const timestamp = `${now.getHours().toString().padStart(2, "0")}:${now.getMinutes().toString().padStart(2, "0")}:${now.getSeconds().toString().padStart(2, "0")}`;
    if (options?.milliseconds) {
      return `${timestamp}.${now.getMilliseconds().toString().padStart(3, "0")}`;
    }
    return timestamp;
  }

  // src/core/utils/logging/serializeRequest.ts
  async function serializeRequest(request) {
    const requestClone = request.clone();
    const requestText = await requestClone.text();
    return {
      url: new URL(request.url),
      method: request.method,
      headers: Object.fromEntries(request.headers.entries()),
      body: requestText
    };
  }

  // node_modules/.pnpm/@bundled-es-modules+statuses@1.0.1/node_modules/@bundled-es-modules/statuses/index-esm.js
  var __create = Object.create;
  var __defProp2 = Object.defineProperty;
  var __getOwnPropDesc2 = Object.getOwnPropertyDescriptor;
  var __getOwnPropNames2 = Object.getOwnPropertyNames;
  var __getProtoOf = Object.getPrototypeOf;
  var __hasOwnProp2 = Object.prototype.hasOwnProperty;
  var __commonJS = (cb, mod) => function __require3() {
    return mod || (0, cb[__getOwnPropNames2(cb)[0]])((mod = { exports: {} }).exports, mod), mod.exports;
  };
  var __copyProps2 = (to, from, except, desc) => {
    if (from && typeof from === "object" || typeof from === "function") {
      for (let key of __getOwnPropNames2(from))
        if (!__hasOwnProp2.call(to, key) && key !== except)
          __defProp2(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc2(from, key)) || desc.enumerable });
    }
    return to;
  };
  var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps2(
    // If the importer is in node compatibility mode or this is not an ESM
    // file that has been converted to a CommonJS file using a Babel-
    // compatible transform (i.e. "__esModule" has not been set), then set
    // "default" to the CommonJS "module.exports" for node compatibility.
    isNodeMode || !mod || !mod.__esModule ? __defProp2(target, "default", { value: mod, enumerable: true }) : target,
    mod
  ));
  var require_codes = __commonJS({
    "node_modules/statuses/codes.json"(exports, module) {
      module.exports = {
        "100": "Continue",
        "101": "Switching Protocols",
        "102": "Processing",
        "103": "Early Hints",
        "200": "OK",
        "201": "Created",
        "202": "Accepted",
        "203": "Non-Authoritative Information",
        "204": "No Content",
        "205": "Reset Content",
        "206": "Partial Content",
        "207": "Multi-Status",
        "208": "Already Reported",
        "226": "IM Used",
        "300": "Multiple Choices",
        "301": "Moved Permanently",
        "302": "Found",
        "303": "See Other",
        "304": "Not Modified",
        "305": "Use Proxy",
        "307": "Temporary Redirect",
        "308": "Permanent Redirect",
        "400": "Bad Request",
        "401": "Unauthorized",
        "402": "Payment Required",
        "403": "Forbidden",
        "404": "Not Found",
        "405": "Method Not Allowed",
        "406": "Not Acceptable",
        "407": "Proxy Authentication Required",
        "408": "Request Timeout",
        "409": "Conflict",
        "410": "Gone",
        "411": "Length Required",
        "412": "Precondition Failed",
        "413": "Payload Too Large",
        "414": "URI Too Long",
        "415": "Unsupported Media Type",
        "416": "Range Not Satisfiable",
        "417": "Expectation Failed",
        "418": "I'm a Teapot",
        "421": "Misdirected Request",
        "422": "Unprocessable Entity",
        "423": "Locked",
        "424": "Failed Dependency",
        "425": "Too Early",
        "426": "Upgrade Required",
        "428": "Precondition Required",
        "429": "Too Many Requests",
        "431": "Request Header Fields Too Large",
        "451": "Unavailable For Legal Reasons",
        "500": "Internal Server Error",
        "501": "Not Implemented",
        "502": "Bad Gateway",
        "503": "Service Unavailable",
        "504": "Gateway Timeout",
        "505": "HTTP Version Not Supported",
        "506": "Variant Also Negotiates",
        "507": "Insufficient Storage",
        "508": "Loop Detected",
        "509": "Bandwidth Limit Exceeded",
        "510": "Not Extended",
        "511": "Network Authentication Required"
      };
    }
  });
  var require_statuses = __commonJS({
    "node_modules/statuses/index.js"(exports, module) {
      "use strict";
      var codes = require_codes();
      module.exports = status2;
      status2.message = codes;
      status2.code = createMessageToStatusCodeMap(codes);
      status2.codes = createStatusCodeList(codes);
      status2.redirect = {
        300: true,
        301: true,
        302: true,
        303: true,
        305: true,
        307: true,
        308: true
      };
      status2.empty = {
        204: true,
        205: true,
        304: true
      };
      status2.retry = {
        502: true,
        503: true,
        504: true
      };
      function createMessageToStatusCodeMap(codes2) {
        var map = {};
        Object.keys(codes2).forEach(function forEachCode(code) {
          var message3 = codes2[code];
          var status3 = Number(code);
          map[message3.toLowerCase()] = status3;
        });
        return map;
      }
      function createStatusCodeList(codes2) {
        return Object.keys(codes2).map(function mapCode(code) {
          return Number(code);
        });
      }
      function getStatusCode(message3) {
        var msg = message3.toLowerCase();
        if (!Object.prototype.hasOwnProperty.call(status2.code, msg)) {
          throw new Error('invalid status message: "' + message3 + '"');
        }
        return status2.code[msg];
      }
      function getStatusMessage(code) {
        if (!Object.prototype.hasOwnProperty.call(status2.message, code)) {
          throw new Error("invalid status code: " + code);
        }
        return status2.message[code];
      }
      function status2(code) {
        if (typeof code === "number") {
          return getStatusMessage(code);
        }
        if (typeof code !== "string") {
          throw new TypeError("code must be a number or string");
        }
        var n = parseInt(code, 10);
        if (!isNaN(n)) {
          return getStatusMessage(n);
        }
        return getStatusCode(code);
      }
    }
  });
  var import_statuses = __toESM(require_statuses(), 1);
  var source_default = import_statuses.default;

  // src/core/utils/logging/serializeResponse.ts
  var { message } = source_default;
  async function serializeResponse(response) {
    const responseClone = response.clone();
    const responseText = await responseClone.text();
    const responseStatus = responseClone.status || 200;
    const responseStatusText = responseClone.statusText || message[responseStatus] || "OK";
    return {
      status: responseStatus,
      statusText: responseStatusText,
      headers: Object.fromEntries(responseClone.headers.entries()),
      body: responseText
    };
  }

  // node_modules/.pnpm/path-to-regexp@6.3.0/node_modules/path-to-regexp/dist.es2015/index.js
  function lexer(str) {
    var tokens = [];
    var i = 0;
    while (i < str.length) {
      var char = str[i];
      if (char === "*" || char === "+" || char === "?") {
        tokens.push({ type: "MODIFIER", index: i, value: str[i++] });
        continue;
      }
      if (char === "\\") {
        tokens.push({ type: "ESCAPED_CHAR", index: i++, value: str[i++] });
        continue;
      }
      if (char === "{") {
        tokens.push({ type: "OPEN", index: i, value: str[i++] });
        continue;
      }
      if (char === "}") {
        tokens.push({ type: "CLOSE", index: i, value: str[i++] });
        continue;
      }
      if (char === ":") {
        var name = "";
        var j = i + 1;
        while (j < str.length) {
          var code = str.charCodeAt(j);
          if (
            // `0-9`
            code >= 48 && code <= 57 || // `A-Z`
            code >= 65 && code <= 90 || // `a-z`
            code >= 97 && code <= 122 || // `_`
            code === 95
          ) {
            name += str[j++];
            continue;
          }
          break;
        }
        if (!name)
          throw new TypeError("Missing parameter name at ".concat(i));
        tokens.push({ type: "NAME", index: i, value: name });
        i = j;
        continue;
      }
      if (char === "(") {
        var count = 1;
        var pattern = "";
        var j = i + 1;
        if (str[j] === "?") {
          throw new TypeError('Pattern cannot start with "?" at '.concat(j));
        }
        while (j < str.length) {
          if (str[j] === "\\") {
            pattern += str[j++] + str[j++];
            continue;
          }
          if (str[j] === ")") {
            count--;
            if (count === 0) {
              j++;
              break;
            }
          } else if (str[j] === "(") {
            count++;
            if (str[j + 1] !== "?") {
              throw new TypeError("Capturing groups are not allowed at ".concat(j));
            }
          }
          pattern += str[j++];
        }
        if (count)
          throw new TypeError("Unbalanced pattern at ".concat(i));
        if (!pattern)
          throw new TypeError("Missing pattern at ".concat(i));
        tokens.push({ type: "PATTERN", index: i, value: pattern });
        i = j;
        continue;
      }
      tokens.push({ type: "CHAR", index: i, value: str[i++] });
    }
    tokens.push({ type: "END", index: i, value: "" });
    return tokens;
  }
  function parse(str, options) {
    if (options === void 0) {
      options = {};
    }
    var tokens = lexer(str);
    var _a2 = options.prefixes, prefixes = _a2 === void 0 ? "./" : _a2, _b2 = options.delimiter, delimiter = _b2 === void 0 ? "/#?" : _b2;
    var result = [];
    var key = 0;
    var i = 0;
    var path = "";
    var tryConsume = function(type) {
      if (i < tokens.length && tokens[i].type === type)
        return tokens[i++].value;
    };
    var mustConsume = function(type) {
      var value2 = tryConsume(type);
      if (value2 !== void 0)
        return value2;
      var _a3 = tokens[i], nextType = _a3.type, index = _a3.index;
      throw new TypeError("Unexpected ".concat(nextType, " at ").concat(index, ", expected ").concat(type));
    };
    var consumeText = function() {
      var result2 = "";
      var value2;
      while (value2 = tryConsume("CHAR") || tryConsume("ESCAPED_CHAR")) {
        result2 += value2;
      }
      return result2;
    };
    var isSafe = function(value2) {
      for (var _i = 0, delimiter_1 = delimiter; _i < delimiter_1.length; _i++) {
        var char2 = delimiter_1[_i];
        if (value2.indexOf(char2) > -1)
          return true;
      }
      return false;
    };
    var safePattern = function(prefix2) {
      var prev = result[result.length - 1];
      var prevText = prefix2 || (prev && typeof prev === "string" ? prev : "");
      if (prev && !prevText) {
        throw new TypeError('Must have text between two parameters, missing text after "'.concat(prev.name, '"'));
      }
      if (!prevText || isSafe(prevText))
        return "[^".concat(escapeString(delimiter), "]+?");
      return "(?:(?!".concat(escapeString(prevText), ")[^").concat(escapeString(delimiter), "])+?");
    };
    while (i < tokens.length) {
      var char = tryConsume("CHAR");
      var name = tryConsume("NAME");
      var pattern = tryConsume("PATTERN");
      if (name || pattern) {
        var prefix = char || "";
        if (prefixes.indexOf(prefix) === -1) {
          path += prefix;
          prefix = "";
        }
        if (path) {
          result.push(path);
          path = "";
        }
        result.push({
          name: name || key++,
          prefix,
          suffix: "",
          pattern: pattern || safePattern(prefix),
          modifier: tryConsume("MODIFIER") || ""
        });
        continue;
      }
      var value = char || tryConsume("ESCAPED_CHAR");
      if (value) {
        path += value;
        continue;
      }
      if (path) {
        result.push(path);
        path = "";
      }
      var open = tryConsume("OPEN");
      if (open) {
        var prefix = consumeText();
        var name_1 = tryConsume("NAME") || "";
        var pattern_1 = tryConsume("PATTERN") || "";
        var suffix = consumeText();
        mustConsume("CLOSE");
        result.push({
          name: name_1 || (pattern_1 ? key++ : ""),
          pattern: name_1 && !pattern_1 ? safePattern(prefix) : pattern_1,
          prefix,
          suffix,
          modifier: tryConsume("MODIFIER") || ""
        });
        continue;
      }
      mustConsume("END");
    }
    return result;
  }
  function match(str, options) {
    var keys = [];
    var re = pathToRegexp(str, keys, options);
    return regexpToFunction(re, keys, options);
  }
  function regexpToFunction(re, keys, options) {
    if (options === void 0) {
      options = {};
    }
    var _a2 = options.decode, decode = _a2 === void 0 ? function(x) {
      return x;
    } : _a2;
    return function(pathname) {
      var m = re.exec(pathname);
      if (!m)
        return false;
      var path = m[0], index = m.index;
      var params = /* @__PURE__ */ Object.create(null);
      var _loop_1 = function(i2) {
        if (m[i2] === void 0)
          return "continue";
        var key = keys[i2 - 1];
        if (key.modifier === "*" || key.modifier === "+") {
          params[key.name] = m[i2].split(key.prefix + key.suffix).map(function(value) {
            return decode(value, key);
          });
        } else {
          params[key.name] = decode(m[i2], key);
        }
      };
      for (var i = 1; i < m.length; i++) {
        _loop_1(i);
      }
      return { path, index, params };
    };
  }
  function escapeString(str) {
    return str.replace(/([.+*?=^!:${}()[\]|/\\])/g, "\\$1");
  }
  function flags(options) {
    return options && options.sensitive ? "" : "i";
  }
  function regexpToRegexp(path, keys) {
    if (!keys)
      return path;
    var groupsRegex = /\((?:\?<(.*?)>)?(?!\?)/g;
    var index = 0;
    var execResult = groupsRegex.exec(path.source);
    while (execResult) {
      keys.push({
        // Use parenthesized substring match if available, index otherwise
        name: execResult[1] || index++,
        prefix: "",
        suffix: "",
        modifier: "",
        pattern: ""
      });
      execResult = groupsRegex.exec(path.source);
    }
    return path;
  }
  function arrayToRegexp(paths, keys, options) {
    var parts = paths.map(function(path) {
      return pathToRegexp(path, keys, options).source;
    });
    return new RegExp("(?:".concat(parts.join("|"), ")"), flags(options));
  }
  function stringToRegexp(path, keys, options) {
    return tokensToRegexp(parse(path, options), keys, options);
  }
  function tokensToRegexp(tokens, keys, options) {
    if (options === void 0) {
      options = {};
    }
    var _a2 = options.strict, strict = _a2 === void 0 ? false : _a2, _b2 = options.start, start = _b2 === void 0 ? true : _b2, _c2 = options.end, end = _c2 === void 0 ? true : _c2, _d = options.encode, encode = _d === void 0 ? function(x) {
      return x;
    } : _d, _e = options.delimiter, delimiter = _e === void 0 ? "/#?" : _e, _f = options.endsWith, endsWith = _f === void 0 ? "" : _f;
    var endsWithRe = "[".concat(escapeString(endsWith), "]|$");
    var delimiterRe = "[".concat(escapeString(delimiter), "]");
    var route = start ? "^" : "";
    for (var _i = 0, tokens_1 = tokens; _i < tokens_1.length; _i++) {
      var token = tokens_1[_i];
      if (typeof token === "string") {
        route += escapeString(encode(token));
      } else {
        var prefix = escapeString(encode(token.prefix));
        var suffix = escapeString(encode(token.suffix));
        if (token.pattern) {
          if (keys)
            keys.push(token);
          if (prefix || suffix) {
            if (token.modifier === "+" || token.modifier === "*") {
              var mod = token.modifier === "*" ? "?" : "";
              route += "(?:".concat(prefix, "((?:").concat(token.pattern, ")(?:").concat(suffix).concat(prefix, "(?:").concat(token.pattern, "))*)").concat(suffix, ")").concat(mod);
            } else {
              route += "(?:".concat(prefix, "(").concat(token.pattern, ")").concat(suffix, ")").concat(token.modifier);
            }
          } else {
            if (token.modifier === "+" || token.modifier === "*") {
              throw new TypeError('Can not repeat "'.concat(token.name, '" without a prefix and suffix'));
            }
            route += "(".concat(token.pattern, ")").concat(token.modifier);
          }
        } else {
          route += "(?:".concat(prefix).concat(suffix, ")").concat(token.modifier);
        }
      }
    }
    if (end) {
      if (!strict)
        route += "".concat(delimiterRe, "?");
      route += !options.endsWith ? "$" : "(?=".concat(endsWithRe, ")");
    } else {
      var endToken = tokens[tokens.length - 1];
      var isEndDelimited = typeof endToken === "string" ? delimiterRe.indexOf(endToken[endToken.length - 1]) > -1 : endToken === void 0;
      if (!strict) {
        route += "(?:".concat(delimiterRe, "(?=").concat(endsWithRe, "))?");
      }
      if (!isEndDelimited) {
        route += "(?=".concat(delimiterRe, "|").concat(endsWithRe, ")");
      }
    }
    return new RegExp(route, flags(options));
  }
  function pathToRegexp(path, keys, options) {
    if (path instanceof RegExp)
      return regexpToRegexp(path, keys);
    if (Array.isArray(path))
      return arrayToRegexp(path, keys, options);
    return stringToRegexp(path, keys, options);
  }

  // node_modules/.pnpm/@mswjs+interceptors@0.37.1/node_modules/@mswjs/interceptors/lib/browser/chunk-6HYIRFX2.mjs
  var encoder = new TextEncoder();
  function encodeBuffer(text) {
    return encoder.encode(text);
  }
  function decodeBuffer(buffer, encoding) {
    const decoder = new TextDecoder(encoding);
    return decoder.decode(buffer);
  }
  function toArrayBuffer(array) {
    return array.buffer.slice(
      array.byteOffset,
      array.byteOffset + array.byteLength
    );
  }

  // node_modules/.pnpm/@mswjs+interceptors@0.37.1/node_modules/@mswjs/interceptors/lib/browser/chunk-F4BN745U.mjs
  var IS_PATCHED_MODULE = Symbol("isPatchedModule");
  var _FetchResponse = class extends Response {
    static isConfigurableStatusCode(status) {
      return status >= 200 && status <= 599;
    }
    static isRedirectResponse(status) {
      return _FetchResponse.STATUS_CODES_WITH_REDIRECT.includes(status);
    }
    /**
     * Returns a boolean indicating whether the given response status
     * code represents a response that can have a body.
     */
    static isResponseWithBody(status) {
      return !_FetchResponse.STATUS_CODES_WITHOUT_BODY.includes(status);
    }
    static setUrl(url, response) {
      if (!url) {
        return;
      }
      if (response.url != "") {
        return;
      }
      Object.defineProperty(response, "url", {
        value: url,
        enumerable: true,
        configurable: true,
        writable: false
      });
    }
    constructor(body, init = {}) {
      var _a2;
      const status = (_a2 = init.status) != null ? _a2 : 200;
      const safeStatus = _FetchResponse.isConfigurableStatusCode(status) ? status : 200;
      const finalBody = _FetchResponse.isResponseWithBody(status) ? body : null;
      super(finalBody, {
        ...init,
        status: safeStatus
      });
      if (status !== safeStatus) {
        const stateSymbol = Object.getOwnPropertySymbols(this).find(
          (symbol) => symbol.description === "state"
        );
        if (stateSymbol) {
          const state = Reflect.get(this, stateSymbol);
          Reflect.set(state, "status", status);
        } else {
          Object.defineProperty(this, "status", {
            value: status,
            enumerable: true,
            configurable: true,
            writable: false
          });
        }
      }
      _FetchResponse.setUrl(init.url, this);
    }
  };
  var FetchResponse = _FetchResponse;
  FetchResponse.STATUS_CODES_WITHOUT_BODY = [101, 103, 204, 205, 304];
  FetchResponse.STATUS_CODES_WITH_REDIRECT = [301, 302, 303, 307, 308];

  // node_modules/.pnpm/is-node-process@1.2.0/node_modules/is-node-process/lib/index.mjs
  function isNodeProcess() {
    if (typeof navigator !== "undefined" && navigator.product === "ReactNative") {
      return true;
    }
    if (typeof process !== "undefined") {
      const type = process.type;
      if (type === "renderer" || type === "worker") {
        return false;
      }
      return !!(process.versions && process.versions.node);
    }
    return false;
  }

  // node_modules/.pnpm/@open-draft+logger@0.3.0/node_modules/@open-draft/logger/lib/index.mjs
  var __defProp3 = Object.defineProperty;
  var __export2 = (target, all) => {
    for (var name in all)
      __defProp3(target, name, { get: all[name], enumerable: true });
  };
  var colors_exports = {};
  __export2(colors_exports, {
    blue: () => blue,
    gray: () => gray,
    green: () => green,
    red: () => red,
    yellow: () => yellow
  });
  function yellow(text) {
    return `\x1B[33m${text}\x1B[0m`;
  }
  function blue(text) {
    return `\x1B[34m${text}\x1B[0m`;
  }
  function gray(text) {
    return `\x1B[90m${text}\x1B[0m`;
  }
  function red(text) {
    return `\x1B[31m${text}\x1B[0m`;
  }
  function green(text) {
    return `\x1B[32m${text}\x1B[0m`;
  }
  var IS_NODE = isNodeProcess();
  var Logger = class {
    constructor(name) {
      this.name = name;
      this.prefix = `[${this.name}]`;
      const LOGGER_NAME = getVariable("DEBUG");
      const LOGGER_LEVEL = getVariable("LOG_LEVEL");
      const isLoggingEnabled = LOGGER_NAME === "1" || LOGGER_NAME === "true" || typeof LOGGER_NAME !== "undefined" && this.name.startsWith(LOGGER_NAME);
      if (isLoggingEnabled) {
        this.debug = isDefinedAndNotEquals(LOGGER_LEVEL, "debug") ? noop : this.debug;
        this.info = isDefinedAndNotEquals(LOGGER_LEVEL, "info") ? noop : this.info;
        this.success = isDefinedAndNotEquals(LOGGER_LEVEL, "success") ? noop : this.success;
        this.warning = isDefinedAndNotEquals(LOGGER_LEVEL, "warning") ? noop : this.warning;
        this.error = isDefinedAndNotEquals(LOGGER_LEVEL, "error") ? noop : this.error;
      } else {
        this.info = noop;
        this.success = noop;
        this.warning = noop;
        this.error = noop;
        this.only = noop;
      }
    }
    prefix;
    extend(domain) {
      return new Logger(`${this.name}:${domain}`);
    }
    /**
     * Print a debug message.
     * @example
     * logger.debug('no duplicates found, creating a document...')
     */
    debug(message3, ...positionals) {
      this.logEntry({
        level: "debug",
        message: gray(message3),
        positionals,
        prefix: this.prefix,
        colors: {
          prefix: "gray"
        }
      });
    }
    /**
     * Print an info message.
     * @example
     * logger.info('start parsing...')
     */
    info(message3, ...positionals) {
      this.logEntry({
        level: "info",
        message: message3,
        positionals,
        prefix: this.prefix,
        colors: {
          prefix: "blue"
        }
      });
      const performance2 = new PerformanceEntry();
      return (message22, ...positionals2) => {
        performance2.measure();
        this.logEntry({
          level: "info",
          message: `${message22} ${gray(`${performance2.deltaTime}ms`)}`,
          positionals: positionals2,
          prefix: this.prefix,
          colors: {
            prefix: "blue"
          }
        });
      };
    }
    /**
     * Print a success message.
     * @example
     * logger.success('successfully created document')
     */
    success(message3, ...positionals) {
      this.logEntry({
        level: "info",
        message: message3,
        positionals,
        prefix: `\u2714 ${this.prefix}`,
        colors: {
          timestamp: "green",
          prefix: "green"
        }
      });
    }
    /**
     * Print a warning.
     * @example
     * logger.warning('found legacy document format')
     */
    warning(message3, ...positionals) {
      this.logEntry({
        level: "warning",
        message: message3,
        positionals,
        prefix: `\u26A0 ${this.prefix}`,
        colors: {
          timestamp: "yellow",
          prefix: "yellow"
        }
      });
    }
    /**
     * Print an error message.
     * @example
     * logger.error('something went wrong')
     */
    error(message3, ...positionals) {
      this.logEntry({
        level: "error",
        message: message3,
        positionals,
        prefix: `\u2716 ${this.prefix}`,
        colors: {
          timestamp: "red",
          prefix: "red"
        }
      });
    }
    /**
     * Execute the given callback only when the logging is enabled.
     * This is skipped in its entirety and has no runtime cost otherwise.
     * This executes regardless of the log level.
     * @example
     * logger.only(() => {
     *   logger.info('additional info')
     * })
     */
    only(callback) {
      callback();
    }
    createEntry(level, message3) {
      return {
        timestamp: /* @__PURE__ */ new Date(),
        level,
        message: message3
      };
    }
    logEntry(args) {
      const {
        level,
        message: message3,
        prefix,
        colors: customColors,
        positionals = []
      } = args;
      const entry = this.createEntry(level, message3);
      const timestampColor = customColors?.timestamp || "gray";
      const prefixColor = customColors?.prefix || "gray";
      const colorize = {
        timestamp: colors_exports[timestampColor],
        prefix: colors_exports[prefixColor]
      };
      const write = this.getWriter(level);
      write(
        [colorize.timestamp(this.formatTimestamp(entry.timestamp))].concat(prefix != null ? colorize.prefix(prefix) : []).concat(serializeInput(message3)).join(" "),
        ...positionals.map(serializeInput)
      );
    }
    formatTimestamp(timestamp) {
      return `${timestamp.toLocaleTimeString(
        "en-GB"
      )}:${timestamp.getMilliseconds()}`;
    }
    getWriter(level) {
      switch (level) {
        case "debug":
        case "success":
        case "info": {
          return log;
        }
        case "warning": {
          return warn2;
        }
        case "error": {
          return error2;
        }
      }
    }
  };
  var PerformanceEntry = class {
    startTime;
    endTime;
    deltaTime;
    constructor() {
      this.startTime = performance.now();
    }
    measure() {
      this.endTime = performance.now();
      const deltaTime = this.endTime - this.startTime;
      this.deltaTime = deltaTime.toFixed(2);
    }
  };
  var noop = () => void 0;
  function log(message3, ...positionals) {
    if (IS_NODE) {
      process.stdout.write(format(message3, ...positionals) + "\n");
      return;
    }
    console.log(message3, ...positionals);
  }
  function warn2(message3, ...positionals) {
    if (IS_NODE) {
      process.stderr.write(format(message3, ...positionals) + "\n");
      return;
    }
    console.warn(message3, ...positionals);
  }
  function error2(message3, ...positionals) {
    if (IS_NODE) {
      process.stderr.write(format(message3, ...positionals) + "\n");
      return;
    }
    console.error(message3, ...positionals);
  }
  function getVariable(variableName) {
    if (IS_NODE) {
      return process.env[variableName];
    }
    return globalThis[variableName]?.toString();
  }
  function isDefinedAndNotEquals(value, expected) {
    return value !== void 0 && value !== expected;
  }
  function serializeInput(message3) {
    if (typeof message3 === "undefined") {
      return "undefined";
    }
    if (message3 === null) {
      return "null";
    }
    if (typeof message3 === "string") {
      return message3;
    }
    if (typeof message3 === "object") {
      return JSON.stringify(message3);
    }
    return message3.toString();
  }

  // node_modules/.pnpm/@mswjs+interceptors@0.37.1/node_modules/@mswjs/interceptors/lib/browser/chunk-QED3Q6Z2.mjs
  var INTERNAL_REQUEST_ID_HEADER_NAME = "x-interceptors-internal-request-id";
  function getGlobalSymbol(symbol) {
    return (
      // @ts-ignore https://github.com/Microsoft/TypeScript/issues/24587
      globalThis[symbol] || void 0
    );
  }
  function setGlobalSymbol(symbol, value) {
    globalThis[symbol] = value;
  }
  function deleteGlobalSymbol(symbol) {
    delete globalThis[symbol];
  }
  var Interceptor = class {
    constructor(symbol) {
      this.symbol = symbol;
      this.readyState = "INACTIVE";
      this.emitter = new Emitter();
      this.subscriptions = [];
      this.logger = new Logger(symbol.description);
      this.emitter.setMaxListeners(0);
      this.logger.info("constructing the interceptor...");
    }
    /**
     * Determine if this interceptor can be applied
     * in the current environment.
     */
    checkEnvironment() {
      return true;
    }
    /**
     * Apply this interceptor to the current process.
     * Returns an already running interceptor instance if it's present.
     */
    apply() {
      const logger = this.logger.extend("apply");
      logger.info("applying the interceptor...");
      if (this.readyState === "APPLIED") {
        logger.info("intercepted already applied!");
        return;
      }
      const shouldApply = this.checkEnvironment();
      if (!shouldApply) {
        logger.info("the interceptor cannot be applied in this environment!");
        return;
      }
      this.readyState = "APPLYING";
      const runningInstance = this.getInstance();
      if (runningInstance) {
        logger.info("found a running instance, reusing...");
        this.on = (event, listener) => {
          logger.info('proxying the "%s" listener', event);
          runningInstance.emitter.addListener(event, listener);
          this.subscriptions.push(() => {
            runningInstance.emitter.removeListener(event, listener);
            logger.info('removed proxied "%s" listener!', event);
          });
          return this;
        };
        this.readyState = "APPLIED";
        return;
      }
      logger.info("no running instance found, setting up a new instance...");
      this.setup();
      this.setInstance();
      this.readyState = "APPLIED";
    }
    /**
     * Setup the module augments and stubs necessary for this interceptor.
     * This method is not run if there's a running interceptor instance
     * to prevent instantiating an interceptor multiple times.
     */
    setup() {
    }
    /**
     * Listen to the interceptor's public events.
     */
    on(event, listener) {
      const logger = this.logger.extend("on");
      if (this.readyState === "DISPOSING" || this.readyState === "DISPOSED") {
        logger.info("cannot listen to events, already disposed!");
        return this;
      }
      logger.info('adding "%s" event listener:', event, listener);
      this.emitter.on(event, listener);
      return this;
    }
    once(event, listener) {
      this.emitter.once(event, listener);
      return this;
    }
    off(event, listener) {
      this.emitter.off(event, listener);
      return this;
    }
    removeAllListeners(event) {
      this.emitter.removeAllListeners(event);
      return this;
    }
    /**
     * Disposes of any side-effects this interceptor has introduced.
     */
    dispose() {
      const logger = this.logger.extend("dispose");
      if (this.readyState === "DISPOSED") {
        logger.info("cannot dispose, already disposed!");
        return;
      }
      logger.info("disposing the interceptor...");
      this.readyState = "DISPOSING";
      if (!this.getInstance()) {
        logger.info("no interceptors running, skipping dispose...");
        return;
      }
      this.clearInstance();
      logger.info("global symbol deleted:", getGlobalSymbol(this.symbol));
      if (this.subscriptions.length > 0) {
        logger.info("disposing of %d subscriptions...", this.subscriptions.length);
        for (const dispose of this.subscriptions) {
          dispose();
        }
        this.subscriptions = [];
        logger.info("disposed of all subscriptions!", this.subscriptions.length);
      }
      this.emitter.removeAllListeners();
      logger.info("destroyed the listener!");
      this.readyState = "DISPOSED";
    }
    getInstance() {
      var _a2;
      const instance = getGlobalSymbol(this.symbol);
      this.logger.info("retrieved global instance:", (_a2 = instance == null ? void 0 : instance.constructor) == null ? void 0 : _a2.name);
      return instance;
    }
    setInstance() {
      setGlobalSymbol(this.symbol, this);
      this.logger.info("set global instance!", this.symbol.description);
    }
    clearInstance() {
      deleteGlobalSymbol(this.symbol);
      this.logger.info("cleared global instance!", this.symbol.description);
    }
  };
  function createRequestId() {
    return Math.random().toString(16).slice(2);
  }

  // node_modules/.pnpm/@mswjs+interceptors@0.37.1/node_modules/@mswjs/interceptors/lib/browser/index.mjs
  var BatchInterceptor = class extends Interceptor {
    constructor(options) {
      BatchInterceptor.symbol = Symbol(options.name);
      super(BatchInterceptor.symbol);
      this.interceptors = options.interceptors;
    }
    setup() {
      const logger = this.logger.extend("setup");
      logger.info("applying all %d interceptors...", this.interceptors.length);
      for (const interceptor of this.interceptors) {
        logger.info('applying "%s" interceptor...', interceptor.constructor.name);
        interceptor.apply();
        logger.info("adding interceptor dispose subscription");
        this.subscriptions.push(() => interceptor.dispose());
      }
    }
    on(event, listener) {
      for (const interceptor of this.interceptors) {
        interceptor.on(event, listener);
      }
      return this;
    }
    once(event, listener) {
      for (const interceptor of this.interceptors) {
        interceptor.once(event, listener);
      }
      return this;
    }
    off(event, listener) {
      for (const interceptor of this.interceptors) {
        interceptor.off(event, listener);
      }
      return this;
    }
    removeAllListeners(event) {
      for (const interceptors of this.interceptors) {
        interceptors.removeAllListeners(event);
      }
      return this;
    }
  };
  function getCleanUrl(url, isAbsolute = true) {
    return [isAbsolute && url.origin, url.pathname].filter(Boolean).join("");
  }

  // src/core/utils/url/cleanUrl.ts
  var REDUNDANT_CHARACTERS_EXP = /[\?|#].*$/g;
  function getSearchParams(path) {
    return new URL(`/${path}`, "http://localhost").searchParams;
  }
  function cleanUrl(path) {
    if (path.endsWith("?")) {
      return path;
    }
    return path.replace(REDUNDANT_CHARACTERS_EXP, "");
  }

  // src/core/utils/url/isAbsoluteUrl.ts
  function isAbsoluteUrl(url) {
    return /^([a-z][a-z\d\+\-\.]*:)?\/\//i.test(url);
  }

  // src/core/utils/url/getAbsoluteUrl.ts
  function getAbsoluteUrl(path, baseUrl) {
    if (isAbsoluteUrl(path)) {
      return path;
    }
    if (path.startsWith("*")) {
      return path;
    }
    const origin = baseUrl || typeof document !== "undefined" && document.baseURI;
    return origin ? (
      // Encode and decode the path to preserve escaped characters.
      decodeURI(new URL(encodeURI(path), origin).href)
    ) : path;
  }

  // src/core/utils/matching/normalizePath.ts
  function normalizePath(path, baseUrl) {
    if (path instanceof RegExp) {
      return path;
    }
    const maybeAbsoluteUrl = getAbsoluteUrl(path, baseUrl);
    return cleanUrl(maybeAbsoluteUrl);
  }

  // src/core/utils/matching/matchRequestUrl.ts
  function coercePath(path) {
    return path.replace(
      /([:a-zA-Z_-]*)(\*{1,2})+/g,
      (_, parameterName, wildcard) => {
        const expression = "(.*)";
        if (!parameterName) {
          return expression;
        }
        return parameterName.startsWith(":") ? `${parameterName}${wildcard}` : `${parameterName}${expression}`;
      }
    ).replace(/([^\/])(:)(?=\d+)/, "$1\\$2").replace(/^([^\/]+)(:)(?=\/\/)/, "$1\\$2");
  }
  function matchRequestUrl(url, path, baseUrl) {
    const normalizedPath = normalizePath(path, baseUrl);
    const cleanPath = typeof normalizedPath === "string" ? coercePath(normalizedPath) : normalizedPath;
    const cleanUrl2 = getCleanUrl(url);
    const result = match(cleanPath, { decode: decodeURIComponent })(cleanUrl2);
    const params = result && result.params || {};
    return {
      matches: result !== false,
      params
    };
  }
  function isPath(value) {
    return typeof value === "string" || value instanceof RegExp;
  }

  // src/core/utils/request/toPublicUrl.ts
  function toPublicUrl(url) {
    if (typeof location === "undefined") {
      return url.toString();
    }
    const urlInstance = url instanceof URL ? url : new URL(url);
    return urlInstance.origin === location.origin ? urlInstance.pathname : urlInstance.origin + urlInstance.pathname;
  }

  // node_modules/.pnpm/@bundled-es-modules+cookie@2.0.1/node_modules/@bundled-es-modules/cookie/index-esm.js
  var __create2 = Object.create;
  var __defProp4 = Object.defineProperty;
  var __getOwnPropDesc3 = Object.getOwnPropertyDescriptor;
  var __getOwnPropNames3 = Object.getOwnPropertyNames;
  var __getProtoOf2 = Object.getPrototypeOf;
  var __hasOwnProp3 = Object.prototype.hasOwnProperty;
  var __commonJS2 = (cb, mod) => function __require3() {
    return mod || (0, cb[__getOwnPropNames3(cb)[0]])((mod = { exports: {} }).exports, mod), mod.exports;
  };
  var __copyProps3 = (to, from, except, desc) => {
    if (from && typeof from === "object" || typeof from === "function") {
      for (let key of __getOwnPropNames3(from))
        if (!__hasOwnProp3.call(to, key) && key !== except)
          __defProp4(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc3(from, key)) || desc.enumerable });
    }
    return to;
  };
  var __toESM2 = (mod, isNodeMode, target) => (target = mod != null ? __create2(__getProtoOf2(mod)) : {}, __copyProps3(
    // If the importer is in node compatibility mode or this is not an ESM
    // file that has been converted to a CommonJS file using a Babel-
    // compatible transform (i.e. "__esModule" has not been set), then set
    // "default" to the CommonJS "module.exports" for node compatibility.
    isNodeMode || !mod || !mod.__esModule ? __defProp4(target, "default", { value: mod, enumerable: true }) : target,
    mod
  ));
  var require_cookie = __commonJS2({
    "node_modules/cookie/index.js"(exports) {
      "use strict";
      exports.parse = parse3;
      exports.serialize = serialize;
      var __toString = Object.prototype.toString;
      var __hasOwnProperty = Object.prototype.hasOwnProperty;
      var cookieNameRegExp = /^[!#$%&'*+\-.^_`|~0-9A-Za-z]+$/;
      var cookieValueRegExp = /^("?)[\u0021\u0023-\u002B\u002D-\u003A\u003C-\u005B\u005D-\u007E]*\1$/;
      var domainValueRegExp = /^([.]?[a-z0-9]([a-z0-9-]{0,61}[a-z0-9])?)([.][a-z0-9]([a-z0-9-]{0,61}[a-z0-9])?)*$/i;
      var pathValueRegExp = /^[\u0020-\u003A\u003D-\u007E]*$/;
      function parse3(str, opt) {
        if (typeof str !== "string") {
          throw new TypeError("argument str must be a string");
        }
        var obj = {};
        var len = str.length;
        if (len < 2) return obj;
        var dec = opt && opt.decode || decode;
        var index = 0;
        var eqIdx = 0;
        var endIdx = 0;
        do {
          eqIdx = str.indexOf("=", index);
          if (eqIdx === -1) break;
          endIdx = str.indexOf(";", index);
          if (endIdx === -1) {
            endIdx = len;
          } else if (eqIdx > endIdx) {
            index = str.lastIndexOf(";", eqIdx - 1) + 1;
            continue;
          }
          var keyStartIdx = startIndex(str, index, eqIdx);
          var keyEndIdx = endIndex(str, eqIdx, keyStartIdx);
          var key = str.slice(keyStartIdx, keyEndIdx);
          if (!__hasOwnProperty.call(obj, key)) {
            var valStartIdx = startIndex(str, eqIdx + 1, endIdx);
            var valEndIdx = endIndex(str, endIdx, valStartIdx);
            if (str.charCodeAt(valStartIdx) === 34 && str.charCodeAt(valEndIdx - 1) === 34) {
              valStartIdx++;
              valEndIdx--;
            }
            var val = str.slice(valStartIdx, valEndIdx);
            obj[key] = tryDecode(val, dec);
          }
          index = endIdx + 1;
        } while (index < len);
        return obj;
      }
      function startIndex(str, index, max) {
        do {
          var code = str.charCodeAt(index);
          if (code !== 32 && code !== 9) return index;
        } while (++index < max);
        return max;
      }
      function endIndex(str, index, min) {
        while (index > min) {
          var code = str.charCodeAt(--index);
          if (code !== 32 && code !== 9) return index + 1;
        }
        return min;
      }
      function serialize(name, val, opt) {
        var enc = opt && opt.encode || encodeURIComponent;
        if (typeof enc !== "function") {
          throw new TypeError("option encode is invalid");
        }
        if (!cookieNameRegExp.test(name)) {
          throw new TypeError("argument name is invalid");
        }
        var value = enc(val);
        if (!cookieValueRegExp.test(value)) {
          throw new TypeError("argument val is invalid");
        }
        var str = name + "=" + value;
        if (!opt) return str;
        if (null != opt.maxAge) {
          var maxAge = Math.floor(opt.maxAge);
          if (!isFinite(maxAge)) {
            throw new TypeError("option maxAge is invalid");
          }
          str += "; Max-Age=" + maxAge;
        }
        if (opt.domain) {
          if (!domainValueRegExp.test(opt.domain)) {
            throw new TypeError("option domain is invalid");
          }
          str += "; Domain=" + opt.domain;
        }
        if (opt.path) {
          if (!pathValueRegExp.test(opt.path)) {
            throw new TypeError("option path is invalid");
          }
          str += "; Path=" + opt.path;
        }
        if (opt.expires) {
          var expires = opt.expires;
          if (!isDate(expires) || isNaN(expires.valueOf())) {
            throw new TypeError("option expires is invalid");
          }
          str += "; Expires=" + expires.toUTCString();
        }
        if (opt.httpOnly) {
          str += "; HttpOnly";
        }
        if (opt.secure) {
          str += "; Secure";
        }
        if (opt.partitioned) {
          str += "; Partitioned";
        }
        if (opt.priority) {
          var priority = typeof opt.priority === "string" ? opt.priority.toLowerCase() : opt.priority;
          switch (priority) {
            case "low":
              str += "; Priority=Low";
              break;
            case "medium":
              str += "; Priority=Medium";
              break;
            case "high":
              str += "; Priority=High";
              break;
            default:
              throw new TypeError("option priority is invalid");
          }
        }
        if (opt.sameSite) {
          var sameSite = typeof opt.sameSite === "string" ? opt.sameSite.toLowerCase() : opt.sameSite;
          switch (sameSite) {
            case true:
              str += "; SameSite=Strict";
              break;
            case "lax":
              str += "; SameSite=Lax";
              break;
            case "strict":
              str += "; SameSite=Strict";
              break;
            case "none":
              str += "; SameSite=None";
              break;
            default:
              throw new TypeError("option sameSite is invalid");
          }
        }
        return str;
      }
      function decode(str) {
        return str.indexOf("%") !== -1 ? decodeURIComponent(str) : str;
      }
      function isDate(val) {
        return __toString.call(val) === "[object Date]";
      }
      function tryDecode(str, decode2) {
        try {
          return decode2(str);
        } catch (e) {
          return str;
        }
      }
    }
  });
  var import_cookie = __toESM2(require_cookie(), 1);
  var source_default2 = import_cookie.default;

  // node_modules/.pnpm/@bundled-es-modules+tough-cookie@0.1.6/node_modules/@bundled-es-modules/tough-cookie/index-esm.js
  var __create3 = Object.create;
  var __defProp5 = Object.defineProperty;
  var __getOwnPropDesc4 = Object.getOwnPropertyDescriptor;
  var __getOwnPropNames4 = Object.getOwnPropertyNames;
  var __getProtoOf3 = Object.getPrototypeOf;
  var __hasOwnProp4 = Object.prototype.hasOwnProperty;
  var __require2 = /* @__PURE__ */ ((x) => typeof __require !== "undefined" ? __require : typeof Proxy !== "undefined" ? new Proxy(x, {
    get: (a, b) => (typeof __require !== "undefined" ? __require : a)[b]
  }) : x)(function(x) {
    if (typeof __require !== "undefined") return __require.apply(this, arguments);
    throw Error('Dynamic require of "' + x + '" is not supported');
  });
  var __commonJS3 = (cb, mod) => function __require22() {
    return mod || (0, cb[__getOwnPropNames4(cb)[0]])((mod = { exports: {} }).exports, mod), mod.exports;
  };
  var __copyProps4 = (to, from, except, desc) => {
    if (from && typeof from === "object" || typeof from === "function") {
      for (let key of __getOwnPropNames4(from))
        if (!__hasOwnProp4.call(to, key) && key !== except)
          __defProp5(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc4(from, key)) || desc.enumerable });
    }
    return to;
  };
  var __toESM3 = (mod, isNodeMode, target) => (target = mod != null ? __create3(__getProtoOf3(mod)) : {}, __copyProps4(
    // If the importer is in node compatibility mode or this is not an ESM
    // file that has been converted to a CommonJS file using a Babel-
    // compatible transform (i.e. "__esModule" has not been set), then set
    // "default" to the CommonJS "module.exports" for node compatibility.
    isNodeMode || !mod || !mod.__esModule ? __defProp5(target, "default", { value: mod, enumerable: true }) : target,
    mod
  ));
  var require_punycode = __commonJS3({
    "node_modules/punycode/punycode.js"(exports, module) {
      "use strict";
      var maxInt = 2147483647;
      var base = 36;
      var tMin = 1;
      var tMax = 26;
      var skew = 38;
      var damp = 700;
      var initialBias = 72;
      var initialN = 128;
      var delimiter = "-";
      var regexPunycode = /^xn--/;
      var regexNonASCII = /[^\0-\x7F]/;
      var regexSeparators = /[\x2E\u3002\uFF0E\uFF61]/g;
      var errors = {
        "overflow": "Overflow: input needs wider integers to process",
        "not-basic": "Illegal input >= 0x80 (not a basic code point)",
        "invalid-input": "Invalid input"
      };
      var baseMinusTMin = base - tMin;
      var floor = Math.floor;
      var stringFromCharCode = String.fromCharCode;
      function error3(type) {
        throw new RangeError(errors[type]);
      }
      function map(array, callback) {
        const result = [];
        let length = array.length;
        while (length--) {
          result[length] = callback(array[length]);
        }
        return result;
      }
      function mapDomain(domain, callback) {
        const parts = domain.split("@");
        let result = "";
        if (parts.length > 1) {
          result = parts[0] + "@";
          domain = parts[1];
        }
        domain = domain.replace(regexSeparators, ".");
        const labels = domain.split(".");
        const encoded = map(labels, callback).join(".");
        return result + encoded;
      }
      function ucs2decode(string) {
        const output = [];
        let counter = 0;
        const length = string.length;
        while (counter < length) {
          const value = string.charCodeAt(counter++);
          if (value >= 55296 && value <= 56319 && counter < length) {
            const extra = string.charCodeAt(counter++);
            if ((extra & 64512) == 56320) {
              output.push(((value & 1023) << 10) + (extra & 1023) + 65536);
            } else {
              output.push(value);
              counter--;
            }
          } else {
            output.push(value);
          }
        }
        return output;
      }
      var ucs2encode = (codePoints) => String.fromCodePoint(...codePoints);
      var basicToDigit = function(codePoint) {
        if (codePoint >= 48 && codePoint < 58) {
          return 26 + (codePoint - 48);
        }
        if (codePoint >= 65 && codePoint < 91) {
          return codePoint - 65;
        }
        if (codePoint >= 97 && codePoint < 123) {
          return codePoint - 97;
        }
        return base;
      };
      var digitToBasic = function(digit, flag) {
        return digit + 22 + 75 * (digit < 26) - ((flag != 0) << 5);
      };
      var adapt = function(delta, numPoints, firstTime) {
        let k = 0;
        delta = firstTime ? floor(delta / damp) : delta >> 1;
        delta += floor(delta / numPoints);
        for (; delta > baseMinusTMin * tMax >> 1; k += base) {
          delta = floor(delta / baseMinusTMin);
        }
        return floor(k + (baseMinusTMin + 1) * delta / (delta + skew));
      };
      var decode = function(input) {
        const output = [];
        const inputLength = input.length;
        let i = 0;
        let n = initialN;
        let bias = initialBias;
        let basic = input.lastIndexOf(delimiter);
        if (basic < 0) {
          basic = 0;
        }
        for (let j = 0; j < basic; ++j) {
          if (input.charCodeAt(j) >= 128) {
            error3("not-basic");
          }
          output.push(input.charCodeAt(j));
        }
        for (let index = basic > 0 ? basic + 1 : 0; index < inputLength; ) {
          const oldi = i;
          for (let w = 1, k = base; ; k += base) {
            if (index >= inputLength) {
              error3("invalid-input");
            }
            const digit = basicToDigit(input.charCodeAt(index++));
            if (digit >= base) {
              error3("invalid-input");
            }
            if (digit > floor((maxInt - i) / w)) {
              error3("overflow");
            }
            i += digit * w;
            const t = k <= bias ? tMin : k >= bias + tMax ? tMax : k - bias;
            if (digit < t) {
              break;
            }
            const baseMinusT = base - t;
            if (w > floor(maxInt / baseMinusT)) {
              error3("overflow");
            }
            w *= baseMinusT;
          }
          const out = output.length + 1;
          bias = adapt(i - oldi, out, oldi == 0);
          if (floor(i / out) > maxInt - n) {
            error3("overflow");
          }
          n += floor(i / out);
          i %= out;
          output.splice(i++, 0, n);
        }
        return String.fromCodePoint(...output);
      };
      var encode = function(input) {
        const output = [];
        input = ucs2decode(input);
        const inputLength = input.length;
        let n = initialN;
        let delta = 0;
        let bias = initialBias;
        for (const currentValue of input) {
          if (currentValue < 128) {
            output.push(stringFromCharCode(currentValue));
          }
        }
        const basicLength = output.length;
        let handledCPCount = basicLength;
        if (basicLength) {
          output.push(delimiter);
        }
        while (handledCPCount < inputLength) {
          let m = maxInt;
          for (const currentValue of input) {
            if (currentValue >= n && currentValue < m) {
              m = currentValue;
            }
          }
          const handledCPCountPlusOne = handledCPCount + 1;
          if (m - n > floor((maxInt - delta) / handledCPCountPlusOne)) {
            error3("overflow");
          }
          delta += (m - n) * handledCPCountPlusOne;
          n = m;
          for (const currentValue of input) {
            if (currentValue < n && ++delta > maxInt) {
              error3("overflow");
            }
            if (currentValue === n) {
              let q = delta;
              for (let k = base; ; k += base) {
                const t = k <= bias ? tMin : k >= bias + tMax ? tMax : k - bias;
                if (q < t) {
                  break;
                }
                const qMinusT = q - t;
                const baseMinusT = base - t;
                output.push(
                  stringFromCharCode(digitToBasic(t + qMinusT % baseMinusT, 0))
                );
                q = floor(qMinusT / baseMinusT);
              }
              output.push(stringFromCharCode(digitToBasic(q, 0)));
              bias = adapt(delta, handledCPCountPlusOne, handledCPCount === basicLength);
              delta = 0;
              ++handledCPCount;
            }
          }
          ++delta;
          ++n;
        }
        return output.join("");
      };
      var toUnicode = function(input) {
        return mapDomain(input, function(string) {
          return regexPunycode.test(string) ? decode(string.slice(4).toLowerCase()) : string;
        });
      };
      var toASCII = function(input) {
        return mapDomain(input, function(string) {
          return regexNonASCII.test(string) ? "xn--" + encode(string) : string;
        });
      };
      var punycode = {
        /**
         * A string representing the current Punycode.js version number.
         * @memberOf punycode
         * @type String
         */
        "version": "2.3.1",
        /**
         * An object of methods to convert from JavaScript's internal character
         * representation (UCS-2) to Unicode code points, and back.
         * @see <https://mathiasbynens.be/notes/javascript-encoding>
         * @memberOf punycode
         * @type Object
         */
        "ucs2": {
          "decode": ucs2decode,
          "encode": ucs2encode
        },
        "decode": decode,
        "encode": encode,
        "toASCII": toASCII,
        "toUnicode": toUnicode
      };
      module.exports = punycode;
    }
  });
  var require_requires_port = __commonJS3({
    "node_modules/requires-port/index.js"(exports, module) {
      "use strict";
      module.exports = function required(port, protocol) {
        protocol = protocol.split(":")[0];
        port = +port;
        if (!port) return false;
        switch (protocol) {
          case "http":
          case "ws":
            return port !== 80;
          case "https":
          case "wss":
            return port !== 443;
          case "ftp":
            return port !== 21;
          case "gopher":
            return port !== 70;
          case "file":
            return false;
        }
        return port !== 0;
      };
    }
  });
  var require_querystringify = __commonJS3({
    "node_modules/querystringify/index.js"(exports) {
      "use strict";
      var has = Object.prototype.hasOwnProperty;
      var undef;
      function decode(input) {
        try {
          return decodeURIComponent(input.replace(/\+/g, " "));
        } catch (e) {
          return null;
        }
      }
      function encode(input) {
        try {
          return encodeURIComponent(input);
        } catch (e) {
          return null;
        }
      }
      function querystring(query) {
        var parser = /([^=?#&]+)=?([^&]*)/g, result = {}, part;
        while (part = parser.exec(query)) {
          var key = decode(part[1]), value = decode(part[2]);
          if (key === null || value === null || key in result) continue;
          result[key] = value;
        }
        return result;
      }
      function querystringify(obj, prefix) {
        prefix = prefix || "";
        var pairs = [], value, key;
        if ("string" !== typeof prefix) prefix = "?";
        for (key in obj) {
          if (has.call(obj, key)) {
            value = obj[key];
            if (!value && (value === null || value === undef || isNaN(value))) {
              value = "";
            }
            key = encode(key);
            value = encode(value);
            if (key === null || value === null) continue;
            pairs.push(key + "=" + value);
          }
        }
        return pairs.length ? prefix + pairs.join("&") : "";
      }
      exports.stringify = querystringify;
      exports.parse = querystring;
    }
  });
  var require_url_parse = __commonJS3({
    "node_modules/url-parse/index.js"(exports, module) {
      "use strict";
      var required = require_requires_port();
      var qs = require_querystringify();
      var controlOrWhitespace = /^[\x00-\x20\u00a0\u1680\u2000-\u200a\u2028\u2029\u202f\u205f\u3000\ufeff]+/;
      var CRHTLF = /[\n\r\t]/g;
      var slashes = /^[A-Za-z][A-Za-z0-9+-.]*:\/\//;
      var port = /:\d+$/;
      var protocolre = /^([a-z][a-z0-9.+-]*:)?(\/\/)?([\\/]+)?([\S\s]*)/i;
      var windowsDriveLetter = /^[a-zA-Z]:/;
      function trimLeft(str) {
        return (str ? str : "").toString().replace(controlOrWhitespace, "");
      }
      var rules = [
        ["#", "hash"],
        // Extract from the back.
        ["?", "query"],
        // Extract from the back.
        function sanitize(address, url) {
          return isSpecial(url.protocol) ? address.replace(/\\/g, "/") : address;
        },
        ["/", "pathname"],
        // Extract from the back.
        ["@", "auth", 1],
        // Extract from the front.
        [NaN, "host", void 0, 1, 1],
        // Set left over value.
        [/:(\d*)$/, "port", void 0, 1],
        // RegExp the back.
        [NaN, "hostname", void 0, 1, 1]
        // Set left over.
      ];
      var ignore = { hash: 1, query: 1 };
      function lolcation(loc) {
        var globalVar;
        if (typeof window !== "undefined") globalVar = window;
        else if (typeof global !== "undefined") globalVar = global;
        else if (typeof self !== "undefined") globalVar = self;
        else globalVar = {};
        var location2 = globalVar.location || {};
        loc = loc || location2;
        var finaldestination = {}, type = typeof loc, key;
        if ("blob:" === loc.protocol) {
          finaldestination = new Url(unescape(loc.pathname), {});
        } else if ("string" === type) {
          finaldestination = new Url(loc, {});
          for (key in ignore) delete finaldestination[key];
        } else if ("object" === type) {
          for (key in loc) {
            if (key in ignore) continue;
            finaldestination[key] = loc[key];
          }
          if (finaldestination.slashes === void 0) {
            finaldestination.slashes = slashes.test(loc.href);
          }
        }
        return finaldestination;
      }
      function isSpecial(scheme) {
        return scheme === "file:" || scheme === "ftp:" || scheme === "http:" || scheme === "https:" || scheme === "ws:" || scheme === "wss:";
      }
      function extractProtocol(address, location2) {
        address = trimLeft(address);
        address = address.replace(CRHTLF, "");
        location2 = location2 || {};
        var match2 = protocolre.exec(address);
        var protocol = match2[1] ? match2[1].toLowerCase() : "";
        var forwardSlashes = !!match2[2];
        var otherSlashes = !!match2[3];
        var slashesCount = 0;
        var rest;
        if (forwardSlashes) {
          if (otherSlashes) {
            rest = match2[2] + match2[3] + match2[4];
            slashesCount = match2[2].length + match2[3].length;
          } else {
            rest = match2[2] + match2[4];
            slashesCount = match2[2].length;
          }
        } else {
          if (otherSlashes) {
            rest = match2[3] + match2[4];
            slashesCount = match2[3].length;
          } else {
            rest = match2[4];
          }
        }
        if (protocol === "file:") {
          if (slashesCount >= 2) {
            rest = rest.slice(2);
          }
        } else if (isSpecial(protocol)) {
          rest = match2[4];
        } else if (protocol) {
          if (forwardSlashes) {
            rest = rest.slice(2);
          }
        } else if (slashesCount >= 2 && isSpecial(location2.protocol)) {
          rest = match2[4];
        }
        return {
          protocol,
          slashes: forwardSlashes || isSpecial(protocol),
          slashesCount,
          rest
        };
      }
      function resolve(relative, base) {
        if (relative === "") return base;
        var path = (base || "/").split("/").slice(0, -1).concat(relative.split("/")), i = path.length, last = path[i - 1], unshift = false, up = 0;
        while (i--) {
          if (path[i] === ".") {
            path.splice(i, 1);
          } else if (path[i] === "..") {
            path.splice(i, 1);
            up++;
          } else if (up) {
            if (i === 0) unshift = true;
            path.splice(i, 1);
            up--;
          }
        }
        if (unshift) path.unshift("");
        if (last === "." || last === "..") path.push("");
        return path.join("/");
      }
      function Url(address, location2, parser) {
        address = trimLeft(address);
        address = address.replace(CRHTLF, "");
        if (!(this instanceof Url)) {
          return new Url(address, location2, parser);
        }
        var relative, extracted, parse3, instruction, index, key, instructions = rules.slice(), type = typeof location2, url = this, i = 0;
        if ("object" !== type && "string" !== type) {
          parser = location2;
          location2 = null;
        }
        if (parser && "function" !== typeof parser) parser = qs.parse;
        location2 = lolcation(location2);
        extracted = extractProtocol(address || "", location2);
        relative = !extracted.protocol && !extracted.slashes;
        url.slashes = extracted.slashes || relative && location2.slashes;
        url.protocol = extracted.protocol || location2.protocol || "";
        address = extracted.rest;
        if (extracted.protocol === "file:" && (extracted.slashesCount !== 2 || windowsDriveLetter.test(address)) || !extracted.slashes && (extracted.protocol || extracted.slashesCount < 2 || !isSpecial(url.protocol))) {
          instructions[3] = [/(.*)/, "pathname"];
        }
        for (; i < instructions.length; i++) {
          instruction = instructions[i];
          if (typeof instruction === "function") {
            address = instruction(address, url);
            continue;
          }
          parse3 = instruction[0];
          key = instruction[1];
          if (parse3 !== parse3) {
            url[key] = address;
          } else if ("string" === typeof parse3) {
            index = parse3 === "@" ? address.lastIndexOf(parse3) : address.indexOf(parse3);
            if (~index) {
              if ("number" === typeof instruction[2]) {
                url[key] = address.slice(0, index);
                address = address.slice(index + instruction[2]);
              } else {
                url[key] = address.slice(index);
                address = address.slice(0, index);
              }
            }
          } else if (index = parse3.exec(address)) {
            url[key] = index[1];
            address = address.slice(0, index.index);
          }
          url[key] = url[key] || (relative && instruction[3] ? location2[key] || "" : "");
          if (instruction[4]) url[key] = url[key].toLowerCase();
        }
        if (parser) url.query = parser(url.query);
        if (relative && location2.slashes && url.pathname.charAt(0) !== "/" && (url.pathname !== "" || location2.pathname !== "")) {
          url.pathname = resolve(url.pathname, location2.pathname);
        }
        if (url.pathname.charAt(0) !== "/" && isSpecial(url.protocol)) {
          url.pathname = "/" + url.pathname;
        }
        if (!required(url.port, url.protocol)) {
          url.host = url.hostname;
          url.port = "";
        }
        url.username = url.password = "";
        if (url.auth) {
          index = url.auth.indexOf(":");
          if (~index) {
            url.username = url.auth.slice(0, index);
            url.username = encodeURIComponent(decodeURIComponent(url.username));
            url.password = url.auth.slice(index + 1);
            url.password = encodeURIComponent(decodeURIComponent(url.password));
          } else {
            url.username = encodeURIComponent(decodeURIComponent(url.auth));
          }
          url.auth = url.password ? url.username + ":" + url.password : url.username;
        }
        url.origin = url.protocol !== "file:" && isSpecial(url.protocol) && url.host ? url.protocol + "//" + url.host : "null";
        url.href = url.toString();
      }
      function set(part, value, fn) {
        var url = this;
        switch (part) {
          case "query":
            if ("string" === typeof value && value.length) {
              value = (fn || qs.parse)(value);
            }
            url[part] = value;
            break;
          case "port":
            url[part] = value;
            if (!required(value, url.protocol)) {
              url.host = url.hostname;
              url[part] = "";
            } else if (value) {
              url.host = url.hostname + ":" + value;
            }
            break;
          case "hostname":
            url[part] = value;
            if (url.port) value += ":" + url.port;
            url.host = value;
            break;
          case "host":
            url[part] = value;
            if (port.test(value)) {
              value = value.split(":");
              url.port = value.pop();
              url.hostname = value.join(":");
            } else {
              url.hostname = value;
              url.port = "";
            }
            break;
          case "protocol":
            url.protocol = value.toLowerCase();
            url.slashes = !fn;
            break;
          case "pathname":
          case "hash":
            if (value) {
              var char = part === "pathname" ? "/" : "#";
              url[part] = value.charAt(0) !== char ? char + value : value;
            } else {
              url[part] = value;
            }
            break;
          case "username":
          case "password":
            url[part] = encodeURIComponent(value);
            break;
          case "auth":
            var index = value.indexOf(":");
            if (~index) {
              url.username = value.slice(0, index);
              url.username = encodeURIComponent(decodeURIComponent(url.username));
              url.password = value.slice(index + 1);
              url.password = encodeURIComponent(decodeURIComponent(url.password));
            } else {
              url.username = encodeURIComponent(decodeURIComponent(value));
            }
        }
        for (var i = 0; i < rules.length; i++) {
          var ins = rules[i];
          if (ins[4]) url[ins[1]] = url[ins[1]].toLowerCase();
        }
        url.auth = url.password ? url.username + ":" + url.password : url.username;
        url.origin = url.protocol !== "file:" && isSpecial(url.protocol) && url.host ? url.protocol + "//" + url.host : "null";
        url.href = url.toString();
        return url;
      }
      function toString(stringify) {
        if (!stringify || "function" !== typeof stringify) stringify = qs.stringify;
        var query, url = this, host = url.host, protocol = url.protocol;
        if (protocol && protocol.charAt(protocol.length - 1) !== ":") protocol += ":";
        var result = protocol + (url.protocol && url.slashes || isSpecial(url.protocol) ? "//" : "");
        if (url.username) {
          result += url.username;
          if (url.password) result += ":" + url.password;
          result += "@";
        } else if (url.password) {
          result += ":" + url.password;
          result += "@";
        } else if (url.protocol !== "file:" && isSpecial(url.protocol) && !host && url.pathname !== "/") {
          result += "@";
        }
        if (host[host.length - 1] === ":" || port.test(url.hostname) && !url.port) {
          host += ":";
        }
        result += host + url.pathname;
        query = "object" === typeof url.query ? stringify(url.query) : url.query;
        if (query) result += "?" !== query.charAt(0) ? "?" + query : query;
        if (url.hash) result += url.hash;
        return result;
      }
      Url.prototype = { set, toString };
      Url.extractProtocol = extractProtocol;
      Url.location = lolcation;
      Url.trimLeft = trimLeft;
      Url.qs = qs;
      module.exports = Url;
    }
  });
  var require_rules = __commonJS3({
    "node_modules/psl/data/rules.json"(exports, module) {
      module.exports = [
        "ac",
        "com.ac",
        "edu.ac",
        "gov.ac",
        "net.ac",
        "mil.ac",
        "org.ac",
        "ad",
        "nom.ad",
        "ae",
        "co.ae",
        "net.ae",
        "org.ae",
        "sch.ae",
        "ac.ae",
        "gov.ae",
        "mil.ae",
        "aero",
        "accident-investigation.aero",
        "accident-prevention.aero",
        "aerobatic.aero",
        "aeroclub.aero",
        "aerodrome.aero",
        "agents.aero",
        "aircraft.aero",
        "airline.aero",
        "airport.aero",
        "air-surveillance.aero",
        "airtraffic.aero",
        "air-traffic-control.aero",
        "ambulance.aero",
        "amusement.aero",
        "association.aero",
        "author.aero",
        "ballooning.aero",
        "broker.aero",
        "caa.aero",
        "cargo.aero",
        "catering.aero",
        "certification.aero",
        "championship.aero",
        "charter.aero",
        "civilaviation.aero",
        "club.aero",
        "conference.aero",
        "consultant.aero",
        "consulting.aero",
        "control.aero",
        "council.aero",
        "crew.aero",
        "design.aero",
        "dgca.aero",
        "educator.aero",
        "emergency.aero",
        "engine.aero",
        "engineer.aero",
        "entertainment.aero",
        "equipment.aero",
        "exchange.aero",
        "express.aero",
        "federation.aero",
        "flight.aero",
        "fuel.aero",
        "gliding.aero",
        "government.aero",
        "groundhandling.aero",
        "group.aero",
        "hanggliding.aero",
        "homebuilt.aero",
        "insurance.aero",
        "journal.aero",
        "journalist.aero",
        "leasing.aero",
        "logistics.aero",
        "magazine.aero",
        "maintenance.aero",
        "media.aero",
        "microlight.aero",
        "modelling.aero",
        "navigation.aero",
        "parachuting.aero",
        "paragliding.aero",
        "passenger-association.aero",
        "pilot.aero",
        "press.aero",
        "production.aero",
        "recreation.aero",
        "repbody.aero",
        "res.aero",
        "research.aero",
        "rotorcraft.aero",
        "safety.aero",
        "scientist.aero",
        "services.aero",
        "show.aero",
        "skydiving.aero",
        "software.aero",
        "student.aero",
        "trader.aero",
        "trading.aero",
        "trainer.aero",
        "union.aero",
        "workinggroup.aero",
        "works.aero",
        "af",
        "gov.af",
        "com.af",
        "org.af",
        "net.af",
        "edu.af",
        "ag",
        "com.ag",
        "org.ag",
        "net.ag",
        "co.ag",
        "nom.ag",
        "ai",
        "off.ai",
        "com.ai",
        "net.ai",
        "org.ai",
        "al",
        "com.al",
        "edu.al",
        "gov.al",
        "mil.al",
        "net.al",
        "org.al",
        "am",
        "co.am",
        "com.am",
        "commune.am",
        "net.am",
        "org.am",
        "ao",
        "ed.ao",
        "gv.ao",
        "og.ao",
        "co.ao",
        "pb.ao",
        "it.ao",
        "aq",
        "ar",
        "bet.ar",
        "com.ar",
        "coop.ar",
        "edu.ar",
        "gob.ar",
        "gov.ar",
        "int.ar",
        "mil.ar",
        "musica.ar",
        "mutual.ar",
        "net.ar",
        "org.ar",
        "senasa.ar",
        "tur.ar",
        "arpa",
        "e164.arpa",
        "in-addr.arpa",
        "ip6.arpa",
        "iris.arpa",
        "uri.arpa",
        "urn.arpa",
        "as",
        "gov.as",
        "asia",
        "at",
        "ac.at",
        "co.at",
        "gv.at",
        "or.at",
        "sth.ac.at",
        "au",
        "com.au",
        "net.au",
        "org.au",
        "edu.au",
        "gov.au",
        "asn.au",
        "id.au",
        "info.au",
        "conf.au",
        "oz.au",
        "act.au",
        "nsw.au",
        "nt.au",
        "qld.au",
        "sa.au",
        "tas.au",
        "vic.au",
        "wa.au",
        "act.edu.au",
        "catholic.edu.au",
        "nsw.edu.au",
        "nt.edu.au",
        "qld.edu.au",
        "sa.edu.au",
        "tas.edu.au",
        "vic.edu.au",
        "wa.edu.au",
        "qld.gov.au",
        "sa.gov.au",
        "tas.gov.au",
        "vic.gov.au",
        "wa.gov.au",
        "schools.nsw.edu.au",
        "aw",
        "com.aw",
        "ax",
        "az",
        "com.az",
        "net.az",
        "int.az",
        "gov.az",
        "org.az",
        "edu.az",
        "info.az",
        "pp.az",
        "mil.az",
        "name.az",
        "pro.az",
        "biz.az",
        "ba",
        "com.ba",
        "edu.ba",
        "gov.ba",
        "mil.ba",
        "net.ba",
        "org.ba",
        "bb",
        "biz.bb",
        "co.bb",
        "com.bb",
        "edu.bb",
        "gov.bb",
        "info.bb",
        "net.bb",
        "org.bb",
        "store.bb",
        "tv.bb",
        "*.bd",
        "be",
        "ac.be",
        "bf",
        "gov.bf",
        "bg",
        "a.bg",
        "b.bg",
        "c.bg",
        "d.bg",
        "e.bg",
        "f.bg",
        "g.bg",
        "h.bg",
        "i.bg",
        "j.bg",
        "k.bg",
        "l.bg",
        "m.bg",
        "n.bg",
        "o.bg",
        "p.bg",
        "q.bg",
        "r.bg",
        "s.bg",
        "t.bg",
        "u.bg",
        "v.bg",
        "w.bg",
        "x.bg",
        "y.bg",
        "z.bg",
        "0.bg",
        "1.bg",
        "2.bg",
        "3.bg",
        "4.bg",
        "5.bg",
        "6.bg",
        "7.bg",
        "8.bg",
        "9.bg",
        "bh",
        "com.bh",
        "edu.bh",
        "net.bh",
        "org.bh",
        "gov.bh",
        "bi",
        "co.bi",
        "com.bi",
        "edu.bi",
        "or.bi",
        "org.bi",
        "biz",
        "bj",
        "asso.bj",
        "barreau.bj",
        "gouv.bj",
        "bm",
        "com.bm",
        "edu.bm",
        "gov.bm",
        "net.bm",
        "org.bm",
        "bn",
        "com.bn",
        "edu.bn",
        "gov.bn",
        "net.bn",
        "org.bn",
        "bo",
        "com.bo",
        "edu.bo",
        "gob.bo",
        "int.bo",
        "org.bo",
        "net.bo",
        "mil.bo",
        "tv.bo",
        "web.bo",
        "academia.bo",
        "agro.bo",
        "arte.bo",
        "blog.bo",
        "bolivia.bo",
        "ciencia.bo",
        "cooperativa.bo",
        "democracia.bo",
        "deporte.bo",
        "ecologia.bo",
        "economia.bo",
        "empresa.bo",
        "indigena.bo",
        "industria.bo",
        "info.bo",
        "medicina.bo",
        "movimiento.bo",
        "musica.bo",
        "natural.bo",
        "nombre.bo",
        "noticias.bo",
        "patria.bo",
        "politica.bo",
        "profesional.bo",
        "plurinacional.bo",
        "pueblo.bo",
        "revista.bo",
        "salud.bo",
        "tecnologia.bo",
        "tksat.bo",
        "transporte.bo",
        "wiki.bo",
        "br",
        "9guacu.br",
        "abc.br",
        "adm.br",
        "adv.br",
        "agr.br",
        "aju.br",
        "am.br",
        "anani.br",
        "aparecida.br",
        "app.br",
        "arq.br",
        "art.br",
        "ato.br",
        "b.br",
        "barueri.br",
        "belem.br",
        "bhz.br",
        "bib.br",
        "bio.br",
        "blog.br",
        "bmd.br",
        "boavista.br",
        "bsb.br",
        "campinagrande.br",
        "campinas.br",
        "caxias.br",
        "cim.br",
        "cng.br",
        "cnt.br",
        "com.br",
        "contagem.br",
        "coop.br",
        "coz.br",
        "cri.br",
        "cuiaba.br",
        "curitiba.br",
        "def.br",
        "des.br",
        "det.br",
        "dev.br",
        "ecn.br",
        "eco.br",
        "edu.br",
        "emp.br",
        "enf.br",
        "eng.br",
        "esp.br",
        "etc.br",
        "eti.br",
        "far.br",
        "feira.br",
        "flog.br",
        "floripa.br",
        "fm.br",
        "fnd.br",
        "fortal.br",
        "fot.br",
        "foz.br",
        "fst.br",
        "g12.br",
        "geo.br",
        "ggf.br",
        "goiania.br",
        "gov.br",
        "ac.gov.br",
        "al.gov.br",
        "am.gov.br",
        "ap.gov.br",
        "ba.gov.br",
        "ce.gov.br",
        "df.gov.br",
        "es.gov.br",
        "go.gov.br",
        "ma.gov.br",
        "mg.gov.br",
        "ms.gov.br",
        "mt.gov.br",
        "pa.gov.br",
        "pb.gov.br",
        "pe.gov.br",
        "pi.gov.br",
        "pr.gov.br",
        "rj.gov.br",
        "rn.gov.br",
        "ro.gov.br",
        "rr.gov.br",
        "rs.gov.br",
        "sc.gov.br",
        "se.gov.br",
        "sp.gov.br",
        "to.gov.br",
        "gru.br",
        "imb.br",
        "ind.br",
        "inf.br",
        "jab.br",
        "jampa.br",
        "jdf.br",
        "joinville.br",
        "jor.br",
        "jus.br",
        "leg.br",
        "lel.br",
        "log.br",
        "londrina.br",
        "macapa.br",
        "maceio.br",
        "manaus.br",
        "maringa.br",
        "mat.br",
        "med.br",
        "mil.br",
        "morena.br",
        "mp.br",
        "mus.br",
        "natal.br",
        "net.br",
        "niteroi.br",
        "*.nom.br",
        "not.br",
        "ntr.br",
        "odo.br",
        "ong.br",
        "org.br",
        "osasco.br",
        "palmas.br",
        "poa.br",
        "ppg.br",
        "pro.br",
        "psc.br",
        "psi.br",
        "pvh.br",
        "qsl.br",
        "radio.br",
        "rec.br",
        "recife.br",
        "rep.br",
        "ribeirao.br",
        "rio.br",
        "riobranco.br",
        "riopreto.br",
        "salvador.br",
        "sampa.br",
        "santamaria.br",
        "santoandre.br",
        "saobernardo.br",
        "saogonca.br",
        "seg.br",
        "sjc.br",
        "slg.br",
        "slz.br",
        "sorocaba.br",
        "srv.br",
        "taxi.br",
        "tc.br",
        "tec.br",
        "teo.br",
        "the.br",
        "tmp.br",
        "trd.br",
        "tur.br",
        "tv.br",
        "udi.br",
        "vet.br",
        "vix.br",
        "vlog.br",
        "wiki.br",
        "zlg.br",
        "bs",
        "com.bs",
        "net.bs",
        "org.bs",
        "edu.bs",
        "gov.bs",
        "bt",
        "com.bt",
        "edu.bt",
        "gov.bt",
        "net.bt",
        "org.bt",
        "bv",
        "bw",
        "co.bw",
        "org.bw",
        "by",
        "gov.by",
        "mil.by",
        "com.by",
        "of.by",
        "bz",
        "com.bz",
        "net.bz",
        "org.bz",
        "edu.bz",
        "gov.bz",
        "ca",
        "ab.ca",
        "bc.ca",
        "mb.ca",
        "nb.ca",
        "nf.ca",
        "nl.ca",
        "ns.ca",
        "nt.ca",
        "nu.ca",
        "on.ca",
        "pe.ca",
        "qc.ca",
        "sk.ca",
        "yk.ca",
        "gc.ca",
        "cat",
        "cc",
        "cd",
        "gov.cd",
        "cf",
        "cg",
        "ch",
        "ci",
        "org.ci",
        "or.ci",
        "com.ci",
        "co.ci",
        "edu.ci",
        "ed.ci",
        "ac.ci",
        "net.ci",
        "go.ci",
        "asso.ci",
        "a\xE9roport.ci",
        "int.ci",
        "presse.ci",
        "md.ci",
        "gouv.ci",
        "*.ck",
        "!www.ck",
        "cl",
        "co.cl",
        "gob.cl",
        "gov.cl",
        "mil.cl",
        "cm",
        "co.cm",
        "com.cm",
        "gov.cm",
        "net.cm",
        "cn",
        "ac.cn",
        "com.cn",
        "edu.cn",
        "gov.cn",
        "net.cn",
        "org.cn",
        "mil.cn",
        "\u516C\u53F8.cn",
        "\u7F51\u7EDC.cn",
        "\u7DB2\u7D61.cn",
        "ah.cn",
        "bj.cn",
        "cq.cn",
        "fj.cn",
        "gd.cn",
        "gs.cn",
        "gz.cn",
        "gx.cn",
        "ha.cn",
        "hb.cn",
        "he.cn",
        "hi.cn",
        "hl.cn",
        "hn.cn",
        "jl.cn",
        "js.cn",
        "jx.cn",
        "ln.cn",
        "nm.cn",
        "nx.cn",
        "qh.cn",
        "sc.cn",
        "sd.cn",
        "sh.cn",
        "sn.cn",
        "sx.cn",
        "tj.cn",
        "xj.cn",
        "xz.cn",
        "yn.cn",
        "zj.cn",
        "hk.cn",
        "mo.cn",
        "tw.cn",
        "co",
        "arts.co",
        "com.co",
        "edu.co",
        "firm.co",
        "gov.co",
        "info.co",
        "int.co",
        "mil.co",
        "net.co",
        "nom.co",
        "org.co",
        "rec.co",
        "web.co",
        "com",
        "coop",
        "cr",
        "ac.cr",
        "co.cr",
        "ed.cr",
        "fi.cr",
        "go.cr",
        "or.cr",
        "sa.cr",
        "cu",
        "com.cu",
        "edu.cu",
        "org.cu",
        "net.cu",
        "gov.cu",
        "inf.cu",
        "cv",
        "com.cv",
        "edu.cv",
        "int.cv",
        "nome.cv",
        "org.cv",
        "cw",
        "com.cw",
        "edu.cw",
        "net.cw",
        "org.cw",
        "cx",
        "gov.cx",
        "cy",
        "ac.cy",
        "biz.cy",
        "com.cy",
        "ekloges.cy",
        "gov.cy",
        "ltd.cy",
        "mil.cy",
        "net.cy",
        "org.cy",
        "press.cy",
        "pro.cy",
        "tm.cy",
        "cz",
        "de",
        "dj",
        "dk",
        "dm",
        "com.dm",
        "net.dm",
        "org.dm",
        "edu.dm",
        "gov.dm",
        "do",
        "art.do",
        "com.do",
        "edu.do",
        "gob.do",
        "gov.do",
        "mil.do",
        "net.do",
        "org.do",
        "sld.do",
        "web.do",
        "dz",
        "art.dz",
        "asso.dz",
        "com.dz",
        "edu.dz",
        "gov.dz",
        "org.dz",
        "net.dz",
        "pol.dz",
        "soc.dz",
        "tm.dz",
        "ec",
        "com.ec",
        "info.ec",
        "net.ec",
        "fin.ec",
        "k12.ec",
        "med.ec",
        "pro.ec",
        "org.ec",
        "edu.ec",
        "gov.ec",
        "gob.ec",
        "mil.ec",
        "edu",
        "ee",
        "edu.ee",
        "gov.ee",
        "riik.ee",
        "lib.ee",
        "med.ee",
        "com.ee",
        "pri.ee",
        "aip.ee",
        "org.ee",
        "fie.ee",
        "eg",
        "com.eg",
        "edu.eg",
        "eun.eg",
        "gov.eg",
        "mil.eg",
        "name.eg",
        "net.eg",
        "org.eg",
        "sci.eg",
        "*.er",
        "es",
        "com.es",
        "nom.es",
        "org.es",
        "gob.es",
        "edu.es",
        "et",
        "com.et",
        "gov.et",
        "org.et",
        "edu.et",
        "biz.et",
        "name.et",
        "info.et",
        "net.et",
        "eu",
        "fi",
        "aland.fi",
        "fj",
        "ac.fj",
        "biz.fj",
        "com.fj",
        "gov.fj",
        "info.fj",
        "mil.fj",
        "name.fj",
        "net.fj",
        "org.fj",
        "pro.fj",
        "*.fk",
        "com.fm",
        "edu.fm",
        "net.fm",
        "org.fm",
        "fm",
        "fo",
        "fr",
        "asso.fr",
        "com.fr",
        "gouv.fr",
        "nom.fr",
        "prd.fr",
        "tm.fr",
        "aeroport.fr",
        "avocat.fr",
        "avoues.fr",
        "cci.fr",
        "chambagri.fr",
        "chirurgiens-dentistes.fr",
        "experts-comptables.fr",
        "geometre-expert.fr",
        "greta.fr",
        "huissier-justice.fr",
        "medecin.fr",
        "notaires.fr",
        "pharmacien.fr",
        "port.fr",
        "veterinaire.fr",
        "ga",
        "gb",
        "edu.gd",
        "gov.gd",
        "gd",
        "ge",
        "com.ge",
        "edu.ge",
        "gov.ge",
        "org.ge",
        "mil.ge",
        "net.ge",
        "pvt.ge",
        "gf",
        "gg",
        "co.gg",
        "net.gg",
        "org.gg",
        "gh",
        "com.gh",
        "edu.gh",
        "gov.gh",
        "org.gh",
        "mil.gh",
        "gi",
        "com.gi",
        "ltd.gi",
        "gov.gi",
        "mod.gi",
        "edu.gi",
        "org.gi",
        "gl",
        "co.gl",
        "com.gl",
        "edu.gl",
        "net.gl",
        "org.gl",
        "gm",
        "gn",
        "ac.gn",
        "com.gn",
        "edu.gn",
        "gov.gn",
        "org.gn",
        "net.gn",
        "gov",
        "gp",
        "com.gp",
        "net.gp",
        "mobi.gp",
        "edu.gp",
        "org.gp",
        "asso.gp",
        "gq",
        "gr",
        "com.gr",
        "edu.gr",
        "net.gr",
        "org.gr",
        "gov.gr",
        "gs",
        "gt",
        "com.gt",
        "edu.gt",
        "gob.gt",
        "ind.gt",
        "mil.gt",
        "net.gt",
        "org.gt",
        "gu",
        "com.gu",
        "edu.gu",
        "gov.gu",
        "guam.gu",
        "info.gu",
        "net.gu",
        "org.gu",
        "web.gu",
        "gw",
        "gy",
        "co.gy",
        "com.gy",
        "edu.gy",
        "gov.gy",
        "net.gy",
        "org.gy",
        "hk",
        "com.hk",
        "edu.hk",
        "gov.hk",
        "idv.hk",
        "net.hk",
        "org.hk",
        "\u516C\u53F8.hk",
        "\u6559\u80B2.hk",
        "\u654E\u80B2.hk",
        "\u653F\u5E9C.hk",
        "\u500B\u4EBA.hk",
        "\u4E2A\uFFFD\uFFFD.hk",
        "\u7B87\u4EBA.hk",
        "\u7DB2\u7EDC.hk",
        "\u7F51\u7EDC.hk",
        "\u7EC4\u7E54.hk",
        "\u7DB2\u7D61.hk",
        "\u7F51\u7D61.hk",
        "\u7EC4\u7EC7.hk",
        "\u7D44\u7E54.hk",
        "\u7D44\u7EC7.hk",
        "hm",
        "hn",
        "com.hn",
        "edu.hn",
        "org.hn",
        "net.hn",
        "mil.hn",
        "gob.hn",
        "hr",
        "iz.hr",
        "from.hr",
        "name.hr",
        "com.hr",
        "ht",
        "com.ht",
        "shop.ht",
        "firm.ht",
        "info.ht",
        "adult.ht",
        "net.ht",
        "pro.ht",
        "org.ht",
        "med.ht",
        "art.ht",
        "coop.ht",
        "pol.ht",
        "asso.ht",
        "edu.ht",
        "rel.ht",
        "gouv.ht",
        "perso.ht",
        "hu",
        "co.hu",
        "info.hu",
        "org.hu",
        "priv.hu",
        "sport.hu",
        "tm.hu",
        "2000.hu",
        "agrar.hu",
        "bolt.hu",
        "casino.hu",
        "city.hu",
        "erotica.hu",
        "erotika.hu",
        "film.hu",
        "forum.hu",
        "games.hu",
        "hotel.hu",
        "ingatlan.hu",
        "jogasz.hu",
        "konyvelo.hu",
        "lakas.hu",
        "media.hu",
        "news.hu",
        "reklam.hu",
        "sex.hu",
        "shop.hu",
        "suli.hu",
        "szex.hu",
        "tozsde.hu",
        "utazas.hu",
        "video.hu",
        "id",
        "ac.id",
        "biz.id",
        "co.id",
        "desa.id",
        "go.id",
        "mil.id",
        "my.id",
        "net.id",
        "or.id",
        "ponpes.id",
        "sch.id",
        "web.id",
        "ie",
        "gov.ie",
        "il",
        "ac.il",
        "co.il",
        "gov.il",
        "idf.il",
        "k12.il",
        "muni.il",
        "net.il",
        "org.il",
        "im",
        "ac.im",
        "co.im",
        "com.im",
        "ltd.co.im",
        "net.im",
        "org.im",
        "plc.co.im",
        "tt.im",
        "tv.im",
        "in",
        "co.in",
        "firm.in",
        "net.in",
        "org.in",
        "gen.in",
        "ind.in",
        "nic.in",
        "ac.in",
        "edu.in",
        "res.in",
        "gov.in",
        "mil.in",
        "info",
        "int",
        "eu.int",
        "io",
        "com.io",
        "iq",
        "gov.iq",
        "edu.iq",
        "mil.iq",
        "com.iq",
        "org.iq",
        "net.iq",
        "ir",
        "ac.ir",
        "co.ir",
        "gov.ir",
        "id.ir",
        "net.ir",
        "org.ir",
        "sch.ir",
        "\u0627\u06CC\u0631\u0627\u0646.ir",
        "\u0627\u064A\u0631\u0627\u0646.ir",
        "is",
        "net.is",
        "com.is",
        "edu.is",
        "gov.is",
        "org.is",
        "int.is",
        "it",
        "gov.it",
        "edu.it",
        "abr.it",
        "abruzzo.it",
        "aosta-valley.it",
        "aostavalley.it",
        "bas.it",
        "basilicata.it",
        "cal.it",
        "calabria.it",
        "cam.it",
        "campania.it",
        "emilia-romagna.it",
        "emiliaromagna.it",
        "emr.it",
        "friuli-v-giulia.it",
        "friuli-ve-giulia.it",
        "friuli-vegiulia.it",
        "friuli-venezia-giulia.it",
        "friuli-veneziagiulia.it",
        "friuli-vgiulia.it",
        "friuliv-giulia.it",
        "friulive-giulia.it",
        "friulivegiulia.it",
        "friulivenezia-giulia.it",
        "friuliveneziagiulia.it",
        "friulivgiulia.it",
        "fvg.it",
        "laz.it",
        "lazio.it",
        "lig.it",
        "liguria.it",
        "lom.it",
        "lombardia.it",
        "lombardy.it",
        "lucania.it",
        "mar.it",
        "marche.it",
        "mol.it",
        "molise.it",
        "piedmont.it",
        "piemonte.it",
        "pmn.it",
        "pug.it",
        "puglia.it",
        "sar.it",
        "sardegna.it",
        "sardinia.it",
        "sic.it",
        "sicilia.it",
        "sicily.it",
        "taa.it",
        "tos.it",
        "toscana.it",
        "trentin-sud-tirol.it",
        "trentin-s\xFCd-tirol.it",
        "trentin-sudtirol.it",
        "trentin-s\xFCdtirol.it",
        "trentin-sued-tirol.it",
        "trentin-suedtirol.it",
        "trentino-a-adige.it",
        "trentino-aadige.it",
        "trentino-alto-adige.it",
        "trentino-altoadige.it",
        "trentino-s-tirol.it",
        "trentino-stirol.it",
        "trentino-sud-tirol.it",
        "trentino-s\xFCd-tirol.it",
        "trentino-sudtirol.it",
        "trentino-s\xFCdtirol.it",
        "trentino-sued-tirol.it",
        "trentino-suedtirol.it",
        "trentino.it",
        "trentinoa-adige.it",
        "trentinoaadige.it",
        "trentinoalto-adige.it",
        "trentinoaltoadige.it",
        "trentinos-tirol.it",
        "trentinostirol.it",
        "trentinosud-tirol.it",
        "trentinos\xFCd-tirol.it",
        "trentinosudtirol.it",
        "trentinos\xFCdtirol.it",
        "trentinosued-tirol.it",
        "trentinosuedtirol.it",
        "trentinsud-tirol.it",
        "trentins\xFCd-tirol.it",
        "trentinsudtirol.it",
        "trentins\xFCdtirol.it",
        "trentinsued-tirol.it",
        "trentinsuedtirol.it",
        "tuscany.it",
        "umb.it",
        "umbria.it",
        "val-d-aosta.it",
        "val-daosta.it",
        "vald-aosta.it",
        "valdaosta.it",
        "valle-aosta.it",
        "valle-d-aosta.it",
        "valle-daosta.it",
        "valleaosta.it",
        "valled-aosta.it",
        "valledaosta.it",
        "vallee-aoste.it",
        "vall\xE9e-aoste.it",
        "vallee-d-aoste.it",
        "vall\xE9e-d-aoste.it",
        "valleeaoste.it",
        "vall\xE9eaoste.it",
        "valleedaoste.it",
        "vall\xE9edaoste.it",
        "vao.it",
        "vda.it",
        "ven.it",
        "veneto.it",
        "ag.it",
        "agrigento.it",
        "al.it",
        "alessandria.it",
        "alto-adige.it",
        "altoadige.it",
        "an.it",
        "ancona.it",
        "andria-barletta-trani.it",
        "andria-trani-barletta.it",
        "andriabarlettatrani.it",
        "andriatranibarletta.it",
        "ao.it",
        "aosta.it",
        "aoste.it",
        "ap.it",
        "aq.it",
        "aquila.it",
        "ar.it",
        "arezzo.it",
        "ascoli-piceno.it",
        "ascolipiceno.it",
        "asti.it",
        "at.it",
        "av.it",
        "avellino.it",
        "ba.it",
        "balsan-sudtirol.it",
        "balsan-s\xFCdtirol.it",
        "balsan-suedtirol.it",
        "balsan.it",
        "bari.it",
        "barletta-trani-andria.it",
        "barlettatraniandria.it",
        "belluno.it",
        "benevento.it",
        "bergamo.it",
        "bg.it",
        "bi.it",
        "biella.it",
        "bl.it",
        "bn.it",
        "bo.it",
        "bologna.it",
        "bolzano-altoadige.it",
        "bolzano.it",
        "bozen-sudtirol.it",
        "bozen-s\xFCdtirol.it",
        "bozen-suedtirol.it",
        "bozen.it",
        "br.it",
        "brescia.it",
        "brindisi.it",
        "bs.it",
        "bt.it",
        "bulsan-sudtirol.it",
        "bulsan-s\xFCdtirol.it",
        "bulsan-suedtirol.it",
        "bulsan.it",
        "bz.it",
        "ca.it",
        "cagliari.it",
        "caltanissetta.it",
        "campidano-medio.it",
        "campidanomedio.it",
        "campobasso.it",
        "carbonia-iglesias.it",
        "carboniaiglesias.it",
        "carrara-massa.it",
        "carraramassa.it",
        "caserta.it",
        "catania.it",
        "catanzaro.it",
        "cb.it",
        "ce.it",
        "cesena-forli.it",
        "cesena-forl\xEC.it",
        "cesenaforli.it",
        "cesenaforl\xEC.it",
        "ch.it",
        "chieti.it",
        "ci.it",
        "cl.it",
        "cn.it",
        "co.it",
        "como.it",
        "cosenza.it",
        "cr.it",
        "cremona.it",
        "crotone.it",
        "cs.it",
        "ct.it",
        "cuneo.it",
        "cz.it",
        "dell-ogliastra.it",
        "dellogliastra.it",
        "en.it",
        "enna.it",
        "fc.it",
        "fe.it",
        "fermo.it",
        "ferrara.it",
        "fg.it",
        "fi.it",
        "firenze.it",
        "florence.it",
        "fm.it",
        "foggia.it",
        "forli-cesena.it",
        "forl\xEC-cesena.it",
        "forlicesena.it",
        "forl\xECcesena.it",
        "fr.it",
        "frosinone.it",
        "ge.it",
        "genoa.it",
        "genova.it",
        "go.it",
        "gorizia.it",
        "gr.it",
        "grosseto.it",
        "iglesias-carbonia.it",
        "iglesiascarbonia.it",
        "im.it",
        "imperia.it",
        "is.it",
        "isernia.it",
        "kr.it",
        "la-spezia.it",
        "laquila.it",
        "laspezia.it",
        "latina.it",
        "lc.it",
        "le.it",
        "lecce.it",
        "lecco.it",
        "li.it",
        "livorno.it",
        "lo.it",
        "lodi.it",
        "lt.it",
        "lu.it",
        "lucca.it",
        "macerata.it",
        "mantova.it",
        "massa-carrara.it",
        "massacarrara.it",
        "matera.it",
        "mb.it",
        "mc.it",
        "me.it",
        "medio-campidano.it",
        "mediocampidano.it",
        "messina.it",
        "mi.it",
        "milan.it",
        "milano.it",
        "mn.it",
        "mo.it",
        "modena.it",
        "monza-brianza.it",
        "monza-e-della-brianza.it",
        "monza.it",
        "monzabrianza.it",
        "monzaebrianza.it",
        "monzaedellabrianza.it",
        "ms.it",
        "mt.it",
        "na.it",
        "naples.it",
        "napoli.it",
        "no.it",
        "novara.it",
        "nu.it",
        "nuoro.it",
        "og.it",
        "ogliastra.it",
        "olbia-tempio.it",
        "olbiatempio.it",
        "or.it",
        "oristano.it",
        "ot.it",
        "pa.it",
        "padova.it",
        "padua.it",
        "palermo.it",
        "parma.it",
        "pavia.it",
        "pc.it",
        "pd.it",
        "pe.it",
        "perugia.it",
        "pesaro-urbino.it",
        "pesarourbino.it",
        "pescara.it",
        "pg.it",
        "pi.it",
        "piacenza.it",
        "pisa.it",
        "pistoia.it",
        "pn.it",
        "po.it",
        "pordenone.it",
        "potenza.it",
        "pr.it",
        "prato.it",
        "pt.it",
        "pu.it",
        "pv.it",
        "pz.it",
        "ra.it",
        "ragusa.it",
        "ravenna.it",
        "rc.it",
        "re.it",
        "reggio-calabria.it",
        "reggio-emilia.it",
        "reggiocalabria.it",
        "reggioemilia.it",
        "rg.it",
        "ri.it",
        "rieti.it",
        "rimini.it",
        "rm.it",
        "rn.it",
        "ro.it",
        "roma.it",
        "rome.it",
        "rovigo.it",
        "sa.it",
        "salerno.it",
        "sassari.it",
        "savona.it",
        "si.it",
        "siena.it",
        "siracusa.it",
        "so.it",
        "sondrio.it",
        "sp.it",
        "sr.it",
        "ss.it",
        "suedtirol.it",
        "s\xFCdtirol.it",
        "sv.it",
        "ta.it",
        "taranto.it",
        "te.it",
        "tempio-olbia.it",
        "tempioolbia.it",
        "teramo.it",
        "terni.it",
        "tn.it",
        "to.it",
        "torino.it",
        "tp.it",
        "tr.it",
        "trani-andria-barletta.it",
        "trani-barletta-andria.it",
        "traniandriabarletta.it",
        "tranibarlettaandria.it",
        "trapani.it",
        "trento.it",
        "treviso.it",
        "trieste.it",
        "ts.it",
        "turin.it",
        "tv.it",
        "ud.it",
        "udine.it",
        "urbino-pesaro.it",
        "urbinopesaro.it",
        "va.it",
        "varese.it",
        "vb.it",
        "vc.it",
        "ve.it",
        "venezia.it",
        "venice.it",
        "verbania.it",
        "vercelli.it",
        "verona.it",
        "vi.it",
        "vibo-valentia.it",
        "vibovalentia.it",
        "vicenza.it",
        "viterbo.it",
        "vr.it",
        "vs.it",
        "vt.it",
        "vv.it",
        "je",
        "co.je",
        "net.je",
        "org.je",
        "*.jm",
        "jo",
        "com.jo",
        "org.jo",
        "net.jo",
        "edu.jo",
        "sch.jo",
        "gov.jo",
        "mil.jo",
        "name.jo",
        "jobs",
        "jp",
        "ac.jp",
        "ad.jp",
        "co.jp",
        "ed.jp",
        "go.jp",
        "gr.jp",
        "lg.jp",
        "ne.jp",
        "or.jp",
        "aichi.jp",
        "akita.jp",
        "aomori.jp",
        "chiba.jp",
        "ehime.jp",
        "fukui.jp",
        "fukuoka.jp",
        "fukushima.jp",
        "gifu.jp",
        "gunma.jp",
        "hiroshima.jp",
        "hokkaido.jp",
        "hyogo.jp",
        "ibaraki.jp",
        "ishikawa.jp",
        "iwate.jp",
        "kagawa.jp",
        "kagoshima.jp",
        "kanagawa.jp",
        "kochi.jp",
        "kumamoto.jp",
        "kyoto.jp",
        "mie.jp",
        "miyagi.jp",
        "miyazaki.jp",
        "nagano.jp",
        "nagasaki.jp",
        "nara.jp",
        "niigata.jp",
        "oita.jp",
        "okayama.jp",
        "okinawa.jp",
        "osaka.jp",
        "saga.jp",
        "saitama.jp",
        "shiga.jp",
        "shimane.jp",
        "shizuoka.jp",
        "tochigi.jp",
        "tokushima.jp",
        "tokyo.jp",
        "tottori.jp",
        "toyama.jp",
        "wakayama.jp",
        "yamagata.jp",
        "yamaguchi.jp",
        "yamanashi.jp",
        "\u6803\u6728.jp",
        "\u611B\u77E5.jp",
        "\u611B\u5A9B.jp",
        "\u5175\u5EAB.jp",
        "\u718A\u672C.jp",
        "\u8328\u57CE.jp",
        "\u5317\u6D77\u9053.jp",
        "\u5343\u8449.jp",
        "\u548C\u6B4C\u5C71.jp",
        "\u9577\u5D0E.jp",
        "\u9577\u91CE.jp",
        "\u65B0\u6F5F.jp",
        "\u9752\u68EE.jp",
        "\u9759\u5CA1.jp",
        "\u6771\u4EAC.jp",
        "\u77F3\u5DDD.jp",
        "\u57FC\u7389.jp",
        "\u4E09\u91CD.jp",
        "\u4EAC\u90FD.jp",
        "\u4F50\u8CC0.jp",
        "\u5927\u5206.jp",
        "\u5927\u962A.jp",
        "\u5948\u826F.jp",
        "\u5BAE\u57CE.jp",
        "\u5BAE\u5D0E.jp",
        "\u5BCC\u5C71.jp",
        "\u5C71\u53E3.jp",
        "\u5C71\u5F62.jp",
        "\u5C71\u68A8.jp",
        "\u5CA9\u624B.jp",
        "\u5C90\u961C.jp",
        "\u5CA1\u5C71.jp",
        "\u5CF6\u6839.jp",
        "\u5E83\u5CF6.jp",
        "\u5FB3\u5CF6.jp",
        "\u6C96\u7E04.jp",
        "\u6ECB\u8CC0.jp",
        "\u795E\u5948\u5DDD.jp",
        "\u798F\u4E95.jp",
        "\u798F\u5CA1.jp",
        "\u798F\u5CF6.jp",
        "\u79CB\u7530.jp",
        "\u7FA4\u99AC.jp",
        "\u9999\u5DDD.jp",
        "\u9AD8\u77E5.jp",
        "\u9CE5\u53D6.jp",
        "\u9E7F\u5150\u5CF6.jp",
        "*.kawasaki.jp",
        "*.kitakyushu.jp",
        "*.kobe.jp",
        "*.nagoya.jp",
        "*.sapporo.jp",
        "*.sendai.jp",
        "*.yokohama.jp",
        "!city.kawasaki.jp",
        "!city.kitakyushu.jp",
        "!city.kobe.jp",
        "!city.nagoya.jp",
        "!city.sapporo.jp",
        "!city.sendai.jp",
        "!city.yokohama.jp",
        "aisai.aichi.jp",
        "ama.aichi.jp",
        "anjo.aichi.jp",
        "asuke.aichi.jp",
        "chiryu.aichi.jp",
        "chita.aichi.jp",
        "fuso.aichi.jp",
        "gamagori.aichi.jp",
        "handa.aichi.jp",
        "hazu.aichi.jp",
        "hekinan.aichi.jp",
        "higashiura.aichi.jp",
        "ichinomiya.aichi.jp",
        "inazawa.aichi.jp",
        "inuyama.aichi.jp",
        "isshiki.aichi.jp",
        "iwakura.aichi.jp",
        "kanie.aichi.jp",
        "kariya.aichi.jp",
        "kasugai.aichi.jp",
        "kira.aichi.jp",
        "kiyosu.aichi.jp",
        "komaki.aichi.jp",
        "konan.aichi.jp",
        "kota.aichi.jp",
        "mihama.aichi.jp",
        "miyoshi.aichi.jp",
        "nishio.aichi.jp",
        "nisshin.aichi.jp",
        "obu.aichi.jp",
        "oguchi.aichi.jp",
        "oharu.aichi.jp",
        "okazaki.aichi.jp",
        "owariasahi.aichi.jp",
        "seto.aichi.jp",
        "shikatsu.aichi.jp",
        "shinshiro.aichi.jp",
        "shitara.aichi.jp",
        "tahara.aichi.jp",
        "takahama.aichi.jp",
        "tobishima.aichi.jp",
        "toei.aichi.jp",
        "togo.aichi.jp",
        "tokai.aichi.jp",
        "tokoname.aichi.jp",
        "toyoake.aichi.jp",
        "toyohashi.aichi.jp",
        "toyokawa.aichi.jp",
        "toyone.aichi.jp",
        "toyota.aichi.jp",
        "tsushima.aichi.jp",
        "yatomi.aichi.jp",
        "akita.akita.jp",
        "daisen.akita.jp",
        "fujisato.akita.jp",
        "gojome.akita.jp",
        "hachirogata.akita.jp",
        "happou.akita.jp",
        "higashinaruse.akita.jp",
        "honjo.akita.jp",
        "honjyo.akita.jp",
        "ikawa.akita.jp",
        "kamikoani.akita.jp",
        "kamioka.akita.jp",
        "katagami.akita.jp",
        "kazuno.akita.jp",
        "kitaakita.akita.jp",
        "kosaka.akita.jp",
        "kyowa.akita.jp",
        "misato.akita.jp",
        "mitane.akita.jp",
        "moriyoshi.akita.jp",
        "nikaho.akita.jp",
        "noshiro.akita.jp",
        "odate.akita.jp",
        "oga.akita.jp",
        "ogata.akita.jp",
        "semboku.akita.jp",
        "yokote.akita.jp",
        "yurihonjo.akita.jp",
        "aomori.aomori.jp",
        "gonohe.aomori.jp",
        "hachinohe.aomori.jp",
        "hashikami.aomori.jp",
        "hiranai.aomori.jp",
        "hirosaki.aomori.jp",
        "itayanagi.aomori.jp",
        "kuroishi.aomori.jp",
        "misawa.aomori.jp",
        "mutsu.aomori.jp",
        "nakadomari.aomori.jp",
        "noheji.aomori.jp",
        "oirase.aomori.jp",
        "owani.aomori.jp",
        "rokunohe.aomori.jp",
        "sannohe.aomori.jp",
        "shichinohe.aomori.jp",
        "shingo.aomori.jp",
        "takko.aomori.jp",
        "towada.aomori.jp",
        "tsugaru.aomori.jp",
        "tsuruta.aomori.jp",
        "abiko.chiba.jp",
        "asahi.chiba.jp",
        "chonan.chiba.jp",
        "chosei.chiba.jp",
        "choshi.chiba.jp",
        "chuo.chiba.jp",
        "funabashi.chiba.jp",
        "futtsu.chiba.jp",
        "hanamigawa.chiba.jp",
        "ichihara.chiba.jp",
        "ichikawa.chiba.jp",
        "ichinomiya.chiba.jp",
        "inzai.chiba.jp",
        "isumi.chiba.jp",
        "kamagaya.chiba.jp",
        "kamogawa.chiba.jp",
        "kashiwa.chiba.jp",
        "katori.chiba.jp",
        "katsuura.chiba.jp",
        "kimitsu.chiba.jp",
        "kisarazu.chiba.jp",
        "kozaki.chiba.jp",
        "kujukuri.chiba.jp",
        "kyonan.chiba.jp",
        "matsudo.chiba.jp",
        "midori.chiba.jp",
        "mihama.chiba.jp",
        "minamiboso.chiba.jp",
        "mobara.chiba.jp",
        "mutsuzawa.chiba.jp",
        "nagara.chiba.jp",
        "nagareyama.chiba.jp",
        "narashino.chiba.jp",
        "narita.chiba.jp",
        "noda.chiba.jp",
        "oamishirasato.chiba.jp",
        "omigawa.chiba.jp",
        "onjuku.chiba.jp",
        "otaki.chiba.jp",
        "sakae.chiba.jp",
        "sakura.chiba.jp",
        "shimofusa.chiba.jp",
        "shirako.chiba.jp",
        "shiroi.chiba.jp",
        "shisui.chiba.jp",
        "sodegaura.chiba.jp",
        "sosa.chiba.jp",
        "tako.chiba.jp",
        "tateyama.chiba.jp",
        "togane.chiba.jp",
        "tohnosho.chiba.jp",
        "tomisato.chiba.jp",
        "urayasu.chiba.jp",
        "yachimata.chiba.jp",
        "yachiyo.chiba.jp",
        "yokaichiba.chiba.jp",
        "yokoshibahikari.chiba.jp",
        "yotsukaido.chiba.jp",
        "ainan.ehime.jp",
        "honai.ehime.jp",
        "ikata.ehime.jp",
        "imabari.ehime.jp",
        "iyo.ehime.jp",
        "kamijima.ehime.jp",
        "kihoku.ehime.jp",
        "kumakogen.ehime.jp",
        "masaki.ehime.jp",
        "matsuno.ehime.jp",
        "matsuyama.ehime.jp",
        "namikata.ehime.jp",
        "niihama.ehime.jp",
        "ozu.ehime.jp",
        "saijo.ehime.jp",
        "seiyo.ehime.jp",
        "shikokuchuo.ehime.jp",
        "tobe.ehime.jp",
        "toon.ehime.jp",
        "uchiko.ehime.jp",
        "uwajima.ehime.jp",
        "yawatahama.ehime.jp",
        "echizen.fukui.jp",
        "eiheiji.fukui.jp",
        "fukui.fukui.jp",
        "ikeda.fukui.jp",
        "katsuyama.fukui.jp",
        "mihama.fukui.jp",
        "minamiechizen.fukui.jp",
        "obama.fukui.jp",
        "ohi.fukui.jp",
        "ono.fukui.jp",
        "sabae.fukui.jp",
        "sakai.fukui.jp",
        "takahama.fukui.jp",
        "tsuruga.fukui.jp",
        "wakasa.fukui.jp",
        "ashiya.fukuoka.jp",
        "buzen.fukuoka.jp",
        "chikugo.fukuoka.jp",
        "chikuho.fukuoka.jp",
        "chikujo.fukuoka.jp",
        "chikushino.fukuoka.jp",
        "chikuzen.fukuoka.jp",
        "chuo.fukuoka.jp",
        "dazaifu.fukuoka.jp",
        "fukuchi.fukuoka.jp",
        "hakata.fukuoka.jp",
        "higashi.fukuoka.jp",
        "hirokawa.fukuoka.jp",
        "hisayama.fukuoka.jp",
        "iizuka.fukuoka.jp",
        "inatsuki.fukuoka.jp",
        "kaho.fukuoka.jp",
        "kasuga.fukuoka.jp",
        "kasuya.fukuoka.jp",
        "kawara.fukuoka.jp",
        "keisen.fukuoka.jp",
        "koga.fukuoka.jp",
        "kurate.fukuoka.jp",
        "kurogi.fukuoka.jp",
        "kurume.fukuoka.jp",
        "minami.fukuoka.jp",
        "miyako.fukuoka.jp",
        "miyama.fukuoka.jp",
        "miyawaka.fukuoka.jp",
        "mizumaki.fukuoka.jp",
        "munakata.fukuoka.jp",
        "nakagawa.fukuoka.jp",
        "nakama.fukuoka.jp",
        "nishi.fukuoka.jp",
        "nogata.fukuoka.jp",
        "ogori.fukuoka.jp",
        "okagaki.fukuoka.jp",
        "okawa.fukuoka.jp",
        "oki.fukuoka.jp",
        "omuta.fukuoka.jp",
        "onga.fukuoka.jp",
        "onojo.fukuoka.jp",
        "oto.fukuoka.jp",
        "saigawa.fukuoka.jp",
        "sasaguri.fukuoka.jp",
        "shingu.fukuoka.jp",
        "shinyoshitomi.fukuoka.jp",
        "shonai.fukuoka.jp",
        "soeda.fukuoka.jp",
        "sue.fukuoka.jp",
        "tachiarai.fukuoka.jp",
        "tagawa.fukuoka.jp",
        "takata.fukuoka.jp",
        "toho.fukuoka.jp",
        "toyotsu.fukuoka.jp",
        "tsuiki.fukuoka.jp",
        "ukiha.fukuoka.jp",
        "umi.fukuoka.jp",
        "usui.fukuoka.jp",
        "yamada.fukuoka.jp",
        "yame.fukuoka.jp",
        "yanagawa.fukuoka.jp",
        "yukuhashi.fukuoka.jp",
        "aizubange.fukushima.jp",
        "aizumisato.fukushima.jp",
        "aizuwakamatsu.fukushima.jp",
        "asakawa.fukushima.jp",
        "bandai.fukushima.jp",
        "date.fukushima.jp",
        "fukushima.fukushima.jp",
        "furudono.fukushima.jp",
        "futaba.fukushima.jp",
        "hanawa.fukushima.jp",
        "higashi.fukushima.jp",
        "hirata.fukushima.jp",
        "hirono.fukushima.jp",
        "iitate.fukushima.jp",
        "inawashiro.fukushima.jp",
        "ishikawa.fukushima.jp",
        "iwaki.fukushima.jp",
        "izumizaki.fukushima.jp",
        "kagamiishi.fukushima.jp",
        "kaneyama.fukushima.jp",
        "kawamata.fukushima.jp",
        "kitakata.fukushima.jp",
        "kitashiobara.fukushima.jp",
        "koori.fukushima.jp",
        "koriyama.fukushima.jp",
        "kunimi.fukushima.jp",
        "miharu.fukushima.jp",
        "mishima.fukushima.jp",
        "namie.fukushima.jp",
        "nango.fukushima.jp",
        "nishiaizu.fukushima.jp",
        "nishigo.fukushima.jp",
        "okuma.fukushima.jp",
        "omotego.fukushima.jp",
        "ono.fukushima.jp",
        "otama.fukushima.jp",
        "samegawa.fukushima.jp",
        "shimogo.fukushima.jp",
        "shirakawa.fukushima.jp",
        "showa.fukushima.jp",
        "soma.fukushima.jp",
        "sukagawa.fukushima.jp",
        "taishin.fukushima.jp",
        "tamakawa.fukushima.jp",
        "tanagura.fukushima.jp",
        "tenei.fukushima.jp",
        "yabuki.fukushima.jp",
        "yamato.fukushima.jp",
        "yamatsuri.fukushima.jp",
        "yanaizu.fukushima.jp",
        "yugawa.fukushima.jp",
        "anpachi.gifu.jp",
        "ena.gifu.jp",
        "gifu.gifu.jp",
        "ginan.gifu.jp",
        "godo.gifu.jp",
        "gujo.gifu.jp",
        "hashima.gifu.jp",
        "hichiso.gifu.jp",
        "hida.gifu.jp",
        "higashishirakawa.gifu.jp",
        "ibigawa.gifu.jp",
        "ikeda.gifu.jp",
        "kakamigahara.gifu.jp",
        "kani.gifu.jp",
        "kasahara.gifu.jp",
        "kasamatsu.gifu.jp",
        "kawaue.gifu.jp",
        "kitagata.gifu.jp",
        "mino.gifu.jp",
        "minokamo.gifu.jp",
        "mitake.gifu.jp",
        "mizunami.gifu.jp",
        "motosu.gifu.jp",
        "nakatsugawa.gifu.jp",
        "ogaki.gifu.jp",
        "sakahogi.gifu.jp",
        "seki.gifu.jp",
        "sekigahara.gifu.jp",
        "shirakawa.gifu.jp",
        "tajimi.gifu.jp",
        "takayama.gifu.jp",
        "tarui.gifu.jp",
        "toki.gifu.jp",
        "tomika.gifu.jp",
        "wanouchi.gifu.jp",
        "yamagata.gifu.jp",
        "yaotsu.gifu.jp",
        "yoro.gifu.jp",
        "annaka.gunma.jp",
        "chiyoda.gunma.jp",
        "fujioka.gunma.jp",
        "higashiagatsuma.gunma.jp",
        "isesaki.gunma.jp",
        "itakura.gunma.jp",
        "kanna.gunma.jp",
        "kanra.gunma.jp",
        "katashina.gunma.jp",
        "kawaba.gunma.jp",
        "kiryu.gunma.jp",
        "kusatsu.gunma.jp",
        "maebashi.gunma.jp",
        "meiwa.gunma.jp",
        "midori.gunma.jp",
        "minakami.gunma.jp",
        "naganohara.gunma.jp",
        "nakanojo.gunma.jp",
        "nanmoku.gunma.jp",
        "numata.gunma.jp",
        "oizumi.gunma.jp",
        "ora.gunma.jp",
        "ota.gunma.jp",
        "shibukawa.gunma.jp",
        "shimonita.gunma.jp",
        "shinto.gunma.jp",
        "showa.gunma.jp",
        "takasaki.gunma.jp",
        "takayama.gunma.jp",
        "tamamura.gunma.jp",
        "tatebayashi.gunma.jp",
        "tomioka.gunma.jp",
        "tsukiyono.gunma.jp",
        "tsumagoi.gunma.jp",
        "ueno.gunma.jp",
        "yoshioka.gunma.jp",
        "asaminami.hiroshima.jp",
        "daiwa.hiroshima.jp",
        "etajima.hiroshima.jp",
        "fuchu.hiroshima.jp",
        "fukuyama.hiroshima.jp",
        "hatsukaichi.hiroshima.jp",
        "higashihiroshima.hiroshima.jp",
        "hongo.hiroshima.jp",
        "jinsekikogen.hiroshima.jp",
        "kaita.hiroshima.jp",
        "kui.hiroshima.jp",
        "kumano.hiroshima.jp",
        "kure.hiroshima.jp",
        "mihara.hiroshima.jp",
        "miyoshi.hiroshima.jp",
        "naka.hiroshima.jp",
        "onomichi.hiroshima.jp",
        "osakikamijima.hiroshima.jp",
        "otake.hiroshima.jp",
        "saka.hiroshima.jp",
        "sera.hiroshima.jp",
        "seranishi.hiroshima.jp",
        "shinichi.hiroshima.jp",
        "shobara.hiroshima.jp",
        "takehara.hiroshima.jp",
        "abashiri.hokkaido.jp",
        "abira.hokkaido.jp",
        "aibetsu.hokkaido.jp",
        "akabira.hokkaido.jp",
        "akkeshi.hokkaido.jp",
        "asahikawa.hokkaido.jp",
        "ashibetsu.hokkaido.jp",
        "ashoro.hokkaido.jp",
        "assabu.hokkaido.jp",
        "atsuma.hokkaido.jp",
        "bibai.hokkaido.jp",
        "biei.hokkaido.jp",
        "bifuka.hokkaido.jp",
        "bihoro.hokkaido.jp",
        "biratori.hokkaido.jp",
        "chippubetsu.hokkaido.jp",
        "chitose.hokkaido.jp",
        "date.hokkaido.jp",
        "ebetsu.hokkaido.jp",
        "embetsu.hokkaido.jp",
        "eniwa.hokkaido.jp",
        "erimo.hokkaido.jp",
        "esan.hokkaido.jp",
        "esashi.hokkaido.jp",
        "fukagawa.hokkaido.jp",
        "fukushima.hokkaido.jp",
        "furano.hokkaido.jp",
        "furubira.hokkaido.jp",
        "haboro.hokkaido.jp",
        "hakodate.hokkaido.jp",
        "hamatonbetsu.hokkaido.jp",
        "hidaka.hokkaido.jp",
        "higashikagura.hokkaido.jp",
        "higashikawa.hokkaido.jp",
        "hiroo.hokkaido.jp",
        "hokuryu.hokkaido.jp",
        "hokuto.hokkaido.jp",
        "honbetsu.hokkaido.jp",
        "horokanai.hokkaido.jp",
        "horonobe.hokkaido.jp",
        "ikeda.hokkaido.jp",
        "imakane.hokkaido.jp",
        "ishikari.hokkaido.jp",
        "iwamizawa.hokkaido.jp",
        "iwanai.hokkaido.jp",
        "kamifurano.hokkaido.jp",
        "kamikawa.hokkaido.jp",
        "kamishihoro.hokkaido.jp",
        "kamisunagawa.hokkaido.jp",
        "kamoenai.hokkaido.jp",
        "kayabe.hokkaido.jp",
        "kembuchi.hokkaido.jp",
        "kikonai.hokkaido.jp",
        "kimobetsu.hokkaido.jp",
        "kitahiroshima.hokkaido.jp",
        "kitami.hokkaido.jp",
        "kiyosato.hokkaido.jp",
        "koshimizu.hokkaido.jp",
        "kunneppu.hokkaido.jp",
        "kuriyama.hokkaido.jp",
        "kuromatsunai.hokkaido.jp",
        "kushiro.hokkaido.jp",
        "kutchan.hokkaido.jp",
        "kyowa.hokkaido.jp",
        "mashike.hokkaido.jp",
        "matsumae.hokkaido.jp",
        "mikasa.hokkaido.jp",
        "minamifurano.hokkaido.jp",
        "mombetsu.hokkaido.jp",
        "moseushi.hokkaido.jp",
        "mukawa.hokkaido.jp",
        "muroran.hokkaido.jp",
        "naie.hokkaido.jp",
        "nakagawa.hokkaido.jp",
        "nakasatsunai.hokkaido.jp",
        "nakatombetsu.hokkaido.jp",
        "nanae.hokkaido.jp",
        "nanporo.hokkaido.jp",
        "nayoro.hokkaido.jp",
        "nemuro.hokkaido.jp",
        "niikappu.hokkaido.jp",
        "niki.hokkaido.jp",
        "nishiokoppe.hokkaido.jp",
        "noboribetsu.hokkaido.jp",
        "numata.hokkaido.jp",
        "obihiro.hokkaido.jp",
        "obira.hokkaido.jp",
        "oketo.hokkaido.jp",
        "okoppe.hokkaido.jp",
        "otaru.hokkaido.jp",
        "otobe.hokkaido.jp",
        "otofuke.hokkaido.jp",
        "otoineppu.hokkaido.jp",
        "oumu.hokkaido.jp",
        "ozora.hokkaido.jp",
        "pippu.hokkaido.jp",
        "rankoshi.hokkaido.jp",
        "rebun.hokkaido.jp",
        "rikubetsu.hokkaido.jp",
        "rishiri.hokkaido.jp",
        "rishirifuji.hokkaido.jp",
        "saroma.hokkaido.jp",
        "sarufutsu.hokkaido.jp",
        "shakotan.hokkaido.jp",
        "shari.hokkaido.jp",
        "shibecha.hokkaido.jp",
        "shibetsu.hokkaido.jp",
        "shikabe.hokkaido.jp",
        "shikaoi.hokkaido.jp",
        "shimamaki.hokkaido.jp",
        "shimizu.hokkaido.jp",
        "shimokawa.hokkaido.jp",
        "shinshinotsu.hokkaido.jp",
        "shintoku.hokkaido.jp",
        "shiranuka.hokkaido.jp",
        "shiraoi.hokkaido.jp",
        "shiriuchi.hokkaido.jp",
        "sobetsu.hokkaido.jp",
        "sunagawa.hokkaido.jp",
        "taiki.hokkaido.jp",
        "takasu.hokkaido.jp",
        "takikawa.hokkaido.jp",
        "takinoue.hokkaido.jp",
        "teshikaga.hokkaido.jp",
        "tobetsu.hokkaido.jp",
        "tohma.hokkaido.jp",
        "tomakomai.hokkaido.jp",
        "tomari.hokkaido.jp",
        "toya.hokkaido.jp",
        "toyako.hokkaido.jp",
        "toyotomi.hokkaido.jp",
        "toyoura.hokkaido.jp",
        "tsubetsu.hokkaido.jp",
        "tsukigata.hokkaido.jp",
        "urakawa.hokkaido.jp",
        "urausu.hokkaido.jp",
        "uryu.hokkaido.jp",
        "utashinai.hokkaido.jp",
        "wakkanai.hokkaido.jp",
        "wassamu.hokkaido.jp",
        "yakumo.hokkaido.jp",
        "yoichi.hokkaido.jp",
        "aioi.hyogo.jp",
        "akashi.hyogo.jp",
        "ako.hyogo.jp",
        "amagasaki.hyogo.jp",
        "aogaki.hyogo.jp",
        "asago.hyogo.jp",
        "ashiya.hyogo.jp",
        "awaji.hyogo.jp",
        "fukusaki.hyogo.jp",
        "goshiki.hyogo.jp",
        "harima.hyogo.jp",
        "himeji.hyogo.jp",
        "ichikawa.hyogo.jp",
        "inagawa.hyogo.jp",
        "itami.hyogo.jp",
        "kakogawa.hyogo.jp",
        "kamigori.hyogo.jp",
        "kamikawa.hyogo.jp",
        "kasai.hyogo.jp",
        "kasuga.hyogo.jp",
        "kawanishi.hyogo.jp",
        "miki.hyogo.jp",
        "minamiawaji.hyogo.jp",
        "nishinomiya.hyogo.jp",
        "nishiwaki.hyogo.jp",
        "ono.hyogo.jp",
        "sanda.hyogo.jp",
        "sannan.hyogo.jp",
        "sasayama.hyogo.jp",
        "sayo.hyogo.jp",
        "shingu.hyogo.jp",
        "shinonsen.hyogo.jp",
        "shiso.hyogo.jp",
        "sumoto.hyogo.jp",
        "taishi.hyogo.jp",
        "taka.hyogo.jp",
        "takarazuka.hyogo.jp",
        "takasago.hyogo.jp",
        "takino.hyogo.jp",
        "tamba.hyogo.jp",
        "tatsuno.hyogo.jp",
        "toyooka.hyogo.jp",
        "yabu.hyogo.jp",
        "yashiro.hyogo.jp",
        "yoka.hyogo.jp",
        "yokawa.hyogo.jp",
        "ami.ibaraki.jp",
        "asahi.ibaraki.jp",
        "bando.ibaraki.jp",
        "chikusei.ibaraki.jp",
        "daigo.ibaraki.jp",
        "fujishiro.ibaraki.jp",
        "hitachi.ibaraki.jp",
        "hitachinaka.ibaraki.jp",
        "hitachiomiya.ibaraki.jp",
        "hitachiota.ibaraki.jp",
        "ibaraki.ibaraki.jp",
        "ina.ibaraki.jp",
        "inashiki.ibaraki.jp",
        "itako.ibaraki.jp",
        "iwama.ibaraki.jp",
        "joso.ibaraki.jp",
        "kamisu.ibaraki.jp",
        "kasama.ibaraki.jp",
        "kashima.ibaraki.jp",
        "kasumigaura.ibaraki.jp",
        "koga.ibaraki.jp",
        "miho.ibaraki.jp",
        "mito.ibaraki.jp",
        "moriya.ibaraki.jp",
        "naka.ibaraki.jp",
        "namegata.ibaraki.jp",
        "oarai.ibaraki.jp",
        "ogawa.ibaraki.jp",
        "omitama.ibaraki.jp",
        "ryugasaki.ibaraki.jp",
        "sakai.ibaraki.jp",
        "sakuragawa.ibaraki.jp",
        "shimodate.ibaraki.jp",
        "shimotsuma.ibaraki.jp",
        "shirosato.ibaraki.jp",
        "sowa.ibaraki.jp",
        "suifu.ibaraki.jp",
        "takahagi.ibaraki.jp",
        "tamatsukuri.ibaraki.jp",
        "tokai.ibaraki.jp",
        "tomobe.ibaraki.jp",
        "tone.ibaraki.jp",
        "toride.ibaraki.jp",
        "tsuchiura.ibaraki.jp",
        "tsukuba.ibaraki.jp",
        "uchihara.ibaraki.jp",
        "ushiku.ibaraki.jp",
        "yachiyo.ibaraki.jp",
        "yamagata.ibaraki.jp",
        "yawara.ibaraki.jp",
        "yuki.ibaraki.jp",
        "anamizu.ishikawa.jp",
        "hakui.ishikawa.jp",
        "hakusan.ishikawa.jp",
        "kaga.ishikawa.jp",
        "kahoku.ishikawa.jp",
        "kanazawa.ishikawa.jp",
        "kawakita.ishikawa.jp",
        "komatsu.ishikawa.jp",
        "nakanoto.ishikawa.jp",
        "nanao.ishikawa.jp",
        "nomi.ishikawa.jp",
        "nonoichi.ishikawa.jp",
        "noto.ishikawa.jp",
        "shika.ishikawa.jp",
        "suzu.ishikawa.jp",
        "tsubata.ishikawa.jp",
        "tsurugi.ishikawa.jp",
        "uchinada.ishikawa.jp",
        "wajima.ishikawa.jp",
        "fudai.iwate.jp",
        "fujisawa.iwate.jp",
        "hanamaki.iwate.jp",
        "hiraizumi.iwate.jp",
        "hirono.iwate.jp",
        "ichinohe.iwate.jp",
        "ichinoseki.iwate.jp",
        "iwaizumi.iwate.jp",
        "iwate.iwate.jp",
        "joboji.iwate.jp",
        "kamaishi.iwate.jp",
        "kanegasaki.iwate.jp",
        "karumai.iwate.jp",
        "kawai.iwate.jp",
        "kitakami.iwate.jp",
        "kuji.iwate.jp",
        "kunohe.iwate.jp",
        "kuzumaki.iwate.jp",
        "miyako.iwate.jp",
        "mizusawa.iwate.jp",
        "morioka.iwate.jp",
        "ninohe.iwate.jp",
        "noda.iwate.jp",
        "ofunato.iwate.jp",
        "oshu.iwate.jp",
        "otsuchi.iwate.jp",
        "rikuzentakata.iwate.jp",
        "shiwa.iwate.jp",
        "shizukuishi.iwate.jp",
        "sumita.iwate.jp",
        "tanohata.iwate.jp",
        "tono.iwate.jp",
        "yahaba.iwate.jp",
        "yamada.iwate.jp",
        "ayagawa.kagawa.jp",
        "higashikagawa.kagawa.jp",
        "kanonji.kagawa.jp",
        "kotohira.kagawa.jp",
        "manno.kagawa.jp",
        "marugame.kagawa.jp",
        "mitoyo.kagawa.jp",
        "naoshima.kagawa.jp",
        "sanuki.kagawa.jp",
        "tadotsu.kagawa.jp",
        "takamatsu.kagawa.jp",
        "tonosho.kagawa.jp",
        "uchinomi.kagawa.jp",
        "utazu.kagawa.jp",
        "zentsuji.kagawa.jp",
        "akune.kagoshima.jp",
        "amami.kagoshima.jp",
        "hioki.kagoshima.jp",
        "isa.kagoshima.jp",
        "isen.kagoshima.jp",
        "izumi.kagoshima.jp",
        "kagoshima.kagoshima.jp",
        "kanoya.kagoshima.jp",
        "kawanabe.kagoshima.jp",
        "kinko.kagoshima.jp",
        "kouyama.kagoshima.jp",
        "makurazaki.kagoshima.jp",
        "matsumoto.kagoshima.jp",
        "minamitane.kagoshima.jp",
        "nakatane.kagoshima.jp",
        "nishinoomote.kagoshima.jp",
        "satsumasendai.kagoshima.jp",
        "soo.kagoshima.jp",
        "tarumizu.kagoshima.jp",
        "yusui.kagoshima.jp",
        "aikawa.kanagawa.jp",
        "atsugi.kanagawa.jp",
        "ayase.kanagawa.jp",
        "chigasaki.kanagawa.jp",
        "ebina.kanagawa.jp",
        "fujisawa.kanagawa.jp",
        "hadano.kanagawa.jp",
        "hakone.kanagawa.jp",
        "hiratsuka.kanagawa.jp",
        "isehara.kanagawa.jp",
        "kaisei.kanagawa.jp",
        "kamakura.kanagawa.jp",
        "kiyokawa.kanagawa.jp",
        "matsuda.kanagawa.jp",
        "minamiashigara.kanagawa.jp",
        "miura.kanagawa.jp",
        "nakai.kanagawa.jp",
        "ninomiya.kanagawa.jp",
        "odawara.kanagawa.jp",
        "oi.kanagawa.jp",
        "oiso.kanagawa.jp",
        "sagamihara.kanagawa.jp",
        "samukawa.kanagawa.jp",
        "tsukui.kanagawa.jp",
        "yamakita.kanagawa.jp",
        "yamato.kanagawa.jp",
        "yokosuka.kanagawa.jp",
        "yugawara.kanagawa.jp",
        "zama.kanagawa.jp",
        "zushi.kanagawa.jp",
        "aki.kochi.jp",
        "geisei.kochi.jp",
        "hidaka.kochi.jp",
        "higashitsuno.kochi.jp",
        "ino.kochi.jp",
        "kagami.kochi.jp",
        "kami.kochi.jp",
        "kitagawa.kochi.jp",
        "kochi.kochi.jp",
        "mihara.kochi.jp",
        "motoyama.kochi.jp",
        "muroto.kochi.jp",
        "nahari.kochi.jp",
        "nakamura.kochi.jp",
        "nankoku.kochi.jp",
        "nishitosa.kochi.jp",
        "niyodogawa.kochi.jp",
        "ochi.kochi.jp",
        "okawa.kochi.jp",
        "otoyo.kochi.jp",
        "otsuki.kochi.jp",
        "sakawa.kochi.jp",
        "sukumo.kochi.jp",
        "susaki.kochi.jp",
        "tosa.kochi.jp",
        "tosashimizu.kochi.jp",
        "toyo.kochi.jp",
        "tsuno.kochi.jp",
        "umaji.kochi.jp",
        "yasuda.kochi.jp",
        "yusuhara.kochi.jp",
        "amakusa.kumamoto.jp",
        "arao.kumamoto.jp",
        "aso.kumamoto.jp",
        "choyo.kumamoto.jp",
        "gyokuto.kumamoto.jp",
        "kamiamakusa.kumamoto.jp",
        "kikuchi.kumamoto.jp",
        "kumamoto.kumamoto.jp",
        "mashiki.kumamoto.jp",
        "mifune.kumamoto.jp",
        "minamata.kumamoto.jp",
        "minamioguni.kumamoto.jp",
        "nagasu.kumamoto.jp",
        "nishihara.kumamoto.jp",
        "oguni.kumamoto.jp",
        "ozu.kumamoto.jp",
        "sumoto.kumamoto.jp",
        "takamori.kumamoto.jp",
        "uki.kumamoto.jp",
        "uto.kumamoto.jp",
        "yamaga.kumamoto.jp",
        "yamato.kumamoto.jp",
        "yatsushiro.kumamoto.jp",
        "ayabe.kyoto.jp",
        "fukuchiyama.kyoto.jp",
        "higashiyama.kyoto.jp",
        "ide.kyoto.jp",
        "ine.kyoto.jp",
        "joyo.kyoto.jp",
        "kameoka.kyoto.jp",
        "kamo.kyoto.jp",
        "kita.kyoto.jp",
        "kizu.kyoto.jp",
        "kumiyama.kyoto.jp",
        "kyotamba.kyoto.jp",
        "kyotanabe.kyoto.jp",
        "kyotango.kyoto.jp",
        "maizuru.kyoto.jp",
        "minami.kyoto.jp",
        "minamiyamashiro.kyoto.jp",
        "miyazu.kyoto.jp",
        "muko.kyoto.jp",
        "nagaokakyo.kyoto.jp",
        "nakagyo.kyoto.jp",
        "nantan.kyoto.jp",
        "oyamazaki.kyoto.jp",
        "sakyo.kyoto.jp",
        "seika.kyoto.jp",
        "tanabe.kyoto.jp",
        "uji.kyoto.jp",
        "ujitawara.kyoto.jp",
        "wazuka.kyoto.jp",
        "yamashina.kyoto.jp",
        "yawata.kyoto.jp",
        "asahi.mie.jp",
        "inabe.mie.jp",
        "ise.mie.jp",
        "kameyama.mie.jp",
        "kawagoe.mie.jp",
        "kiho.mie.jp",
        "kisosaki.mie.jp",
        "kiwa.mie.jp",
        "komono.mie.jp",
        "kumano.mie.jp",
        "kuwana.mie.jp",
        "matsusaka.mie.jp",
        "meiwa.mie.jp",
        "mihama.mie.jp",
        "minamiise.mie.jp",
        "misugi.mie.jp",
        "miyama.mie.jp",
        "nabari.mie.jp",
        "shima.mie.jp",
        "suzuka.mie.jp",
        "tado.mie.jp",
        "taiki.mie.jp",
        "taki.mie.jp",
        "tamaki.mie.jp",
        "toba.mie.jp",
        "tsu.mie.jp",
        "udono.mie.jp",
        "ureshino.mie.jp",
        "watarai.mie.jp",
        "yokkaichi.mie.jp",
        "furukawa.miyagi.jp",
        "higashimatsushima.miyagi.jp",
        "ishinomaki.miyagi.jp",
        "iwanuma.miyagi.jp",
        "kakuda.miyagi.jp",
        "kami.miyagi.jp",
        "kawasaki.miyagi.jp",
        "marumori.miyagi.jp",
        "matsushima.miyagi.jp",
        "minamisanriku.miyagi.jp",
        "misato.miyagi.jp",
        "murata.miyagi.jp",
        "natori.miyagi.jp",
        "ogawara.miyagi.jp",
        "ohira.miyagi.jp",
        "onagawa.miyagi.jp",
        "osaki.miyagi.jp",
        "rifu.miyagi.jp",
        "semine.miyagi.jp",
        "shibata.miyagi.jp",
        "shichikashuku.miyagi.jp",
        "shikama.miyagi.jp",
        "shiogama.miyagi.jp",
        "shiroishi.miyagi.jp",
        "tagajo.miyagi.jp",
        "taiwa.miyagi.jp",
        "tome.miyagi.jp",
        "tomiya.miyagi.jp",
        "wakuya.miyagi.jp",
        "watari.miyagi.jp",
        "yamamoto.miyagi.jp",
        "zao.miyagi.jp",
        "aya.miyazaki.jp",
        "ebino.miyazaki.jp",
        "gokase.miyazaki.jp",
        "hyuga.miyazaki.jp",
        "kadogawa.miyazaki.jp",
        "kawaminami.miyazaki.jp",
        "kijo.miyazaki.jp",
        "kitagawa.miyazaki.jp",
        "kitakata.miyazaki.jp",
        "kitaura.miyazaki.jp",
        "kobayashi.miyazaki.jp",
        "kunitomi.miyazaki.jp",
        "kushima.miyazaki.jp",
        "mimata.miyazaki.jp",
        "miyakonojo.miyazaki.jp",
        "miyazaki.miyazaki.jp",
        "morotsuka.miyazaki.jp",
        "nichinan.miyazaki.jp",
        "nishimera.miyazaki.jp",
        "nobeoka.miyazaki.jp",
        "saito.miyazaki.jp",
        "shiiba.miyazaki.jp",
        "shintomi.miyazaki.jp",
        "takaharu.miyazaki.jp",
        "takanabe.miyazaki.jp",
        "takazaki.miyazaki.jp",
        "tsuno.miyazaki.jp",
        "achi.nagano.jp",
        "agematsu.nagano.jp",
        "anan.nagano.jp",
        "aoki.nagano.jp",
        "asahi.nagano.jp",
        "azumino.nagano.jp",
        "chikuhoku.nagano.jp",
        "chikuma.nagano.jp",
        "chino.nagano.jp",
        "fujimi.nagano.jp",
        "hakuba.nagano.jp",
        "hara.nagano.jp",
        "hiraya.nagano.jp",
        "iida.nagano.jp",
        "iijima.nagano.jp",
        "iiyama.nagano.jp",
        "iizuna.nagano.jp",
        "ikeda.nagano.jp",
        "ikusaka.nagano.jp",
        "ina.nagano.jp",
        "karuizawa.nagano.jp",
        "kawakami.nagano.jp",
        "kiso.nagano.jp",
        "kisofukushima.nagano.jp",
        "kitaaiki.nagano.jp",
        "komagane.nagano.jp",
        "komoro.nagano.jp",
        "matsukawa.nagano.jp",
        "matsumoto.nagano.jp",
        "miasa.nagano.jp",
        "minamiaiki.nagano.jp",
        "minamimaki.nagano.jp",
        "minamiminowa.nagano.jp",
        "minowa.nagano.jp",
        "miyada.nagano.jp",
        "miyota.nagano.jp",
        "mochizuki.nagano.jp",
        "nagano.nagano.jp",
        "nagawa.nagano.jp",
        "nagiso.nagano.jp",
        "nakagawa.nagano.jp",
        "nakano.nagano.jp",
        "nozawaonsen.nagano.jp",
        "obuse.nagano.jp",
        "ogawa.nagano.jp",
        "okaya.nagano.jp",
        "omachi.nagano.jp",
        "omi.nagano.jp",
        "ookuwa.nagano.jp",
        "ooshika.nagano.jp",
        "otaki.nagano.jp",
        "otari.nagano.jp",
        "sakae.nagano.jp",
        "sakaki.nagano.jp",
        "saku.nagano.jp",
        "sakuho.nagano.jp",
        "shimosuwa.nagano.jp",
        "shinanomachi.nagano.jp",
        "shiojiri.nagano.jp",
        "suwa.nagano.jp",
        "suzaka.nagano.jp",
        "takagi.nagano.jp",
        "takamori.nagano.jp",
        "takayama.nagano.jp",
        "tateshina.nagano.jp",
        "tatsuno.nagano.jp",
        "togakushi.nagano.jp",
        "togura.nagano.jp",
        "tomi.nagano.jp",
        "ueda.nagano.jp",
        "wada.nagano.jp",
        "yamagata.nagano.jp",
        "yamanouchi.nagano.jp",
        "yasaka.nagano.jp",
        "yasuoka.nagano.jp",
        "chijiwa.nagasaki.jp",
        "futsu.nagasaki.jp",
        "goto.nagasaki.jp",
        "hasami.nagasaki.jp",
        "hirado.nagasaki.jp",
        "iki.nagasaki.jp",
        "isahaya.nagasaki.jp",
        "kawatana.nagasaki.jp",
        "kuchinotsu.nagasaki.jp",
        "matsuura.nagasaki.jp",
        "nagasaki.nagasaki.jp",
        "obama.nagasaki.jp",
        "omura.nagasaki.jp",
        "oseto.nagasaki.jp",
        "saikai.nagasaki.jp",
        "sasebo.nagasaki.jp",
        "seihi.nagasaki.jp",
        "shimabara.nagasaki.jp",
        "shinkamigoto.nagasaki.jp",
        "togitsu.nagasaki.jp",
        "tsushima.nagasaki.jp",
        "unzen.nagasaki.jp",
        "ando.nara.jp",
        "gose.nara.jp",
        "heguri.nara.jp",
        "higashiyoshino.nara.jp",
        "ikaruga.nara.jp",
        "ikoma.nara.jp",
        "kamikitayama.nara.jp",
        "kanmaki.nara.jp",
        "kashiba.nara.jp",
        "kashihara.nara.jp",
        "katsuragi.nara.jp",
        "kawai.nara.jp",
        "kawakami.nara.jp",
        "kawanishi.nara.jp",
        "koryo.nara.jp",
        "kurotaki.nara.jp",
        "mitsue.nara.jp",
        "miyake.nara.jp",
        "nara.nara.jp",
        "nosegawa.nara.jp",
        "oji.nara.jp",
        "ouda.nara.jp",
        "oyodo.nara.jp",
        "sakurai.nara.jp",
        "sango.nara.jp",
        "shimoichi.nara.jp",
        "shimokitayama.nara.jp",
        "shinjo.nara.jp",
        "soni.nara.jp",
        "takatori.nara.jp",
        "tawaramoto.nara.jp",
        "tenkawa.nara.jp",
        "tenri.nara.jp",
        "uda.nara.jp",
        "yamatokoriyama.nara.jp",
        "yamatotakada.nara.jp",
        "yamazoe.nara.jp",
        "yoshino.nara.jp",
        "aga.niigata.jp",
        "agano.niigata.jp",
        "gosen.niigata.jp",
        "itoigawa.niigata.jp",
        "izumozaki.niigata.jp",
        "joetsu.niigata.jp",
        "kamo.niigata.jp",
        "kariwa.niigata.jp",
        "kashiwazaki.niigata.jp",
        "minamiuonuma.niigata.jp",
        "mitsuke.niigata.jp",
        "muika.niigata.jp",
        "murakami.niigata.jp",
        "myoko.niigata.jp",
        "nagaoka.niigata.jp",
        "niigata.niigata.jp",
        "ojiya.niigata.jp",
        "omi.niigata.jp",
        "sado.niigata.jp",
        "sanjo.niigata.jp",
        "seiro.niigata.jp",
        "seirou.niigata.jp",
        "sekikawa.niigata.jp",
        "shibata.niigata.jp",
        "tagami.niigata.jp",
        "tainai.niigata.jp",
        "tochio.niigata.jp",
        "tokamachi.niigata.jp",
        "tsubame.niigata.jp",
        "tsunan.niigata.jp",
        "uonuma.niigata.jp",
        "yahiko.niigata.jp",
        "yoita.niigata.jp",
        "yuzawa.niigata.jp",
        "beppu.oita.jp",
        "bungoono.oita.jp",
        "bungotakada.oita.jp",
        "hasama.oita.jp",
        "hiji.oita.jp",
        "himeshima.oita.jp",
        "hita.oita.jp",
        "kamitsue.oita.jp",
        "kokonoe.oita.jp",
        "kuju.oita.jp",
        "kunisaki.oita.jp",
        "kusu.oita.jp",
        "oita.oita.jp",
        "saiki.oita.jp",
        "taketa.oita.jp",
        "tsukumi.oita.jp",
        "usa.oita.jp",
        "usuki.oita.jp",
        "yufu.oita.jp",
        "akaiwa.okayama.jp",
        "asakuchi.okayama.jp",
        "bizen.okayama.jp",
        "hayashima.okayama.jp",
        "ibara.okayama.jp",
        "kagamino.okayama.jp",
        "kasaoka.okayama.jp",
        "kibichuo.okayama.jp",
        "kumenan.okayama.jp",
        "kurashiki.okayama.jp",
        "maniwa.okayama.jp",
        "misaki.okayama.jp",
        "nagi.okayama.jp",
        "niimi.okayama.jp",
        "nishiawakura.okayama.jp",
        "okayama.okayama.jp",
        "satosho.okayama.jp",
        "setouchi.okayama.jp",
        "shinjo.okayama.jp",
        "shoo.okayama.jp",
        "soja.okayama.jp",
        "takahashi.okayama.jp",
        "tamano.okayama.jp",
        "tsuyama.okayama.jp",
        "wake.okayama.jp",
        "yakage.okayama.jp",
        "aguni.okinawa.jp",
        "ginowan.okinawa.jp",
        "ginoza.okinawa.jp",
        "gushikami.okinawa.jp",
        "haebaru.okinawa.jp",
        "higashi.okinawa.jp",
        "hirara.okinawa.jp",
        "iheya.okinawa.jp",
        "ishigaki.okinawa.jp",
        "ishikawa.okinawa.jp",
        "itoman.okinawa.jp",
        "izena.okinawa.jp",
        "kadena.okinawa.jp",
        "kin.okinawa.jp",
        "kitadaito.okinawa.jp",
        "kitanakagusuku.okinawa.jp",
        "kumejima.okinawa.jp",
        "kunigami.okinawa.jp",
        "minamidaito.okinawa.jp",
        "motobu.okinawa.jp",
        "nago.okinawa.jp",
        "naha.okinawa.jp",
        "nakagusuku.okinawa.jp",
        "nakijin.okinawa.jp",
        "nanjo.okinawa.jp",
        "nishihara.okinawa.jp",
        "ogimi.okinawa.jp",
        "okinawa.okinawa.jp",
        "onna.okinawa.jp",
        "shimoji.okinawa.jp",
        "taketomi.okinawa.jp",
        "tarama.okinawa.jp",
        "tokashiki.okinawa.jp",
        "tomigusuku.okinawa.jp",
        "tonaki.okinawa.jp",
        "urasoe.okinawa.jp",
        "uruma.okinawa.jp",
        "yaese.okinawa.jp",
        "yomitan.okinawa.jp",
        "yonabaru.okinawa.jp",
        "yonaguni.okinawa.jp",
        "zamami.okinawa.jp",
        "abeno.osaka.jp",
        "chihayaakasaka.osaka.jp",
        "chuo.osaka.jp",
        "daito.osaka.jp",
        "fujiidera.osaka.jp",
        "habikino.osaka.jp",
        "hannan.osaka.jp",
        "higashiosaka.osaka.jp",
        "higashisumiyoshi.osaka.jp",
        "higashiyodogawa.osaka.jp",
        "hirakata.osaka.jp",
        "ibaraki.osaka.jp",
        "ikeda.osaka.jp",
        "izumi.osaka.jp",
        "izumiotsu.osaka.jp",
        "izumisano.osaka.jp",
        "kadoma.osaka.jp",
        "kaizuka.osaka.jp",
        "kanan.osaka.jp",
        "kashiwara.osaka.jp",
        "katano.osaka.jp",
        "kawachinagano.osaka.jp",
        "kishiwada.osaka.jp",
        "kita.osaka.jp",
        "kumatori.osaka.jp",
        "matsubara.osaka.jp",
        "minato.osaka.jp",
        "minoh.osaka.jp",
        "misaki.osaka.jp",
        "moriguchi.osaka.jp",
        "neyagawa.osaka.jp",
        "nishi.osaka.jp",
        "nose.osaka.jp",
        "osakasayama.osaka.jp",
        "sakai.osaka.jp",
        "sayama.osaka.jp",
        "sennan.osaka.jp",
        "settsu.osaka.jp",
        "shijonawate.osaka.jp",
        "shimamoto.osaka.jp",
        "suita.osaka.jp",
        "tadaoka.osaka.jp",
        "taishi.osaka.jp",
        "tajiri.osaka.jp",
        "takaishi.osaka.jp",
        "takatsuki.osaka.jp",
        "tondabayashi.osaka.jp",
        "toyonaka.osaka.jp",
        "toyono.osaka.jp",
        "yao.osaka.jp",
        "ariake.saga.jp",
        "arita.saga.jp",
        "fukudomi.saga.jp",
        "genkai.saga.jp",
        "hamatama.saga.jp",
        "hizen.saga.jp",
        "imari.saga.jp",
        "kamimine.saga.jp",
        "kanzaki.saga.jp",
        "karatsu.saga.jp",
        "kashima.saga.jp",
        "kitagata.saga.jp",
        "kitahata.saga.jp",
        "kiyama.saga.jp",
        "kouhoku.saga.jp",
        "kyuragi.saga.jp",
        "nishiarita.saga.jp",
        "ogi.saga.jp",
        "omachi.saga.jp",
        "ouchi.saga.jp",
        "saga.saga.jp",
        "shiroishi.saga.jp",
        "taku.saga.jp",
        "tara.saga.jp",
        "tosu.saga.jp",
        "yoshinogari.saga.jp",
        "arakawa.saitama.jp",
        "asaka.saitama.jp",
        "chichibu.saitama.jp",
        "fujimi.saitama.jp",
        "fujimino.saitama.jp",
        "fukaya.saitama.jp",
        "hanno.saitama.jp",
        "hanyu.saitama.jp",
        "hasuda.saitama.jp",
        "hatogaya.saitama.jp",
        "hatoyama.saitama.jp",
        "hidaka.saitama.jp",
        "higashichichibu.saitama.jp",
        "higashimatsuyama.saitama.jp",
        "honjo.saitama.jp",
        "ina.saitama.jp",
        "iruma.saitama.jp",
        "iwatsuki.saitama.jp",
        "kamiizumi.saitama.jp",
        "kamikawa.saitama.jp",
        "kamisato.saitama.jp",
        "kasukabe.saitama.jp",
        "kawagoe.saitama.jp",
        "kawaguchi.saitama.jp",
        "kawajima.saitama.jp",
        "kazo.saitama.jp",
        "kitamoto.saitama.jp",
        "koshigaya.saitama.jp",
        "kounosu.saitama.jp",
        "kuki.saitama.jp",
        "kumagaya.saitama.jp",
        "matsubushi.saitama.jp",
        "minano.saitama.jp",
        "misato.saitama.jp",
        "miyashiro.saitama.jp",
        "miyoshi.saitama.jp",
        "moroyama.saitama.jp",
        "nagatoro.saitama.jp",
        "namegawa.saitama.jp",
        "niiza.saitama.jp",
        "ogano.saitama.jp",
        "ogawa.saitama.jp",
        "ogose.saitama.jp",
        "okegawa.saitama.jp",
        "omiya.saitama.jp",
        "otaki.saitama.jp",
        "ranzan.saitama.jp",
        "ryokami.saitama.jp",
        "saitama.saitama.jp",
        "sakado.saitama.jp",
        "satte.saitama.jp",
        "sayama.saitama.jp",
        "shiki.saitama.jp",
        "shiraoka.saitama.jp",
        "soka.saitama.jp",
        "sugito.saitama.jp",
        "toda.saitama.jp",
        "tokigawa.saitama.jp",
        "tokorozawa.saitama.jp",
        "tsurugashima.saitama.jp",
        "urawa.saitama.jp",
        "warabi.saitama.jp",
        "yashio.saitama.jp",
        "yokoze.saitama.jp",
        "yono.saitama.jp",
        "yorii.saitama.jp",
        "yoshida.saitama.jp",
        "yoshikawa.saitama.jp",
        "yoshimi.saitama.jp",
        "aisho.shiga.jp",
        "gamo.shiga.jp",
        "higashiomi.shiga.jp",
        "hikone.shiga.jp",
        "koka.shiga.jp",
        "konan.shiga.jp",
        "kosei.shiga.jp",
        "koto.shiga.jp",
        "kusatsu.shiga.jp",
        "maibara.shiga.jp",
        "moriyama.shiga.jp",
        "nagahama.shiga.jp",
        "nishiazai.shiga.jp",
        "notogawa.shiga.jp",
        "omihachiman.shiga.jp",
        "otsu.shiga.jp",
        "ritto.shiga.jp",
        "ryuoh.shiga.jp",
        "takashima.shiga.jp",
        "takatsuki.shiga.jp",
        "torahime.shiga.jp",
        "toyosato.shiga.jp",
        "yasu.shiga.jp",
        "akagi.shimane.jp",
        "ama.shimane.jp",
        "gotsu.shimane.jp",
        "hamada.shimane.jp",
        "higashiizumo.shimane.jp",
        "hikawa.shimane.jp",
        "hikimi.shimane.jp",
        "izumo.shimane.jp",
        "kakinoki.shimane.jp",
        "masuda.shimane.jp",
        "matsue.shimane.jp",
        "misato.shimane.jp",
        "nishinoshima.shimane.jp",
        "ohda.shimane.jp",
        "okinoshima.shimane.jp",
        "okuizumo.shimane.jp",
        "shimane.shimane.jp",
        "tamayu.shimane.jp",
        "tsuwano.shimane.jp",
        "unnan.shimane.jp",
        "yakumo.shimane.jp",
        "yasugi.shimane.jp",
        "yatsuka.shimane.jp",
        "arai.shizuoka.jp",
        "atami.shizuoka.jp",
        "fuji.shizuoka.jp",
        "fujieda.shizuoka.jp",
        "fujikawa.shizuoka.jp",
        "fujinomiya.shizuoka.jp",
        "fukuroi.shizuoka.jp",
        "gotemba.shizuoka.jp",
        "haibara.shizuoka.jp",
        "hamamatsu.shizuoka.jp",
        "higashiizu.shizuoka.jp",
        "ito.shizuoka.jp",
        "iwata.shizuoka.jp",
        "izu.shizuoka.jp",
        "izunokuni.shizuoka.jp",
        "kakegawa.shizuoka.jp",
        "kannami.shizuoka.jp",
        "kawanehon.shizuoka.jp",
        "kawazu.shizuoka.jp",
        "kikugawa.shizuoka.jp",
        "kosai.shizuoka.jp",
        "makinohara.shizuoka.jp",
        "matsuzaki.shizuoka.jp",
        "minamiizu.shizuoka.jp",
        "mishima.shizuoka.jp",
        "morimachi.shizuoka.jp",
        "nishiizu.shizuoka.jp",
        "numazu.shizuoka.jp",
        "omaezaki.shizuoka.jp",
        "shimada.shizuoka.jp",
        "shimizu.shizuoka.jp",
        "shimoda.shizuoka.jp",
        "shizuoka.shizuoka.jp",
        "susono.shizuoka.jp",
        "yaizu.shizuoka.jp",
        "yoshida.shizuoka.jp",
        "ashikaga.tochigi.jp",
        "bato.tochigi.jp",
        "haga.tochigi.jp",
        "ichikai.tochigi.jp",
        "iwafune.tochigi.jp",
        "kaminokawa.tochigi.jp",
        "kanuma.tochigi.jp",
        "karasuyama.tochigi.jp",
        "kuroiso.tochigi.jp",
        "mashiko.tochigi.jp",
        "mibu.tochigi.jp",
        "moka.tochigi.jp",
        "motegi.tochigi.jp",
        "nasu.tochigi.jp",
        "nasushiobara.tochigi.jp",
        "nikko.tochigi.jp",
        "nishikata.tochigi.jp",
        "nogi.tochigi.jp",
        "ohira.tochigi.jp",
        "ohtawara.tochigi.jp",
        "oyama.tochigi.jp",
        "sakura.tochigi.jp",
        "sano.tochigi.jp",
        "shimotsuke.tochigi.jp",
        "shioya.tochigi.jp",
        "takanezawa.tochigi.jp",
        "tochigi.tochigi.jp",
        "tsuga.tochigi.jp",
        "ujiie.tochigi.jp",
        "utsunomiya.tochigi.jp",
        "yaita.tochigi.jp",
        "aizumi.tokushima.jp",
        "anan.tokushima.jp",
        "ichiba.tokushima.jp",
        "itano.tokushima.jp",
        "kainan.tokushima.jp",
        "komatsushima.tokushima.jp",
        "matsushige.tokushima.jp",
        "mima.tokushima.jp",
        "minami.tokushima.jp",
        "miyoshi.tokushima.jp",
        "mugi.tokushima.jp",
        "nakagawa.tokushima.jp",
        "naruto.tokushima.jp",
        "sanagochi.tokushima.jp",
        "shishikui.tokushima.jp",
        "tokushima.tokushima.jp",
        "wajiki.tokushima.jp",
        "adachi.tokyo.jp",
        "akiruno.tokyo.jp",
        "akishima.tokyo.jp",
        "aogashima.tokyo.jp",
        "arakawa.tokyo.jp",
        "bunkyo.tokyo.jp",
        "chiyoda.tokyo.jp",
        "chofu.tokyo.jp",
        "chuo.tokyo.jp",
        "edogawa.tokyo.jp",
        "fuchu.tokyo.jp",
        "fussa.tokyo.jp",
        "hachijo.tokyo.jp",
        "hachioji.tokyo.jp",
        "hamura.tokyo.jp",
        "higashikurume.tokyo.jp",
        "higashimurayama.tokyo.jp",
        "higashiyamato.tokyo.jp",
        "hino.tokyo.jp",
        "hinode.tokyo.jp",
        "hinohara.tokyo.jp",
        "inagi.tokyo.jp",
        "itabashi.tokyo.jp",
        "katsushika.tokyo.jp",
        "kita.tokyo.jp",
        "kiyose.tokyo.jp",
        "kodaira.tokyo.jp",
        "koganei.tokyo.jp",
        "kokubunji.tokyo.jp",
        "komae.tokyo.jp",
        "koto.tokyo.jp",
        "kouzushima.tokyo.jp",
        "kunitachi.tokyo.jp",
        "machida.tokyo.jp",
        "meguro.tokyo.jp",
        "minato.tokyo.jp",
        "mitaka.tokyo.jp",
        "mizuho.tokyo.jp",
        "musashimurayama.tokyo.jp",
        "musashino.tokyo.jp",
        "nakano.tokyo.jp",
        "nerima.tokyo.jp",
        "ogasawara.tokyo.jp",
        "okutama.tokyo.jp",
        "ome.tokyo.jp",
        "oshima.tokyo.jp",
        "ota.tokyo.jp",
        "setagaya.tokyo.jp",
        "shibuya.tokyo.jp",
        "shinagawa.tokyo.jp",
        "shinjuku.tokyo.jp",
        "suginami.tokyo.jp",
        "sumida.tokyo.jp",
        "tachikawa.tokyo.jp",
        "taito.tokyo.jp",
        "tama.tokyo.jp",
        "toshima.tokyo.jp",
        "chizu.tottori.jp",
        "hino.tottori.jp",
        "kawahara.tottori.jp",
        "koge.tottori.jp",
        "kotoura.tottori.jp",
        "misasa.tottori.jp",
        "nanbu.tottori.jp",
        "nichinan.tottori.jp",
        "sakaiminato.tottori.jp",
        "tottori.tottori.jp",
        "wakasa.tottori.jp",
        "yazu.tottori.jp",
        "yonago.tottori.jp",
        "asahi.toyama.jp",
        "fuchu.toyama.jp",
        "fukumitsu.toyama.jp",
        "funahashi.toyama.jp",
        "himi.toyama.jp",
        "imizu.toyama.jp",
        "inami.toyama.jp",
        "johana.toyama.jp",
        "kamiichi.toyama.jp",
        "kurobe.toyama.jp",
        "nakaniikawa.toyama.jp",
        "namerikawa.toyama.jp",
        "nanto.toyama.jp",
        "nyuzen.toyama.jp",
        "oyabe.toyama.jp",
        "taira.toyama.jp",
        "takaoka.toyama.jp",
        "tateyama.toyama.jp",
        "toga.toyama.jp",
        "tonami.toyama.jp",
        "toyama.toyama.jp",
        "unazuki.toyama.jp",
        "uozu.toyama.jp",
        "yamada.toyama.jp",
        "arida.wakayama.jp",
        "aridagawa.wakayama.jp",
        "gobo.wakayama.jp",
        "hashimoto.wakayama.jp",
        "hidaka.wakayama.jp",
        "hirogawa.wakayama.jp",
        "inami.wakayama.jp",
        "iwade.wakayama.jp",
        "kainan.wakayama.jp",
        "kamitonda.wakayama.jp",
        "katsuragi.wakayama.jp",
        "kimino.wakayama.jp",
        "kinokawa.wakayama.jp",
        "kitayama.wakayama.jp",
        "koya.wakayama.jp",
        "koza.wakayama.jp",
        "kozagawa.wakayama.jp",
        "kudoyama.wakayama.jp",
        "kushimoto.wakayama.jp",
        "mihama.wakayama.jp",
        "misato.wakayama.jp",
        "nachikatsuura.wakayama.jp",
        "shingu.wakayama.jp",
        "shirahama.wakayama.jp",
        "taiji.wakayama.jp",
        "tanabe.wakayama.jp",
        "wakayama.wakayama.jp",
        "yuasa.wakayama.jp",
        "yura.wakayama.jp",
        "asahi.yamagata.jp",
        "funagata.yamagata.jp",
        "higashine.yamagata.jp",
        "iide.yamagata.jp",
        "kahoku.yamagata.jp",
        "kaminoyama.yamagata.jp",
        "kaneyama.yamagata.jp",
        "kawanishi.yamagata.jp",
        "mamurogawa.yamagata.jp",
        "mikawa.yamagata.jp",
        "murayama.yamagata.jp",
        "nagai.yamagata.jp",
        "nakayama.yamagata.jp",
        "nanyo.yamagata.jp",
        "nishikawa.yamagata.jp",
        "obanazawa.yamagata.jp",
        "oe.yamagata.jp",
        "oguni.yamagata.jp",
        "ohkura.yamagata.jp",
        "oishida.yamagata.jp",
        "sagae.yamagata.jp",
        "sakata.yamagata.jp",
        "sakegawa.yamagata.jp",
        "shinjo.yamagata.jp",
        "shirataka.yamagata.jp",
        "shonai.yamagata.jp",
        "takahata.yamagata.jp",
        "tendo.yamagata.jp",
        "tozawa.yamagata.jp",
        "tsuruoka.yamagata.jp",
        "yamagata.yamagata.jp",
        "yamanobe.yamagata.jp",
        "yonezawa.yamagata.jp",
        "yuza.yamagata.jp",
        "abu.yamaguchi.jp",
        "hagi.yamaguchi.jp",
        "hikari.yamaguchi.jp",
        "hofu.yamaguchi.jp",
        "iwakuni.yamaguchi.jp",
        "kudamatsu.yamaguchi.jp",
        "mitou.yamaguchi.jp",
        "nagato.yamaguchi.jp",
        "oshima.yamaguchi.jp",
        "shimonoseki.yamaguchi.jp",
        "shunan.yamaguchi.jp",
        "tabuse.yamaguchi.jp",
        "tokuyama.yamaguchi.jp",
        "toyota.yamaguchi.jp",
        "ube.yamaguchi.jp",
        "yuu.yamaguchi.jp",
        "chuo.yamanashi.jp",
        "doshi.yamanashi.jp",
        "fuefuki.yamanashi.jp",
        "fujikawa.yamanashi.jp",
        "fujikawaguchiko.yamanashi.jp",
        "fujiyoshida.yamanashi.jp",
        "hayakawa.yamanashi.jp",
        "hokuto.yamanashi.jp",
        "ichikawamisato.yamanashi.jp",
        "kai.yamanashi.jp",
        "kofu.yamanashi.jp",
        "koshu.yamanashi.jp",
        "kosuge.yamanashi.jp",
        "minami-alps.yamanashi.jp",
        "minobu.yamanashi.jp",
        "nakamichi.yamanashi.jp",
        "nanbu.yamanashi.jp",
        "narusawa.yamanashi.jp",
        "nirasaki.yamanashi.jp",
        "nishikatsura.yamanashi.jp",
        "oshino.yamanashi.jp",
        "otsuki.yamanashi.jp",
        "showa.yamanashi.jp",
        "tabayama.yamanashi.jp",
        "tsuru.yamanashi.jp",
        "uenohara.yamanashi.jp",
        "yamanakako.yamanashi.jp",
        "yamanashi.yamanashi.jp",
        "ke",
        "ac.ke",
        "co.ke",
        "go.ke",
        "info.ke",
        "me.ke",
        "mobi.ke",
        "ne.ke",
        "or.ke",
        "sc.ke",
        "kg",
        "org.kg",
        "net.kg",
        "com.kg",
        "edu.kg",
        "gov.kg",
        "mil.kg",
        "*.kh",
        "ki",
        "edu.ki",
        "biz.ki",
        "net.ki",
        "org.ki",
        "gov.ki",
        "info.ki",
        "com.ki",
        "km",
        "org.km",
        "nom.km",
        "gov.km",
        "prd.km",
        "tm.km",
        "edu.km",
        "mil.km",
        "ass.km",
        "com.km",
        "coop.km",
        "asso.km",
        "presse.km",
        "medecin.km",
        "notaires.km",
        "pharmaciens.km",
        "veterinaire.km",
        "gouv.km",
        "kn",
        "net.kn",
        "org.kn",
        "edu.kn",
        "gov.kn",
        "kp",
        "com.kp",
        "edu.kp",
        "gov.kp",
        "org.kp",
        "rep.kp",
        "tra.kp",
        "kr",
        "ac.kr",
        "co.kr",
        "es.kr",
        "go.kr",
        "hs.kr",
        "kg.kr",
        "mil.kr",
        "ms.kr",
        "ne.kr",
        "or.kr",
        "pe.kr",
        "re.kr",
        "sc.kr",
        "busan.kr",
        "chungbuk.kr",
        "chungnam.kr",
        "daegu.kr",
        "daejeon.kr",
        "gangwon.kr",
        "gwangju.kr",
        "gyeongbuk.kr",
        "gyeonggi.kr",
        "gyeongnam.kr",
        "incheon.kr",
        "jeju.kr",
        "jeonbuk.kr",
        "jeonnam.kr",
        "seoul.kr",
        "ulsan.kr",
        "kw",
        "com.kw",
        "edu.kw",
        "emb.kw",
        "gov.kw",
        "ind.kw",
        "net.kw",
        "org.kw",
        "ky",
        "com.ky",
        "edu.ky",
        "net.ky",
        "org.ky",
        "kz",
        "org.kz",
        "edu.kz",
        "net.kz",
        "gov.kz",
        "mil.kz",
        "com.kz",
        "la",
        "int.la",
        "net.la",
        "info.la",
        "edu.la",
        "gov.la",
        "per.la",
        "com.la",
        "org.la",
        "lb",
        "com.lb",
        "edu.lb",
        "gov.lb",
        "net.lb",
        "org.lb",
        "lc",
        "com.lc",
        "net.lc",
        "co.lc",
        "org.lc",
        "edu.lc",
        "gov.lc",
        "li",
        "lk",
        "gov.lk",
        "sch.lk",
        "net.lk",
        "int.lk",
        "com.lk",
        "org.lk",
        "edu.lk",
        "ngo.lk",
        "soc.lk",
        "web.lk",
        "ltd.lk",
        "assn.lk",
        "grp.lk",
        "hotel.lk",
        "ac.lk",
        "lr",
        "com.lr",
        "edu.lr",
        "gov.lr",
        "org.lr",
        "net.lr",
        "ls",
        "ac.ls",
        "biz.ls",
        "co.ls",
        "edu.ls",
        "gov.ls",
        "info.ls",
        "net.ls",
        "org.ls",
        "sc.ls",
        "lt",
        "gov.lt",
        "lu",
        "lv",
        "com.lv",
        "edu.lv",
        "gov.lv",
        "org.lv",
        "mil.lv",
        "id.lv",
        "net.lv",
        "asn.lv",
        "conf.lv",
        "ly",
        "com.ly",
        "net.ly",
        "gov.ly",
        "plc.ly",
        "edu.ly",
        "sch.ly",
        "med.ly",
        "org.ly",
        "id.ly",
        "ma",
        "co.ma",
        "net.ma",
        "gov.ma",
        "org.ma",
        "ac.ma",
        "press.ma",
        "mc",
        "tm.mc",
        "asso.mc",
        "md",
        "me",
        "co.me",
        "net.me",
        "org.me",
        "edu.me",
        "ac.me",
        "gov.me",
        "its.me",
        "priv.me",
        "mg",
        "org.mg",
        "nom.mg",
        "gov.mg",
        "prd.mg",
        "tm.mg",
        "edu.mg",
        "mil.mg",
        "com.mg",
        "co.mg",
        "mh",
        "mil",
        "mk",
        "com.mk",
        "org.mk",
        "net.mk",
        "edu.mk",
        "gov.mk",
        "inf.mk",
        "name.mk",
        "ml",
        "com.ml",
        "edu.ml",
        "gouv.ml",
        "gov.ml",
        "net.ml",
        "org.ml",
        "presse.ml",
        "*.mm",
        "mn",
        "gov.mn",
        "edu.mn",
        "org.mn",
        "mo",
        "com.mo",
        "net.mo",
        "org.mo",
        "edu.mo",
        "gov.mo",
        "mobi",
        "mp",
        "mq",
        "mr",
        "gov.mr",
        "ms",
        "com.ms",
        "edu.ms",
        "gov.ms",
        "net.ms",
        "org.ms",
        "mt",
        "com.mt",
        "edu.mt",
        "net.mt",
        "org.mt",
        "mu",
        "com.mu",
        "net.mu",
        "org.mu",
        "gov.mu",
        "ac.mu",
        "co.mu",
        "or.mu",
        "museum",
        "academy.museum",
        "agriculture.museum",
        "air.museum",
        "airguard.museum",
        "alabama.museum",
        "alaska.museum",
        "amber.museum",
        "ambulance.museum",
        "american.museum",
        "americana.museum",
        "americanantiques.museum",
        "americanart.museum",
        "amsterdam.museum",
        "and.museum",
        "annefrank.museum",
        "anthro.museum",
        "anthropology.museum",
        "antiques.museum",
        "aquarium.museum",
        "arboretum.museum",
        "archaeological.museum",
        "archaeology.museum",
        "architecture.museum",
        "art.museum",
        "artanddesign.museum",
        "artcenter.museum",
        "artdeco.museum",
        "arteducation.museum",
        "artgallery.museum",
        "arts.museum",
        "artsandcrafts.museum",
        "asmatart.museum",
        "assassination.museum",
        "assisi.museum",
        "association.museum",
        "astronomy.museum",
        "atlanta.museum",
        "austin.museum",
        "australia.museum",
        "automotive.museum",
        "aviation.museum",
        "axis.museum",
        "badajoz.museum",
        "baghdad.museum",
        "bahn.museum",
        "bale.museum",
        "baltimore.museum",
        "barcelona.museum",
        "baseball.museum",
        "basel.museum",
        "baths.museum",
        "bauern.museum",
        "beauxarts.museum",
        "beeldengeluid.museum",
        "bellevue.museum",
        "bergbau.museum",
        "berkeley.museum",
        "berlin.museum",
        "bern.museum",
        "bible.museum",
        "bilbao.museum",
        "bill.museum",
        "birdart.museum",
        "birthplace.museum",
        "bonn.museum",
        "boston.museum",
        "botanical.museum",
        "botanicalgarden.museum",
        "botanicgarden.museum",
        "botany.museum",
        "brandywinevalley.museum",
        "brasil.museum",
        "bristol.museum",
        "british.museum",
        "britishcolumbia.museum",
        "broadcast.museum",
        "brunel.museum",
        "brussel.museum",
        "brussels.museum",
        "bruxelles.museum",
        "building.museum",
        "burghof.museum",
        "bus.museum",
        "bushey.museum",
        "cadaques.museum",
        "california.museum",
        "cambridge.museum",
        "can.museum",
        "canada.museum",
        "capebreton.museum",
        "carrier.museum",
        "cartoonart.museum",
        "casadelamoneda.museum",
        "castle.museum",
        "castres.museum",
        "celtic.museum",
        "center.museum",
        "chattanooga.museum",
        "cheltenham.museum",
        "chesapeakebay.museum",
        "chicago.museum",
        "children.museum",
        "childrens.museum",
        "childrensgarden.museum",
        "chiropractic.museum",
        "chocolate.museum",
        "christiansburg.museum",
        "cincinnati.museum",
        "cinema.museum",
        "circus.museum",
        "civilisation.museum",
        "civilization.museum",
        "civilwar.museum",
        "clinton.museum",
        "clock.museum",
        "coal.museum",
        "coastaldefence.museum",
        "cody.museum",
        "coldwar.museum",
        "collection.museum",
        "colonialwilliamsburg.museum",
        "coloradoplateau.museum",
        "columbia.museum",
        "columbus.museum",
        "communication.museum",
        "communications.museum",
        "community.museum",
        "computer.museum",
        "computerhistory.museum",
        "comunica\xE7\xF5es.museum",
        "contemporary.museum",
        "contemporaryart.museum",
        "convent.museum",
        "copenhagen.museum",
        "corporation.museum",
        "correios-e-telecomunica\xE7\xF5es.museum",
        "corvette.museum",
        "costume.museum",
        "countryestate.museum",
        "county.museum",
        "crafts.museum",
        "cranbrook.museum",
        "creation.museum",
        "cultural.museum",
        "culturalcenter.museum",
        "culture.museum",
        "cyber.museum",
        "cymru.museum",
        "dali.museum",
        "dallas.museum",
        "database.museum",
        "ddr.museum",
        "decorativearts.museum",
        "delaware.museum",
        "delmenhorst.museum",
        "denmark.museum",
        "depot.museum",
        "design.museum",
        "detroit.museum",
        "dinosaur.museum",
        "discovery.museum",
        "dolls.museum",
        "donostia.museum",
        "durham.museum",
        "eastafrica.museum",
        "eastcoast.museum",
        "education.museum",
        "educational.museum",
        "egyptian.museum",
        "eisenbahn.museum",
        "elburg.museum",
        "elvendrell.museum",
        "embroidery.museum",
        "encyclopedic.museum",
        "england.museum",
        "entomology.museum",
        "environment.museum",
        "environmentalconservation.museum",
        "epilepsy.museum",
        "essex.museum",
        "estate.museum",
        "ethnology.museum",
        "exeter.museum",
        "exhibition.museum",
        "family.museum",
        "farm.museum",
        "farmequipment.museum",
        "farmers.museum",
        "farmstead.museum",
        "field.museum",
        "figueres.museum",
        "filatelia.museum",
        "film.museum",
        "fineart.museum",
        "finearts.museum",
        "finland.museum",
        "flanders.museum",
        "florida.museum",
        "force.museum",
        "fortmissoula.museum",
        "fortworth.museum",
        "foundation.museum",
        "francaise.museum",
        "frankfurt.museum",
        "franziskaner.museum",
        "freemasonry.museum",
        "freiburg.museum",
        "fribourg.museum",
        "frog.museum",
        "fundacio.museum",
        "furniture.museum",
        "gallery.museum",
        "garden.museum",
        "gateway.museum",
        "geelvinck.museum",
        "gemological.museum",
        "geology.museum",
        "georgia.museum",
        "giessen.museum",
        "glas.museum",
        "glass.museum",
        "gorge.museum",
        "grandrapids.museum",
        "graz.museum",
        "guernsey.museum",
        "halloffame.museum",
        "hamburg.museum",
        "handson.museum",
        "harvestcelebration.museum",
        "hawaii.museum",
        "health.museum",
        "heimatunduhren.museum",
        "hellas.museum",
        "helsinki.museum",
        "hembygdsforbund.museum",
        "heritage.museum",
        "histoire.museum",
        "historical.museum",
        "historicalsociety.museum",
        "historichouses.museum",
        "historisch.museum",
        "historisches.museum",
        "history.museum",
        "historyofscience.museum",
        "horology.museum",
        "house.museum",
        "humanities.museum",
        "illustration.museum",
        "imageandsound.museum",
        "indian.museum",
        "indiana.museum",
        "indianapolis.museum",
        "indianmarket.museum",
        "intelligence.museum",
        "interactive.museum",
        "iraq.museum",
        "iron.museum",
        "isleofman.museum",
        "jamison.museum",
        "jefferson.museum",
        "jerusalem.museum",
        "jewelry.museum",
        "jewish.museum",
        "jewishart.museum",
        "jfk.museum",
        "journalism.museum",
        "judaica.museum",
        "judygarland.museum",
        "juedisches.museum",
        "juif.museum",
        "karate.museum",
        "karikatur.museum",
        "kids.museum",
        "koebenhavn.museum",
        "koeln.museum",
        "kunst.museum",
        "kunstsammlung.museum",
        "kunstunddesign.museum",
        "labor.museum",
        "labour.museum",
        "lajolla.museum",
        "lancashire.museum",
        "landes.museum",
        "lans.museum",
        "l\xE4ns.museum",
        "larsson.museum",
        "lewismiller.museum",
        "lincoln.museum",
        "linz.museum",
        "living.museum",
        "livinghistory.museum",
        "localhistory.museum",
        "london.museum",
        "losangeles.museum",
        "louvre.museum",
        "loyalist.museum",
        "lucerne.museum",
        "luxembourg.museum",
        "luzern.museum",
        "mad.museum",
        "madrid.museum",
        "mallorca.museum",
        "manchester.museum",
        "mansion.museum",
        "mansions.museum",
        "manx.museum",
        "marburg.museum",
        "maritime.museum",
        "maritimo.museum",
        "maryland.museum",
        "marylhurst.museum",
        "media.museum",
        "medical.museum",
        "medizinhistorisches.museum",
        "meeres.museum",
        "memorial.museum",
        "mesaverde.museum",
        "michigan.museum",
        "midatlantic.museum",
        "military.museum",
        "mill.museum",
        "miners.museum",
        "mining.museum",
        "minnesota.museum",
        "missile.museum",
        "missoula.museum",
        "modern.museum",
        "moma.museum",
        "money.museum",
        "monmouth.museum",
        "monticello.museum",
        "montreal.museum",
        "moscow.museum",
        "motorcycle.museum",
        "muenchen.museum",
        "muenster.museum",
        "mulhouse.museum",
        "muncie.museum",
        "museet.museum",
        "museumcenter.museum",
        "museumvereniging.museum",
        "music.museum",
        "national.museum",
        "nationalfirearms.museum",
        "nationalheritage.museum",
        "nativeamerican.museum",
        "naturalhistory.museum",
        "naturalhistorymuseum.museum",
        "naturalsciences.museum",
        "nature.museum",
        "naturhistorisches.museum",
        "natuurwetenschappen.museum",
        "naumburg.museum",
        "naval.museum",
        "nebraska.museum",
        "neues.museum",
        "newhampshire.museum",
        "newjersey.museum",
        "newmexico.museum",
        "newport.museum",
        "newspaper.museum",
        "newyork.museum",
        "niepce.museum",
        "norfolk.museum",
        "north.museum",
        "nrw.museum",
        "nyc.museum",
        "nyny.museum",
        "oceanographic.museum",
        "oceanographique.museum",
        "omaha.museum",
        "online.museum",
        "ontario.museum",
        "openair.museum",
        "oregon.museum",
        "oregontrail.museum",
        "otago.museum",
        "oxford.museum",
        "pacific.museum",
        "paderborn.museum",
        "palace.museum",
        "paleo.museum",
        "palmsprings.museum",
        "panama.museum",
        "paris.museum",
        "pasadena.museum",
        "pharmacy.museum",
        "philadelphia.museum",
        "philadelphiaarea.museum",
        "philately.museum",
        "phoenix.museum",
        "photography.museum",
        "pilots.museum",
        "pittsburgh.museum",
        "planetarium.museum",
        "plantation.museum",
        "plants.museum",
        "plaza.museum",
        "portal.museum",
        "portland.museum",
        "portlligat.museum",
        "posts-and-telecommunications.museum",
        "preservation.museum",
        "presidio.museum",
        "press.museum",
        "project.museum",
        "public.museum",
        "pubol.museum",
        "quebec.museum",
        "railroad.museum",
        "railway.museum",
        "research.museum",
        "resistance.museum",
        "riodejaneiro.museum",
        "rochester.museum",
        "rockart.museum",
        "roma.museum",
        "russia.museum",
        "saintlouis.museum",
        "salem.museum",
        "salvadordali.museum",
        "salzburg.museum",
        "sandiego.museum",
        "sanfrancisco.museum",
        "santabarbara.museum",
        "santacruz.museum",
        "santafe.museum",
        "saskatchewan.museum",
        "satx.museum",
        "savannahga.museum",
        "schlesisches.museum",
        "schoenbrunn.museum",
        "schokoladen.museum",
        "school.museum",
        "schweiz.museum",
        "science.museum",
        "scienceandhistory.museum",
        "scienceandindustry.museum",
        "sciencecenter.museum",
        "sciencecenters.museum",
        "science-fiction.museum",
        "sciencehistory.museum",
        "sciences.museum",
        "sciencesnaturelles.museum",
        "scotland.museum",
        "seaport.museum",
        "settlement.museum",
        "settlers.museum",
        "shell.museum",
        "sherbrooke.museum",
        "sibenik.museum",
        "silk.museum",
        "ski.museum",
        "skole.museum",
        "society.museum",
        "sologne.museum",
        "soundandvision.museum",
        "southcarolina.museum",
        "southwest.museum",
        "space.museum",
        "spy.museum",
        "square.museum",
        "stadt.museum",
        "stalbans.museum",
        "starnberg.museum",
        "state.museum",
        "stateofdelaware.museum",
        "station.museum",
        "steam.museum",
        "steiermark.museum",
        "stjohn.museum",
        "stockholm.museum",
        "stpetersburg.museum",
        "stuttgart.museum",
        "suisse.museum",
        "surgeonshall.museum",
        "surrey.museum",
        "svizzera.museum",
        "sweden.museum",
        "sydney.museum",
        "tank.museum",
        "tcm.museum",
        "technology.museum",
        "telekommunikation.museum",
        "television.museum",
        "texas.museum",
        "textile.museum",
        "theater.museum",
        "time.museum",
        "timekeeping.museum",
        "topology.museum",
        "torino.museum",
        "touch.museum",
        "town.museum",
        "transport.museum",
        "tree.museum",
        "trolley.museum",
        "trust.museum",
        "trustee.museum",
        "uhren.museum",
        "ulm.museum",
        "undersea.museum",
        "university.museum",
        "usa.museum",
        "usantiques.museum",
        "usarts.museum",
        "uscountryestate.museum",
        "usculture.museum",
        "usdecorativearts.museum",
        "usgarden.museum",
        "ushistory.museum",
        "ushuaia.museum",
        "uslivinghistory.museum",
        "utah.museum",
        "uvic.museum",
        "valley.museum",
        "vantaa.museum",
        "versailles.museum",
        "viking.museum",
        "village.museum",
        "virginia.museum",
        "virtual.museum",
        "virtuel.museum",
        "vlaanderen.museum",
        "volkenkunde.museum",
        "wales.museum",
        "wallonie.museum",
        "war.museum",
        "washingtondc.museum",
        "watchandclock.museum",
        "watch-and-clock.museum",
        "western.museum",
        "westfalen.museum",
        "whaling.museum",
        "wildlife.museum",
        "williamsburg.museum",
        "windmill.museum",
        "workshop.museum",
        "york.museum",
        "yorkshire.museum",
        "yosemite.museum",
        "youth.museum",
        "zoological.museum",
        "zoology.museum",
        "\u05D9\u05E8\u05D5\u05E9\u05DC\u05D9\u05DD.museum",
        "\u0438\u043A\u043E\u043C.museum",
        "mv",
        "aero.mv",
        "biz.mv",
        "com.mv",
        "coop.mv",
        "edu.mv",
        "gov.mv",
        "info.mv",
        "int.mv",
        "mil.mv",
        "museum.mv",
        "name.mv",
        "net.mv",
        "org.mv",
        "pro.mv",
        "mw",
        "ac.mw",
        "biz.mw",
        "co.mw",
        "com.mw",
        "coop.mw",
        "edu.mw",
        "gov.mw",
        "int.mw",
        "museum.mw",
        "net.mw",
        "org.mw",
        "mx",
        "com.mx",
        "org.mx",
        "gob.mx",
        "edu.mx",
        "net.mx",
        "my",
        "biz.my",
        "com.my",
        "edu.my",
        "gov.my",
        "mil.my",
        "name.my",
        "net.my",
        "org.my",
        "mz",
        "ac.mz",
        "adv.mz",
        "co.mz",
        "edu.mz",
        "gov.mz",
        "mil.mz",
        "net.mz",
        "org.mz",
        "na",
        "info.na",
        "pro.na",
        "name.na",
        "school.na",
        "or.na",
        "dr.na",
        "us.na",
        "mx.na",
        "ca.na",
        "in.na",
        "cc.na",
        "tv.na",
        "ws.na",
        "mobi.na",
        "co.na",
        "com.na",
        "org.na",
        "name",
        "nc",
        "asso.nc",
        "nom.nc",
        "ne",
        "net",
        "nf",
        "com.nf",
        "net.nf",
        "per.nf",
        "rec.nf",
        "web.nf",
        "arts.nf",
        "firm.nf",
        "info.nf",
        "other.nf",
        "store.nf",
        "ng",
        "com.ng",
        "edu.ng",
        "gov.ng",
        "i.ng",
        "mil.ng",
        "mobi.ng",
        "name.ng",
        "net.ng",
        "org.ng",
        "sch.ng",
        "ni",
        "ac.ni",
        "biz.ni",
        "co.ni",
        "com.ni",
        "edu.ni",
        "gob.ni",
        "in.ni",
        "info.ni",
        "int.ni",
        "mil.ni",
        "net.ni",
        "nom.ni",
        "org.ni",
        "web.ni",
        "nl",
        "no",
        "fhs.no",
        "vgs.no",
        "fylkesbibl.no",
        "folkebibl.no",
        "museum.no",
        "idrett.no",
        "priv.no",
        "mil.no",
        "stat.no",
        "dep.no",
        "kommune.no",
        "herad.no",
        "aa.no",
        "ah.no",
        "bu.no",
        "fm.no",
        "hl.no",
        "hm.no",
        "jan-mayen.no",
        "mr.no",
        "nl.no",
        "nt.no",
        "of.no",
        "ol.no",
        "oslo.no",
        "rl.no",
        "sf.no",
        "st.no",
        "svalbard.no",
        "tm.no",
        "tr.no",
        "va.no",
        "vf.no",
        "gs.aa.no",
        "gs.ah.no",
        "gs.bu.no",
        "gs.fm.no",
        "gs.hl.no",
        "gs.hm.no",
        "gs.jan-mayen.no",
        "gs.mr.no",
        "gs.nl.no",
        "gs.nt.no",
        "gs.of.no",
        "gs.ol.no",
        "gs.oslo.no",
        "gs.rl.no",
        "gs.sf.no",
        "gs.st.no",
        "gs.svalbard.no",
        "gs.tm.no",
        "gs.tr.no",
        "gs.va.no",
        "gs.vf.no",
        "akrehamn.no",
        "\xE5krehamn.no",
        "algard.no",
        "\xE5lg\xE5rd.no",
        "arna.no",
        "brumunddal.no",
        "bryne.no",
        "bronnoysund.no",
        "br\xF8nn\xF8ysund.no",
        "drobak.no",
        "dr\xF8bak.no",
        "egersund.no",
        "fetsund.no",
        "floro.no",
        "flor\xF8.no",
        "fredrikstad.no",
        "hokksund.no",
        "honefoss.no",
        "h\xF8nefoss.no",
        "jessheim.no",
        "jorpeland.no",
        "j\xF8rpeland.no",
        "kirkenes.no",
        "kopervik.no",
        "krokstadelva.no",
        "langevag.no",
        "langev\xE5g.no",
        "leirvik.no",
        "mjondalen.no",
        "mj\xF8ndalen.no",
        "mo-i-rana.no",
        "mosjoen.no",
        "mosj\xF8en.no",
        "nesoddtangen.no",
        "orkanger.no",
        "osoyro.no",
        "os\xF8yro.no",
        "raholt.no",
        "r\xE5holt.no",
        "sandnessjoen.no",
        "sandnessj\xF8en.no",
        "skedsmokorset.no",
        "slattum.no",
        "spjelkavik.no",
        "stathelle.no",
        "stavern.no",
        "stjordalshalsen.no",
        "stj\xF8rdalshalsen.no",
        "tananger.no",
        "tranby.no",
        "vossevangen.no",
        "afjord.no",
        "\xE5fjord.no",
        "agdenes.no",
        "al.no",
        "\xE5l.no",
        "alesund.no",
        "\xE5lesund.no",
        "alstahaug.no",
        "alta.no",
        "\xE1lt\xE1.no",
        "alaheadju.no",
        "\xE1laheadju.no",
        "alvdal.no",
        "amli.no",
        "\xE5mli.no",
        "amot.no",
        "\xE5mot.no",
        "andebu.no",
        "andoy.no",
        "and\xF8y.no",
        "andasuolo.no",
        "ardal.no",
        "\xE5rdal.no",
        "aremark.no",
        "arendal.no",
        "\xE5s.no",
        "aseral.no",
        "\xE5seral.no",
        "asker.no",
        "askim.no",
        "askvoll.no",
        "askoy.no",
        "ask\xF8y.no",
        "asnes.no",
        "\xE5snes.no",
        "audnedaln.no",
        "aukra.no",
        "aure.no",
        "aurland.no",
        "aurskog-holand.no",
        "aurskog-h\xF8land.no",
        "austevoll.no",
        "austrheim.no",
        "averoy.no",
        "aver\xF8y.no",
        "balestrand.no",
        "ballangen.no",
        "balat.no",
        "b\xE1l\xE1t.no",
        "balsfjord.no",
        "bahccavuotna.no",
        "b\xE1hccavuotna.no",
        "bamble.no",
        "bardu.no",
        "beardu.no",
        "beiarn.no",
        "bajddar.no",
        "b\xE1jddar.no",
        "baidar.no",
        "b\xE1id\xE1r.no",
        "berg.no",
        "bergen.no",
        "berlevag.no",
        "berlev\xE5g.no",
        "bearalvahki.no",
        "bearalv\xE1hki.no",
        "bindal.no",
        "birkenes.no",
        "bjarkoy.no",
        "bjark\xF8y.no",
        "bjerkreim.no",
        "bjugn.no",
        "bodo.no",
        "bod\xF8.no",
        "badaddja.no",
        "b\xE5d\xE5ddj\xE5.no",
        "budejju.no",
        "bokn.no",
        "bremanger.no",
        "bronnoy.no",
        "br\xF8nn\xF8y.no",
        "bygland.no",
        "bykle.no",
        "barum.no",
        "b\xE6rum.no",
        "bo.telemark.no",
        "b\xF8.telemark.no",
        "bo.nordland.no",
        "b\xF8.nordland.no",
        "bievat.no",
        "biev\xE1t.no",
        "bomlo.no",
        "b\xF8mlo.no",
        "batsfjord.no",
        "b\xE5tsfjord.no",
        "bahcavuotna.no",
        "b\xE1hcavuotna.no",
        "dovre.no",
        "drammen.no",
        "drangedal.no",
        "dyroy.no",
        "dyr\xF8y.no",
        "donna.no",
        "d\xF8nna.no",
        "eid.no",
        "eidfjord.no",
        "eidsberg.no",
        "eidskog.no",
        "eidsvoll.no",
        "eigersund.no",
        "elverum.no",
        "enebakk.no",
        "engerdal.no",
        "etne.no",
        "etnedal.no",
        "evenes.no",
        "evenassi.no",
        "even\xE1\u0161\u0161i.no",
        "evje-og-hornnes.no",
        "farsund.no",
        "fauske.no",
        "fuossko.no",
        "fuoisku.no",
        "fedje.no",
        "fet.no",
        "finnoy.no",
        "finn\xF8y.no",
        "fitjar.no",
        "fjaler.no",
        "fjell.no",
        "flakstad.no",
        "flatanger.no",
        "flekkefjord.no",
        "flesberg.no",
        "flora.no",
        "fla.no",
        "fl\xE5.no",
        "folldal.no",
        "forsand.no",
        "fosnes.no",
        "frei.no",
        "frogn.no",
        "froland.no",
        "frosta.no",
        "frana.no",
        "fr\xE6na.no",
        "froya.no",
        "fr\xF8ya.no",
        "fusa.no",
        "fyresdal.no",
        "forde.no",
        "f\xF8rde.no",
        "gamvik.no",
        "gangaviika.no",
        "g\xE1\u014Bgaviika.no",
        "gaular.no",
        "gausdal.no",
        "gildeskal.no",
        "gildesk\xE5l.no",
        "giske.no",
        "gjemnes.no",
        "gjerdrum.no",
        "gjerstad.no",
        "gjesdal.no",
        "gjovik.no",
        "gj\xF8vik.no",
        "gloppen.no",
        "gol.no",
        "gran.no",
        "grane.no",
        "granvin.no",
        "gratangen.no",
        "grimstad.no",
        "grong.no",
        "kraanghke.no",
        "kr\xE5anghke.no",
        "grue.no",
        "gulen.no",
        "hadsel.no",
        "halden.no",
        "halsa.no",
        "hamar.no",
        "hamaroy.no",
        "habmer.no",
        "h\xE1bmer.no",
        "hapmir.no",
        "h\xE1pmir.no",
        "hammerfest.no",
        "hammarfeasta.no",
        "h\xE1mm\xE1rfeasta.no",
        "haram.no",
        "hareid.no",
        "harstad.no",
        "hasvik.no",
        "aknoluokta.no",
        "\xE1k\u014Boluokta.no",
        "hattfjelldal.no",
        "aarborte.no",
        "haugesund.no",
        "hemne.no",
        "hemnes.no",
        "hemsedal.no",
        "heroy.more-og-romsdal.no",
        "her\xF8y.m\xF8re-og-romsdal.no",
        "heroy.nordland.no",
        "her\xF8y.nordland.no",
        "hitra.no",
        "hjartdal.no",
        "hjelmeland.no",
        "hobol.no",
        "hob\xF8l.no",
        "hof.no",
        "hol.no",
        "hole.no",
        "holmestrand.no",
        "holtalen.no",
        "holt\xE5len.no",
        "hornindal.no",
        "horten.no",
        "hurdal.no",
        "hurum.no",
        "hvaler.no",
        "hyllestad.no",
        "hagebostad.no",
        "h\xE6gebostad.no",
        "hoyanger.no",
        "h\xF8yanger.no",
        "hoylandet.no",
        "h\xF8ylandet.no",
        "ha.no",
        "h\xE5.no",
        "ibestad.no",
        "inderoy.no",
        "inder\xF8y.no",
        "iveland.no",
        "jevnaker.no",
        "jondal.no",
        "jolster.no",
        "j\xF8lster.no",
        "karasjok.no",
        "karasjohka.no",
        "k\xE1r\xE1\u0161johka.no",
        "karlsoy.no",
        "galsa.no",
        "g\xE1ls\xE1.no",
        "karmoy.no",
        "karm\xF8y.no",
        "kautokeino.no",
        "guovdageaidnu.no",
        "klepp.no",
        "klabu.no",
        "kl\xE6bu.no",
        "kongsberg.no",
        "kongsvinger.no",
        "kragero.no",
        "krager\xF8.no",
        "kristiansand.no",
        "kristiansund.no",
        "krodsherad.no",
        "kr\xF8dsherad.no",
        "kvalsund.no",
        "rahkkeravju.no",
        "r\xE1hkker\xE1vju.no",
        "kvam.no",
        "kvinesdal.no",
        "kvinnherad.no",
        "kviteseid.no",
        "kvitsoy.no",
        "kvits\xF8y.no",
        "kvafjord.no",
        "kv\xE6fjord.no",
        "giehtavuoatna.no",
        "kvanangen.no",
        "kv\xE6nangen.no",
        "navuotna.no",
        "n\xE1vuotna.no",
        "kafjord.no",
        "k\xE5fjord.no",
        "gaivuotna.no",
        "g\xE1ivuotna.no",
        "larvik.no",
        "lavangen.no",
        "lavagis.no",
        "loabat.no",
        "loab\xE1t.no",
        "lebesby.no",
        "davvesiida.no",
        "leikanger.no",
        "leirfjord.no",
        "leka.no",
        "leksvik.no",
        "lenvik.no",
        "leangaviika.no",
        "lea\u014Bgaviika.no",
        "lesja.no",
        "levanger.no",
        "lier.no",
        "lierne.no",
        "lillehammer.no",
        "lillesand.no",
        "lindesnes.no",
        "lindas.no",
        "lind\xE5s.no",
        "lom.no",
        "loppa.no",
        "lahppi.no",
        "l\xE1hppi.no",
        "lund.no",
        "lunner.no",
        "luroy.no",
        "lur\xF8y.no",
        "luster.no",
        "lyngdal.no",
        "lyngen.no",
        "ivgu.no",
        "lardal.no",
        "lerdal.no",
        "l\xE6rdal.no",
        "lodingen.no",
        "l\xF8dingen.no",
        "lorenskog.no",
        "l\xF8renskog.no",
        "loten.no",
        "l\xF8ten.no",
        "malvik.no",
        "masoy.no",
        "m\xE5s\xF8y.no",
        "muosat.no",
        "muos\xE1t.no",
        "mandal.no",
        "marker.no",
        "marnardal.no",
        "masfjorden.no",
        "meland.no",
        "meldal.no",
        "melhus.no",
        "meloy.no",
        "mel\xF8y.no",
        "meraker.no",
        "mer\xE5ker.no",
        "moareke.no",
        "mo\xE5reke.no",
        "midsund.no",
        "midtre-gauldal.no",
        "modalen.no",
        "modum.no",
        "molde.no",
        "moskenes.no",
        "moss.no",
        "mosvik.no",
        "malselv.no",
        "m\xE5lselv.no",
        "malatvuopmi.no",
        "m\xE1latvuopmi.no",
        "namdalseid.no",
        "aejrie.no",
        "namsos.no",
        "namsskogan.no",
        "naamesjevuemie.no",
        "n\xE5\xE5mesjevuemie.no",
        "laakesvuemie.no",
        "nannestad.no",
        "narvik.no",
        "narviika.no",
        "naustdal.no",
        "nedre-eiker.no",
        "nes.akershus.no",
        "nes.buskerud.no",
        "nesna.no",
        "nesodden.no",
        "nesseby.no",
        "unjarga.no",
        "unj\xE1rga.no",
        "nesset.no",
        "nissedal.no",
        "nittedal.no",
        "nord-aurdal.no",
        "nord-fron.no",
        "nord-odal.no",
        "norddal.no",
        "nordkapp.no",
        "davvenjarga.no",
        "davvenj\xE1rga.no",
        "nordre-land.no",
        "nordreisa.no",
        "raisa.no",
        "r\xE1isa.no",
        "nore-og-uvdal.no",
        "notodden.no",
        "naroy.no",
        "n\xE6r\xF8y.no",
        "notteroy.no",
        "n\xF8tter\xF8y.no",
        "odda.no",
        "oksnes.no",
        "\xF8ksnes.no",
        "oppdal.no",
        "oppegard.no",
        "oppeg\xE5rd.no",
        "orkdal.no",
        "orland.no",
        "\xF8rland.no",
        "orskog.no",
        "\xF8rskog.no",
        "orsta.no",
        "\xF8rsta.no",
        "os.hedmark.no",
        "os.hordaland.no",
        "osen.no",
        "osteroy.no",
        "oster\xF8y.no",
        "ostre-toten.no",
        "\xF8stre-toten.no",
        "overhalla.no",
        "ovre-eiker.no",
        "\xF8vre-eiker.no",
        "oyer.no",
        "\xF8yer.no",
        "oygarden.no",
        "\xF8ygarden.no",
        "oystre-slidre.no",
        "\xF8ystre-slidre.no",
        "porsanger.no",
        "porsangu.no",
        "pors\xE1\u014Bgu.no",
        "porsgrunn.no",
        "radoy.no",
        "rad\xF8y.no",
        "rakkestad.no",
        "rana.no",
        "ruovat.no",
        "randaberg.no",
        "rauma.no",
        "rendalen.no",
        "rennebu.no",
        "rennesoy.no",
        "rennes\xF8y.no",
        "rindal.no",
        "ringebu.no",
        "ringerike.no",
        "ringsaker.no",
        "rissa.no",
        "risor.no",
        "ris\xF8r.no",
        "roan.no",
        "rollag.no",
        "rygge.no",
        "ralingen.no",
        "r\xE6lingen.no",
        "rodoy.no",
        "r\xF8d\xF8y.no",
        "romskog.no",
        "r\xF8mskog.no",
        "roros.no",
        "r\xF8ros.no",
        "rost.no",
        "r\xF8st.no",
        "royken.no",
        "r\xF8yken.no",
        "royrvik.no",
        "r\xF8yrvik.no",
        "rade.no",
        "r\xE5de.no",
        "salangen.no",
        "siellak.no",
        "saltdal.no",
        "salat.no",
        "s\xE1l\xE1t.no",
        "s\xE1lat.no",
        "samnanger.no",
        "sande.more-og-romsdal.no",
        "sande.m\xF8re-og-romsdal.no",
        "sande.vestfold.no",
        "sandefjord.no",
        "sandnes.no",
        "sandoy.no",
        "sand\xF8y.no",
        "sarpsborg.no",
        "sauda.no",
        "sauherad.no",
        "sel.no",
        "selbu.no",
        "selje.no",
        "seljord.no",
        "sigdal.no",
        "siljan.no",
        "sirdal.no",
        "skaun.no",
        "skedsmo.no",
        "ski.no",
        "skien.no",
        "skiptvet.no",
        "skjervoy.no",
        "skjerv\xF8y.no",
        "skierva.no",
        "skierv\xE1.no",
        "skjak.no",
        "skj\xE5k.no",
        "skodje.no",
        "skanland.no",
        "sk\xE5nland.no",
        "skanit.no",
        "sk\xE1nit.no",
        "smola.no",
        "sm\xF8la.no",
        "snillfjord.no",
        "snasa.no",
        "sn\xE5sa.no",
        "snoasa.no",
        "snaase.no",
        "sn\xE5ase.no",
        "sogndal.no",
        "sokndal.no",
        "sola.no",
        "solund.no",
        "songdalen.no",
        "sortland.no",
        "spydeberg.no",
        "stange.no",
        "stavanger.no",
        "steigen.no",
        "steinkjer.no",
        "stjordal.no",
        "stj\xF8rdal.no",
        "stokke.no",
        "stor-elvdal.no",
        "stord.no",
        "stordal.no",
        "storfjord.no",
        "omasvuotna.no",
        "strand.no",
        "stranda.no",
        "stryn.no",
        "sula.no",
        "suldal.no",
        "sund.no",
        "sunndal.no",
        "surnadal.no",
        "sveio.no",
        "svelvik.no",
        "sykkylven.no",
        "sogne.no",
        "s\xF8gne.no",
        "somna.no",
        "s\xF8mna.no",
        "sondre-land.no",
        "s\xF8ndre-land.no",
        "sor-aurdal.no",
        "s\xF8r-aurdal.no",
        "sor-fron.no",
        "s\xF8r-fron.no",
        "sor-odal.no",
        "s\xF8r-odal.no",
        "sor-varanger.no",
        "s\xF8r-varanger.no",
        "matta-varjjat.no",
        "m\xE1tta-v\xE1rjjat.no",
        "sorfold.no",
        "s\xF8rfold.no",
        "sorreisa.no",
        "s\xF8rreisa.no",
        "sorum.no",
        "s\xF8rum.no",
        "tana.no",
        "deatnu.no",
        "time.no",
        "tingvoll.no",
        "tinn.no",
        "tjeldsund.no",
        "dielddanuorri.no",
        "tjome.no",
        "tj\xF8me.no",
        "tokke.no",
        "tolga.no",
        "torsken.no",
        "tranoy.no",
        "tran\xF8y.no",
        "tromso.no",
        "troms\xF8.no",
        "tromsa.no",
        "romsa.no",
        "trondheim.no",
        "troandin.no",
        "trysil.no",
        "trana.no",
        "tr\xE6na.no",
        "trogstad.no",
        "tr\xF8gstad.no",
        "tvedestrand.no",
        "tydal.no",
        "tynset.no",
        "tysfjord.no",
        "divtasvuodna.no",
        "divttasvuotna.no",
        "tysnes.no",
        "tysvar.no",
        "tysv\xE6r.no",
        "tonsberg.no",
        "t\xF8nsberg.no",
        "ullensaker.no",
        "ullensvang.no",
        "ulvik.no",
        "utsira.no",
        "vadso.no",
        "vads\xF8.no",
        "cahcesuolo.no",
        "\u010D\xE1hcesuolo.no",
        "vaksdal.no",
        "valle.no",
        "vang.no",
        "vanylven.no",
        "vardo.no",
        "vard\xF8.no",
        "varggat.no",
        "v\xE1rgg\xE1t.no",
        "vefsn.no",
        "vaapste.no",
        "vega.no",
        "vegarshei.no",
        "veg\xE5rshei.no",
        "vennesla.no",
        "verdal.no",
        "verran.no",
        "vestby.no",
        "vestnes.no",
        "vestre-slidre.no",
        "vestre-toten.no",
        "vestvagoy.no",
        "vestv\xE5g\xF8y.no",
        "vevelstad.no",
        "vik.no",
        "vikna.no",
        "vindafjord.no",
        "volda.no",
        "voss.no",
        "varoy.no",
        "v\xE6r\xF8y.no",
        "vagan.no",
        "v\xE5gan.no",
        "voagat.no",
        "vagsoy.no",
        "v\xE5gs\xF8y.no",
        "vaga.no",
        "v\xE5g\xE5.no",
        "valer.ostfold.no",
        "v\xE5ler.\xF8stfold.no",
        "valer.hedmark.no",
        "v\xE5ler.hedmark.no",
        "*.np",
        "nr",
        "biz.nr",
        "info.nr",
        "gov.nr",
        "edu.nr",
        "org.nr",
        "net.nr",
        "com.nr",
        "nu",
        "nz",
        "ac.nz",
        "co.nz",
        "cri.nz",
        "geek.nz",
        "gen.nz",
        "govt.nz",
        "health.nz",
        "iwi.nz",
        "kiwi.nz",
        "maori.nz",
        "mil.nz",
        "m\u0101ori.nz",
        "net.nz",
        "org.nz",
        "parliament.nz",
        "school.nz",
        "om",
        "co.om",
        "com.om",
        "edu.om",
        "gov.om",
        "med.om",
        "museum.om",
        "net.om",
        "org.om",
        "pro.om",
        "onion",
        "org",
        "pa",
        "ac.pa",
        "gob.pa",
        "com.pa",
        "org.pa",
        "sld.pa",
        "edu.pa",
        "net.pa",
        "ing.pa",
        "abo.pa",
        "med.pa",
        "nom.pa",
        "pe",
        "edu.pe",
        "gob.pe",
        "nom.pe",
        "mil.pe",
        "org.pe",
        "com.pe",
        "net.pe",
        "pf",
        "com.pf",
        "org.pf",
        "edu.pf",
        "*.pg",
        "ph",
        "com.ph",
        "net.ph",
        "org.ph",
        "gov.ph",
        "edu.ph",
        "ngo.ph",
        "mil.ph",
        "i.ph",
        "pk",
        "com.pk",
        "net.pk",
        "edu.pk",
        "org.pk",
        "fam.pk",
        "biz.pk",
        "web.pk",
        "gov.pk",
        "gob.pk",
        "gok.pk",
        "gon.pk",
        "gop.pk",
        "gos.pk",
        "info.pk",
        "pl",
        "com.pl",
        "net.pl",
        "org.pl",
        "aid.pl",
        "agro.pl",
        "atm.pl",
        "auto.pl",
        "biz.pl",
        "edu.pl",
        "gmina.pl",
        "gsm.pl",
        "info.pl",
        "mail.pl",
        "miasta.pl",
        "media.pl",
        "mil.pl",
        "nieruchomosci.pl",
        "nom.pl",
        "pc.pl",
        "powiat.pl",
        "priv.pl",
        "realestate.pl",
        "rel.pl",
        "sex.pl",
        "shop.pl",
        "sklep.pl",
        "sos.pl",
        "szkola.pl",
        "targi.pl",
        "tm.pl",
        "tourism.pl",
        "travel.pl",
        "turystyka.pl",
        "gov.pl",
        "ap.gov.pl",
        "ic.gov.pl",
        "is.gov.pl",
        "us.gov.pl",
        "kmpsp.gov.pl",
        "kppsp.gov.pl",
        "kwpsp.gov.pl",
        "psp.gov.pl",
        "wskr.gov.pl",
        "kwp.gov.pl",
        "mw.gov.pl",
        "ug.gov.pl",
        "um.gov.pl",
        "umig.gov.pl",
        "ugim.gov.pl",
        "upow.gov.pl",
        "uw.gov.pl",
        "starostwo.gov.pl",
        "pa.gov.pl",
        "po.gov.pl",
        "psse.gov.pl",
        "pup.gov.pl",
        "rzgw.gov.pl",
        "sa.gov.pl",
        "so.gov.pl",
        "sr.gov.pl",
        "wsa.gov.pl",
        "sko.gov.pl",
        "uzs.gov.pl",
        "wiih.gov.pl",
        "winb.gov.pl",
        "pinb.gov.pl",
        "wios.gov.pl",
        "witd.gov.pl",
        "wzmiuw.gov.pl",
        "piw.gov.pl",
        "wiw.gov.pl",
        "griw.gov.pl",
        "wif.gov.pl",
        "oum.gov.pl",
        "sdn.gov.pl",
        "zp.gov.pl",
        "uppo.gov.pl",
        "mup.gov.pl",
        "wuoz.gov.pl",
        "konsulat.gov.pl",
        "oirm.gov.pl",
        "augustow.pl",
        "babia-gora.pl",
        "bedzin.pl",
        "beskidy.pl",
        "bialowieza.pl",
        "bialystok.pl",
        "bielawa.pl",
        "bieszczady.pl",
        "boleslawiec.pl",
        "bydgoszcz.pl",
        "bytom.pl",
        "cieszyn.pl",
        "czeladz.pl",
        "czest.pl",
        "dlugoleka.pl",
        "elblag.pl",
        "elk.pl",
        "glogow.pl",
        "gniezno.pl",
        "gorlice.pl",
        "grajewo.pl",
        "ilawa.pl",
        "jaworzno.pl",
        "jelenia-gora.pl",
        "jgora.pl",
        "kalisz.pl",
        "kazimierz-dolny.pl",
        "karpacz.pl",
        "kartuzy.pl",
        "kaszuby.pl",
        "katowice.pl",
        "kepno.pl",
        "ketrzyn.pl",
        "klodzko.pl",
        "kobierzyce.pl",
        "kolobrzeg.pl",
        "konin.pl",
        "konskowola.pl",
        "kutno.pl",
        "lapy.pl",
        "lebork.pl",
        "legnica.pl",
        "lezajsk.pl",
        "limanowa.pl",
        "lomza.pl",
        "lowicz.pl",
        "lubin.pl",
        "lukow.pl",
        "malbork.pl",
        "malopolska.pl",
        "mazowsze.pl",
        "mazury.pl",
        "mielec.pl",
        "mielno.pl",
        "mragowo.pl",
        "naklo.pl",
        "nowaruda.pl",
        "nysa.pl",
        "olawa.pl",
        "olecko.pl",
        "olkusz.pl",
        "olsztyn.pl",
        "opoczno.pl",
        "opole.pl",
        "ostroda.pl",
        "ostroleka.pl",
        "ostrowiec.pl",
        "ostrowwlkp.pl",
        "pila.pl",
        "pisz.pl",
        "podhale.pl",
        "podlasie.pl",
        "polkowice.pl",
        "pomorze.pl",
        "pomorskie.pl",
        "prochowice.pl",
        "pruszkow.pl",
        "przeworsk.pl",
        "pulawy.pl",
        "radom.pl",
        "rawa-maz.pl",
        "rybnik.pl",
        "rzeszow.pl",
        "sanok.pl",
        "sejny.pl",
        "slask.pl",
        "slupsk.pl",
        "sosnowiec.pl",
        "stalowa-wola.pl",
        "skoczow.pl",
        "starachowice.pl",
        "stargard.pl",
        "suwalki.pl",
        "swidnica.pl",
        "swiebodzin.pl",
        "swinoujscie.pl",
        "szczecin.pl",
        "szczytno.pl",
        "tarnobrzeg.pl",
        "tgory.pl",
        "turek.pl",
        "tychy.pl",
        "ustka.pl",
        "walbrzych.pl",
        "warmia.pl",
        "warszawa.pl",
        "waw.pl",
        "wegrow.pl",
        "wielun.pl",
        "wlocl.pl",
        "wloclawek.pl",
        "wodzislaw.pl",
        "wolomin.pl",
        "wroclaw.pl",
        "zachpomor.pl",
        "zagan.pl",
        "zarow.pl",
        "zgora.pl",
        "zgorzelec.pl",
        "pm",
        "pn",
        "gov.pn",
        "co.pn",
        "org.pn",
        "edu.pn",
        "net.pn",
        "post",
        "pr",
        "com.pr",
        "net.pr",
        "org.pr",
        "gov.pr",
        "edu.pr",
        "isla.pr",
        "pro.pr",
        "biz.pr",
        "info.pr",
        "name.pr",
        "est.pr",
        "prof.pr",
        "ac.pr",
        "pro",
        "aaa.pro",
        "aca.pro",
        "acct.pro",
        "avocat.pro",
        "bar.pro",
        "cpa.pro",
        "eng.pro",
        "jur.pro",
        "law.pro",
        "med.pro",
        "recht.pro",
        "ps",
        "edu.ps",
        "gov.ps",
        "sec.ps",
        "plo.ps",
        "com.ps",
        "org.ps",
        "net.ps",
        "pt",
        "net.pt",
        "gov.pt",
        "org.pt",
        "edu.pt",
        "int.pt",
        "publ.pt",
        "com.pt",
        "nome.pt",
        "pw",
        "co.pw",
        "ne.pw",
        "or.pw",
        "ed.pw",
        "go.pw",
        "belau.pw",
        "py",
        "com.py",
        "coop.py",
        "edu.py",
        "gov.py",
        "mil.py",
        "net.py",
        "org.py",
        "qa",
        "com.qa",
        "edu.qa",
        "gov.qa",
        "mil.qa",
        "name.qa",
        "net.qa",
        "org.qa",
        "sch.qa",
        "re",
        "asso.re",
        "com.re",
        "nom.re",
        "ro",
        "arts.ro",
        "com.ro",
        "firm.ro",
        "info.ro",
        "nom.ro",
        "nt.ro",
        "org.ro",
        "rec.ro",
        "store.ro",
        "tm.ro",
        "www.ro",
        "rs",
        "ac.rs",
        "co.rs",
        "edu.rs",
        "gov.rs",
        "in.rs",
        "org.rs",
        "ru",
        "rw",
        "ac.rw",
        "co.rw",
        "coop.rw",
        "gov.rw",
        "mil.rw",
        "net.rw",
        "org.rw",
        "sa",
        "com.sa",
        "net.sa",
        "org.sa",
        "gov.sa",
        "med.sa",
        "pub.sa",
        "edu.sa",
        "sch.sa",
        "sb",
        "com.sb",
        "edu.sb",
        "gov.sb",
        "net.sb",
        "org.sb",
        "sc",
        "com.sc",
        "gov.sc",
        "net.sc",
        "org.sc",
        "edu.sc",
        "sd",
        "com.sd",
        "net.sd",
        "org.sd",
        "edu.sd",
        "med.sd",
        "tv.sd",
        "gov.sd",
        "info.sd",
        "se",
        "a.se",
        "ac.se",
        "b.se",
        "bd.se",
        "brand.se",
        "c.se",
        "d.se",
        "e.se",
        "f.se",
        "fh.se",
        "fhsk.se",
        "fhv.se",
        "g.se",
        "h.se",
        "i.se",
        "k.se",
        "komforb.se",
        "kommunalforbund.se",
        "komvux.se",
        "l.se",
        "lanbib.se",
        "m.se",
        "n.se",
        "naturbruksgymn.se",
        "o.se",
        "org.se",
        "p.se",
        "parti.se",
        "pp.se",
        "press.se",
        "r.se",
        "s.se",
        "t.se",
        "tm.se",
        "u.se",
        "w.se",
        "x.se",
        "y.se",
        "z.se",
        "sg",
        "com.sg",
        "net.sg",
        "org.sg",
        "gov.sg",
        "edu.sg",
        "per.sg",
        "sh",
        "com.sh",
        "net.sh",
        "gov.sh",
        "org.sh",
        "mil.sh",
        "si",
        "sj",
        "sk",
        "sl",
        "com.sl",
        "net.sl",
        "edu.sl",
        "gov.sl",
        "org.sl",
        "sm",
        "sn",
        "art.sn",
        "com.sn",
        "edu.sn",
        "gouv.sn",
        "org.sn",
        "perso.sn",
        "univ.sn",
        "so",
        "com.so",
        "edu.so",
        "gov.so",
        "me.so",
        "net.so",
        "org.so",
        "sr",
        "ss",
        "biz.ss",
        "com.ss",
        "edu.ss",
        "gov.ss",
        "me.ss",
        "net.ss",
        "org.ss",
        "sch.ss",
        "st",
        "co.st",
        "com.st",
        "consulado.st",
        "edu.st",
        "embaixada.st",
        "mil.st",
        "net.st",
        "org.st",
        "principe.st",
        "saotome.st",
        "store.st",
        "su",
        "sv",
        "com.sv",
        "edu.sv",
        "gob.sv",
        "org.sv",
        "red.sv",
        "sx",
        "gov.sx",
        "sy",
        "edu.sy",
        "gov.sy",
        "net.sy",
        "mil.sy",
        "com.sy",
        "org.sy",
        "sz",
        "co.sz",
        "ac.sz",
        "org.sz",
        "tc",
        "td",
        "tel",
        "tf",
        "tg",
        "th",
        "ac.th",
        "co.th",
        "go.th",
        "in.th",
        "mi.th",
        "net.th",
        "or.th",
        "tj",
        "ac.tj",
        "biz.tj",
        "co.tj",
        "com.tj",
        "edu.tj",
        "go.tj",
        "gov.tj",
        "int.tj",
        "mil.tj",
        "name.tj",
        "net.tj",
        "nic.tj",
        "org.tj",
        "test.tj",
        "web.tj",
        "tk",
        "tl",
        "gov.tl",
        "tm",
        "com.tm",
        "co.tm",
        "org.tm",
        "net.tm",
        "nom.tm",
        "gov.tm",
        "mil.tm",
        "edu.tm",
        "tn",
        "com.tn",
        "ens.tn",
        "fin.tn",
        "gov.tn",
        "ind.tn",
        "info.tn",
        "intl.tn",
        "mincom.tn",
        "nat.tn",
        "net.tn",
        "org.tn",
        "perso.tn",
        "tourism.tn",
        "to",
        "com.to",
        "gov.to",
        "net.to",
        "org.to",
        "edu.to",
        "mil.to",
        "tr",
        "av.tr",
        "bbs.tr",
        "bel.tr",
        "biz.tr",
        "com.tr",
        "dr.tr",
        "edu.tr",
        "gen.tr",
        "gov.tr",
        "info.tr",
        "mil.tr",
        "k12.tr",
        "kep.tr",
        "name.tr",
        "net.tr",
        "org.tr",
        "pol.tr",
        "tel.tr",
        "tsk.tr",
        "tv.tr",
        "web.tr",
        "nc.tr",
        "gov.nc.tr",
        "tt",
        "co.tt",
        "com.tt",
        "org.tt",
        "net.tt",
        "biz.tt",
        "info.tt",
        "pro.tt",
        "int.tt",
        "coop.tt",
        "jobs.tt",
        "mobi.tt",
        "travel.tt",
        "museum.tt",
        "aero.tt",
        "name.tt",
        "gov.tt",
        "edu.tt",
        "tv",
        "tw",
        "edu.tw",
        "gov.tw",
        "mil.tw",
        "com.tw",
        "net.tw",
        "org.tw",
        "idv.tw",
        "game.tw",
        "ebiz.tw",
        "club.tw",
        "\u7DB2\u8DEF.tw",
        "\u7D44\u7E54.tw",
        "\u5546\u696D.tw",
        "tz",
        "ac.tz",
        "co.tz",
        "go.tz",
        "hotel.tz",
        "info.tz",
        "me.tz",
        "mil.tz",
        "mobi.tz",
        "ne.tz",
        "or.tz",
        "sc.tz",
        "tv.tz",
        "ua",
        "com.ua",
        "edu.ua",
        "gov.ua",
        "in.ua",
        "net.ua",
        "org.ua",
        "cherkassy.ua",
        "cherkasy.ua",
        "chernigov.ua",
        "chernihiv.ua",
        "chernivtsi.ua",
        "chernovtsy.ua",
        "ck.ua",
        "cn.ua",
        "cr.ua",
        "crimea.ua",
        "cv.ua",
        "dn.ua",
        "dnepropetrovsk.ua",
        "dnipropetrovsk.ua",
        "donetsk.ua",
        "dp.ua",
        "if.ua",
        "ivano-frankivsk.ua",
        "kh.ua",
        "kharkiv.ua",
        "kharkov.ua",
        "kherson.ua",
        "khmelnitskiy.ua",
        "khmelnytskyi.ua",
        "kiev.ua",
        "kirovograd.ua",
        "km.ua",
        "kr.ua",
        "krym.ua",
        "ks.ua",
        "kv.ua",
        "kyiv.ua",
        "lg.ua",
        "lt.ua",
        "lugansk.ua",
        "lutsk.ua",
        "lv.ua",
        "lviv.ua",
        "mk.ua",
        "mykolaiv.ua",
        "nikolaev.ua",
        "od.ua",
        "odesa.ua",
        "odessa.ua",
        "pl.ua",
        "poltava.ua",
        "rivne.ua",
        "rovno.ua",
        "rv.ua",
        "sb.ua",
        "sebastopol.ua",
        "sevastopol.ua",
        "sm.ua",
        "sumy.ua",
        "te.ua",
        "ternopil.ua",
        "uz.ua",
        "uzhgorod.ua",
        "vinnica.ua",
        "vinnytsia.ua",
        "vn.ua",
        "volyn.ua",
        "yalta.ua",
        "zaporizhzhe.ua",
        "zaporizhzhia.ua",
        "zhitomir.ua",
        "zhytomyr.ua",
        "zp.ua",
        "zt.ua",
        "ug",
        "co.ug",
        "or.ug",
        "ac.ug",
        "sc.ug",
        "go.ug",
        "ne.ug",
        "com.ug",
        "org.ug",
        "uk",
        "ac.uk",
        "co.uk",
        "gov.uk",
        "ltd.uk",
        "me.uk",
        "net.uk",
        "nhs.uk",
        "org.uk",
        "plc.uk",
        "police.uk",
        "*.sch.uk",
        "us",
        "dni.us",
        "fed.us",
        "isa.us",
        "kids.us",
        "nsn.us",
        "ak.us",
        "al.us",
        "ar.us",
        "as.us",
        "az.us",
        "ca.us",
        "co.us",
        "ct.us",
        "dc.us",
        "de.us",
        "fl.us",
        "ga.us",
        "gu.us",
        "hi.us",
        "ia.us",
        "id.us",
        "il.us",
        "in.us",
        "ks.us",
        "ky.us",
        "la.us",
        "ma.us",
        "md.us",
        "me.us",
        "mi.us",
        "mn.us",
        "mo.us",
        "ms.us",
        "mt.us",
        "nc.us",
        "nd.us",
        "ne.us",
        "nh.us",
        "nj.us",
        "nm.us",
        "nv.us",
        "ny.us",
        "oh.us",
        "ok.us",
        "or.us",
        "pa.us",
        "pr.us",
        "ri.us",
        "sc.us",
        "sd.us",
        "tn.us",
        "tx.us",
        "ut.us",
        "vi.us",
        "vt.us",
        "va.us",
        "wa.us",
        "wi.us",
        "wv.us",
        "wy.us",
        "k12.ak.us",
        "k12.al.us",
        "k12.ar.us",
        "k12.as.us",
        "k12.az.us",
        "k12.ca.us",
        "k12.co.us",
        "k12.ct.us",
        "k12.dc.us",
        "k12.de.us",
        "k12.fl.us",
        "k12.ga.us",
        "k12.gu.us",
        "k12.ia.us",
        "k12.id.us",
        "k12.il.us",
        "k12.in.us",
        "k12.ks.us",
        "k12.ky.us",
        "k12.la.us",
        "k12.ma.us",
        "k12.md.us",
        "k12.me.us",
        "k12.mi.us",
        "k12.mn.us",
        "k12.mo.us",
        "k12.ms.us",
        "k12.mt.us",
        "k12.nc.us",
        "k12.ne.us",
        "k12.nh.us",
        "k12.nj.us",
        "k12.nm.us",
        "k12.nv.us",
        "k12.ny.us",
        "k12.oh.us",
        "k12.ok.us",
        "k12.or.us",
        "k12.pa.us",
        "k12.pr.us",
        "k12.sc.us",
        "k12.tn.us",
        "k12.tx.us",
        "k12.ut.us",
        "k12.vi.us",
        "k12.vt.us",
        "k12.va.us",
        "k12.wa.us",
        "k12.wi.us",
        "k12.wy.us",
        "cc.ak.us",
        "cc.al.us",
        "cc.ar.us",
        "cc.as.us",
        "cc.az.us",
        "cc.ca.us",
        "cc.co.us",
        "cc.ct.us",
        "cc.dc.us",
        "cc.de.us",
        "cc.fl.us",
        "cc.ga.us",
        "cc.gu.us",
        "cc.hi.us",
        "cc.ia.us",
        "cc.id.us",
        "cc.il.us",
        "cc.in.us",
        "cc.ks.us",
        "cc.ky.us",
        "cc.la.us",
        "cc.ma.us",
        "cc.md.us",
        "cc.me.us",
        "cc.mi.us",
        "cc.mn.us",
        "cc.mo.us",
        "cc.ms.us",
        "cc.mt.us",
        "cc.nc.us",
        "cc.nd.us",
        "cc.ne.us",
        "cc.nh.us",
        "cc.nj.us",
        "cc.nm.us",
        "cc.nv.us",
        "cc.ny.us",
        "cc.oh.us",
        "cc.ok.us",
        "cc.or.us",
        "cc.pa.us",
        "cc.pr.us",
        "cc.ri.us",
        "cc.sc.us",
        "cc.sd.us",
        "cc.tn.us",
        "cc.tx.us",
        "cc.ut.us",
        "cc.vi.us",
        "cc.vt.us",
        "cc.va.us",
        "cc.wa.us",
        "cc.wi.us",
        "cc.wv.us",
        "cc.wy.us",
        "lib.ak.us",
        "lib.al.us",
        "lib.ar.us",
        "lib.as.us",
        "lib.az.us",
        "lib.ca.us",
        "lib.co.us",
        "lib.ct.us",
        "lib.dc.us",
        "lib.fl.us",
        "lib.ga.us",
        "lib.gu.us",
        "lib.hi.us",
        "lib.ia.us",
        "lib.id.us",
        "lib.il.us",
        "lib.in.us",
        "lib.ks.us",
        "lib.ky.us",
        "lib.la.us",
        "lib.ma.us",
        "lib.md.us",
        "lib.me.us",
        "lib.mi.us",
        "lib.mn.us",
        "lib.mo.us",
        "lib.ms.us",
        "lib.mt.us",
        "lib.nc.us",
        "lib.nd.us",
        "lib.ne.us",
        "lib.nh.us",
        "lib.nj.us",
        "lib.nm.us",
        "lib.nv.us",
        "lib.ny.us",
        "lib.oh.us",
        "lib.ok.us",
        "lib.or.us",
        "lib.pa.us",
        "lib.pr.us",
        "lib.ri.us",
        "lib.sc.us",
        "lib.sd.us",
        "lib.tn.us",
        "lib.tx.us",
        "lib.ut.us",
        "lib.vi.us",
        "lib.vt.us",
        "lib.va.us",
        "lib.wa.us",
        "lib.wi.us",
        "lib.wy.us",
        "pvt.k12.ma.us",
        "chtr.k12.ma.us",
        "paroch.k12.ma.us",
        "ann-arbor.mi.us",
        "cog.mi.us",
        "dst.mi.us",
        "eaton.mi.us",
        "gen.mi.us",
        "mus.mi.us",
        "tec.mi.us",
        "washtenaw.mi.us",
        "uy",
        "com.uy",
        "edu.uy",
        "gub.uy",
        "mil.uy",
        "net.uy",
        "org.uy",
        "uz",
        "co.uz",
        "com.uz",
        "net.uz",
        "org.uz",
        "va",
        "vc",
        "com.vc",
        "net.vc",
        "org.vc",
        "gov.vc",
        "mil.vc",
        "edu.vc",
        "ve",
        "arts.ve",
        "bib.ve",
        "co.ve",
        "com.ve",
        "e12.ve",
        "edu.ve",
        "firm.ve",
        "gob.ve",
        "gov.ve",
        "info.ve",
        "int.ve",
        "mil.ve",
        "net.ve",
        "nom.ve",
        "org.ve",
        "rar.ve",
        "rec.ve",
        "store.ve",
        "tec.ve",
        "web.ve",
        "vg",
        "vi",
        "co.vi",
        "com.vi",
        "k12.vi",
        "net.vi",
        "org.vi",
        "vn",
        "com.vn",
        "net.vn",
        "org.vn",
        "edu.vn",
        "gov.vn",
        "int.vn",
        "ac.vn",
        "biz.vn",
        "info.vn",
        "name.vn",
        "pro.vn",
        "health.vn",
        "vu",
        "com.vu",
        "edu.vu",
        "net.vu",
        "org.vu",
        "wf",
        "ws",
        "com.ws",
        "net.ws",
        "org.ws",
        "gov.ws",
        "edu.ws",
        "yt",
        "\u0627\u0645\u0627\u0631\u0627\u062A",
        "\u0570\u0561\u0575",
        "\u09AC\u09BE\u0982\u09B2\u09BE",
        "\u0431\u0433",
        "\u0627\u0644\u0628\u062D\u0631\u064A\u0646",
        "\u0431\u0435\u043B",
        "\u4E2D\u56FD",
        "\u4E2D\u570B",
        "\u0627\u0644\u062C\u0632\u0627\u0626\u0631",
        "\u0645\u0635\u0631",
        "\u0435\u044E",
        "\u03B5\u03C5",
        "\u0645\u0648\u0631\u064A\u062A\u0627\u0646\u064A\u0627",
        "\u10D2\u10D4",
        "\u03B5\u03BB",
        "\u9999\u6E2F",
        "\u516C\u53F8.\u9999\u6E2F",
        "\u6559\u80B2.\u9999\u6E2F",
        "\u653F\u5E9C.\u9999\u6E2F",
        "\u500B\u4EBA.\u9999\u6E2F",
        "\u7DB2\u7D61.\u9999\u6E2F",
        "\u7D44\u7E54.\u9999\u6E2F",
        "\u0CAD\u0CBE\u0CB0\u0CA4",
        "\u0B2D\u0B3E\u0B30\u0B24",
        "\u09AD\u09BE\u09F0\u09A4",
        "\u092D\u093E\u0930\u0924\u092E\u094D",
        "\u092D\u093E\u0930\u094B\u0924",
        "\u0680\u0627\u0631\u062A",
        "\u0D2D\u0D3E\u0D30\u0D24\u0D02",
        "\u092D\u093E\u0930\u0924",
        "\u0628\u0627\u0631\u062A",
        "\u0628\u06BE\u0627\u0631\u062A",
        "\u0C2D\u0C3E\u0C30\u0C24\u0C4D",
        "\u0AAD\u0ABE\u0AB0\u0AA4",
        "\u0A2D\u0A3E\u0A30\u0A24",
        "\u09AD\u09BE\u09B0\u09A4",
        "\u0B87\u0BA8\u0BCD\u0BA4\u0BBF\u0BAF\u0BBE",
        "\u0627\u06CC\u0631\u0627\u0646",
        "\u0627\u064A\u0631\u0627\u0646",
        "\u0639\u0631\u0627\u0642",
        "\u0627\u0644\u0627\u0631\u062F\u0646",
        "\uD55C\uAD6D",
        "\u049B\u0430\u0437",
        "\u0EA5\u0EB2\u0EA7",
        "\u0DBD\u0D82\u0D9A\u0DCF",
        "\u0B87\u0BB2\u0B99\u0BCD\u0B95\u0BC8",
        "\u0627\u0644\u0645\u063A\u0631\u0628",
        "\u043C\u043A\u0434",
        "\u043C\u043E\u043D",
        "\u6FB3\u9580",
        "\u6FB3\u95E8",
        "\u0645\u0644\u064A\u0633\u064A\u0627",
        "\u0639\u0645\u0627\u0646",
        "\u067E\u0627\u06A9\u0633\u062A\u0627\u0646",
        "\u067E\u0627\u0643\u0633\u062A\u0627\u0646",
        "\u0641\u0644\u0633\u0637\u064A\u0646",
        "\u0441\u0440\u0431",
        "\u043F\u0440.\u0441\u0440\u0431",
        "\u043E\u0440\u0433.\u0441\u0440\u0431",
        "\u043E\u0431\u0440.\u0441\u0440\u0431",
        "\u043E\u0434.\u0441\u0440\u0431",
        "\u0443\u043F\u0440.\u0441\u0440\u0431",
        "\u0430\u043A.\u0441\u0440\u0431",
        "\u0440\u0444",
        "\u0642\u0637\u0631",
        "\u0627\u0644\u0633\u0639\u0648\u062F\u064A\u0629",
        "\u0627\u0644\u0633\u0639\u0648\u062F\u06CC\u0629",
        "\u0627\u0644\u0633\u0639\u0648\u062F\u06CC\u06C3",
        "\u0627\u0644\u0633\u0639\u0648\u062F\u064A\u0647",
        "\u0633\u0648\u062F\u0627\u0646",
        "\u65B0\u52A0\u5761",
        "\u0B9A\u0BBF\u0B99\u0BCD\u0B95\u0BAA\u0BCD\u0BAA\u0BC2\u0BB0\u0BCD",
        "\u0633\u0648\u0631\u064A\u0629",
        "\u0633\u0648\u0631\u064A\u0627",
        "\u0E44\u0E17\u0E22",
        "\u0E28\u0E36\u0E01\u0E29\u0E32.\u0E44\u0E17\u0E22",
        "\u0E18\u0E38\u0E23\u0E01\u0E34\u0E08.\u0E44\u0E17\u0E22",
        "\u0E23\u0E31\u0E10\u0E1A\u0E32\u0E25.\u0E44\u0E17\u0E22",
        "\u0E17\u0E2B\u0E32\u0E23.\u0E44\u0E17\u0E22",
        "\u0E40\u0E19\u0E47\u0E15.\u0E44\u0E17\u0E22",
        "\u0E2D\u0E07\u0E04\u0E4C\u0E01\u0E23.\u0E44\u0E17\u0E22",
        "\u062A\u0648\u0646\u0633",
        "\u53F0\u7063",
        "\u53F0\u6E7E",
        "\u81FA\u7063",
        "\u0443\u043A\u0440",
        "\u0627\u0644\u064A\u0645\u0646",
        "xxx",
        "ye",
        "com.ye",
        "edu.ye",
        "gov.ye",
        "net.ye",
        "mil.ye",
        "org.ye",
        "ac.za",
        "agric.za",
        "alt.za",
        "co.za",
        "edu.za",
        "gov.za",
        "grondar.za",
        "law.za",
        "mil.za",
        "net.za",
        "ngo.za",
        "nic.za",
        "nis.za",
        "nom.za",
        "org.za",
        "school.za",
        "tm.za",
        "web.za",
        "zm",
        "ac.zm",
        "biz.zm",
        "co.zm",
        "com.zm",
        "edu.zm",
        "gov.zm",
        "info.zm",
        "mil.zm",
        "net.zm",
        "org.zm",
        "sch.zm",
        "zw",
        "ac.zw",
        "co.zw",
        "gov.zw",
        "mil.zw",
        "org.zw",
        "aaa",
        "aarp",
        "abarth",
        "abb",
        "abbott",
        "abbvie",
        "abc",
        "able",
        "abogado",
        "abudhabi",
        "academy",
        "accenture",
        "accountant",
        "accountants",
        "aco",
        "actor",
        "adac",
        "ads",
        "adult",
        "aeg",
        "aetna",
        "afl",
        "africa",
        "agakhan",
        "agency",
        "aig",
        "airbus",
        "airforce",
        "airtel",
        "akdn",
        "alfaromeo",
        "alibaba",
        "alipay",
        "allfinanz",
        "allstate",
        "ally",
        "alsace",
        "alstom",
        "amazon",
        "americanexpress",
        "americanfamily",
        "amex",
        "amfam",
        "amica",
        "amsterdam",
        "analytics",
        "android",
        "anquan",
        "anz",
        "aol",
        "apartments",
        "app",
        "apple",
        "aquarelle",
        "arab",
        "aramco",
        "archi",
        "army",
        "art",
        "arte",
        "asda",
        "associates",
        "athleta",
        "attorney",
        "auction",
        "audi",
        "audible",
        "audio",
        "auspost",
        "author",
        "auto",
        "autos",
        "avianca",
        "aws",
        "axa",
        "azure",
        "baby",
        "baidu",
        "banamex",
        "bananarepublic",
        "band",
        "bank",
        "bar",
        "barcelona",
        "barclaycard",
        "barclays",
        "barefoot",
        "bargains",
        "baseball",
        "basketball",
        "bauhaus",
        "bayern",
        "bbc",
        "bbt",
        "bbva",
        "bcg",
        "bcn",
        "beats",
        "beauty",
        "beer",
        "bentley",
        "berlin",
        "best",
        "bestbuy",
        "bet",
        "bharti",
        "bible",
        "bid",
        "bike",
        "bing",
        "bingo",
        "bio",
        "black",
        "blackfriday",
        "blockbuster",
        "blog",
        "bloomberg",
        "blue",
        "bms",
        "bmw",
        "bnpparibas",
        "boats",
        "boehringer",
        "bofa",
        "bom",
        "bond",
        "boo",
        "book",
        "booking",
        "bosch",
        "bostik",
        "boston",
        "bot",
        "boutique",
        "box",
        "bradesco",
        "bridgestone",
        "broadway",
        "broker",
        "brother",
        "brussels",
        "bugatti",
        "build",
        "builders",
        "business",
        "buy",
        "buzz",
        "bzh",
        "cab",
        "cafe",
        "cal",
        "call",
        "calvinklein",
        "cam",
        "camera",
        "camp",
        "cancerresearch",
        "canon",
        "capetown",
        "capital",
        "capitalone",
        "car",
        "caravan",
        "cards",
        "care",
        "career",
        "careers",
        "cars",
        "casa",
        "case",
        "cash",
        "casino",
        "catering",
        "catholic",
        "cba",
        "cbn",
        "cbre",
        "cbs",
        "center",
        "ceo",
        "cern",
        "cfa",
        "cfd",
        "chanel",
        "channel",
        "charity",
        "chase",
        "chat",
        "cheap",
        "chintai",
        "christmas",
        "chrome",
        "church",
        "cipriani",
        "circle",
        "cisco",
        "citadel",
        "citi",
        "citic",
        "city",
        "cityeats",
        "claims",
        "cleaning",
        "click",
        "clinic",
        "clinique",
        "clothing",
        "cloud",
        "club",
        "clubmed",
        "coach",
        "codes",
        "coffee",
        "college",
        "cologne",
        "comcast",
        "commbank",
        "community",
        "company",
        "compare",
        "computer",
        "comsec",
        "condos",
        "construction",
        "consulting",
        "contact",
        "contractors",
        "cooking",
        "cookingchannel",
        "cool",
        "corsica",
        "country",
        "coupon",
        "coupons",
        "courses",
        "cpa",
        "credit",
        "creditcard",
        "creditunion",
        "cricket",
        "crown",
        "crs",
        "cruise",
        "cruises",
        "cuisinella",
        "cymru",
        "cyou",
        "dabur",
        "dad",
        "dance",
        "data",
        "date",
        "dating",
        "datsun",
        "day",
        "dclk",
        "dds",
        "deal",
        "dealer",
        "deals",
        "degree",
        "delivery",
        "dell",
        "deloitte",
        "delta",
        "democrat",
        "dental",
        "dentist",
        "desi",
        "design",
        "dev",
        "dhl",
        "diamonds",
        "diet",
        "digital",
        "direct",
        "directory",
        "discount",
        "discover",
        "dish",
        "diy",
        "dnp",
        "docs",
        "doctor",
        "dog",
        "domains",
        "dot",
        "download",
        "drive",
        "dtv",
        "dubai",
        "dunlop",
        "dupont",
        "durban",
        "dvag",
        "dvr",
        "earth",
        "eat",
        "eco",
        "edeka",
        "education",
        "email",
        "emerck",
        "energy",
        "engineer",
        "engineering",
        "enterprises",
        "epson",
        "equipment",
        "ericsson",
        "erni",
        "esq",
        "estate",
        "etisalat",
        "eurovision",
        "eus",
        "events",
        "exchange",
        "expert",
        "exposed",
        "express",
        "extraspace",
        "fage",
        "fail",
        "fairwinds",
        "faith",
        "family",
        "fan",
        "fans",
        "farm",
        "farmers",
        "fashion",
        "fast",
        "fedex",
        "feedback",
        "ferrari",
        "ferrero",
        "fiat",
        "fidelity",
        "fido",
        "film",
        "final",
        "finance",
        "financial",
        "fire",
        "firestone",
        "firmdale",
        "fish",
        "fishing",
        "fit",
        "fitness",
        "flickr",
        "flights",
        "flir",
        "florist",
        "flowers",
        "fly",
        "foo",
        "food",
        "foodnetwork",
        "football",
        "ford",
        "forex",
        "forsale",
        "forum",
        "foundation",
        "fox",
        "free",
        "fresenius",
        "frl",
        "frogans",
        "frontdoor",
        "frontier",
        "ftr",
        "fujitsu",
        "fun",
        "fund",
        "furniture",
        "futbol",
        "fyi",
        "gal",
        "gallery",
        "gallo",
        "gallup",
        "game",
        "games",
        "gap",
        "garden",
        "gay",
        "gbiz",
        "gdn",
        "gea",
        "gent",
        "genting",
        "george",
        "ggee",
        "gift",
        "gifts",
        "gives",
        "giving",
        "glass",
        "gle",
        "global",
        "globo",
        "gmail",
        "gmbh",
        "gmo",
        "gmx",
        "godaddy",
        "gold",
        "goldpoint",
        "golf",
        "goo",
        "goodyear",
        "goog",
        "google",
        "gop",
        "got",
        "grainger",
        "graphics",
        "gratis",
        "green",
        "gripe",
        "grocery",
        "group",
        "guardian",
        "gucci",
        "guge",
        "guide",
        "guitars",
        "guru",
        "hair",
        "hamburg",
        "hangout",
        "haus",
        "hbo",
        "hdfc",
        "hdfcbank",
        "health",
        "healthcare",
        "help",
        "helsinki",
        "here",
        "hermes",
        "hgtv",
        "hiphop",
        "hisamitsu",
        "hitachi",
        "hiv",
        "hkt",
        "hockey",
        "holdings",
        "holiday",
        "homedepot",
        "homegoods",
        "homes",
        "homesense",
        "honda",
        "horse",
        "hospital",
        "host",
        "hosting",
        "hot",
        "hoteles",
        "hotels",
        "hotmail",
        "house",
        "how",
        "hsbc",
        "hughes",
        "hyatt",
        "hyundai",
        "ibm",
        "icbc",
        "ice",
        "icu",
        "ieee",
        "ifm",
        "ikano",
        "imamat",
        "imdb",
        "immo",
        "immobilien",
        "inc",
        "industries",
        "infiniti",
        "ing",
        "ink",
        "institute",
        "insurance",
        "insure",
        "international",
        "intuit",
        "investments",
        "ipiranga",
        "irish",
        "ismaili",
        "ist",
        "istanbul",
        "itau",
        "itv",
        "jaguar",
        "java",
        "jcb",
        "jeep",
        "jetzt",
        "jewelry",
        "jio",
        "jll",
        "jmp",
        "jnj",
        "joburg",
        "jot",
        "joy",
        "jpmorgan",
        "jprs",
        "juegos",
        "juniper",
        "kaufen",
        "kddi",
        "kerryhotels",
        "kerrylogistics",
        "kerryproperties",
        "kfh",
        "kia",
        "kids",
        "kim",
        "kinder",
        "kindle",
        "kitchen",
        "kiwi",
        "koeln",
        "komatsu",
        "kosher",
        "kpmg",
        "kpn",
        "krd",
        "kred",
        "kuokgroup",
        "kyoto",
        "lacaixa",
        "lamborghini",
        "lamer",
        "lancaster",
        "lancia",
        "land",
        "landrover",
        "lanxess",
        "lasalle",
        "lat",
        "latino",
        "latrobe",
        "law",
        "lawyer",
        "lds",
        "lease",
        "leclerc",
        "lefrak",
        "legal",
        "lego",
        "lexus",
        "lgbt",
        "lidl",
        "life",
        "lifeinsurance",
        "lifestyle",
        "lighting",
        "like",
        "lilly",
        "limited",
        "limo",
        "lincoln",
        "linde",
        "link",
        "lipsy",
        "live",
        "living",
        "llc",
        "llp",
        "loan",
        "loans",
        "locker",
        "locus",
        "loft",
        "lol",
        "london",
        "lotte",
        "lotto",
        "love",
        "lpl",
        "lplfinancial",
        "ltd",
        "ltda",
        "lundbeck",
        "luxe",
        "luxury",
        "macys",
        "madrid",
        "maif",
        "maison",
        "makeup",
        "man",
        "management",
        "mango",
        "map",
        "market",
        "marketing",
        "markets",
        "marriott",
        "marshalls",
        "maserati",
        "mattel",
        "mba",
        "mckinsey",
        "med",
        "media",
        "meet",
        "melbourne",
        "meme",
        "memorial",
        "men",
        "menu",
        "merckmsd",
        "miami",
        "microsoft",
        "mini",
        "mint",
        "mit",
        "mitsubishi",
        "mlb",
        "mls",
        "mma",
        "mobile",
        "moda",
        "moe",
        "moi",
        "mom",
        "monash",
        "money",
        "monster",
        "mormon",
        "mortgage",
        "moscow",
        "moto",
        "motorcycles",
        "mov",
        "movie",
        "msd",
        "mtn",
        "mtr",
        "music",
        "mutual",
        "nab",
        "nagoya",
        "natura",
        "navy",
        "nba",
        "nec",
        "netbank",
        "netflix",
        "network",
        "neustar",
        "new",
        "news",
        "next",
        "nextdirect",
        "nexus",
        "nfl",
        "ngo",
        "nhk",
        "nico",
        "nike",
        "nikon",
        "ninja",
        "nissan",
        "nissay",
        "nokia",
        "northwesternmutual",
        "norton",
        "now",
        "nowruz",
        "nowtv",
        "nra",
        "nrw",
        "ntt",
        "nyc",
        "obi",
        "observer",
        "office",
        "okinawa",
        "olayan",
        "olayangroup",
        "oldnavy",
        "ollo",
        "omega",
        "one",
        "ong",
        "onl",
        "online",
        "ooo",
        "open",
        "oracle",
        "orange",
        "organic",
        "origins",
        "osaka",
        "otsuka",
        "ott",
        "ovh",
        "page",
        "panasonic",
        "paris",
        "pars",
        "partners",
        "parts",
        "party",
        "passagens",
        "pay",
        "pccw",
        "pet",
        "pfizer",
        "pharmacy",
        "phd",
        "philips",
        "phone",
        "photo",
        "photography",
        "photos",
        "physio",
        "pics",
        "pictet",
        "pictures",
        "pid",
        "pin",
        "ping",
        "pink",
        "pioneer",
        "pizza",
        "place",
        "play",
        "playstation",
        "plumbing",
        "plus",
        "pnc",
        "pohl",
        "poker",
        "politie",
        "porn",
        "pramerica",
        "praxi",
        "press",
        "prime",
        "prod",
        "productions",
        "prof",
        "progressive",
        "promo",
        "properties",
        "property",
        "protection",
        "pru",
        "prudential",
        "pub",
        "pwc",
        "qpon",
        "quebec",
        "quest",
        "racing",
        "radio",
        "read",
        "realestate",
        "realtor",
        "realty",
        "recipes",
        "red",
        "redstone",
        "redumbrella",
        "rehab",
        "reise",
        "reisen",
        "reit",
        "reliance",
        "ren",
        "rent",
        "rentals",
        "repair",
        "report",
        "republican",
        "rest",
        "restaurant",
        "review",
        "reviews",
        "rexroth",
        "rich",
        "richardli",
        "ricoh",
        "ril",
        "rio",
        "rip",
        "rocher",
        "rocks",
        "rodeo",
        "rogers",
        "room",
        "rsvp",
        "rugby",
        "ruhr",
        "run",
        "rwe",
        "ryukyu",
        "saarland",
        "safe",
        "safety",
        "sakura",
        "sale",
        "salon",
        "samsclub",
        "samsung",
        "sandvik",
        "sandvikcoromant",
        "sanofi",
        "sap",
        "sarl",
        "sas",
        "save",
        "saxo",
        "sbi",
        "sbs",
        "sca",
        "scb",
        "schaeffler",
        "schmidt",
        "scholarships",
        "school",
        "schule",
        "schwarz",
        "science",
        "scot",
        "search",
        "seat",
        "secure",
        "security",
        "seek",
        "select",
        "sener",
        "services",
        "ses",
        "seven",
        "sew",
        "sex",
        "sexy",
        "sfr",
        "shangrila",
        "sharp",
        "shaw",
        "shell",
        "shia",
        "shiksha",
        "shoes",
        "shop",
        "shopping",
        "shouji",
        "show",
        "showtime",
        "silk",
        "sina",
        "singles",
        "site",
        "ski",
        "skin",
        "sky",
        "skype",
        "sling",
        "smart",
        "smile",
        "sncf",
        "soccer",
        "social",
        "softbank",
        "software",
        "sohu",
        "solar",
        "solutions",
        "song",
        "sony",
        "soy",
        "spa",
        "space",
        "sport",
        "spot",
        "srl",
        "stada",
        "staples",
        "star",
        "statebank",
        "statefarm",
        "stc",
        "stcgroup",
        "stockholm",
        "storage",
        "store",
        "stream",
        "studio",
        "study",
        "style",
        "sucks",
        "supplies",
        "supply",
        "support",
        "surf",
        "surgery",
        "suzuki",
        "swatch",
        "swiss",
        "sydney",
        "systems",
        "tab",
        "taipei",
        "talk",
        "taobao",
        "target",
        "tatamotors",
        "tatar",
        "tattoo",
        "tax",
        "taxi",
        "tci",
        "tdk",
        "team",
        "tech",
        "technology",
        "temasek",
        "tennis",
        "teva",
        "thd",
        "theater",
        "theatre",
        "tiaa",
        "tickets",
        "tienda",
        "tiffany",
        "tips",
        "tires",
        "tirol",
        "tjmaxx",
        "tjx",
        "tkmaxx",
        "tmall",
        "today",
        "tokyo",
        "tools",
        "top",
        "toray",
        "toshiba",
        "total",
        "tours",
        "town",
        "toyota",
        "toys",
        "trade",
        "trading",
        "training",
        "travel",
        "travelchannel",
        "travelers",
        "travelersinsurance",
        "trust",
        "trv",
        "tube",
        "tui",
        "tunes",
        "tushu",
        "tvs",
        "ubank",
        "ubs",
        "unicom",
        "university",
        "uno",
        "uol",
        "ups",
        "vacations",
        "vana",
        "vanguard",
        "vegas",
        "ventures",
        "verisign",
        "versicherung",
        "vet",
        "viajes",
        "video",
        "vig",
        "viking",
        "villas",
        "vin",
        "vip",
        "virgin",
        "visa",
        "vision",
        "viva",
        "vivo",
        "vlaanderen",
        "vodka",
        "volkswagen",
        "volvo",
        "vote",
        "voting",
        "voto",
        "voyage",
        "vuelos",
        "wales",
        "walmart",
        "walter",
        "wang",
        "wanggou",
        "watch",
        "watches",
        "weather",
        "weatherchannel",
        "webcam",
        "weber",
        "website",
        "wedding",
        "weibo",
        "weir",
        "whoswho",
        "wien",
        "wiki",
        "williamhill",
        "win",
        "windows",
        "wine",
        "winners",
        "wme",
        "wolterskluwer",
        "woodside",
        "work",
        "works",
        "world",
        "wow",
        "wtc",
        "wtf",
        "xbox",
        "xerox",
        "xfinity",
        "xihuan",
        "xin",
        "\u0915\u0949\u092E",
        "\u30BB\u30FC\u30EB",
        "\u4F5B\u5C71",
        "\u6148\u5584",
        "\u96C6\u56E2",
        "\u5728\u7EBF",
        "\u70B9\u770B",
        "\u0E04\u0E2D\u0E21",
        "\u516B\u5366",
        "\u0645\u0648\u0642\u0639",
        "\u516C\u76CA",
        "\u516C\u53F8",
        "\u9999\u683C\u91CC\u62C9",
        "\u7F51\u7AD9",
        "\u79FB\u52A8",
        "\u6211\u7231\u4F60",
        "\u043C\u043E\u0441\u043A\u0432\u0430",
        "\u043A\u0430\u0442\u043E\u043B\u0438\u043A",
        "\u043E\u043D\u043B\u0430\u0439\u043D",
        "\u0441\u0430\u0439\u0442",
        "\u8054\u901A",
        "\u05E7\u05D5\u05DD",
        "\u65F6\u5C1A",
        "\u5FAE\u535A",
        "\u6DE1\u9A6C\u9521",
        "\u30D5\u30A1\u30C3\u30B7\u30E7\u30F3",
        "\u043E\u0440\u0433",
        "\u0928\u0947\u091F",
        "\u30B9\u30C8\u30A2",
        "\u30A2\u30DE\u30BE\u30F3",
        "\uC0BC\uC131",
        "\u5546\u6807",
        "\u5546\u5E97",
        "\u5546\u57CE",
        "\u0434\u0435\u0442\u0438",
        "\u30DD\u30A4\u30F3\u30C8",
        "\u65B0\u95FB",
        "\u5BB6\u96FB",
        "\u0643\u0648\u0645",
        "\u4E2D\u6587\u7F51",
        "\u4E2D\u4FE1",
        "\u5A31\u4E50",
        "\u8C37\u6B4C",
        "\u96FB\u8A0A\u76C8\u79D1",
        "\u8D2D\u7269",
        "\u30AF\u30E9\u30A6\u30C9",
        "\u901A\u8CA9",
        "\u7F51\u5E97",
        "\u0938\u0902\u0917\u0920\u0928",
        "\u9910\u5385",
        "\u7F51\u7EDC",
        "\u043A\u043E\u043C",
        "\u4E9A\u9A6C\u900A",
        "\u8BFA\u57FA\u4E9A",
        "\u98DF\u54C1",
        "\u98DE\u5229\u6D66",
        "\u624B\u673A",
        "\u0627\u0631\u0627\u0645\u0643\u0648",
        "\u0627\u0644\u0639\u0644\u064A\u0627\u0646",
        "\u0627\u062A\u0635\u0627\u0644\u0627\u062A",
        "\u0628\u0627\u0632\u0627\u0631",
        "\u0627\u0628\u0648\u0638\u0628\u064A",
        "\u0643\u0627\u062B\u0648\u0644\u064A\u0643",
        "\u0647\u0645\u0631\u0627\u0647",
        "\uB2F7\uCEF4",
        "\u653F\u5E9C",
        "\u0634\u0628\u0643\u0629",
        "\u0628\u064A\u062A\u0643",
        "\u0639\u0631\u0628",
        "\u673A\u6784",
        "\u7EC4\u7EC7\u673A\u6784",
        "\u5065\u5EB7",
        "\u62DB\u8058",
        "\u0440\u0443\u0441",
        "\u5927\u62FF",
        "\u307F\u3093\u306A",
        "\u30B0\u30FC\u30B0\u30EB",
        "\u4E16\u754C",
        "\u66F8\u7C4D",
        "\u7F51\u5740",
        "\uB2F7\uB137",
        "\u30B3\u30E0",
        "\u5929\u4E3B\u6559",
        "\u6E38\u620F",
        "verm\xF6gensberater",
        "verm\xF6gensberatung",
        "\u4F01\u4E1A",
        "\u4FE1\u606F",
        "\u5609\u91CC\u5927\u9152\u5E97",
        "\u5609\u91CC",
        "\u5E7F\u4E1C",
        "\u653F\u52A1",
        "xyz",
        "yachts",
        "yahoo",
        "yamaxun",
        "yandex",
        "yodobashi",
        "yoga",
        "yokohama",
        "you",
        "youtube",
        "yun",
        "zappos",
        "zara",
        "zero",
        "zip",
        "zone",
        "zuerich",
        "cc.ua",
        "inf.ua",
        "ltd.ua",
        "611.to",
        "graphox.us",
        "*.devcdnaccesso.com",
        "adobeaemcloud.com",
        "*.dev.adobeaemcloud.com",
        "hlx.live",
        "adobeaemcloud.net",
        "hlx.page",
        "hlx3.page",
        "beep.pl",
        "airkitapps.com",
        "airkitapps-au.com",
        "airkitapps.eu",
        "aivencloud.com",
        "barsy.ca",
        "*.compute.estate",
        "*.alces.network",
        "kasserver.com",
        "altervista.org",
        "alwaysdata.net",
        "cloudfront.net",
        "*.compute.amazonaws.com",
        "*.compute-1.amazonaws.com",
        "*.compute.amazonaws.com.cn",
        "us-east-1.amazonaws.com",
        "cn-north-1.eb.amazonaws.com.cn",
        "cn-northwest-1.eb.amazonaws.com.cn",
        "elasticbeanstalk.com",
        "ap-northeast-1.elasticbeanstalk.com",
        "ap-northeast-2.elasticbeanstalk.com",
        "ap-northeast-3.elasticbeanstalk.com",
        "ap-south-1.elasticbeanstalk.com",
        "ap-southeast-1.elasticbeanstalk.com",
        "ap-southeast-2.elasticbeanstalk.com",
        "ca-central-1.elasticbeanstalk.com",
        "eu-central-1.elasticbeanstalk.com",
        "eu-west-1.elasticbeanstalk.com",
        "eu-west-2.elasticbeanstalk.com",
        "eu-west-3.elasticbeanstalk.com",
        "sa-east-1.elasticbeanstalk.com",
        "us-east-1.elasticbeanstalk.com",
        "us-east-2.elasticbeanstalk.com",
        "us-gov-west-1.elasticbeanstalk.com",
        "us-west-1.elasticbeanstalk.com",
        "us-west-2.elasticbeanstalk.com",
        "*.elb.amazonaws.com",
        "*.elb.amazonaws.com.cn",
        "awsglobalaccelerator.com",
        "s3.amazonaws.com",
        "s3-ap-northeast-1.amazonaws.com",
        "s3-ap-northeast-2.amazonaws.com",
        "s3-ap-south-1.amazonaws.com",
        "s3-ap-southeast-1.amazonaws.com",
        "s3-ap-southeast-2.amazonaws.com",
        "s3-ca-central-1.amazonaws.com",
        "s3-eu-central-1.amazonaws.com",
        "s3-eu-west-1.amazonaws.com",
        "s3-eu-west-2.amazonaws.com",
        "s3-eu-west-3.amazonaws.com",
        "s3-external-1.amazonaws.com",
        "s3-fips-us-gov-west-1.amazonaws.com",
        "s3-sa-east-1.amazonaws.com",
        "s3-us-gov-west-1.amazonaws.com",
        "s3-us-east-2.amazonaws.com",
        "s3-us-west-1.amazonaws.com",
        "s3-us-west-2.amazonaws.com",
        "s3.ap-northeast-2.amazonaws.com",
        "s3.ap-south-1.amazonaws.com",
        "s3.cn-north-1.amazonaws.com.cn",
        "s3.ca-central-1.amazonaws.com",
        "s3.eu-central-1.amazonaws.com",
        "s3.eu-west-2.amazonaws.com",
        "s3.eu-west-3.amazonaws.com",
        "s3.us-east-2.amazonaws.com",
        "s3.dualstack.ap-northeast-1.amazonaws.com",
        "s3.dualstack.ap-northeast-2.amazonaws.com",
        "s3.dualstack.ap-south-1.amazonaws.com",
        "s3.dualstack.ap-southeast-1.amazonaws.com",
        "s3.dualstack.ap-southeast-2.amazonaws.com",
        "s3.dualstack.ca-central-1.amazonaws.com",
        "s3.dualstack.eu-central-1.amazonaws.com",
        "s3.dualstack.eu-west-1.amazonaws.com",
        "s3.dualstack.eu-west-2.amazonaws.com",
        "s3.dualstack.eu-west-3.amazonaws.com",
        "s3.dualstack.sa-east-1.amazonaws.com",
        "s3.dualstack.us-east-1.amazonaws.com",
        "s3.dualstack.us-east-2.amazonaws.com",
        "s3-website-us-east-1.amazonaws.com",
        "s3-website-us-west-1.amazonaws.com",
        "s3-website-us-west-2.amazonaws.com",
        "s3-website-ap-northeast-1.amazonaws.com",
        "s3-website-ap-southeast-1.amazonaws.com",
        "s3-website-ap-southeast-2.amazonaws.com",
        "s3-website-eu-west-1.amazonaws.com",
        "s3-website-sa-east-1.amazonaws.com",
        "s3-website.ap-northeast-2.amazonaws.com",
        "s3-website.ap-south-1.amazonaws.com",
        "s3-website.ca-central-1.amazonaws.com",
        "s3-website.eu-central-1.amazonaws.com",
        "s3-website.eu-west-2.amazonaws.com",
        "s3-website.eu-west-3.amazonaws.com",
        "s3-website.us-east-2.amazonaws.com",
        "t3l3p0rt.net",
        "tele.amune.org",
        "apigee.io",
        "siiites.com",
        "appspacehosted.com",
        "appspaceusercontent.com",
        "appudo.net",
        "on-aptible.com",
        "user.aseinet.ne.jp",
        "gv.vc",
        "d.gv.vc",
        "user.party.eus",
        "pimienta.org",
        "poivron.org",
        "potager.org",
        "sweetpepper.org",
        "myasustor.com",
        "cdn.prod.atlassian-dev.net",
        "translated.page",
        "myfritz.net",
        "onavstack.net",
        "*.awdev.ca",
        "*.advisor.ws",
        "ecommerce-shop.pl",
        "b-data.io",
        "backplaneapp.io",
        "balena-devices.com",
        "rs.ba",
        "*.banzai.cloud",
        "app.banzaicloud.io",
        "*.backyards.banzaicloud.io",
        "base.ec",
        "official.ec",
        "buyshop.jp",
        "fashionstore.jp",
        "handcrafted.jp",
        "kawaiishop.jp",
        "supersale.jp",
        "theshop.jp",
        "shopselect.net",
        "base.shop",
        "*.beget.app",
        "betainabox.com",
        "bnr.la",
        "bitbucket.io",
        "blackbaudcdn.net",
        "of.je",
        "bluebite.io",
        "boomla.net",
        "boutir.com",
        "boxfuse.io",
        "square7.ch",
        "bplaced.com",
        "bplaced.de",
        "square7.de",
        "bplaced.net",
        "square7.net",
        "shop.brendly.rs",
        "browsersafetymark.io",
        "uk0.bigv.io",
        "dh.bytemark.co.uk",
        "vm.bytemark.co.uk",
        "cafjs.com",
        "mycd.eu",
        "drr.ac",
        "uwu.ai",
        "carrd.co",
        "crd.co",
        "ju.mp",
        "ae.org",
        "br.com",
        "cn.com",
        "com.de",
        "com.se",
        "de.com",
        "eu.com",
        "gb.net",
        "hu.net",
        "jp.net",
        "jpn.com",
        "mex.com",
        "ru.com",
        "sa.com",
        "se.net",
        "uk.com",
        "uk.net",
        "us.com",
        "za.bz",
        "za.com",
        "ar.com",
        "hu.com",
        "kr.com",
        "no.com",
        "qc.com",
        "uy.com",
        "africa.com",
        "gr.com",
        "in.net",
        "web.in",
        "us.org",
        "co.com",
        "aus.basketball",
        "nz.basketball",
        "radio.am",
        "radio.fm",
        "c.la",
        "certmgr.org",
        "cx.ua",
        "discourse.group",
        "discourse.team",
        "cleverapps.io",
        "clerk.app",
        "clerkstage.app",
        "*.lcl.dev",
        "*.lclstage.dev",
        "*.stg.dev",
        "*.stgstage.dev",
        "clickrising.net",
        "c66.me",
        "cloud66.ws",
        "cloud66.zone",
        "jdevcloud.com",
        "wpdevcloud.com",
        "cloudaccess.host",
        "freesite.host",
        "cloudaccess.net",
        "cloudcontrolled.com",
        "cloudcontrolapp.com",
        "*.cloudera.site",
        "pages.dev",
        "trycloudflare.com",
        "workers.dev",
        "wnext.app",
        "co.ca",
        "*.otap.co",
        "co.cz",
        "c.cdn77.org",
        "cdn77-ssl.net",
        "r.cdn77.net",
        "rsc.cdn77.org",
        "ssl.origin.cdn77-secure.org",
        "cloudns.asia",
        "cloudns.biz",
        "cloudns.club",
        "cloudns.cc",
        "cloudns.eu",
        "cloudns.in",
        "cloudns.info",
        "cloudns.org",
        "cloudns.pro",
        "cloudns.pw",
        "cloudns.us",
        "cnpy.gdn",
        "codeberg.page",
        "co.nl",
        "co.no",
        "webhosting.be",
        "hosting-cluster.nl",
        "ac.ru",
        "edu.ru",
        "gov.ru",
        "int.ru",
        "mil.ru",
        "test.ru",
        "dyn.cosidns.de",
        "dynamisches-dns.de",
        "dnsupdater.de",
        "internet-dns.de",
        "l-o-g-i-n.de",
        "dynamic-dns.info",
        "feste-ip.net",
        "knx-server.net",
        "static-access.net",
        "realm.cz",
        "*.cryptonomic.net",
        "cupcake.is",
        "curv.dev",
        "*.customer-oci.com",
        "*.oci.customer-oci.com",
        "*.ocp.customer-oci.com",
        "*.ocs.customer-oci.com",
        "cyon.link",
        "cyon.site",
        "fnwk.site",
        "folionetwork.site",
        "platform0.app",
        "daplie.me",
        "localhost.daplie.me",
        "dattolocal.com",
        "dattorelay.com",
        "dattoweb.com",
        "mydatto.com",
        "dattolocal.net",
        "mydatto.net",
        "biz.dk",
        "co.dk",
        "firm.dk",
        "reg.dk",
        "store.dk",
        "dyndns.dappnode.io",
        "*.dapps.earth",
        "*.bzz.dapps.earth",
        "builtwithdark.com",
        "demo.datadetect.com",
        "instance.datadetect.com",
        "edgestack.me",
        "ddns5.com",
        "debian.net",
        "deno.dev",
        "deno-staging.dev",
        "dedyn.io",
        "deta.app",
        "deta.dev",
        "*.rss.my.id",
        "*.diher.solutions",
        "discordsays.com",
        "discordsez.com",
        "jozi.biz",
        "dnshome.de",
        "online.th",
        "shop.th",
        "drayddns.com",
        "shoparena.pl",
        "dreamhosters.com",
        "mydrobo.com",
        "drud.io",
        "drud.us",
        "duckdns.org",
        "bip.sh",
        "bitbridge.net",
        "dy.fi",
        "tunk.org",
        "dyndns-at-home.com",
        "dyndns-at-work.com",
        "dyndns-blog.com",
        "dyndns-free.com",
        "dyndns-home.com",
        "dyndns-ip.com",
        "dyndns-mail.com",
        "dyndns-office.com",
        "dyndns-pics.com",
        "dyndns-remote.com",
        "dyndns-server.com",
        "dyndns-web.com",
        "dyndns-wiki.com",
        "dyndns-work.com",
        "dyndns.biz",
        "dyndns.info",
        "dyndns.org",
        "dyndns.tv",
        "at-band-camp.net",
        "ath.cx",
        "barrel-of-knowledge.info",
        "barrell-of-knowledge.info",
        "better-than.tv",
        "blogdns.com",
        "blogdns.net",
        "blogdns.org",
        "blogsite.org",
        "boldlygoingnowhere.org",
        "broke-it.net",
        "buyshouses.net",
        "cechire.com",
        "dnsalias.com",
        "dnsalias.net",
        "dnsalias.org",
        "dnsdojo.com",
        "dnsdojo.net",
        "dnsdojo.org",
        "does-it.net",
        "doesntexist.com",
        "doesntexist.org",
        "dontexist.com",
        "dontexist.net",
        "dontexist.org",
        "doomdns.com",
        "doomdns.org",
        "dvrdns.org",
        "dyn-o-saur.com",
        "dynalias.com",
        "dynalias.net",
        "dynalias.org",
        "dynathome.net",
        "dyndns.ws",
        "endofinternet.net",
        "endofinternet.org",
        "endoftheinternet.org",
        "est-a-la-maison.com",
        "est-a-la-masion.com",
        "est-le-patron.com",
        "est-mon-blogueur.com",
        "for-better.biz",
        "for-more.biz",
        "for-our.info",
        "for-some.biz",
        "for-the.biz",
        "forgot.her.name",
        "forgot.his.name",
        "from-ak.com",
        "from-al.com",
        "from-ar.com",
        "from-az.net",
        "from-ca.com",
        "from-co.net",
        "from-ct.com",
        "from-dc.com",
        "from-de.com",
        "from-fl.com",
        "from-ga.com",
        "from-hi.com",
        "from-ia.com",
        "from-id.com",
        "from-il.com",
        "from-in.com",
        "from-ks.com",
        "from-ky.com",
        "from-la.net",
        "from-ma.com",
        "from-md.com",
        "from-me.org",
        "from-mi.com",
        "from-mn.com",
        "from-mo.com",
        "from-ms.com",
        "from-mt.com",
        "from-nc.com",
        "from-nd.com",
        "from-ne.com",
        "from-nh.com",
        "from-nj.com",
        "from-nm.com",
        "from-nv.com",
        "from-ny.net",
        "from-oh.com",
        "from-ok.com",
        "from-or.com",
        "from-pa.com",
        "from-pr.com",
        "from-ri.com",
        "from-sc.com",
        "from-sd.com",
        "from-tn.com",
        "from-tx.com",
        "from-ut.com",
        "from-va.com",
        "from-vt.com",
        "from-wa.com",
        "from-wi.com",
        "from-wv.com",
        "from-wy.com",
        "ftpaccess.cc",
        "fuettertdasnetz.de",
        "game-host.org",
        "game-server.cc",
        "getmyip.com",
        "gets-it.net",
        "go.dyndns.org",
        "gotdns.com",
        "gotdns.org",
        "groks-the.info",
        "groks-this.info",
        "ham-radio-op.net",
        "here-for-more.info",
        "hobby-site.com",
        "hobby-site.org",
        "home.dyndns.org",
        "homedns.org",
        "homeftp.net",
        "homeftp.org",
        "homeip.net",
        "homelinux.com",
        "homelinux.net",
        "homelinux.org",
        "homeunix.com",
        "homeunix.net",
        "homeunix.org",
        "iamallama.com",
        "in-the-band.net",
        "is-a-anarchist.com",
        "is-a-blogger.com",
        "is-a-bookkeeper.com",
        "is-a-bruinsfan.org",
        "is-a-bulls-fan.com",
        "is-a-candidate.org",
        "is-a-caterer.com",
        "is-a-celticsfan.org",
        "is-a-chef.com",
        "is-a-chef.net",
        "is-a-chef.org",
        "is-a-conservative.com",
        "is-a-cpa.com",
        "is-a-cubicle-slave.com",
        "is-a-democrat.com",
        "is-a-designer.com",
        "is-a-doctor.com",
        "is-a-financialadvisor.com",
        "is-a-geek.com",
        "is-a-geek.net",
        "is-a-geek.org",
        "is-a-green.com",
        "is-a-guru.com",
        "is-a-hard-worker.com",
        "is-a-hunter.com",
        "is-a-knight.org",
        "is-a-landscaper.com",
        "is-a-lawyer.com",
        "is-a-liberal.com",
        "is-a-libertarian.com",
        "is-a-linux-user.org",
        "is-a-llama.com",
        "is-a-musician.com",
        "is-a-nascarfan.com",
        "is-a-nurse.com",
        "is-a-painter.com",
        "is-a-patsfan.org",
        "is-a-personaltrainer.com",
        "is-a-photographer.com",
        "is-a-player.com",
        "is-a-republican.com",
        "is-a-rockstar.com",
        "is-a-socialist.com",
        "is-a-soxfan.org",
        "is-a-student.com",
        "is-a-teacher.com",
        "is-a-techie.com",
        "is-a-therapist.com",
        "is-an-accountant.com",
        "is-an-actor.com",
        "is-an-actress.com",
        "is-an-anarchist.com",
        "is-an-artist.com",
        "is-an-engineer.com",
        "is-an-entertainer.com",
        "is-by.us",
        "is-certified.com",
        "is-found.org",
        "is-gone.com",
        "is-into-anime.com",
        "is-into-cars.com",
        "is-into-cartoons.com",
        "is-into-games.com",
        "is-leet.com",
        "is-lost.org",
        "is-not-certified.com",
        "is-saved.org",
        "is-slick.com",
        "is-uberleet.com",
        "is-very-bad.org",
        "is-very-evil.org",
        "is-very-good.org",
        "is-very-nice.org",
        "is-very-sweet.org",
        "is-with-theband.com",
        "isa-geek.com",
        "isa-geek.net",
        "isa-geek.org",
        "isa-hockeynut.com",
        "issmarterthanyou.com",
        "isteingeek.de",
        "istmein.de",
        "kicks-ass.net",
        "kicks-ass.org",
        "knowsitall.info",
        "land-4-sale.us",
        "lebtimnetz.de",
        "leitungsen.de",
        "likes-pie.com",
        "likescandy.com",
        "merseine.nu",
        "mine.nu",
        "misconfused.org",
        "mypets.ws",
        "myphotos.cc",
        "neat-url.com",
        "office-on-the.net",
        "on-the-web.tv",
        "podzone.net",
        "podzone.org",
        "readmyblog.org",
        "saves-the-whales.com",
        "scrapper-site.net",
        "scrapping.cc",
        "selfip.biz",
        "selfip.com",
        "selfip.info",
        "selfip.net",
        "selfip.org",
        "sells-for-less.com",
        "sells-for-u.com",
        "sells-it.net",
        "sellsyourhome.org",
        "servebbs.com",
        "servebbs.net",
        "servebbs.org",
        "serveftp.net",
        "serveftp.org",
        "servegame.org",
        "shacknet.nu",
        "simple-url.com",
        "space-to-rent.com",
        "stuff-4-sale.org",
        "stuff-4-sale.us",
        "teaches-yoga.com",
        "thruhere.net",
        "traeumtgerade.de",
        "webhop.biz",
        "webhop.info",
        "webhop.net",
        "webhop.org",
        "worse-than.tv",
        "writesthisblog.com",
        "ddnss.de",
        "dyn.ddnss.de",
        "dyndns.ddnss.de",
        "dyndns1.de",
        "dyn-ip24.de",
        "home-webserver.de",
        "dyn.home-webserver.de",
        "myhome-server.de",
        "ddnss.org",
        "definima.net",
        "definima.io",
        "ondigitalocean.app",
        "*.digitaloceanspaces.com",
        "bci.dnstrace.pro",
        "ddnsfree.com",
        "ddnsgeek.com",
        "giize.com",
        "gleeze.com",
        "kozow.com",
        "loseyourip.com",
        "ooguy.com",
        "theworkpc.com",
        "casacam.net",
        "dynu.net",
        "accesscam.org",
        "camdvr.org",
        "freeddns.org",
        "mywire.org",
        "webredirect.org",
        "myddns.rocks",
        "blogsite.xyz",
        "dynv6.net",
        "e4.cz",
        "eero.online",
        "eero-stage.online",
        "elementor.cloud",
        "elementor.cool",
        "en-root.fr",
        "mytuleap.com",
        "tuleap-partners.com",
        "encr.app",
        "encoreapi.com",
        "onred.one",
        "staging.onred.one",
        "eu.encoway.cloud",
        "eu.org",
        "al.eu.org",
        "asso.eu.org",
        "at.eu.org",
        "au.eu.org",
        "be.eu.org",
        "bg.eu.org",
        "ca.eu.org",
        "cd.eu.org",
        "ch.eu.org",
        "cn.eu.org",
        "cy.eu.org",
        "cz.eu.org",
        "de.eu.org",
        "dk.eu.org",
        "edu.eu.org",
        "ee.eu.org",
        "es.eu.org",
        "fi.eu.org",
        "fr.eu.org",
        "gr.eu.org",
        "hr.eu.org",
        "hu.eu.org",
        "ie.eu.org",
        "il.eu.org",
        "in.eu.org",
        "int.eu.org",
        "is.eu.org",
        "it.eu.org",
        "jp.eu.org",
        "kr.eu.org",
        "lt.eu.org",
        "lu.eu.org",
        "lv.eu.org",
        "mc.eu.org",
        "me.eu.org",
        "mk.eu.org",
        "mt.eu.org",
        "my.eu.org",
        "net.eu.org",
        "ng.eu.org",
        "nl.eu.org",
        "no.eu.org",
        "nz.eu.org",
        "paris.eu.org",
        "pl.eu.org",
        "pt.eu.org",
        "q-a.eu.org",
        "ro.eu.org",
        "ru.eu.org",
        "se.eu.org",
        "si.eu.org",
        "sk.eu.org",
        "tr.eu.org",
        "uk.eu.org",
        "us.eu.org",
        "eurodir.ru",
        "eu-1.evennode.com",
        "eu-2.evennode.com",
        "eu-3.evennode.com",
        "eu-4.evennode.com",
        "us-1.evennode.com",
        "us-2.evennode.com",
        "us-3.evennode.com",
        "us-4.evennode.com",
        "twmail.cc",
        "twmail.net",
        "twmail.org",
        "mymailer.com.tw",
        "url.tw",
        "onfabrica.com",
        "apps.fbsbx.com",
        "ru.net",
        "adygeya.ru",
        "bashkiria.ru",
        "bir.ru",
        "cbg.ru",
        "com.ru",
        "dagestan.ru",
        "grozny.ru",
        "kalmykia.ru",
        "kustanai.ru",
        "marine.ru",
        "mordovia.ru",
        "msk.ru",
        "mytis.ru",
        "nalchik.ru",
        "nov.ru",
        "pyatigorsk.ru",
        "spb.ru",
        "vladikavkaz.ru",
        "vladimir.ru",
        "abkhazia.su",
        "adygeya.su",
        "aktyubinsk.su",
        "arkhangelsk.su",
        "armenia.su",
        "ashgabad.su",
        "azerbaijan.su",
        "balashov.su",
        "bashkiria.su",
        "bryansk.su",
        "bukhara.su",
        "chimkent.su",
        "dagestan.su",
        "east-kazakhstan.su",
        "exnet.su",
        "georgia.su",
        "grozny.su",
        "ivanovo.su",
        "jambyl.su",
        "kalmykia.su",
        "kaluga.su",
        "karacol.su",
        "karaganda.su",
        "karelia.su",
        "khakassia.su",
        "krasnodar.su",
        "kurgan.su",
        "kustanai.su",
        "lenug.su",
        "mangyshlak.su",
        "mordovia.su",
        "msk.su",
        "murmansk.su",
        "nalchik.su",
        "navoi.su",
        "north-kazakhstan.su",
        "nov.su",
        "obninsk.su",
        "penza.su",
        "pokrovsk.su",
        "sochi.su",
        "spb.su",
        "tashkent.su",
        "termez.su",
        "togliatti.su",
        "troitsk.su",
        "tselinograd.su",
        "tula.su",
        "tuva.su",
        "vladikavkaz.su",
        "vladimir.su",
        "vologda.su",
        "channelsdvr.net",
        "u.channelsdvr.net",
        "edgecompute.app",
        "fastly-terrarium.com",
        "fastlylb.net",
        "map.fastlylb.net",
        "freetls.fastly.net",
        "map.fastly.net",
        "a.prod.fastly.net",
        "global.prod.fastly.net",
        "a.ssl.fastly.net",
        "b.ssl.fastly.net",
        "global.ssl.fastly.net",
        "fastvps-server.com",
        "fastvps.host",
        "myfast.host",
        "fastvps.site",
        "myfast.space",
        "fedorainfracloud.org",
        "fedorapeople.org",
        "cloud.fedoraproject.org",
        "app.os.fedoraproject.org",
        "app.os.stg.fedoraproject.org",
        "conn.uk",
        "copro.uk",
        "hosp.uk",
        "mydobiss.com",
        "fh-muenster.io",
        "filegear.me",
        "filegear-au.me",
        "filegear-de.me",
        "filegear-gb.me",
        "filegear-ie.me",
        "filegear-jp.me",
        "filegear-sg.me",
        "firebaseapp.com",
        "fireweb.app",
        "flap.id",
        "onflashdrive.app",
        "fldrv.com",
        "fly.dev",
        "edgeapp.net",
        "shw.io",
        "flynnhosting.net",
        "forgeblocks.com",
        "id.forgerock.io",
        "framer.app",
        "framercanvas.com",
        "*.frusky.de",
        "ravpage.co.il",
        "0e.vc",
        "freebox-os.com",
        "freeboxos.com",
        "fbx-os.fr",
        "fbxos.fr",
        "freebox-os.fr",
        "freeboxos.fr",
        "freedesktop.org",
        "freemyip.com",
        "wien.funkfeuer.at",
        "*.futurecms.at",
        "*.ex.futurecms.at",
        "*.in.futurecms.at",
        "futurehosting.at",
        "futuremailing.at",
        "*.ex.ortsinfo.at",
        "*.kunden.ortsinfo.at",
        "*.statics.cloud",
        "independent-commission.uk",
        "independent-inquest.uk",
        "independent-inquiry.uk",
        "independent-panel.uk",
        "independent-review.uk",
        "public-inquiry.uk",
        "royal-commission.uk",
        "campaign.gov.uk",
        "service.gov.uk",
        "api.gov.uk",
        "gehirn.ne.jp",
        "usercontent.jp",
        "gentapps.com",
        "gentlentapis.com",
        "lab.ms",
        "cdn-edges.net",
        "ghost.io",
        "gsj.bz",
        "githubusercontent.com",
        "githubpreview.dev",
        "github.io",
        "gitlab.io",
        "gitapp.si",
        "gitpage.si",
        "glitch.me",
        "nog.community",
        "co.ro",
        "shop.ro",
        "lolipop.io",
        "angry.jp",
        "babyblue.jp",
        "babymilk.jp",
        "backdrop.jp",
        "bambina.jp",
        "bitter.jp",
        "blush.jp",
        "boo.jp",
        "boy.jp",
        "boyfriend.jp",
        "but.jp",
        "candypop.jp",
        "capoo.jp",
        "catfood.jp",
        "cheap.jp",
        "chicappa.jp",
        "chillout.jp",
        "chips.jp",
        "chowder.jp",
        "chu.jp",
        "ciao.jp",
        "cocotte.jp",
        "coolblog.jp",
        "cranky.jp",
        "cutegirl.jp",
        "daa.jp",
        "deca.jp",
        "deci.jp",
        "digick.jp",
        "egoism.jp",
        "fakefur.jp",
        "fem.jp",
        "flier.jp",
        "floppy.jp",
        "fool.jp",
        "frenchkiss.jp",
        "girlfriend.jp",
        "girly.jp",
        "gloomy.jp",
        "gonna.jp",
        "greater.jp",
        "hacca.jp",
        "heavy.jp",
        "her.jp",
        "hiho.jp",
        "hippy.jp",
        "holy.jp",
        "hungry.jp",
        "icurus.jp",
        "itigo.jp",
        "jellybean.jp",
        "kikirara.jp",
        "kill.jp",
        "kilo.jp",
        "kuron.jp",
        "littlestar.jp",
        "lolipopmc.jp",
        "lolitapunk.jp",
        "lomo.jp",
        "lovepop.jp",
        "lovesick.jp",
        "main.jp",
        "mods.jp",
        "mond.jp",
        "mongolian.jp",
        "moo.jp",
        "namaste.jp",
        "nikita.jp",
        "nobushi.jp",
        "noor.jp",
        "oops.jp",
        "parallel.jp",
        "parasite.jp",
        "pecori.jp",
        "peewee.jp",
        "penne.jp",
        "pepper.jp",
        "perma.jp",
        "pigboat.jp",
        "pinoko.jp",
        "punyu.jp",
        "pupu.jp",
        "pussycat.jp",
        "pya.jp",
        "raindrop.jp",
        "readymade.jp",
        "sadist.jp",
        "schoolbus.jp",
        "secret.jp",
        "staba.jp",
        "stripper.jp",
        "sub.jp",
        "sunnyday.jp",
        "thick.jp",
        "tonkotsu.jp",
        "under.jp",
        "upper.jp",
        "velvet.jp",
        "verse.jp",
        "versus.jp",
        "vivian.jp",
        "watson.jp",
        "weblike.jp",
        "whitesnow.jp",
        "zombie.jp",
        "heteml.net",
        "cloudapps.digital",
        "london.cloudapps.digital",
        "pymnt.uk",
        "homeoffice.gov.uk",
        "ro.im",
        "goip.de",
        "run.app",
        "a.run.app",
        "web.app",
        "*.0emm.com",
        "appspot.com",
        "*.r.appspot.com",
        "codespot.com",
        "googleapis.com",
        "googlecode.com",
        "pagespeedmobilizer.com",
        "publishproxy.com",
        "withgoogle.com",
        "withyoutube.com",
        "*.gateway.dev",
        "cloud.goog",
        "translate.goog",
        "*.usercontent.goog",
        "cloudfunctions.net",
        "blogspot.ae",
        "blogspot.al",
        "blogspot.am",
        "blogspot.ba",
        "blogspot.be",
        "blogspot.bg",
        "blogspot.bj",
        "blogspot.ca",
        "blogspot.cf",
        "blogspot.ch",
        "blogspot.cl",
        "blogspot.co.at",
        "blogspot.co.id",
        "blogspot.co.il",
        "blogspot.co.ke",
        "blogspot.co.nz",
        "blogspot.co.uk",
        "blogspot.co.za",
        "blogspot.com",
        "blogspot.com.ar",
        "blogspot.com.au",
        "blogspot.com.br",
        "blogspot.com.by",
        "blogspot.com.co",
        "blogspot.com.cy",
        "blogspot.com.ee",
        "blogspot.com.eg",
        "blogspot.com.es",
        "blogspot.com.mt",
        "blogspot.com.ng",
        "blogspot.com.tr",
        "blogspot.com.uy",
        "blogspot.cv",
        "blogspot.cz",
        "blogspot.de",
        "blogspot.dk",
        "blogspot.fi",
        "blogspot.fr",
        "blogspot.gr",
        "blogspot.hk",
        "blogspot.hr",
        "blogspot.hu",
        "blogspot.ie",
        "blogspot.in",
        "blogspot.is",
        "blogspot.it",
        "blogspot.jp",
        "blogspot.kr",
        "blogspot.li",
        "blogspot.lt",
        "blogspot.lu",
        "blogspot.md",
        "blogspot.mk",
        "blogspot.mr",
        "blogspot.mx",
        "blogspot.my",
        "blogspot.nl",
        "blogspot.no",
        "blogspot.pe",
        "blogspot.pt",
        "blogspot.qa",
        "blogspot.re",
        "blogspot.ro",
        "blogspot.rs",
        "blogspot.ru",
        "blogspot.se",
        "blogspot.sg",
        "blogspot.si",
        "blogspot.sk",
        "blogspot.sn",
        "blogspot.td",
        "blogspot.tw",
        "blogspot.ug",
        "blogspot.vn",
        "goupile.fr",
        "gov.nl",
        "awsmppl.com",
        "g\xFCnstigbestellen.de",
        "g\xFCnstigliefern.de",
        "fin.ci",
        "free.hr",
        "caa.li",
        "ua.rs",
        "conf.se",
        "hs.zone",
        "hs.run",
        "hashbang.sh",
        "hasura.app",
        "hasura-app.io",
        "pages.it.hs-heilbronn.de",
        "hepforge.org",
        "herokuapp.com",
        "herokussl.com",
        "ravendb.cloud",
        "myravendb.com",
        "ravendb.community",
        "ravendb.me",
        "development.run",
        "ravendb.run",
        "homesklep.pl",
        "secaas.hk",
        "hoplix.shop",
        "orx.biz",
        "biz.gl",
        "col.ng",
        "firm.ng",
        "gen.ng",
        "ltd.ng",
        "ngo.ng",
        "edu.scot",
        "sch.so",
        "hostyhosting.io",
        "h\xE4kkinen.fi",
        "*.moonscale.io",
        "moonscale.net",
        "iki.fi",
        "ibxos.it",
        "iliadboxos.it",
        "impertrixcdn.com",
        "impertrix.com",
        "smushcdn.com",
        "wphostedmail.com",
        "wpmucdn.com",
        "tempurl.host",
        "wpmudev.host",
        "dyn-berlin.de",
        "in-berlin.de",
        "in-brb.de",
        "in-butter.de",
        "in-dsl.de",
        "in-dsl.net",
        "in-dsl.org",
        "in-vpn.de",
        "in-vpn.net",
        "in-vpn.org",
        "biz.at",
        "info.at",
        "info.cx",
        "ac.leg.br",
        "al.leg.br",
        "am.leg.br",
        "ap.leg.br",
        "ba.leg.br",
        "ce.leg.br",
        "df.leg.br",
        "es.leg.br",
        "go.leg.br",
        "ma.leg.br",
        "mg.leg.br",
        "ms.leg.br",
        "mt.leg.br",
        "pa.leg.br",
        "pb.leg.br",
        "pe.leg.br",
        "pi.leg.br",
        "pr.leg.br",
        "rj.leg.br",
        "rn.leg.br",
        "ro.leg.br",
        "rr.leg.br",
        "rs.leg.br",
        "sc.leg.br",
        "se.leg.br",
        "sp.leg.br",
        "to.leg.br",
        "pixolino.com",
        "na4u.ru",
        "iopsys.se",
        "ipifony.net",
        "iservschule.de",
        "mein-iserv.de",
        "schulplattform.de",
        "schulserver.de",
        "test-iserv.de",
        "iserv.dev",
        "iobb.net",
        "mel.cloudlets.com.au",
        "cloud.interhostsolutions.be",
        "users.scale.virtualcloud.com.br",
        "mycloud.by",
        "alp1.ae.flow.ch",
        "appengine.flow.ch",
        "es-1.axarnet.cloud",
        "diadem.cloud",
        "vip.jelastic.cloud",
        "jele.cloud",
        "it1.eur.aruba.jenv-aruba.cloud",
        "it1.jenv-aruba.cloud",
        "keliweb.cloud",
        "cs.keliweb.cloud",
        "oxa.cloud",
        "tn.oxa.cloud",
        "uk.oxa.cloud",
        "primetel.cloud",
        "uk.primetel.cloud",
        "ca.reclaim.cloud",
        "uk.reclaim.cloud",
        "us.reclaim.cloud",
        "ch.trendhosting.cloud",
        "de.trendhosting.cloud",
        "jele.club",
        "amscompute.com",
        "clicketcloud.com",
        "dopaas.com",
        "hidora.com",
        "paas.hosted-by-previder.com",
        "rag-cloud.hosteur.com",
        "rag-cloud-ch.hosteur.com",
        "jcloud.ik-server.com",
        "jcloud-ver-jpc.ik-server.com",
        "demo.jelastic.com",
        "kilatiron.com",
        "paas.massivegrid.com",
        "jed.wafaicloud.com",
        "lon.wafaicloud.com",
        "ryd.wafaicloud.com",
        "j.scaleforce.com.cy",
        "jelastic.dogado.eu",
        "fi.cloudplatform.fi",
        "demo.datacenter.fi",
        "paas.datacenter.fi",
        "jele.host",
        "mircloud.host",
        "paas.beebyte.io",
        "sekd1.beebyteapp.io",
        "jele.io",
        "cloud-fr1.unispace.io",
        "jc.neen.it",
        "cloud.jelastic.open.tim.it",
        "jcloud.kz",
        "upaas.kazteleport.kz",
        "cloudjiffy.net",
        "fra1-de.cloudjiffy.net",
        "west1-us.cloudjiffy.net",
        "jls-sto1.elastx.net",
        "jls-sto2.elastx.net",
        "jls-sto3.elastx.net",
        "faststacks.net",
        "fr-1.paas.massivegrid.net",
        "lon-1.paas.massivegrid.net",
        "lon-2.paas.massivegrid.net",
        "ny-1.paas.massivegrid.net",
        "ny-2.paas.massivegrid.net",
        "sg-1.paas.massivegrid.net",
        "jelastic.saveincloud.net",
        "nordeste-idc.saveincloud.net",
        "j.scaleforce.net",
        "jelastic.tsukaeru.net",
        "sdscloud.pl",
        "unicloud.pl",
        "mircloud.ru",
        "jelastic.regruhosting.ru",
        "enscaled.sg",
        "jele.site",
        "jelastic.team",
        "orangecloud.tn",
        "j.layershift.co.uk",
        "phx.enscaled.us",
        "mircloud.us",
        "myjino.ru",
        "*.hosting.myjino.ru",
        "*.landing.myjino.ru",
        "*.spectrum.myjino.ru",
        "*.vps.myjino.ru",
        "jotelulu.cloud",
        "*.triton.zone",
        "*.cns.joyent.com",
        "js.org",
        "kaas.gg",
        "khplay.nl",
        "ktistory.com",
        "kapsi.fi",
        "keymachine.de",
        "kinghost.net",
        "uni5.net",
        "knightpoint.systems",
        "koobin.events",
        "oya.to",
        "kuleuven.cloud",
        "ezproxy.kuleuven.be",
        "co.krd",
        "edu.krd",
        "krellian.net",
        "webthings.io",
        "git-repos.de",
        "lcube-server.de",
        "svn-repos.de",
        "leadpages.co",
        "lpages.co",
        "lpusercontent.com",
        "lelux.site",
        "co.business",
        "co.education",
        "co.events",
        "co.financial",
        "co.network",
        "co.place",
        "co.technology",
        "app.lmpm.com",
        "linkyard.cloud",
        "linkyard-cloud.ch",
        "members.linode.com",
        "*.nodebalancer.linode.com",
        "*.linodeobjects.com",
        "ip.linodeusercontent.com",
        "we.bs",
        "*.user.localcert.dev",
        "localzone.xyz",
        "loginline.app",
        "loginline.dev",
        "loginline.io",
        "loginline.services",
        "loginline.site",
        "servers.run",
        "lohmus.me",
        "krasnik.pl",
        "leczna.pl",
        "lubartow.pl",
        "lublin.pl",
        "poniatowa.pl",
        "swidnik.pl",
        "glug.org.uk",
        "lug.org.uk",
        "lugs.org.uk",
        "barsy.bg",
        "barsy.co.uk",
        "barsyonline.co.uk",
        "barsycenter.com",
        "barsyonline.com",
        "barsy.club",
        "barsy.de",
        "barsy.eu",
        "barsy.in",
        "barsy.info",
        "barsy.io",
        "barsy.me",
        "barsy.menu",
        "barsy.mobi",
        "barsy.net",
        "barsy.online",
        "barsy.org",
        "barsy.pro",
        "barsy.pub",
        "barsy.ro",
        "barsy.shop",
        "barsy.site",
        "barsy.support",
        "barsy.uk",
        "*.magentosite.cloud",
        "mayfirst.info",
        "mayfirst.org",
        "hb.cldmail.ru",
        "cn.vu",
        "mazeplay.com",
        "mcpe.me",
        "mcdir.me",
        "mcdir.ru",
        "mcpre.ru",
        "vps.mcdir.ru",
        "mediatech.by",
        "mediatech.dev",
        "hra.health",
        "miniserver.com",
        "memset.net",
        "messerli.app",
        "*.cloud.metacentrum.cz",
        "custom.metacentrum.cz",
        "flt.cloud.muni.cz",
        "usr.cloud.muni.cz",
        "meteorapp.com",
        "eu.meteorapp.com",
        "co.pl",
        "*.azurecontainer.io",
        "azurewebsites.net",
        "azure-mobile.net",
        "cloudapp.net",
        "azurestaticapps.net",
        "1.azurestaticapps.net",
        "centralus.azurestaticapps.net",
        "eastasia.azurestaticapps.net",
        "eastus2.azurestaticapps.net",
        "westeurope.azurestaticapps.net",
        "westus2.azurestaticapps.net",
        "csx.cc",
        "mintere.site",
        "forte.id",
        "mozilla-iot.org",
        "bmoattachments.org",
        "net.ru",
        "org.ru",
        "pp.ru",
        "hostedpi.com",
        "customer.mythic-beasts.com",
        "caracal.mythic-beasts.com",
        "fentiger.mythic-beasts.com",
        "lynx.mythic-beasts.com",
        "ocelot.mythic-beasts.com",
        "oncilla.mythic-beasts.com",
        "onza.mythic-beasts.com",
        "sphinx.mythic-beasts.com",
        "vs.mythic-beasts.com",
        "x.mythic-beasts.com",
        "yali.mythic-beasts.com",
        "cust.retrosnub.co.uk",
        "ui.nabu.casa",
        "pony.club",
        "of.fashion",
        "in.london",
        "of.london",
        "from.marketing",
        "with.marketing",
        "for.men",
        "repair.men",
        "and.mom",
        "for.mom",
        "for.one",
        "under.one",
        "for.sale",
        "that.win",
        "from.work",
        "to.work",
        "cloud.nospamproxy.com",
        "netlify.app",
        "4u.com",
        "ngrok.io",
        "nh-serv.co.uk",
        "nfshost.com",
        "*.developer.app",
        "noop.app",
        "*.northflank.app",
        "*.build.run",
        "*.code.run",
        "*.database.run",
        "*.migration.run",
        "noticeable.news",
        "dnsking.ch",
        "mypi.co",
        "n4t.co",
        "001www.com",
        "ddnslive.com",
        "myiphost.com",
        "forumz.info",
        "16-b.it",
        "32-b.it",
        "64-b.it",
        "soundcast.me",
        "tcp4.me",
        "dnsup.net",
        "hicam.net",
        "now-dns.net",
        "ownip.net",
        "vpndns.net",
        "dynserv.org",
        "now-dns.org",
        "x443.pw",
        "now-dns.top",
        "ntdll.top",
        "freeddns.us",
        "crafting.xyz",
        "zapto.xyz",
        "nsupdate.info",
        "nerdpol.ovh",
        "blogsyte.com",
        "brasilia.me",
        "cable-modem.org",
        "ciscofreak.com",
        "collegefan.org",
        "couchpotatofries.org",
        "damnserver.com",
        "ddns.me",
        "ditchyourip.com",
        "dnsfor.me",
        "dnsiskinky.com",
        "dvrcam.info",
        "dynns.com",
        "eating-organic.net",
        "fantasyleague.cc",
        "geekgalaxy.com",
        "golffan.us",
        "health-carereform.com",
        "homesecuritymac.com",
        "homesecuritypc.com",
        "hopto.me",
        "ilovecollege.info",
        "loginto.me",
        "mlbfan.org",
        "mmafan.biz",
        "myactivedirectory.com",
        "mydissent.net",
        "myeffect.net",
        "mymediapc.net",
        "mypsx.net",
        "mysecuritycamera.com",
        "mysecuritycamera.net",
        "mysecuritycamera.org",
        "net-freaks.com",
        "nflfan.org",
        "nhlfan.net",
        "no-ip.ca",
        "no-ip.co.uk",
        "no-ip.net",
        "noip.us",
        "onthewifi.com",
        "pgafan.net",
        "point2this.com",
        "pointto.us",
        "privatizehealthinsurance.net",
        "quicksytes.com",
        "read-books.org",
        "securitytactics.com",
        "serveexchange.com",
        "servehumour.com",
        "servep2p.com",
        "servesarcasm.com",
        "stufftoread.com",
        "ufcfan.org",
        "unusualperson.com",
        "workisboring.com",
        "3utilities.com",
        "bounceme.net",
        "ddns.net",
        "ddnsking.com",
        "gotdns.ch",
        "hopto.org",
        "myftp.biz",
        "myftp.org",
        "myvnc.com",
        "no-ip.biz",
        "no-ip.info",
        "no-ip.org",
        "noip.me",
        "redirectme.net",
        "servebeer.com",
        "serveblog.net",
        "servecounterstrike.com",
        "serveftp.com",
        "servegame.com",
        "servehalflife.com",
        "servehttp.com",
        "serveirc.com",
        "serveminecraft.net",
        "servemp3.com",
        "servepics.com",
        "servequake.com",
        "sytes.net",
        "webhop.me",
        "zapto.org",
        "stage.nodeart.io",
        "pcloud.host",
        "nyc.mn",
        "static.observableusercontent.com",
        "cya.gg",
        "omg.lol",
        "cloudycluster.net",
        "omniwe.site",
        "service.one",
        "nid.io",
        "opensocial.site",
        "opencraft.hosting",
        "orsites.com",
        "operaunite.com",
        "tech.orange",
        "authgear-staging.com",
        "authgearapps.com",
        "skygearapp.com",
        "outsystemscloud.com",
        "*.webpaas.ovh.net",
        "*.hosting.ovh.net",
        "ownprovider.com",
        "own.pm",
        "*.owo.codes",
        "ox.rs",
        "oy.lc",
        "pgfog.com",
        "pagefrontapp.com",
        "pagexl.com",
        "*.paywhirl.com",
        "bar0.net",
        "bar1.net",
        "bar2.net",
        "rdv.to",
        "art.pl",
        "gliwice.pl",
        "krakow.pl",
        "poznan.pl",
        "wroc.pl",
        "zakopane.pl",
        "pantheonsite.io",
        "gotpantheon.com",
        "mypep.link",
        "perspecta.cloud",
        "lk3.ru",
        "on-web.fr",
        "bc.platform.sh",
        "ent.platform.sh",
        "eu.platform.sh",
        "us.platform.sh",
        "*.platformsh.site",
        "*.tst.site",
        "platter-app.com",
        "platter-app.dev",
        "platterp.us",
        "pdns.page",
        "plesk.page",
        "pleskns.com",
        "dyn53.io",
        "onporter.run",
        "co.bn",
        "postman-echo.com",
        "pstmn.io",
        "mock.pstmn.io",
        "httpbin.org",
        "prequalifyme.today",
        "xen.prgmr.com",
        "priv.at",
        "prvcy.page",
        "*.dweb.link",
        "protonet.io",
        "chirurgiens-dentistes-en-france.fr",
        "byen.site",
        "pubtls.org",
        "pythonanywhere.com",
        "eu.pythonanywhere.com",
        "qoto.io",
        "qualifioapp.com",
        "qbuser.com",
        "cloudsite.builders",
        "instances.spawn.cc",
        "instantcloud.cn",
        "ras.ru",
        "qa2.com",
        "qcx.io",
        "*.sys.qcx.io",
        "dev-myqnapcloud.com",
        "alpha-myqnapcloud.com",
        "myqnapcloud.com",
        "*.quipelements.com",
        "vapor.cloud",
        "vaporcloud.io",
        "rackmaze.com",
        "rackmaze.net",
        "g.vbrplsbx.io",
        "*.on-k3s.io",
        "*.on-rancher.cloud",
        "*.on-rio.io",
        "readthedocs.io",
        "rhcloud.com",
        "app.render.com",
        "onrender.com",
        "repl.co",
        "id.repl.co",
        "repl.run",
        "resindevice.io",
        "devices.resinstaging.io",
        "hzc.io",
        "wellbeingzone.eu",
        "wellbeingzone.co.uk",
        "adimo.co.uk",
        "itcouldbewor.se",
        "git-pages.rit.edu",
        "rocky.page",
        "\u0431\u0438\u0437.\u0440\u0443\u0441",
        "\u043A\u043E\u043C.\u0440\u0443\u0441",
        "\u043A\u0440\u044B\u043C.\u0440\u0443\u0441",
        "\u043C\u0438\u0440.\u0440\u0443\u0441",
        "\u043C\u0441\u043A.\u0440\u0443\u0441",
        "\u043E\u0440\u0433.\u0440\u0443\u0441",
        "\u0441\u0430\u043C\u0430\u0440\u0430.\u0440\u0443\u0441",
        "\u0441\u043E\u0447\u0438.\u0440\u0443\u0441",
        "\u0441\u043F\u0431.\u0440\u0443\u0441",
        "\u044F.\u0440\u0443\u0441",
        "*.builder.code.com",
        "*.dev-builder.code.com",
        "*.stg-builder.code.com",
        "sandcats.io",
        "logoip.de",
        "logoip.com",
        "fr-par-1.baremetal.scw.cloud",
        "fr-par-2.baremetal.scw.cloud",
        "nl-ams-1.baremetal.scw.cloud",
        "fnc.fr-par.scw.cloud",
        "functions.fnc.fr-par.scw.cloud",
        "k8s.fr-par.scw.cloud",
        "nodes.k8s.fr-par.scw.cloud",
        "s3.fr-par.scw.cloud",
        "s3-website.fr-par.scw.cloud",
        "whm.fr-par.scw.cloud",
        "priv.instances.scw.cloud",
        "pub.instances.scw.cloud",
        "k8s.scw.cloud",
        "k8s.nl-ams.scw.cloud",
        "nodes.k8s.nl-ams.scw.cloud",
        "s3.nl-ams.scw.cloud",
        "s3-website.nl-ams.scw.cloud",
        "whm.nl-ams.scw.cloud",
        "k8s.pl-waw.scw.cloud",
        "nodes.k8s.pl-waw.scw.cloud",
        "s3.pl-waw.scw.cloud",
        "s3-website.pl-waw.scw.cloud",
        "scalebook.scw.cloud",
        "smartlabeling.scw.cloud",
        "dedibox.fr",
        "schokokeks.net",
        "gov.scot",
        "service.gov.scot",
        "scrysec.com",
        "firewall-gateway.com",
        "firewall-gateway.de",
        "my-gateway.de",
        "my-router.de",
        "spdns.de",
        "spdns.eu",
        "firewall-gateway.net",
        "my-firewall.org",
        "myfirewall.org",
        "spdns.org",
        "seidat.net",
        "sellfy.store",
        "senseering.net",
        "minisite.ms",
        "magnet.page",
        "biz.ua",
        "co.ua",
        "pp.ua",
        "shiftcrypto.dev",
        "shiftcrypto.io",
        "shiftedit.io",
        "myshopblocks.com",
        "myshopify.com",
        "shopitsite.com",
        "shopware.store",
        "mo-siemens.io",
        "1kapp.com",
        "appchizi.com",
        "applinzi.com",
        "sinaapp.com",
        "vipsinaapp.com",
        "siteleaf.net",
        "bounty-full.com",
        "alpha.bounty-full.com",
        "beta.bounty-full.com",
        "small-web.org",
        "vp4.me",
        "try-snowplow.com",
        "srht.site",
        "stackhero-network.com",
        "musician.io",
        "novecore.site",
        "static.land",
        "dev.static.land",
        "sites.static.land",
        "storebase.store",
        "vps-host.net",
        "atl.jelastic.vps-host.net",
        "njs.jelastic.vps-host.net",
        "ric.jelastic.vps-host.net",
        "playstation-cloud.com",
        "apps.lair.io",
        "*.stolos.io",
        "spacekit.io",
        "customer.speedpartner.de",
        "myspreadshop.at",
        "myspreadshop.com.au",
        "myspreadshop.be",
        "myspreadshop.ca",
        "myspreadshop.ch",
        "myspreadshop.com",
        "myspreadshop.de",
        "myspreadshop.dk",
        "myspreadshop.es",
        "myspreadshop.fi",
        "myspreadshop.fr",
        "myspreadshop.ie",
        "myspreadshop.it",
        "myspreadshop.net",
        "myspreadshop.nl",
        "myspreadshop.no",
        "myspreadshop.pl",
        "myspreadshop.se",
        "myspreadshop.co.uk",
        "api.stdlib.com",
        "storj.farm",
        "utwente.io",
        "soc.srcf.net",
        "user.srcf.net",
        "temp-dns.com",
        "supabase.co",
        "supabase.in",
        "supabase.net",
        "su.paba.se",
        "*.s5y.io",
        "*.sensiosite.cloud",
        "syncloud.it",
        "dscloud.biz",
        "direct.quickconnect.cn",
        "dsmynas.com",
        "familyds.com",
        "diskstation.me",
        "dscloud.me",
        "i234.me",
        "myds.me",
        "synology.me",
        "dscloud.mobi",
        "dsmynas.net",
        "familyds.net",
        "dsmynas.org",
        "familyds.org",
        "vpnplus.to",
        "direct.quickconnect.to",
        "tabitorder.co.il",
        "taifun-dns.de",
        "beta.tailscale.net",
        "ts.net",
        "gda.pl",
        "gdansk.pl",
        "gdynia.pl",
        "med.pl",
        "sopot.pl",
        "site.tb-hosting.com",
        "edugit.io",
        "s3.teckids.org",
        "telebit.app",
        "telebit.io",
        "*.telebit.xyz",
        "gwiddle.co.uk",
        "*.firenet.ch",
        "*.svc.firenet.ch",
        "reservd.com",
        "thingdustdata.com",
        "cust.dev.thingdust.io",
        "cust.disrec.thingdust.io",
        "cust.prod.thingdust.io",
        "cust.testing.thingdust.io",
        "reservd.dev.thingdust.io",
        "reservd.disrec.thingdust.io",
        "reservd.testing.thingdust.io",
        "tickets.io",
        "arvo.network",
        "azimuth.network",
        "tlon.network",
        "torproject.net",
        "pages.torproject.net",
        "bloxcms.com",
        "townnews-staging.com",
        "tbits.me",
        "12hp.at",
        "2ix.at",
        "4lima.at",
        "lima-city.at",
        "12hp.ch",
        "2ix.ch",
        "4lima.ch",
        "lima-city.ch",
        "trafficplex.cloud",
        "de.cool",
        "12hp.de",
        "2ix.de",
        "4lima.de",
        "lima-city.de",
        "1337.pictures",
        "clan.rip",
        "lima-city.rocks",
        "webspace.rocks",
        "lima.zone",
        "*.transurl.be",
        "*.transurl.eu",
        "*.transurl.nl",
        "site.transip.me",
        "tuxfamily.org",
        "dd-dns.de",
        "diskstation.eu",
        "diskstation.org",
        "dray-dns.de",
        "draydns.de",
        "dyn-vpn.de",
        "dynvpn.de",
        "mein-vigor.de",
        "my-vigor.de",
        "my-wan.de",
        "syno-ds.de",
        "synology-diskstation.de",
        "synology-ds.de",
        "typedream.app",
        "pro.typeform.com",
        "uber.space",
        "*.uberspace.de",
        "hk.com",
        "hk.org",
        "ltd.hk",
        "inc.hk",
        "name.pm",
        "sch.tf",
        "biz.wf",
        "sch.wf",
        "org.yt",
        "virtualuser.de",
        "virtual-user.de",
        "upli.io",
        "urown.cloud",
        "dnsupdate.info",
        "lib.de.us",
        "2038.io",
        "vercel.app",
        "vercel.dev",
        "now.sh",
        "router.management",
        "v-info.info",
        "voorloper.cloud",
        "neko.am",
        "nyaa.am",
        "be.ax",
        "cat.ax",
        "es.ax",
        "eu.ax",
        "gg.ax",
        "mc.ax",
        "us.ax",
        "xy.ax",
        "nl.ci",
        "xx.gl",
        "app.gp",
        "blog.gt",
        "de.gt",
        "to.gt",
        "be.gy",
        "cc.hn",
        "blog.kg",
        "io.kg",
        "jp.kg",
        "tv.kg",
        "uk.kg",
        "us.kg",
        "de.ls",
        "at.md",
        "de.md",
        "jp.md",
        "to.md",
        "indie.porn",
        "vxl.sh",
        "ch.tc",
        "me.tc",
        "we.tc",
        "nyan.to",
        "at.vg",
        "blog.vu",
        "dev.vu",
        "me.vu",
        "v.ua",
        "*.vultrobjects.com",
        "wafflecell.com",
        "*.webhare.dev",
        "reserve-online.net",
        "reserve-online.com",
        "bookonline.app",
        "hotelwithflight.com",
        "wedeploy.io",
        "wedeploy.me",
        "wedeploy.sh",
        "remotewd.com",
        "pages.wiardweb.com",
        "wmflabs.org",
        "toolforge.org",
        "wmcloud.org",
        "panel.gg",
        "daemon.panel.gg",
        "messwithdns.com",
        "woltlab-demo.com",
        "myforum.community",
        "community-pro.de",
        "diskussionsbereich.de",
        "community-pro.net",
        "meinforum.net",
        "affinitylottery.org.uk",
        "raffleentry.org.uk",
        "weeklylottery.org.uk",
        "wpenginepowered.com",
        "js.wpenginepowered.com",
        "wixsite.com",
        "editorx.io",
        "half.host",
        "xnbay.com",
        "u2.xnbay.com",
        "u2-local.xnbay.com",
        "cistron.nl",
        "demon.nl",
        "xs4all.space",
        "yandexcloud.net",
        "storage.yandexcloud.net",
        "website.yandexcloud.net",
        "official.academy",
        "yolasite.com",
        "ybo.faith",
        "yombo.me",
        "homelink.one",
        "ybo.party",
        "ybo.review",
        "ybo.science",
        "ybo.trade",
        "ynh.fr",
        "nohost.me",
        "noho.st",
        "za.net",
        "za.org",
        "bss.design",
        "basicserver.io",
        "virtualserver.io",
        "enterprisecloud.nu"
      ];
    }
  });
  var require_psl = __commonJS3({
    "node_modules/psl/index.js"(exports) {
      "use strict";
      var Punycode = require_punycode();
      var internals = {};
      internals.rules = require_rules().map(function(rule) {
        return {
          rule,
          suffix: rule.replace(/^(\*\.|\!)/, ""),
          punySuffix: -1,
          wildcard: rule.charAt(0) === "*",
          exception: rule.charAt(0) === "!"
        };
      });
      internals.endsWith = function(str, suffix) {
        return str.indexOf(suffix, str.length - suffix.length) !== -1;
      };
      internals.findRule = function(domain) {
        var punyDomain = Punycode.toASCII(domain);
        return internals.rules.reduce(function(memo, rule) {
          if (rule.punySuffix === -1) {
            rule.punySuffix = Punycode.toASCII(rule.suffix);
          }
          if (!internals.endsWith(punyDomain, "." + rule.punySuffix) && punyDomain !== rule.punySuffix) {
            return memo;
          }
          return rule;
        }, null);
      };
      exports.errorCodes = {
        DOMAIN_TOO_SHORT: "Domain name too short.",
        DOMAIN_TOO_LONG: "Domain name too long. It should be no more than 255 chars.",
        LABEL_STARTS_WITH_DASH: "Domain name label can not start with a dash.",
        LABEL_ENDS_WITH_DASH: "Domain name label can not end with a dash.",
        LABEL_TOO_LONG: "Domain name label should be at most 63 chars long.",
        LABEL_TOO_SHORT: "Domain name label should be at least 1 character long.",
        LABEL_INVALID_CHARS: "Domain name label can only contain alphanumeric characters or dashes."
      };
      internals.validate = function(input) {
        var ascii = Punycode.toASCII(input);
        if (ascii.length < 1) {
          return "DOMAIN_TOO_SHORT";
        }
        if (ascii.length > 255) {
          return "DOMAIN_TOO_LONG";
        }
        var labels = ascii.split(".");
        var label;
        for (var i = 0; i < labels.length; ++i) {
          label = labels[i];
          if (!label.length) {
            return "LABEL_TOO_SHORT";
          }
          if (label.length > 63) {
            return "LABEL_TOO_LONG";
          }
          if (label.charAt(0) === "-") {
            return "LABEL_STARTS_WITH_DASH";
          }
          if (label.charAt(label.length - 1) === "-") {
            return "LABEL_ENDS_WITH_DASH";
          }
          if (!/^[a-z0-9\-]+$/.test(label)) {
            return "LABEL_INVALID_CHARS";
          }
        }
      };
      exports.parse = function(input) {
        if (typeof input !== "string") {
          throw new TypeError("Domain name must be a string.");
        }
        var domain = input.slice(0).toLowerCase();
        if (domain.charAt(domain.length - 1) === ".") {
          domain = domain.slice(0, domain.length - 1);
        }
        var error3 = internals.validate(domain);
        if (error3) {
          return {
            input,
            error: {
              message: exports.errorCodes[error3],
              code: error3
            }
          };
        }
        var parsed = {
          input,
          tld: null,
          sld: null,
          domain: null,
          subdomain: null,
          listed: false
        };
        var domainParts = domain.split(".");
        if (domainParts[domainParts.length - 1] === "local") {
          return parsed;
        }
        var handlePunycode = function() {
          if (!/xn--/.test(domain)) {
            return parsed;
          }
          if (parsed.domain) {
            parsed.domain = Punycode.toASCII(parsed.domain);
          }
          if (parsed.subdomain) {
            parsed.subdomain = Punycode.toASCII(parsed.subdomain);
          }
          return parsed;
        };
        var rule = internals.findRule(domain);
        if (!rule) {
          if (domainParts.length < 2) {
            return parsed;
          }
          parsed.tld = domainParts.pop();
          parsed.sld = domainParts.pop();
          parsed.domain = [parsed.sld, parsed.tld].join(".");
          if (domainParts.length) {
            parsed.subdomain = domainParts.pop();
          }
          return handlePunycode();
        }
        parsed.listed = true;
        var tldParts = rule.suffix.split(".");
        var privateParts = domainParts.slice(0, domainParts.length - tldParts.length);
        if (rule.exception) {
          privateParts.push(tldParts.shift());
        }
        parsed.tld = tldParts.join(".");
        if (!privateParts.length) {
          return handlePunycode();
        }
        if (rule.wildcard) {
          tldParts.unshift(privateParts.pop());
          parsed.tld = tldParts.join(".");
        }
        if (!privateParts.length) {
          return handlePunycode();
        }
        parsed.sld = privateParts.pop();
        parsed.domain = [parsed.sld, parsed.tld].join(".");
        if (privateParts.length) {
          parsed.subdomain = privateParts.join(".");
        }
        return handlePunycode();
      };
      exports.get = function(domain) {
        if (!domain) {
          return null;
        }
        return exports.parse(domain).domain || null;
      };
      exports.isValid = function(domain) {
        var parsed = exports.parse(domain);
        return Boolean(parsed.domain && parsed.listed);
      };
    }
  });
  var require_pubsuffix_psl = __commonJS3({
    "node_modules/tough-cookie/lib/pubsuffix-psl.js"(exports) {
      "use strict";
      var psl = require_psl();
      var SPECIAL_USE_DOMAINS = [
        "local",
        "example",
        "invalid",
        "localhost",
        "test"
      ];
      var SPECIAL_TREATMENT_DOMAINS = ["localhost", "invalid"];
      function getPublicSuffix(domain, options = {}) {
        const domainParts = domain.split(".");
        const topLevelDomain = domainParts[domainParts.length - 1];
        const allowSpecialUseDomain = !!options.allowSpecialUseDomain;
        const ignoreError = !!options.ignoreError;
        if (allowSpecialUseDomain && SPECIAL_USE_DOMAINS.includes(topLevelDomain)) {
          if (domainParts.length > 1) {
            const secondLevelDomain = domainParts[domainParts.length - 2];
            return `${secondLevelDomain}.${topLevelDomain}`;
          } else if (SPECIAL_TREATMENT_DOMAINS.includes(topLevelDomain)) {
            return `${topLevelDomain}`;
          }
        }
        if (!ignoreError && SPECIAL_USE_DOMAINS.includes(topLevelDomain)) {
          throw new Error(
            `Cookie has domain set to the public suffix "${topLevelDomain}" which is a special use domain. To allow this, configure your CookieJar with {allowSpecialUseDomain:true, rejectPublicSuffixes: false}.`
          );
        }
        return psl.get(domain);
      }
      exports.getPublicSuffix = getPublicSuffix;
    }
  });
  var require_store = __commonJS3({
    "node_modules/tough-cookie/lib/store.js"(exports) {
      "use strict";
      var Store2 = class {
        constructor() {
          this.synchronous = false;
        }
        findCookie(domain, path, key, cb) {
          throw new Error("findCookie is not implemented");
        }
        findCookies(domain, path, allowSpecialUseDomain, cb) {
          throw new Error("findCookies is not implemented");
        }
        putCookie(cookie, cb) {
          throw new Error("putCookie is not implemented");
        }
        updateCookie(oldCookie, newCookie, cb) {
          throw new Error("updateCookie is not implemented");
        }
        removeCookie(domain, path, key, cb) {
          throw new Error("removeCookie is not implemented");
        }
        removeCookies(domain, path, cb) {
          throw new Error("removeCookies is not implemented");
        }
        removeAllCookies(cb) {
          throw new Error("removeAllCookies is not implemented");
        }
        getAllCookies(cb) {
          throw new Error(
            "getAllCookies is not implemented (therefore jar cannot be serialized)"
          );
        }
      };
      exports.Store = Store2;
    }
  });
  var require_universalify = __commonJS3({
    "node_modules/universalify/index.js"(exports) {
      "use strict";
      exports.fromCallback = function(fn) {
        return Object.defineProperty(function() {
          if (typeof arguments[arguments.length - 1] === "function") fn.apply(this, arguments);
          else {
            return new Promise((resolve, reject) => {
              arguments[arguments.length] = (err, res) => {
                if (err) return reject(err);
                resolve(res);
              };
              arguments.length++;
              fn.apply(this, arguments);
            });
          }
        }, "name", { value: fn.name });
      };
      exports.fromPromise = function(fn) {
        return Object.defineProperty(function() {
          const cb = arguments[arguments.length - 1];
          if (typeof cb !== "function") return fn.apply(this, arguments);
          else {
            delete arguments[arguments.length - 1];
            arguments.length--;
            fn.apply(this, arguments).then((r) => cb(null, r), cb);
          }
        }, "name", { value: fn.name });
      };
    }
  });
  var require_permuteDomain = __commonJS3({
    "node_modules/tough-cookie/lib/permuteDomain.js"(exports) {
      "use strict";
      var pubsuffix = require_pubsuffix_psl();
      function permuteDomain(domain, allowSpecialUseDomain) {
        const pubSuf = pubsuffix.getPublicSuffix(domain, {
          allowSpecialUseDomain
        });
        if (!pubSuf) {
          return null;
        }
        if (pubSuf == domain) {
          return [domain];
        }
        if (domain.slice(-1) == ".") {
          domain = domain.slice(0, -1);
        }
        const prefix = domain.slice(0, -(pubSuf.length + 1));
        const parts = prefix.split(".").reverse();
        let cur = pubSuf;
        const permutations = [cur];
        while (parts.length) {
          cur = `${parts.shift()}.${cur}`;
          permutations.push(cur);
        }
        return permutations;
      }
      exports.permuteDomain = permuteDomain;
    }
  });
  var require_pathMatch = __commonJS3({
    "node_modules/tough-cookie/lib/pathMatch.js"(exports) {
      "use strict";
      function pathMatch2(reqPath, cookiePath) {
        if (cookiePath === reqPath) {
          return true;
        }
        const idx = reqPath.indexOf(cookiePath);
        if (idx === 0) {
          if (cookiePath.substr(-1) === "/") {
            return true;
          }
          if (reqPath.substr(cookiePath.length, 1) === "/") {
            return true;
          }
        }
        return false;
      }
      exports.pathMatch = pathMatch2;
    }
  });
  var require_utilHelper = __commonJS3({
    "node_modules/tough-cookie/lib/utilHelper.js"(exports) {
      function requireUtil() {
        try {
          return __require2("util");
        } catch (e) {
          return null;
        }
      }
      function lookupCustomInspectSymbol() {
        return Symbol.for("nodejs.util.inspect.custom");
      }
      function tryReadingCustomSymbolFromUtilInspect(options) {
        const _requireUtil = options.requireUtil || requireUtil;
        const util = _requireUtil();
        return util ? util.inspect.custom : null;
      }
      exports.getUtilInspect = function getUtilInspect(fallback, options = {}) {
        const _requireUtil = options.requireUtil || requireUtil;
        const util = _requireUtil();
        return function inspect2(value, showHidden, depth) {
          return util ? util.inspect(value, showHidden, depth) : fallback(value);
        };
      };
      exports.getCustomInspectSymbol = function getCustomInspectSymbol(options = {}) {
        const _lookupCustomInspectSymbol = options.lookupCustomInspectSymbol || lookupCustomInspectSymbol;
        return _lookupCustomInspectSymbol() || tryReadingCustomSymbolFromUtilInspect(options);
      };
    }
  });
  var require_memstore = __commonJS3({
    "node_modules/tough-cookie/lib/memstore.js"(exports) {
      "use strict";
      var { fromCallback } = require_universalify();
      var Store2 = require_store().Store;
      var permuteDomain = require_permuteDomain().permuteDomain;
      var pathMatch2 = require_pathMatch().pathMatch;
      var { getCustomInspectSymbol, getUtilInspect } = require_utilHelper();
      var MemoryCookieStore2 = class extends Store2 {
        constructor() {
          super();
          this.synchronous = true;
          this.idx = /* @__PURE__ */ Object.create(null);
          const customInspectSymbol = getCustomInspectSymbol();
          if (customInspectSymbol) {
            this[customInspectSymbol] = this.inspect;
          }
        }
        inspect() {
          const util = { inspect: getUtilInspect(inspectFallback) };
          return `{ idx: ${util.inspect(this.idx, false, 2)} }`;
        }
        findCookie(domain, path, key, cb) {
          if (!this.idx[domain]) {
            return cb(null, void 0);
          }
          if (!this.idx[domain][path]) {
            return cb(null, void 0);
          }
          return cb(null, this.idx[domain][path][key] || null);
        }
        findCookies(domain, path, allowSpecialUseDomain, cb) {
          const results = [];
          if (typeof allowSpecialUseDomain === "function") {
            cb = allowSpecialUseDomain;
            allowSpecialUseDomain = true;
          }
          if (!domain) {
            return cb(null, []);
          }
          let pathMatcher;
          if (!path) {
            pathMatcher = function matchAll(domainIndex) {
              for (const curPath in domainIndex) {
                const pathIndex = domainIndex[curPath];
                for (const key in pathIndex) {
                  results.push(pathIndex[key]);
                }
              }
            };
          } else {
            pathMatcher = function matchRFC(domainIndex) {
              Object.keys(domainIndex).forEach((cookiePath) => {
                if (pathMatch2(path, cookiePath)) {
                  const pathIndex = domainIndex[cookiePath];
                  for (const key in pathIndex) {
                    results.push(pathIndex[key]);
                  }
                }
              });
            };
          }
          const domains = permuteDomain(domain, allowSpecialUseDomain) || [domain];
          const idx = this.idx;
          domains.forEach((curDomain) => {
            const domainIndex = idx[curDomain];
            if (!domainIndex) {
              return;
            }
            pathMatcher(domainIndex);
          });
          cb(null, results);
        }
        putCookie(cookie, cb) {
          if (!this.idx[cookie.domain]) {
            this.idx[cookie.domain] = /* @__PURE__ */ Object.create(null);
          }
          if (!this.idx[cookie.domain][cookie.path]) {
            this.idx[cookie.domain][cookie.path] = /* @__PURE__ */ Object.create(null);
          }
          this.idx[cookie.domain][cookie.path][cookie.key] = cookie;
          cb(null);
        }
        updateCookie(oldCookie, newCookie, cb) {
          this.putCookie(newCookie, cb);
        }
        removeCookie(domain, path, key, cb) {
          if (this.idx[domain] && this.idx[domain][path] && this.idx[domain][path][key]) {
            delete this.idx[domain][path][key];
          }
          cb(null);
        }
        removeCookies(domain, path, cb) {
          if (this.idx[domain]) {
            if (path) {
              delete this.idx[domain][path];
            } else {
              delete this.idx[domain];
            }
          }
          return cb(null);
        }
        removeAllCookies(cb) {
          this.idx = /* @__PURE__ */ Object.create(null);
          return cb(null);
        }
        getAllCookies(cb) {
          const cookies = [];
          const idx = this.idx;
          const domains = Object.keys(idx);
          domains.forEach((domain) => {
            const paths = Object.keys(idx[domain]);
            paths.forEach((path) => {
              const keys = Object.keys(idx[domain][path]);
              keys.forEach((key) => {
                if (key !== null) {
                  cookies.push(idx[domain][path][key]);
                }
              });
            });
          });
          cookies.sort((a, b) => {
            return (a.creationIndex || 0) - (b.creationIndex || 0);
          });
          cb(null, cookies);
        }
      };
      [
        "findCookie",
        "findCookies",
        "putCookie",
        "updateCookie",
        "removeCookie",
        "removeCookies",
        "removeAllCookies",
        "getAllCookies"
      ].forEach((name) => {
        MemoryCookieStore2.prototype[name] = fromCallback(
          MemoryCookieStore2.prototype[name]
        );
      });
      exports.MemoryCookieStore = MemoryCookieStore2;
      function inspectFallback(val) {
        const domains = Object.keys(val);
        if (domains.length === 0) {
          return "[Object: null prototype] {}";
        }
        let result = "[Object: null prototype] {\n";
        Object.keys(val).forEach((domain, i) => {
          result += formatDomain(domain, val[domain]);
          if (i < domains.length - 1) {
            result += ",";
          }
          result += "\n";
        });
        result += "}";
        return result;
      }
      function formatDomain(domainName, domainValue) {
        const indent2 = "  ";
        let result = `${indent2}'${domainName}': [Object: null prototype] {
`;
        Object.keys(domainValue).forEach((path, i, paths) => {
          result += formatPath(path, domainValue[path]);
          if (i < paths.length - 1) {
            result += ",";
          }
          result += "\n";
        });
        result += `${indent2}}`;
        return result;
      }
      function formatPath(pathName, pathValue) {
        const indent2 = "    ";
        let result = `${indent2}'${pathName}': [Object: null prototype] {
`;
        Object.keys(pathValue).forEach((cookieName, i, cookieNames) => {
          const cookie = pathValue[cookieName];
          result += `      ${cookieName}: ${cookie.inspect()}`;
          if (i < cookieNames.length - 1) {
            result += ",";
          }
          result += "\n";
        });
        result += `${indent2}}`;
        return result;
      }
      exports.inspectFallback = inspectFallback;
    }
  });
  var require_validators = __commonJS3({
    "node_modules/tough-cookie/lib/validators.js"(exports) {
      "use strict";
      var toString = Object.prototype.toString;
      function isFunction(data) {
        return typeof data === "function";
      }
      function isNonEmptyString(data) {
        return isString(data) && data !== "";
      }
      function isDate(data) {
        return isInstanceStrict(data, Date) && isInteger(data.getTime());
      }
      function isEmptyString(data) {
        return data === "" || data instanceof String && data.toString() === "";
      }
      function isString(data) {
        return typeof data === "string" || data instanceof String;
      }
      function isObject2(data) {
        return toString.call(data) === "[object Object]";
      }
      function isInstanceStrict(data, prototype) {
        try {
          return data instanceof prototype;
        } catch (error3) {
          return false;
        }
      }
      function isUrlStringOrObject(data) {
        return isNonEmptyString(data) || isObject2(data) && "hostname" in data && "pathname" in data && "protocol" in data || isInstanceStrict(data, URL);
      }
      function isInteger(data) {
        return typeof data === "number" && data % 1 === 0;
      }
      function validate2(bool, cb, options) {
        if (!isFunction(cb)) {
          options = cb;
          cb = null;
        }
        if (!isObject2(options)) options = { Error: "Failed Check" };
        if (!bool) {
          if (cb) {
            cb(new ParameterError(options));
          } else {
            throw new ParameterError(options);
          }
        }
      }
      var ParameterError = class extends Error {
        constructor(...params) {
          super(...params);
        }
      };
      exports.ParameterError = ParameterError;
      exports.isFunction = isFunction;
      exports.isNonEmptyString = isNonEmptyString;
      exports.isDate = isDate;
      exports.isEmptyString = isEmptyString;
      exports.isString = isString;
      exports.isObject = isObject2;
      exports.isUrlStringOrObject = isUrlStringOrObject;
      exports.validate = validate2;
    }
  });
  var require_version = __commonJS3({
    "node_modules/tough-cookie/lib/version.js"(exports, module) {
      module.exports = "4.1.4";
    }
  });
  var require_cookie2 = __commonJS3({
    "node_modules/tough-cookie/lib/cookie.js"(exports) {
      "use strict";
      var punycode = require_punycode();
      var urlParse = require_url_parse();
      var pubsuffix = require_pubsuffix_psl();
      var Store2 = require_store().Store;
      var MemoryCookieStore2 = require_memstore().MemoryCookieStore;
      var pathMatch2 = require_pathMatch().pathMatch;
      var validators = require_validators();
      var VERSION = require_version();
      var { fromCallback } = require_universalify();
      var { getCustomInspectSymbol } = require_utilHelper();
      var COOKIE_OCTETS = /^[\x21\x23-\x2B\x2D-\x3A\x3C-\x5B\x5D-\x7E]+$/;
      var CONTROL_CHARS = /[\x00-\x1F]/;
      var TERMINATORS = ["\n", "\r", "\0"];
      var PATH_VALUE = /[\x20-\x3A\x3C-\x7E]+/;
      var DATE_DELIM = /[\x09\x20-\x2F\x3B-\x40\x5B-\x60\x7B-\x7E]/;
      var MONTH_TO_NUM = {
        jan: 0,
        feb: 1,
        mar: 2,
        apr: 3,
        may: 4,
        jun: 5,
        jul: 6,
        aug: 7,
        sep: 8,
        oct: 9,
        nov: 10,
        dec: 11
      };
      var MAX_TIME = 2147483647e3;
      var MIN_TIME = 0;
      var SAME_SITE_CONTEXT_VAL_ERR = 'Invalid sameSiteContext option for getCookies(); expected one of "strict", "lax", or "none"';
      function checkSameSiteContext(value) {
        validators.validate(validators.isNonEmptyString(value), value);
        const context = String(value).toLowerCase();
        if (context === "none" || context === "lax" || context === "strict") {
          return context;
        } else {
          return null;
        }
      }
      var PrefixSecurityEnum = Object.freeze({
        SILENT: "silent",
        STRICT: "strict",
        DISABLED: "unsafe-disabled"
      });
      var IP_REGEX_LOWERCASE = /(?:^(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]\d|\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]\d|\d)){3}$)|(?:^(?:(?:[a-f\d]{1,4}:){7}(?:[a-f\d]{1,4}|:)|(?:[a-f\d]{1,4}:){6}(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]\d|\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]\d|\d)){3}|:[a-f\d]{1,4}|:)|(?:[a-f\d]{1,4}:){5}(?::(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]\d|\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]\d|\d)){3}|(?::[a-f\d]{1,4}){1,2}|:)|(?:[a-f\d]{1,4}:){4}(?:(?::[a-f\d]{1,4}){0,1}:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]\d|\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]\d|\d)){3}|(?::[a-f\d]{1,4}){1,3}|:)|(?:[a-f\d]{1,4}:){3}(?:(?::[a-f\d]{1,4}){0,2}:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]\d|\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]\d|\d)){3}|(?::[a-f\d]{1,4}){1,4}|:)|(?:[a-f\d]{1,4}:){2}(?:(?::[a-f\d]{1,4}){0,3}:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]\d|\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]\d|\d)){3}|(?::[a-f\d]{1,4}){1,5}|:)|(?:[a-f\d]{1,4}:){1}(?:(?::[a-f\d]{1,4}){0,4}:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]\d|\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]\d|\d)){3}|(?::[a-f\d]{1,4}){1,6}|:)|(?::(?:(?::[a-f\d]{1,4}){0,5}:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]\d|\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]\d|\d)){3}|(?::[a-f\d]{1,4}){1,7}|:)))$)/;
      var IP_V6_REGEX = `
\\[?(?:
(?:[a-fA-F\\d]{1,4}:){7}(?:[a-fA-F\\d]{1,4}|:)|
(?:[a-fA-F\\d]{1,4}:){6}(?:(?:25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]\\d|\\d)(?:\\.(?:25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]\\d|\\d)){3}|:[a-fA-F\\d]{1,4}|:)|
(?:[a-fA-F\\d]{1,4}:){5}(?::(?:25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]\\d|\\d)(?:\\.(?:25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]\\d|\\d)){3}|(?::[a-fA-F\\d]{1,4}){1,2}|:)|
(?:[a-fA-F\\d]{1,4}:){4}(?:(?::[a-fA-F\\d]{1,4}){0,1}:(?:25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]\\d|\\d)(?:\\.(?:25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]\\d|\\d)){3}|(?::[a-fA-F\\d]{1,4}){1,3}|:)|
(?:[a-fA-F\\d]{1,4}:){3}(?:(?::[a-fA-F\\d]{1,4}){0,2}:(?:25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]\\d|\\d)(?:\\.(?:25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]\\d|\\d)){3}|(?::[a-fA-F\\d]{1,4}){1,4}|:)|
(?:[a-fA-F\\d]{1,4}:){2}(?:(?::[a-fA-F\\d]{1,4}){0,3}:(?:25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]\\d|\\d)(?:\\.(?:25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]\\d|\\d)){3}|(?::[a-fA-F\\d]{1,4}){1,5}|:)|
(?:[a-fA-F\\d]{1,4}:){1}(?:(?::[a-fA-F\\d]{1,4}){0,4}:(?:25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]\\d|\\d)(?:\\.(?:25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]\\d|\\d)){3}|(?::[a-fA-F\\d]{1,4}){1,6}|:)|
(?::(?:(?::[a-fA-F\\d]{1,4}){0,5}:(?:25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]\\d|\\d)(?:\\.(?:25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]\\d|\\d)){3}|(?::[a-fA-F\\d]{1,4}){1,7}|:))
)(?:%[0-9a-zA-Z]{1,})?\\]?
`.replace(/\s*\/\/.*$/gm, "").replace(/\n/g, "").trim();
      var IP_V6_REGEX_OBJECT = new RegExp(`^${IP_V6_REGEX}$`);
      function parseDigits(token, minDigits, maxDigits, trailingOK) {
        let count = 0;
        while (count < token.length) {
          const c = token.charCodeAt(count);
          if (c <= 47 || c >= 58) {
            break;
          }
          count++;
        }
        if (count < minDigits || count > maxDigits) {
          return null;
        }
        if (!trailingOK && count != token.length) {
          return null;
        }
        return parseInt(token.substr(0, count), 10);
      }
      function parseTime(token) {
        const parts = token.split(":");
        const result = [0, 0, 0];
        if (parts.length !== 3) {
          return null;
        }
        for (let i = 0; i < 3; i++) {
          const trailingOK = i == 2;
          const num = parseDigits(parts[i], 1, 2, trailingOK);
          if (num === null) {
            return null;
          }
          result[i] = num;
        }
        return result;
      }
      function parseMonth(token) {
        token = String(token).substr(0, 3).toLowerCase();
        const num = MONTH_TO_NUM[token];
        return num >= 0 ? num : null;
      }
      function parseDate(str) {
        if (!str) {
          return;
        }
        const tokens = str.split(DATE_DELIM);
        if (!tokens) {
          return;
        }
        let hour = null;
        let minute = null;
        let second = null;
        let dayOfMonth = null;
        let month = null;
        let year = null;
        for (let i = 0; i < tokens.length; i++) {
          const token = tokens[i].trim();
          if (!token.length) {
            continue;
          }
          let result;
          if (second === null) {
            result = parseTime(token);
            if (result) {
              hour = result[0];
              minute = result[1];
              second = result[2];
              continue;
            }
          }
          if (dayOfMonth === null) {
            result = parseDigits(token, 1, 2, true);
            if (result !== null) {
              dayOfMonth = result;
              continue;
            }
          }
          if (month === null) {
            result = parseMonth(token);
            if (result !== null) {
              month = result;
              continue;
            }
          }
          if (year === null) {
            result = parseDigits(token, 2, 4, true);
            if (result !== null) {
              year = result;
              if (year >= 70 && year <= 99) {
                year += 1900;
              } else if (year >= 0 && year <= 69) {
                year += 2e3;
              }
            }
          }
        }
        if (dayOfMonth === null || month === null || year === null || second === null || dayOfMonth < 1 || dayOfMonth > 31 || year < 1601 || hour > 23 || minute > 59 || second > 59) {
          return;
        }
        return new Date(Date.UTC(year, month, dayOfMonth, hour, minute, second));
      }
      function formatDate(date) {
        validators.validate(validators.isDate(date), date);
        return date.toUTCString();
      }
      function canonicalDomain(str) {
        if (str == null) {
          return null;
        }
        str = str.trim().replace(/^\./, "");
        if (IP_V6_REGEX_OBJECT.test(str)) {
          str = str.replace("[", "").replace("]", "");
        }
        if (punycode && /[^\u0001-\u007f]/.test(str)) {
          str = punycode.toASCII(str);
        }
        return str.toLowerCase();
      }
      function domainMatch2(str, domStr, canonicalize) {
        if (str == null || domStr == null) {
          return null;
        }
        if (canonicalize !== false) {
          str = canonicalDomain(str);
          domStr = canonicalDomain(domStr);
        }
        if (str == domStr) {
          return true;
        }
        const idx = str.lastIndexOf(domStr);
        if (idx <= 0) {
          return false;
        }
        if (str.length !== domStr.length + idx) {
          return false;
        }
        if (str.substr(idx - 1, 1) !== ".") {
          return false;
        }
        if (IP_REGEX_LOWERCASE.test(str)) {
          return false;
        }
        return true;
      }
      function defaultPath(path) {
        if (!path || path.substr(0, 1) !== "/") {
          return "/";
        }
        if (path === "/") {
          return path;
        }
        const rightSlash = path.lastIndexOf("/");
        if (rightSlash === 0) {
          return "/";
        }
        return path.slice(0, rightSlash);
      }
      function trimTerminator(str) {
        if (validators.isEmptyString(str)) return str;
        for (let t = 0; t < TERMINATORS.length; t++) {
          const terminatorIdx = str.indexOf(TERMINATORS[t]);
          if (terminatorIdx !== -1) {
            str = str.substr(0, terminatorIdx);
          }
        }
        return str;
      }
      function parseCookiePair(cookiePair, looseMode) {
        cookiePair = trimTerminator(cookiePair);
        validators.validate(validators.isString(cookiePair), cookiePair);
        let firstEq = cookiePair.indexOf("=");
        if (looseMode) {
          if (firstEq === 0) {
            cookiePair = cookiePair.substr(1);
            firstEq = cookiePair.indexOf("=");
          }
        } else {
          if (firstEq <= 0) {
            return;
          }
        }
        let cookieName, cookieValue;
        if (firstEq <= 0) {
          cookieName = "";
          cookieValue = cookiePair.trim();
        } else {
          cookieName = cookiePair.substr(0, firstEq).trim();
          cookieValue = cookiePair.substr(firstEq + 1).trim();
        }
        if (CONTROL_CHARS.test(cookieName) || CONTROL_CHARS.test(cookieValue)) {
          return;
        }
        const c = new Cookie2();
        c.key = cookieName;
        c.value = cookieValue;
        return c;
      }
      function parse3(str, options) {
        if (!options || typeof options !== "object") {
          options = {};
        }
        if (validators.isEmptyString(str) || !validators.isString(str)) {
          return null;
        }
        str = str.trim();
        const firstSemi = str.indexOf(";");
        const cookiePair = firstSemi === -1 ? str : str.substr(0, firstSemi);
        const c = parseCookiePair(cookiePair, !!options.loose);
        if (!c) {
          return;
        }
        if (firstSemi === -1) {
          return c;
        }
        const unparsed = str.slice(firstSemi + 1).trim();
        if (unparsed.length === 0) {
          return c;
        }
        const cookie_avs = unparsed.split(";");
        while (cookie_avs.length) {
          const av = cookie_avs.shift().trim();
          if (av.length === 0) {
            continue;
          }
          const av_sep = av.indexOf("=");
          let av_key, av_value;
          if (av_sep === -1) {
            av_key = av;
            av_value = null;
          } else {
            av_key = av.substr(0, av_sep);
            av_value = av.substr(av_sep + 1);
          }
          av_key = av_key.trim().toLowerCase();
          if (av_value) {
            av_value = av_value.trim();
          }
          switch (av_key) {
            case "expires":
              if (av_value) {
                const exp = parseDate(av_value);
                if (exp) {
                  c.expires = exp;
                }
              }
              break;
            case "max-age":
              if (av_value) {
                if (/^-?[0-9]+$/.test(av_value)) {
                  const delta = parseInt(av_value, 10);
                  c.setMaxAge(delta);
                }
              }
              break;
            case "domain":
              if (av_value) {
                const domain = av_value.trim().replace(/^\./, "");
                if (domain) {
                  c.domain = domain.toLowerCase();
                }
              }
              break;
            case "path":
              c.path = av_value && av_value[0] === "/" ? av_value : null;
              break;
            case "secure":
              c.secure = true;
              break;
            case "httponly":
              c.httpOnly = true;
              break;
            case "samesite":
              const enforcement = av_value ? av_value.toLowerCase() : "";
              switch (enforcement) {
                case "strict":
                  c.sameSite = "strict";
                  break;
                case "lax":
                  c.sameSite = "lax";
                  break;
                case "none":
                  c.sameSite = "none";
                  break;
                default:
                  c.sameSite = void 0;
                  break;
              }
              break;
            default:
              c.extensions = c.extensions || [];
              c.extensions.push(av);
              break;
          }
        }
        return c;
      }
      function isSecurePrefixConditionMet(cookie) {
        validators.validate(validators.isObject(cookie), cookie);
        return !cookie.key.startsWith("__Secure-") || cookie.secure;
      }
      function isHostPrefixConditionMet(cookie) {
        validators.validate(validators.isObject(cookie));
        return !cookie.key.startsWith("__Host-") || cookie.secure && cookie.hostOnly && cookie.path != null && cookie.path === "/";
      }
      function jsonParse2(str) {
        let obj;
        try {
          obj = JSON.parse(str);
        } catch (e) {
          return e;
        }
        return obj;
      }
      function fromJSON(str) {
        if (!str || validators.isEmptyString(str)) {
          return null;
        }
        let obj;
        if (typeof str === "string") {
          obj = jsonParse2(str);
          if (obj instanceof Error) {
            return null;
          }
        } else {
          obj = str;
        }
        const c = new Cookie2();
        for (let i = 0; i < Cookie2.serializableProperties.length; i++) {
          const prop = Cookie2.serializableProperties[i];
          if (obj[prop] === void 0 || obj[prop] === cookieDefaults[prop]) {
            continue;
          }
          if (prop === "expires" || prop === "creation" || prop === "lastAccessed") {
            if (obj[prop] === null) {
              c[prop] = null;
            } else {
              c[prop] = obj[prop] == "Infinity" ? "Infinity" : new Date(obj[prop]);
            }
          } else {
            c[prop] = obj[prop];
          }
        }
        return c;
      }
      function cookieCompare(a, b) {
        validators.validate(validators.isObject(a), a);
        validators.validate(validators.isObject(b), b);
        let cmp = 0;
        const aPathLen = a.path ? a.path.length : 0;
        const bPathLen = b.path ? b.path.length : 0;
        cmp = bPathLen - aPathLen;
        if (cmp !== 0) {
          return cmp;
        }
        const aTime = a.creation ? a.creation.getTime() : MAX_TIME;
        const bTime = b.creation ? b.creation.getTime() : MAX_TIME;
        cmp = aTime - bTime;
        if (cmp !== 0) {
          return cmp;
        }
        cmp = a.creationIndex - b.creationIndex;
        return cmp;
      }
      function permutePath(path) {
        validators.validate(validators.isString(path));
        if (path === "/") {
          return ["/"];
        }
        const permutations = [path];
        while (path.length > 1) {
          const lindex = path.lastIndexOf("/");
          if (lindex === 0) {
            break;
          }
          path = path.substr(0, lindex);
          permutations.push(path);
        }
        permutations.push("/");
        return permutations;
      }
      function getCookieContext(url) {
        if (url instanceof Object) {
          return url;
        }
        try {
          url = decodeURI(url);
        } catch (err) {
        }
        return urlParse(url);
      }
      var cookieDefaults = {
        // the order in which the RFC has them:
        key: "",
        value: "",
        expires: "Infinity",
        maxAge: null,
        domain: null,
        path: null,
        secure: false,
        httpOnly: false,
        extensions: null,
        // set by the CookieJar:
        hostOnly: null,
        pathIsDefault: null,
        creation: null,
        lastAccessed: null,
        sameSite: void 0
      };
      var Cookie2 = class _Cookie {
        constructor(options = {}) {
          const customInspectSymbol = getCustomInspectSymbol();
          if (customInspectSymbol) {
            this[customInspectSymbol] = this.inspect;
          }
          Object.assign(this, cookieDefaults, options);
          this.creation = this.creation || /* @__PURE__ */ new Date();
          Object.defineProperty(this, "creationIndex", {
            configurable: false,
            enumerable: false,
            // important for assert.deepEqual checks
            writable: true,
            value: ++_Cookie.cookiesCreated
          });
        }
        inspect() {
          const now = Date.now();
          const hostOnly = this.hostOnly != null ? this.hostOnly : "?";
          const createAge = this.creation ? `${now - this.creation.getTime()}ms` : "?";
          const accessAge = this.lastAccessed ? `${now - this.lastAccessed.getTime()}ms` : "?";
          return `Cookie="${this.toString()}; hostOnly=${hostOnly}; aAge=${accessAge}; cAge=${createAge}"`;
        }
        toJSON() {
          const obj = {};
          for (const prop of _Cookie.serializableProperties) {
            if (this[prop] === cookieDefaults[prop]) {
              continue;
            }
            if (prop === "expires" || prop === "creation" || prop === "lastAccessed") {
              if (this[prop] === null) {
                obj[prop] = null;
              } else {
                obj[prop] = this[prop] == "Infinity" ? "Infinity" : this[prop].toISOString();
              }
            } else if (prop === "maxAge") {
              if (this[prop] !== null) {
                obj[prop] = this[prop] == Infinity || this[prop] == -Infinity ? this[prop].toString() : this[prop];
              }
            } else {
              if (this[prop] !== cookieDefaults[prop]) {
                obj[prop] = this[prop];
              }
            }
          }
          return obj;
        }
        clone() {
          return fromJSON(this.toJSON());
        }
        validate() {
          if (!COOKIE_OCTETS.test(this.value)) {
            return false;
          }
          if (this.expires != Infinity && !(this.expires instanceof Date) && !parseDate(this.expires)) {
            return false;
          }
          if (this.maxAge != null && this.maxAge <= 0) {
            return false;
          }
          if (this.path != null && !PATH_VALUE.test(this.path)) {
            return false;
          }
          const cdomain = this.cdomain();
          if (cdomain) {
            if (cdomain.match(/\.$/)) {
              return false;
            }
            const suffix = pubsuffix.getPublicSuffix(cdomain);
            if (suffix == null) {
              return false;
            }
          }
          return true;
        }
        setExpires(exp) {
          if (exp instanceof Date) {
            this.expires = exp;
          } else {
            this.expires = parseDate(exp) || "Infinity";
          }
        }
        setMaxAge(age) {
          if (age === Infinity || age === -Infinity) {
            this.maxAge = age.toString();
          } else {
            this.maxAge = age;
          }
        }
        cookieString() {
          let val = this.value;
          if (val == null) {
            val = "";
          }
          if (this.key === "") {
            return val;
          }
          return `${this.key}=${val}`;
        }
        // gives Set-Cookie header format
        toString() {
          let str = this.cookieString();
          if (this.expires != Infinity) {
            if (this.expires instanceof Date) {
              str += `; Expires=${formatDate(this.expires)}`;
            } else {
              str += `; Expires=${this.expires}`;
            }
          }
          if (this.maxAge != null && this.maxAge != Infinity) {
            str += `; Max-Age=${this.maxAge}`;
          }
          if (this.domain && !this.hostOnly) {
            str += `; Domain=${this.domain}`;
          }
          if (this.path) {
            str += `; Path=${this.path}`;
          }
          if (this.secure) {
            str += "; Secure";
          }
          if (this.httpOnly) {
            str += "; HttpOnly";
          }
          if (this.sameSite && this.sameSite !== "none") {
            const ssCanon = _Cookie.sameSiteCanonical[this.sameSite.toLowerCase()];
            str += `; SameSite=${ssCanon ? ssCanon : this.sameSite}`;
          }
          if (this.extensions) {
            this.extensions.forEach((ext) => {
              str += `; ${ext}`;
            });
          }
          return str;
        }
        // TTL() partially replaces the "expiry-time" parts of S5.3 step 3 (setCookie()
        // elsewhere)
        // S5.3 says to give the "latest representable date" for which we use Infinity
        // For "expired" we use 0
        TTL(now) {
          if (this.maxAge != null) {
            return this.maxAge <= 0 ? 0 : this.maxAge * 1e3;
          }
          let expires = this.expires;
          if (expires != Infinity) {
            if (!(expires instanceof Date)) {
              expires = parseDate(expires) || Infinity;
            }
            if (expires == Infinity) {
              return Infinity;
            }
            return expires.getTime() - (now || Date.now());
          }
          return Infinity;
        }
        // expiryTime() replaces the "expiry-time" parts of S5.3 step 3 (setCookie()
        // elsewhere)
        expiryTime(now) {
          if (this.maxAge != null) {
            const relativeTo = now || this.creation || /* @__PURE__ */ new Date();
            const age = this.maxAge <= 0 ? -Infinity : this.maxAge * 1e3;
            return relativeTo.getTime() + age;
          }
          if (this.expires == Infinity) {
            return Infinity;
          }
          return this.expires.getTime();
        }
        // expiryDate() replaces the "expiry-time" parts of S5.3 step 3 (setCookie()
        // elsewhere), except it returns a Date
        expiryDate(now) {
          const millisec = this.expiryTime(now);
          if (millisec == Infinity) {
            return new Date(MAX_TIME);
          } else if (millisec == -Infinity) {
            return new Date(MIN_TIME);
          } else {
            return new Date(millisec);
          }
        }
        // This replaces the "persistent-flag" parts of S5.3 step 3
        isPersistent() {
          return this.maxAge != null || this.expires != Infinity;
        }
        // Mostly S5.1.2 and S5.2.3:
        canonicalizedDomain() {
          if (this.domain == null) {
            return null;
          }
          return canonicalDomain(this.domain);
        }
        cdomain() {
          return this.canonicalizedDomain();
        }
      };
      Cookie2.cookiesCreated = 0;
      Cookie2.parse = parse3;
      Cookie2.fromJSON = fromJSON;
      Cookie2.serializableProperties = Object.keys(cookieDefaults);
      Cookie2.sameSiteLevel = {
        strict: 3,
        lax: 2,
        none: 1
      };
      Cookie2.sameSiteCanonical = {
        strict: "Strict",
        lax: "Lax"
      };
      function getNormalizedPrefixSecurity(prefixSecurity) {
        if (prefixSecurity != null) {
          const normalizedPrefixSecurity = prefixSecurity.toLowerCase();
          switch (normalizedPrefixSecurity) {
            case PrefixSecurityEnum.STRICT:
            case PrefixSecurityEnum.SILENT:
            case PrefixSecurityEnum.DISABLED:
              return normalizedPrefixSecurity;
          }
        }
        return PrefixSecurityEnum.SILENT;
      }
      var CookieJar2 = class _CookieJar {
        constructor(store2, options = { rejectPublicSuffixes: true }) {
          if (typeof options === "boolean") {
            options = { rejectPublicSuffixes: options };
          }
          validators.validate(validators.isObject(options), options);
          this.rejectPublicSuffixes = options.rejectPublicSuffixes;
          this.enableLooseMode = !!options.looseMode;
          this.allowSpecialUseDomain = typeof options.allowSpecialUseDomain === "boolean" ? options.allowSpecialUseDomain : true;
          this.store = store2 || new MemoryCookieStore2();
          this.prefixSecurity = getNormalizedPrefixSecurity(options.prefixSecurity);
          this._cloneSync = syncWrap("clone");
          this._importCookiesSync = syncWrap("_importCookies");
          this.getCookiesSync = syncWrap("getCookies");
          this.getCookieStringSync = syncWrap("getCookieString");
          this.getSetCookieStringsSync = syncWrap("getSetCookieStrings");
          this.removeAllCookiesSync = syncWrap("removeAllCookies");
          this.setCookieSync = syncWrap("setCookie");
          this.serializeSync = syncWrap("serialize");
        }
        setCookie(cookie, url, options, cb) {
          validators.validate(validators.isUrlStringOrObject(url), cb, options);
          let err;
          if (validators.isFunction(url)) {
            cb = url;
            return cb(new Error("No URL was specified"));
          }
          const context = getCookieContext(url);
          if (validators.isFunction(options)) {
            cb = options;
            options = {};
          }
          validators.validate(validators.isFunction(cb), cb);
          if (!validators.isNonEmptyString(cookie) && !validators.isObject(cookie) && cookie instanceof String && cookie.length == 0) {
            return cb(null);
          }
          const host = canonicalDomain(context.hostname);
          const loose = options.loose || this.enableLooseMode;
          let sameSiteContext = null;
          if (options.sameSiteContext) {
            sameSiteContext = checkSameSiteContext(options.sameSiteContext);
            if (!sameSiteContext) {
              return cb(new Error(SAME_SITE_CONTEXT_VAL_ERR));
            }
          }
          if (typeof cookie === "string" || cookie instanceof String) {
            cookie = Cookie2.parse(cookie, { loose });
            if (!cookie) {
              err = new Error("Cookie failed to parse");
              return cb(options.ignoreError ? null : err);
            }
          } else if (!(cookie instanceof Cookie2)) {
            err = new Error(
              "First argument to setCookie must be a Cookie object or string"
            );
            return cb(options.ignoreError ? null : err);
          }
          const now = options.now || /* @__PURE__ */ new Date();
          if (this.rejectPublicSuffixes && cookie.domain) {
            const suffix = pubsuffix.getPublicSuffix(cookie.cdomain(), {
              allowSpecialUseDomain: this.allowSpecialUseDomain,
              ignoreError: options.ignoreError
            });
            if (suffix == null && !IP_V6_REGEX_OBJECT.test(cookie.domain)) {
              err = new Error("Cookie has domain set to a public suffix");
              return cb(options.ignoreError ? null : err);
            }
          }
          if (cookie.domain) {
            if (!domainMatch2(host, cookie.cdomain(), false)) {
              err = new Error(
                `Cookie not in this host's domain. Cookie:${cookie.cdomain()} Request:${host}`
              );
              return cb(options.ignoreError ? null : err);
            }
            if (cookie.hostOnly == null) {
              cookie.hostOnly = false;
            }
          } else {
            cookie.hostOnly = true;
            cookie.domain = host;
          }
          if (!cookie.path || cookie.path[0] !== "/") {
            cookie.path = defaultPath(context.pathname);
            cookie.pathIsDefault = true;
          }
          if (options.http === false && cookie.httpOnly) {
            err = new Error("Cookie is HttpOnly and this isn't an HTTP API");
            return cb(options.ignoreError ? null : err);
          }
          if (cookie.sameSite !== "none" && cookie.sameSite !== void 0 && sameSiteContext) {
            if (sameSiteContext === "none") {
              err = new Error(
                "Cookie is SameSite but this is a cross-origin request"
              );
              return cb(options.ignoreError ? null : err);
            }
          }
          const ignoreErrorForPrefixSecurity = this.prefixSecurity === PrefixSecurityEnum.SILENT;
          const prefixSecurityDisabled = this.prefixSecurity === PrefixSecurityEnum.DISABLED;
          if (!prefixSecurityDisabled) {
            let errorFound = false;
            let errorMsg;
            if (!isSecurePrefixConditionMet(cookie)) {
              errorFound = true;
              errorMsg = "Cookie has __Secure prefix but Secure attribute is not set";
            } else if (!isHostPrefixConditionMet(cookie)) {
              errorFound = true;
              errorMsg = "Cookie has __Host prefix but either Secure or HostOnly attribute is not set or Path is not '/'";
            }
            if (errorFound) {
              return cb(
                options.ignoreError || ignoreErrorForPrefixSecurity ? null : new Error(errorMsg)
              );
            }
          }
          const store2 = this.store;
          if (!store2.updateCookie) {
            store2.updateCookie = function(oldCookie, newCookie, cb2) {
              this.putCookie(newCookie, cb2);
            };
          }
          function withCookie(err2, oldCookie) {
            if (err2) {
              return cb(err2);
            }
            const next = function(err3) {
              if (err3) {
                return cb(err3);
              } else {
                cb(null, cookie);
              }
            };
            if (oldCookie) {
              if (options.http === false && oldCookie.httpOnly) {
                err2 = new Error("old Cookie is HttpOnly and this isn't an HTTP API");
                return cb(options.ignoreError ? null : err2);
              }
              cookie.creation = oldCookie.creation;
              cookie.creationIndex = oldCookie.creationIndex;
              cookie.lastAccessed = now;
              store2.updateCookie(oldCookie, cookie, next);
            } else {
              cookie.creation = cookie.lastAccessed = now;
              store2.putCookie(cookie, next);
            }
          }
          store2.findCookie(cookie.domain, cookie.path, cookie.key, withCookie);
        }
        // RFC6365 S5.4
        getCookies(url, options, cb) {
          validators.validate(validators.isUrlStringOrObject(url), cb, url);
          const context = getCookieContext(url);
          if (validators.isFunction(options)) {
            cb = options;
            options = {};
          }
          validators.validate(validators.isObject(options), cb, options);
          validators.validate(validators.isFunction(cb), cb);
          const host = canonicalDomain(context.hostname);
          const path = context.pathname || "/";
          let secure = options.secure;
          if (secure == null && context.protocol && (context.protocol == "https:" || context.protocol == "wss:")) {
            secure = true;
          }
          let sameSiteLevel = 0;
          if (options.sameSiteContext) {
            const sameSiteContext = checkSameSiteContext(options.sameSiteContext);
            sameSiteLevel = Cookie2.sameSiteLevel[sameSiteContext];
            if (!sameSiteLevel) {
              return cb(new Error(SAME_SITE_CONTEXT_VAL_ERR));
            }
          }
          let http2 = options.http;
          if (http2 == null) {
            http2 = true;
          }
          const now = options.now || Date.now();
          const expireCheck = options.expire !== false;
          const allPaths = !!options.allPaths;
          const store2 = this.store;
          function matchingCookie(c) {
            if (c.hostOnly) {
              if (c.domain != host) {
                return false;
              }
            } else {
              if (!domainMatch2(host, c.domain, false)) {
                return false;
              }
            }
            if (!allPaths && !pathMatch2(path, c.path)) {
              return false;
            }
            if (c.secure && !secure) {
              return false;
            }
            if (c.httpOnly && !http2) {
              return false;
            }
            if (sameSiteLevel) {
              const cookieLevel = Cookie2.sameSiteLevel[c.sameSite || "none"];
              if (cookieLevel > sameSiteLevel) {
                return false;
              }
            }
            if (expireCheck && c.expiryTime() <= now) {
              store2.removeCookie(c.domain, c.path, c.key, () => {
              });
              return false;
            }
            return true;
          }
          store2.findCookies(
            host,
            allPaths ? null : path,
            this.allowSpecialUseDomain,
            (err, cookies) => {
              if (err) {
                return cb(err);
              }
              cookies = cookies.filter(matchingCookie);
              if (options.sort !== false) {
                cookies = cookies.sort(cookieCompare);
              }
              const now2 = /* @__PURE__ */ new Date();
              for (const cookie of cookies) {
                cookie.lastAccessed = now2;
              }
              cb(null, cookies);
            }
          );
        }
        getCookieString(...args) {
          const cb = args.pop();
          validators.validate(validators.isFunction(cb), cb);
          const next = function(err, cookies) {
            if (err) {
              cb(err);
            } else {
              cb(
                null,
                cookies.sort(cookieCompare).map((c) => c.cookieString()).join("; ")
              );
            }
          };
          args.push(next);
          this.getCookies.apply(this, args);
        }
        getSetCookieStrings(...args) {
          const cb = args.pop();
          validators.validate(validators.isFunction(cb), cb);
          const next = function(err, cookies) {
            if (err) {
              cb(err);
            } else {
              cb(
                null,
                cookies.map((c) => {
                  return c.toString();
                })
              );
            }
          };
          args.push(next);
          this.getCookies.apply(this, args);
        }
        serialize(cb) {
          validators.validate(validators.isFunction(cb), cb);
          let type = this.store.constructor.name;
          if (validators.isObject(type)) {
            type = null;
          }
          const serialized = {
            // The version of tough-cookie that serialized this jar. Generally a good
            // practice since future versions can make data import decisions based on
            // known past behavior. When/if this matters, use `semver`.
            version: `tough-cookie@${VERSION}`,
            // add the store type, to make humans happy:
            storeType: type,
            // CookieJar configuration:
            rejectPublicSuffixes: !!this.rejectPublicSuffixes,
            enableLooseMode: !!this.enableLooseMode,
            allowSpecialUseDomain: !!this.allowSpecialUseDomain,
            prefixSecurity: getNormalizedPrefixSecurity(this.prefixSecurity),
            // this gets filled from getAllCookies:
            cookies: []
          };
          if (!(this.store.getAllCookies && typeof this.store.getAllCookies === "function")) {
            return cb(
              new Error(
                "store does not support getAllCookies and cannot be serialized"
              )
            );
          }
          this.store.getAllCookies((err, cookies) => {
            if (err) {
              return cb(err);
            }
            serialized.cookies = cookies.map((cookie) => {
              cookie = cookie instanceof Cookie2 ? cookie.toJSON() : cookie;
              delete cookie.creationIndex;
              return cookie;
            });
            return cb(null, serialized);
          });
        }
        toJSON() {
          return this.serializeSync();
        }
        // use the class method CookieJar.deserialize instead of calling this directly
        _importCookies(serialized, cb) {
          let cookies = serialized.cookies;
          if (!cookies || !Array.isArray(cookies)) {
            return cb(new Error("serialized jar has no cookies array"));
          }
          cookies = cookies.slice();
          const putNext = (err) => {
            if (err) {
              return cb(err);
            }
            if (!cookies.length) {
              return cb(err, this);
            }
            let cookie;
            try {
              cookie = fromJSON(cookies.shift());
            } catch (e) {
              return cb(e);
            }
            if (cookie === null) {
              return putNext(null);
            }
            this.store.putCookie(cookie, putNext);
          };
          putNext();
        }
        clone(newStore, cb) {
          if (arguments.length === 1) {
            cb = newStore;
            newStore = null;
          }
          this.serialize((err, serialized) => {
            if (err) {
              return cb(err);
            }
            _CookieJar.deserialize(serialized, newStore, cb);
          });
        }
        cloneSync(newStore) {
          if (arguments.length === 0) {
            return this._cloneSync();
          }
          if (!newStore.synchronous) {
            throw new Error(
              "CookieJar clone destination store is not synchronous; use async API instead."
            );
          }
          return this._cloneSync(newStore);
        }
        removeAllCookies(cb) {
          validators.validate(validators.isFunction(cb), cb);
          const store2 = this.store;
          if (typeof store2.removeAllCookies === "function" && store2.removeAllCookies !== Store2.prototype.removeAllCookies) {
            return store2.removeAllCookies(cb);
          }
          store2.getAllCookies((err, cookies) => {
            if (err) {
              return cb(err);
            }
            if (cookies.length === 0) {
              return cb(null);
            }
            let completedCount = 0;
            const removeErrors = [];
            function removeCookieCb(removeErr) {
              if (removeErr) {
                removeErrors.push(removeErr);
              }
              completedCount++;
              if (completedCount === cookies.length) {
                return cb(removeErrors.length ? removeErrors[0] : null);
              }
            }
            cookies.forEach((cookie) => {
              store2.removeCookie(
                cookie.domain,
                cookie.path,
                cookie.key,
                removeCookieCb
              );
            });
          });
        }
        static deserialize(strOrObj, store2, cb) {
          if (arguments.length !== 3) {
            cb = store2;
            store2 = null;
          }
          validators.validate(validators.isFunction(cb), cb);
          let serialized;
          if (typeof strOrObj === "string") {
            serialized = jsonParse2(strOrObj);
            if (serialized instanceof Error) {
              return cb(serialized);
            }
          } else {
            serialized = strOrObj;
          }
          const jar = new _CookieJar(store2, {
            rejectPublicSuffixes: serialized.rejectPublicSuffixes,
            looseMode: serialized.enableLooseMode,
            allowSpecialUseDomain: serialized.allowSpecialUseDomain,
            prefixSecurity: serialized.prefixSecurity
          });
          jar._importCookies(serialized, (err) => {
            if (err) {
              return cb(err);
            }
            cb(null, jar);
          });
        }
        static deserializeSync(strOrObj, store2) {
          const serialized = typeof strOrObj === "string" ? JSON.parse(strOrObj) : strOrObj;
          const jar = new _CookieJar(store2, {
            rejectPublicSuffixes: serialized.rejectPublicSuffixes,
            looseMode: serialized.enableLooseMode
          });
          if (!jar.store.synchronous) {
            throw new Error(
              "CookieJar store is not synchronous; use async API instead."
            );
          }
          jar._importCookiesSync(serialized);
          return jar;
        }
      };
      CookieJar2.fromJSON = CookieJar2.deserializeSync;
      [
        "_importCookies",
        "clone",
        "getCookies",
        "getCookieString",
        "getSetCookieStrings",
        "removeAllCookies",
        "serialize",
        "setCookie"
      ].forEach((name) => {
        CookieJar2.prototype[name] = fromCallback(CookieJar2.prototype[name]);
      });
      CookieJar2.deserialize = fromCallback(CookieJar2.deserialize);
      function syncWrap(method) {
        return function(...args) {
          if (!this.store.synchronous) {
            throw new Error(
              "CookieJar store is not synchronous; use async API instead."
            );
          }
          let syncErr, syncResult;
          this[method](...args, (err, result) => {
            syncErr = err;
            syncResult = result;
          });
          if (syncErr) {
            throw syncErr;
          }
          return syncResult;
        };
      }
      exports.version = VERSION;
      exports.CookieJar = CookieJar2;
      exports.Cookie = Cookie2;
      exports.Store = Store2;
      exports.MemoryCookieStore = MemoryCookieStore2;
      exports.parseDate = parseDate;
      exports.formatDate = formatDate;
      exports.parse = parse3;
      exports.fromJSON = fromJSON;
      exports.domainMatch = domainMatch2;
      exports.defaultPath = defaultPath;
      exports.pathMatch = pathMatch2;
      exports.getPublicSuffix = pubsuffix.getPublicSuffix;
      exports.cookieCompare = cookieCompare;
      exports.permuteDomain = require_permuteDomain().permuteDomain;
      exports.permutePath = permutePath;
      exports.canonicalDomain = canonicalDomain;
      exports.PrefixSecurityEnum = PrefixSecurityEnum;
      exports.ParameterError = validators.ParameterError;
    }
  });
  var import_tough_cookie = __toESM3(require_cookie2(), 1);
  var source_default3 = import_tough_cookie.default;

  // src/core/utils/cookieStore.ts
  var { Cookie, CookieJar, Store, MemoryCookieStore, domainMatch, pathMatch } = source_default3;
  var WebStorageCookieStore = class extends Store {
    storage;
    storageKey;
    constructor() {
      super();
      invariant(
        typeof localStorage !== "undefined",
        "Failed to create a WebStorageCookieStore: `localStorage` is not available in this environment. This is likely an issue with MSW. Please report it on GitHub: https://github.com/mswjs/msw/issues"
      );
      this.synchronous = true;
      this.storage = localStorage;
      this.storageKey = "__msw-cookie-store__";
    }
    findCookie(domain, path, key, callback) {
      try {
        const store2 = this.getStore();
        const cookies = this.filterCookiesFromList(store2, { domain, path, key });
        callback(null, cookies[0] || null);
      } catch (error3) {
        if (error3 instanceof Error) {
          callback(error3, null);
        }
      }
    }
    findCookies(domain, path, allowSpecialUseDomain, callback) {
      if (!domain) {
        callback(null, []);
        return;
      }
      try {
        const store2 = this.getStore();
        const results = this.filterCookiesFromList(store2, {
          domain,
          path
        });
        callback(null, results);
      } catch (error3) {
        if (error3 instanceof Error) {
          callback(error3, []);
        }
      }
    }
    putCookie(cookie, callback) {
      try {
        if (cookie.maxAge === 0) {
          return;
        }
        const store2 = this.getStore();
        store2.push(cookie);
        this.updateStore(store2);
      } catch (error3) {
        if (error3 instanceof Error) {
          callback(error3);
        }
      }
    }
    updateCookie(oldCookie, newCookie, callback) {
      if (newCookie.maxAge === 0) {
        this.removeCookie(
          newCookie.domain || "",
          newCookie.path || "",
          newCookie.key,
          callback
        );
        return;
      }
      this.putCookie(newCookie, callback);
    }
    removeCookie(domain, path, key, callback) {
      try {
        const store2 = this.getStore();
        const nextStore = this.deleteCookiesFromList(store2, { domain, path, key });
        this.updateStore(nextStore);
        callback(null);
      } catch (error3) {
        if (error3 instanceof Error) {
          callback(error3);
        }
      }
    }
    removeCookies(domain, path, callback) {
      try {
        const store2 = this.getStore();
        const nextStore = this.deleteCookiesFromList(store2, { domain, path });
        this.updateStore(nextStore);
        callback(null);
      } catch (error3) {
        if (error3 instanceof Error) {
          callback(error3);
        }
      }
    }
    getAllCookies(callback) {
      try {
        callback(null, this.getStore());
      } catch (error3) {
        if (error3 instanceof Error) {
          callback(error3, []);
        }
      }
    }
    getStore() {
      try {
        const json = this.storage.getItem(this.storageKey);
        if (json == null) {
          return [];
        }
        const rawCookies = JSON.parse(json);
        const cookies = [];
        for (const rawCookie of rawCookies) {
          const cookie = Cookie.fromJSON(rawCookie);
          if (cookie != null) {
            cookies.push(cookie);
          }
        }
        return cookies;
      } catch {
        return [];
      }
    }
    updateStore(nextStore) {
      this.storage.setItem(
        this.storageKey,
        JSON.stringify(nextStore.map((cookie) => cookie.toJSON()))
      );
    }
    filterCookiesFromList(cookies, matches) {
      const result = [];
      for (const cookie of cookies) {
        if (matches.domain && !domainMatch(matches.domain, cookie.domain || "")) {
          continue;
        }
        if (matches.path && !pathMatch(matches.path, cookie.path || "")) {
          continue;
        }
        if (matches.key && cookie.key !== matches.key) {
          continue;
        }
        result.push(cookie);
      }
      return result;
    }
    deleteCookiesFromList(cookies, matches) {
      const matchingCookies = this.filterCookiesFromList(cookies, matches);
      return cookies.filter((cookie) => !matchingCookies.includes(cookie));
    }
  };
  var store = isNodeProcess() ? new MemoryCookieStore() : new WebStorageCookieStore();
  var cookieStore = new CookieJar(store);

  // src/core/utils/request/getRequestCookies.ts
  function parseCookies(input) {
    const parsedCookies = source_default2.parse(input);
    const cookies = {};
    for (const cookieName in parsedCookies) {
      if (typeof parsedCookies[cookieName] !== "undefined") {
        cookies[cookieName] = parsedCookies[cookieName];
      }
    }
    return cookies;
  }
  function getAllDocumentCookies() {
    return parseCookies(document.cookie);
  }
  function getDocumentCookies(request) {
    if (typeof document === "undefined" || typeof location === "undefined") {
      return {};
    }
    switch (request.credentials) {
      case "same-origin": {
        const requestUrl = new URL(request.url);
        return location.origin === requestUrl.origin ? getAllDocumentCookies() : {};
      }
      case "include": {
        return getAllDocumentCookies();
      }
      default: {
        return {};
      }
    }
  }
  function getAllRequestCookies(request) {
    const requestCookieHeader = request.headers.get("cookie");
    const cookiesFromHeaders = requestCookieHeader ? parseCookies(requestCookieHeader) : {};
    const cookiesFromDocument = getDocumentCookies(request);
    for (const name in cookiesFromDocument) {
      request.headers.append(
        "cookie",
        source_default2.serialize(name, cookiesFromDocument[name])
      );
    }
    const cookiesFromStore = cookieStore.getCookiesSync(request.url);
    const storedCookiesObject = Object.fromEntries(
      cookiesFromStore.map((cookie) => [cookie.key, cookie.value])
    );
    for (const cookie of cookiesFromStore) {
      request.headers.append("cookie", cookie.toString());
    }
    return {
      ...cookiesFromDocument,
      ...storedCookiesObject,
      ...cookiesFromHeaders
    };
  }

  // src/core/handlers/HttpHandler.ts
  var HttpMethods = /* @__PURE__ */ ((HttpMethods2) => {
    HttpMethods2["HEAD"] = "HEAD";
    HttpMethods2["GET"] = "GET";
    HttpMethods2["POST"] = "POST";
    HttpMethods2["PUT"] = "PUT";
    HttpMethods2["PATCH"] = "PATCH";
    HttpMethods2["OPTIONS"] = "OPTIONS";
    HttpMethods2["DELETE"] = "DELETE";
    return HttpMethods2;
  })(HttpMethods || {});
  var HttpHandler = class extends RequestHandler {
    constructor(method, path, resolver, options) {
      super({
        info: {
          header: `${method} ${path}`,
          path,
          method
        },
        resolver,
        options
      });
      this.checkRedundantQueryParameters();
    }
    checkRedundantQueryParameters() {
      const { method, path } = this.info;
      if (path instanceof RegExp) {
        return;
      }
      const url = cleanUrl(path);
      if (url === path) {
        return;
      }
      const searchParams = getSearchParams(path);
      const queryParams = [];
      searchParams.forEach((_, paramName) => {
        queryParams.push(paramName);
      });
      devUtils.warn(
        `Found a redundant usage of query parameters in the request handler URL for "${method} ${path}". Please match against a path instead and access query parameters using "new URL(request.url).searchParams" instead. Learn more: https://mswjs.io/docs/recipes/query-parameters`
      );
    }
    async parse(args) {
      const url = new URL(args.request.url);
      const match2 = matchRequestUrl(
        url,
        this.info.path,
        args.resolutionContext?.baseUrl
      );
      const cookies = getAllRequestCookies(args.request);
      return {
        match: match2,
        cookies
      };
    }
    predicate(args) {
      const hasMatchingMethod = this.matchMethod(args.request.method);
      const hasMatchingUrl = args.parsedResult.match.matches;
      return hasMatchingMethod && hasMatchingUrl;
    }
    matchMethod(actualMethod) {
      return this.info.method instanceof RegExp ? this.info.method.test(actualMethod) : isStringEqual(this.info.method, actualMethod);
    }
    extendResolverArgs(args) {
      return {
        params: args.parsedResult.match?.params || {},
        cookies: args.parsedResult.cookies
      };
    }
    async log(args) {
      const publicUrl = toPublicUrl(args.request.url);
      const loggedRequest = await serializeRequest(args.request);
      const loggedResponse = await serializeResponse(args.response);
      const statusColor = getStatusCodeColor(loggedResponse.status);
      console.groupCollapsed(
        devUtils.formatMessage(
          `${getTimestamp()} ${args.request.method} ${publicUrl} (%c${loggedResponse.status} ${loggedResponse.statusText}%c)`
        ),
        `color:${statusColor}`,
        "color:inherit"
      );
      console.log("Request", loggedRequest);
      console.log("Handler:", this);
      console.log("Response", loggedResponse);
      console.groupEnd();
    }
  };

  // src/core/http.ts
  function createHttpHandler(method) {
    return (path, resolver, options = {}) => {
      return new HttpHandler(method, path, resolver, options);
    };
  }
  var http = {
    all: createHttpHandler(/.+/),
    head: createHttpHandler("HEAD" /* HEAD */),
    get: createHttpHandler("GET" /* GET */),
    post: createHttpHandler("POST" /* POST */),
    put: createHttpHandler("PUT" /* PUT */),
    delete: createHttpHandler("DELETE" /* DELETE */),
    patch: createHttpHandler("PATCH" /* PATCH */),
    options: createHttpHandler("OPTIONS" /* OPTIONS */)
  };

  // src/core/utils/internal/jsonParse.ts
  function jsonParse(value) {
    try {
      return JSON.parse(value);
    } catch {
      return void 0;
    }
  }

  // node_modules/.pnpm/headers-polyfill@4.0.3/node_modules/headers-polyfill/lib/index.mjs
  var __create4 = Object.create;
  var __defProp6 = Object.defineProperty;
  var __getOwnPropDesc5 = Object.getOwnPropertyDescriptor;
  var __getOwnPropNames5 = Object.getOwnPropertyNames;
  var __getProtoOf4 = Object.getPrototypeOf;
  var __hasOwnProp5 = Object.prototype.hasOwnProperty;
  var __commonJS4 = (cb, mod) => function __require3() {
    return mod || (0, cb[__getOwnPropNames5(cb)[0]])((mod = { exports: {} }).exports, mod), mod.exports;
  };
  var __copyProps5 = (to, from, except, desc) => {
    if (from && typeof from === "object" || typeof from === "function") {
      for (let key of __getOwnPropNames5(from))
        if (!__hasOwnProp5.call(to, key) && key !== except)
          __defProp6(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc5(from, key)) || desc.enumerable });
    }
    return to;
  };
  var __toESM4 = (mod, isNodeMode, target) => (target = mod != null ? __create4(__getProtoOf4(mod)) : {}, __copyProps5(
    // If the importer is in node compatibility mode or this is not an ESM
    // file that has been converted to a CommonJS file using a Babel-
    // compatible transform (i.e. "__esModule" has not been set), then set
    // "default" to the CommonJS "module.exports" for node compatibility.
    isNodeMode || !mod || !mod.__esModule ? __defProp6(target, "default", { value: mod, enumerable: true }) : target,
    mod
  ));
  var require_set_cookie = __commonJS4({
    "node_modules/set-cookie-parser/lib/set-cookie.js"(exports, module) {
      "use strict";
      var defaultParseOptions = {
        decodeValues: true,
        map: false,
        silent: false
      };
      function isNonEmptyString(str) {
        return typeof str === "string" && !!str.trim();
      }
      function parseString(setCookieValue, options) {
        var parts = setCookieValue.split(";").filter(isNonEmptyString);
        var nameValuePairStr = parts.shift();
        var parsed = parseNameValuePair(nameValuePairStr);
        var name = parsed.name;
        var value = parsed.value;
        options = options ? Object.assign({}, defaultParseOptions, options) : defaultParseOptions;
        try {
          value = options.decodeValues ? decodeURIComponent(value) : value;
        } catch (e) {
          console.error(
            "set-cookie-parser encountered an error while decoding a cookie with value '" + value + "'. Set options.decodeValues to false to disable this feature.",
            e
          );
        }
        var cookie = {
          name,
          value
        };
        parts.forEach(function(part) {
          var sides = part.split("=");
          var key = sides.shift().trimLeft().toLowerCase();
          var value2 = sides.join("=");
          if (key === "expires") {
            cookie.expires = new Date(value2);
          } else if (key === "max-age") {
            cookie.maxAge = parseInt(value2, 10);
          } else if (key === "secure") {
            cookie.secure = true;
          } else if (key === "httponly") {
            cookie.httpOnly = true;
          } else if (key === "samesite") {
            cookie.sameSite = value2;
          } else {
            cookie[key] = value2;
          }
        });
        return cookie;
      }
      function parseNameValuePair(nameValuePairStr) {
        var name = "";
        var value = "";
        var nameValueArr = nameValuePairStr.split("=");
        if (nameValueArr.length > 1) {
          name = nameValueArr.shift();
          value = nameValueArr.join("=");
        } else {
          value = nameValuePairStr;
        }
        return { name, value };
      }
      function parse3(input, options) {
        options = options ? Object.assign({}, defaultParseOptions, options) : defaultParseOptions;
        if (!input) {
          if (!options.map) {
            return [];
          } else {
            return {};
          }
        }
        if (input.headers) {
          if (typeof input.headers.getSetCookie === "function") {
            input = input.headers.getSetCookie();
          } else if (input.headers["set-cookie"]) {
            input = input.headers["set-cookie"];
          } else {
            var sch = input.headers[Object.keys(input.headers).find(function(key) {
              return key.toLowerCase() === "set-cookie";
            })];
            if (!sch && input.headers.cookie && !options.silent) {
              console.warn(
                "Warning: set-cookie-parser appears to have been called on a request object. It is designed to parse Set-Cookie headers from responses, not Cookie headers from requests. Set the option {silent: true} to suppress this warning."
              );
            }
            input = sch;
          }
        }
        if (!Array.isArray(input)) {
          input = [input];
        }
        options = options ? Object.assign({}, defaultParseOptions, options) : defaultParseOptions;
        if (!options.map) {
          return input.filter(isNonEmptyString).map(function(str) {
            return parseString(str, options);
          });
        } else {
          var cookies = {};
          return input.filter(isNonEmptyString).reduce(function(cookies2, str) {
            var cookie = parseString(str, options);
            cookies2[cookie.name] = cookie;
            return cookies2;
          }, cookies);
        }
      }
      function splitCookiesString2(cookiesString) {
        if (Array.isArray(cookiesString)) {
          return cookiesString;
        }
        if (typeof cookiesString !== "string") {
          return [];
        }
        var cookiesStrings = [];
        var pos = 0;
        var start;
        var ch;
        var lastComma;
        var nextStart;
        var cookiesSeparatorFound;
        function skipWhitespace() {
          while (pos < cookiesString.length && /\s/.test(cookiesString.charAt(pos))) {
            pos += 1;
          }
          return pos < cookiesString.length;
        }
        function notSpecialChar() {
          ch = cookiesString.charAt(pos);
          return ch !== "=" && ch !== ";" && ch !== ",";
        }
        while (pos < cookiesString.length) {
          start = pos;
          cookiesSeparatorFound = false;
          while (skipWhitespace()) {
            ch = cookiesString.charAt(pos);
            if (ch === ",") {
              lastComma = pos;
              pos += 1;
              skipWhitespace();
              nextStart = pos;
              while (pos < cookiesString.length && notSpecialChar()) {
                pos += 1;
              }
              if (pos < cookiesString.length && cookiesString.charAt(pos) === "=") {
                cookiesSeparatorFound = true;
                pos = nextStart;
                cookiesStrings.push(cookiesString.substring(start, lastComma));
                start = pos;
              } else {
                pos = lastComma + 1;
              }
            } else {
              pos += 1;
            }
          }
          if (!cookiesSeparatorFound || pos >= cookiesString.length) {
            cookiesStrings.push(cookiesString.substring(start, cookiesString.length));
          }
        }
        return cookiesStrings;
      }
      module.exports = parse3;
      module.exports.parse = parse3;
      module.exports.parseString = parseString;
      module.exports.splitCookiesString = splitCookiesString2;
    }
  });
  var import_set_cookie_parser = __toESM4(require_set_cookie());
  var HEADERS_INVALID_CHARACTERS = /[^a-z0-9\-#$%&'*+.^_`|~]/i;
  function normalizeHeaderName(name) {
    if (HEADERS_INVALID_CHARACTERS.test(name) || name.trim() === "") {
      throw new TypeError("Invalid character in header field name");
    }
    return name.trim().toLowerCase();
  }
  var charCodesToRemove = [
    String.fromCharCode(10),
    String.fromCharCode(13),
    String.fromCharCode(9),
    String.fromCharCode(32)
  ];
  var HEADER_VALUE_REMOVE_REGEXP = new RegExp(
    `(^[${charCodesToRemove.join("")}]|$[${charCodesToRemove.join("")}])`,
    "g"
  );
  function normalizeHeaderValue(value) {
    const nextValue = value.replace(HEADER_VALUE_REMOVE_REGEXP, "");
    return nextValue;
  }
  function isValidHeaderName(value) {
    if (typeof value !== "string") {
      return false;
    }
    if (value.length === 0) {
      return false;
    }
    for (let i = 0; i < value.length; i++) {
      const character = value.charCodeAt(i);
      if (character > 127 || !isToken(character)) {
        return false;
      }
    }
    return true;
  }
  function isToken(value) {
    return ![
      127,
      32,
      "(",
      ")",
      "<",
      ">",
      "@",
      ",",
      ";",
      ":",
      "\\",
      '"',
      "/",
      "[",
      "]",
      "?",
      "=",
      "{",
      "}"
    ].includes(value);
  }
  function isValidHeaderValue(value) {
    if (typeof value !== "string") {
      return false;
    }
    if (value.trim() !== value) {
      return false;
    }
    for (let i = 0; i < value.length; i++) {
      const character = value.charCodeAt(i);
      if (
        // NUL.
        character === 0 || // HTTP newline bytes.
        character === 10 || character === 13
      ) {
        return false;
      }
    }
    return true;
  }
  var NORMALIZED_HEADERS = Symbol("normalizedHeaders");
  var RAW_HEADER_NAMES = Symbol("rawHeaderNames");
  var HEADER_VALUE_DELIMITER = ", ";
  var _a;
  var _b;
  var _c;
  var Headers2 = class _Headers {
    constructor(init) {
      this[_a] = {};
      this[_b] = /* @__PURE__ */ new Map();
      this[_c] = "Headers";
      if (["Headers", "HeadersPolyfill"].includes(init?.constructor.name) || init instanceof _Headers || typeof globalThis.Headers !== "undefined" && init instanceof globalThis.Headers) {
        const initialHeaders = init;
        initialHeaders.forEach((value, name) => {
          this.append(name, value);
        }, this);
      } else if (Array.isArray(init)) {
        init.forEach(([name, value]) => {
          this.append(
            name,
            Array.isArray(value) ? value.join(HEADER_VALUE_DELIMITER) : value
          );
        });
      } else if (init) {
        Object.getOwnPropertyNames(init).forEach((name) => {
          const value = init[name];
          this.append(
            name,
            Array.isArray(value) ? value.join(HEADER_VALUE_DELIMITER) : value
          );
        });
      }
    }
    [(_a = NORMALIZED_HEADERS, _b = RAW_HEADER_NAMES, _c = Symbol.toStringTag, Symbol.iterator)]() {
      return this.entries();
    }
    *keys() {
      for (const [name] of this.entries()) {
        yield name;
      }
    }
    *values() {
      for (const [, value] of this.entries()) {
        yield value;
      }
    }
    *entries() {
      let sortedKeys = Object.keys(this[NORMALIZED_HEADERS]).sort(
        (a, b) => a.localeCompare(b)
      );
      for (const name of sortedKeys) {
        if (name === "set-cookie") {
          for (const value of this.getSetCookie()) {
            yield [name, value];
          }
        } else {
          yield [name, this.get(name)];
        }
      }
    }
    /**
     * Returns a boolean stating whether a `Headers` object contains a certain header.
     */
    has(name) {
      if (!isValidHeaderName(name)) {
        throw new TypeError(`Invalid header name "${name}"`);
      }
      return this[NORMALIZED_HEADERS].hasOwnProperty(normalizeHeaderName(name));
    }
    /**
     * Returns a `ByteString` sequence of all the values of a header with a given name.
     */
    get(name) {
      if (!isValidHeaderName(name)) {
        throw TypeError(`Invalid header name "${name}"`);
      }
      return this[NORMALIZED_HEADERS][normalizeHeaderName(name)] ?? null;
    }
    /**
     * Sets a new value for an existing header inside a `Headers` object, or adds the header if it does not already exist.
     */
    set(name, value) {
      if (!isValidHeaderName(name) || !isValidHeaderValue(value)) {
        return;
      }
      const normalizedName = normalizeHeaderName(name);
      const normalizedValue = normalizeHeaderValue(value);
      this[NORMALIZED_HEADERS][normalizedName] = normalizeHeaderValue(normalizedValue);
      this[RAW_HEADER_NAMES].set(normalizedName, name);
    }
    /**
     * Appends a new value onto an existing header inside a `Headers` object, or adds the header if it does not already exist.
     */
    append(name, value) {
      if (!isValidHeaderName(name) || !isValidHeaderValue(value)) {
        return;
      }
      const normalizedName = normalizeHeaderName(name);
      const normalizedValue = normalizeHeaderValue(value);
      let resolvedValue = this.has(normalizedName) ? `${this.get(normalizedName)}, ${normalizedValue}` : normalizedValue;
      this.set(name, resolvedValue);
    }
    /**
     * Deletes a header from the `Headers` object.
     */
    delete(name) {
      if (!isValidHeaderName(name)) {
        return;
      }
      if (!this.has(name)) {
        return;
      }
      const normalizedName = normalizeHeaderName(name);
      delete this[NORMALIZED_HEADERS][normalizedName];
      this[RAW_HEADER_NAMES].delete(normalizedName);
    }
    /**
     * Traverses the `Headers` object,
     * calling the given callback for each header.
     */
    forEach(callback, thisArg) {
      for (const [name, value] of this.entries()) {
        callback.call(thisArg, value, name, this);
      }
    }
    /**
     * Returns an array containing the values
     * of all Set-Cookie headers associated
     * with a response
     */
    getSetCookie() {
      const setCookieHeader = this.get("set-cookie");
      if (setCookieHeader === null) {
        return [];
      }
      if (setCookieHeader === "") {
        return [""];
      }
      return (0, import_set_cookie_parser.splitCookiesString)(setCookieHeader);
    }
  };
  function stringToHeaders(str) {
    const lines = str.trim().split(/[\r\n]+/);
    return lines.reduce((headers, line) => {
      if (line.trim() === "") {
        return headers;
      }
      const parts = line.split(": ");
      const name = parts.shift();
      const value = parts.join(": ");
      headers.append(name, value);
      return headers;
    }, new Headers2());
  }

  // src/core/utils/internal/parseMultipartData.ts
  function parseContentHeaders(headersString) {
    const headers = stringToHeaders(headersString);
    const contentType = headers.get("content-type") || "text/plain";
    const disposition = headers.get("content-disposition");
    if (!disposition) {
      throw new Error('"Content-Disposition" header is required.');
    }
    const directives = disposition.split(";").reduce((acc, chunk) => {
      const [name2, ...rest] = chunk.trim().split("=");
      acc[name2] = rest.join("=");
      return acc;
    }, {});
    const name = directives.name?.slice(1, -1);
    const filename = directives.filename?.slice(1, -1);
    return {
      name,
      filename,
      contentType
    };
  }
  function parseMultipartData(data, headers) {
    const contentType = headers?.get("content-type");
    if (!contentType) {
      return void 0;
    }
    const [, ...directives] = contentType.split(/; */);
    const boundary = directives.filter((d) => d.startsWith("boundary=")).map((s) => s.replace(/^boundary=/, ""))[0];
    if (!boundary) {
      return void 0;
    }
    const boundaryRegExp = new RegExp(`--+${boundary}`);
    const fields = data.split(boundaryRegExp).filter((chunk) => chunk.startsWith("\r\n") && chunk.endsWith("\r\n")).map((chunk) => chunk.trimStart().replace(/\r\n$/, ""));
    if (!fields.length) {
      return void 0;
    }
    const parsedBody = {};
    try {
      for (const field of fields) {
        const [contentHeaders, ...rest] = field.split("\r\n\r\n");
        const contentBody = rest.join("\r\n\r\n");
        const { contentType: contentType2, filename, name } = parseContentHeaders(contentHeaders);
        const value = filename === void 0 ? contentBody : new File([contentBody], filename, { type: contentType2 });
        const parsedValue = parsedBody[name];
        if (parsedValue === void 0) {
          parsedBody[name] = value;
        } else if (Array.isArray(parsedValue)) {
          parsedBody[name] = [...parsedValue, value];
        } else {
          parsedBody[name] = [parsedValue, value];
        }
      }
      return parsedBody;
    } catch {
      return void 0;
    }
  }

  // src/core/utils/internal/parseGraphQLRequest.ts
  function parseDocumentNode(node) {
    const operationDef = node.definitions.find((definition) => {
      return definition.kind === "OperationDefinition";
    });
    return {
      operationType: operationDef?.operation,
      operationName: operationDef?.name?.value
    };
  }
  async function parseQuery(query) {
    const { parse: parse3 } = (init_graphql2(), __toCommonJS(graphql_exports));
    try {
      const ast = parse3(query);
      return parseDocumentNode(ast);
    } catch (error3) {
      return error3;
    }
  }
  function extractMultipartVariables(variables, map, files) {
    const operations = { variables };
    for (const [key, pathArray] of Object.entries(map)) {
      if (!(key in files)) {
        throw new Error(`Given files do not have a key '${key}' .`);
      }
      for (const dotPath of pathArray) {
        const [lastPath, ...reversedPaths] = dotPath.split(".").reverse();
        const paths = reversedPaths.reverse();
        let target = operations;
        for (const path of paths) {
          if (!(path in target)) {
            throw new Error(`Property '${paths}' is not in operations.`);
          }
          target = target[path];
        }
        target[lastPath] = files[key];
      }
    }
    return operations.variables;
  }
  async function getGraphQLInput(request) {
    switch (request.method) {
      case "GET": {
        const url = new URL(request.url);
        const query = url.searchParams.get("query");
        const variables = url.searchParams.get("variables") || "";
        return {
          query,
          variables: jsonParse(variables)
        };
      }
      case "POST": {
        const requestClone = request.clone();
        if (request.headers.get("content-type")?.includes("multipart/form-data")) {
          const responseJson = parseMultipartData(
            await requestClone.text(),
            request.headers
          );
          if (!responseJson) {
            return null;
          }
          const { operations, map, ...files } = responseJson;
          const parsedOperations = jsonParse(
            operations
          ) || {};
          if (!parsedOperations.query) {
            return null;
          }
          const parsedMap = jsonParse(map || "") || {};
          const variables = parsedOperations.variables ? extractMultipartVariables(
            parsedOperations.variables,
            parsedMap,
            files
          ) : {};
          return {
            query: parsedOperations.query,
            variables
          };
        }
        const requestJson = await requestClone.json().catch(() => null);
        if (requestJson?.query) {
          const { query, variables } = requestJson;
          return {
            query,
            variables
          };
        }
      }
      default:
        return null;
    }
  }
  async function parseGraphQLRequest(request) {
    const input = await getGraphQLInput(request);
    if (!input || !input.query) {
      return;
    }
    const { query, variables } = input;
    const parsedResult = await parseQuery(query);
    if (parsedResult instanceof Error) {
      const requestPublicUrl = toPublicUrl(request.url);
      throw new Error(
        devUtils.formatMessage(
          'Failed to intercept a GraphQL request to "%s %s": cannot parse query. See the error message from the parser below.\n\n%s',
          request.method,
          requestPublicUrl,
          parsedResult.message
        )
      );
    }
    return {
      query: input.query,
      operationType: parsedResult.operationType,
      operationName: parsedResult.operationName,
      variables
    };
  }

  // src/core/handlers/GraphQLHandler.ts
  function isDocumentNode(value) {
    if (value == null) {
      return false;
    }
    return typeof value === "object" && "kind" in value && "definitions" in value;
  }
  var GraphQLHandler = class _GraphQLHandler extends RequestHandler {
    endpoint;
    static parsedRequestCache = /* @__PURE__ */ new WeakMap();
    constructor(operationType, operationName, endpoint, resolver, options) {
      let resolvedOperationName = operationName;
      if (isDocumentNode(operationName)) {
        const parsedNode = parseDocumentNode(operationName);
        if (parsedNode.operationType !== operationType) {
          throw new Error(
            `Failed to create a GraphQL handler: provided a DocumentNode with a mismatched operation type (expected "${operationType}", but got "${parsedNode.operationType}").`
          );
        }
        if (!parsedNode.operationName) {
          throw new Error(
            `Failed to create a GraphQL handler: provided a DocumentNode with no operation name.`
          );
        }
        resolvedOperationName = parsedNode.operationName;
      }
      const header = operationType === "all" ? `${operationType} (origin: ${endpoint.toString()})` : `${operationType} ${resolvedOperationName} (origin: ${endpoint.toString()})`;
      super({
        info: {
          header,
          operationType,
          operationName: resolvedOperationName
        },
        resolver,
        options
      });
      this.endpoint = endpoint;
    }
    /**
     * Parses the request body, once per request, cached across all
     * GraphQL handlers. This is done to avoid multiple parsing of the
     * request body, which each requires a clone of the request.
     */
    async parseGraphQLRequestOrGetFromCache(request) {
      if (!_GraphQLHandler.parsedRequestCache.has(request)) {
        _GraphQLHandler.parsedRequestCache.set(
          request,
          await parseGraphQLRequest(request).catch((error3) => {
            console.error(error3);
            return void 0;
          })
        );
      }
      return _GraphQLHandler.parsedRequestCache.get(request);
    }
    async parse(args) {
      const match2 = matchRequestUrl(new URL(args.request.url), this.endpoint);
      const cookies = getAllRequestCookies(args.request);
      if (!match2.matches) {
        return { match: match2, cookies };
      }
      const parsedResult = await this.parseGraphQLRequestOrGetFromCache(
        args.request
      );
      if (typeof parsedResult === "undefined") {
        return { match: match2, cookies };
      }
      return {
        match: match2,
        cookies,
        query: parsedResult.query,
        operationType: parsedResult.operationType,
        operationName: parsedResult.operationName,
        variables: parsedResult.variables
      };
    }
    predicate(args) {
      if (args.parsedResult.operationType === void 0) {
        return false;
      }
      if (!args.parsedResult.operationName && this.info.operationType !== "all") {
        const publicUrl = toPublicUrl(args.request.url);
        devUtils.warn(`Failed to intercept a GraphQL request at "${args.request.method} ${publicUrl}": anonymous GraphQL operations are not supported.

Consider naming this operation or using "graphql.operation()" request handler to intercept GraphQL requests regardless of their operation name/type. Read more: https://mswjs.io/docs/api/graphql/#graphqloperationresolver`);
        return false;
      }
      const hasMatchingOperationType = this.info.operationType === "all" || args.parsedResult.operationType === this.info.operationType;
      const hasMatchingOperationName = this.info.operationName instanceof RegExp ? this.info.operationName.test(args.parsedResult.operationName || "") : args.parsedResult.operationName === this.info.operationName;
      return args.parsedResult.match.matches && hasMatchingOperationType && hasMatchingOperationName;
    }
    extendResolverArgs(args) {
      return {
        query: args.parsedResult.query || "",
        operationName: args.parsedResult.operationName || "",
        variables: args.parsedResult.variables || {},
        cookies: args.parsedResult.cookies
      };
    }
    async log(args) {
      const loggedRequest = await serializeRequest(args.request);
      const loggedResponse = await serializeResponse(args.response);
      const statusColor = getStatusCodeColor(loggedResponse.status);
      const requestInfo = args.parsedResult.operationName ? `${args.parsedResult.operationType} ${args.parsedResult.operationName}` : `anonymous ${args.parsedResult.operationType}`;
      console.groupCollapsed(
        devUtils.formatMessage(
          `${getTimestamp()} ${requestInfo} (%c${loggedResponse.status} ${loggedResponse.statusText}%c)`
        ),
        `color:${statusColor}`,
        "color:inherit"
      );
      console.log("Request:", loggedRequest);
      console.log("Handler:", this);
      console.log("Response:", loggedResponse);
      console.groupEnd();
    }
  };

  // src/core/graphql.ts
  function createScopedGraphQLHandler(operationType, url) {
    return (operationName, resolver, options = {}) => {
      return new GraphQLHandler(
        operationType,
        operationName,
        url,
        resolver,
        options
      );
    };
  }
  function createGraphQLOperationHandler(url) {
    return (resolver) => {
      return new GraphQLHandler("all", new RegExp(".*"), url, resolver);
    };
  }
  var standardGraphQLHandlers = {
    /**
     * Intercepts a GraphQL query by a given name.
     *
     * @example
     * graphql.query('GetUser', () => {
     *   return HttpResponse.json({ data: { user: { name: 'John' } } })
     * })
     *
     * @see {@link https://mswjs.io/docs/api/graphql#graphqlqueryqueryname-resolver `graphql.query()` API reference}
     */
    query: createScopedGraphQLHandler("query", "*"),
    /**
     * Intercepts a GraphQL mutation by its name.
     *
     * @example
     * graphql.mutation('SavePost', () => {
     *   return HttpResponse.json({ data: { post: { id: 'abc-123 } } })
     * })
     *
     * @see {@link https://mswjs.io/docs/api/graphql#graphqlmutationmutationname-resolver `graphql.query()` API reference}
     *
     */
    mutation: createScopedGraphQLHandler("mutation", "*"),
    /**
     * Intercepts any GraphQL operation, regardless of its type or name.
     *
     * @example
     * graphql.operation(() => {
     *   return HttpResponse.json({ data: { name: 'John' } })
     * })
     *
     * @see {@link https://mswjs.io/docs/api/graphql#graphloperationresolver `graphql.operation()` API reference}
     */
    operation: createGraphQLOperationHandler("*")
  };
  function createGraphQLLink(url) {
    return {
      operation: createGraphQLOperationHandler(url),
      query: createScopedGraphQLHandler("query", url),
      mutation: createScopedGraphQLHandler("mutation", url)
    };
  }
  var graphql2 = {
    ...standardGraphQLHandlers,
    /**
     * Intercepts GraphQL operations scoped by the given URL.
     *
     * @example
     * const github = graphql.link('https://api.github.com/graphql')
     * github.query('GetRepo', resolver)
     *
     * @see {@link https://mswjs.io/docs/api/graphql#graphqllinkurl `graphql.link()` API reference}
     */
    link: createGraphQLLink
  };

  // src/core/handlers/WebSocketHandler.ts
  var kEmitter = Symbol("kEmitter");
  var kDispatchEvent = Symbol("kDispatchEvent");
  var kSender = Symbol("kSender");
  var kStopPropagationPatched = Symbol("kStopPropagationPatched");
  var KOnStopPropagation = Symbol("KOnStopPropagation");
  var WebSocketHandler = class {
    constructor(url) {
      this.url = url;
      this.id = createRequestId();
      this[kEmitter] = new Emitter();
      this.callFrame = getCallFrame(new Error());
      this.__kind = "EventHandler";
    }
    __kind;
    id;
    callFrame;
    [kEmitter];
    parse(args) {
      const connection = args.event.data;
      const match2 = matchRequestUrl(connection.client.url, this.url);
      return {
        match: match2
      };
    }
    predicate(args) {
      return args.parsedResult.match.matches;
    }
    async [kDispatchEvent](event) {
      const parsedResult = this.parse({ event });
      const connection = event.data;
      const resolvedConnection = {
        ...connection,
        params: parsedResult.match.params || {}
      };
      connection.client.addEventListener(
        "message",
        createStopPropagationListener(this)
      );
      connection.client.addEventListener(
        "close",
        createStopPropagationListener(this)
      );
      connection.server.addEventListener(
        "open",
        createStopPropagationListener(this)
      );
      connection.server.addEventListener(
        "message",
        createStopPropagationListener(this)
      );
      connection.server.addEventListener(
        "error",
        createStopPropagationListener(this)
      );
      connection.server.addEventListener(
        "close",
        createStopPropagationListener(this)
      );
      this[kEmitter].emit("connection", resolvedConnection);
    }
  };
  function createStopPropagationListener(handler) {
    return function stopPropagationListener(event) {
      const propagationStoppedAt = Reflect.get(event, "kPropagationStoppedAt");
      if (propagationStoppedAt && handler.id !== propagationStoppedAt) {
        event.stopImmediatePropagation();
        return;
      }
      Object.defineProperty(event, KOnStopPropagation, {
        value() {
          Object.defineProperty(event, "kPropagationStoppedAt", {
            value: handler.id
          });
        },
        configurable: true
      });
      if (!Reflect.get(event, kStopPropagationPatched)) {
        event.stopPropagation = new Proxy(event.stopPropagation, {
          apply: (target, thisArg, args) => {
            Reflect.get(event, KOnStopPropagation)?.call(handler);
            return Reflect.apply(target, thisArg, args);
          }
        });
        Object.defineProperty(event, kStopPropagationPatched, {
          value: true,
          // If something else attempts to redefine this, throw.
          configurable: false
        });
      }
    };
  }

  // src/core/ws/WebSocketMemoryClientStore.ts
  var WebSocketMemoryClientStore = class {
    store;
    constructor() {
      this.store = /* @__PURE__ */ new Map();
    }
    async add(client) {
      this.store.set(client.id, { id: client.id, url: client.url.href });
    }
    getAll() {
      return Promise.resolve(Array.from(this.store.values()));
    }
    async deleteMany(clientIds) {
      for (const clientId of clientIds) {
        this.store.delete(clientId);
      }
    }
  };

  // node_modules/.pnpm/@open-draft+deferred-promise@2.2.0/node_modules/@open-draft/deferred-promise/build/index.mjs
  function createDeferredExecutor() {
    const executor = (resolve, reject) => {
      executor.state = "pending";
      executor.resolve = (data) => {
        if (executor.state !== "pending") {
          return;
        }
        executor.result = data;
        const onFulfilled = (value) => {
          executor.state = "fulfilled";
          return value;
        };
        return resolve(
          data instanceof Promise ? data : Promise.resolve(data).then(onFulfilled)
        );
      };
      executor.reject = (reason) => {
        if (executor.state !== "pending") {
          return;
        }
        queueMicrotask(() => {
          executor.state = "rejected";
        });
        return reject(executor.rejectionReason = reason);
      };
    };
    return executor;
  }
  var DeferredPromise = class extends Promise {
    #executor;
    resolve;
    reject;
    constructor(executor = null) {
      const deferredExecutor = createDeferredExecutor();
      super((originalResolve, originalReject) => {
        deferredExecutor(originalResolve, originalReject);
        executor?.(deferredExecutor.resolve, deferredExecutor.reject);
      });
      this.#executor = deferredExecutor;
      this.resolve = this.#executor.resolve;
      this.reject = this.#executor.reject;
    }
    get state() {
      return this.#executor.state;
    }
    get rejectionReason() {
      return this.#executor.rejectionReason;
    }
    then(onFulfilled, onRejected) {
      return this.#decorate(super.then(onFulfilled, onRejected));
    }
    catch(onRejected) {
      return this.#decorate(super.catch(onRejected));
    }
    finally(onfinally) {
      return this.#decorate(super.finally(onfinally));
    }
    #decorate(promise) {
      return Object.defineProperties(promise, {
        resolve: { configurable: true, value: this.resolve },
        reject: { configurable: true, value: this.reject }
      });
    }
  };

  // src/core/ws/WebSocketIndexedDBClientStore.ts
  var DB_NAME = "msw-websocket-clients";
  var DB_STORE_NAME = "clients";
  var WebSocketIndexedDBClientStore = class {
    db;
    constructor() {
      this.db = this.createDatabase();
    }
    async add(client) {
      const promise = new DeferredPromise();
      const store2 = await this.getStore();
      const request = store2.put({
        id: client.id,
        url: client.url.href
      });
      request.onsuccess = () => {
        promise.resolve();
      };
      request.onerror = () => {
        console.error(request.error);
        promise.reject(
          new Error(
            `Failed to add WebSocket client "${client.id}". There is likely an additional output above.`
          )
        );
      };
      return promise;
    }
    async getAll() {
      const promise = new DeferredPromise();
      const store2 = await this.getStore();
      const request = store2.getAll();
      request.onsuccess = () => {
        promise.resolve(request.result);
      };
      request.onerror = () => {
        console.log(request.error);
        promise.reject(
          new Error(
            `Failed to get all WebSocket clients. There is likely an additional output above.`
          )
        );
      };
      return promise;
    }
    async deleteMany(clientIds) {
      const promise = new DeferredPromise();
      const store2 = await this.getStore();
      for (const clientId of clientIds) {
        store2.delete(clientId);
      }
      store2.transaction.oncomplete = () => {
        promise.resolve();
      };
      store2.transaction.onerror = () => {
        console.error(store2.transaction.error);
        promise.reject(
          new Error(
            `Failed to delete WebSocket clients [${clientIds.join(", ")}]. There is likely an additional output above.`
          )
        );
      };
      return promise;
    }
    async createDatabase() {
      const promise = new DeferredPromise();
      const request = indexedDB.open(DB_NAME, 1);
      request.onsuccess = ({ currentTarget }) => {
        const db = Reflect.get(currentTarget, "result");
        if (db.objectStoreNames.contains(DB_STORE_NAME)) {
          return promise.resolve(db);
        }
      };
      request.onupgradeneeded = async ({ currentTarget }) => {
        const db = Reflect.get(currentTarget, "result");
        if (db.objectStoreNames.contains(DB_STORE_NAME)) {
          return;
        }
        const store2 = db.createObjectStore(DB_STORE_NAME, { keyPath: "id" });
        store2.transaction.oncomplete = () => {
          promise.resolve(db);
        };
        store2.transaction.onerror = () => {
          console.error(store2.transaction.error);
          promise.reject(
            new Error(
              "Failed to create WebSocket client store. There is likely an additional output above."
            )
          );
        };
      };
      request.onerror = () => {
        console.error(request.error);
        promise.reject(
          new Error(
            "Failed to open an IndexedDB database. There is likely an additional output above."
          )
        );
      };
      return promise;
    }
    async getStore() {
      const db = await this.db;
      return db.transaction(DB_STORE_NAME, "readwrite").objectStore(DB_STORE_NAME);
    }
  };

  // src/core/ws/WebSocketClientManager.ts
  var WebSocketClientManager = class {
    constructor(channel) {
      this.channel = channel;
      this.store = typeof indexedDB !== "undefined" ? new WebSocketIndexedDBClientStore() : new WebSocketMemoryClientStore();
      this.runtimeClients = /* @__PURE__ */ new Map();
      this.allClients = /* @__PURE__ */ new Set();
      this.channel.addEventListener("message", (message3) => {
        if (message3.data?.type === "db:update") {
          this.flushDatabaseToMemory();
        }
      });
      if (typeof window !== "undefined") {
        window.addEventListener("message", async (message3) => {
          if (message3.data?.type === "msw/worker:stop") {
            await this.removeRuntimeClients();
          }
        });
      }
    }
    store;
    runtimeClients;
    allClients;
    async flushDatabaseToMemory() {
      const storedClients = await this.store.getAll();
      this.allClients = new Set(
        storedClients.map((client) => {
          const runtimeClient = this.runtimeClients.get(client.id);
          if (runtimeClient) {
            return runtimeClient;
          }
          return new WebSocketRemoteClientConnection(
            client.id,
            new URL(client.url),
            this.channel
          );
        })
      );
    }
    async removeRuntimeClients() {
      await this.store.deleteMany(Array.from(this.runtimeClients.keys()));
      this.runtimeClients.clear();
      await this.flushDatabaseToMemory();
      this.notifyOthersAboutDatabaseUpdate();
    }
    /**
     * All active WebSocket client connections.
     */
    get clients() {
      return this.allClients;
    }
    /**
     * Notify other runtimes about the database update
     * using the shared `BroadcastChannel` instance.
     */
    notifyOthersAboutDatabaseUpdate() {
      this.channel.postMessage({ type: "db:update" });
    }
    async addClient(client) {
      await this.store.add(client);
      await this.flushDatabaseToMemory();
      this.notifyOthersAboutDatabaseUpdate();
    }
    /**
     * Adds the given `WebSocket` client connection to the set
     * of all connections. The given connection is always the complete
     * connection object because `addConnection()` is called only
     * for the opened connections in the same runtime.
     */
    async addConnection(client) {
      this.runtimeClients.set(client.id, client);
      await this.addClient(client);
      const handleExtraneousMessage = (message3) => {
        const { type, payload } = message3.data;
        if (typeof payload === "object" && "clientId" in payload && payload.clientId !== client.id) {
          return;
        }
        switch (type) {
          case "extraneous:send": {
            client.send(payload.data);
            break;
          }
          case "extraneous:close": {
            client.close(payload.code, payload.reason);
            break;
          }
        }
      };
      const abortController = new AbortController();
      this.channel.addEventListener("message", handleExtraneousMessage, {
        signal: abortController.signal
      });
      client.addEventListener("close", () => abortController.abort(), {
        once: true
      });
    }
  };
  var WebSocketRemoteClientConnection = class {
    constructor(id, url, channel) {
      this.id = id;
      this.url = url;
      this.channel = channel;
    }
    send(data) {
      this.channel.postMessage({
        type: "extraneous:send",
        payload: {
          clientId: this.id,
          data
        }
      });
    }
    close(code, reason) {
      this.channel.postMessage({
        type: "extraneous:close",
        payload: {
          clientId: this.id,
          code,
          reason
        }
      });
    }
  };

  // src/core/ws.ts
  function isBroadcastChannelWithUnref(channel) {
    return typeof Reflect.get(channel, "unref") !== "undefined";
  }
  var webSocketChannel = new BroadcastChannel("msw:websocket-client-manager");
  if (isBroadcastChannelWithUnref(webSocketChannel)) {
    webSocketChannel.unref();
  }
  function createWebSocketLinkHandler(url) {
    invariant(url, "Expected a WebSocket server URL but got undefined");
    invariant(
      isPath(url),
      "Expected a WebSocket server URL to be a valid path but got %s",
      typeof url
    );
    const clientManager = new WebSocketClientManager(webSocketChannel);
    return {
      get clients() {
        return clientManager.clients;
      },
      addEventListener(event, listener) {
        const handler = new WebSocketHandler(url);
        handler[kEmitter].on("connection", async ({ client }) => {
          await clientManager.addConnection(client);
        });
        handler[kEmitter].on(event, listener);
        return handler;
      },
      broadcast(data) {
        this.broadcastExcept([], data);
      },
      broadcastExcept(clients, data) {
        const ignoreClients = Array.prototype.concat(clients).map((client) => client.id);
        clientManager.clients.forEach((otherClient) => {
          if (!ignoreClients.includes(otherClient.id)) {
            otherClient.send(data);
          }
        });
      }
    };
  }
  var ws = {
    link: createWebSocketLinkHandler
  };

  // node_modules/.pnpm/@open-draft+until@2.1.0/node_modules/@open-draft/until/lib/index.mjs
  var until = async (promise) => {
    try {
      const data = await promise().catch((error3) => {
        throw error3;
      });
      return { error: null, data };
    } catch (error3) {
      return { error: error3, data: null };
    }
  };

  // src/core/utils/executeHandlers.ts
  var executeHandlers = async ({
    request,
    requestId,
    handlers,
    resolutionContext
  }) => {
    let matchingHandler = null;
    let result = null;
    for (const handler of handlers) {
      result = await handler.run({ request, requestId, resolutionContext });
      if (result !== null) {
        matchingHandler = handler;
      }
      if (result?.response) {
        break;
      }
    }
    if (matchingHandler) {
      return {
        handler: matchingHandler,
        parsedResult: result?.parsedResult,
        response: result?.response
      };
    }
    return null;
  };

  // src/core/isCommonAssetRequest.ts
  function isCommonAssetRequest(request) {
    const url = new URL(request.url);
    if (url.protocol === "file:") {
      return true;
    }
    if (/(fonts\.googleapis\.com)/.test(url.hostname)) {
      return true;
    }
    if (/node_modules/.test(url.pathname)) {
      return true;
    }
    if (url.pathname.includes("@vite")) {
      return true;
    }
    return /\.(s?css|less|m?jsx?|m?tsx?|html|ttf|otf|woff|woff2|eot|gif|jpe?g|png|avif|webp|svg|mp4|webm|ogg|mov|mp3|wav|ogg|flac|aac|pdf|txt|csv|json|xml|md|zip|tar|gz|rar|7z)$/i.test(
      url.pathname
    );
  }

  // src/core/utils/request/onUnhandledRequest.ts
  async function onUnhandledRequest(request, strategy = "warn") {
    const url = new URL(request.url);
    const publicUrl = toPublicUrl(url) + url.search;
    const requestBody = request.method === "HEAD" || request.method === "GET" ? null : await request.clone().text();
    const messageDetails = `

  \u2022 ${request.method} ${publicUrl}

${requestBody ? `  \u2022 Request body: ${requestBody}

` : ""}`;
    const unhandledRequestMessage = `intercepted a request without a matching request handler:${messageDetails}If you still wish to intercept this unhandled request, please create a request handler for it.
Read more: https://mswjs.io/docs/getting-started/mocks`;
    function applyStrategy(strategy2) {
      switch (strategy2) {
        case "error": {
          devUtils.error("Error: %s", unhandledRequestMessage);
          throw new InternalError(
            devUtils.formatMessage(
              'Cannot bypass a request when using the "error" strategy for the "onUnhandledRequest" option.'
            )
          );
        }
        case "warn": {
          devUtils.warn("Warning: %s", unhandledRequestMessage);
          break;
        }
        case "bypass":
          break;
        default:
          throw new InternalError(
            devUtils.formatMessage(
              'Failed to react to an unhandled request: unknown strategy "%s". Please provide one of the supported strategies ("bypass", "warn", "error") or a custom callback function as the value of the "onUnhandledRequest" option.',
              strategy2
            )
          );
      }
    }
    if (typeof strategy === "function") {
      strategy(request, {
        warning: applyStrategy.bind(null, "warn"),
        error: applyStrategy.bind(null, "error")
      });
      return;
    }
    if (!isCommonAssetRequest(request)) {
      applyStrategy(strategy);
    }
  }

  // src/core/utils/HttpResponse/decorators.ts
  var { message: message2 } = source_default;
  var kSetCookie = Symbol("kSetCookie");
  function normalizeResponseInit(init = {}) {
    const status = init?.status || 200;
    const statusText = init?.statusText || message2[status] || "";
    const headers = new Headers(init?.headers);
    return {
      ...init,
      headers,
      status,
      statusText
    };
  }
  function decorateResponse(response, init) {
    if (init.type) {
      Object.defineProperty(response, "type", {
        value: init.type,
        enumerable: true,
        writable: false
      });
    }
    const responseCookies = init.headers.get("set-cookie");
    if (responseCookies) {
      Object.defineProperty(response, kSetCookie, {
        value: responseCookies,
        enumerable: false,
        writable: false
      });
      if (typeof document !== "undefined") {
        const responseCookiePairs = Headers2.prototype.getSetCookie.call(
          init.headers
        );
        for (const cookieString of responseCookiePairs) {
          document.cookie = cookieString;
        }
      }
    }
    return response;
  }

  // src/core/utils/request/storeResponseCookies.ts
  function storeResponseCookies(request, response) {
    const responseCookies = Reflect.get(response, kSetCookie);
    if (responseCookies) {
      cookieStore.setCookie(responseCookies, request.url);
    }
  }

  // src/core/utils/handleRequest.ts
  async function handleRequest(request, requestId, handlers, options, emitter, handleRequestOptions) {
    emitter.emit("request:start", { request, requestId });
    if (request.headers.get("accept")?.includes("msw/passthrough")) {
      emitter.emit("request:end", { request, requestId });
      handleRequestOptions?.onPassthroughResponse?.(request);
      return;
    }
    const lookupResult = await until(() => {
      return executeHandlers({
        request,
        requestId,
        handlers,
        resolutionContext: handleRequestOptions?.resolutionContext
      });
    });
    if (lookupResult.error) {
      emitter.emit("unhandledException", {
        error: lookupResult.error,
        request,
        requestId
      });
      throw lookupResult.error;
    }
    if (!lookupResult.data) {
      await onUnhandledRequest(request, options.onUnhandledRequest);
      emitter.emit("request:unhandled", { request, requestId });
      emitter.emit("request:end", { request, requestId });
      handleRequestOptions?.onPassthroughResponse?.(request);
      return;
    }
    const { response } = lookupResult.data;
    if (!response) {
      emitter.emit("request:end", { request, requestId });
      handleRequestOptions?.onPassthroughResponse?.(request);
      return;
    }
    if (response.status === 302 && response.headers.get("x-msw-intention") === "passthrough") {
      emitter.emit("request:end", { request, requestId });
      handleRequestOptions?.onPassthroughResponse?.(request);
      return;
    }
    storeResponseCookies(request, response);
    emitter.emit("request:match", { request, requestId });
    const requiredLookupResult = lookupResult.data;
    handleRequestOptions?.onMockedResponse?.(response, requiredLookupResult);
    emitter.emit("request:end", { request, requestId });
    return response;
  }

  // src/core/getResponse.ts
  var getResponse = async (handlers, request) => {
    const result = await executeHandlers({
      request,
      requestId: createRequestId(),
      handlers
    });
    return result?.response;
  };

  // src/core/HttpResponse.ts
  var bodyType = Symbol("bodyType");
  var HttpResponse = class _HttpResponse extends FetchResponse {
    [bodyType];
    constructor(body, init) {
      const responseInit = normalizeResponseInit(init);
      super(body, responseInit);
      decorateResponse(this, responseInit);
    }
    /**
     * Create a `Response` with a `Content-Type: "text/plain"` body.
     * @example
     * HttpResponse.text('hello world')
     * HttpResponse.text('Error', { status: 500 })
     */
    static text(body, init) {
      const responseInit = normalizeResponseInit(init);
      if (!responseInit.headers.has("Content-Type")) {
        responseInit.headers.set("Content-Type", "text/plain");
      }
      if (!responseInit.headers.has("Content-Length")) {
        responseInit.headers.set(
          "Content-Length",
          body ? new Blob([body]).size.toString() : "0"
        );
      }
      return new _HttpResponse(body, responseInit);
    }
    /**
     * Create a `Response` with a `Content-Type: "application/json"` body.
     * @example
     * HttpResponse.json({ firstName: 'John' })
     * HttpResponse.json({ error: 'Not Authorized' }, { status: 401 })
     */
    static json(body, init) {
      const responseInit = normalizeResponseInit(init);
      if (!responseInit.headers.has("Content-Type")) {
        responseInit.headers.set("Content-Type", "application/json");
      }
      const responseText = JSON.stringify(body);
      if (!responseInit.headers.has("Content-Length")) {
        responseInit.headers.set(
          "Content-Length",
          responseText ? new Blob([responseText]).size.toString() : "0"
        );
      }
      return new _HttpResponse(
        responseText,
        responseInit
      );
    }
    /**
     * Create a `Response` with a `Content-Type: "application/xml"` body.
     * @example
     * HttpResponse.xml(`<user name="John" />`)
     * HttpResponse.xml(`<article id="abc-123" />`, { status: 201 })
     */
    static xml(body, init) {
      const responseInit = normalizeResponseInit(init);
      if (!responseInit.headers.has("Content-Type")) {
        responseInit.headers.set("Content-Type", "text/xml");
      }
      return new _HttpResponse(body, responseInit);
    }
    /**
     * Create a `Response` with a `Content-Type: "text/html"` body.
     * @example
     * HttpResponse.html(`<p class="author">Jane Doe</p>`)
     * HttpResponse.html(`<main id="abc-123">Main text</main>`, { status: 201 })
     */
    static html(body, init) {
      const responseInit = normalizeResponseInit(init);
      if (!responseInit.headers.has("Content-Type")) {
        responseInit.headers.set("Content-Type", "text/html");
      }
      return new _HttpResponse(body, responseInit);
    }
    /**
     * Create a `Response` with an `ArrayBuffer` body.
     * @example
     * const buffer = new ArrayBuffer(3)
     * const view = new Uint8Array(buffer)
     * view.set([1, 2, 3])
     *
     * HttpResponse.arrayBuffer(buffer)
     */
    static arrayBuffer(body, init) {
      const responseInit = normalizeResponseInit(init);
      if (!responseInit.headers.has("Content-Type")) {
        responseInit.headers.set("Content-Type", "application/octet-stream");
      }
      if (body && !responseInit.headers.has("Content-Length")) {
        responseInit.headers.set("Content-Length", body.byteLength.toString());
      }
      return new _HttpResponse(body, responseInit);
    }
    /**
     * Create a `Response` with a `FormData` body.
     * @example
     * const data = new FormData()
     * data.set('name', 'Alice')
     *
     * HttpResponse.formData(data)
     */
    static formData(body, init) {
      return new _HttpResponse(body, normalizeResponseInit(init));
    }
  };

  // src/core/delay.ts
  var SET_TIMEOUT_MAX_ALLOWED_INT = 2147483647;
  var MIN_SERVER_RESPONSE_TIME = 100;
  var MAX_SERVER_RESPONSE_TIME = 400;
  var NODE_SERVER_RESPONSE_TIME = 5;
  function getRealisticResponseTime() {
    if (isNodeProcess()) {
      return NODE_SERVER_RESPONSE_TIME;
    }
    return Math.floor(
      Math.random() * (MAX_SERVER_RESPONSE_TIME - MIN_SERVER_RESPONSE_TIME) + MIN_SERVER_RESPONSE_TIME
    );
  }
  async function delay(durationOrMode) {
    let delayTime;
    if (typeof durationOrMode === "string") {
      switch (durationOrMode) {
        case "infinite": {
          delayTime = SET_TIMEOUT_MAX_ALLOWED_INT;
          break;
        }
        case "real": {
          delayTime = getRealisticResponseTime();
          break;
        }
        default: {
          throw new Error(
            `Failed to delay a response: unknown delay mode "${durationOrMode}". Please make sure you provide one of the supported modes ("real", "infinite") or a number.`
          );
        }
      }
    } else if (typeof durationOrMode === "undefined") {
      delayTime = getRealisticResponseTime();
    } else {
      if (durationOrMode > SET_TIMEOUT_MAX_ALLOWED_INT) {
        throw new Error(
          `Failed to delay a response: provided delay duration (${durationOrMode}) exceeds the maximum allowed duration for "setTimeout" (${SET_TIMEOUT_MAX_ALLOWED_INT}). This will cause the response to be returned immediately. Please use a number within the allowed range to delay the response by exact duration, or consider the "infinite" delay mode to delay the response indefinitely.`
        );
      }
      delayTime = durationOrMode;
    }
    return new Promise((resolve) => setTimeout(resolve, delayTime));
  }

  // src/core/bypass.ts
  function bypass(input, init) {
    const request = new Request(
      // If given a Request instance, clone it not to exhaust
      // the original request's body.
      input instanceof Request ? input.clone() : input,
      init
    );
    invariant(
      !request.bodyUsed,
      'Failed to create a bypassed request to "%s %s": given request instance already has its body read. Make sure to clone the intercepted request if you wish to read its body before bypassing it.',
      request.method,
      request.url
    );
    const requestClone = request.clone();
    requestClone.headers.append("accept", "msw/passthrough");
    return requestClone;
  }

  // src/core/passthrough.ts
  function passthrough() {
    return new Response(null, {
      status: 302,
      statusText: "Passthrough",
      headers: {
        "x-msw-intention": "passthrough"
      }
    });
  }

  // src/core/index.ts
  checkGlobals();

  // src/browser/utils/getAbsoluteWorkerUrl.ts
  function getAbsoluteWorkerUrl(workerUrl) {
    return new URL(workerUrl, location.href).href;
  }

  // src/browser/setupWorker/start/utils/getWorkerByRegistration.ts
  function getWorkerByRegistration(registration, absoluteWorkerUrl, findWorker) {
    const allStates = [
      registration.active,
      registration.installing,
      registration.waiting
    ];
    const relevantStates = allStates.filter((state) => {
      return state != null;
    });
    const worker = relevantStates.find((worker2) => {
      return findWorker(worker2.scriptURL, absoluteWorkerUrl);
    });
    return worker || null;
  }

  // src/browser/setupWorker/start/utils/getWorkerInstance.ts
  var getWorkerInstance = async (url, options = {}, findWorker) => {
    const absoluteWorkerUrl = getAbsoluteWorkerUrl(url);
    const mockRegistrations = await navigator.serviceWorker.getRegistrations().then(
      (registrations) => registrations.filter(
        (registration) => getWorkerByRegistration(registration, absoluteWorkerUrl, findWorker)
      )
    );
    if (!navigator.serviceWorker.controller && mockRegistrations.length > 0) {
      location.reload();
    }
    const [existingRegistration] = mockRegistrations;
    if (existingRegistration) {
      existingRegistration.update();
      return [
        getWorkerByRegistration(
          existingRegistration,
          absoluteWorkerUrl,
          findWorker
        ),
        existingRegistration
      ];
    }
    const registrationResult = await until(
      async () => {
        const registration = await navigator.serviceWorker.register(url, options);
        return [
          // Compare existing worker registration by its worker URL,
          // to prevent irrelevant workers to resolve here (such as Codesandbox worker).
          getWorkerByRegistration(registration, absoluteWorkerUrl, findWorker),
          registration
        ];
      }
    );
    if (registrationResult.error) {
      const isWorkerMissing = registrationResult.error.message.includes("(404)");
      if (isWorkerMissing) {
        const scopeUrl = new URL(options?.scope || "/", location.href);
        throw new Error(
          devUtils.formatMessage(`Failed to register a Service Worker for scope ('${scopeUrl.href}') with script ('${absoluteWorkerUrl}'): Service Worker script does not exist at the given path.

Did you forget to run "npx msw init <PUBLIC_DIR>"?

Learn more about creating the Service Worker script: https://mswjs.io/docs/cli/init`)
        );
      }
      throw new Error(
        devUtils.formatMessage(
          "Failed to register the Service Worker:\n\n%s",
          registrationResult.error.message
        )
      );
    }
    return registrationResult.data;
  };

  // src/browser/setupWorker/start/utils/printStartMessage.ts
  function printStartMessage(args = {}) {
    if (args.quiet) {
      return;
    }
    const message3 = args.message || "Mocking enabled.";
    console.groupCollapsed(
      `%c${devUtils.formatMessage(message3)}`,
      "color:orangered;font-weight:bold;"
    );
    console.log(
      "%cDocumentation: %chttps://mswjs.io/docs",
      "font-weight:bold",
      "font-weight:normal"
    );
    console.log("Found an issue? https://github.com/mswjs/msw/issues");
    if (args.workerUrl) {
      console.log("Worker script URL:", args.workerUrl);
    }
    if (args.workerScope) {
      console.log("Worker scope:", args.workerScope);
    }
    if (args.client) {
      console.log("Client ID: %s (%s)", args.client.id, args.client.frameType);
    }
    console.groupEnd();
  }

  // src/browser/setupWorker/start/utils/enableMocking.ts
  async function enableMocking(context, options) {
    context.workerChannel.send("MOCK_ACTIVATE");
    const { payload } = await context.events.once("MOCKING_ENABLED");
    if (context.isMockingEnabled) {
      devUtils.warn(
        `Found a redundant "worker.start()" call. Note that starting the worker while mocking is already enabled will have no effect. Consider removing this "worker.start()" call.`
      );
      return;
    }
    context.isMockingEnabled = true;
    printStartMessage({
      quiet: options.quiet,
      workerScope: context.registration?.scope,
      workerUrl: context.worker?.scriptURL,
      client: payload.client
    });
  }

  // src/browser/setupWorker/start/utils/createMessageChannel.ts
  var WorkerChannel = class {
    constructor(port) {
      this.port = port;
    }
    postMessage(event, ...rest) {
      const [data, transfer] = rest;
      this.port.postMessage({ type: event, data }, { transfer });
    }
  };

  // src/browser/utils/pruneGetRequestBody.ts
  function pruneGetRequestBody(request) {
    if (["HEAD", "GET"].includes(request.method)) {
      return void 0;
    }
    return request.body;
  }

  // src/browser/utils/parseWorkerRequest.ts
  function parseWorkerRequest(incomingRequest) {
    return new Request(incomingRequest.url, {
      ...incomingRequest,
      body: pruneGetRequestBody(incomingRequest)
    });
  }

  // src/core/utils/toResponseInit.ts
  function toResponseInit(response) {
    return {
      status: response.status,
      statusText: response.statusText,
      headers: Object.fromEntries(response.headers.entries())
    };
  }

  // src/core/utils/internal/isHandlerKind.ts
  function isHandlerKind(kind) {
    return (input) => {
      return input != null && typeof input === "object" && "__kind" in input && input.__kind === kind;
    };
  }

  // src/browser/setupWorker/start/createRequestListener.ts
  var createRequestListener = (context, options) => {
    return async (event, message3) => {
      const messageChannel = new WorkerChannel(event.ports[0]);
      const requestId = message3.payload.id;
      const request = parseWorkerRequest(message3.payload);
      const requestCloneForLogs = request.clone();
      const requestClone = request.clone();
      RequestHandler.cache.set(request, requestClone);
      context.requests.set(requestId, requestClone);
      try {
        await handleRequest(
          request,
          requestId,
          context.getRequestHandlers().filter(isHandlerKind("RequestHandler")),
          options,
          context.emitter,
          {
            onPassthroughResponse() {
              messageChannel.postMessage("PASSTHROUGH");
            },
            async onMockedResponse(response, { handler, parsedResult }) {
              const responseClone = response.clone();
              const responseCloneForLogs = response.clone();
              const responseInit = toResponseInit(response);
              if (context.supports.readableStreamTransfer) {
                const responseStreamOrNull = response.body;
                messageChannel.postMessage(
                  "MOCK_RESPONSE",
                  {
                    ...responseInit,
                    body: responseStreamOrNull
                  },
                  responseStreamOrNull ? [responseStreamOrNull] : void 0
                );
              } else {
                const responseBufferOrNull = response.body === null ? null : await responseClone.arrayBuffer();
                messageChannel.postMessage("MOCK_RESPONSE", {
                  ...responseInit,
                  body: responseBufferOrNull
                });
              }
              if (!options.quiet) {
                context.emitter.once("response:mocked", () => {
                  handler.log({
                    request: requestCloneForLogs,
                    response: responseCloneForLogs,
                    parsedResult
                  });
                });
              }
            }
          }
        );
      } catch (error3) {
        if (error3 instanceof Error) {
          devUtils.error(
            `Uncaught exception in the request handler for "%s %s":

%s

This exception has been gracefully handled as a 500 response, however, it's strongly recommended to resolve this error, as it indicates a mistake in your code. If you wish to mock an error response, please see this guide: https://mswjs.io/docs/recipes/mocking-error-responses`,
            request.method,
            request.url,
            error3.stack ?? error3
          );
          messageChannel.postMessage("MOCK_RESPONSE", {
            status: 500,
            statusText: "Request Handler Error",
            headers: {
              "Content-Type": "application/json"
            },
            body: JSON.stringify({
              name: error3.name,
              message: error3.message,
              stack: error3.stack
            })
          });
        }
      }
    };
  };

  // src/browser/utils/checkWorkerIntegrity.ts
  async function checkWorkerIntegrity(context) {
    context.workerChannel.send("INTEGRITY_CHECK_REQUEST");
    const { payload } = await context.events.once("INTEGRITY_CHECK_RESPONSE");
    if (payload.checksum !== "00729d72e3b82faf54ca8b9621dbb96f") {
      devUtils.warn(
        `The currently registered Service Worker has been generated by a different version of MSW (${payload.packageVersion}) and may not be fully compatible with the installed version.

It's recommended you update your worker script by running this command:

  \u2022 npx msw init <PUBLIC_DIR>

You can also automate this process and make the worker script update automatically upon the library installations. Read more: https://mswjs.io/docs/cli/init.`
      );
    }
  }

  // src/browser/setupWorker/start/createResponseListener.ts
  function createResponseListener(context) {
    return (_, message3) => {
      const { payload: responseJson } = message3;
      const { requestId } = responseJson;
      const request = context.requests.get(requestId);
      context.requests.delete(requestId);
      if (responseJson.type?.includes("opaque")) {
        return;
      }
      const response = responseJson.status === 0 ? Response.error() : new FetchResponse(
        /**
         * Responses may be streams here, but when we create a response object
         * with null-body status codes, like 204, 205, 304 Response will
         * throw when passed a non-null body, so ensure it's null here
         * for those codes
         */
        FetchResponse.isResponseWithBody(responseJson.status) ? responseJson.body : null,
        {
          ...responseJson,
          /**
           * Set response URL if it's not set already.
           * @see https://github.com/mswjs/msw/issues/2030
           * @see https://developer.mozilla.org/en-US/docs/Web/API/Response/url
           */
          url: request.url
        }
      );
      context.emitter.emit(
        responseJson.isMockedResponse ? "response:mocked" : "response:bypass",
        {
          response,
          request,
          requestId: responseJson.requestId
        }
      );
    };
  }

  // src/browser/setupWorker/start/utils/validateWorkerScope.ts
  function validateWorkerScope(registration, options) {
    if (!options?.quiet && !location.href.startsWith(registration.scope)) {
      devUtils.warn(
        `Cannot intercept requests on this page because it's outside of the worker's scope ("${registration.scope}"). If you wish to mock API requests on this page, you must resolve this scope issue.

- (Recommended) Register the worker at the root level ("/") of your application.
- Set the "Service-Worker-Allowed" response header to allow out-of-scope workers.`
      );
    }
  }

  // src/browser/setupWorker/start/createStartHandler.ts
  var createStartHandler = (context) => {
    return function start(options, customOptions) {
      const startWorkerInstance = async () => {
        context.events.removeAllListeners();
        context.workerChannel.on(
          "REQUEST",
          createRequestListener(context, options)
        );
        context.workerChannel.on("RESPONSE", createResponseListener(context));
        const instance = await getWorkerInstance(
          options.serviceWorker.url,
          options.serviceWorker.options,
          options.findWorker
        );
        const [worker, registration] = instance;
        if (!worker) {
          const missingWorkerMessage = customOptions?.findWorker ? devUtils.formatMessage(
            `Failed to locate the Service Worker registration using a custom "findWorker" predicate.

Please ensure that the custom predicate properly locates the Service Worker registration at "%s".
More details: https://mswjs.io/docs/api/setup-worker/start#findworker
`,
            options.serviceWorker.url
          ) : devUtils.formatMessage(
            `Failed to locate the Service Worker registration.

This most likely means that the worker script URL "%s" cannot resolve against the actual public hostname (%s). This may happen if your application runs behind a proxy, or has a dynamic hostname.

Please consider using a custom "serviceWorker.url" option to point to the actual worker script location, or a custom "findWorker" option to resolve the Service Worker registration manually. More details: https://mswjs.io/docs/api/setup-worker/start`,
            options.serviceWorker.url,
            location.host
          );
          throw new Error(missingWorkerMessage);
        }
        context.worker = worker;
        context.registration = registration;
        context.events.addListener(window, "beforeunload", () => {
          if (worker.state !== "redundant") {
            context.workerChannel.send("CLIENT_CLOSED");
          }
          window.clearInterval(context.keepAliveInterval);
          window.postMessage({ type: "msw/worker:stop" });
        });
        await checkWorkerIntegrity(context).catch((error3) => {
          devUtils.error(
            "Error while checking the worker script integrity. Please report this on GitHub (https://github.com/mswjs/msw/issues), including the original error below."
          );
          console.error(error3);
        });
        context.keepAliveInterval = window.setInterval(
          () => context.workerChannel.send("KEEPALIVE_REQUEST"),
          5e3
        );
        validateWorkerScope(registration, context.startOptions);
        return registration;
      };
      const workerRegistration = startWorkerInstance().then(
        async (registration) => {
          const pendingInstance = registration.installing || registration.waiting;
          if (pendingInstance) {
            await new Promise((resolve) => {
              pendingInstance.addEventListener("statechange", () => {
                if (pendingInstance.state === "activated") {
                  return resolve();
                }
              });
            });
          }
          await enableMocking(context, options).catch((error3) => {
            throw new Error(`Failed to enable mocking: ${error3?.message}`);
          });
          return registration;
        }
      );
      return workerRegistration;
    };
  };

  // src/browser/setupWorker/stop/utils/printStopMessage.ts
  function printStopMessage(args = {}) {
    if (args.quiet) {
      return;
    }
    console.log(
      `%c${devUtils.formatMessage("Mocking disabled.")}`,
      "color:orangered;font-weight:bold;"
    );
  }

  // src/browser/setupWorker/stop/createStop.ts
  var createStop = (context) => {
    return function stop() {
      if (!context.isMockingEnabled) {
        devUtils.warn(
          'Found a redundant "worker.stop()" call. Note that stopping the worker while mocking already stopped has no effect. Consider removing this "worker.stop()" call.'
        );
        return;
      }
      context.workerChannel.send("MOCK_DEACTIVATE");
      context.isMockingEnabled = false;
      window.clearInterval(context.keepAliveInterval);
      window.postMessage({ type: "msw/worker:stop" });
      printStopMessage({ quiet: context.startOptions?.quiet });
    };
  };

  // src/core/utils/internal/isObject.ts
  function isObject(value) {
    return value != null && typeof value === "object" && !Array.isArray(value);
  }

  // src/core/utils/internal/mergeRight.ts
  function mergeRight(left, right) {
    return Object.entries(right).reduce(
      (result, [key, rightValue]) => {
        const leftValue = result[key];
        if (Array.isArray(leftValue) && Array.isArray(rightValue)) {
          result[key] = leftValue.concat(rightValue);
          return result;
        }
        if (isObject(leftValue) && isObject(rightValue)) {
          result[key] = mergeRight(leftValue, rightValue);
          return result;
        }
        result[key] = rightValue;
        return result;
      },
      Object.assign({}, left)
    );
  }

  // src/browser/setupWorker/start/utils/prepareStartHandler.ts
  var DEFAULT_START_OPTIONS = {
    serviceWorker: {
      url: "/mockServiceWorker.js",
      options: null
    },
    quiet: false,
    waitUntilReady: true,
    onUnhandledRequest: "warn",
    findWorker(scriptURL, mockServiceWorkerUrl) {
      return scriptURL === mockServiceWorkerUrl;
    }
  };

  // node_modules/.pnpm/@mswjs+interceptors@0.37.1/node_modules/@mswjs/interceptors/lib/browser/chunk-H5O73WD2.mjs
  var InterceptorError = class extends Error {
    constructor(message3) {
      super(message3);
      this.name = "InterceptorError";
      Object.setPrototypeOf(this, InterceptorError.prototype);
    }
  };
  var kRequestHandled = Symbol("kRequestHandled");
  var kResponsePromise = Symbol("kResponsePromise");
  var RequestController = class {
    constructor(request) {
      this.request = request;
      this[kRequestHandled] = false;
      this[kResponsePromise] = new DeferredPromise();
    }
    /**
     * Respond to this request with the given `Response` instance.
     * @example
     * controller.respondWith(new Response())
     * controller.respondWith(Response.json({ id }))
     * controller.respondWith(Response.error())
     */
    respondWith(response) {
      invariant.as(
        InterceptorError,
        !this[kRequestHandled],
        'Failed to respond to the "%s %s" request: the "request" event has already been handled.',
        this.request.method,
        this.request.url
      );
      this[kRequestHandled] = true;
      this[kResponsePromise].resolve(response);
    }
    /**
     * Error this request with the given error.
     * @example
     * controller.errorWith()
     * controller.errorWith(new Error('Oops!'))
     */
    errorWith(error3) {
      invariant.as(
        InterceptorError,
        !this[kRequestHandled],
        'Failed to error the "%s %s" request: the "request" event has already been handled.',
        this.request.method,
        this.request.url
      );
      this[kRequestHandled] = true;
      this[kResponsePromise].resolve(error3);
    }
  };
  async function emitAsync(emitter, eventName, ...data) {
    const listners = emitter.listeners(eventName);
    if (listners.length === 0) {
      return;
    }
    for (const listener of listners) {
      await listener.apply(emitter, data);
    }
  }
  function isPropertyAccessible(obj, key) {
    try {
      obj[key];
      return true;
    } catch (e) {
      return false;
    }
  }
  function createServerErrorResponse(body) {
    return new Response(
      JSON.stringify(
        body instanceof Error ? {
          name: body.name,
          message: body.message,
          stack: body.stack
        } : body
      ),
      {
        status: 500,
        statusText: "Unhandled Exception",
        headers: {
          "Content-Type": "application/json"
        }
      }
    );
  }
  function isResponseError(response) {
    return isPropertyAccessible(response, "type") && response.type === "error";
  }
  function isNodeLikeError(error3) {
    if (error3 == null) {
      return false;
    }
    if (!(error3 instanceof Error)) {
      return false;
    }
    return "code" in error3 && "errno" in error3;
  }
  async function handleRequest2(options) {
    const handleResponse = async (response) => {
      if (response instanceof Error) {
        options.onError(response);
      } else if (isResponseError(response)) {
        options.onRequestError(response);
      } else {
        await options.onResponse(response);
      }
      return true;
    };
    const handleResponseError = async (error3) => {
      if (error3 instanceof InterceptorError) {
        throw result.error;
      }
      if (isNodeLikeError(error3)) {
        options.onError(error3);
        return true;
      }
      if (error3 instanceof Response) {
        return await handleResponse(error3);
      }
      return false;
    };
    options.emitter.once("request", ({ requestId: pendingRequestId }) => {
      if (pendingRequestId !== options.requestId) {
        return;
      }
      if (options.controller[kResponsePromise].state === "pending") {
        options.controller[kResponsePromise].resolve(void 0);
      }
    });
    const requestAbortPromise = new DeferredPromise();
    if (options.request.signal) {
      if (options.request.signal.aborted) {
        requestAbortPromise.reject(options.request.signal.reason);
      } else {
        options.request.signal.addEventListener(
          "abort",
          () => {
            requestAbortPromise.reject(options.request.signal.reason);
          },
          { once: true }
        );
      }
    }
    const result = await until(async () => {
      const requestListtenersPromise = emitAsync(options.emitter, "request", {
        requestId: options.requestId,
        request: options.request,
        controller: options.controller
      });
      await Promise.race([
        // Short-circuit the request handling promise if the request gets aborted.
        requestAbortPromise,
        requestListtenersPromise,
        options.controller[kResponsePromise]
      ]);
      const mockedResponse = await options.controller[kResponsePromise];
      return mockedResponse;
    });
    if (requestAbortPromise.state === "rejected") {
      options.onError(requestAbortPromise.rejectionReason);
      return true;
    }
    if (result.error) {
      if (await handleResponseError(result.error)) {
        return true;
      }
      if (options.emitter.listenerCount("unhandledException") > 0) {
        const unhandledExceptionController = new RequestController(
          options.request
        );
        await emitAsync(options.emitter, "unhandledException", {
          error: result.error,
          request: options.request,
          requestId: options.requestId,
          controller: unhandledExceptionController
        }).then(() => {
          if (unhandledExceptionController[kResponsePromise].state === "pending") {
            unhandledExceptionController[kResponsePromise].resolve(void 0);
          }
        });
        const nextResult = await until(
          () => unhandledExceptionController[kResponsePromise]
        );
        if (nextResult.error) {
          return handleResponseError(nextResult.error);
        }
        if (nextResult.data) {
          return handleResponse(nextResult.data);
        }
      }
      options.onResponse(createServerErrorResponse(result.error));
      return true;
    }
    if (result.data) {
      return handleResponse(result.data);
    }
    return false;
  }

  // node_modules/.pnpm/@mswjs+interceptors@0.37.1/node_modules/@mswjs/interceptors/lib/browser/chunk-TX5GBTFY.mjs
  function hasConfigurableGlobal(propertyName) {
    const descriptor = Object.getOwnPropertyDescriptor(globalThis, propertyName);
    if (typeof descriptor === "undefined") {
      return false;
    }
    if (typeof descriptor.get === "function" && typeof descriptor.get() === "undefined") {
      return false;
    }
    if (typeof descriptor.get === "undefined" && descriptor.value == null) {
      return false;
    }
    if (typeof descriptor.set === "undefined" && !descriptor.configurable) {
      console.error(
        `[MSW] Failed to apply interceptor: the global \`${propertyName}\` property is non-configurable. This is likely an issue with your environment. If you are using a framework, please open an issue about this in their repository.`
      );
      return false;
    }
    return true;
  }

  // node_modules/.pnpm/@mswjs+interceptors@0.37.1/node_modules/@mswjs/interceptors/lib/browser/chunk-HER3NHBG.mjs
  function canParseUrl(url) {
    try {
      new URL(url);
      return true;
    } catch (_error) {
      return false;
    }
  }
  function createNetworkError(cause) {
    return Object.assign(new TypeError("Failed to fetch"), {
      cause
    });
  }
  var REQUEST_BODY_HEADERS = [
    "content-encoding",
    "content-language",
    "content-location",
    "content-type",
    "content-length"
  ];
  var kRedirectCount = Symbol("kRedirectCount");
  async function followFetchRedirect(request, response) {
    if (response.status !== 303 && request.body != null) {
      return Promise.reject(createNetworkError());
    }
    const requestUrl = new URL(request.url);
    let locationUrl;
    try {
      locationUrl = new URL(response.headers.get("location"), request.url);
    } catch (error3) {
      return Promise.reject(createNetworkError(error3));
    }
    if (!(locationUrl.protocol === "http:" || locationUrl.protocol === "https:")) {
      return Promise.reject(
        createNetworkError("URL scheme must be a HTTP(S) scheme")
      );
    }
    if (Reflect.get(request, kRedirectCount) > 20) {
      return Promise.reject(createNetworkError("redirect count exceeded"));
    }
    Object.defineProperty(request, kRedirectCount, {
      value: (Reflect.get(request, kRedirectCount) || 0) + 1
    });
    if (request.mode === "cors" && (locationUrl.username || locationUrl.password) && !sameOrigin(requestUrl, locationUrl)) {
      return Promise.reject(
        createNetworkError('cross origin not allowed for request mode "cors"')
      );
    }
    const requestInit = {};
    if ([301, 302].includes(response.status) && request.method === "POST" || response.status === 303 && !["HEAD", "GET"].includes(request.method)) {
      requestInit.method = "GET";
      requestInit.body = null;
      REQUEST_BODY_HEADERS.forEach((headerName) => {
        request.headers.delete(headerName);
      });
    }
    if (!sameOrigin(requestUrl, locationUrl)) {
      request.headers.delete("authorization");
      request.headers.delete("proxy-authorization");
      request.headers.delete("cookie");
      request.headers.delete("host");
    }
    requestInit.headers = request.headers;
    return fetch(new Request(locationUrl, requestInit));
  }
  function sameOrigin(left, right) {
    if (left.origin === right.origin && left.origin === "null") {
      return true;
    }
    if (left.protocol === right.protocol && left.hostname === right.hostname && left.port === right.port) {
      return true;
    }
    return false;
  }
  var BrotliDecompressionStream = class extends TransformStream {
    constructor() {
      console.warn(
        "[Interceptors]: Brotli decompression of response streams is not supported in the browser"
      );
      super({
        transform(chunk, controller) {
          controller.enqueue(chunk);
        }
      });
    }
  };
  var PipelineStream = class extends TransformStream {
    constructor(transformStreams, ...strategies) {
      super({}, ...strategies);
      const readable = [super.readable, ...transformStreams].reduce(
        (readable2, transform) => readable2.pipeThrough(transform)
      );
      Object.defineProperty(this, "readable", {
        get() {
          return readable;
        }
      });
    }
  };
  function parseContentEncoding(contentEncoding) {
    return contentEncoding.toLowerCase().split(",").map((coding) => coding.trim());
  }
  function createDecompressionStream(contentEncoding) {
    if (contentEncoding === "") {
      return null;
    }
    const codings = parseContentEncoding(contentEncoding);
    if (codings.length === 0) {
      return null;
    }
    const transformers = codings.reduceRight(
      (transformers2, coding) => {
        if (coding === "gzip" || coding === "x-gzip") {
          return transformers2.concat(new DecompressionStream("gzip"));
        } else if (coding === "deflate") {
          return transformers2.concat(new DecompressionStream("deflate"));
        } else if (coding === "br") {
          return transformers2.concat(new BrotliDecompressionStream());
        } else {
          transformers2.length = 0;
        }
        return transformers2;
      },
      []
    );
    return new PipelineStream(transformers);
  }
  function decompressResponse(response) {
    if (response.body === null) {
      return null;
    }
    const decompressionStream = createDecompressionStream(
      response.headers.get("content-encoding") || ""
    );
    if (!decompressionStream) {
      return null;
    }
    response.body.pipeTo(decompressionStream.writable);
    return decompressionStream.readable;
  }
  var _FetchInterceptor = class extends Interceptor {
    constructor() {
      super(_FetchInterceptor.symbol);
    }
    checkEnvironment() {
      return hasConfigurableGlobal("fetch");
    }
    async setup() {
      const pureFetch = globalThis.fetch;
      invariant(
        !pureFetch[IS_PATCHED_MODULE],
        'Failed to patch the "fetch" module: already patched.'
      );
      globalThis.fetch = async (input, init) => {
        const requestId = createRequestId();
        const resolvedInput = typeof input === "string" && typeof location !== "undefined" && !canParseUrl(input) ? new URL(input, location.origin) : input;
        const request = new Request(resolvedInput, init);
        const responsePromise = new DeferredPromise();
        const controller = new RequestController(request);
        this.logger.info("[%s] %s", request.method, request.url);
        this.logger.info("awaiting for the mocked response...");
        this.logger.info(
          'emitting the "request" event for %s listener(s)...',
          this.emitter.listenerCount("request")
        );
        const isRequestHandled = await handleRequest2({
          request,
          requestId,
          emitter: this.emitter,
          controller,
          onResponse: async (rawResponse) => {
            this.logger.info("received mocked response!", {
              rawResponse
            });
            const decompressedStream = decompressResponse(rawResponse);
            const response = decompressedStream === null ? rawResponse : new FetchResponse(decompressedStream, rawResponse);
            FetchResponse.setUrl(request.url, response);
            if (FetchResponse.isRedirectResponse(response.status)) {
              if (request.redirect === "error") {
                responsePromise.reject(createNetworkError("unexpected redirect"));
                return;
              }
              if (request.redirect === "follow") {
                followFetchRedirect(request, response).then(
                  (response2) => {
                    responsePromise.resolve(response2);
                  },
                  (reason) => {
                    responsePromise.reject(reason);
                  }
                );
                return;
              }
            }
            if (this.emitter.listenerCount("response") > 0) {
              this.logger.info('emitting the "response" event...');
              await emitAsync(this.emitter, "response", {
                // Clone the mocked response for the "response" event listener.
                // This way, the listener can read the response and not lock its body
                // for the actual fetch consumer.
                response: response.clone(),
                isMockedResponse: true,
                request,
                requestId
              });
            }
            responsePromise.resolve(response);
          },
          onRequestError: (response) => {
            this.logger.info("request has errored!", { response });
            responsePromise.reject(createNetworkError(response));
          },
          onError: (error3) => {
            this.logger.info("request has been aborted!", { error: error3 });
            responsePromise.reject(error3);
          }
        });
        if (isRequestHandled) {
          this.logger.info("request has been handled, returning mock promise...");
          return responsePromise;
        }
        this.logger.info(
          "no mocked response received, performing request as-is..."
        );
        return pureFetch(request).then(async (response) => {
          this.logger.info("original fetch performed", response);
          if (this.emitter.listenerCount("response") > 0) {
            this.logger.info('emitting the "response" event...');
            const responseClone = response.clone();
            await emitAsync(this.emitter, "response", {
              response: responseClone,
              isMockedResponse: false,
              request,
              requestId
            });
          }
          return response;
        });
      };
      Object.defineProperty(globalThis.fetch, IS_PATCHED_MODULE, {
        enumerable: true,
        configurable: true,
        value: true
      });
      this.subscriptions.push(() => {
        Object.defineProperty(globalThis.fetch, IS_PATCHED_MODULE, {
          value: void 0
        });
        globalThis.fetch = pureFetch;
        this.logger.info(
          'restored native "globalThis.fetch"!',
          globalThis.fetch.name
        );
      });
    }
  };
  var FetchInterceptor = _FetchInterceptor;
  FetchInterceptor.symbol = Symbol("fetch");

  // node_modules/.pnpm/@mswjs+interceptors@0.37.1/node_modules/@mswjs/interceptors/lib/browser/chunk-4SRQFK76.mjs
  function concatArrayBuffer(left, right) {
    const result = new Uint8Array(left.byteLength + right.byteLength);
    result.set(left, 0);
    result.set(right, left.byteLength);
    return result;
  }
  var EventPolyfill = class {
    constructor(type, options) {
      this.NONE = 0;
      this.CAPTURING_PHASE = 1;
      this.AT_TARGET = 2;
      this.BUBBLING_PHASE = 3;
      this.type = "";
      this.srcElement = null;
      this.currentTarget = null;
      this.eventPhase = 0;
      this.isTrusted = true;
      this.composed = false;
      this.cancelable = true;
      this.defaultPrevented = false;
      this.bubbles = true;
      this.lengthComputable = true;
      this.loaded = 0;
      this.total = 0;
      this.cancelBubble = false;
      this.returnValue = true;
      this.type = type;
      this.target = (options == null ? void 0 : options.target) || null;
      this.currentTarget = (options == null ? void 0 : options.currentTarget) || null;
      this.timeStamp = Date.now();
    }
    composedPath() {
      return [];
    }
    initEvent(type, bubbles, cancelable) {
      this.type = type;
      this.bubbles = !!bubbles;
      this.cancelable = !!cancelable;
    }
    preventDefault() {
      this.defaultPrevented = true;
    }
    stopPropagation() {
    }
    stopImmediatePropagation() {
    }
  };
  var ProgressEventPolyfill = class extends EventPolyfill {
    constructor(type, init) {
      super(type);
      this.lengthComputable = (init == null ? void 0 : init.lengthComputable) || false;
      this.composed = (init == null ? void 0 : init.composed) || false;
      this.loaded = (init == null ? void 0 : init.loaded) || 0;
      this.total = (init == null ? void 0 : init.total) || 0;
    }
  };
  var SUPPORTS_PROGRESS_EVENT = typeof ProgressEvent !== "undefined";
  function createEvent(target, type, init) {
    const progressEvents = [
      "error",
      "progress",
      "loadstart",
      "loadend",
      "load",
      "timeout",
      "abort"
    ];
    const ProgressEventClass = SUPPORTS_PROGRESS_EVENT ? ProgressEvent : ProgressEventPolyfill;
    const event = progressEvents.includes(type) ? new ProgressEventClass(type, {
      lengthComputable: true,
      loaded: (init == null ? void 0 : init.loaded) || 0,
      total: (init == null ? void 0 : init.total) || 0
    }) : new EventPolyfill(type, {
      target,
      currentTarget: target
    });
    return event;
  }
  function findPropertySource(target, propertyName) {
    if (!(propertyName in target)) {
      return null;
    }
    const hasProperty = Object.prototype.hasOwnProperty.call(target, propertyName);
    if (hasProperty) {
      return target;
    }
    const prototype = Reflect.getPrototypeOf(target);
    return prototype ? findPropertySource(prototype, propertyName) : null;
  }
  function createProxy(target, options) {
    const proxy = new Proxy(target, optionsToProxyHandler(options));
    return proxy;
  }
  function optionsToProxyHandler(options) {
    const { constructorCall, methodCall, getProperty, setProperty } = options;
    const handler = {};
    if (typeof constructorCall !== "undefined") {
      handler.construct = function(target, args, newTarget) {
        const next = Reflect.construct.bind(null, target, args, newTarget);
        return constructorCall.call(newTarget, args, next);
      };
    }
    handler.set = function(target, propertyName, nextValue) {
      const next = () => {
        const propertySource = findPropertySource(target, propertyName) || target;
        const ownDescriptors = Reflect.getOwnPropertyDescriptor(
          propertySource,
          propertyName
        );
        if (typeof (ownDescriptors == null ? void 0 : ownDescriptors.set) !== "undefined") {
          ownDescriptors.set.apply(target, [nextValue]);
          return true;
        }
        return Reflect.defineProperty(propertySource, propertyName, {
          writable: true,
          enumerable: true,
          configurable: true,
          value: nextValue
        });
      };
      if (typeof setProperty !== "undefined") {
        return setProperty.call(target, [propertyName, nextValue], next);
      }
      return next();
    };
    handler.get = function(target, propertyName, receiver) {
      const next = () => target[propertyName];
      const value = typeof getProperty !== "undefined" ? getProperty.call(target, [propertyName, receiver], next) : next();
      if (typeof value === "function") {
        return (...args) => {
          const next2 = value.bind(target, ...args);
          if (typeof methodCall !== "undefined") {
            return methodCall.call(target, [propertyName, args], next2);
          }
          return next2();
        };
      }
      return value;
    };
    return handler;
  }
  function isDomParserSupportedType(type) {
    const supportedTypes = [
      "application/xhtml+xml",
      "application/xml",
      "image/svg+xml",
      "text/html",
      "text/xml"
    ];
    return supportedTypes.some((supportedType) => {
      return type.startsWith(supportedType);
    });
  }
  function parseJson(data) {
    try {
      const json = JSON.parse(data);
      return json;
    } catch (_) {
      return null;
    }
  }
  function createResponse(request, body) {
    const responseBodyOrNull = FetchResponse.isResponseWithBody(request.status) ? body : null;
    return new FetchResponse(responseBodyOrNull, {
      url: request.responseURL,
      status: request.status,
      statusText: request.statusText,
      headers: createHeadersFromXMLHttpReqestHeaders(
        request.getAllResponseHeaders()
      )
    });
  }
  function createHeadersFromXMLHttpReqestHeaders(headersString) {
    const headers = new Headers();
    const lines = headersString.split(/[\r\n]+/);
    for (const line of lines) {
      if (line.trim() === "") {
        continue;
      }
      const [name, ...parts] = line.split(": ");
      const value = parts.join(": ");
      headers.append(name, value);
    }
    return headers;
  }
  async function getBodyByteLength(input) {
    const explicitContentLength = input.headers.get("content-length");
    if (explicitContentLength != null && explicitContentLength !== "") {
      return Number(explicitContentLength);
    }
    const buffer = await input.arrayBuffer();
    return buffer.byteLength;
  }
  var kIsRequestHandled = Symbol("kIsRequestHandled");
  var IS_NODE2 = isNodeProcess();
  var kFetchRequest = Symbol("kFetchRequest");
  var XMLHttpRequestController = class {
    constructor(initialRequest, logger) {
      this.initialRequest = initialRequest;
      this.logger = logger;
      this.method = "GET";
      this.url = null;
      this[kIsRequestHandled] = false;
      this.events = /* @__PURE__ */ new Map();
      this.uploadEvents = /* @__PURE__ */ new Map();
      this.requestId = createRequestId();
      this.requestHeaders = new Headers();
      this.responseBuffer = new Uint8Array();
      this.request = createProxy(initialRequest, {
        setProperty: ([propertyName, nextValue], invoke) => {
          switch (propertyName) {
            case "ontimeout": {
              const eventName = propertyName.slice(
                2
              );
              this.request.addEventListener(eventName, nextValue);
              return invoke();
            }
            default: {
              return invoke();
            }
          }
        },
        methodCall: ([methodName, args], invoke) => {
          var _a2;
          switch (methodName) {
            case "open": {
              const [method, url] = args;
              if (typeof url === "undefined") {
                this.method = "GET";
                this.url = toAbsoluteUrl(method);
              } else {
                this.method = method;
                this.url = toAbsoluteUrl(url);
              }
              this.logger = this.logger.extend(`${this.method} ${this.url.href}`);
              this.logger.info("open", this.method, this.url.href);
              return invoke();
            }
            case "addEventListener": {
              const [eventName, listener] = args;
              this.registerEvent(eventName, listener);
              this.logger.info("addEventListener", eventName, listener);
              return invoke();
            }
            case "setRequestHeader": {
              const [name, value] = args;
              this.requestHeaders.set(name, value);
              this.logger.info("setRequestHeader", name, value);
              return invoke();
            }
            case "send": {
              const [body] = args;
              this.request.addEventListener("load", () => {
                if (typeof this.onResponse !== "undefined") {
                  const fetchResponse = createResponse(
                    this.request,
                    /**
                     * The `response` property is the right way to read
                     * the ambiguous response body, as the request's "responseType" may differ.
                     * @see https://xhr.spec.whatwg.org/#the-response-attribute
                     */
                    this.request.response
                  );
                  this.onResponse.call(this, {
                    response: fetchResponse,
                    isMockedResponse: this[kIsRequestHandled],
                    request: fetchRequest,
                    requestId: this.requestId
                  });
                }
              });
              const requestBody = typeof body === "string" ? encodeBuffer(body) : body;
              const fetchRequest = this.toFetchApiRequest(requestBody);
              this[kFetchRequest] = fetchRequest.clone();
              const onceRequestSettled = ((_a2 = this.onRequest) == null ? void 0 : _a2.call(this, {
                request: fetchRequest,
                requestId: this.requestId
              })) || Promise.resolve();
              onceRequestSettled.finally(() => {
                if (!this[kIsRequestHandled]) {
                  this.logger.info(
                    "request callback settled but request has not been handled (readystate %d), performing as-is...",
                    this.request.readyState
                  );
                  if (IS_NODE2) {
                    this.request.setRequestHeader(
                      INTERNAL_REQUEST_ID_HEADER_NAME,
                      this.requestId
                    );
                  }
                  return invoke();
                }
              });
              break;
            }
            default: {
              return invoke();
            }
          }
        }
      });
      define(
        this.request,
        "upload",
        createProxy(this.request.upload, {
          setProperty: ([propertyName, nextValue], invoke) => {
            switch (propertyName) {
              case "onloadstart":
              case "onprogress":
              case "onaboart":
              case "onerror":
              case "onload":
              case "ontimeout":
              case "onloadend": {
                const eventName = propertyName.slice(
                  2
                );
                this.registerUploadEvent(eventName, nextValue);
              }
            }
            return invoke();
          },
          methodCall: ([methodName, args], invoke) => {
            switch (methodName) {
              case "addEventListener": {
                const [eventName, listener] = args;
                this.registerUploadEvent(eventName, listener);
                this.logger.info("upload.addEventListener", eventName, listener);
                return invoke();
              }
            }
          }
        })
      );
    }
    registerEvent(eventName, listener) {
      const prevEvents = this.events.get(eventName) || [];
      const nextEvents = prevEvents.concat(listener);
      this.events.set(eventName, nextEvents);
      this.logger.info('registered event "%s"', eventName, listener);
    }
    registerUploadEvent(eventName, listener) {
      const prevEvents = this.uploadEvents.get(eventName) || [];
      const nextEvents = prevEvents.concat(listener);
      this.uploadEvents.set(eventName, nextEvents);
      this.logger.info('registered upload event "%s"', eventName, listener);
    }
    /**
     * Responds to the current request with the given
     * Fetch API `Response` instance.
     */
    async respondWith(response) {
      this[kIsRequestHandled] = true;
      if (this[kFetchRequest]) {
        const totalRequestBodyLength = await getBodyByteLength(
          this[kFetchRequest]
        );
        this.trigger("loadstart", this.request.upload, {
          loaded: 0,
          total: totalRequestBodyLength
        });
        this.trigger("progress", this.request.upload, {
          loaded: totalRequestBodyLength,
          total: totalRequestBodyLength
        });
        this.trigger("load", this.request.upload, {
          loaded: totalRequestBodyLength,
          total: totalRequestBodyLength
        });
        this.trigger("loadend", this.request.upload, {
          loaded: totalRequestBodyLength,
          total: totalRequestBodyLength
        });
      }
      this.logger.info(
        "responding with a mocked response: %d %s",
        response.status,
        response.statusText
      );
      define(this.request, "status", response.status);
      define(this.request, "statusText", response.statusText);
      define(this.request, "responseURL", this.url.href);
      this.request.getResponseHeader = new Proxy(this.request.getResponseHeader, {
        apply: (_, __, args) => {
          this.logger.info("getResponseHeader", args[0]);
          if (this.request.readyState < this.request.HEADERS_RECEIVED) {
            this.logger.info("headers not received yet, returning null");
            return null;
          }
          const headerValue = response.headers.get(args[0]);
          this.logger.info(
            'resolved response header "%s" to',
            args[0],
            headerValue
          );
          return headerValue;
        }
      });
      this.request.getAllResponseHeaders = new Proxy(
        this.request.getAllResponseHeaders,
        {
          apply: () => {
            this.logger.info("getAllResponseHeaders");
            if (this.request.readyState < this.request.HEADERS_RECEIVED) {
              this.logger.info("headers not received yet, returning empty string");
              return "";
            }
            const headersList = Array.from(response.headers.entries());
            const allHeaders = headersList.map(([headerName, headerValue]) => {
              return `${headerName}: ${headerValue}`;
            }).join("\r\n");
            this.logger.info("resolved all response headers to", allHeaders);
            return allHeaders;
          }
        }
      );
      Object.defineProperties(this.request, {
        response: {
          enumerable: true,
          configurable: false,
          get: () => this.response
        },
        responseText: {
          enumerable: true,
          configurable: false,
          get: () => this.responseText
        },
        responseXML: {
          enumerable: true,
          configurable: false,
          get: () => this.responseXML
        }
      });
      const totalResponseBodyLength = await getBodyByteLength(response.clone());
      this.logger.info("calculated response body length", totalResponseBodyLength);
      this.trigger("loadstart", this.request, {
        loaded: 0,
        total: totalResponseBodyLength
      });
      this.setReadyState(this.request.HEADERS_RECEIVED);
      this.setReadyState(this.request.LOADING);
      const finalizeResponse = () => {
        this.logger.info("finalizing the mocked response...");
        this.setReadyState(this.request.DONE);
        this.trigger("load", this.request, {
          loaded: this.responseBuffer.byteLength,
          total: totalResponseBodyLength
        });
        this.trigger("loadend", this.request, {
          loaded: this.responseBuffer.byteLength,
          total: totalResponseBodyLength
        });
      };
      if (response.body) {
        this.logger.info("mocked response has body, streaming...");
        const reader = response.body.getReader();
        const readNextResponseBodyChunk = async () => {
          const { value, done } = await reader.read();
          if (done) {
            this.logger.info("response body stream done!");
            finalizeResponse();
            return;
          }
          if (value) {
            this.logger.info("read response body chunk:", value);
            this.responseBuffer = concatArrayBuffer(this.responseBuffer, value);
            this.trigger("progress", this.request, {
              loaded: this.responseBuffer.byteLength,
              total: totalResponseBodyLength
            });
          }
          readNextResponseBodyChunk();
        };
        readNextResponseBodyChunk();
      } else {
        finalizeResponse();
      }
    }
    responseBufferToText() {
      return decodeBuffer(this.responseBuffer);
    }
    get response() {
      this.logger.info(
        "getResponse (responseType: %s)",
        this.request.responseType
      );
      if (this.request.readyState !== this.request.DONE) {
        return null;
      }
      switch (this.request.responseType) {
        case "json": {
          const responseJson = parseJson(this.responseBufferToText());
          this.logger.info("resolved response JSON", responseJson);
          return responseJson;
        }
        case "arraybuffer": {
          const arrayBuffer = toArrayBuffer(this.responseBuffer);
          this.logger.info("resolved response ArrayBuffer", arrayBuffer);
          return arrayBuffer;
        }
        case "blob": {
          const mimeType = this.request.getResponseHeader("Content-Type") || "text/plain";
          const responseBlob = new Blob([this.responseBufferToText()], {
            type: mimeType
          });
          this.logger.info(
            "resolved response Blob (mime type: %s)",
            responseBlob,
            mimeType
          );
          return responseBlob;
        }
        default: {
          const responseText = this.responseBufferToText();
          this.logger.info(
            'resolving "%s" response type as text',
            this.request.responseType,
            responseText
          );
          return responseText;
        }
      }
    }
    get responseText() {
      invariant(
        this.request.responseType === "" || this.request.responseType === "text",
        "InvalidStateError: The object is in invalid state."
      );
      if (this.request.readyState !== this.request.LOADING && this.request.readyState !== this.request.DONE) {
        return "";
      }
      const responseText = this.responseBufferToText();
      this.logger.info('getResponseText: "%s"', responseText);
      return responseText;
    }
    get responseXML() {
      invariant(
        this.request.responseType === "" || this.request.responseType === "document",
        "InvalidStateError: The object is in invalid state."
      );
      if (this.request.readyState !== this.request.DONE) {
        return null;
      }
      const contentType = this.request.getResponseHeader("Content-Type") || "";
      if (typeof DOMParser === "undefined") {
        console.warn(
          "Cannot retrieve XMLHttpRequest response body as XML: DOMParser is not defined. You are likely using an environment that is not browser or does not polyfill browser globals correctly."
        );
        return null;
      }
      if (isDomParserSupportedType(contentType)) {
        return new DOMParser().parseFromString(
          this.responseBufferToText(),
          contentType
        );
      }
      return null;
    }
    errorWith(error3) {
      this[kIsRequestHandled] = true;
      this.logger.info("responding with an error");
      this.setReadyState(this.request.DONE);
      this.trigger("error", this.request);
      this.trigger("loadend", this.request);
    }
    /**
     * Transitions this request's `readyState` to the given one.
     */
    setReadyState(nextReadyState) {
      this.logger.info(
        "setReadyState: %d -> %d",
        this.request.readyState,
        nextReadyState
      );
      if (this.request.readyState === nextReadyState) {
        this.logger.info("ready state identical, skipping transition...");
        return;
      }
      define(this.request, "readyState", nextReadyState);
      this.logger.info("set readyState to: %d", nextReadyState);
      if (nextReadyState !== this.request.UNSENT) {
        this.logger.info('triggerring "readystatechange" event...');
        this.trigger("readystatechange", this.request);
      }
    }
    /**
     * Triggers given event on the `XMLHttpRequest` instance.
     */
    trigger(eventName, target, options) {
      const callback = target[`on${eventName}`];
      const event = createEvent(target, eventName, options);
      this.logger.info('trigger "%s"', eventName, options || "");
      if (typeof callback === "function") {
        this.logger.info('found a direct "%s" callback, calling...', eventName);
        callback.call(target, event);
      }
      const events = target instanceof XMLHttpRequestUpload ? this.uploadEvents : this.events;
      for (const [registeredEventName, listeners] of events) {
        if (registeredEventName === eventName) {
          this.logger.info(
            'found %d listener(s) for "%s" event, calling...',
            listeners.length,
            eventName
          );
          listeners.forEach((listener) => listener.call(target, event));
        }
      }
    }
    /**
     * Converts this `XMLHttpRequest` instance into a Fetch API `Request` instance.
     */
    toFetchApiRequest(body) {
      this.logger.info("converting request to a Fetch API Request...");
      const resolvedBody = body instanceof Document ? body.documentElement.innerText : body;
      const fetchRequest = new Request(this.url.href, {
        method: this.method,
        headers: this.requestHeaders,
        /**
         * @see https://xhr.spec.whatwg.org/#cross-origin-credentials
         */
        credentials: this.request.withCredentials ? "include" : "same-origin",
        body: ["GET", "HEAD"].includes(this.method.toUpperCase()) ? null : resolvedBody
      });
      const proxyHeaders = createProxy(fetchRequest.headers, {
        methodCall: ([methodName, args], invoke) => {
          switch (methodName) {
            case "append":
            case "set": {
              const [headerName, headerValue] = args;
              this.request.setRequestHeader(headerName, headerValue);
              break;
            }
            case "delete": {
              const [headerName] = args;
              console.warn(
                `XMLHttpRequest: Cannot remove a "${headerName}" header from the Fetch API representation of the "${fetchRequest.method} ${fetchRequest.url}" request. XMLHttpRequest headers cannot be removed.`
              );
              break;
            }
          }
          return invoke();
        }
      });
      define(fetchRequest, "headers", proxyHeaders);
      this.logger.info("converted request to a Fetch API Request!", fetchRequest);
      return fetchRequest;
    }
  };
  function toAbsoluteUrl(url) {
    if (typeof location === "undefined") {
      return new URL(url);
    }
    return new URL(url.toString(), location.href);
  }
  function define(target, property, value) {
    Reflect.defineProperty(target, property, {
      // Ensure writable properties to allow redefining readonly properties.
      writable: true,
      enumerable: true,
      value
    });
  }
  function createXMLHttpRequestProxy({
    emitter,
    logger
  }) {
    const XMLHttpRequestProxy = new Proxy(globalThis.XMLHttpRequest, {
      construct(target, args, newTarget) {
        logger.info("constructed new XMLHttpRequest");
        const originalRequest = Reflect.construct(
          target,
          args,
          newTarget
        );
        const prototypeDescriptors = Object.getOwnPropertyDescriptors(
          target.prototype
        );
        for (const propertyName in prototypeDescriptors) {
          Reflect.defineProperty(
            originalRequest,
            propertyName,
            prototypeDescriptors[propertyName]
          );
        }
        const xhrRequestController = new XMLHttpRequestController(
          originalRequest,
          logger
        );
        xhrRequestController.onRequest = async function({ request, requestId }) {
          const controller = new RequestController(request);
          this.logger.info("awaiting mocked response...");
          this.logger.info(
            'emitting the "request" event for %s listener(s)...',
            emitter.listenerCount("request")
          );
          const isRequestHandled = await handleRequest2({
            request,
            requestId,
            controller,
            emitter,
            onResponse: async (response) => {
              await this.respondWith(response);
            },
            onRequestError: () => {
              this.errorWith(new TypeError("Network error"));
            },
            onError: (error3) => {
              this.logger.info("request errored!", { error: error3 });
              if (error3 instanceof Error) {
                this.errorWith(error3);
              }
            }
          });
          if (!isRequestHandled) {
            this.logger.info(
              "no mocked response received, performing request as-is..."
            );
          }
        };
        xhrRequestController.onResponse = async function({
          response,
          isMockedResponse,
          request,
          requestId
        }) {
          this.logger.info(
            'emitting the "response" event for %s listener(s)...',
            emitter.listenerCount("response")
          );
          emitter.emit("response", {
            response,
            isMockedResponse,
            request,
            requestId
          });
        };
        return xhrRequestController.request;
      }
    });
    return XMLHttpRequestProxy;
  }
  var _XMLHttpRequestInterceptor = class extends Interceptor {
    constructor() {
      super(_XMLHttpRequestInterceptor.interceptorSymbol);
    }
    checkEnvironment() {
      return hasConfigurableGlobal("XMLHttpRequest");
    }
    setup() {
      const logger = this.logger.extend("setup");
      logger.info('patching "XMLHttpRequest" module...');
      const PureXMLHttpRequest = globalThis.XMLHttpRequest;
      invariant(
        !PureXMLHttpRequest[IS_PATCHED_MODULE],
        'Failed to patch the "XMLHttpRequest" module: already patched.'
      );
      globalThis.XMLHttpRequest = createXMLHttpRequestProxy({
        emitter: this.emitter,
        logger: this.logger
      });
      logger.info(
        'native "XMLHttpRequest" module patched!',
        globalThis.XMLHttpRequest.name
      );
      Object.defineProperty(globalThis.XMLHttpRequest, IS_PATCHED_MODULE, {
        enumerable: true,
        configurable: true,
        value: true
      });
      this.subscriptions.push(() => {
        Object.defineProperty(globalThis.XMLHttpRequest, IS_PATCHED_MODULE, {
          value: void 0
        });
        globalThis.XMLHttpRequest = PureXMLHttpRequest;
        logger.info(
          'native "XMLHttpRequest" module restored!',
          globalThis.XMLHttpRequest.name
        );
      });
    }
  };
  var XMLHttpRequestInterceptor = _XMLHttpRequestInterceptor;
  XMLHttpRequestInterceptor.interceptorSymbol = Symbol("xhr");

  // src/browser/setupWorker/start/createFallbackRequestListener.ts
  function createFallbackRequestListener(context, options) {
    const interceptor = new BatchInterceptor({
      name: "fallback",
      interceptors: [new FetchInterceptor(), new XMLHttpRequestInterceptor()]
    });
    interceptor.on("request", async ({ request, requestId, controller }) => {
      const requestCloneForLogs = request.clone();
      const response = await handleRequest(
        request,
        requestId,
        context.getRequestHandlers().filter(isHandlerKind("RequestHandler")),
        options,
        context.emitter,
        {
          onMockedResponse(_, { handler, parsedResult }) {
            if (!options.quiet) {
              context.emitter.once("response:mocked", ({ response: response2 }) => {
                handler.log({
                  request: requestCloneForLogs,
                  response: response2,
                  parsedResult
                });
              });
            }
          }
        }
      );
      if (response) {
        controller.respondWith(response);
      }
    });
    interceptor.on(
      "response",
      ({ response, isMockedResponse, request, requestId }) => {
        context.emitter.emit(
          isMockedResponse ? "response:mocked" : "response:bypass",
          {
            response,
            request,
            requestId
          }
        );
      }
    );
    interceptor.apply();
    return interceptor;
  }

  // src/browser/setupWorker/start/createFallbackStart.ts
  function createFallbackStart(context) {
    return async function start(options) {
      context.fallbackInterceptor = createFallbackRequestListener(
        context,
        options
      );
      printStartMessage({
        message: "Mocking enabled (fallback mode).",
        quiet: options.quiet
      });
      return void 0;
    };
  }

  // src/browser/setupWorker/stop/createFallbackStop.ts
  function createFallbackStop(context) {
    return function stop() {
      context.fallbackInterceptor?.dispose();
      printStopMessage({ quiet: context.startOptions?.quiet });
    };
  }

  // src/browser/utils/supportsReadableStreamTransfer.ts
  function supportsReadableStreamTransfer() {
    try {
      const stream = new ReadableStream({
        start: (controller) => controller.close()
      });
      const message3 = new MessageChannel();
      message3.port1.postMessage(stream, [stream]);
      return true;
    } catch {
      return false;
    }
  }

  // node_modules/.pnpm/@mswjs+interceptors@0.37.1/node_modules/@mswjs/interceptors/lib/browser/interceptors/WebSocket/index.mjs
  function bindEvent(target, event) {
    Object.defineProperties(event, {
      target: {
        value: target,
        enumerable: true,
        writable: true
      },
      currentTarget: {
        value: target,
        enumerable: true,
        writable: true
      }
    });
    return event;
  }
  var kCancelable = Symbol("kCancelable");
  var kDefaultPrevented = Symbol("kDefaultPrevented");
  var CancelableMessageEvent = class extends MessageEvent {
    constructor(type, init) {
      super(type, init);
      this[kCancelable] = !!init.cancelable;
      this[kDefaultPrevented] = false;
    }
    get cancelable() {
      return this[kCancelable];
    }
    set cancelable(nextCancelable) {
      this[kCancelable] = nextCancelable;
    }
    get defaultPrevented() {
      return this[kDefaultPrevented];
    }
    set defaultPrevented(nextDefaultPrevented) {
      this[kDefaultPrevented] = nextDefaultPrevented;
    }
    preventDefault() {
      if (this.cancelable && !this[kDefaultPrevented]) {
        this[kDefaultPrevented] = true;
      }
    }
  };
  var CloseEvent = class extends Event {
    constructor(type, init = {}) {
      super(type, init);
      this.code = init.code === void 0 ? 0 : init.code;
      this.reason = init.reason === void 0 ? "" : init.reason;
      this.wasClean = init.wasClean === void 0 ? false : init.wasClean;
    }
  };
  var CancelableCloseEvent = class extends CloseEvent {
    constructor(type, init = {}) {
      super(type, init);
      this[kCancelable] = !!init.cancelable;
      this[kDefaultPrevented] = false;
    }
    get cancelable() {
      return this[kCancelable];
    }
    set cancelable(nextCancelable) {
      this[kCancelable] = nextCancelable;
    }
    get defaultPrevented() {
      return this[kDefaultPrevented];
    }
    set defaultPrevented(nextDefaultPrevented) {
      this[kDefaultPrevented] = nextDefaultPrevented;
    }
    preventDefault() {
      if (this.cancelable && !this[kDefaultPrevented]) {
        this[kDefaultPrevented] = true;
      }
    }
  };
  var kEmitter2 = Symbol("kEmitter");
  var kBoundListener = Symbol("kBoundListener");
  var WebSocketClientConnection = class {
    constructor(socket, transport) {
      this.socket = socket;
      this.transport = transport;
      this.id = createRequestId();
      this.url = new URL(socket.url);
      this[kEmitter2] = new EventTarget();
      this.transport.addEventListener("outgoing", (event) => {
        const message3 = bindEvent(
          this.socket,
          new CancelableMessageEvent("message", {
            data: event.data,
            origin: event.origin,
            cancelable: true
          })
        );
        this[kEmitter2].dispatchEvent(message3);
        if (message3.defaultPrevented) {
          event.preventDefault();
        }
      });
      this.transport.addEventListener("close", (event) => {
        this[kEmitter2].dispatchEvent(
          bindEvent(this.socket, new CloseEvent("close", event))
        );
      });
    }
    /**
     * Listen for the outgoing events from the connected WebSocket client.
     */
    addEventListener(type, listener, options) {
      if (!Reflect.has(listener, kBoundListener)) {
        const boundListener = listener.bind(this.socket);
        Object.defineProperty(listener, kBoundListener, {
          value: boundListener,
          enumerable: false,
          configurable: false
        });
      }
      this[kEmitter2].addEventListener(
        type,
        Reflect.get(listener, kBoundListener),
        options
      );
    }
    /**
     * Removes the listener for the given event.
     */
    removeEventListener(event, listener, options) {
      this[kEmitter2].removeEventListener(
        event,
        Reflect.get(listener, kBoundListener),
        options
      );
    }
    /**
     * Send data to the connected client.
     */
    send(data) {
      this.transport.send(data);
    }
    /**
     * Close the WebSocket connection.
     * @param {number} code A status code (see https://www.rfc-editor.org/rfc/rfc6455#section-7.4.1).
     * @param {string} reason A custom connection close reason.
     */
    close(code, reason) {
      this.transport.close(code, reason);
    }
  };
  var WEBSOCKET_CLOSE_CODE_RANGE_ERROR = "InvalidAccessError: close code out of user configurable range";
  var kPassthroughPromise = Symbol("kPassthroughPromise");
  var kOnSend = Symbol("kOnSend");
  var kClose = Symbol("kClose");
  var WebSocketOverride = class extends EventTarget {
    constructor(url, protocols) {
      super();
      this.CONNECTING = 0;
      this.OPEN = 1;
      this.CLOSING = 2;
      this.CLOSED = 3;
      this._onopen = null;
      this._onmessage = null;
      this._onerror = null;
      this._onclose = null;
      this.url = url.toString();
      this.protocol = "";
      this.extensions = "";
      this.binaryType = "blob";
      this.readyState = this.CONNECTING;
      this.bufferedAmount = 0;
      this[kPassthroughPromise] = new DeferredPromise();
      queueMicrotask(async () => {
        if (await this[kPassthroughPromise]) {
          return;
        }
        this.protocol = typeof protocols === "string" ? protocols : Array.isArray(protocols) && protocols.length > 0 ? protocols[0] : "";
        if (this.readyState === this.CONNECTING) {
          this.readyState = this.OPEN;
          this.dispatchEvent(bindEvent(this, new Event("open")));
        }
      });
    }
    set onopen(listener) {
      this.removeEventListener("open", this._onopen);
      this._onopen = listener;
      if (listener !== null) {
        this.addEventListener("open", listener);
      }
    }
    get onopen() {
      return this._onopen;
    }
    set onmessage(listener) {
      this.removeEventListener(
        "message",
        this._onmessage
      );
      this._onmessage = listener;
      if (listener !== null) {
        this.addEventListener("message", listener);
      }
    }
    get onmessage() {
      return this._onmessage;
    }
    set onerror(listener) {
      this.removeEventListener("error", this._onerror);
      this._onerror = listener;
      if (listener !== null) {
        this.addEventListener("error", listener);
      }
    }
    get onerror() {
      return this._onerror;
    }
    set onclose(listener) {
      this.removeEventListener("close", this._onclose);
      this._onclose = listener;
      if (listener !== null) {
        this.addEventListener("close", listener);
      }
    }
    get onclose() {
      return this._onclose;
    }
    /**
     * @see https://websockets.spec.whatwg.org/#ref-for-dom-websocket-send%E2%91%A0
     */
    send(data) {
      if (this.readyState === this.CONNECTING) {
        this.close();
        throw new DOMException("InvalidStateError");
      }
      if (this.readyState === this.CLOSING || this.readyState === this.CLOSED) {
        return;
      }
      this.bufferedAmount += getDataSize(data);
      queueMicrotask(() => {
        var _a2;
        this.bufferedAmount = 0;
        (_a2 = this[kOnSend]) == null ? void 0 : _a2.call(this, data);
      });
    }
    close(code = 1e3, reason) {
      invariant(code, WEBSOCKET_CLOSE_CODE_RANGE_ERROR);
      invariant(
        code === 1e3 || code >= 3e3 && code <= 4999,
        WEBSOCKET_CLOSE_CODE_RANGE_ERROR
      );
      this[kClose](code, reason);
    }
    [(kPassthroughPromise, kOnSend, kClose)](code = 1e3, reason, wasClean = true) {
      if (this.readyState === this.CLOSING || this.readyState === this.CLOSED) {
        return;
      }
      this.readyState = this.CLOSING;
      queueMicrotask(() => {
        this.readyState = this.CLOSED;
        this.dispatchEvent(
          bindEvent(
            this,
            new CloseEvent("close", {
              code,
              reason,
              wasClean
            })
          )
        );
        this._onopen = null;
        this._onmessage = null;
        this._onerror = null;
        this._onclose = null;
      });
    }
    addEventListener(type, listener, options) {
      return super.addEventListener(
        type,
        listener,
        options
      );
    }
    removeEventListener(type, callback, options) {
      return super.removeEventListener(type, callback, options);
    }
  };
  WebSocketOverride.CONNECTING = 0;
  WebSocketOverride.OPEN = 1;
  WebSocketOverride.CLOSING = 2;
  WebSocketOverride.CLOSED = 3;
  function getDataSize(data) {
    if (typeof data === "string") {
      return data.length;
    }
    if (data instanceof Blob) {
      return data.size;
    }
    return data.byteLength;
  }
  var kEmitter22 = Symbol("kEmitter");
  var kBoundListener2 = Symbol("kBoundListener");
  var kSend = Symbol("kSend");
  var WebSocketServerConnection = class {
    constructor(client, transport, createConnection) {
      this.client = client;
      this.transport = transport;
      this.createConnection = createConnection;
      this[kEmitter22] = new EventTarget();
      this.mockCloseController = new AbortController();
      this.realCloseController = new AbortController();
      this.transport.addEventListener("outgoing", (event) => {
        if (typeof this.realWebSocket === "undefined") {
          return;
        }
        queueMicrotask(() => {
          if (!event.defaultPrevented) {
            this[kSend](event.data);
          }
        });
      });
      this.transport.addEventListener(
        "incoming",
        this.handleIncomingMessage.bind(this)
      );
    }
    /**
     * The `WebSocket` instance connected to the original server.
     * Accessing this before calling `server.connect()` will throw.
     */
    get socket() {
      invariant(
        this.realWebSocket,
        'Cannot access "socket" on the original WebSocket server object: the connection is not open. Did you forget to call `server.connect()`?'
      );
      return this.realWebSocket;
    }
    /**
     * Open connection to the original WebSocket server.
     */
    connect() {
      invariant(
        !this.realWebSocket || this.realWebSocket.readyState !== WebSocket.OPEN,
        'Failed to call "connect()" on the original WebSocket instance: the connection already open'
      );
      const realWebSocket = this.createConnection();
      realWebSocket.binaryType = this.client.binaryType;
      realWebSocket.addEventListener(
        "open",
        (event) => {
          this[kEmitter22].dispatchEvent(
            bindEvent(this.realWebSocket, new Event("open", event))
          );
        },
        { once: true }
      );
      realWebSocket.addEventListener("message", (event) => {
        this.transport.dispatchEvent(
          bindEvent(
            this.realWebSocket,
            new MessageEvent("incoming", {
              data: event.data,
              origin: event.origin
            })
          )
        );
      });
      this.client.addEventListener(
        "close",
        (event) => {
          this.handleMockClose(event);
        },
        {
          signal: this.mockCloseController.signal
        }
      );
      realWebSocket.addEventListener(
        "close",
        (event) => {
          this.handleRealClose(event);
        },
        {
          signal: this.realCloseController.signal
        }
      );
      realWebSocket.addEventListener("error", () => {
        const errorEvent = bindEvent(
          realWebSocket,
          new Event("error", { cancelable: true })
        );
        this[kEmitter22].dispatchEvent(errorEvent);
        if (!errorEvent.defaultPrevented) {
          this.client.dispatchEvent(bindEvent(this.client, new Event("error")));
        }
      });
      this.realWebSocket = realWebSocket;
    }
    /**
     * Listen for the incoming events from the original WebSocket server.
     */
    addEventListener(event, listener, options) {
      if (!Reflect.has(listener, kBoundListener2)) {
        const boundListener = listener.bind(this.client);
        Object.defineProperty(listener, kBoundListener2, {
          value: boundListener,
          enumerable: false
        });
      }
      this[kEmitter22].addEventListener(
        event,
        Reflect.get(listener, kBoundListener2),
        options
      );
    }
    /**
     * Remove the listener for the given event.
     */
    removeEventListener(event, listener, options) {
      this[kEmitter22].removeEventListener(
        event,
        Reflect.get(listener, kBoundListener2),
        options
      );
    }
    /**
     * Send data to the original WebSocket server.
     * @example
     * server.send('hello')
     * server.send(new Blob(['hello']))
     * server.send(new TextEncoder().encode('hello'))
     */
    send(data) {
      this[kSend](data);
    }
    [(kEmitter22, kSend)](data) {
      const { realWebSocket } = this;
      invariant(
        realWebSocket,
        'Failed to call "server.send()" for "%s": the connection is not open. Did you forget to call "server.connect()"?',
        this.client.url
      );
      if (realWebSocket.readyState === WebSocket.CLOSING || realWebSocket.readyState === WebSocket.CLOSED) {
        return;
      }
      if (realWebSocket.readyState === WebSocket.CONNECTING) {
        realWebSocket.addEventListener(
          "open",
          () => {
            realWebSocket.send(data);
          },
          { once: true }
        );
        return;
      }
      realWebSocket.send(data);
    }
    /**
     * Close the actual server connection.
     */
    close() {
      const { realWebSocket } = this;
      invariant(
        realWebSocket,
        'Failed to close server connection for "%s": the connection is not open. Did you forget to call "server.connect()"?',
        this.client.url
      );
      this.realCloseController.abort();
      if (realWebSocket.readyState === WebSocket.CLOSING || realWebSocket.readyState === WebSocket.CLOSED) {
        return;
      }
      realWebSocket.close();
      queueMicrotask(() => {
        this[kEmitter22].dispatchEvent(
          bindEvent(
            this.realWebSocket,
            new CancelableCloseEvent("close", {
              /**
               * @note `server.close()` in the interceptor
               * always results in clean closures.
               */
              code: 1e3,
              cancelable: true
            })
          )
        );
      });
    }
    handleIncomingMessage(event) {
      const messageEvent = bindEvent(
        event.target,
        new CancelableMessageEvent("message", {
          data: event.data,
          origin: event.origin,
          cancelable: true
        })
      );
      this[kEmitter22].dispatchEvent(messageEvent);
      if (!messageEvent.defaultPrevented) {
        this.client.dispatchEvent(
          bindEvent(
            /**
             * @note Bind the forwarded original server events
             * to the mock WebSocket instance so it would
             * dispatch them straight away.
             */
            this.client,
            // Clone the message event again to prevent
            // the "already being dispatched" exception.
            new MessageEvent("message", {
              data: event.data,
              origin: event.origin
            })
          )
        );
      }
    }
    handleMockClose(_event) {
      if (this.realWebSocket) {
        this.realWebSocket.close();
      }
    }
    handleRealClose(event) {
      this.mockCloseController.abort();
      const closeEvent = bindEvent(
        this.realWebSocket,
        new CancelableCloseEvent("close", {
          code: event.code,
          reason: event.reason,
          wasClean: event.wasClean,
          cancelable: true
        })
      );
      this[kEmitter22].dispatchEvent(closeEvent);
      if (!closeEvent.defaultPrevented) {
        this.client[kClose](event.code, event.reason);
      }
    }
  };
  var WebSocketClassTransport = class extends EventTarget {
    constructor(socket) {
      super();
      this.socket = socket;
      this.socket.addEventListener("close", (event) => {
        this.dispatchEvent(bindEvent(this.socket, new CloseEvent("close", event)));
      });
      this.socket[kOnSend] = (data) => {
        this.dispatchEvent(
          bindEvent(
            this.socket,
            // Dispatch this as cancelable because "client" connection
            // re-creates this message event (cannot dispatch the same event).
            new CancelableMessageEvent("outgoing", {
              data,
              origin: this.socket.url,
              cancelable: true
            })
          )
        );
      };
    }
    addEventListener(type, callback, options) {
      return super.addEventListener(type, callback, options);
    }
    dispatchEvent(event) {
      return super.dispatchEvent(event);
    }
    send(data) {
      queueMicrotask(() => {
        if (this.socket.readyState === this.socket.CLOSING || this.socket.readyState === this.socket.CLOSED) {
          return;
        }
        const dispatchEvent = () => {
          this.socket.dispatchEvent(
            bindEvent(
              /**
               * @note Setting this event's "target" to the
               * WebSocket override instance is important.
               * This way it can tell apart original incoming events
               * (must be forwarded to the transport) from the
               * mocked message events like the one below
               * (must be dispatched on the client instance).
               */
              this.socket,
              new MessageEvent("message", {
                data,
                origin: this.socket.url
              })
            )
          );
        };
        if (this.socket.readyState === this.socket.CONNECTING) {
          this.socket.addEventListener(
            "open",
            () => {
              dispatchEvent();
            },
            { once: true }
          );
        } else {
          dispatchEvent();
        }
      });
    }
    close(code, reason) {
      this.socket[kClose](code, reason);
    }
  };
  var _WebSocketInterceptor = class extends Interceptor {
    constructor() {
      super(_WebSocketInterceptor.symbol);
    }
    checkEnvironment() {
      return hasConfigurableGlobal("WebSocket");
    }
    setup() {
      const originalWebSocketDescriptor = Object.getOwnPropertyDescriptor(
        globalThis,
        "WebSocket"
      );
      const WebSocketProxy = new Proxy(globalThis.WebSocket, {
        construct: (target, args, newTarget) => {
          const [url, protocols] = args;
          const createConnection = () => {
            return Reflect.construct(target, args, newTarget);
          };
          const socket = new WebSocketOverride(url, protocols);
          const transport = new WebSocketClassTransport(socket);
          queueMicrotask(() => {
            try {
              const server = new WebSocketServerConnection(
                socket,
                transport,
                createConnection
              );
              const hasConnectionListeners = this.emitter.emit("connection", {
                client: new WebSocketClientConnection(socket, transport),
                server,
                info: {
                  protocols
                }
              });
              if (hasConnectionListeners) {
                socket[kPassthroughPromise].resolve(false);
              } else {
                socket[kPassthroughPromise].resolve(true);
                server.connect();
                server.addEventListener("open", () => {
                  socket.dispatchEvent(bindEvent(socket, new Event("open")));
                  if (server["realWebSocket"]) {
                    socket.protocol = server["realWebSocket"].protocol;
                  }
                });
              }
            } catch (error3) {
              if (error3 instanceof Error) {
                socket.dispatchEvent(new Event("error"));
                if (socket.readyState !== WebSocket.CLOSING && socket.readyState !== WebSocket.CLOSED) {
                  socket[kClose](1011, error3.message, false);
                }
                console.error(error3);
              }
            }
          });
          return socket;
        }
      });
      Object.defineProperty(globalThis, "WebSocket", {
        value: WebSocketProxy,
        configurable: true
      });
      this.subscriptions.push(() => {
        Object.defineProperty(
          globalThis,
          "WebSocket",
          originalWebSocketDescriptor
        );
      });
    }
  };
  var WebSocketInterceptor = _WebSocketInterceptor;
  WebSocketInterceptor.symbol = Symbol("websocket");

  // src/core/ws/webSocketInterceptor.ts
  var webSocketInterceptor = new WebSocketInterceptor();

  // src/core/ws/handleWebSocketEvent.ts
  function handleWebSocketEvent(options) {
    webSocketInterceptor.on("connection", async (connection) => {
      const handlers = options.getHandlers();
      const connectionEvent = new MessageEvent("connection", {
        data: connection
      });
      const matchingHandlers = [];
      for (const handler of handlers) {
        if (isHandlerKind("EventHandler")(handler) && handler.predicate({
          event: connectionEvent,
          parsedResult: handler.parse({
            event: connectionEvent
          })
        })) {
          matchingHandlers.push(handler);
        }
      }
      if (matchingHandlers.length > 0) {
        options?.onMockedConnection(connection);
        for (const handler of matchingHandlers) {
          handler[kDispatchEvent](connectionEvent);
        }
      } else {
        const request = new Request(connection.client.url, {
          headers: {
            upgrade: "websocket",
            connection: "upgrade"
          }
        });
        await onUnhandledRequest(
          request,
          options.getUnhandledRequestStrategy()
        ).catch((error3) => {
          const errorEvent = new Event("error");
          Object.defineProperty(errorEvent, "cause", {
            enumerable: true,
            configurable: false,
            value: error3
          });
          connection.client.socket.dispatchEvent(errorEvent);
        });
        options?.onPassthroughConnection(connection);
        connection.server.connect();
      }
    });
  }

  // src/core/ws/utils/getMessageLength.ts
  function getMessageLength(data) {
    if (data instanceof Blob) {
      return data.size;
    }
    if (data instanceof ArrayBuffer) {
      return data.byteLength;
    }
    return new Blob([data]).size;
  }

  // src/core/ws/utils/truncateMessage.ts
  var MAX_LENGTH = 24;
  function truncateMessage(message3) {
    if (message3.length <= MAX_LENGTH) {
      return message3;
    }
    return `${message3.slice(0, MAX_LENGTH)}\u2026`;
  }

  // src/core/ws/utils/getPublicData.ts
  async function getPublicData(data) {
    if (data instanceof Blob) {
      const text = await data.text();
      return `Blob(${truncateMessage(text)})`;
    }
    if (typeof data === "object" && "byteLength" in data) {
      const text = new TextDecoder().decode(data);
      return `ArrayBuffer(${truncateMessage(text)})`;
    }
    return truncateMessage(data);
  }

  // src/core/ws/utils/attachWebSocketLogger.ts
  var colors = {
    system: "#3b82f6",
    outgoing: "#22c55e",
    incoming: "#ef4444",
    mocked: "#ff6a33"
  };
  function attachWebSocketLogger(connection) {
    const { client, server } = connection;
    logConnectionOpen(client);
    client.addEventListener("message", (event) => {
      logOutgoingClientMessage(event);
    });
    client.addEventListener("close", (event) => {
      logConnectionClose(event);
    });
    client.socket.addEventListener("error", (event) => {
      logClientError(event);
    });
    client.send = new Proxy(client.send, {
      apply(target, thisArg, args) {
        const [data] = args;
        const messageEvent = new MessageEvent("message", { data });
        Object.defineProperties(messageEvent, {
          currentTarget: {
            enumerable: true,
            writable: false,
            value: client.socket
          },
          target: {
            enumerable: true,
            writable: false,
            value: client.socket
          }
        });
        queueMicrotask(() => {
          logIncomingMockedClientMessage(messageEvent);
        });
        return Reflect.apply(target, thisArg, args);
      }
    });
    server.addEventListener(
      "open",
      () => {
        server.addEventListener("message", (event) => {
          logIncomingServerMessage(event);
        });
      },
      { once: true }
    );
    server.send = new Proxy(server.send, {
      apply(target, thisArg, args) {
        const [data] = args;
        const messageEvent = new MessageEvent("message", { data });
        Object.defineProperties(messageEvent, {
          currentTarget: {
            enumerable: true,
            writable: false,
            value: server.socket
          },
          target: {
            enumerable: true,
            writable: false,
            value: server.socket
          }
        });
        logOutgoingMockedClientMessage(messageEvent);
        return Reflect.apply(target, thisArg, args);
      }
    });
  }
  function logConnectionOpen(client) {
    const publicUrl = toPublicUrl(client.url);
    console.groupCollapsed(
      devUtils.formatMessage(`${getTimestamp()} %c\u25B6%c ${publicUrl}`),
      `color:${colors.system}`,
      "color:inherit"
    );
    console.log("Client:", client.socket);
    console.groupEnd();
  }
  function logConnectionClose(event) {
    const target = event.target;
    const publicUrl = toPublicUrl(target.url);
    console.groupCollapsed(
      devUtils.formatMessage(
        `${getTimestamp({ milliseconds: true })} %c\u25A0%c ${publicUrl}`
      ),
      `color:${colors.system}`,
      "color:inherit"
    );
    console.log(event);
    console.groupEnd();
  }
  function logClientError(event) {
    const socket = event.target;
    const publicUrl = toPublicUrl(socket.url);
    console.groupCollapsed(
      devUtils.formatMessage(
        `${getTimestamp({ milliseconds: true })} %c\xD7%c ${publicUrl}`
      ),
      `color:${colors.system}`,
      "color:inherit"
    );
    console.log(event);
    console.groupEnd();
  }
  async function logOutgoingClientMessage(event) {
    const byteLength = getMessageLength(event.data);
    const publicData = await getPublicData(event.data);
    const arrow = event.defaultPrevented ? "\u21E1" : "\u2B06";
    console.groupCollapsed(
      devUtils.formatMessage(
        `${getTimestamp({ milliseconds: true })} %c${arrow}%c ${publicData} %c${byteLength}%c`
      ),
      `color:${colors.outgoing}`,
      "color:inherit",
      "color:gray;font-weight:normal",
      "color:inherit;font-weight:inherit"
    );
    console.log(event);
    console.groupEnd();
  }
  async function logOutgoingMockedClientMessage(event) {
    const byteLength = getMessageLength(event.data);
    const publicData = await getPublicData(event.data);
    console.groupCollapsed(
      devUtils.formatMessage(
        `${getTimestamp({ milliseconds: true })} %c\u2B06%c ${publicData} %c${byteLength}%c`
      ),
      `color:${colors.mocked}`,
      "color:inherit",
      "color:gray;font-weight:normal",
      "color:inherit;font-weight:inherit"
    );
    console.log(event);
    console.groupEnd();
  }
  async function logIncomingMockedClientMessage(event) {
    const byteLength = getMessageLength(event.data);
    const publicData = await getPublicData(event.data);
    console.groupCollapsed(
      devUtils.formatMessage(
        `${getTimestamp({ milliseconds: true })} %c\u2B07%c ${publicData} %c${byteLength}%c`
      ),
      `color:${colors.mocked}`,
      "color:inherit",
      "color:gray;font-weight:normal",
      "color:inherit;font-weight:inherit"
    );
    console.log(event);
    console.groupEnd();
  }
  async function logIncomingServerMessage(event) {
    const byteLength = getMessageLength(event.data);
    const publicData = await getPublicData(event.data);
    const arrow = event.defaultPrevented ? "\u21E3" : "\u2B07";
    console.groupCollapsed(
      devUtils.formatMessage(
        `${getTimestamp({ milliseconds: true })} %c${arrow}%c ${publicData} %c${byteLength}%c`
      ),
      `color:${colors.incoming}`,
      "color:inherit",
      "color:gray;font-weight:normal",
      "color:inherit;font-weight:inherit"
    );
    console.log(event);
    console.groupEnd();
  }

  // src/browser/setupWorker/setupWorker.ts
  var SetupWorkerApi = class extends SetupApi {
    context;
    startHandler = null;
    stopHandler = null;
    listeners;
    constructor(...handlers) {
      super(...handlers);
      invariant(
        !isNodeProcess(),
        devUtils.formatMessage(
          "Failed to execute `setupWorker` in a non-browser environment. Consider using `setupServer` for Node.js environment instead."
        )
      );
      this.listeners = [];
      this.context = this.createWorkerContext();
    }
    createWorkerContext() {
      const context = {
        // Mocking is not considered enabled until the worker
        // signals back the successful activation event.
        isMockingEnabled: false,
        startOptions: null,
        worker: null,
        getRequestHandlers: () => {
          return this.handlersController.currentHandlers();
        },
        registration: null,
        requests: /* @__PURE__ */ new Map(),
        emitter: this.emitter,
        workerChannel: {
          on: (eventType, callback) => {
            this.context.events.addListener(navigator.serviceWorker, "message", (event) => {
              if (event.source !== this.context.worker) {
                return;
              }
              const message3 = event.data;
              if (!message3) {
                return;
              }
              if (message3.type === eventType) {
                callback(event, message3);
              }
            });
          },
          send: (type) => {
            this.context.worker?.postMessage(type);
          }
        },
        events: {
          addListener: (target, eventType, callback) => {
            target.addEventListener(eventType, callback);
            this.listeners.push({
              eventType,
              target,
              callback
            });
            return () => {
              target.removeEventListener(eventType, callback);
            };
          },
          removeAllListeners: () => {
            for (const { target, eventType, callback } of this.listeners) {
              target.removeEventListener(eventType, callback);
            }
            this.listeners = [];
          },
          once: (eventType) => {
            const bindings = [];
            return new Promise((resolve, reject) => {
              const handleIncomingMessage = (event) => {
                try {
                  const message3 = event.data;
                  if (message3.type === eventType) {
                    resolve(message3);
                  }
                } catch (error3) {
                  reject(error3);
                }
              };
              bindings.push(
                this.context.events.addListener(
                  navigator.serviceWorker,
                  "message",
                  handleIncomingMessage
                ),
                this.context.events.addListener(
                  navigator.serviceWorker,
                  "messageerror",
                  reject
                )
              );
            }).finally(() => {
              bindings.forEach((unbind) => unbind());
            });
          }
        },
        supports: {
          serviceWorkerApi: !("serviceWorker" in navigator) || location.protocol === "file:",
          readableStreamTransfer: supportsReadableStreamTransfer()
        }
      };
      this.startHandler = context.supports.serviceWorkerApi ? createFallbackStart(context) : createStartHandler(context);
      this.stopHandler = context.supports.serviceWorkerApi ? createFallbackStop(context) : createStop(context);
      return context;
    }
    async start(options = {}) {
      if (options.waitUntilReady === true) {
        devUtils.warn(
          'The "waitUntilReady" option has been deprecated. Please remove it from this "worker.start()" call. Follow the recommended Browser integration (https://mswjs.io/docs/integrations/browser) to eliminate any race conditions between the Service Worker registration and any requests made by your application on initial render.'
        );
      }
      this.context.startOptions = mergeRight(
        DEFAULT_START_OPTIONS,
        options
      );
      handleWebSocketEvent({
        getUnhandledRequestStrategy: () => {
          return this.context.startOptions.onUnhandledRequest;
        },
        getHandlers: () => {
          return this.handlersController.currentHandlers();
        },
        onMockedConnection: (connection) => {
          if (!this.context.startOptions.quiet) {
            attachWebSocketLogger(connection);
          }
        },
        onPassthroughConnection() {
        }
      });
      webSocketInterceptor.apply();
      this.subscriptions.push(() => {
        webSocketInterceptor.dispose();
      });
      return await this.startHandler(this.context.startOptions, options);
    }
    stop() {
      super.dispose();
      this.context.events.removeAllListeners();
      this.context.emitter.removeAllListeners();
      this.stopHandler();
    }
  };
  function setupWorker(...handlers) {
    return new SetupWorkerApi(...handlers);
  }
  return __toCommonJS(iife_exports);
})();
/*! Bundled license information:

@bundled-es-modules/statuses/index-esm.js:
  (*! Bundled license information:
  
  statuses/index.js:
    (*!
     * statuses
     * Copyright(c) 2014 Jonathan Ong
     * Copyright(c) 2016 Douglas Christopher Wilson
     * MIT Licensed
     *)
  *)

@bundled-es-modules/cookie/index-esm.js:
  (*! Bundled license information:
  
  cookie/index.js:
    (*!
     * cookie
     * Copyright(c) 2012-2014 Roman Shtylman
     * Copyright(c) 2015 Douglas Christopher Wilson
     * MIT Licensed
     *)
  *)

@bundled-es-modules/tough-cookie/index-esm.js:
  (*! Bundled license information:
  
  tough-cookie/lib/pubsuffix-psl.js:
    (*!
     * Copyright (c) 2018, Salesforce.com, Inc.
     * All rights reserved.
     *
     * Redistribution and use in source and binary forms, with or without
     * modification, are permitted provided that the following conditions are met:
     *
     * 1. Redistributions of source code must retain the above copyright notice,
     * this list of conditions and the following disclaimer.
     *
     * 2. Redistributions in binary form must reproduce the above copyright notice,
     * this list of conditions and the following disclaimer in the documentation
     * and/or other materials provided with the distribution.
     *
     * 3. Neither the name of Salesforce.com nor the names of its contributors may
     * be used to endorse or promote products derived from this software without
     * specific prior written permission.
     *
     * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
     * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
     * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
     * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
     * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
     * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
     * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
     * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
     * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
     * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
     * POSSIBILITY OF SUCH DAMAGE.
     *)
  
  tough-cookie/lib/store.js:
    (*!
     * Copyright (c) 2015, Salesforce.com, Inc.
     * All rights reserved.
     *
     * Redistribution and use in source and binary forms, with or without
     * modification, are permitted provided that the following conditions are met:
     *
     * 1. Redistributions of source code must retain the above copyright notice,
     * this list of conditions and the following disclaimer.
     *
     * 2. Redistributions in binary form must reproduce the above copyright notice,
     * this list of conditions and the following disclaimer in the documentation
     * and/or other materials provided with the distribution.
     *
     * 3. Neither the name of Salesforce.com nor the names of its contributors may
     * be used to endorse or promote products derived from this software without
     * specific prior written permission.
     *
     * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
    