# Installation
> `npm install --save @types/react-timeago`

# Summary
This package contains type definitions for react-timeago (https://github.com/nmn/react-timeago).

# Details
Files were exported from https://github.com/DefinitelyTyped/DefinitelyTyped/tree/master/types/react-timeago.
## [index.d.ts](https://github.com/DefinitelyTyped/DefinitelyTyped/tree/master/types/react-timeago/index.d.ts)
````ts
import * as React from "react";

declare namespace ReactTimeago {
    type Unit =
        | "second"
        | "minute"
        | "hour"
        | "day"
        | "week"
        | "month"
        | "year";

    type Suffix = "ago" | "from now";

    type Formatter = (
        value: number,
        unit: Unit,
        suffix: Suffix,
        epochMiliseconds: number,
        nextFormatter?: Formatter,
    ) => React.ReactNode;

    interface ReactTimeagoProps<T extends React.ElementType> {
        readonly live?: boolean | undefined;
        readonly minPeriod?: number | undefined;
        readonly maxPeriod?: number | undefined;
        readonly component?: T | undefined;
        readonly title?: string | undefined;
        readonly formatter?: Formatter | undefined;
        readonly date: string | number | Date;
        readonly now?: (() => number) | undefined;
    }
}

declare class ReactTimeago<
    T extends React.ElementType<P>,
    P = React.ComponentProps<T>,
> extends React.Component<
    ReactTimeago.ReactTimeagoProps<T> & P
> {}

export = ReactTimeago;

````

### Additional Details
 * Last updated: Fri, 22 Dec 2023 00:23:24 GMT
 * Dependencies: [@types/react](https://npmjs.com/package/@types/react)

# Credits
These definitions were written by [Konstantin Lebedev](https://github.com/koss-lebedev), and [Mike Martin](https://github.com/mcmar).
