<?php
/**
 * HubDbTableV3Request
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  HubSpot\Client\Cms\Hubdb
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Hubdb
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: v3
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 7.3.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace HubSpot\Client\Cms\Hubdb\Model;

use \ArrayAccess;
use \HubSpot\Client\Cms\Hubdb\ObjectSerializer;

/**
 * HubDbTableV3Request Class Doc Comment
 *
 * @category Class
 * @package  HubSpot\Client\Cms\Hubdb
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class HubDbTableV3Request implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'HubDbTableV3Request';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'dynamic_meta_tags' => 'array<string,int>',
        'allow_public_api_access' => 'bool',
        'use_for_pages' => 'bool',
        'columns' => '\HubSpot\Client\Cms\Hubdb\Model\ColumnRequest[]',
        'name' => 'string',
        'enable_child_table_pages' => 'bool',
        'label' => 'string',
        'allow_child_tables' => 'bool'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'dynamic_meta_tags' => 'int32',
        'allow_public_api_access' => null,
        'use_for_pages' => null,
        'columns' => null,
        'name' => null,
        'enable_child_table_pages' => null,
        'label' => null,
        'allow_child_tables' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'dynamic_meta_tags' => false,
        'allow_public_api_access' => false,
        'use_for_pages' => false,
        'columns' => false,
        'name' => false,
        'enable_child_table_pages' => false,
        'label' => false,
        'allow_child_tables' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'dynamic_meta_tags' => 'dynamicMetaTags',
        'allow_public_api_access' => 'allowPublicApiAccess',
        'use_for_pages' => 'useForPages',
        'columns' => 'columns',
        'name' => 'name',
        'enable_child_table_pages' => 'enableChildTablePages',
        'label' => 'label',
        'allow_child_tables' => 'allowChildTables'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'dynamic_meta_tags' => 'setDynamicMetaTags',
        'allow_public_api_access' => 'setAllowPublicApiAccess',
        'use_for_pages' => 'setUseForPages',
        'columns' => 'setColumns',
        'name' => 'setName',
        'enable_child_table_pages' => 'setEnableChildTablePages',
        'label' => 'setLabel',
        'allow_child_tables' => 'setAllowChildTables'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'dynamic_meta_tags' => 'getDynamicMetaTags',
        'allow_public_api_access' => 'getAllowPublicApiAccess',
        'use_for_pages' => 'getUseForPages',
        'columns' => 'getColumns',
        'name' => 'getName',
        'enable_child_table_pages' => 'getEnableChildTablePages',
        'label' => 'getLabel',
        'allow_child_tables' => 'getAllowChildTables'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('dynamic_meta_tags', $data ?? [], null);
        $this->setIfExists('allow_public_api_access', $data ?? [], null);
        $this->setIfExists('use_for_pages', $data ?? [], null);
        $this->setIfExists('columns', $data ?? [], null);
        $this->setIfExists('name', $data ?? [], null);
        $this->setIfExists('enable_child_table_pages', $data ?? [], null);
        $this->setIfExists('label', $data ?? [], null);
        $this->setIfExists('allow_child_tables', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['name'] === null) {
            $invalidProperties[] = "'name' can't be null";
        }
        if ($this->container['label'] === null) {
            $invalidProperties[] = "'label' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets dynamic_meta_tags
     *
     * @return array<string,int>|null
     */
    public function getDynamicMetaTags()
    {
        return $this->container['dynamic_meta_tags'];
    }

    /**
     * Sets dynamic_meta_tags
     *
     * @param array<string,int>|null $dynamic_meta_tags Specifies the key value pairs of the [metadata fields](https://developers.hubspot.com/docs/cms/guides/dynamic-pages/hubdb#dynamic-pages) with the associated column IDs.
     *
     * @return self
     */
    public function setDynamicMetaTags($dynamic_meta_tags)
    {
        if (is_null($dynamic_meta_tags)) {
            throw new \InvalidArgumentException('non-nullable dynamic_meta_tags cannot be null');
        }
        $this->container['dynamic_meta_tags'] = $dynamic_meta_tags;

        return $this;
    }

    /**
     * Gets allow_public_api_access
     *
     * @return bool|null
     */
    public function getAllowPublicApiAccess()
    {
        return $this->container['allow_public_api_access'];
    }

    /**
     * Sets allow_public_api_access
     *
     * @param bool|null $allow_public_api_access Specifies whether the table can be read by public without authorization
     *
     * @return self
     */
    public function setAllowPublicApiAccess($allow_public_api_access)
    {
        if (is_null($allow_public_api_access)) {
            throw new \InvalidArgumentException('non-nullable allow_public_api_access cannot be null');
        }
        $this->container['allow_public_api_access'] = $allow_public_api_access;

        return $this;
    }

    /**
     * Gets use_for_pages
     *
     * @return bool|null
     */
    public function getUseForPages()
    {
        return $this->container['use_for_pages'];
    }

    /**
     * Sets use_for_pages
     *
     * @param bool|null $use_for_pages Specifies whether the table can be used for creation of dynamic pages
     *
     * @return self
     */
    public function setUseForPages($use_for_pages)
    {
        if (is_null($use_for_pages)) {
            throw new \InvalidArgumentException('non-nullable use_for_pages cannot be null');
        }
        $this->container['use_for_pages'] = $use_for_pages;

        return $this;
    }

    /**
     * Gets columns
     *
     * @return \HubSpot\Client\Cms\Hubdb\Model\ColumnRequest[]|null
     */
    public function getColumns()
    {
        return $this->container['columns'];
    }

    /**
     * Sets columns
     *
     * @param \HubSpot\Client\Cms\Hubdb\Model\ColumnRequest[]|null $columns List of columns in the table
     *
     * @return self
     */
    public function setColumns($columns)
    {
        if (is_null($columns)) {
            throw new \InvalidArgumentException('non-nullable columns cannot be null');
        }
        $this->container['columns'] = $columns;

        return $this;
    }

    /**
     * Gets name
     *
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     *
     * @param string $name Name of the table
     *
     * @return self
     */
    public function setName($name)
    {
        if (is_null($name)) {
            throw new \InvalidArgumentException('non-nullable name cannot be null');
        }
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets enable_child_table_pages
     *
     * @return bool|null
     */
    public function getEnableChildTablePages()
    {
        return $this->container['enable_child_table_pages'];
    }

    /**
     * Sets enable_child_table_pages
     *
     * @param bool|null $enable_child_table_pages Specifies creation of multi-level dynamic pages using child tables
     *
     * @return self
     */
    public function setEnableChildTablePages($enable_child_table_pages)
    {
        if (is_null($enable_child_table_pages)) {
            throw new \InvalidArgumentException('non-nullable enable_child_table_pages cannot be null');
        }
        $this->container['enable_child_table_pages'] = $enable_child_table_pages;

        return $this;
    }

    /**
     * Gets label
     *
     * @return string
     */
    public function getLabel()
    {
        return $this->container['label'];
    }

    /**
     * Sets label
     *
     * @param string $label Label of the table
     *
     * @return self
     */
    public function setLabel($label)
    {
        if (is_null($label)) {
            throw new \InvalidArgumentException('non-nullable label cannot be null');
        }
        $this->container['label'] = $label;

        return $this;
    }

    /**
     * Gets allow_child_tables
     *
     * @return bool|null
     */
    public function getAllowChildTables()
    {
        return $this->container['allow_child_tables'];
    }

    /**
     * Sets allow_child_tables
     *
     * @param bool|null $allow_child_tables Specifies whether child tables can be created
     *
     * @return self
     */
    public function setAllowChildTables($allow_child_tables)
    {
        if (is_null($allow_child_tables)) {
            throw new \InvalidArgumentException('non-nullable allow_child_tables cannot be null');
        }
        $this->container['allow_child_tables'] = $allow_child_tables;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


