<?php
/**
 * BlogAuthorsApi
 * PHP version 7.4
 *
 * @category Class
 * @package  HubSpot\Client\Cms\Blogs\Authors
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Authors
 *
 * Use these endpoints for interacting with Blog Posts, Blog Authors, and Blog Tags
 *
 * The version of the OpenAPI document: v3
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 7.3.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace HubSpot\Client\Cms\Blogs\Authors\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use HubSpot\Client\Cms\Blogs\Authors\ApiException;
use HubSpot\Client\Cms\Blogs\Authors\Configuration;
use HubSpot\Client\Cms\Blogs\Authors\HeaderSelector;
use HubSpot\Client\Cms\Blogs\Authors\ObjectSerializer;

/**
 * BlogAuthorsApi Class Doc Comment
 *
 * @category Class
 * @package  HubSpot\Client\Cms\Blogs\Authors
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class BlogAuthorsApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'archive' => [
            'application/json',
        ],
        'archiveBatch' => [
            'application/json',
        ],
        'attachToLangGroup' => [
            'application/json',
        ],
        'create' => [
            'application/json',
        ],
        'createBatch' => [
            'application/json',
        ],
        'createLangVariation' => [
            'application/json',
        ],
        'detachFromLangGroup' => [
            'application/json',
        ],
        'getById' => [
            'application/json',
        ],
        'getPage' => [
            'application/json',
        ],
        'readBatch' => [
            'application/json',
        ],
        'setLangPrimary' => [
            'application/json',
        ],
        'update' => [
            'application/json',
        ],
        'updateBatch' => [
            'application/json',
        ],
        'updateLangs' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ClientInterface $client = null,
        Configuration $config = null,
        HeaderSelector $selector = null,
        $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: new Configuration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation archive
     *
     * Delete a Blog Author
     *
     * @param  string $object_id The Blog Author id. (required)
     * @param  bool $archived Whether to return only results that have been archived. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['archive'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Cms\Blogs\Authors\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function archive($object_id, $archived = null, string $contentType = self::contentTypes['archive'][0])
    {
        $this->archiveWithHttpInfo($object_id, $archived, $contentType);
    }

    /**
     * Operation archiveWithHttpInfo
     *
     * Delete a Blog Author
     *
     * @param  string $object_id The Blog Author id. (required)
     * @param  bool $archived Whether to return only results that have been archived. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['archive'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Cms\Blogs\Authors\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function archiveWithHttpInfo($object_id, $archived = null, string $contentType = self::contentTypes['archive'][0])
    {
        $request = $this->archiveRequest($object_id, $archived, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Cms\Blogs\Authors\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation archiveAsync
     *
     * Delete a Blog Author
     *
     * @param  string $object_id The Blog Author id. (required)
     * @param  bool $archived Whether to return only results that have been archived. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['archive'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function archiveAsync($object_id, $archived = null, string $contentType = self::contentTypes['archive'][0])
    {
        return $this->archiveAsyncWithHttpInfo($object_id, $archived, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation archiveAsyncWithHttpInfo
     *
     * Delete a Blog Author
     *
     * @param  string $object_id The Blog Author id. (required)
     * @param  bool $archived Whether to return only results that have been archived. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['archive'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function archiveAsyncWithHttpInfo($object_id, $archived = null, string $contentType = self::contentTypes['archive'][0])
    {
        $returnType = '';
        $request = $this->archiveRequest($object_id, $archived, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'archive'
     *
     * @param  string $object_id The Blog Author id. (required)
     * @param  bool $archived Whether to return only results that have been archived. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['archive'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function archiveRequest($object_id, $archived = null, string $contentType = self::contentTypes['archive'][0])
    {

        // verify the required parameter 'object_id' is set
        if ($object_id === null || (is_array($object_id) && count($object_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $object_id when calling archive'
            );
        }



        $resourcePath = '/cms/v3/blogs/authors/{objectId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $archived,
            'archived', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);


        // path params
        if ($object_id !== null) {
            $resourcePath = str_replace(
                '{' . 'objectId' . '}',
                ObjectSerializer::toPathValue($object_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['*/*', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation archiveBatch
     *
     * Delete a batch of Blog Authors
     *
     * @param  \HubSpot\Client\Cms\Blogs\Authors\Model\BatchInputString $batch_input_string The JSON array of Blog Author ids. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['archiveBatch'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Cms\Blogs\Authors\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function archiveBatch($batch_input_string, string $contentType = self::contentTypes['archiveBatch'][0])
    {
        $this->archiveBatchWithHttpInfo($batch_input_string, $contentType);
    }

    /**
     * Operation archiveBatchWithHttpInfo
     *
     * Delete a batch of Blog Authors
     *
     * @param  \HubSpot\Client\Cms\Blogs\Authors\Model\BatchInputString $batch_input_string The JSON array of Blog Author ids. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['archiveBatch'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Cms\Blogs\Authors\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function archiveBatchWithHttpInfo($batch_input_string, string $contentType = self::contentTypes['archiveBatch'][0])
    {
        $request = $this->archiveBatchRequest($batch_input_string, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Cms\Blogs\Authors\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation archiveBatchAsync
     *
     * Delete a batch of Blog Authors
     *
     * @param  \HubSpot\Client\Cms\Blogs\Authors\Model\BatchInputString $batch_input_string The JSON array of Blog Author ids. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['archiveBatch'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function archiveBatchAsync($batch_input_string, string $contentType = self::contentTypes['archiveBatch'][0])
    {
        return $this->archiveBatchAsyncWithHttpInfo($batch_input_string, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation archiveBatchAsyncWithHttpInfo
     *
     * Delete a batch of Blog Authors
     *
     * @param  \HubSpot\Client\Cms\Blogs\Authors\Model\BatchInputString $batch_input_string The JSON array of Blog Author ids. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['archiveBatch'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function archiveBatchAsyncWithHttpInfo($batch_input_string, string $contentType = self::contentTypes['archiveBatch'][0])
    {
        $returnType = '';
        $request = $this->archiveBatchRequest($batch_input_string, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'archiveBatch'
     *
     * @param  \HubSpot\Client\Cms\Blogs\Authors\Model\BatchInputString $batch_input_string The JSON array of Blog Author ids. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['archiveBatch'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function archiveBatchRequest($batch_input_string, string $contentType = self::contentTypes['archiveBatch'][0])
    {

        // verify the required parameter 'batch_input_string' is set
        if ($batch_input_string === null || (is_array($batch_input_string) && count($batch_input_string) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $batch_input_string when calling archiveBatch'
            );
        }


        $resourcePath = '/cms/v3/blogs/authors/batch/archive';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['*/*', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($batch_input_string)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($batch_input_string));
            } else {
                $httpBody = $batch_input_string;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation attachToLangGroup
     *
     * Attach a Blog Author to a multi-language group
     *
     * @param  \HubSpot\Client\Cms\Blogs\Authors\Model\AttachToLangPrimaryRequestVNext $attach_to_lang_primary_request_v_next The JSON representation of the AttachToLangPrimaryRequest object. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['attachToLangGroup'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Cms\Blogs\Authors\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function attachToLangGroup($attach_to_lang_primary_request_v_next, string $contentType = self::contentTypes['attachToLangGroup'][0])
    {
        $this->attachToLangGroupWithHttpInfo($attach_to_lang_primary_request_v_next, $contentType);
    }

    /**
     * Operation attachToLangGroupWithHttpInfo
     *
     * Attach a Blog Author to a multi-language group
     *
     * @param  \HubSpot\Client\Cms\Blogs\Authors\Model\AttachToLangPrimaryRequestVNext $attach_to_lang_primary_request_v_next The JSON representation of the AttachToLangPrimaryRequest object. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['attachToLangGroup'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Cms\Blogs\Authors\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function attachToLangGroupWithHttpInfo($attach_to_lang_primary_request_v_next, string $contentType = self::contentTypes['attachToLangGroup'][0])
    {
        $request = $this->attachToLangGroupRequest($attach_to_lang_primary_request_v_next, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Cms\Blogs\Authors\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation attachToLangGroupAsync
     *
     * Attach a Blog Author to a multi-language group
     *
     * @param  \HubSpot\Client\Cms\Blogs\Authors\Model\AttachToLangPrimaryRequestVNext $attach_to_lang_primary_request_v_next The JSON representation of the AttachToLangPrimaryRequest object. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['attachToLangGroup'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function attachToLangGroupAsync($attach_to_lang_primary_request_v_next, string $contentType = self::contentTypes['attachToLangGroup'][0])
    {
        return $this->attachToLangGroupAsyncWithHttpInfo($attach_to_lang_primary_request_v_next, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation attachToLangGroupAsyncWithHttpInfo
     *
     * Attach a Blog Author to a multi-language group
     *
     * @param  \HubSpot\Client\Cms\Blogs\Authors\Model\AttachToLangPrimaryRequestVNext $attach_to_lang_primary_request_v_next The JSON representation of the AttachToLangPrimaryRequest object. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['attachToLangGroup'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function attachToLangGroupAsyncWithHttpInfo($attach_to_lang_primary_request_v_next, string $contentType = self::contentTypes['attachToLangGroup'][0])
    {
        $returnType = '';
        $request = $this->attachToLangGroupRequest($attach_to_lang_primary_request_v_next, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'attachToLangGroup'
     *
     * @param  \HubSpot\Client\Cms\Blogs\Authors\Model\AttachToLangPrimaryRequestVNext $attach_to_lang_primary_request_v_next The JSON representation of the AttachToLangPrimaryRequest object. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['attachToLangGroup'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function attachToLangGroupRequest($attach_to_lang_primary_request_v_next, string $contentType = self::contentTypes['attachToLangGroup'][0])
    {

        // verify the required parameter 'attach_to_lang_primary_request_v_next' is set
        if ($attach_to_lang_primary_request_v_next === null || (is_array($attach_to_lang_primary_request_v_next) && count($attach_to_lang_primary_request_v_next) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $attach_to_lang_primary_request_v_next when calling attachToLangGroup'
            );
        }


        $resourcePath = '/cms/v3/blogs/authors/multi-language/attach-to-lang-group';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['*/*', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($attach_to_lang_primary_request_v_next)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($attach_to_lang_primary_request_v_next));
            } else {
                $httpBody = $attach_to_lang_primary_request_v_next;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation create
     *
     * Create a new Blog Author
     *
     * @param  \HubSpot\Client\Cms\Blogs\Authors\Model\BlogAuthor $blog_author The JSON representation of a new Blog Author. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['create'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Cms\Blogs\Authors\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \HubSpot\Client\Cms\Blogs\Authors\Model\BlogAuthor|\HubSpot\Client\Cms\Blogs\Authors\Model\Error
     */
    public function create($blog_author, string $contentType = self::contentTypes['create'][0])
    {
        list($response) = $this->createWithHttpInfo($blog_author, $contentType);
        return $response;
    }

    /**
     * Operation createWithHttpInfo
     *
     * Create a new Blog Author
     *
     * @param  \HubSpot\Client\Cms\Blogs\Authors\Model\BlogAuthor $blog_author The JSON representation of a new Blog Author. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['create'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Cms\Blogs\Authors\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \HubSpot\Client\Cms\Blogs\Authors\Model\BlogAuthor|\HubSpot\Client\Cms\Blogs\Authors\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createWithHttpInfo($blog_author, string $contentType = self::contentTypes['create'][0])
    {
        $request = $this->createRequest($blog_author, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 201:
                    if ('\HubSpot\Client\Cms\Blogs\Authors\Model\BlogAuthor' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Cms\Blogs\Authors\Model\BlogAuthor' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Cms\Blogs\Authors\Model\BlogAuthor', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                default:
                    if ('\HubSpot\Client\Cms\Blogs\Authors\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Cms\Blogs\Authors\Model\Error' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Cms\Blogs\Authors\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\HubSpot\Client\Cms\Blogs\Authors\Model\BlogAuthor';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Cms\Blogs\Authors\Model\BlogAuthor',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Cms\Blogs\Authors\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createAsync
     *
     * Create a new Blog Author
     *
     * @param  \HubSpot\Client\Cms\Blogs\Authors\Model\BlogAuthor $blog_author The JSON representation of a new Blog Author. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['create'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createAsync($blog_author, string $contentType = self::contentTypes['create'][0])
    {
        return $this->createAsyncWithHttpInfo($blog_author, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createAsyncWithHttpInfo
     *
     * Create a new Blog Author
     *
     * @param  \HubSpot\Client\Cms\Blogs\Authors\Model\BlogAuthor $blog_author The JSON representation of a new Blog Author. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['create'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createAsyncWithHttpInfo($blog_author, string $contentType = self::contentTypes['create'][0])
    {
        $returnType = '\HubSpot\Client\Cms\Blogs\Authors\Model\BlogAuthor';
        $request = $this->createRequest($blog_author, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'create'
     *
     * @param  \HubSpot\Client\Cms\Blogs\Authors\Model\BlogAuthor $blog_author The JSON representation of a new Blog Author. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['create'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createRequest($blog_author, string $contentType = self::contentTypes['create'][0])
    {

        // verify the required parameter 'blog_author' is set
        if ($blog_author === null || (is_array($blog_author) && count($blog_author) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $blog_author when calling create'
            );
        }


        $resourcePath = '/cms/v3/blogs/authors';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', '*/*', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($blog_author)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($blog_author));
            } else {
                $httpBody = $blog_author;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createBatch
     *
     * Create a batch of Blog Authors
     *
     * @param  \HubSpot\Client\Cms\Blogs\Authors\Model\BatchInputBlogAuthor $batch_input_blog_author The JSON array of new Blog Authors to create. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createBatch'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Cms\Blogs\Authors\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \HubSpot\Client\Cms\Blogs\Authors\Model\BatchResponseBlogAuthor|\HubSpot\Client\Cms\Blogs\Authors\Model\BatchResponseBlogAuthorWithErrors|\HubSpot\Client\Cms\Blogs\Authors\Model\Error
     */
    public function createBatch($batch_input_blog_author, string $contentType = self::contentTypes['createBatch'][0])
    {
        list($response) = $this->createBatchWithHttpInfo($batch_input_blog_author, $contentType);
        return $response;
    }

    /**
     * Operation createBatchWithHttpInfo
     *
     * Create a batch of Blog Authors
     *
     * @param  \HubSpot\Client\Cms\Blogs\Authors\Model\BatchInputBlogAuthor $batch_input_blog_author The JSON array of new Blog Authors to create. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createBatch'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Cms\Blogs\Authors\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \HubSpot\Client\Cms\Blogs\Authors\Model\BatchResponseBlogAuthor|\HubSpot\Client\Cms\Blogs\Authors\Model\BatchResponseBlogAuthorWithErrors|\HubSpot\Client\Cms\Blogs\Authors\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createBatchWithHttpInfo($batch_input_blog_author, string $contentType = self::contentTypes['createBatch'][0])
    {
        $request = $this->createBatchRequest($batch_input_blog_author, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 201:
                    if ('\HubSpot\Client\Cms\Blogs\Authors\Model\BatchResponseBlogAuthor' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Cms\Blogs\Authors\Model\BatchResponseBlogAuthor' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Cms\Blogs\Authors\Model\BatchResponseBlogAuthor', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 207:
                    if ('\HubSpot\Client\Cms\Blogs\Authors\Model\BatchResponseBlogAuthorWithErrors' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Cms\Blogs\Authors\Model\BatchResponseBlogAuthorWithErrors' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Cms\Blogs\Authors\Model\BatchResponseBlogAuthorWithErrors', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                default:
                    if ('\HubSpot\Client\Cms\Blogs\Authors\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Cms\Blogs\Authors\Model\Error' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Cms\Blogs\Authors\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\HubSpot\Client\Cms\Blogs\Authors\Model\BatchResponseBlogAuthor';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Cms\Blogs\Authors\Model\BatchResponseBlogAuthor',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 207:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Cms\Blogs\Authors\Model\BatchResponseBlogAuthorWithErrors',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Cms\Blogs\Authors\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createBatchAsync
     *
     * Create a batch of Blog Authors
     *
     * @param  \HubSpot\Client\Cms\Blogs\Authors\Model\BatchInputBlogAuthor $batch_input_blog_author The JSON array of new Blog Authors to create. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createBatch'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createBatchAsync($batch_input_blog_author, string $contentType = self::contentTypes['createBatch'][0])
    {
        return $this->createBatchAsyncWithHttpInfo($batch_input_blog_author, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createBatchAsyncWithHttpInfo
     *
     * Create a batch of Blog Authors
     *
     * @param  \HubSpot\Client\Cms\Blogs\Authors\Model\BatchInputBlogAuthor $batch_input_blog_author The JSON array of new Blog Authors to create. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createBatch'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createBatchAsyncWithHttpInfo($batch_input_blog_author, string $contentType = self::contentTypes['createBatch'][0])
    {
        $returnType = '\HubSpot\Client\Cms\Blogs\Authors\Model\BatchResponseBlogAuthor';
        $request = $this->createBatchRequest($batch_input_blog_author, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createBatch'
     *
     * @param  \HubSpot\Client\Cms\Blogs\Authors\Model\BatchInputBlogAuthor $batch_input_blog_author The JSON array of new Blog Authors to create. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createBatch'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createBatchRequest($batch_input_blog_author, string $contentType = self::contentTypes['createBatch'][0])
    {

        // verify the required parameter 'batch_input_blog_author' is set
        if ($batch_input_blog_author === null || (is_array($batch_input_blog_author) && count($batch_input_blog_author) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $batch_input_blog_author when calling createBatch'
            );
        }


        $resourcePath = '/cms/v3/blogs/authors/batch/create';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', '*/*', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($batch_input_blog_author)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($batch_input_blog_author));
            } else {
                $httpBody = $batch_input_blog_author;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createLangVariation
     *
     * Create a new language variation
     *
     * @param  \HubSpot\Client\Cms\Blogs\Authors\Model\BlogAuthorCloneRequestVNext $blog_author_clone_request_v_next The JSON representation of the ContentLanguageCloneRequest object. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createLangVariation'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Cms\Blogs\Authors\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \HubSpot\Client\Cms\Blogs\Authors\Model\BlogAuthor|\HubSpot\Client\Cms\Blogs\Authors\Model\Error
     */
    public function createLangVariation($blog_author_clone_request_v_next, string $contentType = self::contentTypes['createLangVariation'][0])
    {
        list($response) = $this->createLangVariationWithHttpInfo($blog_author_clone_request_v_next, $contentType);
        return $response;
    }

    /**
     * Operation createLangVariationWithHttpInfo
     *
     * Create a new language variation
     *
     * @param  \HubSpot\Client\Cms\Blogs\Authors\Model\BlogAuthorCloneRequestVNext $blog_author_clone_request_v_next The JSON representation of the ContentLanguageCloneRequest object. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createLangVariation'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Cms\Blogs\Authors\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \HubSpot\Client\Cms\Blogs\Authors\Model\BlogAuthor|\HubSpot\Client\Cms\Blogs\Authors\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createLangVariationWithHttpInfo($blog_author_clone_request_v_next, string $contentType = self::contentTypes['createLangVariation'][0])
    {
        $request = $this->createLangVariationRequest($blog_author_clone_request_v_next, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\HubSpot\Client\Cms\Blogs\Authors\Model\BlogAuthor' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Cms\Blogs\Authors\Model\BlogAuthor' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Cms\Blogs\Authors\Model\BlogAuthor', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                default:
                    if ('\HubSpot\Client\Cms\Blogs\Authors\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Cms\Blogs\Authors\Model\Error' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Cms\Blogs\Authors\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\HubSpot\Client\Cms\Blogs\Authors\Model\BlogAuthor';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Cms\Blogs\Authors\Model\BlogAuthor',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Cms\Blogs\Authors\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createLangVariationAsync
     *
     * Create a new language variation
     *
     * @param  \HubSpot\Client\Cms\Blogs\Authors\Model\BlogAuthorCloneRequestVNext $blog_author_clone_request_v_next The JSON representation of the ContentLanguageCloneRequest object. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createLangVariation'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createLangVariationAsync($blog_author_clone_request_v_next, string $contentType = self::contentTypes['createLangVariation'][0])
    {
        return $this->createLangVariationAsyncWithHttpInfo($blog_author_clone_request_v_next, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createLangVariationAsyncWithHttpInfo
     *
     * Create a new language variation
     *
     * @param  \HubSpot\Client\Cms\Blogs\Authors\Model\BlogAuthorCloneRequestVNext $blog_author_clone_request_v_next The JSON representation of the ContentLanguageCloneRequest object. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createLangVariation'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createLangVariationAsyncWithHttpInfo($blog_author_clone_request_v_next, string $contentType = self::contentTypes['createLangVariation'][0])
    {
        $returnType = '\HubSpot\Client\Cms\Blogs\Authors\Model\BlogAuthor';
        $request = $this->createLangVariationRequest($blog_author_clone_request_v_next, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createLangVariation'
     *
     * @param  \HubSpot\Client\Cms\Blogs\Authors\Model\BlogAuthorCloneRequestVNext $blog_author_clone_request_v_next The JSON representation of the ContentLanguageCloneRequest object. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createLangVariation'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createLangVariationRequest($blog_author_clone_request_v_next, string $contentType = self::contentTypes['createLangVariation'][0])
    {

        // verify the required parameter 'blog_author_clone_request_v_next' is set
        if ($blog_author_clone_request_v_next === null || (is_array($blog_author_clone_request_v_next) && count($blog_author_clone_request_v_next) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $blog_author_clone_request_v_next when calling createLangVariation'
            );
        }


        $resourcePath = '/cms/v3/blogs/authors/multi-language/create-language-variation';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', '*/*', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($blog_author_clone_request_v_next)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($blog_author_clone_request_v_next));
            } else {
                $httpBody = $blog_author_clone_request_v_next;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation detachFromLangGroup
     *
     * Detach a Blog Author from a multi-language group
     *
     * @param  \HubSpot\Client\Cms\Blogs\Authors\Model\DetachFromLangGroupRequestVNext $detach_from_lang_group_request_v_next The JSON representation of the DetachFromLangGroupRequest object. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['detachFromLangGroup'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Cms\Blogs\Authors\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function detachFromLangGroup($detach_from_lang_group_request_v_next, string $contentType = self::contentTypes['detachFromLangGroup'][0])
    {
        $this->detachFromLangGroupWithHttpInfo($detach_from_lang_group_request_v_next, $contentType);
    }

    /**
     * Operation detachFromLangGroupWithHttpInfo
     *
     * Detach a Blog Author from a multi-language group
     *
     * @param  \HubSpot\Client\Cms\Blogs\Authors\Model\DetachFromLangGroupRequestVNext $detach_from_lang_group_request_v_next The JSON representation of the DetachFromLangGroupRequest object. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['detachFromLangGroup'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Cms\Blogs\Authors\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function detachFromLangGroupWithHttpInfo($detach_from_lang_group_request_v_next, string $contentType = self::contentTypes['detachFromLangGroup'][0])
    {
        $request = $this->detachFromLangGroupRequest($detach_from_lang_group_request_v_next, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Cms\Blogs\Authors\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation detachFromLangGroupAsync
     *
     * Detach a Blog Author from a multi-language group
     *
     * @param  \HubSpot\Client\Cms\Blogs\Authors\Model\DetachFromLangGroupRequestVNext $detach_from_lang_group_request_v_next The JSON representation of the DetachFromLangGroupRequest object. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['detachFromLangGroup'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function detachFromLangGroupAsync($detach_from_lang_group_request_v_next, string $contentType = self::contentTypes['detachFromLangGroup'][0])
    {
        return $this->detachFromLangGroupAsyncWithHttpInfo($detach_from_lang_group_request_v_next, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation detachFromLangGroupAsyncWithHttpInfo
     *
     * Detach a Blog Author from a multi-language group
     *
     * @param  \HubSpot\Client\Cms\Blogs\Authors\Model\DetachFromLangGroupRequestVNext $detach_from_lang_group_request_v_next The JSON representation of the DetachFromLangGroupRequest object. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['detachFromLangGroup'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function detachFromLangGroupAsyncWithHttpInfo($detach_from_lang_group_request_v_next, string $contentType = self::contentTypes['detachFromLangGroup'][0])
    {
        $returnType = '';
        $request = $this->detachFromLangGroupRequest($detach_from_lang_group_request_v_next, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'detachFromLangGroup'
     *
     * @param  \HubSpot\Client\Cms\Blogs\Authors\Model\DetachFromLangGroupRequestVNext $detach_from_lang_group_request_v_next The JSON representation of the DetachFromLangGroupRequest object. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['detachFromLangGroup'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function detachFromLangGroupRequest($detach_from_lang_group_request_v_next, string $contentType = self::contentTypes['detachFromLangGroup'][0])
    {

        // verify the required parameter 'detach_from_lang_group_request_v_next' is set
        if ($detach_from_lang_group_request_v_next === null || (is_array($detach_from_lang_group_request_v_next) && count($detach_from_lang_group_request_v_next) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $detach_from_lang_group_request_v_next when calling detachFromLangGroup'
            );
        }


        $resourcePath = '/cms/v3/blogs/authors/multi-language/detach-from-lang-group';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['*/*', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($detach_from_lang_group_request_v_next)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($detach_from_lang_group_request_v_next));
            } else {
                $httpBody = $detach_from_lang_group_request_v_next;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getById
     *
     * Retrieve a Blog Author
     *
     * @param  string $object_id The Blog Author id. (required)
     * @param  bool $archived Specifies whether to return deleted Blog Authors. Defaults to &#x60;false&#x60;. (optional)
     * @param  string $property property (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getById'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Cms\Blogs\Authors\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \HubSpot\Client\Cms\Blogs\Authors\Model\BlogAuthor|\HubSpot\Client\Cms\Blogs\Authors\Model\Error
     */
    public function getById($object_id, $archived = null, $property = null, string $contentType = self::contentTypes['getById'][0])
    {
        list($response) = $this->getByIdWithHttpInfo($object_id, $archived, $property, $contentType);
        return $response;
    }

    /**
     * Operation getByIdWithHttpInfo
     *
     * Retrieve a Blog Author
     *
     * @param  string $object_id The Blog Author id. (required)
     * @param  bool $archived Specifies whether to return deleted Blog Authors. Defaults to &#x60;false&#x60;. (optional)
     * @param  string $property (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getById'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Cms\Blogs\Authors\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \HubSpot\Client\Cms\Blogs\Authors\Model\BlogAuthor|\HubSpot\Client\Cms\Blogs\Authors\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function getByIdWithHttpInfo($object_id, $archived = null, $property = null, string $contentType = self::contentTypes['getById'][0])
    {
        $request = $this->getByIdRequest($object_id, $archived, $property, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\HubSpot\Client\Cms\Blogs\Authors\Model\BlogAuthor' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Cms\Blogs\Authors\Model\BlogAuthor' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Cms\Blogs\Authors\Model\BlogAuthor', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                default:
                    if ('\HubSpot\Client\Cms\Blogs\Authors\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Cms\Blogs\Authors\Model\Error' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Cms\Blogs\Authors\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\HubSpot\Client\Cms\Blogs\Authors\Model\BlogAuthor';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Cms\Blogs\Authors\Model\BlogAuthor',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Cms\Blogs\Authors\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getByIdAsync
     *
     * Retrieve a Blog Author
     *
     * @param  string $object_id The Blog Author id. (required)
     * @param  bool $archived Specifies whether to return deleted Blog Authors. Defaults to &#x60;false&#x60;. (optional)
     * @param  string $property (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getById'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getByIdAsync($object_id, $archived = null, $property = null, string $contentType = self::contentTypes['getById'][0])
    {
        return $this->getByIdAsyncWithHttpInfo($object_id, $archived, $property, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getByIdAsyncWithHttpInfo
     *
     * Retrieve a Blog Author
     *
     * @param  string $object_id The Blog Author id. (required)
     * @param  bool $archived Specifies whether to return deleted Blog Authors. Defaults to &#x60;false&#x60;. (optional)
     * @param  string $property (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getById'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getByIdAsyncWithHttpInfo($object_id, $archived = null, $property = null, string $contentType = self::contentTypes['getById'][0])
    {
        $returnType = '\HubSpot\Client\Cms\Blogs\Authors\Model\BlogAuthor';
        $request = $this->getByIdRequest($object_id, $archived, $property, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getById'
     *
     * @param  string $object_id The Blog Author id. (required)
     * @param  bool $archived Specifies whether to return deleted Blog Authors. Defaults to &#x60;false&#x60;. (optional)
     * @param  string $property (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getById'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getByIdRequest($object_id, $archived = null, $property = null, string $contentType = self::contentTypes['getById'][0])
    {

        // verify the required parameter 'object_id' is set
        if ($object_id === null || (is_array($object_id) && count($object_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $object_id when calling getById'
            );
        }




        $resourcePath = '/cms/v3/blogs/authors/{objectId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $archived,
            'archived', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $property,
            'property', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);


        // path params
        if ($object_id !== null) {
            $resourcePath = str_replace(
                '{' . 'objectId' . '}',
                ObjectSerializer::toPathValue($object_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', '*/*', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getPage
     *
     * Get all Blog Authors
     *
     * @param  \DateTime $created_at Only return Blog Authors created at exactly the specified time. (optional)
     * @param  \DateTime $created_after Only return Blog Authors created after the specified time. (optional)
     * @param  \DateTime $created_before Only return Blog Authors created before the specified time. (optional)
     * @param  \DateTime $updated_at Only return Blog Authors last updated at exactly the specified time. (optional)
     * @param  \DateTime $updated_after Only return Blog Authors last updated after the specified time. (optional)
     * @param  \DateTime $updated_before Only return Blog Authors last updated before the specified time. (optional)
     * @param  string[] $sort Specifies which fields to use for sorting results. Valid fields are &#x60;name&#x60;, &#x60;createdAt&#x60;, &#x60;updatedAt&#x60;, &#x60;createdBy&#x60;, &#x60;updatedBy&#x60;. &#x60;createdAt&#x60; will be used by default. (optional)
     * @param  string $after The cursor token value to get the next set of results. You can get this from the &#x60;paging.next.after&#x60; JSON property of a paged response containing more results. (optional)
     * @param  int $limit The maximum number of results to return. Default is 100. (optional)
     * @param  bool $archived Specifies whether to return deleted Blog Authors. Defaults to &#x60;false&#x60;. (optional)
     * @param  string $property property (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPage'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Cms\Blogs\Authors\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \HubSpot\Client\Cms\Blogs\Authors\Model\CollectionResponseWithTotalBlogAuthorForwardPaging|\HubSpot\Client\Cms\Blogs\Authors\Model\Error
     */
    public function getPage($created_at = null, $created_after = null, $created_before = null, $updated_at = null, $updated_after = null, $updated_before = null, $sort = null, $after = null, $limit = null, $archived = null, $property = null, string $contentType = self::contentTypes['getPage'][0])
    {
        list($response) = $this->getPageWithHttpInfo($created_at, $created_after, $created_before, $updated_at, $updated_after, $updated_before, $sort, $after, $limit, $archived, $property, $contentType);
        return $response;
    }

    /**
     * Operation getPageWithHttpInfo
     *
     * Get all Blog Authors
     *
     * @param  \DateTime $created_at Only return Blog Authors created at exactly the specified time. (optional)
     * @param  \DateTime $created_after Only return Blog Authors created after the specified time. (optional)
     * @param  \DateTime $created_before Only return Blog Authors created before the specified time. (optional)
     * @param  \DateTime $updated_at Only return Blog Authors last updated at exactly the specified time. (optional)
     * @param  \DateTime $updated_after Only return Blog Authors last updated after the specified time. (optional)
     * @param  \DateTime $updated_before Only return Blog Authors last updated before the specified time. (optional)
     * @param  string[] $sort Specifies which fields to use for sorting results. Valid fields are &#x60;name&#x60;, &#x60;createdAt&#x60;, &#x60;updatedAt&#x60;, &#x60;createdBy&#x60;, &#x60;updatedBy&#x60;. &#x60;createdAt&#x60; will be used by default. (optional)
     * @param  string $after The cursor token value to get the next set of results. You can get this from the &#x60;paging.next.after&#x60; JSON property of a paged response containing more results. (optional)
     * @param  int $limit The maximum number of results to return. Default is 100. (optional)
     * @param  bool $archived Specifies whether to return deleted Blog Authors. Defaults to &#x60;false&#x60;. (optional)
     * @param  string $property (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPage'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Cms\Blogs\Authors\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \HubSpot\Client\Cms\Blogs\Authors\Model\CollectionResponseWithTotalBlogAuthorForwardPaging|\HubSpot\Client\Cms\Blogs\Authors\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function getPageWithHttpInfo($created_at = null, $created_after = null, $created_before = null, $updated_at = null, $updated_after = null, $updated_before = null, $sort = null, $after = null, $limit = null, $archived = null, $property = null, string $contentType = self::contentTypes['getPage'][0])
    {
        $request = $this->getPageRequest($created_at, $created_after, $created_before, $updated_at, $updated_after, $updated_before, $sort, $after, $limit, $archived, $property, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\HubSpot\Client\Cms\Blogs\Authors\Model\CollectionResponseWithTotalBlogAuthorForwardPaging' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Cms\Blogs\Authors\Model\CollectionResponseWithTotalBlogAuthorForwardPaging' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Cms\Blogs\Authors\Model\CollectionResponseWithTotalBlogAuthorForwardPaging', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                default:
                    if ('\HubSpot\Client\Cms\Blogs\Authors\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Cms\Blogs\Authors\Model\Error' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Cms\Blogs\Authors\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\HubSpot\Client\Cms\Blogs\Authors\Model\CollectionResponseWithTotalBlogAuthorForwardPaging';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Cms\Blogs\Authors\Model\CollectionResponseWithTotalBlogAuthorForwardPaging',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Cms\Blogs\Authors\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getPageAsync
     *
     * Get all Blog Authors
     *
     * @param  \DateTime $created_at Only return Blog Authors created at exactly the specified time. (optional)
     * @param  \DateTime $created_after Only return Blog Authors created after the specified time. (optional)
     * @param  \DateTime $created_before Only return Blog Authors created before the specified time. (optional)
     * @param  \DateTime $updated_at Only return Blog Authors last updated at exactly the specified time. (optional)
     * @param  \DateTime $updated_after Only return Blog Authors last updated after the specified time. (optional)
     * @param  \DateTime $updated_before Only return Blog Authors last updated before the specified time. (optional)
     * @param  string[] $sort Specifies which fields to use for sorting results. Valid fields are &#x60;name&#x60;, &#x60;createdAt&#x60;, &#x60;updatedAt&#x60;, &#x60;createdBy&#x60;, &#x60;updatedBy&#x60;. &#x60;createdAt&#x60; will be used by default. (optional)
     * @param  string $after The cursor token value to get the next set of results. You can get this from the &#x60;paging.next.after&#x60; JSON property of a paged response containing more results. (optional)
     * @param  int $limit The maximum number of results to return. Default is 100. (optional)
     * @param  bool $archived Specifies whether to return deleted Blog Authors. Defaults to &#x60;false&#x60;. (optional)
     * @param  string $property (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPage'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getPageAsync($created_at = null, $created_after = null, $created_before = null, $updated_at = null, $updated_after = null, $updated_before = null, $sort = null, $after = null, $limit = null, $archived = null, $property = null, string $contentType = self::contentTypes['getPage'][0])
    {
        return $this->getPageAsyncWithHttpInfo($created_at, $created_after, $created_before, $updated_at, $updated_after, $updated_before, $sort, $after, $limit, $archived, $property, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getPageAsyncWithHttpInfo
     *
     * Get all Blog Authors
     *
     * @param  \DateTime $created_at Only return Blog Authors created at exactly the specified time. (optional)
     * @param  \DateTime $created_after Only return Blog Authors created after the specified time. (optional)
     * @param  \DateTime $created_before Only return Blog Authors created before the specified time. (optional)
     * @param  \DateTime $updated_at Only return Blog Authors last updated at exactly the specified time. (optional)
     * @param  \DateTime $updated_after Only return Blog Authors last updated after the specified time. (optional)
     * @param  \DateTime $updated_before Only return Blog Authors last updated before the specified time. (optional)
     * @param  string[] $sort Specifies which fields to use for sorting results. Valid fields are &#x60;name&#x60;, &#x60;createdAt&#x60;, &#x60;updatedAt&#x60;, &#x60;createdBy&#x60;, &#x60;updatedBy&#x60;. &#x60;createdAt&#x60; will be used by default. (optional)
     * @param  string $after The cursor token value to get the next set of results. You can get this from the &#x60;paging.next.after&#x60; JSON property of a paged response containing more results. (optional)
     * @param  int $limit The maximum number of results to return. Default is 100. (optional)
     * @param  bool $archived Specifies whether to return deleted Blog Authors. Defaults to &#x60;false&#x60;. (optional)
     * @param  string $property (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPage'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getPageAsyncWithHttpInfo($created_at = null, $created_after = null, $created_before = null, $updated_at = null, $updated_after = null, $updated_before = null, $sort = null, $after = null, $limit = null, $archived = null, $property = null, string $contentType = self::contentTypes['getPage'][0])
    {
        $returnType = '\HubSpot\Client\Cms\Blogs\Authors\Model\CollectionResponseWithTotalBlogAuthorForwardPaging';
        $request = $this->getPageRequest($created_at, $created_after, $created_before, $updated_at, $updated_after, $updated_before, $sort, $after, $limit, $archived, $property, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getPage'
     *
     * @param  \DateTime $created_at Only return Blog Authors created at exactly the specified time. (optional)
     * @param  \DateTime $created_after Only return Blog Authors created after the specified time. (optional)
     * @param  \DateTime $created_before Only return Blog Authors created before the specified time. (optional)
     * @param  \DateTime $updated_at Only return Blog Authors last updated at exactly the specified time. (optional)
     * @param  \DateTime $updated_after Only return Blog Authors last updated after the specified time. (optional)
     * @param  \DateTime $updated_before Only return Blog Authors last updated before the specified time. (optional)
     * @param  string[] $sort Specifies which fields to use for sorting results. Valid fields are &#x60;name&#x60;, &#x60;createdAt&#x60;, &#x60;updatedAt&#x60;, &#x60;createdBy&#x60;, &#x60;updatedBy&#x60;. &#x60;createdAt&#x60; will be used by default. (optional)
     * @param  string $after The cursor token value to get the next set of results. You can get this from the &#x60;paging.next.after&#x60; JSON property of a paged response containing more results. (optional)
     * @param  int $limit The maximum number of results to return. Default is 100. (optional)
     * @param  bool $archived Specifies whether to return deleted Blog Authors. Defaults to &#x60;false&#x60;. (optional)
     * @param  string $property (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPage'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getPageRequest($created_at = null, $created_after = null, $created_before = null, $updated_at = null, $updated_after = null, $updated_before = null, $sort = null, $after = null, $limit = null, $archived = null, $property = null, string $contentType = self::contentTypes['getPage'][0])
    {













        $resourcePath = '/cms/v3/blogs/authors';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $created_at,
            'createdAt', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $created_after,
            'createdAfter', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $created_before,
            'createdBefore', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $updated_at,
            'updatedAt', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $updated_after,
            'updatedAfter', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $updated_before,
            'updatedBefore', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $sort,
            'sort', // param base name
            'array', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $after,
            'after', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $limit,
            'limit', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $archived,
            'archived', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $property,
            'property', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', '*/*', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation readBatch
     *
     * Retrieve a batch of Blog Authors
     *
     * @param  \HubSpot\Client\Cms\Blogs\Authors\Model\BatchInputString $batch_input_string The JSON array of Blog Author ids. (required)
     * @param  bool $archived Specifies whether to return deleted Blog Authors. Defaults to &#x60;false&#x60;. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['readBatch'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Cms\Blogs\Authors\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \HubSpot\Client\Cms\Blogs\Authors\Model\BatchResponseBlogAuthor|\HubSpot\Client\Cms\Blogs\Authors\Model\BatchResponseBlogAuthorWithErrors|\HubSpot\Client\Cms\Blogs\Authors\Model\Error
     */
    public function readBatch($batch_input_string, $archived = null, string $contentType = self::contentTypes['readBatch'][0])
    {
        list($response) = $this->readBatchWithHttpInfo($batch_input_string, $archived, $contentType);
        return $response;
    }

    /**
     * Operation readBatchWithHttpInfo
     *
     * Retrieve a batch of Blog Authors
     *
     * @param  \HubSpot\Client\Cms\Blogs\Authors\Model\BatchInputString $batch_input_string The JSON array of Blog Author ids. (required)
     * @param  bool $archived Specifies whether to return deleted Blog Authors. Defaults to &#x60;false&#x60;. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['readBatch'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Cms\Blogs\Authors\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \HubSpot\Client\Cms\Blogs\Authors\Model\BatchResponseBlogAuthor|\HubSpot\Client\Cms\Blogs\Authors\Model\BatchResponseBlogAuthorWithErrors|\HubSpot\Client\Cms\Blogs\Authors\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function readBatchWithHttpInfo($batch_input_string, $archived = null, string $contentType = self::contentTypes['readBatch'][0])
    {
        $request = $this->readBatchRequest($batch_input_string, $archived, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\HubSpot\Client\Cms\Blogs\Authors\Model\BatchResponseBlogAuthor' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Cms\Blogs\Authors\Model\BatchResponseBlogAuthor' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Cms\Blogs\Authors\Model\BatchResponseBlogAuthor', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 207:
                    if ('\HubSpot\Client\Cms\Blogs\Authors\Model\BatchResponseBlogAuthorWithErrors' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Cms\Blogs\Authors\Model\BatchResponseBlogAuthorWithErrors' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Cms\Blogs\Authors\Model\BatchResponseBlogAuthorWithErrors', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                default:
                    if ('\HubSpot\Client\Cms\Blogs\Authors\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Cms\Blogs\Authors\Model\Error' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Cms\Blogs\Authors\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\HubSpot\Client\Cms\Blogs\Authors\Model\BatchResponseBlogAuthor';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Cms\Blogs\Authors\Model\BatchResponseBlogAuthor',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 207:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Cms\Blogs\Authors\Model\BatchResponseBlogAuthorWithErrors',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Cms\Blogs\Authors\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation readBatchAsync
     *
     * Retrieve a batch of Blog Authors
     *
     * @param  \HubSpot\Client\Cms\Blogs\Authors\Model\BatchInputString $batch_input_string The JSON array of Blog Author ids. (required)
     * @param  bool $archived Specifies whether to return deleted Blog Authors. Defaults to &#x60;false&#x60;. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['readBatch'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function readBatchAsync($batch_input_string, $archived = null, string $contentType = self::contentTypes['readBatch'][0])
    {
        return $this->readBatchAsyncWithHttpInfo($batch_input_string, $archived, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation readBatchAsyncWithHttpInfo
     *
     * Retrieve a batch of Blog Authors
     *
     * @param  \HubSpot\Client\Cms\Blogs\Authors\Model\BatchInputString $batch_input_string The JSON array of Blog Author ids. (required)
     * @param  bool $archived Specifies whether to return deleted Blog Authors. Defaults to &#x60;false&#x60;. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['readBatch'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function readBatchAsyncWithHttpInfo($batch_input_string, $archived = null, string $contentType = self::contentTypes['readBatch'][0])
    {
        $returnType = '\HubSpot\Client\Cms\Blogs\Authors\Model\BatchResponseBlogAuthor';
        $request = $this->readBatchRequest($batch_input_string, $archived, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'readBatch'
     *
     * @param  \HubSpot\Client\Cms\Blogs\Authors\Model\BatchInputString $batch_input_string The JSON array of Blog Author ids. (required)
     * @param  bool $archived Specifies whether to return deleted Blog Authors. Defaults to &#x60;false&#x60;. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['readBatch'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function readBatchRequest($batch_input_string, $archived = null, string $contentType = self::contentTypes['readBatch'][0])
    {

        // verify the required parameter 'batch_input_string' is set
        if ($batch_input_string === null || (is_array($batch_input_string) && count($batch_input_string) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $batch_input_string when calling readBatch'
            );
        }



        $resourcePath = '/cms/v3/blogs/authors/batch/read';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $archived,
            'archived', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', '*/*', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($batch_input_string)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($batch_input_string));
            } else {
                $httpBody = $batch_input_string;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation setLangPrimary
     *
     * Set a new primary language
     *
     * @param  \HubSpot\Client\Cms\Blogs\Authors\Model\SetNewLanguagePrimaryRequestVNext $set_new_language_primary_request_v_next The JSON representation of the SetNewLanguagePrimaryRequest object. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setLangPrimary'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Cms\Blogs\Authors\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function setLangPrimary($set_new_language_primary_request_v_next, string $contentType = self::contentTypes['setLangPrimary'][0])
    {
        $this->setLangPrimaryWithHttpInfo($set_new_language_primary_request_v_next, $contentType);
    }

    /**
     * Operation setLangPrimaryWithHttpInfo
     *
     * Set a new primary language
     *
     * @param  \HubSpot\Client\Cms\Blogs\Authors\Model\SetNewLanguagePrimaryRequestVNext $set_new_language_primary_request_v_next The JSON representation of the SetNewLanguagePrimaryRequest object. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setLangPrimary'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Cms\Blogs\Authors\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function setLangPrimaryWithHttpInfo($set_new_language_primary_request_v_next, string $contentType = self::contentTypes['setLangPrimary'][0])
    {
        $request = $this->setLangPrimaryRequest($set_new_language_primary_request_v_next, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Cms\Blogs\Authors\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation setLangPrimaryAsync
     *
     * Set a new primary language
     *
     * @param  \HubSpot\Client\Cms\Blogs\Authors\Model\SetNewLanguagePrimaryRequestVNext $set_new_language_primary_request_v_next The JSON representation of the SetNewLanguagePrimaryRequest object. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setLangPrimary'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function setLangPrimaryAsync($set_new_language_primary_request_v_next, string $contentType = self::contentTypes['setLangPrimary'][0])
    {
        return $this->setLangPrimaryAsyncWithHttpInfo($set_new_language_primary_request_v_next, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation setLangPrimaryAsyncWithHttpInfo
     *
     * Set a new primary language
     *
     * @param  \HubSpot\Client\Cms\Blogs\Authors\Model\SetNewLanguagePrimaryRequestVNext $set_new_language_primary_request_v_next The JSON representation of the SetNewLanguagePrimaryRequest object. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setLangPrimary'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function setLangPrimaryAsyncWithHttpInfo($set_new_language_primary_request_v_next, string $contentType = self::contentTypes['setLangPrimary'][0])
    {
        $returnType = '';
        $request = $this->setLangPrimaryRequest($set_new_language_primary_request_v_next, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'setLangPrimary'
     *
     * @param  \HubSpot\Client\Cms\Blogs\Authors\Model\SetNewLanguagePrimaryRequestVNext $set_new_language_primary_request_v_next The JSON representation of the SetNewLanguagePrimaryRequest object. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setLangPrimary'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function setLangPrimaryRequest($set_new_language_primary_request_v_next, string $contentType = self::contentTypes['setLangPrimary'][0])
    {

        // verify the required parameter 'set_new_language_primary_request_v_next' is set
        if ($set_new_language_primary_request_v_next === null || (is_array($set_new_language_primary_request_v_next) && count($set_new_language_primary_request_v_next) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $set_new_language_primary_request_v_next when calling setLangPrimary'
            );
        }


        $resourcePath = '/cms/v3/blogs/authors/multi-language/set-new-lang-primary';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['*/*', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($set_new_language_primary_request_v_next)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($set_new_language_primary_request_v_next));
            } else {
                $httpBody = $set_new_language_primary_request_v_next;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation update
     *
     * Update a Blog Author
     *
     * @param  string $object_id The Blog Author id. (required)
     * @param  \HubSpot\Client\Cms\Blogs\Authors\Model\BlogAuthor $blog_author The JSON representation of the updated Blog Author. (required)
     * @param  bool $archived Specifies whether to update deleted Blog Authors. Defaults to &#x60;false&#x60;. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['update'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Cms\Blogs\Authors\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \HubSpot\Client\Cms\Blogs\Authors\Model\BlogAuthor|\HubSpot\Client\Cms\Blogs\Authors\Model\Error
     */
    public function update($object_id, $blog_author, $archived = null, string $contentType = self::contentTypes['update'][0])
    {
        list($response) = $this->updateWithHttpInfo($object_id, $blog_author, $archived, $contentType);
        return $response;
    }

    /**
     * Operation updateWithHttpInfo
     *
     * Update a Blog Author
     *
     * @param  string $object_id The Blog Author id. (required)
     * @param  \HubSpot\Client\Cms\Blogs\Authors\Model\BlogAuthor $blog_author The JSON representation of the updated Blog Author. (required)
     * @param  bool $archived Specifies whether to update deleted Blog Authors. Defaults to &#x60;false&#x60;. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['update'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Cms\Blogs\Authors\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \HubSpot\Client\Cms\Blogs\Authors\Model\BlogAuthor|\HubSpot\Client\Cms\Blogs\Authors\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateWithHttpInfo($object_id, $blog_author, $archived = null, string $contentType = self::contentTypes['update'][0])
    {
        $request = $this->updateRequest($object_id, $blog_author, $archived, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\HubSpot\Client\Cms\Blogs\Authors\Model\BlogAuthor' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Cms\Blogs\Authors\Model\BlogAuthor' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Cms\Blogs\Authors\Model\BlogAuthor', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                default:
                    if ('\HubSpot\Client\Cms\Blogs\Authors\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Cms\Blogs\Authors\Model\Error' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Cms\Blogs\Authors\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\HubSpot\Client\Cms\Blogs\Authors\Model\BlogAuthor';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Cms\Blogs\Authors\Model\BlogAuthor',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Cms\Blogs\Authors\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation updateAsync
     *
     * Update a Blog Author
     *
     * @param  string $object_id The Blog Author id. (required)
     * @param  \HubSpot\Client\Cms\Blogs\Authors\Model\BlogAuthor $blog_author The JSON representation of the updated Blog Author. (required)
     * @param  bool $archived Specifies whether to update deleted Blog Authors. Defaults to &#x60;false&#x60;. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['update'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateAsync($object_id, $blog_author, $archived = null, string $contentType = self::contentTypes['update'][0])
    {
        return $this->updateAsyncWithHttpInfo($object_id, $blog_author, $archived, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updateAsyncWithHttpInfo
     *
     * Update a Blog Author
     *
     * @param  string $object_id The Blog Author id. (required)
     * @param  \HubSpot\Client\Cms\Blogs\Authors\Model\BlogAuthor $blog_author The JSON representation of the updated Blog Author. (required)
     * @param  bool $archived Specifies whether to update deleted Blog Authors. Defaults to &#x60;false&#x60;. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['update'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateAsyncWithHttpInfo($object_id, $blog_author, $archived = null, string $contentType = self::contentTypes['update'][0])
    {
        $returnType = '\HubSpot\Client\Cms\Blogs\Authors\Model\BlogAuthor';
        $request = $this->updateRequest($object_id, $blog_author, $archived, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'update'
     *
     * @param  string $object_id The Blog Author id. (required)
     * @param  \HubSpot\Client\Cms\Blogs\Authors\Model\BlogAuthor $blog_author The JSON representation of the updated Blog Author. (required)
     * @param  bool $archived Specifies whether to update deleted Blog Authors. Defaults to &#x60;false&#x60;. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['update'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function updateRequest($object_id, $blog_author, $archived = null, string $contentType = self::contentTypes['update'][0])
    {

        // verify the required parameter 'object_id' is set
        if ($object_id === null || (is_array($object_id) && count($object_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $object_id when calling update'
            );
        }

        // verify the required parameter 'blog_author' is set
        if ($blog_author === null || (is_array($blog_author) && count($blog_author) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $blog_author when calling update'
            );
        }



        $resourcePath = '/cms/v3/blogs/authors/{objectId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $archived,
            'archived', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);


        // path params
        if ($object_id !== null) {
            $resourcePath = str_replace(
                '{' . 'objectId' . '}',
                ObjectSerializer::toPathValue($object_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', '*/*', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($blog_author)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($blog_author));
            } else {
                $httpBody = $blog_author;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PATCH',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateBatch
     *
     * Update a batch of Blog Authors
     *
     * @param  \HubSpot\Client\Cms\Blogs\Authors\Model\BatchInputJsonNode $batch_input_json_node A JSON array of the JSON representations of the updated Blog Authors. (required)
     * @param  bool $archived Specifies whether to update deleted Blog Authors. Defaults to &#x60;false&#x60;. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateBatch'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Cms\Blogs\Authors\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \HubSpot\Client\Cms\Blogs\Authors\Model\BatchResponseBlogAuthor|\HubSpot\Client\Cms\Blogs\Authors\Model\BatchResponseBlogAuthorWithErrors|\HubSpot\Client\Cms\Blogs\Authors\Model\Error
     */
    public function updateBatch($batch_input_json_node, $archived = null, string $contentType = self::contentTypes['updateBatch'][0])
    {
        list($response) = $this->updateBatchWithHttpInfo($batch_input_json_node, $archived, $contentType);
        return $response;
    }

    /**
     * Operation updateBatchWithHttpInfo
     *
     * Update a batch of Blog Authors
     *
     * @param  \HubSpot\Client\Cms\Blogs\Authors\Model\BatchInputJsonNode $batch_input_json_node A JSON array of the JSON representations of the updated Blog Authors. (required)
     * @param  bool $archived Specifies whether to update deleted Blog Authors. Defaults to &#x60;false&#x60;. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateBatch'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Cms\Blogs\Authors\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \HubSpot\Client\Cms\Blogs\Authors\Model\BatchResponseBlogAuthor|\HubSpot\Client\Cms\Blogs\Authors\Model\BatchResponseBlogAuthorWithErrors|\HubSpot\Client\Cms\Blogs\Authors\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateBatchWithHttpInfo($batch_input_json_node, $archived = null, string $contentType = self::contentTypes['updateBatch'][0])
    {
        $request = $this->updateBatchRequest($batch_input_json_node, $archived, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\HubSpot\Client\Cms\Blogs\Authors\Model\BatchResponseBlogAuthor' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Cms\Blogs\Authors\Model\BatchResponseBlogAuthor' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Cms\Blogs\Authors\Model\BatchResponseBlogAuthor', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 207:
                    if ('\HubSpot\Client\Cms\Blogs\Authors\Model\BatchResponseBlogAuthorWithErrors' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Cms\Blogs\Authors\Model\BatchResponseBlogAuthorWithErrors' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Cms\Blogs\Authors\Model\BatchResponseBlogAuthorWithErrors', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                default:
                    if ('\HubSpot\Client\Cms\Blogs\Authors\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Cms\Blogs\Authors\Model\Error' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Cms\Blogs\Authors\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\HubSpot\Client\Cms\Blogs\Authors\Model\BatchResponseBlogAuthor';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Cms\Blogs\Authors\Model\BatchResponseBlogAuthor',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 207:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Cms\Blogs\Authors\Model\BatchResponseBlogAuthorWithErrors',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Cms\Blogs\Authors\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation updateBatchAsync
     *
     * Update a batch of Blog Authors
     *
     * @param  \HubSpot\Client\Cms\Blogs\Authors\Model\BatchInputJsonNode $batch_input_json_node A JSON array of the JSON representations of the updated Blog Authors. (required)
     * @param  bool $archived Specifies whether to update deleted Blog Authors. Defaults to &#x60;false&#x60;. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateBatch'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateBatchAsync($batch_input_json_node, $archived = null, string $contentType = self::contentTypes['updateBatch'][0])
    {
        return $this->updateBatchAsyncWithHttpInfo($batch_input_json_node, $archived, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updateBatchAsyncWithHttpInfo
     *
     * Update a batch of Blog Authors
     *
     * @param  \HubSpot\Client\Cms\Blogs\Authors\Model\BatchInputJsonNode $batch_input_json_node A JSON array of the JSON representations of the updated Blog Authors. (required)
     * @param  bool $archived Specifies whether to update deleted Blog Authors. Defaults to &#x60;false&#x60;. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateBatch'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateBatchAsyncWithHttpInfo($batch_input_json_node, $archived = null, string $contentType = self::contentTypes['updateBatch'][0])
    {
        $returnType = '\HubSpot\Client\Cms\Blogs\Authors\Model\BatchResponseBlogAuthor';
        $request = $this->updateBatchRequest($batch_input_json_node, $archived, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateBatch'
     *
     * @param  \HubSpot\Client\Cms\Blogs\Authors\Model\BatchInputJsonNode $batch_input_json_node A JSON array of the JSON representations of the updated Blog Authors. (required)
     * @param  bool $archived Specifies whether to update deleted Blog Authors. Defaults to &#x60;false&#x60;. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateBatch'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function updateBatchRequest($batch_input_json_node, $archived = null, string $contentType = self::contentTypes['updateBatch'][0])
    {

        // verify the required parameter 'batch_input_json_node' is set
        if ($batch_input_json_node === null || (is_array($batch_input_json_node) && count($batch_input_json_node) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $batch_input_json_node when calling updateBatch'
            );
        }



        $resourcePath = '/cms/v3/blogs/authors/batch/update';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $archived,
            'archived', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', '*/*', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($batch_input_json_node)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($batch_input_json_node));
            } else {
                $httpBody = $batch_input_json_node;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateLangs
     *
     * Update languages of multi-language group
     *
     * @param  \HubSpot\Client\Cms\Blogs\Authors\Model\UpdateLanguagesRequestVNext $update_languages_request_v_next The JSON representation of the UpdateLanguagesRequest object. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateLangs'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Cms\Blogs\Authors\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function updateLangs($update_languages_request_v_next, string $contentType = self::contentTypes['updateLangs'][0])
    {
        $this->updateLangsWithHttpInfo($update_languages_request_v_next, $contentType);
    }

    /**
     * Operation updateLangsWithHttpInfo
     *
     * Update languages of multi-language group
     *
     * @param  \HubSpot\Client\Cms\Blogs\Authors\Model\UpdateLanguagesRequestVNext $update_languages_request_v_next The JSON representation of the UpdateLanguagesRequest object. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateLangs'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Cms\Blogs\Authors\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateLangsWithHttpInfo($update_languages_request_v_next, string $contentType = self::contentTypes['updateLangs'][0])
    {
        $request = $this->updateLangsRequest($update_languages_request_v_next, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Cms\Blogs\Authors\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation updateLangsAsync
     *
     * Update languages of multi-language group
     *
     * @param  \HubSpot\Client\Cms\Blogs\Authors\Model\UpdateLanguagesRequestVNext $update_languages_request_v_next The JSON representation of the UpdateLanguagesRequest object. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateLangs'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateLangsAsync($update_languages_request_v_next, string $contentType = self::contentTypes['updateLangs'][0])
    {
        return $this->updateLangsAsyncWithHttpInfo($update_languages_request_v_next, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updateLangsAsyncWithHttpInfo
     *
     * Update languages of multi-language group
     *
     * @param  \HubSpot\Client\Cms\Blogs\Authors\Model\UpdateLanguagesRequestVNext $update_languages_request_v_next The JSON representation of the UpdateLanguagesRequest object. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateLangs'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateLangsAsyncWithHttpInfo($update_languages_request_v_next, string $contentType = self::contentTypes['updateLangs'][0])
    {
        $returnType = '';
        $request = $this->updateLangsRequest($update_languages_request_v_next, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateLangs'
     *
     * @param  \HubSpot\Client\Cms\Blogs\Authors\Model\UpdateLanguagesRequestVNext $update_languages_request_v_next The JSON representation of the UpdateLanguagesRequest object. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateLangs'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function updateLangsRequest($update_languages_request_v_next, string $contentType = self::contentTypes['updateLangs'][0])
    {

        // verify the required parameter 'update_languages_request_v_next' is set
        if ($update_languages_request_v_next === null || (is_array($update_languages_request_v_next) && count($update_languages_request_v_next) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $update_languages_request_v_next when calling updateLangs'
            );
        }


        $resourcePath = '/cms/v3/blogs/authors/multi-language/update-languages';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['*/*', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($update_languages_request_v_next)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($update_languages_request_v_next));
            } else {
                $httpBody = $update_languages_request_v_next;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
